// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = (typeof Module !== 'undefined' ? Module : null) || {};

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = typeof window === 'object';
// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  if (!Module['print']) Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  if (!Module['printErr']) Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };

  Module['readBinary'] = function readBinary(filename) {
    var ret = Module['read'](filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };

  Module['load'] = function load(f) {
    globalEval(read(f));
  };

  if (!Module['thisProgram']) {
    if (process['argv'].length > 1) {
      Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
    } else {
      Module['thisProgram'] = 'unknown-program';
    }
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
}
else if (ENVIRONMENT_IS_SHELL) {
  if (!Module['print']) Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }

  Module['readBinary'] = function readBinary(f) {
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    var data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof console !== 'undefined') {
    if (!Module['print']) Module['print'] = function print(x) {
      console.log(x);
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  if (ENVIRONMENT_IS_WORKER) {
    Module['load'] = importScripts;
  }

  if (typeof Module['setWindowTitle'] === 'undefined') {
    Module['setWindowTitle'] = function(title) { document.title = title };
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
if (!Module['thisProgram']) {
  Module['thisProgram'] = './this.program';
}

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in: 
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at: 
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  setTempRet0: function (value) {
    tempRet0 = value;
  },
  getTempRet0: function () {
    return tempRet0;
  },
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  STACK_ALIGN: 16,
  prepVararg: function (ptr, type) {
    if (type === 'double' || type === 'i64') {
      // move so the load is aligned
      if (ptr & 7) {
        assert((ptr & 7) === 4);
        ptr += 4;
      }
    } else {
      assert((ptr & 3) === 0);
    }
    return ptr;
  },
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (!vararg && (type == 'i64' || type == 'double')) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      assert(args.length == sig.length-1);
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      assert(sig.length == 1);
      assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[sig]) {
      Runtime.funcWrappers[sig] = {};
    }
    var sigCache = Runtime.funcWrappers[sig];
    if (!sigCache[func]) {
      sigCache[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return sigCache[func];
  },
  getCompilerSetting: function (name) {
    throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+15)&-16);(assert((((STACKTOP|0) < (STACK_MAX|0))|0))|0); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + (assert(!staticSealed),size))|0;STATICTOP = (((STATICTOP)+15)&-16); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + (assert(DYNAMICTOP > 0),size))|0;DYNAMICTOP = (((DYNAMICTOP)+15)&-16); if (DYNAMICTOP >= TOTAL_MEMORY) { var success = enlargeMemory(); if (!success) { DYNAMICTOP = ret;  return 0; } }; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 16))*(quantum ? quantum : 16); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*4294967296.0)) : ((+((low>>>0)))+((+((high|0)))*4294967296.0))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}



Module["Runtime"] = Runtime;



//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  if (!func) {
    try {
      func = eval('_' + ident); // explicit lookup
    } catch(e) {}
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

var cwrap, ccall;
(function(){
  var JSfuncs = {
    // Helpers for cwrap -- it can't refer to Runtime directly because it might
    // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
    // out what the minified function name is.
    'stackSave': function() {
      Runtime.stackSave()
    },
    'stackRestore': function() {
      Runtime.stackRestore()
    },
    // type conversion from js to c
    'arrayToC' : function(arr) {
      var ret = Runtime.stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    },
    'stringToC' : function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        ret = Runtime.stackAlloc((str.length << 2) + 1);
        writeStringToMemory(str, ret);
      }
      return ret;
    }
  };
  // For fast lookup of conversion functions
  var toC = {'string' : JSfuncs['stringToC'], 'array' : JSfuncs['arrayToC']};

  // C calling interface. 
  ccall = function ccallFunc(ident, returnType, argTypes, args, opts) {
    var func = getCFunc(ident);
    var cArgs = [];
    var stack = 0;
    assert(returnType !== 'array', 'Return type should not be "array".');
    if (args) {
      for (var i = 0; i < args.length; i++) {
        var converter = toC[argTypes[i]];
        if (converter) {
          if (stack === 0) stack = Runtime.stackSave();
          cArgs[i] = converter(args[i]);
        } else {
          cArgs[i] = args[i];
        }
      }
    }
    var ret = func.apply(null, cArgs);
    if ((!opts || !opts.async) && typeof EmterpreterAsync === 'object') {
      assert(!EmterpreterAsync.state, 'cannot start async op with normal JS calling ccall');
    }
    if (opts && opts.async) assert(!returnType, 'async ccalls cannot return values');
    if (returnType === 'string') ret = Pointer_stringify(ret);
    if (stack !== 0) {
      if (opts && opts.async) {
        EmterpreterAsync.asyncFinalizers.push(function() {
          Runtime.stackRestore(stack);
        });
        return;
      }
      Runtime.stackRestore(stack);
    }
    return ret;
  }

  var sourceRegex = /^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;
  function parseJSFunc(jsfunc) {
    // Match the body and the return value of a javascript function source
    var parsed = jsfunc.toString().match(sourceRegex).slice(1);
    return {arguments : parsed[0], body : parsed[1], returnValue: parsed[2]}
  }
  var JSsource = {};
  for (var fun in JSfuncs) {
    if (JSfuncs.hasOwnProperty(fun)) {
      // Elements of toCsource are arrays of three items:
      // the code, and the return value
      JSsource[fun] = parseJSFunc(JSfuncs[fun]);
    }
  }

  
  cwrap = function cwrap(ident, returnType, argTypes) {
    argTypes = argTypes || [];
    var cfunc = getCFunc(ident);
    // When the function takes numbers and returns a number, we can just return
    // the original function
    var numericArgs = argTypes.every(function(type){ return type === 'number'});
    var numericRet = (returnType !== 'string');
    if ( numericRet && numericArgs) {
      return cfunc;
    }
    // Creation of the arguments list (["$1","$2",...,"$nargs"])
    var argNames = argTypes.map(function(x,i){return '$'+i});
    var funcstr = "(function(" + argNames.join(',') + ") {";
    var nargs = argTypes.length;
    if (!numericArgs) {
      // Generate the code needed to convert the arguments from javascript
      // values to pointers
      funcstr += 'var stack = ' + JSsource['stackSave'].body + ';';
      for (var i = 0; i < nargs; i++) {
        var arg = argNames[i], type = argTypes[i];
        if (type === 'number') continue;
        var convertCode = JSsource[type + 'ToC']; // [code, return]
        funcstr += 'var ' + convertCode.arguments + ' = ' + arg + ';';
        funcstr += convertCode.body + ';';
        funcstr += arg + '=' + convertCode.returnValue + ';';
      }
    }

    // When the code is compressed, the name of cfunc is not literally 'cfunc' anymore
    var cfuncname = parseJSFunc(function(){return cfunc}).returnValue;
    // Call the function
    funcstr += 'var ret = ' + cfuncname + '(' + argNames.join(',') + ');';
    if (!numericRet) { // Return type can only by 'string' or 'number'
      // Convert the result to a string
      var strgfy = parseJSFunc(function(){return Pointer_stringify}).returnValue;
      funcstr += 'ret = ' + strgfy + '(ret);';
    }
    funcstr += "if (typeof EmterpreterAsync === 'object') { assert(!EmterpreterAsync.state, 'cannot start async op with normal JS calling cwrap') }";
    if (!numericArgs) {
      // If we had a stack, restore it
      funcstr += JSsource['stackRestore'].body.replace('()', '(stack)') + ';';
    }
    funcstr += 'return ret})';
    return eval(funcstr);
  };
})();
Module["ccall"] = ccall;
Module["cwrap"] = cwrap;

function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module["setValue"] = setValue;


function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module["getValue"] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module["ALLOC_NORMAL"] = ALLOC_NORMAL;
Module["ALLOC_STACK"] = ALLOC_STACK;
Module["ALLOC_STATIC"] = ALLOC_STATIC;
Module["ALLOC_DYNAMIC"] = ALLOC_DYNAMIC;
Module["ALLOC_NONE"] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    assert(type, 'Must know what type to store in allocate!');

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}
Module["allocate"] = allocate;

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return Runtime.staticAlloc(size);
  if ((typeof _sbrk !== 'undefined' && !_sbrk.called) || !runtimeInitialized) return Runtime.dynamicAlloc(size);
  return _malloc(size);
}
Module["getMemory"] = getMemory;

function Pointer_stringify(ptr, /* optional */ length) {
  if (length === 0 || !ptr) return '';
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    assert(ptr + i < TOTAL_MEMORY);
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return Module['UTF8ToString'](ptr);
}
Module["Pointer_stringify"] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}
Module["AsciiToString"] = AsciiToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}
Module["stringToAscii"] = stringToAscii;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

function UTF8ArrayToString(u8Array, idx) {
  var u0, u1, u2, u3, u4, u5;

  var str = '';
  while (1) {
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    u0 = u8Array[idx++];
    if (!u0) return str;
    if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
    u1 = u8Array[idx++] & 63;
    if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
    u2 = u8Array[idx++] & 63;
    if ((u0 & 0xF0) == 0xE0) {
      u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
    } else {
      u3 = u8Array[idx++] & 63;
      if ((u0 & 0xF8) == 0xF0) {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
      } else {
        u4 = u8Array[idx++] & 63;
        if ((u0 & 0xFC) == 0xF8) {
          u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
        } else {
          u5 = u8Array[idx++] & 63;
          u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
        }
      }
    }
    if (u0 < 0x10000) {
      str += String.fromCharCode(u0);
    } else {
      var ch = u0 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    }
  }
}
Module["UTF8ArrayToString"] = UTF8ArrayToString;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8,ptr);
}
Module["UTF8ToString"] = UTF8ToString;

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}
Module["stringToUTF8Array"] = stringToUTF8Array;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}
Module["stringToUTF8"] = stringToUTF8;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}
Module["lengthBytesUTF8"] = lengthBytesUTF8;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF16ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module["UTF16ToString"] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF16"] = stringToUTF16;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}
Module["lengthBytesUTF16"] = lengthBytesUTF16;

function UTF32ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module["UTF32ToString"] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF32"] = stringToUTF32;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}
Module["lengthBytesUTF32"] = lengthBytesUTF32;

function demangle(func) {
  var hasLibcxxabi = !!Module['___cxa_demangle'];
  if (hasLibcxxabi) {
    try {
      var buf = _malloc(func.length);
      writeStringToMemory(func.substr(1), buf);
      var status = _malloc(4);
      var ret = Module['___cxa_demangle'](buf, 0, 0, status);
      if (getValue(status, 'i32') === 0 && ret) {
        return Pointer_stringify(ret);
      }
      // otherwise, libcxxabi failed, we can try ours which may return a partial result
    } catch(e) {
      // failure when using libcxxabi, we can try ours which may return a partial result
    } finally {
      if (buf) _free(buf);
      if (status) _free(status);
      if (ret) _free(ret);
    }
  }
  var i = 3;
  // params, etc.
  var basicTypes = {
    'v': 'void',
    'b': 'bool',
    'c': 'char',
    's': 'short',
    'i': 'int',
    'l': 'long',
    'f': 'float',
    'd': 'double',
    'w': 'wchar_t',
    'a': 'signed char',
    'h': 'unsigned char',
    't': 'unsigned short',
    'j': 'unsigned int',
    'm': 'unsigned long',
    'x': 'long long',
    'y': 'unsigned long long',
    'z': '...'
  };
  var subs = [];
  var first = true;
  function dump(x) {
    //return;
    if (x) Module.print(x);
    Module.print(func);
    var pre = '';
    for (var a = 0; a < i; a++) pre += ' ';
    Module.print (pre + '^');
  }
  function parseNested() {
    i++;
    if (func[i] === 'K') i++; // ignore const
    var parts = [];
    while (func[i] !== 'E') {
      if (func[i] === 'S') { // substitution
        i++;
        var next = func.indexOf('_', i);
        var num = func.substring(i, next) || 0;
        parts.push(subs[num] || '?');
        i = next+1;
        continue;
      }
      if (func[i] === 'C') { // constructor
        parts.push(parts[parts.length-1]);
        i += 2;
        continue;
      }
      var size = parseInt(func.substr(i));
      var pre = size.toString().length;
      if (!size || !pre) { i--; break; } // counter i++ below us
      var curr = func.substr(i + pre, size);
      parts.push(curr);
      subs.push(curr);
      i += pre + size;
    }
    i++; // skip E
    return parts;
  }
  function parse(rawList, limit, allowVoid) { // main parser
    limit = limit || Infinity;
    var ret = '', list = [];
    function flushList() {
      return '(' + list.join(', ') + ')';
    }
    var name;
    if (func[i] === 'N') {
      // namespaced N-E
      name = parseNested().join('::');
      limit--;
      if (limit === 0) return rawList ? [name] : name;
    } else {
      // not namespaced
      if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
      var size = parseInt(func.substr(i));
      if (size) {
        var pre = size.toString().length;
        name = func.substr(i + pre, size);
        i += pre + size;
      }
    }
    first = false;
    if (func[i] === 'I') {
      i++;
      var iList = parse(true);
      var iRet = parse(true, 1, true);
      ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
    } else {
      ret = name;
    }
    paramLoop: while (i < func.length && limit-- > 0) {
      //dump('paramLoop');
      var c = func[i++];
      if (c in basicTypes) {
        list.push(basicTypes[c]);
      } else {
        switch (c) {
          case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
          case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
          case 'L': { // literal
            i++; // skip basic type
            var end = func.indexOf('E', i);
            var size = end - i;
            list.push(func.substr(i, size));
            i += size + 2; // size + 'EE'
            break;
          }
          case 'A': { // array
            var size = parseInt(func.substr(i));
            i += size.toString().length;
            if (func[i] !== '_') throw '?';
            i++; // skip _
            list.push(parse(true, 1, true)[0] + ' [' + size + ']');
            break;
          }
          case 'E': break paramLoop;
          default: ret += '?' + c; break paramLoop;
        }
      }
    }
    if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
    if (rawList) {
      if (ret) {
        list.push(ret + '?');
      }
      return list;
    } else {
      return ret + flushList();
    }
  }
  var parsed = func;
  try {
    // Special-case the entry point, since its name differs from other name mangling.
    if (func == 'Object._main' || func == '_main') {
      return 'main()';
    }
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    parsed = parse();
  } catch(e) {
    parsed += '?';
  }
  if (parsed.indexOf('?') >= 0 && !hasLibcxxabi) {
    Runtime.warnOnce('warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
  }
  return parsed;
}

function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  return demangleAll(jsStackTrace());
}
Module["stackTrace"] = stackTrace;

// Memory management

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
  if (x % 4096 > 0) {
    x += (4096 - (x % 4096));
  }
  return x;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk


function abortOnCannotGrowMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ');
}

function enlargeMemory() {
  abortOnCannotGrowMemory();
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;

var totalMemory = 64*1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
if (totalMemory !== TOTAL_MEMORY) {
  Module.printErr('increasing TOTAL_MEMORY to ' + totalMemory + ' to be compliant with the asm.js spec (and given that TOTAL_STACK=' + TOTAL_STACK + ')');
  TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'JS engine does not provide full typed array support');

var buffer;



buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);


// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['buffer'] = buffer;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module["addOnPreRun"] = addOnPreRun;

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module["addOnInit"] = addOnInit;

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module["addOnPreMain"] = addOnPreMain;

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module["addOnExit"] = addOnExit;

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module["addOnPostRun"] = addOnPostRun;

// Tools


function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}
Module["intArrayFromString"] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module["intArrayToString"] = intArrayToString;

function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))>>0)]=chr;
    i = i + 1;
  }
}
Module["writeStringToMemory"] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[((buffer++)>>0)]=array[i];
  }
}
Module["writeArrayToMemory"] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    assert(str.charCodeAt(i) === str.charCodeAt(i)&0xff);
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}
Module["writeAsciiToMemory"] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}


// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


if (!Math['clz32']) Math['clz32'] = function(x) {
  x = x >>> 0;
  for (var i = 0; i < 32; i++) {
    if (x & (1 << (31 - i))) return i;
  }
  return 32;
};
Math.clz32 = Math['clz32']

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
var runDependencyTracking = {};

function getUniqueRunDependency(id) {
  var orig = id;
  while (1) {
    if (!runDependencyTracking[id]) return id;
    id = orig + Math.random();
  }
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        if (ABORT) {
          clearInterval(runDependencyWatcher);
          runDependencyWatcher = null;
          return;
        }
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 10000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module["addRunDependency"] = addRunDependency;

function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module["removeRunDependency"] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;



// === Body ===

var ASM_CONSTS = [];




STATIC_BASE = 8;

STATICTOP = STATIC_BASE + 453040;
  /* global initializers */  __ATINIT__.push();
  

/* memory initializer */ allocate([0,0,0,0,255,255,255,255,0,0,0,0,1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate([1,0,0,0,1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+1660);
/* memory initializer */ allocate([150,48,7,119,44,97,14,238,186,81,9,153,25,196,109,7,143,244,106,112,53,165,99,233,163,149,100,158,50,136,219,14,164,184,220,121,30,233,213,224,136,217,210,151,43,76,182,9,189,124,177,126,7,45,184,231,145,29,191,144,100,16,183,29,242,32,176,106,72,113,185,243,222,65,190,132,125,212,218,26,235,228,221,109,81,181,212,244,199,133,211,131,86,152,108,19,192,168,107,100,122,249,98,253,236,201,101,138,79,92,1,20,217,108,6,99,99,61,15,250,245,13,8,141,200,32,110,59,94,16,105,76,228,65,96,213,114,113,103,162,209,228,3,60,71,212,4,75,253,133,13,210,107,181,10,165,250,168,181,53,108,152,178,66,214,201,187,219,64,249,188,172,227,108,216,50,117,92,223,69,207,13,214,220,89,61,209,171,172,48,217,38,58,0,222,81,128,81,215,200,22,97,208,191,181,244,180,33,35,196,179,86,153,149,186,207,15,165,189,184,158,184,2,40,8,136,5,95,178,217,12,198,36,233,11,177,135,124,111,47,17,76,104,88,171,29,97,193,61,45,102,182,144,65,220,118,6,113,219,1,188,32,210,152,42,16,213,239,137,133,177,113,31,181,182,6,165,228,191,159,51,212,184,232,162,201,7,120,52,249,0,15,142,168,9,150,24,152,14,225,187,13,106,127,45,61,109,8,151,108,100,145,1,92,99,230,244,81,107,107,98,97,108,28,216,48,101,133,78,0,98,242,237,149,6,108,123,165,1,27,193,244,8,130,87,196,15,245,198,217,176,101,80,233,183,18,234,184,190,139,124,136,185,252,223,29,221,98,73,45,218,21,243,124,211,140,101,76,212,251,88,97,178,77,206,81,181,58,116,0,188,163,226,48,187,212,65,165,223,74,215,149,216,61,109,196,209,164,251,244,214,211,106,233,105,67,252,217,110,52,70,136,103,173,208,184,96,218,115,45,4,68,229,29,3,51,95,76,10,170,201,124,13,221,60,113,5,80,170,65,2,39,16,16,11,190,134,32,12,201,37,181,104,87,179,133,111,32,9,212,102,185,159,228,97,206,14,249,222,94,152,201,217,41,34,152,208,176,180,168,215,199,23,61,179,89,129,13,180,46,59,92,189,183,173,108,186,192,32,131,184,237,182,179,191,154,12,226,182,3,154,210,177,116,57,71,213,234,175,119,210,157,21,38,219,4,131,22,220,115,18,11,99,227,132,59,100,148,62,106,109,13,168,90,106,122,11,207,14,228,157,255,9,147,39,174,0,10,177,158,7,125,68,147,15,240,210,163,8,135,104,242,1,30,254,194,6,105,93,87,98,247,203,103,101,128,113,54,108,25,231,6,107,110,118,27,212,254,224,43,211,137,90,122,218,16,204,74,221,103,111,223,185,249,249,239,190,142,67,190,183,23,213,142,176,96,232,163,214,214,126,147,209,161,196,194,216,56,82,242,223,79,241,103,187,209,103,87,188,166,221,6,181,63,75,54,178,72,218,43,13,216,76,27,10,175,246,74,3,54,96,122,4,65,195,239,96,223,85,223,103,168,239,142,110,49,121,190,105,70,140,179,97,203,26,131,102,188,160,210,111,37,54,226,104,82,149,119,12,204,3,71,11,187,185,22,2,34,47,38,5,85,190,59,186,197,40,11,189,178,146,90,180,43,4,106,179,92,167,255,215,194,49,207,208,181,139,158,217,44,29,174,222,91,176,194,100,155,38,242,99,236,156,163,106,117,10,147,109,2,169,6,9,156,63,54,14,235,133,103,7,114,19,87,0,5,130,74,191,149,20,122,184,226,174,43,177,123,56,27,182,12,155,142,210,146,13,190,213,229,183,239,220,124,33,223,219,11,212,210,211,134,66,226,212,241,248,179,221,104,110,131,218,31,205,22,190,129,91,38,185,246,225,119,176,111,119,71,183,24,230,90,8,136,112,106,15,255,202,59,6,102,92,11,1,17,255,158,101,143,105,174,98,248,211,255,107,97,69,207,108,22,120,226,10,160,238,210,13,215,84,131,4,78,194,179,3,57,97,38,103,167,247,22,96,208,77,71,105,73,219,119,110,62,74,106,209,174,220,90,214,217,102,11,223,64,240,59,216,55,83,174,188,169,197,158,187,222,127,207,178,71,233,255,181,48,28,242,189,189,138,194,186,202,48,147,179,83,166,163,180,36,5,54,208,186,147,6,215,205,41,87,222,84,191,103,217,35,46,122,102,179,184,74,97,196,2,27,104,93,148,43,111,42,55,190,11,180,161,142,12,195,27,223,5,90,141,239,2,45], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+2952);
/* memory initializer */ allocate([1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+10624);
/* memory initializer */ allocate([1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,0,0,3,4,0,0,26,32,0,0,83,4,0,0,30,32,0,0,38,32,0,0,32,32,0,0,33,32,0,0,172,32,0,0,48,32,0,0,9,4,0,0,57,32,0,0,10,4,0,0,12,4,0,0,11,4,0,0,15,4,0,0,82,4,0,0,24,32,0,0,25,32,0,0,28,32,0,0,29,32,0,0,34,32,0,0,19,32,0,0,20,32,0,0,32,0,0,0,34,33,0,0,89,4,0,0,58,32,0,0,90,4,0,0,92,4,0,0,91,4,0,0,95,4,0,0,160,0,0,0,14,4,0,0,94,4,0,0,8,4,0,0,164,0,0,0,144,4,0,0,166,0,0,0,167,0,0,0,1,4,0,0,169,0,0,0,4,4,0,0,171,0,0,0,172,0,0,0,173,0,0,0,174,0,0,0,7,4,0,0,176,0,0,0,177,0,0,0,6,4,0,0,86,4,0,0,145,4,0,0,181,0,0,0,182,0,0,0,183,0,0,0,81,4,0,0,22,33,0,0,84,4,0,0,187,0,0,0,88,4,0,0,5,4,0,0,85,4,0,0,87,4,0,0,16,4,0,0,17,4,0,0,18,4,0,0,19,4,0,0,20,4,0,0,21,4,0,0,22,4,0,0,23,4,0,0,24,4,0,0,25,4,0,0,26,4,0,0,27,4,0,0,28,4,0,0,29,4,0,0,30,4,0,0,31,4,0,0,32,4,0,0,33,4,0,0,34,4,0,0,35,4,0,0,36,4,0,0,37,4,0,0,38,4,0,0,39,4,0,0,40,4,0,0,41,4,0,0,42,4,0,0,43,4,0,0,44,4,0,0,45,4,0,0,46,4,0,0,47,4,0,0,48,4,0,0,49,4,0,0,50,4,0,0,51,4,0,0,52,4,0,0,53,4,0,0,54,4,0,0,55,4,0,0,56,4,0,0,57,4,0,0,58,4,0,0,59,4,0,0,60,4,0,0,61,4,0,0,62,4,0,0,63,4,0,0,64,4,0,0,65,4,0,0,66,4,0,0,67,4,0,0,68,4,0,0,69,4,0,0,70,4,0,0,71,4,0,0,72,4,0,0,73,4,0,0,74,4,0,0,75,4,0,0,76,4,0,0,77,4,0,0,78,4,0,0,79,4,0,0,1,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+319840);
/* memory initializer */ allocate([64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,65,0,0,0,97,0,0,0,66,0,0,0,98,0,0,0,67,0,0,0,99,0,0,0,68,0,0,0,100,0,0,0,69,0,0,0,101,0,0,0,70,0,0,0,102,0,0,0,71,0,0,0,103,0,0,0,72,0,0,0,104,0,0,0,73,0,0,0,105,0,0,0,74,0,0,0,106,0,0,0,75,0,0,0,107,0,0,0,76,0,0,0,108,0,0,0,77,0,0,0,109,0,0,0,78,0,0,0,110,0,0,0,79,0,0,0,111,0,0,0,80,0,0,0,112,0,0,0,81,0,0,0,113,0,0,0,82,0,0,0,114,0,0,0,83,0,0,0,115,0,0,0,84,0,0,0,116,0,0,0,85,0,0,0,117,0,0,0,86,0,0,0,118,0,0,0,87,0,0,0,119,0,0,0,88,0,0,0,120,0,0,0,89,0,0,0,121,0,0,0,90,0,0,0,122,0,0,0,148,217,6,0,13,0,0,0,5,0,0,0,76,217,6,0,1,0,0,0,5,0,0,0,82,217,6,0,2,0,0,0,5,0,0,0,88,217,6,0,3,0,0,0,5,0,0,0,94,217,6,0,4,0,0,0,5,0,0,0,100,217,6,0,5,0,0,0,5,0,0,0,106,217,6,0,6,0,0,0,5,0,0,0,112,217,6,0,7,0,0,0,5,0,0,0,118,217,6,0,8,0,0,0,5,0,0,0,124,217,6,0,9,0,0,0,5,0,0,0,130,217,6,0,10,0,0,0,5,0,0,0,136,217,6,0,11,0,0,0,6,0,0,0,154,217,6,0,14,0,0,0,5,0,0,0,143,217,6,0,12,0,0,0,4,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,97,216,6,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,6,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,4,0,0,0,5,0,0,0,124,216,6,0,98,216,6,0,126,216,6,0,103,216,6,0,100,216,6,0,128,216,6,0,97,216,6,0,97,216,6,0,98,216,6,0,100,216,6,0,103,216,6,0,106,216,6,0,115,216,6,0,140,216,6,0,13,0,0,0,5,0,0,0,146,216,6,0,1,0,0,0,5,0,0,0,152,216,6,0,2,0,0,0,5,0,0,0,158,216,6,0,3,0,0,0,5,0,0,0,164,216,6,0,4,0,0,0,5,0,0,0,170,216,6,0,5,0,0,0,5,0,0,0,176,216,6,0,6,0,0,0,5,0,0,0,182,216,6,0,7,0,0,0,5,0,0,0,188,216,6,0,8,0,0,0,5,0,0,0,194,216,6,0,9,0,0,0,5,0,0,0,200,216,6,0,10,0,0,0,5,0,0,0,206,216,6,0,11,0,0,0,6,0,0,0,213,216,6,0,14,0,0,0,5,0,0,0,219,216,6,0,12,0,0,0,4,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,58,0,0,0,93,0,0,0,86,213,247,127,135,3,3,0,139,1,160,128,8,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,7,0,0,0,11,0,0,0,19,0,0,0,37,0,0,0,67,0,0,0,131,0,0,0,27,1,0,0,9,2,0,0,9,4,0,0,5,8,0,0,3,16,0,0,27,32,0,0,43,64,0,0,3,128,0,0,45,0,1,0,29,0,2,0,3,0,4,0,21,0,8,0,7,0,16,0,17,0,32,0,15,0,64,0,9,0,128,0,43,0,0,1,35,0,0,2,15,0,0,4,29,0,0,8,3,0,0,16,11,0,0,32,85,0,0,64,0,0,0,0,8,0,0,0,59,217,6,0,1,0,0,0,1,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,0,0,0,1,0,0,0,65,0,0,0,0,0,0,0,0,0,0,0,98,0,0,0,1,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,99,0,0,0,1,0,0,0,67,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,1,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,101,0,0,0,1,0,0,0,69,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,1,0,0,0,70,0,0,0,0,0,0,0,0,0,0,0,103,0,0,0,1,0,0,0,71,0,0,0,0,0,0,0,0,0,0,0,104,0,0,0,1,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,1,0,0,0,74,0,0,0,0,0,0,0,0,0,0,0,107,0,0,0,2,0,0,0,42,33,0,0,75,0,0,0,0,0,0,0,108,0,0,0,1,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,110,0,0,0,1,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,111,0,0,0,1,0,0,0,79,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,1,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,113,0,0,0,1,0,0,0,81,0,0,0,0,0,0,0,0,0,0,0,114,0,0,0,1,0,0,0,82,0,0,0,0,0,0,0,0,0,0,0,115,0,0,0,2,0,0,0,83,0,0,0,127,1,0,0,0,0,0,0,116,0,0,0,1,0,0,0,84,0,0,0,0,0,0,0,0,0,0,0,117,0,0,0,1,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,118,0,0,0,1,0,0,0,86,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,1,0,0,0,87,0,0,0,0,0,0,0,0,0,0,0,120,0,0,0,1,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,121,0,0,0,1,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,122,0,0,0,1,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,1,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,225,0,0,0,1,0,0,0,193,0,0,0,0,0,0,0,0,0,0,0,226,0,0,0,1,0,0,0,194,0,0,0,0,0,0,0,0,0,0,0,227,0,0,0,1,0,0,0,195,0,0,0,0,0,0,0,0,0,0,0,228,0,0,0,1,0,0,0,196,0,0,0,0,0,0,0,0,0,0,0,229,0,0,0,2,0,0,0,43,33,0,0,197,0,0,0,0,0,0,0,230,0,0,0,1,0,0,0,198,0,0,0,0,0,0,0,0,0,0,0,231,0,0,0,1,0,0,0,199,0,0,0,0,0,0,0,0,0,0,0,232,0,0,0,1,0,0,0,200,0,0,0,0,0,0,0,0,0,0,0,233,0,0,0,1,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,234,0,0,0,1,0,0,0,202,0,0,0,0,0,0,0,0,0,0,0,235,0,0,0,1,0,0,0,203,0,0,0,0,0,0,0,0,0,0,0,236,0,0,0,1,0,0,0,204,0,0,0,0,0,0,0,0,0,0,0,237,0,0,0,1,0,0,0,205,0,0,0,0,0,0,0,0,0,0,0,238,0,0,0,1,0,0,0,206,0,0,0,0,0,0,0,0,0,0,0,239,0,0,0,1,0,0,0,207,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,1,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,241,0,0,0,1,0,0,0,209,0,0,0,0,0,0,0,0,0,0,0,242,0,0,0,1,0,0,0,210,0,0,0,0,0,0,0,0,0,0,0,243,0,0,0,1,0,0,0,211,0,0,0,0,0,0,0,0,0,0,0,244,0,0,0,1,0,0,0,212,0,0,0,0,0,0,0,0,0,0,0,245,0,0,0,1,0,0,0,213,0,0,0,0,0,0,0,0,0,0,0,246,0,0,0,1,0,0,0,214,0,0,0,0,0,0,0,0,0,0,0,248,0,0,0,1,0,0,0,216,0,0,0,0,0,0,0,0,0,0,0,249,0,0,0,1,0,0,0,217,0,0,0,0,0,0,0,0,0,0,0,250,0,0,0,1,0,0,0,218,0,0,0,0,0,0,0,0,0,0,0,251,0,0,0,1,0,0,0,219,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,1,0,0,0,220,0,0,0,0,0,0,0,0,0,0,0,253,0,0,0,1,0,0,0,221,0,0,0,0,0,0,0,0,0,0,0,254,0,0,0,1,0,0,0,222,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,1,0,0,0,120,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,1,0,0,1,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,5,1,0,0,1,0,0,0,4,1,0,0,0,0,0,0,0,0,0,0,7,1,0,0,1,0,0,0,6,1,0,0,0,0,0,0,0,0,0,0,9,1,0,0,1,0,0,0,8,1,0,0,0,0,0,0,0,0,0,0,11,1,0,0,1,0,0,0,10,1,0,0,0,0,0,0,0,0,0,0,13,1,0,0,1,0,0,0,12,1,0,0,0,0,0,0,0,0,0,0,15,1,0,0,1,0,0,0,14,1,0,0,0,0,0,0,0,0,0,0,17,1,0,0,1,0,0,0,16,1,0,0,0,0,0,0,0,0,0,0,19,1,0,0,1,0,0,0,18,1,0,0,0,0,0,0,0,0,0,0,21,1,0,0,1,0,0,0,20,1,0,0,0,0,0,0,0,0,0,0,23,1,0,0,1,0,0,0,22,1,0,0,0,0,0,0,0,0,0,0,25,1,0,0,1,0,0,0,24,1,0,0,0,0,0,0,0,0,0,0,27,1,0,0,1,0,0,0,26,1,0,0,0,0,0,0,0,0,0,0,29,1,0,0,1,0,0,0,28,1,0,0,0,0,0,0,0,0,0,0,31,1,0,0,1,0,0,0,30,1,0,0,0,0,0,0,0,0,0,0,33,1,0,0,1,0,0,0,32,1,0,0,0,0,0,0,0,0,0,0,35,1,0,0,1,0,0,0,34,1,0,0,0,0,0,0,0,0,0,0,37,1,0,0,1,0,0,0,36,1,0,0,0,0,0,0,0,0,0,0,39,1,0,0,1,0,0,0,38,1,0,0,0,0,0,0,0,0,0,0,41,1,0,0,1,0,0,0,40,1,0,0,0,0,0,0,0,0,0,0,43,1,0,0,1,0,0,0,42,1,0,0,0,0,0,0,0,0,0,0,45,1,0,0,1,0,0,0,44,1,0,0,0,0,0,0,0,0,0,0,47,1,0,0,1,0,0,0,46,1,0,0,0,0,0,0,0,0,0,0,51,1,0,0,1,0,0,0,50,1,0,0,0,0,0,0,0,0,0,0,53,1,0,0,1,0,0,0,52,1,0,0,0,0,0,0,0,0,0,0,55,1,0,0,1,0,0,0,54,1,0,0,0,0,0,0,0,0,0,0,58,1,0,0,1,0,0,0,57,1,0,0,0,0,0,0,0,0,0,0,60,1,0,0,1,0,0,0,59,1,0,0,0,0,0,0,0,0,0,0,62,1,0,0,1,0,0,0,61,1,0,0,0,0,0,0,0,0,0,0,64,1,0,0,1,0,0,0,63,1,0,0,0,0,0,0,0,0,0,0,66,1,0,0,1,0,0,0,65,1,0,0,0,0,0,0,0,0,0,0,68,1,0,0,1,0,0,0,67,1,0,0,0,0,0,0,0,0,0,0,70,1,0,0,1,0,0,0,69,1,0,0,0,0,0,0,0,0,0,0,72,1,0,0,1,0,0,0,71,1,0,0,0,0,0,0,0,0,0,0,75,1,0,0,1,0,0,0,74,1,0,0,0,0,0,0,0,0,0,0,77,1,0,0,1,0,0,0,76,1,0,0,0,0,0,0,0,0,0,0,79,1,0,0,1,0,0,0,78,1,0,0,0,0,0,0,0,0,0,0,81,1,0,0,1,0,0,0,80,1,0,0,0,0,0,0,0,0,0,0,83,1,0,0,1,0,0,0,82,1,0,0,0,0,0,0,0,0,0,0,85,1,0,0,1,0,0,0,84,1,0,0,0,0,0,0,0,0,0,0,87,1,0,0,1,0,0,0,86,1,0,0,0,0,0,0,0,0,0,0,89,1,0,0,1,0,0,0,88,1,0,0,0,0,0,0,0,0,0,0,91,1,0,0,1,0,0,0,90,1,0,0,0,0,0,0,0,0,0,0,93,1,0,0,1,0,0,0,92,1,0,0,0,0,0,0,0,0,0,0,95,1,0,0,1,0,0,0,94,1,0,0,0,0,0,0,0,0,0,0,97,1,0,0,1,0,0,0,96,1,0,0,0,0,0,0,0,0,0,0,99,1,0,0,1,0,0,0,98,1,0,0,0,0,0,0,0,0,0,0,101,1,0,0,1,0,0,0,100,1,0,0,0,0,0,0,0,0,0,0,103,1,0,0,1,0,0,0,102,1,0,0,0,0,0,0,0,0,0,0,105,1,0,0,1,0,0,0,104,1,0,0,0,0,0,0,0,0,0,0,107,1,0,0,1,0,0,0,106,1,0,0,0,0,0,0,0,0,0,0,109,1,0,0,1,0,0,0,108,1,0,0,0,0,0,0,0,0,0,0,111,1,0,0,1,0,0,0,110,1,0,0,0,0,0,0,0,0,0,0,113,1,0,0,1,0,0,0,112,1,0,0,0,0,0,0,0,0,0,0,115,1,0,0,1,0,0,0,114,1,0,0,0,0,0,0,0,0,0,0,117,1,0,0,1,0,0,0,116,1,0,0,0,0,0,0,0,0,0,0,119,1,0,0,1,0,0,0,118,1,0,0,0,0,0,0,0,0,0,0,122,1,0,0,1,0,0,0,121,1,0,0,0,0,0,0,0,0,0,0,124,1,0,0,1,0,0,0,123,1,0,0,0,0,0,0,0,0,0,0,126,1,0,0,1,0,0,0,125,1,0,0,0,0,0,0,0,0,0,0,131,1,0,0,1,0,0,0,130,1,0,0,0,0,0,0,0,0,0,0,133,1,0,0,1,0,0,0,132,1,0,0,0,0,0,0,0,0,0,0,136,1,0,0,1,0,0,0,135,1,0,0,0,0,0,0,0,0,0,0,140,1,0,0,1,0,0,0,139,1,0,0,0,0,0,0,0,0,0,0,146,1,0,0,1,0,0,0,145,1,0,0,0,0,0,0,0,0,0,0,149,1,0,0,1,0,0,0,246,1,0,0,0,0,0,0,0,0,0,0,153,1,0,0,1,0,0,0,152,1,0,0,0,0,0,0,0,0,0,0,154,1,0,0,1,0,0,0,61,2,0,0,0,0,0,0,0,0,0,0,158,1,0,0,1,0,0,0,32,2,0,0,0,0,0,0,0,0,0,0,161,1,0,0,1,0,0,0,160,1,0,0,0,0,0,0,0,0,0,0,163,1,0,0,1,0,0,0,162,1,0,0,0,0,0,0,0,0,0,0,165,1,0,0,1,0,0,0,164,1,0,0,0,0,0,0,0,0,0,0,168,1,0,0,1,0,0,0,167,1,0,0,0,0,0,0,0,0,0,0,173,1,0,0,1,0,0,0,172,1,0,0,0,0,0,0,0,0,0,0,176,1,0,0,1,0,0,0,175,1,0,0,0,0,0,0,0,0,0,0,180,1,0,0,1,0,0,0,179,1,0,0,0,0,0,0,0,0,0,0,182,1,0,0,1,0,0,0,181,1,0,0,0,0,0,0,0,0,0,0,185,1,0,0,1,0,0,0,184,1,0,0,0,0,0,0,0,0,0,0,189,1,0,0,1,0,0,0,188,1,0,0,0,0,0,0,0,0,0,0,191,1,0,0,1,0,0,0,247,1,0,0,0,0,0,0,0,0,0,0,198,1,0,0,2,0,0,0,196,1,0,0,197,1,0,0,0,0,0,0,201,1,0,0,2,0,0,0,199,1,0,0,200,1,0,0,0,0,0,0,204,1,0,0,2,0,0,0,202,1,0,0,203,1,0,0,0,0,0,0,206,1,0,0,1,0,0,0,205,1,0,0,0,0,0,0,0,0,0,0,208,1,0,0,1,0,0,0,207,1,0,0,0,0,0,0,0,0,0,0,210,1,0,0,1,0,0,0,209,1,0,0,0,0,0,0,0,0,0,0,212,1,0,0,1,0,0,0,211,1,0,0,0,0,0,0,0,0,0,0,214,1,0,0,1,0,0,0,213,1,0,0,0,0,0,0,0,0,0,0,216,1,0,0,1,0,0,0,215,1,0,0,0,0,0,0,0,0,0,0,218,1,0,0,1,0,0,0,217,1,0,0,0,0,0,0,0,0,0,0,220,1,0,0,1,0,0,0,219,1,0,0,0,0,0,0,0,0,0,0,221,1,0,0,1,0,0,0,142,1,0,0,0,0,0,0,0,0,0,0,223,1,0,0,1,0,0,0,222,1,0,0,0,0,0,0,0,0,0,0,225,1,0,0,1,0,0,0,224,1,0,0,0,0,0,0,0,0,0,0,227,1,0,0,1,0,0,0,226,1,0,0,0,0,0,0,0,0,0,0,229,1,0,0,1,0,0,0,228,1,0,0,0,0,0,0,0,0,0,0,231,1,0,0,1,0,0,0,230,1,0,0,0,0,0,0,0,0,0,0,233,1,0,0,1,0,0,0,232,1,0,0,0,0,0,0,0,0,0,0,235,1,0,0,1,0,0,0,234,1,0,0,0,0,0,0,0,0,0,0,237,1,0,0,1,0,0,0,236,1,0,0,0,0,0,0,0,0,0,0,239,1,0,0,1,0,0,0,238,1,0,0,0,0,0,0,0,0,0,0,243,1,0,0,2,0,0,0,241,1,0,0,242,1,0,0,0,0,0,0,245,1,0,0,1,0,0,0,244,1,0,0,0,0,0,0,0,0,0,0,249,1,0,0,1,0,0,0,248,1,0,0,0,0,0,0,0,0,0,0,251,1,0,0,1,0,0,0,250,1,0,0,0,0,0,0,0,0,0,0,253,1,0,0,1,0,0,0,252,1,0,0,0,0,0,0,0,0,0,0,255,1,0,0,1,0,0,0,254,1,0,0,0,0,0,0,0,0,0,0,1,2,0,0,1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,3,2,0,0,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,5,2,0,0,1,0,0,0,4,2,0,0,0,0,0,0,0,0,0,0,7,2,0,0,1,0,0,0,6,2,0,0,0,0,0,0,0,0,0,0,9,2,0,0,1,0,0,0,8,2,0,0,0,0,0,0,0,0,0,0,11,2,0,0,1,0,0,0,10,2,0,0,0,0,0,0,0,0,0,0,13,2,0,0,1,0,0,0,12,2,0,0,0,0,0,0,0,0,0,0,15,2,0,0,1,0,0,0,14,2,0,0,0,0,0,0,0,0,0,0,17,2,0,0,1,0,0,0,16,2,0,0,0,0,0,0,0,0,0,0,19,2,0,0,1,0,0,0,18,2,0,0,0,0,0,0,0,0,0,0,21,2,0,0,1,0,0,0,20,2,0,0,0,0,0,0,0,0,0,0,23,2,0,0,1,0,0,0,22,2,0,0,0,0,0,0,0,0,0,0,25,2,0,0,1,0,0,0,24,2,0,0,0,0,0,0,0,0,0,0,27,2,0,0,1,0,0,0,26,2,0,0,0,0,0,0,0,0,0,0,29,2,0,0,1,0,0,0,28,2,0,0,0,0,0,0,0,0,0,0,31,2,0,0,1,0,0,0,30,2,0,0,0,0,0,0,0,0,0,0,35,2,0,0,1,0,0,0,34,2,0,0,0,0,0,0,0,0,0,0,37,2,0,0,1,0,0,0,36,2,0,0,0,0,0,0,0,0,0,0,39,2,0,0,1,0,0,0,38,2,0,0,0,0,0,0,0,0,0,0,41,2,0,0,1,0,0,0,40,2,0,0,0,0,0,0,0,0,0,0,43,2,0,0,1,0,0,0,42,2,0,0,0,0,0,0,0,0,0,0,45,2,0,0,1,0,0,0,44,2,0,0,0,0,0,0,0,0,0,0,47,2,0,0,1,0,0,0,46,2,0,0,0,0,0,0,0,0,0,0,49,2,0,0,1,0,0,0,48,2,0,0,0,0,0,0,0,0,0,0,51,2,0,0,1,0,0,0,50,2,0,0,0,0,0,0,0,0,0,0,60,2,0,0,1,0,0,0,59,2,0,0,0,0,0,0,0,0,0,0,83,2,0,0,1,0,0,0,129,1,0,0,0,0,0,0,0,0,0,0,84,2,0,0,1,0,0,0,134,1,0,0,0,0,0,0,0,0,0,0,86,2,0,0,1,0,0,0,137,1,0,0,0,0,0,0,0,0,0,0,87,2,0,0,1,0,0,0,138,1,0,0,0,0,0,0,0,0,0,0,89,2,0,0,1,0,0,0,143,1,0,0,0,0,0,0,0,0,0,0,91,2,0,0,1,0,0,0,144,1,0,0,0,0,0,0,0,0,0,0,96,2,0,0,1,0,0,0,147,1,0,0,0,0,0,0,0,0,0,0,99,2,0,0,1,0,0,0,148,1,0,0,0,0,0,0,0,0,0,0,104,2,0,0,1,0,0,0,151,1,0,0,0,0,0,0,0,0,0,0,105,2,0,0,1,0,0,0,150,1,0,0,0,0,0,0,0,0,0,0,111,2,0,0,1,0,0,0,156,1,0,0,0,0,0,0,0,0,0,0,114,2,0,0,1,0,0,0,157,1,0,0,0,0,0,0,0,0,0,0,117,2,0,0,1,0,0,0,159,1,0,0,0,0,0,0,0,0,0,0,128,2,0,0,1,0,0,0,166,1,0,0,0,0,0,0,0,0,0,0,131,2,0,0,1,0,0,0,169,1,0,0,0,0,0,0,0,0,0,0,136,2,0,0,1,0,0,0,174,1,0,0,0,0,0,0,0,0,0,0,138,2,0,0,1,0,0,0,177,1,0,0,0,0,0,0,0,0,0,0,139,2,0,0,1,0,0,0,178,1,0,0,0,0,0,0,0,0,0,0,146,2,0,0,1,0,0,0,183,1,0,0,0,0,0,0,0,0,0,0,148,2,0,0,1,0,0,0,65,2,0,0,0,0,0,0,0,0,0,0,172,3,0,0,1,0,0,0,134,3,0,0,0,0,0,0,0,0,0,0,173,3,0,0,1,0,0,0,136,3,0,0,0,0,0,0,0,0,0,0,174,3,0,0,1,0,0,0,137,3,0,0,0,0,0,0,0,0,0,0,175,3,0,0,1,0,0,0,138,3,0,0,0,0,0,0,0,0,0,0,177,3,0,0,1,0,0,0,145,3,0,0,0,0,0,0,0,0,0,0,178,3,0,0,2,0,0,0,146,3,0,0,208,3,0,0,0,0,0,0,179,3,0,0,1,0,0,0,147,3,0,0,0,0,0,0,0,0,0,0,180,3,0,0,1,0,0,0,148,3,0,0,0,0,0,0,0,0,0,0,181,3,0,0,2,0,0,0,245,3,0,0,149,3,0,0,0,0,0,0,182,3,0,0,1,0,0,0,150,3,0,0,0,0,0,0,0,0,0,0,183,3,0,0,1,0,0,0,151,3,0,0,0,0,0,0,0,0,0,0,184,3,0,0,3,0,0,0,244,3,0,0,152,3,0,0,209,3,0,0,185,3,0,0,3,0,0,0,190,31,0,0,153,3,0,0,69,3,0,0,186,3,0,0,2,0,0,0,240,3,0,0,154,3,0,0,0,0,0,0,187,3,0,0,1,0,0,0,155,3,0,0,0,0,0,0,0,0,0,0,188,3,0,0,2,0,0,0,181,0,0,0,156,3,0,0,0,0,0,0,189,3,0,0,1,0,0,0,157,3,0,0,0,0,0,0,0,0,0,0,190,3,0,0,1,0,0,0,158,3,0,0,0,0,0,0,0,0,0,0,191,3,0,0,1,0,0,0,159,3,0,0,0,0,0,0,0,0,0,0,192,3,0,0,2,0,0,0,160,3,0,0,214,3,0,0,0,0,0,0,193,3,0,0,2,0,0,0,241,3,0,0,161,3,0,0,0,0,0,0,195,3,0,0,2,0,0,0,163,3,0,0,194,3,0,0,0,0,0,0,196,3,0,0,1,0,0,0,164,3,0,0,0,0,0,0,0,0,0,0,197,3,0,0,1,0,0,0,165,3,0,0,0,0,0,0,0,0,0,0,198,3,0,0,2,0,0,0,166,3,0,0,213,3,0,0,0,0,0,0,199,3,0,0,1,0,0,0,167,3,0,0,0,0,0,0,0,0,0,0,200,3,0,0,1,0,0,0,168,3,0,0,0,0,0,0,0,0,0,0,201,3,0,0,2,0,0,0,169,3,0,0,38,33,0,0,0,0,0,0,202,3,0,0,1,0,0,0,170,3,0,0,0,0,0,0,0,0,0,0,203,3,0,0,1,0,0,0,171,3,0,0,0,0,0,0,0,0,0,0,204,3,0,0,1,0,0,0,140,3,0,0,0,0,0,0,0,0,0,0,205,3,0,0,1,0,0,0,142,3,0,0,0,0,0,0,0,0,0,0,206,3,0,0,1,0,0,0,143,3,0,0,0,0,0,0,0,0,0,0,217,3,0,0,1,0,0,0,216,3,0,0,0,0,0,0,0,0,0,0,219,3,0,0,1,0,0,0,218,3,0,0,0,0,0,0,0,0,0,0,221,3,0,0,1,0,0,0,220,3,0,0,0,0,0,0,0,0,0,0,223,3,0,0,1,0,0,0,222,3,0,0,0,0,0,0,0,0,0,0,225,3,0,0,1,0,0,0,224,3,0,0,0,0,0,0,0,0,0,0,227,3,0,0,1,0,0,0,226,3,0,0,0,0,0,0,0,0,0,0,229,3,0,0,1,0,0,0,228,3,0,0,0,0,0,0,0,0,0,0,231,3,0,0,1,0,0,0,230,3,0,0,0,0,0,0,0,0,0,0,233,3,0,0,1,0,0,0,232,3,0,0,0,0,0,0,0,0,0,0,235,3,0,0,1,0,0,0,234,3,0,0,0,0,0,0,0,0,0,0,237,3,0,0,1,0,0,0,236,3,0,0,0,0,0,0,0,0,0,0,239,3,0,0,1,0,0,0,238,3,0,0,0,0,0,0,0,0,0,0,242,3,0,0,1,0,0,0,249,3,0,0,0,0,0,0,0,0,0,0,248,3,0,0,1,0,0,0,247,3,0,0,0,0,0,0,0,0,0,0,251,3,0,0,1,0,0,0,250,3,0,0,0,0,0,0,0,0,0,0,48,4,0,0,1,0,0,0,16,4,0,0,0,0,0,0,0,0,0,0,49,4,0,0,1,0,0,0,17,4,0,0,0,0,0,0,0,0,0,0,50,4,0,0,1,0,0,0,18,4,0,0,0,0,0,0,0,0,0,0,51,4,0,0,1,0,0,0,19,4,0,0,0,0,0,0,0,0,0,0,52,4,0,0,1,0,0,0,20,4,0,0,0,0,0,0,0,0,0,0,53,4,0,0,1,0,0,0,21,4,0,0,0,0,0,0,0,0,0,0,54,4,0,0,1,0,0,0,22,4,0,0,0,0,0,0,0,0,0,0,55,4,0,0,1,0,0,0,23,4,0,0,0,0,0,0,0,0,0,0,56,4,0,0,1,0,0,0,24,4,0,0,0,0,0,0,0,0,0,0,57,4,0,0,1,0,0,0,25,4,0,0,0,0,0,0,0,0,0,0,58,4,0,0,1,0,0,0,26,4,0,0,0,0,0,0,0,0,0,0,59,4,0,0,1,0,0,0,27,4,0,0,0,0,0,0,0,0,0,0,60,4,0,0,1,0,0,0,28,4,0,0,0,0,0,0,0,0,0,0,61,4,0,0,1,0,0,0,29,4,0,0,0,0,0,0,0,0,0,0,62,4,0,0,1,0,0,0,30,4,0,0,0,0,0,0,0,0,0,0,63,4,0,0,1,0,0,0,31,4,0,0,0,0,0,0,0,0,0,0,64,4,0,0,1,0,0,0,32,4,0,0,0,0,0,0,0,0,0,0,65,4,0,0,1,0,0,0,33,4,0,0,0,0,0,0,0,0,0,0,66,4,0,0,1,0,0,0,34,4,0,0,0,0,0,0,0,0,0,0,67,4,0,0,1,0,0,0,35,4,0,0,0,0,0,0,0,0,0,0,68,4,0,0,1,0,0,0,36,4,0,0,0,0,0,0,0,0,0,0,69,4,0,0,1,0,0,0,37,4,0,0,0,0,0,0,0,0,0,0,70,4,0,0,1,0,0,0,38,4,0,0,0,0,0,0,0,0,0,0,71,4,0,0,1,0,0,0,39,4,0,0,0,0,0,0,0,0,0,0,72,4,0,0,1,0,0,0,40,4,0,0,0,0,0,0,0,0,0,0,73,4,0,0,1,0,0,0,41,4,0,0,0,0,0,0,0,0,0,0,74,4,0,0,1,0,0,0,42,4,0,0,0,0,0,0,0,0,0,0,75,4,0,0,1,0,0,0,43,4,0,0,0,0,0,0,0,0,0,0,76,4,0,0,1,0,0,0,44,4,0,0,0,0,0,0,0,0,0,0,77,4,0,0,1,0,0,0,45,4,0,0,0,0,0,0,0,0,0,0,78,4,0,0,1,0,0,0,46,4,0,0,0,0,0,0,0,0,0,0,79,4,0,0,1,0,0,0,47,4,0,0,0,0,0,0,0,0,0,0,80,4,0,0,1,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,81,4,0,0,1,0,0,0,1,4,0,0,0,0,0,0,0,0,0,0,82,4,0,0,1,0,0,0,2,4,0,0,0,0,0,0,0,0,0,0,83,4,0,0,1,0,0,0,3,4,0,0,0,0,0,0,0,0,0,0,84,4,0,0,1,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,85,4,0,0,1,0,0,0,5,4,0,0,0,0,0,0,0,0,0,0,86,4,0,0,1,0,0,0,6,4,0,0,0,0,0,0,0,0,0,0,87,4,0,0,1,0,0,0,7,4,0,0,0,0,0,0,0,0,0,0,88,4,0,0,1,0,0,0,8,4,0,0,0,0,0,0,0,0,0,0,89,4,0,0,1,0,0,0,9,4,0,0,0,0,0,0,0,0,0,0,90,4,0,0,1,0,0,0,10,4,0,0,0,0,0,0,0,0,0,0,91,4,0,0,1,0,0,0,11,4,0,0,0,0,0,0,0,0,0,0,92,4,0,0,1,0,0,0,12,4,0,0,0,0,0,0,0,0,0,0,93,4,0,0,1,0,0,0,13,4,0,0,0,0,0,0,0,0,0,0,94,4,0,0,1,0,0,0,14,4,0,0,0,0,0,0,0,0,0,0,95,4,0,0,1,0,0,0,15,4,0,0,0,0,0,0,0,0,0,0,97,4,0,0,1,0,0,0,96,4,0,0,0,0,0,0,0,0,0,0,99,4,0,0,1,0,0,0,98,4,0,0,0,0,0,0,0,0,0,0,101,4,0,0,1,0,0,0,100,4,0,0,0,0,0,0,0,0,0,0,103,4,0,0,1,0,0,0,102,4,0,0,0,0,0,0,0,0,0,0,105,4,0,0,1,0,0,0,104,4,0,0,0,0,0,0,0,0,0,0,107,4,0,0,1,0,0,0,106,4,0,0,0,0,0,0,0,0,0,0,109,4,0,0,1,0,0,0,108,4,0,0,0,0,0,0,0,0,0,0,111,4,0,0,1,0,0,0,110,4,0,0,0,0,0,0,0,0,0,0,113,4,0,0,1,0,0,0,112,4,0,0,0,0,0,0,0,0,0,0,115,4,0,0,1,0,0,0,114,4,0,0,0,0,0,0,0,0,0,0,117,4,0,0,1,0,0,0,116,4,0,0,0,0,0,0,0,0,0,0,119,4,0,0,1,0,0,0,118,4,0,0,0,0,0,0,0,0,0,0,121,4,0,0,1,0,0,0,120,4,0,0,0,0,0,0,0,0,0,0,123,4,0,0,1,0,0,0,122,4,0,0,0,0,0,0,0,0,0,0,125,4,0,0,1,0,0,0,124,4,0,0,0,0,0,0,0,0,0,0,127,4,0,0,1,0,0,0,126,4,0,0,0,0,0,0,0,0,0,0,129,4,0,0,1,0,0,0,128,4,0,0,0,0,0,0,0,0,0,0,139,4,0,0,1,0,0,0,138,4,0,0,0,0,0,0,0,0,0,0,141,4,0,0,1,0,0,0,140,4,0,0,0,0,0,0,0,0,0,0,143,4,0,0,1,0,0,0,142,4,0,0,0,0,0,0,0,0,0,0,145,4,0,0,1,0,0,0,144,4,0,0,0,0,0,0,0,0,0,0,147,4,0,0,1,0,0,0,146,4,0,0,0,0,0,0,0,0,0,0,149,4,0,0,1,0,0,0,148,4,0,0,0,0,0,0,0,0,0,0,151,4,0,0,1,0,0,0,150,4,0,0,0,0,0,0,0,0,0,0,153,4,0,0,1,0,0,0,152,4,0,0,0,0,0,0,0,0,0,0,155,4,0,0,1,0,0,0,154,4,0,0,0,0,0,0,0,0,0,0,157,4,0,0,1,0,0,0,156,4,0,0,0,0,0,0,0,0,0,0,159,4,0,0,1,0,0,0,158,4,0,0,0,0,0,0,0,0,0,0,161,4,0,0,1,0,0,0,160,4,0,0,0,0,0,0,0,0,0,0,163,4,0,0,1,0,0,0,162,4,0,0,0,0,0,0,0,0,0,0,165,4,0,0,1,0,0,0,164,4,0,0,0,0,0,0,0,0,0,0,167,4,0,0,1,0,0,0,166,4,0,0,0,0,0,0,0,0,0,0,169,4,0,0,1,0,0,0,168,4,0,0,0,0,0,0,0,0,0,0,171,4,0,0,1,0,0,0,170,4,0,0,0,0,0,0,0,0,0,0,173,4,0,0,1,0,0,0,172,4,0,0,0,0,0,0,0,0,0,0,175,4,0,0,1,0,0,0,174,4,0,0,0,0,0,0,0,0,0,0,177,4,0,0,1,0,0,0,176,4,0,0,0,0,0,0,0,0,0,0,179,4,0,0,1,0,0,0,178,4,0,0,0,0,0,0,0,0,0,0,181,4,0,0,1,0,0,0,180,4,0,0,0,0,0,0,0,0,0,0,183,4,0,0,1,0,0,0,182,4,0,0,0,0,0,0,0,0,0,0,185,4,0,0,1,0,0,0,184,4,0,0,0,0,0,0,0,0,0,0,187,4,0,0,1,0,0,0,186,4,0,0,0,0,0,0,0,0,0,0,189,4,0,0,1,0,0,0,188,4,0,0,0,0,0,0,0,0,0,0,191,4,0,0,1,0,0,0,190,4,0,0,0,0,0,0,0,0,0,0,194,4,0,0,1,0,0,0,193,4,0,0,0,0,0,0,0,0,0,0,196,4,0,0,1,0,0,0,195,4,0,0,0,0,0,0,0,0,0,0,198,4,0,0,1,0,0,0,197,4,0,0,0,0,0,0,0,0,0,0,200,4,0,0,1,0,0,0,199,4,0,0,0,0,0,0,0,0,0,0,202,4,0,0,1,0,0,0,201,4,0,0,0,0,0,0,0,0,0,0,204,4,0,0,1,0,0,0,203,4,0,0,0,0,0,0,0,0,0,0,206,4,0,0,1,0,0,0,205,4,0,0,0,0,0,0,0,0,0,0,209,4,0,0,1,0,0,0,208,4,0,0,0,0,0,0,0,0,0,0,211,4,0,0,1,0,0,0,210,4,0,0,0,0,0,0,0,0,0,0,213,4,0,0,1,0,0,0,212,4,0,0,0,0,0,0,0,0,0,0,215,4,0,0,1,0,0,0,214,4,0,0,0,0,0,0,0,0,0,0,217,4,0,0,1,0,0,0,216,4,0,0,0,0,0,0,0,0,0,0,219,4,0,0,1,0,0,0,218,4,0,0,0,0,0,0,0,0,0,0,221,4,0,0,1,0,0,0,220,4,0,0,0,0,0,0,0,0,0,0,223,4,0,0,1,0,0,0,222,4,0,0,0,0,0,0,0,0,0,0,225,4,0,0,1,0,0,0,224,4,0,0,0,0,0,0,0,0,0,0,227,4,0,0,1,0,0,0,226,4,0,0,0,0,0,0,0,0,0,0,229,4,0,0,1,0,0,0,228,4,0,0,0,0,0,0,0,0,0,0,231,4,0,0,1,0,0,0,230,4,0,0,0,0,0,0,0,0,0,0,233,4,0,0,1,0,0,0,232,4,0,0,0,0,0,0,0,0,0,0,235,4,0,0,1,0,0,0,234,4,0,0,0,0,0,0,0,0,0,0,237,4,0,0,1,0,0,0,236,4,0,0,0,0,0,0,0,0,0,0,239,4,0,0,1,0,0,0,238,4,0,0,0,0,0,0,0,0,0,0,241,4,0,0,1,0,0,0,240,4,0,0,0,0,0,0,0,0,0,0,243,4,0,0,1,0,0,0,242,4,0,0,0,0,0,0,0,0,0,0,245,4,0,0,1,0,0,0,244,4,0,0,0,0,0,0,0,0,0,0,247,4,0,0,1,0,0,0,246,4,0,0,0,0,0,0,0,0,0,0,249,4,0,0,1,0,0,0,248,4,0,0,0,0,0,0,0,0,0,0,1,5,0,0,1,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,3,5,0,0,1,0,0,0,2,5,0,0,0,0,0,0,0,0,0,0,5,5,0,0,1,0,0,0,4,5,0,0,0,0,0,0,0,0,0,0,7,5,0,0,1,0,0,0,6,5,0,0,0,0,0,0,0,0,0,0,9,5,0,0,1,0,0,0,8,5,0,0,0,0,0,0,0,0,0,0,11,5,0,0,1,0,0,0,10,5,0,0,0,0,0,0,0,0,0,0,13,5,0,0,1,0,0,0,12,5,0,0,0,0,0,0,0,0,0,0,15,5,0,0,1,0,0,0,14,5,0,0,0,0,0,0,0,0,0,0,97,5,0,0,1,0,0,0,49,5,0,0,0,0,0,0,0,0,0,0,98,5,0,0,1,0,0,0,50,5,0,0,0,0,0,0,0,0,0,0,99,5,0,0,1,0,0,0,51,5,0,0,0,0,0,0,0,0,0,0,100,5,0,0,1,0,0,0,52,5,0,0,0,0,0,0,0,0,0,0,101,5,0,0,1,0,0,0,53,5,0,0,0,0,0,0,0,0,0,0,102,5,0,0,1,0,0,0,54,5,0,0,0,0,0,0,0,0,0,0,103,5,0,0,1,0,0,0,55,5,0,0,0,0,0,0,0,0,0,0,104,5,0,0,1,0,0,0,56,5,0,0,0,0,0,0,0,0,0,0,105,5,0,0,1,0,0,0,57,5,0,0,0,0,0,0,0,0,0,0,106,5,0,0,1,0,0,0,58,5,0,0,0,0,0,0,0,0,0,0,107,5,0,0,1,0,0,0,59,5,0,0,0,0,0,0,0,0,0,0,108,5,0,0,1,0,0,0,60,5,0,0,0,0,0,0,0,0,0,0,109,5,0,0,1,0,0,0,61,5,0,0,0,0,0,0,0,0,0,0,110,5,0,0,1,0,0,0,62,5,0,0,0,0,0,0,0,0,0,0,111,5,0,0,1,0,0,0,63,5,0,0,0,0,0,0,0,0,0,0,112,5,0,0,1,0,0,0,64,5,0,0,0,0,0,0,0,0,0,0,113,5,0,0,1,0,0,0,65,5,0,0,0,0,0,0,0,0,0,0,114,5,0,0,1,0,0,0,66,5,0,0,0,0,0,0,0,0,0,0,115,5,0,0,1,0,0,0,67,5,0,0,0,0,0,0,0,0,0,0,116,5,0,0,1,0,0,0,68,5,0,0,0,0,0,0,0,0,0,0,117,5,0,0,1,0,0,0,69,5,0,0,0,0,0,0,0,0,0,0,118,5,0,0,1,0,0,0,70,5,0,0,0,0,0,0,0,0,0,0,119,5,0,0,1,0,0,0,71,5,0,0,0,0,0,0,0,0,0,0,120,5,0,0,1,0,0,0,72,5,0,0,0,0,0,0,0,0,0,0,121,5,0,0,1,0,0,0,73,5,0,0,0,0,0,0,0,0,0,0,122,5,0,0,1,0,0,0,74,5,0,0,0,0,0,0,0,0,0,0,123,5,0,0,1,0,0,0,75,5,0,0,0,0,0,0,0,0,0,0,124,5,0,0,1,0,0,0,76,5,0,0,0,0,0,0,0,0,0,0,125,5,0,0,1,0,0,0,77,5,0,0,0,0,0,0,0,0,0,0,126,5,0,0,1,0,0,0,78,5,0,0,0,0,0,0,0,0,0,0,127,5,0,0,1,0,0,0,79,5,0,0,0,0,0,0,0,0,0,0,128,5,0,0,1,0,0,0,80,5,0,0,0,0,0,0,0,0,0,0,129,5,0,0,1,0,0,0,81,5,0,0,0,0,0,0,0,0,0,0,130,5,0,0,1,0,0,0,82,5,0,0,0,0,0,0,0,0,0,0,131,5,0,0,1,0,0,0,83,5,0,0,0,0,0,0,0,0,0,0,132,5,0,0,1,0,0,0,84,5], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+335223);
/* memory initializer */ allocate([133,5,0,0,1,0,0,0,85,5,0,0,0,0,0,0,0,0,0,0,134,5,0,0,1,0,0,0,86,5,0,0,0,0,0,0,0,0,0,0,1,30,0,0,1,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,3,30,0,0,1,0,0,0,2,30,0,0,0,0,0,0,0,0,0,0,5,30,0,0,1,0,0,0,4,30,0,0,0,0,0,0,0,0,0,0,7,30,0,0,1,0,0,0,6,30,0,0,0,0,0,0,0,0,0,0,9,30,0,0,1,0,0,0,8,30,0,0,0,0,0,0,0,0,0,0,11,30,0,0,1,0,0,0,10,30,0,0,0,0,0,0,0,0,0,0,13,30,0,0,1,0,0,0,12,30,0,0,0,0,0,0,0,0,0,0,15,30,0,0,1,0,0,0,14,30,0,0,0,0,0,0,0,0,0,0,17,30,0,0,1,0,0,0,16,30,0,0,0,0,0,0,0,0,0,0,19,30,0,0,1,0,0,0,18,30,0,0,0,0,0,0,0,0,0,0,21,30,0,0,1,0,0,0,20,30,0,0,0,0,0,0,0,0,0,0,23,30,0,0,1,0,0,0,22,30,0,0,0,0,0,0,0,0,0,0,25,30,0,0,1,0,0,0,24,30,0,0,0,0,0,0,0,0,0,0,27,30,0,0,1,0,0,0,26,30,0,0,0,0,0,0,0,0,0,0,29,30,0,0,1,0,0,0,28,30,0,0,0,0,0,0,0,0,0,0,31,30,0,0,1,0,0,0,30,30,0,0,0,0,0,0,0,0,0,0,33,30,0,0,1,0,0,0,32,30,0,0,0,0,0,0,0,0,0,0,35,30,0,0,1,0,0,0,34,30,0,0,0,0,0,0,0,0,0,0,37,30,0,0,1,0,0,0,36,30,0,0,0,0,0,0,0,0,0,0,39,30,0,0,1,0,0,0,38,30,0,0,0,0,0,0,0,0,0,0,41,30,0,0,1,0,0,0,40,30,0,0,0,0,0,0,0,0,0,0,43,30,0,0,1,0,0,0,42,30,0,0,0,0,0,0,0,0,0,0,45,30,0,0,1,0,0,0,44,30,0,0,0,0,0,0,0,0,0,0,47,30,0,0,1,0,0,0,46,30,0,0,0,0,0,0,0,0,0,0,49,30,0,0,1,0,0,0,48,30,0,0,0,0,0,0,0,0,0,0,51,30,0,0,1,0,0,0,50,30,0,0,0,0,0,0,0,0,0,0,53,30,0,0,1,0,0,0,52,30,0,0,0,0,0,0,0,0,0,0,55,30,0,0,1,0,0,0,54,30,0,0,0,0,0,0,0,0,0,0,57,30,0,0,1,0,0,0,56,30,0,0,0,0,0,0,0,0,0,0,59,30,0,0,1,0,0,0,58,30,0,0,0,0,0,0,0,0,0,0,61,30,0,0,1,0,0,0,60,30,0,0,0,0,0,0,0,0,0,0,63,30,0,0,1,0,0,0,62,30,0,0,0,0,0,0,0,0,0,0,65,30,0,0,1,0,0,0,64,30,0,0,0,0,0,0,0,0,0,0,67,30,0,0,1,0,0,0,66,30,0,0,0,0,0,0,0,0,0,0,69,30,0,0,1,0,0,0,68,30,0,0,0,0,0,0,0,0,0,0,71,30,0,0,1,0,0,0,70,30,0,0,0,0,0,0,0,0,0,0,73,30,0,0,1,0,0,0,72,30,0,0,0,0,0,0,0,0,0,0,75,30,0,0,1,0,0,0,74,30,0,0,0,0,0,0,0,0,0,0,77,30,0,0,1,0,0,0,76,30,0,0,0,0,0,0,0,0,0,0,79,30,0,0,1,0,0,0,78,30,0,0,0,0,0,0,0,0,0,0,81,30,0,0,1,0,0,0,80,30,0,0,0,0,0,0,0,0,0,0,83,30,0,0,1,0,0,0,82,30,0,0,0,0,0,0,0,0,0,0,85,30,0,0,1,0,0,0,84,30,0,0,0,0,0,0,0,0,0,0,87,30,0,0,1,0,0,0,86,30,0,0,0,0,0,0,0,0,0,0,89,30,0,0,1,0,0,0,88,30,0,0,0,0,0,0,0,0,0,0,91,30,0,0,1,0,0,0,90,30,0,0,0,0,0,0,0,0,0,0,93,30,0,0,1,0,0,0,92,30,0,0,0,0,0,0,0,0,0,0,95,30,0,0,1,0,0,0,94,30,0,0,0,0,0,0,0,0,0,0,97,30,0,0,2,0,0,0,155,30,0,0,96,30,0,0,0,0,0,0,99,30,0,0,1,0,0,0,98,30,0,0,0,0,0,0,0,0,0,0,101,30,0,0,1,0,0,0,100,30,0,0,0,0,0,0,0,0,0,0,103,30,0,0,1,0,0,0,102,30,0,0,0,0,0,0,0,0,0,0,105,30,0,0,1,0,0,0,104,30,0,0,0,0,0,0,0,0,0,0,107,30,0,0,1,0,0,0,106,30,0,0,0,0,0,0,0,0,0,0,109,30,0,0,1,0,0,0,108,30,0,0,0,0,0,0,0,0,0,0,111,30,0,0,1,0,0,0,110,30,0,0,0,0,0,0,0,0,0,0,113,30,0,0,1,0,0,0,112,30,0,0,0,0,0,0,0,0,0,0,115,30,0,0,1,0,0,0,114,30,0,0,0,0,0,0,0,0,0,0,117,30,0,0,1,0,0,0,116,30,0,0,0,0,0,0,0,0,0,0,119,30,0,0,1,0,0,0,118,30,0,0,0,0,0,0,0,0,0,0,121,30,0,0,1,0,0,0,120,30,0,0,0,0,0,0,0,0,0,0,123,30,0,0,1,0,0,0,122,30,0,0,0,0,0,0,0,0,0,0,125,30,0,0,1,0,0,0,124,30,0,0,0,0,0,0,0,0,0,0,127,30,0,0,1,0,0,0,126,30,0,0,0,0,0,0,0,0,0,0,129,30,0,0,1,0,0,0,128,30,0,0,0,0,0,0,0,0,0,0,131,30,0,0,1,0,0,0,130,30,0,0,0,0,0,0,0,0,0,0,133,30,0,0,1,0,0,0,132,30,0,0,0,0,0,0,0,0,0,0,135,30,0,0,1,0,0,0,134,30,0,0,0,0,0,0,0,0,0,0,137,30,0,0,1,0,0,0,136,30,0,0,0,0,0,0,0,0,0,0,139,30,0,0,1,0,0,0,138,30,0,0,0,0,0,0,0,0,0,0,141,30,0,0,1,0,0,0,140,30,0,0,0,0,0,0,0,0,0,0,143,30,0,0,1,0,0,0,142,30,0,0,0,0,0,0,0,0,0,0,145,30,0,0,1,0,0,0,144,30,0,0,0,0,0,0,0,0,0,0,147,30,0,0,1,0,0,0,146,30,0,0,0,0,0,0,0,0,0,0,149,30,0,0,1,0,0,0,148,30,0,0,0,0,0,0,0,0,0,0,161,30,0,0,1,0,0,0,160,30,0,0,0,0,0,0,0,0,0,0,163,30,0,0,1,0,0,0,162,30,0,0,0,0,0,0,0,0,0,0,165,30,0,0,1,0,0,0,164,30,0,0,0,0,0,0,0,0,0,0,167,30,0,0,1,0,0,0,166,30,0,0,0,0,0,0,0,0,0,0,169,30,0,0,1,0,0,0,168,30,0,0,0,0,0,0,0,0,0,0,171,30,0,0,1,0,0,0,170,30,0,0,0,0,0,0,0,0,0,0,173,30,0,0,1,0,0,0,172,30,0,0,0,0,0,0,0,0,0,0,175,30,0,0,1,0,0,0,174,30,0,0,0,0,0,0,0,0,0,0,177,30,0,0,1,0,0,0,176,30,0,0,0,0,0,0,0,0,0,0,179,30,0,0,1,0,0,0,178,30,0,0,0,0,0,0,0,0,0,0,181,30,0,0,1,0,0,0,180,30,0,0,0,0,0,0,0,0,0,0,183,30,0,0,1,0,0,0,182,30,0,0,0,0,0,0,0,0,0,0,185,30,0,0,1,0,0,0,184,30,0,0,0,0,0,0,0,0,0,0,187,30,0,0,1,0,0,0,186,30,0,0,0,0,0,0,0,0,0,0,189,30,0,0,1,0,0,0,188,30,0,0,0,0,0,0,0,0,0,0,191,30,0,0,1,0,0,0,190,30,0,0,0,0,0,0,0,0,0,0,193,30,0,0,1,0,0,0,192,30,0,0,0,0,0,0,0,0,0,0,195,30,0,0,1,0,0,0,194,30,0,0,0,0,0,0,0,0,0,0,197,30,0,0,1,0,0,0,196,30,0,0,0,0,0,0,0,0,0,0,199,30,0,0,1,0,0,0,198,30,0,0,0,0,0,0,0,0,0,0,201,30,0,0,1,0,0,0,200,30,0,0,0,0,0,0,0,0,0,0,203,30,0,0,1,0,0,0,202,30,0,0,0,0,0,0,0,0,0,0,205,30,0,0,1,0,0,0,204,30,0,0,0,0,0,0,0,0,0,0,207,30,0,0,1,0,0,0,206,30,0,0,0,0,0,0,0,0,0,0,209,30,0,0,1,0,0,0,208,30,0,0,0,0,0,0,0,0,0,0,211,30,0,0,1,0,0,0,210,30,0,0,0,0,0,0,0,0,0,0,213,30,0,0,1,0,0,0,212,30,0,0,0,0,0,0,0,0,0,0,215,30,0,0,1,0,0,0,214,30,0,0,0,0,0,0,0,0,0,0,217,30,0,0,1,0,0,0,216,30,0,0,0,0,0,0,0,0,0,0,219,30,0,0,1,0,0,0,218,30,0,0,0,0,0,0,0,0,0,0,221,30,0,0,1,0,0,0,220,30,0,0,0,0,0,0,0,0,0,0,223,30,0,0,1,0,0,0,222,30,0,0,0,0,0,0,0,0,0,0,225,30,0,0,1,0,0,0,224,30,0,0,0,0,0,0,0,0,0,0,227,30,0,0,1,0,0,0,226,30,0,0,0,0,0,0,0,0,0,0,229,30,0,0,1,0,0,0,228,30,0,0,0,0,0,0,0,0,0,0,231,30,0,0,1,0,0,0,230,30,0,0,0,0,0,0,0,0,0,0,233,30,0,0,1,0,0,0,232,30,0,0,0,0,0,0,0,0,0,0,235,30,0,0,1,0,0,0,234,30,0,0,0,0,0,0,0,0,0,0,237,30,0,0,1,0,0,0,236,30,0,0,0,0,0,0,0,0,0,0,239,30,0,0,1,0,0,0,238,30,0,0,0,0,0,0,0,0,0,0,241,30,0,0,1,0,0,0,240,30,0,0,0,0,0,0,0,0,0,0,243,30,0,0,1,0,0,0,242,30,0,0,0,0,0,0,0,0,0,0,245,30,0,0,1,0,0,0,244,30,0,0,0,0,0,0,0,0,0,0,247,30,0,0,1,0,0,0,246,30,0,0,0,0,0,0,0,0,0,0,249,30,0,0,1,0,0,0,248,30,0,0,0,0,0,0,0,0,0,0,0,31,0,0,1,0,0,0,8,31,0,0,0,0,0,0,0,0,0,0,1,31,0,0,1,0,0,0,9,31,0,0,0,0,0,0,0,0,0,0,2,31,0,0,1,0,0,0,10,31,0,0,0,0,0,0,0,0,0,0,3,31,0,0,1,0,0,0,11,31,0,0,0,0,0,0,0,0,0,0,4,31,0,0,1,0,0,0,12,31,0,0,0,0,0,0,0,0,0,0,5,31,0,0,1,0,0,0,13,31,0,0,0,0,0,0,0,0,0,0,6,31,0,0,1,0,0,0,14,31,0,0,0,0,0,0,0,0,0,0,7,31,0,0,1,0,0,0,15,31,0,0,0,0,0,0,0,0,0,0,16,31,0,0,1,0,0,0,24,31,0,0,0,0,0,0,0,0,0,0,17,31,0,0,1,0,0,0,25,31,0,0,0,0,0,0,0,0,0,0,18,31,0,0,1,0,0,0,26,31,0,0,0,0,0,0,0,0,0,0,19,31,0,0,1,0,0,0,27,31,0,0,0,0,0,0,0,0,0,0,20,31,0,0,1,0,0,0,28,31,0,0,0,0,0,0,0,0,0,0,21,31,0,0,1,0,0,0,29,31,0,0,0,0,0,0,0,0,0,0,32,31,0,0,1,0,0,0,40,31,0,0,0,0,0,0,0,0,0,0,33,31,0,0,1,0,0,0,41,31,0,0,0,0,0,0,0,0,0,0,34,31,0,0,1,0,0,0,42,31,0,0,0,0,0,0,0,0,0,0,35,31,0,0,1,0,0,0,43,31,0,0,0,0,0,0,0,0,0,0,36,31,0,0,1,0,0,0,44,31,0,0,0,0,0,0,0,0,0,0,37,31,0,0,1,0,0,0,45,31,0,0,0,0,0,0,0,0,0,0,38,31,0,0,1,0,0,0,46,31,0,0,0,0,0,0,0,0,0,0,39,31,0,0,1,0,0,0,47,31,0,0,0,0,0,0,0,0,0,0,48,31,0,0,1,0,0,0,56,31,0,0,0,0,0,0,0,0,0,0,49,31,0,0,1,0,0,0,57,31,0,0,0,0,0,0,0,0,0,0,50,31,0,0,1,0,0,0,58,31,0,0,0,0,0,0,0,0,0,0,51,31,0,0,1,0,0,0,59,31,0,0,0,0,0,0,0,0,0,0,52,31,0,0,1,0,0,0,60,31,0,0,0,0,0,0,0,0,0,0,53,31,0,0,1,0,0,0,61,31,0,0,0,0,0,0,0,0,0,0,54,31,0,0,1,0,0,0,62,31,0,0,0,0,0,0,0,0,0,0,55,31,0,0,1,0,0,0,63,31,0,0,0,0,0,0,0,0,0,0,64,31,0,0,1,0,0,0,72,31,0,0,0,0,0,0,0,0,0,0,65,31,0,0,1,0,0,0,73,31,0,0,0,0,0,0,0,0,0,0,66,31,0,0,1,0,0,0,74,31,0,0,0,0,0,0,0,0,0,0,67,31,0,0,1,0,0,0,75,31,0,0,0,0,0,0,0,0,0,0,68,31,0,0,1,0,0,0,76,31,0,0,0,0,0,0,0,0,0,0,69,31,0,0,1,0,0,0,77,31,0,0,0,0,0,0,0,0,0,0,81,31,0,0,1,0,0,0,89,31,0,0,0,0,0,0,0,0,0,0,83,31,0,0,1,0,0,0,91,31,0,0,0,0,0,0,0,0,0,0,85,31,0,0,1,0,0,0,93,31,0,0,0,0,0,0,0,0,0,0,87,31,0,0,1,0,0,0,95,31,0,0,0,0,0,0,0,0,0,0,96,31,0,0,1,0,0,0,104,31,0,0,0,0,0,0,0,0,0,0,97,31,0,0,1,0,0,0,105,31,0,0,0,0,0,0,0,0,0,0,98,31,0,0,1,0,0,0,106,31,0,0,0,0,0,0,0,0,0,0,99,31,0,0,1,0,0,0,107,31,0,0,0,0,0,0,0,0,0,0,100,31,0,0,1,0,0,0,108,31,0,0,0,0,0,0,0,0,0,0,101,31,0,0,1,0,0,0,109,31,0,0,0,0,0,0,0,0,0,0,102,31,0,0,1,0,0,0,110,31,0,0,0,0,0,0,0,0,0,0,103,31,0,0,1,0,0,0,111,31,0,0,0,0,0,0,0,0,0,0,112,31,0,0,1,0,0,0,186,31,0,0,0,0,0,0,0,0,0,0,113,31,0,0,1,0,0,0,187,31,0,0,0,0,0,0,0,0,0,0,114,31,0,0,1,0,0,0,200,31,0,0,0,0,0,0,0,0,0,0,115,31,0,0,1,0,0,0,201,31,0,0,0,0,0,0,0,0,0,0,116,31,0,0,1,0,0,0,202,31,0,0,0,0,0,0,0,0,0,0,117,31,0,0,1,0,0,0,203,31,0,0,0,0,0,0,0,0,0,0,118,31,0,0,1,0,0,0,218,31,0,0,0,0,0,0,0,0,0,0,119,31,0,0,1,0,0,0,219,31,0,0,0,0,0,0,0,0,0,0,120,31,0,0,1,0,0,0,248,31,0,0,0,0,0,0,0,0,0,0,121,31,0,0,1,0,0,0,249,31,0,0,0,0,0,0,0,0,0,0,122,31,0,0,1,0,0,0,234,31,0,0,0,0,0,0,0,0,0,0,123,31,0,0,1,0,0,0,235,31,0,0,0,0,0,0,0,0,0,0,124,31,0,0,1,0,0,0,250,31,0,0,0,0,0,0,0,0,0,0,125,31,0,0,1,0,0,0,251,31,0,0,0,0,0,0,0,0,0,0,176,31,0,0,1,0,0,0,184,31,0,0,0,0,0,0,0,0,0,0,177,31,0,0,1,0,0,0,185,31,0,0,0,0,0,0,0,0,0,0,208,31,0,0,1,0,0,0,216,31,0,0,0,0,0,0,0,0,0,0,209,31,0,0,1,0,0,0,217,31,0,0,0,0,0,0,0,0,0,0,224,31,0,0,1,0,0,0,232,31,0,0,0,0,0,0,0,0,0,0,225,31,0,0,1,0,0,0,233,31,0,0,0,0,0,0,0,0,0,0,229,31,0,0,1,0,0,0,236,31,0,0,0,0,0,0,0,0,0,0,112,33,0,0,1,0,0,0,96,33,0,0,0,0,0,0,0,0,0,0,113,33,0,0,1,0,0,0,97,33,0,0,0,0,0,0,0,0,0,0,114,33,0,0,1,0,0,0,98,33,0,0,0,0,0,0,0,0,0,0,115,33,0,0,1,0,0,0,99,33,0,0,0,0,0,0,0,0,0,0,116,33,0,0,1,0,0,0,100,33,0,0,0,0,0,0,0,0,0,0,117,33,0,0,1,0,0,0,101,33,0,0,0,0,0,0,0,0,0,0,118,33,0,0,1,0,0,0,102,33,0,0,0,0,0,0,0,0,0,0,119,33,0,0,1,0,0,0,103,33,0,0,0,0,0,0,0,0,0,0,120,33,0,0,1,0,0,0,104,33,0,0,0,0,0,0,0,0,0,0,121,33,0,0,1,0,0,0,105,33,0,0,0,0,0,0,0,0,0,0,122,33,0,0,1,0,0,0,106,33,0,0,0,0,0,0,0,0,0,0,123,33,0,0,1,0,0,0,107,33,0,0,0,0,0,0,0,0,0,0,124,33,0,0,1,0,0,0,108,33,0,0,0,0,0,0,0,0,0,0,125,33,0,0,1,0,0,0,109,33,0,0,0,0,0,0,0,0,0,0,126,33,0,0,1,0,0,0,110,33,0,0,0,0,0,0,0,0,0,0,127,33,0,0,1,0,0,0,111,33,0,0,0,0,0,0,0,0,0,0,208,36,0,0,1,0,0,0,182,36,0,0,0,0,0,0,0,0,0,0,209,36,0,0,1,0,0,0,183,36,0,0,0,0,0,0,0,0,0,0,210,36,0,0,1,0,0,0,184,36,0,0,0,0,0,0,0,0,0,0,211,36,0,0,1,0,0,0,185,36,0,0,0,0,0,0,0,0,0,0,212,36,0,0,1,0,0,0,186,36,0,0,0,0,0,0,0,0,0,0,213,36,0,0,1,0,0,0,187,36,0,0,0,0,0,0,0,0,0,0,214,36,0,0,1,0,0,0,188,36,0,0,0,0,0,0,0,0,0,0,215,36,0,0,1,0,0,0,189,36,0,0,0,0,0,0,0,0,0,0,216,36,0,0,1,0,0,0,190,36,0,0,0,0,0,0,0,0,0,0,217,36,0,0,1,0,0,0,191,36,0,0,0,0,0,0,0,0,0,0,218,36,0,0,1,0,0,0,192,36,0,0,0,0,0,0,0,0,0,0,219,36,0,0,1,0,0,0,193,36,0,0,0,0,0,0,0,0,0,0,220,36,0,0,1,0,0,0,194,36,0,0,0,0,0,0,0,0,0,0,221,36,0,0,1,0,0,0,195,36,0,0,0,0,0,0,0,0,0,0,222,36,0,0,1,0,0,0,196,36,0,0,0,0,0,0,0,0,0,0,223,36,0,0,1,0,0,0,197,36,0,0,0,0,0,0,0,0,0,0,224,36,0,0,1,0,0,0,198,36,0,0,0,0,0,0,0,0,0,0,225,36,0,0,1,0,0,0,199,36,0,0,0,0,0,0,0,0,0,0,226,36,0,0,1,0,0,0,200,36,0,0,0,0,0,0,0,0,0,0,227,36,0,0,1,0,0,0,201,36,0,0,0,0,0,0,0,0,0,0,228,36,0,0,1,0,0,0,202,36,0,0,0,0,0,0,0,0,0,0,229,36,0,0,1,0,0,0,203,36,0,0,0,0,0,0,0,0,0,0,230,36,0,0,1,0,0,0,204,36,0,0,0,0,0,0,0,0,0,0,231,36,0,0,1,0,0,0,205,36,0,0,0,0,0,0,0,0,0,0,232,36,0,0,1,0,0,0,206,36,0,0,0,0,0,0,0,0,0,0,233,36,0,0,1,0,0,0,207,36,0,0,0,0,0,0,0,0,0,0,48,44,0,0,1,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,49,44,0,0,1,0,0,0,1,44,0,0,0,0,0,0,0,0,0,0,50,44,0,0,1,0,0,0,2,44,0,0,0,0,0,0,0,0,0,0,51,44,0,0,1,0,0,0,3,44,0,0,0,0,0,0,0,0,0,0,52,44,0,0,1,0,0,0,4,44,0,0,0,0,0,0,0,0,0,0,53,44,0,0,1,0,0,0,5,44,0,0,0,0,0,0,0,0,0,0,54,44,0,0,1,0,0,0,6,44,0,0,0,0,0,0,0,0,0,0,55,44,0,0,1,0,0,0,7,44,0,0,0,0,0,0,0,0,0,0,56,44,0,0,1,0,0,0,8,44,0,0,0,0,0,0,0,0,0,0,57,44,0,0,1,0,0,0,9,44,0,0,0,0,0,0,0,0,0,0,58,44,0,0,1,0,0,0,10,44,0,0,0,0,0,0,0,0,0,0,59,44,0,0,1,0,0,0,11,44,0,0,0,0,0,0,0,0,0,0,60,44,0,0,1,0,0,0,12,44,0,0,0,0,0,0,0,0,0,0,61,44,0,0,1,0,0,0,13,44,0,0,0,0,0,0,0,0,0,0,62,44,0,0,1,0,0,0,14,44,0,0,0,0,0,0,0,0,0,0,63,44,0,0,1,0,0,0,15,44,0,0,0,0,0,0,0,0,0,0,64,44,0,0,1,0,0,0,16,44,0,0,0,0,0,0,0,0,0,0,65,44,0,0,1,0,0,0,17,44,0,0,0,0,0,0,0,0,0,0,66,44,0,0,1,0,0,0,18,44,0,0,0,0,0,0,0,0,0,0,67,44,0,0,1,0,0,0,19,44,0,0,0,0,0,0,0,0,0,0,68,44,0,0,1,0,0,0,20,44,0,0,0,0,0,0,0,0,0,0,69,44,0,0,1,0,0,0,21,44,0,0,0,0,0,0,0,0,0,0,70,44,0,0,1,0,0,0,22,44,0,0,0,0,0,0,0,0,0,0,71,44,0,0,1,0,0,0,23,44,0,0,0,0,0,0,0,0,0,0,72,44,0,0,1,0,0,0,24,44,0,0,0,0,0,0,0,0,0,0,73,44,0,0,1,0,0,0,25,44,0,0,0,0,0,0,0,0,0,0,74,44,0,0,1,0,0,0,26,44,0,0,0,0,0,0,0,0,0,0,75,44,0,0,1,0,0,0,27,44,0,0,0,0,0,0,0,0,0,0,76,44,0,0,1,0,0,0,28,44,0,0,0,0,0,0,0,0,0,0,77,44,0,0,1,0,0,0,29,44,0,0,0,0,0,0,0,0,0,0,78,44,0,0,1,0,0,0,30,44,0,0,0,0,0,0,0,0,0,0,79,44,0,0,1,0,0,0,31,44,0,0,0,0,0,0,0,0,0,0,80,44,0,0,1,0,0,0,32,44,0,0,0,0,0,0,0,0,0,0,81,44,0,0,1,0,0,0,33,44,0,0,0,0,0,0,0,0,0,0,82,44,0,0,1,0,0,0,34,44,0,0,0,0,0,0,0,0,0,0,83,44,0,0,1,0,0,0,35,44,0,0,0,0,0,0,0,0,0,0,84,44,0,0,1,0,0,0,36,44,0,0,0,0,0,0,0,0,0,0,85,44,0,0,1,0,0,0,37,44,0,0,0,0,0,0,0,0,0,0,86,44,0,0,1,0,0,0,38,44,0,0,0,0,0,0,0,0,0,0,87,44,0,0,1,0,0,0,39,44,0,0,0,0,0,0,0,0,0,0,88,44,0,0,1,0,0,0,40,44,0,0,0,0,0,0,0,0,0,0,89,44,0,0,1,0,0,0,41,44,0,0,0,0,0,0,0,0,0,0,90,44,0,0,1,0,0,0,42,44,0,0,0,0,0,0,0,0,0,0,91,44,0,0,1,0,0,0,43,44,0,0,0,0,0,0,0,0,0,0,92,44,0,0,1,0,0,0,44,44,0,0,0,0,0,0,0,0,0,0,93,44,0,0,1,0,0,0,45,44,0,0,0,0,0,0,0,0,0,0,94,44,0,0,1,0,0,0,46,44,0,0,0,0,0,0,0,0,0,0,129,44,0,0,1,0,0,0,128,44,0,0,0,0,0,0,0,0,0,0,131,44,0,0,1,0,0,0,130,44,0,0,0,0,0,0,0,0,0,0,133,44,0,0,1,0,0,0,132,44,0,0,0,0,0,0,0,0,0,0,135,44,0,0,1,0,0,0,134,44,0,0,0,0,0,0,0,0,0,0,137,44,0,0,1,0,0,0,136,44,0,0,0,0,0,0,0,0,0,0,139,44,0,0,1,0,0,0,138,44,0,0,0,0,0,0,0,0,0,0,141,44,0,0,1,0,0,0,140,44,0,0,0,0,0,0,0,0,0,0,143,44,0,0,1,0,0,0,142,44,0,0,0,0,0,0,0,0,0,0,145,44,0,0,1,0,0,0,144,44,0,0,0,0,0,0,0,0,0,0,147,44,0,0,1,0,0,0,146,44,0,0,0,0,0,0,0,0,0,0,149,44,0,0,1,0,0,0,148,44,0,0,0,0,0,0,0,0,0,0,151,44,0,0,1,0,0,0,150,44,0,0,0,0,0,0,0,0,0,0,153,44,0,0,1,0,0,0,152,44,0,0,0,0,0,0,0,0,0,0,155,44,0,0,1,0,0,0,154,44,0,0,0,0,0,0,0,0,0,0,157,44,0,0,1,0,0,0,156,44,0,0,0,0,0,0,0,0,0,0,159,44,0,0,1,0,0,0,158,44,0,0,0,0,0,0,0,0,0,0,161,44,0,0,1,0,0,0,160,44,0,0,0,0,0,0,0,0,0,0,163,44,0,0,1,0,0,0,162,44,0,0,0,0,0,0,0,0,0,0,165,44,0,0,1,0,0,0,164,44,0,0,0,0,0,0,0,0,0,0,167,44,0,0,1,0,0,0,166,44,0,0,0,0,0,0,0,0,0,0,169,44,0,0,1,0,0,0,168,44,0,0,0,0,0,0,0,0,0,0,171,44,0,0,1,0,0,0,170,44,0,0,0,0,0,0,0,0,0,0,173,44,0,0,1,0,0,0,172,44,0,0,0,0,0,0,0,0,0,0,175,44,0,0,1,0,0,0,174,44,0,0,0,0,0,0,0,0,0,0,177,44,0,0,1,0,0,0,176,44,0,0,0,0,0,0,0,0,0,0,179,44,0,0,1,0,0,0,178,44,0,0,0,0,0,0,0,0,0,0,181,44,0,0,1,0,0,0,180,44,0,0,0,0,0,0,0,0,0,0,183,44,0,0,1,0,0,0,182,44,0,0,0,0,0,0,0,0,0,0,185,44,0,0,1,0,0,0,184,44,0,0,0,0,0,0,0,0,0,0,187,44,0,0,1,0,0,0,186,44,0,0,0,0,0,0,0,0,0,0,189,44,0,0,1,0,0,0,188,44,0,0,0,0,0,0,0,0,0,0,191,44,0,0,1,0,0,0,190,44,0,0,0,0,0,0,0,0,0,0,193,44,0,0,1,0,0,0,192,44,0,0,0,0,0,0,0,0,0,0,195,44,0,0,1,0,0,0,194,44,0,0,0,0,0,0,0,0,0,0,197,44,0,0,1,0,0,0,196,44,0,0,0,0,0,0,0,0,0,0,199,44,0,0,1,0,0,0,198,44,0,0,0,0,0,0,0,0,0,0,201,44,0,0,1,0,0,0,200,44,0,0,0,0,0,0,0,0,0,0,203,44,0,0,1,0,0,0,202,44,0,0,0,0,0,0,0,0,0,0,205,44,0,0,1,0,0,0,204,44,0,0,0,0,0,0,0,0,0,0,207,44,0,0,1,0,0,0,206,44,0,0,0,0,0,0,0,0,0,0,209,44,0,0,1,0,0,0,208,44,0,0,0,0,0,0,0,0,0,0,211,44,0,0,1,0,0,0,210,44,0,0,0,0,0,0,0,0,0,0,213,44,0,0,1,0,0,0,212,44,0,0,0,0,0,0,0,0,0,0,215,44,0,0,1,0,0,0,214,44,0,0,0,0,0,0,0,0,0,0,217,44,0,0,1,0,0,0,216,44,0,0,0,0,0,0,0,0,0,0,219,44,0,0,1,0,0,0,218,44,0,0,0,0,0,0,0,0,0,0,221,44,0,0,1,0,0,0,220,44,0,0,0,0,0,0,0,0,0,0,223,44,0,0,1,0,0,0,222,44,0,0,0,0,0,0,0,0,0,0,225,44,0,0,1,0,0,0,224,44,0,0,0,0,0,0,0,0,0,0,227,44,0,0,1,0,0,0,226,44,0,0,0,0,0,0,0,0,0,0,0,45,0,0,1,0,0,0,160,16,0,0,0,0,0,0,0,0,0,0,1,45,0,0,1,0,0,0,161,16,0,0,0,0,0,0,0,0,0,0,2,45,0,0,1,0,0,0,162,16,0,0,0,0,0,0,0,0,0,0,3,45,0,0,1,0,0,0,163,16,0,0,0,0,0,0,0,0,0,0,4,45,0,0,1,0,0,0,164,16,0,0,0,0,0,0,0,0,0,0,5,45,0,0,1,0,0,0,165,16,0,0,0,0,0,0,0,0,0,0,6,45,0,0,1,0,0,0,166,16,0,0,0,0,0,0,0,0,0,0,7,45,0,0,1,0,0,0,167,16,0,0,0,0,0,0,0,0,0,0,8,45,0,0,1,0,0,0,168,16,0,0,0,0,0,0,0,0,0,0,9,45,0,0,1,0,0,0,169,16,0,0,0,0,0,0,0,0,0,0,10,45,0,0,1,0,0,0,170,16,0,0,0,0,0,0,0,0,0,0,11,45,0,0,1,0,0,0,171,16,0,0,0,0,0,0,0,0,0,0,12,45,0,0,1,0,0,0,172,16,0,0,0,0,0,0,0,0,0,0,13,45,0,0,1,0,0,0,173,16,0,0,0,0,0,0,0,0,0,0,14,45,0,0,1,0,0,0,174,16,0,0,0,0,0,0,0,0,0,0,15,45,0,0,1,0,0,0,175,16,0,0,0,0,0,0,0,0,0,0,16,45,0,0,1,0,0,0,176,16,0,0,0,0,0,0,0,0,0,0,17,45,0,0,1,0,0,0,177,16,0,0,0,0,0,0,0,0,0,0,18,45,0,0,1,0,0,0,178,16,0,0,0,0,0,0,0,0,0,0,19,45,0,0,1,0,0,0,179,16,0,0,0,0,0,0,0,0,0,0,20,45,0,0,1,0,0,0,180,16,0,0,0,0,0,0,0,0,0,0,21,45,0,0,1,0,0,0,181,16,0,0,0,0,0,0,0,0,0,0,22,45,0,0,1,0,0,0,182,16,0,0,0,0,0,0,0,0,0,0,23,45,0,0,1,0,0,0,183,16,0,0,0,0,0,0,0,0,0,0,24,45,0,0,1,0,0,0,184,16,0,0,0,0,0,0,0,0,0,0,25,45,0,0,1,0,0,0,185,16,0,0,0,0,0,0,0,0,0,0,26,45,0,0,1,0,0,0,186,16,0,0,0,0,0,0,0,0,0,0,27,45,0,0,1,0,0,0,187,16,0,0,0,0,0,0,0,0,0,0,28,45,0,0,1,0,0,0,188,16,0,0,0,0,0,0,0,0,0,0,29,45,0,0,1,0,0,0,189,16,0,0,0,0,0,0,0,0,0,0,30,45,0,0,1,0,0,0,190,16,0,0,0,0,0,0,0,0,0,0,31,45,0,0,1,0,0,0,191,16,0,0,0,0,0,0,0,0,0,0,32,45,0,0,1,0,0,0,192,16,0,0,0,0,0,0,0,0,0,0,33,45,0,0,1,0,0,0,193,16,0,0,0,0,0,0,0,0,0,0,34,45,0,0,1,0,0,0,194,16,0,0,0,0,0,0,0,0,0,0,35,45,0,0,1,0,0,0,195,16,0,0,0,0,0,0,0,0,0,0,36,45,0,0,1,0,0,0,196,16,0,0,0,0,0,0,0,0,0,0,37,45,0,0,1,0,0,0,197,16,0,0,0,0,0,0,0,0,0,0,65,255,0,0,1,0,0,0,33,255,0,0,0,0,0,0,0,0,0,0,66,255,0,0,1,0,0,0,34,255,0,0,0,0,0,0,0,0,0,0,67,255,0,0,1,0,0,0,35,255,0,0,0,0,0,0,0,0,0,0,68,255,0,0,1,0,0,0,36,255,0,0,0,0,0,0,0,0,0,0,69,255,0,0,1,0,0,0,37,255,0,0,0,0,0,0,0,0,0,0,70,255,0,0,1,0,0,0,38,255,0,0,0,0,0,0,0,0,0,0,71,255,0,0,1,0,0,0,39,255,0,0,0,0,0,0,0,0,0,0,72,255,0,0,1,0,0,0,40,255,0,0,0,0,0,0,0,0,0,0,73,255,0,0,1,0,0,0,41,255,0,0,0,0,0,0,0,0,0,0,74,255,0,0,1,0,0,0,42,255,0,0,0,0,0,0,0,0,0,0,75,255,0,0,1,0,0,0,43,255,0,0,0,0,0,0,0,0,0,0,76,255,0,0,1,0,0,0,44,255,0,0,0,0,0,0,0,0,0,0,77,255,0,0,1,0,0,0,45,255,0,0,0,0,0,0,0,0,0,0,78,255,0,0,1,0,0,0,46,255,0,0,0,0,0,0,0,0,0,0,79,255,0,0,1,0,0,0,47,255,0,0,0,0,0,0,0,0,0,0,80,255,0,0,1,0,0,0,48,255,0,0,0,0,0,0,0,0,0,0,81,255,0,0,1,0,0,0,49,255,0,0,0,0,0,0,0,0,0,0,82,255,0,0,1,0,0,0,50,255,0,0,0,0,0,0,0,0,0,0,83,255,0,0,1,0,0,0,51,255,0,0,0,0,0,0,0,0,0,0,84,255,0,0,1,0,0,0,52,255,0,0,0,0,0,0,0,0,0,0,85,255,0,0,1,0,0,0,53,255,0,0,0,0,0,0,0,0,0,0,86,255,0,0,1,0,0,0,54,255,0,0,0,0,0,0,0,0,0,0,87,255,0,0,1,0,0,0,55,255,0,0,0,0,0,0,0,0,0,0,88,255,0,0,1,0,0,0,56,255,0,0,0,0,0,0,0,0,0,0,89,255,0,0,1,0,0,0,57,255,0,0,0,0,0,0,0,0,0,0,90,255,0,0,1,0,0,0,58,255,0,0,0,0,0,0,0,0,0,0,40,4,1,0,1,0,0,0,0,4,1,0,0,0,0,0,0,0,0,0,41,4,1,0,1,0,0,0,1,4,1,0,0,0,0,0,0,0,0,0,42,4,1,0,1,0,0,0,2,4,1,0,0,0,0,0,0,0,0,0,43,4,1,0,1,0,0,0,3,4,1,0,0,0,0,0,0,0,0,0,44,4,1,0,1,0,0,0,4,4,1,0,0,0,0,0,0,0,0,0,45,4,1,0,1,0,0,0,5,4,1,0,0,0,0,0,0,0,0,0,46,4,1,0,1,0,0,0,6,4,1,0,0,0,0,0,0,0,0,0,47,4,1,0,1,0,0,0,7,4,1,0,0,0,0,0,0,0,0,0,48,4,1,0,1,0,0,0,8,4,1,0,0,0,0,0,0,0,0,0,49,4,1,0,1,0,0,0,9,4,1,0,0,0,0,0,0,0,0,0,50,4,1,0,1,0,0,0,10,4,1,0,0,0,0,0,0,0,0,0,51,4,1,0,1,0,0,0,11,4,1,0,0,0,0,0,0,0,0,0,52,4,1,0,1,0,0,0,12,4,1,0,0,0,0,0,0,0,0,0,53,4,1,0,1,0,0,0,13,4,1,0,0,0,0,0,0,0,0,0,54,4,1,0,1,0,0,0,14,4,1,0,0,0,0,0,0,0,0,0,55,4,1,0,1,0,0,0,15,4,1,0,0,0,0,0,0,0,0,0,56,4,1,0,1,0,0,0,16,4,1,0,0,0,0,0,0,0,0,0,57,4,1,0,1,0,0,0,17,4,1,0,0,0,0,0,0,0,0,0,58,4,1,0,1,0,0,0,18,4,1,0,0,0,0,0,0,0,0,0,59,4,1,0,1,0,0,0,19,4,1,0,0,0,0,0,0,0,0,0,60,4,1,0,1,0,0,0,20,4,1,0,0,0,0,0,0,0,0,0,61,4,1,0,1,0,0,0,21,4,1,0,0,0,0,0,0,0,0,0,62,4,1,0,1,0,0,0,22,4,1,0,0,0,0,0,0,0,0,0,63,4,1,0,1,0,0,0,23,4,1,0,0,0,0,0,0,0,0,0,64,4,1,0,1,0,0,0,24,4,1,0,0,0,0,0,0,0,0,0,65,4,1,0,1,0,0,0,25,4,1,0,0,0,0,0,0,0,0,0,66,4,1,0,1,0,0,0,26,4,1,0,0,0,0,0,0,0,0,0,67,4,1,0,1,0,0,0,27,4,1,0,0,0,0,0,0,0,0,0,68,4,1,0,1,0,0,0,28,4,1,0,0,0,0,0,0,0,0,0,69,4,1,0,1,0,0,0,29,4,1,0,0,0,0,0,0,0,0,0,70,4,1,0,1,0,0,0,30,4,1,0,0,0,0,0,0,0,0,0,71,4,1,0,1,0,0,0,31,4,1,0,0,0,0,0,0,0,0,0,72,4,1,0,1,0,0,0,32,4,1,0,0,0,0,0,0,0,0,0,73,4,1,0,1,0,0,0,33,4,1,0,0,0,0,0,0,0,0,0,74,4,1,0,1,0,0,0,34,4,1,0,0,0,0,0,0,0,0,0,75,4,1,0,1,0,0,0,35,4,1,0,0,0,0,0,0,0,0,0,76,4,1,0,1,0,0,0,36,4,1,0,0,0,0,0,0,0,0,0,77,4,1,0,1,0,0,0,37,4,1,0,0,0,0,0,0,0,0,0,78,4,1,0,1,0,0,0,38,4,1,0,0,0,0,0,0,0,0,0,79,4,1,0,1,0,0,0,39,4,1,0,0,0,0,0,0,0,0,0,105,0,0,0,1,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,97,0,0,0,190,2,0,0,1,0,0,0,154,30,0,0,0,0,0,0,102,0,0,0,102,0,0,0,1,0,0,0,0,251,0,0,0,0,0,0,102,0,0,0,105,0,0,0,1,0,0,0,1,251,0,0,0,0,0,0,102,0,0,0,108,0,0,0,1,0,0,0,2,251,0,0,0,0,0,0,104,0,0,0,49,3,0,0,1,0,0,0,150,30,0,0,0,0,0,0,106,0,0,0,12,3,0,0,1,0,0,0,240,1,0,0,0,0,0,0,115,0,0,0,115,0,0,0,1,0,0,0,223,0,0,0,0,0,0,0,115,0,0,0,116,0,0,0,2,0,0,0,5,251,0,0,6,251,0,0,116,0,0,0,8,3,0,0,1,0,0,0,151,30,0,0,0,0,0,0,119,0,0,0,10,3,0,0,1,0,0,0,152,30,0,0,0,0,0,0,121,0,0,0,10,3,0,0,1,0,0,0,153,30,0,0,0,0,0,0,188,2,0,0,110,0,0,0,1,0,0,0,73,1,0,0,0,0,0,0,172,3,0,0,185,3,0,0,1,0,0,0,180,31,0,0,0,0,0,0,174,3,0,0,185,3,0,0,1,0,0,0,196,31,0,0,0,0,0,0,177,3,0,0,66,3,0,0,1,0,0,0,182,31,0,0,0,0,0,0,177,3,0,0,185,3,0,0,2,0,0,0,179,31,0,0,188,31,0,0,183,3,0,0,66,3,0,0,1,0,0,0,198,31,0,0,0,0,0,0,183,3,0,0,185,3,0,0,2,0,0,0,195,31,0,0,204,31,0,0,185,3,0,0,66,3,0,0,1,0,0,0,214,31,0,0,0,0,0,0,193,3,0,0,19,3,0,0,1,0,0,0,228,31,0,0,0,0,0,0,197,3,0,0,19,3,0,0,1,0,0,0,80,31,0,0,0,0,0,0,197,3,0,0,66,3,0,0,1,0,0,0,230,31,0,0,0,0,0,0,201,3,0,0,66,3,0,0,1,0,0,0,246,31,0,0,0,0,0,0,201,3,0,0,185,3,0,0,2,0,0,0,243,31,0,0,252,31,0,0,206,3,0,0,185,3,0,0,1,0,0,0,244,31,0,0,0,0,0,0,101,5,0,0,130,5,0,0,1,0,0,0,135,5,0,0,0,0,0,0,116,5,0,0,101,5,0,0,1,0,0,0,20,251,0,0,0,0,0,0,116,5,0,0,107,5,0,0,1,0,0,0,21,251,0,0,0,0,0,0,116,5,0,0,109,5,0,0,1,0,0,0,23,251,0,0,0,0,0,0,116,5,0,0,118,5,0,0,1,0,0,0,19,251,0,0,0,0,0,0,126,5,0,0,118,5,0,0,1,0,0,0,22,251,0,0,0,0,0,0,0,31,0,0,185,3,0,0,2,0,0,0,136,31,0,0,128,31,0,0,1,31,0,0,185,3,0,0,2,0,0,0,129,31,0,0,137,31,0,0,2,31,0,0,185,3,0,0,2,0,0,0,130,31,0,0,138,31,0,0,3,31,0,0,185,3,0,0,2,0,0,0,131,31,0,0,139,31,0,0,4,31,0,0,185,3,0,0,2,0,0,0,132,31,0,0,140,31,0,0,5,31,0,0,185,3,0,0,2,0,0,0,133,31,0,0,141,31,0,0,6,31,0,0,185,3,0,0,2,0,0,0,134,31,0,0,142,31,0,0,7,31,0,0,185,3,0,0,2,0,0,0,135,31,0,0,143,31,0,0,32,31,0,0,185,3,0,0,2,0,0,0,144,31,0,0,152,31,0,0,33,31,0,0,185,3,0,0,2,0,0,0,145,31,0,0,153,31,0,0,34,31,0,0,185,3,0,0,2,0,0,0,146,31,0,0,154,31,0,0,35,31,0,0,185,3,0,0,2,0,0,0,147,31,0,0,155,31,0,0,36,31,0,0,185,3,0,0,2,0,0,0,148,31,0,0,156,31,0,0,37,31,0,0,185,3,0,0,2,0,0,0,149,31,0,0,157,31,0,0,38,31,0,0,185,3,0,0,2,0,0,0,150,31,0,0,158,31,0,0,39,31,0,0,185,3,0,0,2,0,0,0,151,31,0,0,159,31,0,0,96,31,0,0,185,3,0,0,2,0,0,0,160,31,0,0,168,31,0,0,97,31,0,0,185,3,0,0,2,0,0,0,161,31,0,0,169,31,0,0,98,31,0,0,185,3,0,0,2,0,0,0,162,31,0,0,170,31,0,0,99,31,0,0,185,3,0,0,2,0,0,0,163,31,0,0,171,31,0,0,100,31,0,0,185,3,0,0,2,0,0,0,164,31,0,0,172,31,0,0,101,31,0,0,185,3,0,0,2,0,0,0,165,31,0,0,173,31,0,0,102,31,0,0,185,3,0,0,2,0,0,0,166,31,0,0,174,31,0,0,103,31,0,0,185,3,0,0,2,0,0,0,167,31,0,0,175,31,0,0,112,31,0,0,185,3,0,0,1,0,0,0,178,31,0,0,0,0,0,0,116,31,0,0,185,3,0,0,1,0,0,0,194,31,0,0,0,0,0,0,124,31,0,0,185,3,0,0,1,0,0,0,242,31,0,0,0,0,0,0,105,0,0,0,7,3,0,0,1,0,0,0,48,1,0,0,0,0,0,0,102,0,0,0,102,0,0,0,105,0,0,0,1,0,0,0,3,251,0,0,0,0,0,0,102,0,0,0,102,0,0,0,108,0,0,0,1,0,0,0,4,251,0,0,0,0,0,0,177,3,0,0,66,3,0,0,185,3,0,0,1,0,0,0,183,31,0,0,0,0,0,0,183,3,0,0,66,3,0,0,185,3,0,0,1,0,0,0,199,31,0,0,0,0,0,0,185,3,0,0,8,3,0,0,0,3,0,0,1,0,0,0,210,31,0,0,0,0,0,0,185,3,0,0,8,3,0,0,1,3,0,0,2,0,0,0,144,3,0,0,211,31,0,0,185,3,0,0,8,3,0,0,66,3,0,0,1,0,0,0,215,31,0,0,0,0,0,0,197,3,0,0,8,3,0,0,0,3,0,0,1,0,0,0,226,31,0,0,0,0,0,0,197,3,0,0,8,3,0,0,1,3,0,0,2,0,0,0,176,3,0,0,227,31,0,0,197,3,0,0,8,3,0,0,66,3,0,0,1,0,0,0,231,31,0,0,0,0,0,0,197,3,0,0,19,3,0,0,0,3,0,0,1,0,0,0,82,31,0,0,0,0,0,0,197,3,0,0,19,3,0,0,1,3,0,0,1,0,0,0,84,31,0,0,0,0,0,0,197,3,0,0,19,3,0,0,66,3,0,0,1,0,0,0,86,31,0,0,0,0,0,0,201,3,0,0,66,3,0,0,185,3,0,0,1,0,0,0,247,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,1,0,0,0,97], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+345468);
/* memory initializer */ allocate([66,0,0,0,1,0,0,0,98,0,0,0,0,0,0,0,0,0,0,0,67,0,0,0,1,0,0,0,99,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,69,0,0,0,1,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,70,0,0,0,1,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,71,0,0,0,1,0,0,0,103,0,0,0,0,0,0,0,0,0,0,0,72,0,0,0,1,0,0,0,104,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,1,0,0,0,106,0,0,0,0,0,0,0,0,0,0,0,75,0,0,0,1,0,0,0,107,0,0,0,0,0,0,0,0,0,0,0,76,0,0,0,1,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,77,0,0,0,1,0,0,0,109,0,0,0,0,0,0,0,0,0,0,0,78,0,0,0,1,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,1,0,0,0,111,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,1,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,81,0,0,0,1,0,0,0,113,0,0,0,0,0,0,0,0,0,0,0,82,0,0,0,1,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,1,0,0,0,115,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,1,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,1,0,0,0,117,0,0,0,0,0,0,0,0,0,0,0,86,0,0,0,1,0,0,0,118,0,0,0,0,0,0,0,0,0,0,0,87,0,0,0,1,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,88,0,0,0,1,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,89,0,0,0,1,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,90,0,0,0,1,0,0,0,122,0,0,0,0,0,0,0,0,0,0,0,181,0,0,0,1,0,0,0,188,3,0,0,0,0,0,0,0,0,0,0,192,0,0,0,1,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,193,0,0,0,1,0,0,0,225,0,0,0,0,0,0,0,0,0,0,0,194,0,0,0,1,0,0,0,226,0,0,0,0,0,0,0,0,0,0,0,195,0,0,0,1,0,0,0,227,0,0,0,0,0,0,0,0,0,0,0,196,0,0,0,1,0,0,0,228,0,0,0,0,0,0,0,0,0,0,0,197,0,0,0,1,0,0,0,229,0,0,0,0,0,0,0,0,0,0,0,198,0,0,0,1,0,0,0,230,0,0,0,0,0,0,0,0,0,0,0,199,0,0,0,1,0,0,0,231,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,1,0,0,0,232,0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,1,0,0,0,233,0,0,0,0,0,0,0,0,0,0,0,202,0,0,0,1,0,0,0,234,0,0,0,0,0,0,0,0,0,0,0,203,0,0,0,1,0,0,0,235,0,0,0,0,0,0,0,0,0,0,0,204,0,0,0,1,0,0,0,236,0,0,0,0,0,0,0,0,0,0,0,205,0,0,0,1,0,0,0,237,0,0,0,0,0,0,0,0,0,0,0,206,0,0,0,1,0,0,0,238,0,0,0,0,0,0,0,0,0,0,0,207,0,0,0,1,0,0,0,239,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,1,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,209,0,0,0,1,0,0,0,241,0,0,0,0,0,0,0,0,0,0,0,210,0,0,0,1,0,0,0,242,0,0,0,0,0,0,0,0,0,0,0,211,0,0,0,1,0,0,0,243,0,0,0,0,0,0,0,0,0,0,0,212,0,0,0,1,0,0,0,244,0,0,0,0,0,0,0,0,0,0,0,213,0,0,0,1,0,0,0,245,0,0,0,0,0,0,0,0,0,0,0,214,0,0,0,1,0,0,0,246,0,0,0,0,0,0,0,0,0,0,0,216,0,0,0,1,0,0,0,248,0,0,0,0,0,0,0,0,0,0,0,217,0,0,0,1,0,0,0,249,0,0,0,0,0,0,0,0,0,0,0,218,0,0,0,1,0,0,0,250,0,0,0,0,0,0,0,0,0,0,0,219,0,0,0,1,0,0,0,251,0,0,0,0,0,0,0,0,0,0,0,220,0,0,0,1,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,221,0,0,0,1,0,0,0,253,0,0,0,0,0,0,0,0,0,0,0,222,0,0,0,1,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,223,0,0,0,2,0,0,0,115,0,0,0,115,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,2,1,0,0,1,0,0,0,3,1,0,0,0,0,0,0,0,0,0,0,4,1,0,0,1,0,0,0,5,1,0,0,0,0,0,0,0,0,0,0,6,1,0,0,1,0,0,0,7,1,0,0,0,0,0,0,0,0,0,0,8,1,0,0,1,0,0,0,9,1,0,0,0,0,0,0,0,0,0,0,10,1,0,0,1,0,0,0,11,1,0,0,0,0,0,0,0,0,0,0,12,1,0,0,1,0,0,0,13,1,0,0,0,0,0,0,0,0,0,0,14,1,0,0,1,0,0,0,15,1,0,0,0,0,0,0,0,0,0,0,16,1,0,0,1,0,0,0,17,1,0,0,0,0,0,0,0,0,0,0,18,1,0,0,1,0,0,0,19,1,0,0,0,0,0,0,0,0,0,0,20,1,0,0,1,0,0,0,21,1,0,0,0,0,0,0,0,0,0,0,22,1,0,0,1,0,0,0,23,1,0,0,0,0,0,0,0,0,0,0,24,1,0,0,1,0,0,0,25,1,0,0,0,0,0,0,0,0,0,0,26,1,0,0,1,0,0,0,27,1,0,0,0,0,0,0,0,0,0,0,28,1,0,0,1,0,0,0,29,1,0,0,0,0,0,0,0,0,0,0,30,1,0,0,1,0,0,0,31,1,0,0,0,0,0,0,0,0,0,0,32,1,0,0,1,0,0,0,33,1,0,0,0,0,0,0,0,0,0,0,34,1,0,0,1,0,0,0,35,1,0,0,0,0,0,0,0,0,0,0,36,1,0,0,1,0,0,0,37,1,0,0,0,0,0,0,0,0,0,0,38,1,0,0,1,0,0,0,39,1,0,0,0,0,0,0,0,0,0,0,40,1,0,0,1,0,0,0,41,1,0,0,0,0,0,0,0,0,0,0,42,1,0,0,1,0,0,0,43,1,0,0,0,0,0,0,0,0,0,0,44,1,0,0,1,0,0,0,45,1,0,0,0,0,0,0,0,0,0,0,46,1,0,0,1,0,0,0,47,1,0,0,0,0,0,0,0,0,0,0,50,1,0,0,1,0,0,0,51,1,0,0,0,0,0,0,0,0,0,0,52,1,0,0,1,0,0,0,53,1,0,0,0,0,0,0,0,0,0,0,54,1,0,0,1,0,0,0,55,1,0,0,0,0,0,0,0,0,0,0,57,1,0,0,1,0,0,0,58,1,0,0,0,0,0,0,0,0,0,0,59,1,0,0,1,0,0,0,60,1,0,0,0,0,0,0,0,0,0,0,61,1,0,0,1,0,0,0,62,1,0,0,0,0,0,0,0,0,0,0,63,1,0,0,1,0,0,0,64,1,0,0,0,0,0,0,0,0,0,0,65,1,0,0,1,0,0,0,66,1,0,0,0,0,0,0,0,0,0,0,67,1,0,0,1,0,0,0,68,1,0,0,0,0,0,0,0,0,0,0,69,1,0,0,1,0,0,0,70,1,0,0,0,0,0,0,0,0,0,0,71,1,0,0,1,0,0,0,72,1,0,0,0,0,0,0,0,0,0,0,73,1,0,0,2,0,0,0,188,2,0,0,110,0,0,0,0,0,0,0,74,1,0,0,1,0,0,0,75,1,0,0,0,0,0,0,0,0,0,0,76,1,0,0,1,0,0,0,77,1,0,0,0,0,0,0,0,0,0,0,78,1,0,0,1,0,0,0,79,1,0,0,0,0,0,0,0,0,0,0,80,1,0,0,1,0,0,0,81,1,0,0,0,0,0,0,0,0,0,0,82,1,0,0,1,0,0,0,83,1,0,0,0,0,0,0,0,0,0,0,84,1,0,0,1,0,0,0,85,1,0,0,0,0,0,0,0,0,0,0,86,1,0,0,1,0,0,0,87,1,0,0,0,0,0,0,0,0,0,0,88,1,0,0,1,0,0,0,89,1,0,0,0,0,0,0,0,0,0,0,90,1,0,0,1,0,0,0,91,1,0,0,0,0,0,0,0,0,0,0,92,1,0,0,1,0,0,0,93,1,0,0,0,0,0,0,0,0,0,0,94,1,0,0,1,0,0,0,95,1,0,0,0,0,0,0,0,0,0,0,96,1,0,0,1,0,0,0,97,1,0,0,0,0,0,0,0,0,0,0,98,1,0,0,1,0,0,0,99,1,0,0,0,0,0,0,0,0,0,0,100,1,0,0,1,0,0,0,101,1,0,0,0,0,0,0,0,0,0,0,102,1,0,0,1,0,0,0,103,1,0,0,0,0,0,0,0,0,0,0,104,1,0,0,1,0,0,0,105,1,0,0,0,0,0,0,0,0,0,0,106,1,0,0,1,0,0,0,107,1,0,0,0,0,0,0,0,0,0,0,108,1,0,0,1,0,0,0,109,1,0,0,0,0,0,0,0,0,0,0,110,1,0,0,1,0,0,0,111,1,0,0,0,0,0,0,0,0,0,0,112,1,0,0,1,0,0,0,113,1,0,0,0,0,0,0,0,0,0,0,114,1,0,0,1,0,0,0,115,1,0,0,0,0,0,0,0,0,0,0,116,1,0,0,1,0,0,0,117,1,0,0,0,0,0,0,0,0,0,0,118,1,0,0,1,0,0,0,119,1,0,0,0,0,0,0,0,0,0,0,120,1,0,0,1,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,121,1,0,0,1,0,0,0,122,1,0,0,0,0,0,0,0,0,0,0,123,1,0,0,1,0,0,0,124,1,0,0,0,0,0,0,0,0,0,0,125,1,0,0,1,0,0,0,126,1,0,0,0,0,0,0,0,0,0,0,127,1,0,0,1,0,0,0,115,0,0,0,0,0,0,0,0,0,0,0,129,1,0,0,1,0,0,0,83,2,0,0,0,0,0,0,0,0,0,0,130,1,0,0,1,0,0,0,131,1,0,0,0,0,0,0,0,0,0,0,132,1,0,0,1,0,0,0,133,1,0,0,0,0,0,0,0,0,0,0,134,1,0,0,1,0,0,0,84,2,0,0,0,0,0,0,0,0,0,0,135,1,0,0,1,0,0,0,136,1,0,0,0,0,0,0,0,0,0,0,137,1,0,0,1,0,0,0,86,2,0,0,0,0,0,0,0,0,0,0,138,1,0,0,1,0,0,0,87,2,0,0,0,0,0,0,0,0,0,0,139,1,0,0,1,0,0,0,140,1,0,0,0,0,0,0,0,0,0,0,142,1,0,0,1,0,0,0,221,1,0,0,0,0,0,0,0,0,0,0,143,1,0,0,1,0,0,0,89,2,0,0,0,0,0,0,0,0,0,0,144,1,0,0,1,0,0,0,91,2,0,0,0,0,0,0,0,0,0,0,145,1,0,0,1,0,0,0,146,1,0,0,0,0,0,0,0,0,0,0,147,1,0,0,1,0,0,0,96,2,0,0,0,0,0,0,0,0,0,0,148,1,0,0,1,0,0,0,99,2,0,0,0,0,0,0,0,0,0,0,150,1,0,0,1,0,0,0,105,2,0,0,0,0,0,0,0,0,0,0,151,1,0,0,1,0,0,0,104,2,0,0,0,0,0,0,0,0,0,0,152,1,0,0,1,0,0,0,153,1,0,0,0,0,0,0,0,0,0,0,156,1,0,0,1,0,0,0,111,2,0,0,0,0,0,0,0,0,0,0,157,1,0,0,1,0,0,0,114,2,0,0,0,0,0,0,0,0,0,0,159,1,0,0,1,0,0,0,117,2,0,0,0,0,0,0,0,0,0,0,160,1,0,0,1,0,0,0,161,1,0,0,0,0,0,0,0,0,0,0,162,1,0,0,1,0,0,0,163,1,0,0,0,0,0,0,0,0,0,0,164,1,0,0,1,0,0,0,165,1,0,0,0,0,0,0,0,0,0,0,166,1,0,0,1,0,0,0,128,2,0,0,0,0,0,0,0,0,0,0,167,1,0,0,1,0,0,0,168,1,0,0,0,0,0,0,0,0,0,0,169,1,0,0,1,0,0,0,131,2,0,0,0,0,0,0,0,0,0,0,172,1,0,0,1,0,0,0,173,1,0,0,0,0,0,0,0,0,0,0,174,1,0,0,1,0,0,0,136,2,0,0,0,0,0,0,0,0,0,0,175,1,0,0,1,0,0,0,176,1,0,0,0,0,0,0,0,0,0,0,177,1,0,0,1,0,0,0,138,2,0,0,0,0,0,0,0,0,0,0,178,1,0,0,1,0,0,0,139,2,0,0,0,0,0,0,0,0,0,0,179,1,0,0,1,0,0,0,180,1,0,0,0,0,0,0,0,0,0,0,181,1,0,0,1,0,0,0,182,1,0,0,0,0,0,0,0,0,0,0,183,1,0,0,1,0,0,0,146,2,0,0,0,0,0,0,0,0,0,0,184,1,0,0,1,0,0,0,185,1,0,0,0,0,0,0,0,0,0,0,188,1,0,0,1,0,0,0,189,1,0,0,0,0,0,0,0,0,0,0,196,1,0,0,1,0,0,0,198,1,0,0,0,0,0,0,0,0,0,0,197,1,0,0,1,0,0,0,198,1,0,0,0,0,0,0,0,0,0,0,199,1,0,0,1,0,0,0,201,1,0,0,0,0,0,0,0,0,0,0,200,1,0,0,1,0,0,0,201,1,0,0,0,0,0,0,0,0,0,0,202,1,0,0,1,0,0,0,204,1,0,0,0,0,0,0,0,0,0,0,203,1,0,0,1,0,0,0,204,1,0,0,0,0,0,0,0,0,0,0,205,1,0,0,1,0,0,0,206,1,0,0,0,0,0,0,0,0,0,0,207,1,0,0,1,0,0,0,208,1,0,0,0,0,0,0,0,0,0,0,209,1,0,0,1,0,0,0,210,1,0,0,0,0,0,0,0,0,0,0,211,1,0,0,1,0,0,0,212,1,0,0,0,0,0,0,0,0,0,0,213,1,0,0,1,0,0,0,214,1,0,0,0,0,0,0,0,0,0,0,215,1,0,0,1,0,0,0,216,1,0,0,0,0,0,0,0,0,0,0,217,1,0,0,1,0,0,0,218,1,0,0,0,0,0,0,0,0,0,0,219,1,0,0,1,0,0,0,220,1,0,0,0,0,0,0,0,0,0,0,222,1,0,0,1,0,0,0,223,1,0,0,0,0,0,0,0,0,0,0,224,1,0,0,1,0,0,0,225,1,0,0,0,0,0,0,0,0,0,0,226,1,0,0,1,0,0,0,227,1,0,0,0,0,0,0,0,0,0,0,228,1,0,0,1,0,0,0,229,1,0,0,0,0,0,0,0,0,0,0,230,1,0,0,1,0,0,0,231,1,0,0,0,0,0,0,0,0,0,0,232,1,0,0,1,0,0,0,233,1,0,0,0,0,0,0,0,0,0,0,234,1,0,0,1,0,0,0,235,1,0,0,0,0,0,0,0,0,0,0,236,1,0,0,1,0,0,0,237,1,0,0,0,0,0,0,0,0,0,0,238,1,0,0,1,0,0,0,239,1,0,0,0,0,0,0,0,0,0,0,240,1,0,0,2,0,0,0,106,0,0,0,12,3,0,0,0,0,0,0,241,1,0,0,1,0,0,0,243,1,0,0,0,0,0,0,0,0,0,0,242,1,0,0,1,0,0,0,243,1,0,0,0,0,0,0,0,0,0,0,244,1,0,0,1,0,0,0,245,1,0,0,0,0,0,0,0,0,0,0,246,1,0,0,1,0,0,0,149,1,0,0,0,0,0,0,0,0,0,0,247,1,0,0,1,0,0,0,191,1,0,0,0,0,0,0,0,0,0,0,248,1,0,0,1,0,0,0,249,1,0,0,0,0,0,0,0,0,0,0,250,1,0,0,1,0,0,0,251,1,0,0,0,0,0,0,0,0,0,0,252,1,0,0,1,0,0,0,253,1,0,0,0,0,0,0,0,0,0,0,254,1,0,0,1,0,0,0,255,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,4,2,0,0,1,0,0,0,5,2,0,0,0,0,0,0,0,0,0,0,6,2,0,0,1,0,0,0,7,2,0,0,0,0,0,0,0,0,0,0,8,2,0,0,1,0,0,0,9,2,0,0,0,0,0,0,0,0,0,0,10,2,0,0,1,0,0,0,11,2,0,0,0,0,0,0,0,0,0,0,12,2,0,0,1,0,0,0,13,2,0,0,0,0,0,0,0,0,0,0,14,2,0,0,1,0,0,0,15,2,0,0,0,0,0,0,0,0,0,0,16,2,0,0,1,0,0,0,17,2,0,0,0,0,0,0,0,0,0,0,18,2,0,0,1,0,0,0,19,2,0,0,0,0,0,0,0,0,0,0,20,2,0,0,1,0,0,0,21,2,0,0,0,0,0,0,0,0,0,0,22,2,0,0,1,0,0,0,23,2,0,0,0,0,0,0,0,0,0,0,24,2,0,0,1,0,0,0,25,2,0,0,0,0,0,0,0,0,0,0,26,2,0,0,1,0,0,0,27,2,0,0,0,0,0,0,0,0,0,0,28,2,0,0,1,0,0,0,29,2,0,0,0,0,0,0,0,0,0,0,30,2,0,0,1,0,0,0,31,2,0,0,0,0,0,0,0,0,0,0,32,2,0,0,1,0,0,0,158,1,0,0,0,0,0,0,0,0,0,0,34,2,0,0,1,0,0,0,35,2,0,0,0,0,0,0,0,0,0,0,36,2,0,0,1,0,0,0,37,2,0,0,0,0,0,0,0,0,0,0,38,2,0,0,1,0,0,0,39,2,0,0,0,0,0,0,0,0,0,0,40,2,0,0,1,0,0,0,41,2,0,0,0,0,0,0,0,0,0,0,42,2,0,0,1,0,0,0,43,2,0,0,0,0,0,0,0,0,0,0,44,2,0,0,1,0,0,0,45,2,0,0,0,0,0,0,0,0,0,0,46,2,0,0,1,0,0,0,47,2,0,0,0,0,0,0,0,0,0,0,48,2,0,0,1,0,0,0,49,2,0,0,0,0,0,0,0,0,0,0,50,2,0,0,1,0,0,0,51,2,0,0,0,0,0,0,0,0,0,0,59,2,0,0,1,0,0,0,60,2,0,0,0,0,0,0,0,0,0,0,61,2,0,0,1,0,0,0,154,1,0,0,0,0,0,0,0,0,0,0,65,2,0,0,1,0,0,0,148,2,0,0,0,0,0,0,0,0,0,0,69,3,0,0,1,0,0,0,185,3,0,0,0,0,0,0,0,0,0,0,134,3,0,0,1,0,0,0,172,3,0,0,0,0,0,0,0,0,0,0,136,3,0,0,1,0,0,0,173,3,0,0,0,0,0,0,0,0,0,0,137,3,0,0,1,0,0,0,174,3,0,0,0,0,0,0,0,0,0,0,138,3,0,0,1,0,0,0,175,3,0,0,0,0,0,0,0,0,0,0,140,3,0,0,1,0,0,0,204,3,0,0,0,0,0,0,0,0,0,0,142,3,0,0,1,0,0,0,205,3,0,0,0,0,0,0,0,0,0,0,143,3,0,0,1,0,0,0,206,3,0,0,0,0,0,0,0,0,0,0,144,3,0,0,3,0,0,0,185,3,0,0,8,3,0,0,1,3,0,0,145,3,0,0,1,0,0,0,177,3,0,0,0,0,0,0,0,0,0,0,146,3,0,0,1,0,0,0,178,3,0,0,0,0,0,0,0,0,0,0,147,3,0,0,1,0,0,0,179,3,0,0,0,0,0,0,0,0,0,0,148,3,0,0,1,0,0,0,180,3,0,0,0,0,0,0,0,0,0,0,149,3,0,0,1,0,0,0,181,3,0,0,0,0,0,0,0,0,0,0,150,3,0,0,1,0,0,0,182,3,0,0,0,0,0,0,0,0,0,0,151,3,0,0,1,0,0,0,183,3,0,0,0,0,0,0,0,0,0,0,152,3,0,0,1,0,0,0,184,3,0,0,0,0,0,0,0,0,0,0,153,3,0,0,1,0,0,0,185,3,0,0,0,0,0,0,0,0,0,0,154,3,0,0,1,0,0,0,186,3,0,0,0,0,0,0,0,0,0,0,155,3,0,0,1,0,0,0,187,3,0,0,0,0,0,0,0,0,0,0,156,3,0,0,1,0,0,0,188,3,0,0,0,0,0,0,0,0,0,0,157,3,0,0,1,0,0,0,189,3,0,0,0,0,0,0,0,0,0,0,158,3,0,0,1,0,0,0,190,3,0,0,0,0,0,0,0,0,0,0,159,3,0,0,1,0,0,0,191,3,0,0,0,0,0,0,0,0,0,0,160,3,0,0,1,0,0,0,192,3,0,0,0,0,0,0,0,0,0,0,161,3,0,0,1,0,0,0,193,3,0,0,0,0,0,0,0,0,0,0,163,3,0,0,1,0,0,0,195,3,0,0,0,0,0,0,0,0,0,0,164,3,0,0,1,0,0,0,196,3,0,0,0,0,0,0,0,0,0,0,165,3,0,0,1,0,0,0,197,3,0,0,0,0,0,0,0,0,0,0,166,3,0,0,1,0,0,0,198,3,0,0,0,0,0,0,0,0,0,0,167,3,0,0,1,0,0,0,199,3,0,0,0,0,0,0,0,0,0,0,168,3,0,0,1,0,0,0,200,3,0,0,0,0,0,0,0,0,0,0,169,3,0,0,1,0,0,0,201,3,0,0,0,0,0,0,0,0,0,0,170,3,0,0,1,0,0,0,202,3,0,0,0,0,0,0,0,0,0,0,171,3,0,0,1,0,0,0,203,3,0,0,0,0,0,0,0,0,0,0,176,3,0,0,3,0,0,0,197,3,0,0,8,3,0,0,1,3,0,0,194,3,0,0,1,0,0,0,195,3,0,0,0,0,0,0,0,0,0,0,208,3,0,0,1,0,0,0,178,3,0,0,0,0,0,0,0,0,0,0,209,3,0,0,1,0,0,0,184,3,0,0,0,0,0,0,0,0,0,0,213,3,0,0,1,0,0,0,198,3,0,0,0,0,0,0,0,0,0,0,214,3,0,0,1,0,0,0,192,3,0,0,0,0,0,0,0,0,0,0,216,3,0,0,1,0,0,0,217,3,0,0,0,0,0,0,0,0,0,0,218,3,0,0,1,0,0,0,219,3,0,0,0,0,0,0,0,0,0,0,220,3,0,0,1,0,0,0,221,3,0,0,0,0,0,0,0,0,0,0,222,3,0,0,1,0,0,0,223,3,0,0,0,0,0,0,0,0,0,0,224,3,0,0,1,0,0,0,225,3,0,0,0,0,0,0,0,0,0,0,226,3,0,0,1,0,0,0,227,3,0,0,0,0,0,0,0,0,0,0,228,3,0,0,1,0,0,0,229,3,0,0,0,0,0,0,0,0,0,0,230,3,0,0,1,0,0,0,231,3,0,0,0,0,0,0,0,0,0,0,232,3,0,0,1,0,0,0,233,3,0,0,0,0,0,0,0,0,0,0,234,3,0,0,1,0,0,0,235,3,0,0,0,0,0,0,0,0,0,0,236,3,0,0,1,0,0,0,237,3,0,0,0,0,0,0,0,0,0,0,238,3,0,0,1,0,0,0,239,3,0,0,0,0,0,0,0,0,0,0,240,3,0,0,1,0,0,0,186,3,0,0,0,0,0,0,0,0,0,0,241,3,0,0,1,0,0,0,193,3,0,0,0,0,0,0,0,0,0,0,244,3,0,0,1,0,0,0,184,3,0,0,0,0,0,0,0,0,0,0,245,3,0,0,1,0,0,0,181,3,0,0,0,0,0,0,0,0,0,0,247,3,0,0,1,0,0,0,248,3,0,0,0,0,0,0,0,0,0,0,249,3,0,0,1,0,0,0,242,3,0,0,0,0,0,0,0,0,0,0,250,3,0,0,1,0,0,0,251,3,0,0,0,0,0,0,0,0,0,0,0,4,0,0,1,0,0,0,80,4,0,0,0,0,0,0,0,0,0,0,1,4,0,0,1,0,0,0,81,4,0,0,0,0,0,0,0,0,0,0,2,4,0,0,1,0,0,0,82,4,0,0,0,0,0,0,0,0,0,0,3,4,0,0,1,0,0,0,83,4,0,0,0,0,0,0,0,0,0,0,4,4,0,0,1,0,0,0,84,4,0,0,0,0,0,0,0,0,0,0,5,4,0,0,1,0,0,0,85,4,0,0,0,0,0,0,0,0,0,0,6,4,0,0,1,0,0,0,86,4,0,0,0,0,0,0,0,0,0,0,7,4,0,0,1,0,0,0,87,4,0,0,0,0,0,0,0,0,0,0,8,4,0,0,1,0,0,0,88,4,0,0,0,0,0,0,0,0,0,0,9,4,0,0,1,0,0,0,89,4,0,0,0,0,0,0,0,0,0,0,10,4,0,0,1,0,0,0,90,4,0,0,0,0,0,0,0,0,0,0,11,4,0,0,1,0,0,0,91,4,0,0,0,0,0,0,0,0,0,0,12,4,0,0,1,0,0,0,92,4,0,0,0,0,0,0,0,0,0,0,13,4,0,0,1,0,0,0,93,4,0,0,0,0,0,0,0,0,0,0,14,4,0,0,1,0,0,0,94,4,0,0,0,0,0,0,0,0,0,0,15,4,0,0,1,0,0,0,95,4,0,0,0,0,0,0,0,0,0,0,16,4,0,0,1,0,0,0,48,4,0,0,0,0,0,0,0,0,0,0,17,4,0,0,1,0,0,0,49,4,0,0,0,0,0,0,0,0,0,0,18,4,0,0,1,0,0,0,50,4,0,0,0,0,0,0,0,0,0,0,19,4,0,0,1,0,0,0,51,4,0,0,0,0,0,0,0,0,0,0,20,4,0,0,1,0,0,0,52,4,0,0,0,0,0,0,0,0,0,0,21,4,0,0,1,0,0,0,53,4,0,0,0,0,0,0,0,0,0,0,22,4,0,0,1,0,0,0,54,4,0,0,0,0,0,0,0,0,0,0,23,4,0,0,1,0,0,0,55,4,0,0,0,0,0,0,0,0,0,0,24,4,0,0,1,0,0,0,56,4,0,0,0,0,0,0,0,0,0,0,25,4,0,0,1,0,0,0,57,4,0,0,0,0,0,0,0,0,0,0,26,4,0,0,1,0,0,0,58,4,0,0,0,0,0,0,0,0,0,0,27,4,0,0,1,0,0,0,59,4,0,0,0,0,0,0,0,0,0,0,28,4,0,0,1,0,0,0,60,4,0,0,0,0,0,0,0,0,0,0,29,4,0,0,1,0,0,0,61,4,0,0,0,0,0,0,0,0,0,0,30,4,0,0,1,0,0,0,62,4,0,0,0,0,0,0,0,0,0,0,31,4,0,0,1,0,0,0,63,4,0,0,0,0,0,0,0,0,0,0,32,4,0,0,1,0,0,0,64,4,0,0,0,0,0,0,0,0,0,0,33,4,0,0,1,0,0,0,65,4,0,0,0,0,0,0,0,0,0,0,34,4,0,0,1,0,0,0,66,4,0,0,0,0,0,0,0,0,0,0,35,4,0,0,1,0,0,0,67,4,0,0,0,0,0,0,0,0,0,0,36,4,0,0,1,0,0,0,68,4,0,0,0,0,0,0,0,0,0,0,37,4,0,0,1,0,0,0,69,4,0,0,0,0,0,0,0,0,0,0,38,4,0,0,1,0,0,0,70,4,0,0,0,0,0,0,0,0,0,0,39,4,0,0,1,0,0,0,71,4,0,0,0,0,0,0,0,0,0,0,40,4,0,0,1,0,0,0,72,4,0,0,0,0,0,0,0,0,0,0,41,4,0,0,1,0,0,0,73,4,0,0,0,0,0,0,0,0,0,0,42,4,0,0,1,0,0,0,74,4,0,0,0,0,0,0,0,0,0,0,43,4,0,0,1,0,0,0,75,4,0,0,0,0,0,0,0,0,0,0,44,4,0,0,1,0,0,0,76,4,0,0,0,0,0,0,0,0,0,0,45,4,0,0,1,0,0,0,77,4,0,0,0,0,0,0,0,0,0,0,46,4,0,0,1,0,0,0,78,4,0,0,0,0,0,0,0,0,0,0,47,4,0,0,1,0,0,0,79,4,0,0,0,0,0,0,0,0,0,0,96,4,0,0,1,0,0,0,97,4,0,0,0,0,0,0,0,0,0,0,98,4,0,0,1,0,0,0,99,4,0,0,0,0,0,0,0,0,0,0,100,4,0,0,1,0,0,0,101,4,0,0,0,0,0,0,0,0,0,0,102,4,0,0,1,0,0,0,103,4,0,0,0,0,0,0,0,0,0,0,104,4,0,0,1,0,0,0,105,4,0,0,0,0,0,0,0,0,0,0,106,4,0,0,1,0,0,0,107,4,0,0,0,0,0,0,0,0,0,0,108,4,0,0,1,0,0,0,109,4,0,0,0,0,0,0,0,0,0,0,110,4,0,0,1,0,0,0,111,4,0,0,0,0,0,0,0,0,0,0,112,4,0,0,1,0,0,0,113,4,0,0,0,0,0,0,0,0,0,0,114,4,0,0,1,0,0,0,115,4,0,0,0,0,0,0,0,0,0,0,116,4,0,0,1,0,0,0,117,4,0,0,0,0,0,0,0,0,0,0,118,4,0,0,1,0,0,0,119,4,0,0,0,0,0,0,0,0,0,0,120,4,0,0,1,0,0,0,121,4,0,0,0,0,0,0,0,0,0,0,122,4,0,0,1,0,0,0,123,4,0,0,0,0,0,0,0,0,0,0,124,4,0,0,1,0,0,0,125,4,0,0,0,0,0,0,0,0,0,0,126,4,0,0,1,0,0,0,127,4,0,0,0,0,0,0,0,0,0,0,128,4,0,0,1,0,0,0,129,4,0,0,0,0,0,0,0,0,0,0,138,4,0,0,1,0,0,0,139,4,0,0,0,0,0,0,0,0,0,0,140,4,0,0,1,0,0,0,141,4,0,0,0,0,0,0,0,0,0,0,142,4,0,0,1,0,0,0,143,4,0,0,0,0,0,0,0,0,0,0,144,4,0,0,1,0,0,0,145,4,0,0,0,0,0,0,0,0,0,0,146,4,0,0,1,0,0,0,147,4,0,0,0,0,0,0,0,0,0,0,148,4,0,0,1,0,0,0,149,4,0,0,0,0,0,0,0,0,0,0,150,4,0,0,1,0,0,0,151,4,0,0,0,0,0,0,0,0,0,0,152,4,0,0,1,0,0,0,153,4,0,0,0,0,0,0,0,0,0,0,154,4,0,0,1,0,0,0,155,4,0,0,0,0,0,0,0,0,0,0,156,4,0,0,1,0,0,0,157,4,0,0,0,0,0,0,0,0,0,0,158,4,0,0,1,0,0,0,159,4,0,0,0,0,0,0,0,0,0,0,160,4,0,0,1,0,0,0,161,4,0,0,0,0,0,0,0,0,0,0,162,4,0,0,1,0,0,0,163,4,0,0,0,0,0,0,0,0,0,0,164,4,0,0,1,0,0,0,165,4,0,0,0,0,0,0,0,0,0,0,166,4,0,0,1,0,0,0,167,4,0,0,0,0,0,0,0,0,0,0,168,4,0,0,1,0,0,0,169,4,0,0,0,0,0,0,0,0,0,0,170,4,0,0,1,0,0,0,171,4,0,0,0,0,0,0,0,0,0,0,172,4,0,0,1,0,0,0,173,4,0,0,0,0,0,0,0,0,0,0,174,4,0,0,1,0,0,0,175,4,0,0,0,0,0,0,0,0,0,0,176,4,0,0,1,0,0,0,177,4,0,0,0,0,0,0,0,0,0,0,178,4,0,0,1,0,0,0,179,4,0,0,0,0,0,0,0,0,0,0,180,4,0,0,1,0,0,0,181,4,0,0,0,0,0,0,0,0,0,0,182,4,0,0,1,0,0,0,183,4,0,0,0,0,0,0,0,0,0,0,184,4,0,0,1,0,0,0,185,4,0,0,0,0,0,0,0,0,0,0,186,4,0,0,1,0,0,0,187,4,0,0,0,0,0,0,0,0,0,0,188,4,0,0,1,0,0,0,189,4,0,0,0,0,0,0,0,0,0,0,190,4,0,0,1,0,0,0,191,4,0,0,0,0,0,0,0,0,0,0,193,4,0,0,1,0,0,0,194,4,0,0,0,0,0,0,0,0,0,0,195,4,0,0,1,0,0,0,196,4,0,0,0,0,0,0,0,0,0,0,197,4,0,0,1,0,0,0,198,4,0,0,0,0,0,0,0,0,0,0,199,4,0,0,1,0,0,0,200,4,0,0,0,0,0,0,0,0,0,0,201,4,0,0,1,0,0,0,202,4,0,0,0,0,0,0,0,0,0,0,203,4,0,0,1,0,0,0,204,4,0,0,0,0,0,0,0,0,0,0,205,4,0,0,1,0,0,0,206,4,0,0,0,0,0,0,0,0,0,0,208,4,0,0,1,0,0,0,209,4,0,0,0,0,0,0,0,0,0,0,210,4,0,0,1,0,0,0,211,4,0,0,0,0,0,0,0,0,0,0,212,4,0,0,1,0,0,0,213,4,0,0,0,0,0,0,0,0,0,0,214,4,0,0,1,0,0,0,215,4,0,0,0,0,0,0,0,0,0,0,216,4,0,0,1,0,0,0,217,4,0,0,0,0,0,0,0,0,0,0,218,4,0,0,1,0,0,0,219,4,0,0,0,0,0,0,0,0,0,0,220,4,0,0,1,0,0,0,221,4,0,0,0,0,0,0,0,0,0,0,222,4,0,0,1,0,0,0,223,4,0,0,0,0,0,0,0,0,0,0,224,4,0,0,1,0,0,0,225,4,0,0,0,0,0,0,0,0,0,0,226,4,0,0,1,0,0,0,227,4,0,0,0,0,0,0,0,0,0,0,228,4,0,0,1,0,0,0,229,4,0,0,0,0,0,0,0,0,0,0,230,4,0,0,1,0,0,0,231,4,0,0,0,0,0,0,0,0,0,0,232,4,0,0,1,0,0,0,233,4,0,0,0,0,0,0,0,0,0,0,234,4,0,0,1,0,0,0,235,4,0,0,0,0,0,0,0,0,0,0,236,4,0,0,1,0,0,0,237,4,0,0,0,0,0,0,0,0,0,0,238,4,0,0,1,0,0,0,239,4,0,0,0,0,0,0,0,0,0,0,240,4,0,0,1,0,0,0,241,4,0,0,0,0,0,0,0,0,0,0,242,4,0,0,1,0,0,0,243,4,0,0,0,0,0,0,0,0,0,0,244,4,0,0,1,0,0,0,245,4,0,0,0,0,0,0,0,0,0,0,246,4,0,0,1,0,0,0,247,4,0,0,0,0,0,0,0,0,0,0,248,4,0,0,1,0,0,0,249,4,0,0,0,0,0,0,0,0,0,0,0,5,0,0,1,0,0,0,1,5,0,0,0,0,0,0,0,0,0,0,2,5,0,0,1,0,0,0,3,5,0,0,0,0,0,0,0,0,0,0,4,5,0,0,1,0,0,0,5,5,0,0,0,0,0,0,0,0,0,0,6,5,0,0,1,0,0,0,7,5,0,0,0,0,0,0,0,0,0,0,8,5,0,0,1,0,0,0,9,5,0,0,0,0,0,0,0,0,0,0,10,5,0,0,1,0,0,0,11,5,0,0,0,0,0,0,0,0,0,0,12,5,0,0,1,0,0,0,13,5,0,0,0,0,0,0,0,0,0,0,14,5,0,0,1,0,0,0,15,5,0,0,0,0,0,0,0,0,0,0,49,5,0,0,1,0,0,0,97,5,0,0,0,0,0,0,0,0,0,0,50,5,0,0,1,0,0,0,98,5,0,0,0,0,0,0,0,0,0,0,51,5,0,0,1,0,0,0,99,5,0,0,0,0,0,0,0,0,0,0,52,5,0,0,1,0,0,0,100,5,0,0,0,0,0,0,0,0,0,0,53,5,0,0,1,0,0,0,101,5,0,0,0,0,0,0,0,0,0,0,54,5,0,0,1,0,0,0,102,5,0,0,0,0,0,0,0,0,0,0,55,5,0,0,1,0,0,0,103,5,0,0,0,0,0,0,0,0,0,0,56,5,0,0,1,0,0,0,104,5,0,0,0,0,0,0,0,0,0,0,57,5,0,0,1,0,0,0,105,5,0,0,0,0,0,0,0,0,0,0,58,5,0,0,1,0,0,0,106,5,0,0,0,0,0,0,0,0,0,0,59,5,0,0,1,0,0,0,107,5,0,0,0,0,0,0,0,0,0,0,60,5,0,0,1,0,0,0,108,5,0,0,0,0,0,0,0,0,0,0,61,5,0,0,1,0,0,0,109,5,0,0,0,0,0,0,0,0,0,0,62,5,0,0,1,0,0,0,110,5,0,0,0,0,0,0,0,0,0,0,63,5,0,0,1,0,0,0,111,5,0,0,0,0,0,0,0,0,0,0,64,5,0,0,1,0,0,0,112,5,0,0,0,0,0,0,0,0,0,0,65,5,0,0,1,0,0,0,113,5,0,0,0,0,0,0,0,0,0,0,66,5,0,0,1,0,0,0,114,5,0,0,0,0,0,0,0,0,0,0,67,5,0,0,1,0,0,0,115,5,0,0,0,0,0,0,0,0,0,0,68,5,0,0,1,0,0,0,116,5,0,0,0,0,0,0,0,0,0,0,69,5,0,0,1,0,0,0,117,5,0,0,0,0,0,0,0,0,0,0,70,5,0,0,1,0,0,0,118,5,0,0,0,0,0,0,0,0,0,0,71,5,0,0,1,0,0,0,119,5,0,0,0,0,0,0,0,0,0,0,72,5,0,0,1,0,0,0,120,5,0,0,0,0,0,0,0,0,0,0,73,5,0,0,1,0,0,0,121,5,0,0,0,0,0,0,0,0,0,0,74,5,0,0,1,0,0,0,122,5,0,0,0,0,0,0,0,0,0,0,75,5,0,0,1,0,0,0,123,5,0,0,0,0,0,0,0,0,0,0,76,5,0,0,1,0,0,0,124,5,0,0,0,0,0,0,0,0,0,0,77,5,0,0,1,0,0,0,125,5,0,0,0,0,0,0,0,0,0,0,78,5,0,0,1,0,0,0,126,5,0,0,0,0,0,0,0,0,0,0,79,5,0,0,1,0,0,0,127,5,0,0,0,0,0,0,0,0,0,0,80,5,0,0,1,0,0,0,128,5,0,0,0,0,0,0,0,0,0,0,81,5,0,0,1,0,0,0,129,5,0,0,0,0,0,0,0,0,0,0,82,5,0,0,1,0,0,0,130,5,0,0,0,0,0,0,0,0,0,0,83,5,0,0,1,0,0,0,131,5,0,0,0,0,0,0,0,0,0,0,84,5,0,0,1,0,0,0,132,5,0,0,0,0,0,0,0,0,0,0,85,5,0,0,1,0,0,0,133,5,0,0,0,0,0,0,0,0,0,0,86,5,0,0,1,0,0,0,134,5,0,0,0,0,0,0,0,0,0,0,135,5,0,0,2,0,0,0,101,5,0,0,130,5,0,0,0,0,0,0,160,16,0,0,1,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,161,16,0,0,1,0,0,0,1,45,0,0,0,0,0,0,0,0,0,0,162,16,0,0,1,0,0,0,2,45,0,0,0,0,0,0,0,0,0,0,163,16,0,0,1,0,0,0,3,45,0,0,0,0,0,0,0,0,0,0,164,16,0,0,1,0,0,0,4,45,0,0,0,0,0,0,0,0,0,0,165,16,0,0,1,0,0,0,5,45,0,0,0,0,0,0,0,0,0,0,166,16,0,0,1,0,0,0,6,45,0,0,0,0,0,0,0,0,0,0,167,16,0,0,1,0,0,0,7,45,0,0,0,0,0,0,0,0,0,0,168,16,0,0,1,0,0,0,8,45,0,0,0,0,0,0,0,0,0,0,169,16,0,0,1,0,0,0,9,45,0,0,0,0,0,0,0,0,0,0,170,16,0,0,1,0,0,0,10,45,0,0,0,0,0,0,0,0,0,0,171,16,0,0,1,0,0,0,11,45,0,0,0,0,0,0,0,0,0,0,172,16,0,0,1,0,0,0,12,45,0,0,0,0,0,0,0,0,0,0,173,16,0,0,1,0,0,0,13,45,0,0,0,0,0,0,0,0,0,0,174,16,0,0,1,0,0,0,14,45,0,0,0,0,0,0,0,0,0,0,175,16,0,0,1,0,0,0,15,45,0,0,0,0,0,0,0,0,0,0,176,16,0,0,1,0,0,0,16,45,0,0,0,0,0,0,0,0,0,0,177,16,0,0,1,0,0,0,17,45,0,0,0,0,0,0,0,0,0,0,178,16,0,0,1,0,0,0,18,45,0,0,0,0,0,0,0,0,0,0,179,16,0,0,1,0,0,0,19,45,0,0,0,0,0,0,0,0,0,0,180,16,0,0,1,0,0,0,20,45,0,0,0,0,0,0,0,0,0,0,181,16,0,0,1,0,0,0,21,45,0,0,0,0,0,0,0,0,0,0,182,16,0,0,1,0,0,0,22,45,0,0,0,0,0,0,0,0,0,0,183,16,0,0,1,0,0,0,23,45,0,0,0,0,0,0,0,0,0,0,184,16,0,0,1,0,0,0,24,45,0,0,0,0,0,0,0,0,0,0,185,16,0,0,1,0,0,0,25,45,0,0,0,0,0,0,0,0,0,0,186,16,0,0,1,0,0,0,26,45,0,0,0,0,0,0,0,0,0,0,187,16,0,0,1,0,0,0,27,45,0,0,0,0,0,0,0,0,0,0,188,16,0,0,1,0,0,0,28,45,0,0,0,0,0,0,0,0,0,0,189,16,0,0,1,0,0,0,29,45,0,0,0,0,0,0,0,0,0,0,190,16,0,0,1,0,0,0,30,45,0,0,0,0,0,0,0,0,0,0,191,16,0,0,1,0,0,0,31,45,0,0,0,0,0,0,0,0,0,0,192,16,0,0,1,0,0,0,32,45,0,0,0,0,0,0,0,0,0,0,193,16,0,0,1,0,0,0,33,45,0,0,0,0,0,0,0,0,0,0,194,16,0,0,1,0,0,0,34,45,0,0,0,0,0,0,0,0,0,0,195,16,0,0,1,0,0,0,35,45,0,0,0,0,0,0,0,0,0,0,196,16,0,0,1,0,0,0,36,45,0,0,0,0,0,0,0,0,0,0,197,16,0,0,1,0,0,0,37,45,0,0,0,0,0,0,0,0,0,0,0,30,0,0,1,0,0,0,1,30,0,0,0,0,0,0,0,0,0,0,2,30,0,0,1,0,0,0,3,30,0,0,0,0,0,0,0,0,0,0,4,30,0,0,1,0,0,0,5,30,0,0,0,0,0,0,0,0,0,0,6,30,0,0,1,0,0,0,7,30,0,0,0,0,0,0,0,0,0,0,8,30,0,0,1,0,0,0,9,30,0,0,0,0,0,0,0,0,0,0,10,30,0,0,1,0,0,0,11,30,0,0,0,0,0,0,0,0,0,0,12,30,0,0,1,0,0,0,13,30,0,0,0,0,0,0,0,0,0,0,14,30,0,0,1,0,0,0,15,30,0,0,0,0,0,0,0,0,0,0,16,30,0,0,1,0,0,0,17,30,0,0,0,0,0,0,0,0,0,0,18,30,0,0,1,0,0,0,19,30,0,0,0,0,0,0,0,0,0,0,20,30,0,0,1,0,0,0,21,30,0,0,0,0,0,0,0,0,0,0,22,30,0,0,1,0,0,0,23,30,0,0,0,0,0,0,0,0,0,0,24,30,0,0,1,0,0,0,25,30,0,0,0,0,0,0,0,0,0,0,26,30,0,0,1,0,0,0,27,30,0,0,0,0,0,0,0,0,0,0,28,30,0,0,1,0,0,0,29,30,0,0,0,0,0,0,0,0,0,0,30,30,0,0,1,0,0,0,31,30,0,0,0,0,0,0,0,0,0,0,32,30,0,0,1,0,0,0,33,30,0,0,0,0,0,0,0,0,0,0,34,30,0,0,1,0,0,0,35,30,0,0,0,0,0,0,0,0,0,0,36,30,0,0,1,0,0,0,37,30,0,0,0,0,0,0,0,0,0,0,38,30,0,0,1,0,0,0,39,30,0,0,0,0,0,0,0,0,0,0,40,30,0,0,1,0,0,0,41,30,0,0,0,0,0,0,0,0,0,0,42,30,0,0,1,0,0,0,43,30,0,0,0,0,0,0,0,0,0,0,44,30,0,0,1,0,0,0,45,30,0,0,0,0,0,0,0,0,0,0,46,30,0,0,1,0,0,0,47,30,0,0,0,0,0,0,0,0,0,0,48,30,0,0,1,0,0,0,49,30,0,0,0,0,0,0,0,0,0,0,50,30,0,0,1,0,0,0,51,30,0,0,0,0,0,0,0,0,0,0,52,30,0,0,1,0,0,0,53,30,0,0,0,0,0,0,0,0,0,0,54,30,0,0,1,0,0,0,55,30,0,0,0,0,0,0,0,0,0,0,56,30,0,0,1,0,0,0,57,30], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+355716);
/* memory initializer */ allocate([58,30,0,0,1,0,0,0,59,30,0,0,0,0,0,0,0,0,0,0,60,30,0,0,1,0,0,0,61,30,0,0,0,0,0,0,0,0,0,0,62,30,0,0,1,0,0,0,63,30,0,0,0,0,0,0,0,0,0,0,64,30,0,0,1,0,0,0,65,30,0,0,0,0,0,0,0,0,0,0,66,30,0,0,1,0,0,0,67,30,0,0,0,0,0,0,0,0,0,0,68,30,0,0,1,0,0,0,69,30,0,0,0,0,0,0,0,0,0,0,70,30,0,0,1,0,0,0,71,30,0,0,0,0,0,0,0,0,0,0,72,30,0,0,1,0,0,0,73,30,0,0,0,0,0,0,0,0,0,0,74,30,0,0,1,0,0,0,75,30,0,0,0,0,0,0,0,0,0,0,76,30,0,0,1,0,0,0,77,30,0,0,0,0,0,0,0,0,0,0,78,30,0,0,1,0,0,0,79,30,0,0,0,0,0,0,0,0,0,0,80,30,0,0,1,0,0,0,81,30,0,0,0,0,0,0,0,0,0,0,82,30,0,0,1,0,0,0,83,30,0,0,0,0,0,0,0,0,0,0,84,30,0,0,1,0,0,0,85,30,0,0,0,0,0,0,0,0,0,0,86,30,0,0,1,0,0,0,87,30,0,0,0,0,0,0,0,0,0,0,88,30,0,0,1,0,0,0,89,30,0,0,0,0,0,0,0,0,0,0,90,30,0,0,1,0,0,0,91,30,0,0,0,0,0,0,0,0,0,0,92,30,0,0,1,0,0,0,93,30,0,0,0,0,0,0,0,0,0,0,94,30,0,0,1,0,0,0,95,30,0,0,0,0,0,0,0,0,0,0,96,30,0,0,1,0,0,0,97,30,0,0,0,0,0,0,0,0,0,0,98,30,0,0,1,0,0,0,99,30,0,0,0,0,0,0,0,0,0,0,100,30,0,0,1,0,0,0,101,30,0,0,0,0,0,0,0,0,0,0,102,30,0,0,1,0,0,0,103,30,0,0,0,0,0,0,0,0,0,0,104,30,0,0,1,0,0,0,105,30,0,0,0,0,0,0,0,0,0,0,106,30,0,0,1,0,0,0,107,30,0,0,0,0,0,0,0,0,0,0,108,30,0,0,1,0,0,0,109,30,0,0,0,0,0,0,0,0,0,0,110,30,0,0,1,0,0,0,111,30,0,0,0,0,0,0,0,0,0,0,112,30,0,0,1,0,0,0,113,30,0,0,0,0,0,0,0,0,0,0,114,30,0,0,1,0,0,0,115,30,0,0,0,0,0,0,0,0,0,0,116,30,0,0,1,0,0,0,117,30,0,0,0,0,0,0,0,0,0,0,118,30,0,0,1,0,0,0,119,30,0,0,0,0,0,0,0,0,0,0,120,30,0,0,1,0,0,0,121,30,0,0,0,0,0,0,0,0,0,0,122,30,0,0,1,0,0,0,123,30,0,0,0,0,0,0,0,0,0,0,124,30,0,0,1,0,0,0,125,30,0,0,0,0,0,0,0,0,0,0,126,30,0,0,1,0,0,0,127,30,0,0,0,0,0,0,0,0,0,0,128,30,0,0,1,0,0,0,129,30,0,0,0,0,0,0,0,0,0,0,130,30,0,0,1,0,0,0,131,30,0,0,0,0,0,0,0,0,0,0,132,30,0,0,1,0,0,0,133,30,0,0,0,0,0,0,0,0,0,0,134,30,0,0,1,0,0,0,135,30,0,0,0,0,0,0,0,0,0,0,136,30,0,0,1,0,0,0,137,30,0,0,0,0,0,0,0,0,0,0,138,30,0,0,1,0,0,0,139,30,0,0,0,0,0,0,0,0,0,0,140,30,0,0,1,0,0,0,141,30,0,0,0,0,0,0,0,0,0,0,142,30,0,0,1,0,0,0,143,30,0,0,0,0,0,0,0,0,0,0,144,30,0,0,1,0,0,0,145,30,0,0,0,0,0,0,0,0,0,0,146,30,0,0,1,0,0,0,147,30,0,0,0,0,0,0,0,0,0,0,148,30,0,0,1,0,0,0,149,30,0,0,0,0,0,0,0,0,0,0,150,30,0,0,2,0,0,0,104,0,0,0,49,3,0,0,0,0,0,0,151,30,0,0,2,0,0,0,116,0,0,0,8,3,0,0,0,0,0,0,152,30,0,0,2,0,0,0,119,0,0,0,10,3,0,0,0,0,0,0,153,30,0,0,2,0,0,0,121,0,0,0,10,3,0,0,0,0,0,0,154,30,0,0,2,0,0,0,97,0,0,0,190,2,0,0,0,0,0,0,155,30,0,0,1,0,0,0,97,30,0,0,0,0,0,0,0,0,0,0,160,30,0,0,1,0,0,0,161,30,0,0,0,0,0,0,0,0,0,0,162,30,0,0,1,0,0,0,163,30,0,0,0,0,0,0,0,0,0,0,164,30,0,0,1,0,0,0,165,30,0,0,0,0,0,0,0,0,0,0,166,30,0,0,1,0,0,0,167,30,0,0,0,0,0,0,0,0,0,0,168,30,0,0,1,0,0,0,169,30,0,0,0,0,0,0,0,0,0,0,170,30,0,0,1,0,0,0,171,30,0,0,0,0,0,0,0,0,0,0,172,30,0,0,1,0,0,0,173,30,0,0,0,0,0,0,0,0,0,0,174,30,0,0,1,0,0,0,175,30,0,0,0,0,0,0,0,0,0,0,176,30,0,0,1,0,0,0,177,30,0,0,0,0,0,0,0,0,0,0,178,30,0,0,1,0,0,0,179,30,0,0,0,0,0,0,0,0,0,0,180,30,0,0,1,0,0,0,181,30,0,0,0,0,0,0,0,0,0,0,182,30,0,0,1,0,0,0,183,30,0,0,0,0,0,0,0,0,0,0,184,30,0,0,1,0,0,0,185,30,0,0,0,0,0,0,0,0,0,0,186,30,0,0,1,0,0,0,187,30,0,0,0,0,0,0,0,0,0,0,188,30,0,0,1,0,0,0,189,30,0,0,0,0,0,0,0,0,0,0,190,30,0,0,1,0,0,0,191,30,0,0,0,0,0,0,0,0,0,0,192,30,0,0,1,0,0,0,193,30,0,0,0,0,0,0,0,0,0,0,194,30,0,0,1,0,0,0,195,30,0,0,0,0,0,0,0,0,0,0,196,30,0,0,1,0,0,0,197,30,0,0,0,0,0,0,0,0,0,0,198,30,0,0,1,0,0,0,199,30,0,0,0,0,0,0,0,0,0,0,200,30,0,0,1,0,0,0,201,30,0,0,0,0,0,0,0,0,0,0,202,30,0,0,1,0,0,0,203,30,0,0,0,0,0,0,0,0,0,0,204,30,0,0,1,0,0,0,205,30,0,0,0,0,0,0,0,0,0,0,206,30,0,0,1,0,0,0,207,30,0,0,0,0,0,0,0,0,0,0,208,30,0,0,1,0,0,0,209,30,0,0,0,0,0,0,0,0,0,0,210,30,0,0,1,0,0,0,211,30,0,0,0,0,0,0,0,0,0,0,212,30,0,0,1,0,0,0,213,30,0,0,0,0,0,0,0,0,0,0,214,30,0,0,1,0,0,0,215,30,0,0,0,0,0,0,0,0,0,0,216,30,0,0,1,0,0,0,217,30,0,0,0,0,0,0,0,0,0,0,218,30,0,0,1,0,0,0,219,30,0,0,0,0,0,0,0,0,0,0,220,30,0,0,1,0,0,0,221,30,0,0,0,0,0,0,0,0,0,0,222,30,0,0,1,0,0,0,223,30,0,0,0,0,0,0,0,0,0,0,224,30,0,0,1,0,0,0,225,30,0,0,0,0,0,0,0,0,0,0,226,30,0,0,1,0,0,0,227,30,0,0,0,0,0,0,0,0,0,0,228,30,0,0,1,0,0,0,229,30,0,0,0,0,0,0,0,0,0,0,230,30,0,0,1,0,0,0,231,30,0,0,0,0,0,0,0,0,0,0,232,30,0,0,1,0,0,0,233,30,0,0,0,0,0,0,0,0,0,0,234,30,0,0,1,0,0,0,235,30,0,0,0,0,0,0,0,0,0,0,236,30,0,0,1,0,0,0,237,30,0,0,0,0,0,0,0,0,0,0,238,30,0,0,1,0,0,0,239,30,0,0,0,0,0,0,0,0,0,0,240,30,0,0,1,0,0,0,241,30,0,0,0,0,0,0,0,0,0,0,242,30,0,0,1,0,0,0,243,30,0,0,0,0,0,0,0,0,0,0,244,30,0,0,1,0,0,0,245,30,0,0,0,0,0,0,0,0,0,0,246,30,0,0,1,0,0,0,247,30,0,0,0,0,0,0,0,0,0,0,248,30,0,0,1,0,0,0,249,30,0,0,0,0,0,0,0,0,0,0,8,31,0,0,1,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,9,31,0,0,1,0,0,0,1,31,0,0,0,0,0,0,0,0,0,0,10,31,0,0,1,0,0,0,2,31,0,0,0,0,0,0,0,0,0,0,11,31,0,0,1,0,0,0,3,31,0,0,0,0,0,0,0,0,0,0,12,31,0,0,1,0,0,0,4,31,0,0,0,0,0,0,0,0,0,0,13,31,0,0,1,0,0,0,5,31,0,0,0,0,0,0,0,0,0,0,14,31,0,0,1,0,0,0,6,31,0,0,0,0,0,0,0,0,0,0,15,31,0,0,1,0,0,0,7,31,0,0,0,0,0,0,0,0,0,0,24,31,0,0,1,0,0,0,16,31,0,0,0,0,0,0,0,0,0,0,25,31,0,0,1,0,0,0,17,31,0,0,0,0,0,0,0,0,0,0,26,31,0,0,1,0,0,0,18,31,0,0,0,0,0,0,0,0,0,0,27,31,0,0,1,0,0,0,19,31,0,0,0,0,0,0,0,0,0,0,28,31,0,0,1,0,0,0,20,31,0,0,0,0,0,0,0,0,0,0,29,31,0,0,1,0,0,0,21,31,0,0,0,0,0,0,0,0,0,0,40,31,0,0,1,0,0,0,32,31,0,0,0,0,0,0,0,0,0,0,41,31,0,0,1,0,0,0,33,31,0,0,0,0,0,0,0,0,0,0,42,31,0,0,1,0,0,0,34,31,0,0,0,0,0,0,0,0,0,0,43,31,0,0,1,0,0,0,35,31,0,0,0,0,0,0,0,0,0,0,44,31,0,0,1,0,0,0,36,31,0,0,0,0,0,0,0,0,0,0,45,31,0,0,1,0,0,0,37,31,0,0,0,0,0,0,0,0,0,0,46,31,0,0,1,0,0,0,38,31,0,0,0,0,0,0,0,0,0,0,47,31,0,0,1,0,0,0,39,31,0,0,0,0,0,0,0,0,0,0,56,31,0,0,1,0,0,0,48,31,0,0,0,0,0,0,0,0,0,0,57,31,0,0,1,0,0,0,49,31,0,0,0,0,0,0,0,0,0,0,58,31,0,0,1,0,0,0,50,31,0,0,0,0,0,0,0,0,0,0,59,31,0,0,1,0,0,0,51,31,0,0,0,0,0,0,0,0,0,0,60,31,0,0,1,0,0,0,52,31,0,0,0,0,0,0,0,0,0,0,61,31,0,0,1,0,0,0,53,31,0,0,0,0,0,0,0,0,0,0,62,31,0,0,1,0,0,0,54,31,0,0,0,0,0,0,0,0,0,0,63,31,0,0,1,0,0,0,55,31,0,0,0,0,0,0,0,0,0,0,72,31,0,0,1,0,0,0,64,31,0,0,0,0,0,0,0,0,0,0,73,31,0,0,1,0,0,0,65,31,0,0,0,0,0,0,0,0,0,0,74,31,0,0,1,0,0,0,66,31,0,0,0,0,0,0,0,0,0,0,75,31,0,0,1,0,0,0,67,31,0,0,0,0,0,0,0,0,0,0,76,31,0,0,1,0,0,0,68,31,0,0,0,0,0,0,0,0,0,0,77,31,0,0,1,0,0,0,69,31,0,0,0,0,0,0,0,0,0,0,80,31,0,0,2,0,0,0,197,3,0,0,19,3,0,0,0,0,0,0,82,31,0,0,3,0,0,0,197,3,0,0,19,3,0,0,0,3,0,0,84,31,0,0,3,0,0,0,197,3,0,0,19,3,0,0,1,3,0,0,86,31,0,0,3,0,0,0,197,3,0,0,19,3,0,0,66,3,0,0,89,31,0,0,1,0,0,0,81,31,0,0,0,0,0,0,0,0,0,0,91,31,0,0,1,0,0,0,83,31,0,0,0,0,0,0,0,0,0,0,93,31,0,0,1,0,0,0,85,31,0,0,0,0,0,0,0,0,0,0,95,31,0,0,1,0,0,0,87,31,0,0,0,0,0,0,0,0,0,0,104,31,0,0,1,0,0,0,96,31,0,0,0,0,0,0,0,0,0,0,105,31,0,0,1,0,0,0,97,31,0,0,0,0,0,0,0,0,0,0,106,31,0,0,1,0,0,0,98,31,0,0,0,0,0,0,0,0,0,0,107,31,0,0,1,0,0,0,99,31,0,0,0,0,0,0,0,0,0,0,108,31,0,0,1,0,0,0,100,31,0,0,0,0,0,0,0,0,0,0,109,31,0,0,1,0,0,0,101,31,0,0,0,0,0,0,0,0,0,0,110,31,0,0,1,0,0,0,102,31,0,0,0,0,0,0,0,0,0,0,111,31,0,0,1,0,0,0,103,31,0,0,0,0,0,0,0,0,0,0,128,31,0,0,2,0,0,0,0,31,0,0,185,3,0,0,0,0,0,0,129,31,0,0,2,0,0,0,1,31,0,0,185,3,0,0,0,0,0,0,130,31,0,0,2,0,0,0,2,31,0,0,185,3,0,0,0,0,0,0,131,31,0,0,2,0,0,0,3,31,0,0,185,3,0,0,0,0,0,0,132,31,0,0,2,0,0,0,4,31,0,0,185,3,0,0,0,0,0,0,133,31,0,0,2,0,0,0,5,31,0,0,185,3,0,0,0,0,0,0,134,31,0,0,2,0,0,0,6,31,0,0,185,3,0,0,0,0,0,0,135,31,0,0,2,0,0,0,7,31,0,0,185,3,0,0,0,0,0,0,136,31,0,0,2,0,0,0,0,31,0,0,185,3,0,0,0,0,0,0,137,31,0,0,2,0,0,0,1,31,0,0,185,3,0,0,0,0,0,0,138,31,0,0,2,0,0,0,2,31,0,0,185,3,0,0,0,0,0,0,139,31,0,0,2,0,0,0,3,31,0,0,185,3,0,0,0,0,0,0,140,31,0,0,2,0,0,0,4,31,0,0,185,3,0,0,0,0,0,0,141,31,0,0,2,0,0,0,5,31,0,0,185,3,0,0,0,0,0,0,142,31,0,0,2,0,0,0,6,31,0,0,185,3,0,0,0,0,0,0,143,31,0,0,2,0,0,0,7,31,0,0,185,3,0,0,0,0,0,0,144,31,0,0,2,0,0,0,32,31,0,0,185,3,0,0,0,0,0,0,145,31,0,0,2,0,0,0,33,31,0,0,185,3,0,0,0,0,0,0,146,31,0,0,2,0,0,0,34,31,0,0,185,3,0,0,0,0,0,0,147,31,0,0,2,0,0,0,35,31,0,0,185,3,0,0,0,0,0,0,148,31,0,0,2,0,0,0,36,31,0,0,185,3,0,0,0,0,0,0,149,31,0,0,2,0,0,0,37,31,0,0,185,3,0,0,0,0,0,0,150,31,0,0,2,0,0,0,38,31,0,0,185,3,0,0,0,0,0,0,151,31,0,0,2,0,0,0,39,31,0,0,185,3,0,0,0,0,0,0,152,31,0,0,2,0,0,0,32,31,0,0,185,3,0,0,0,0,0,0,153,31,0,0,2,0,0,0,33,31,0,0,185,3,0,0,0,0,0,0,154,31,0,0,2,0,0,0,34,31,0,0,185,3,0,0,0,0,0,0,155,31,0,0,2,0,0,0,35,31,0,0,185,3,0,0,0,0,0,0,156,31,0,0,2,0,0,0,36,31,0,0,185,3,0,0,0,0,0,0,157,31,0,0,2,0,0,0,37,31,0,0,185,3,0,0,0,0,0,0,158,31,0,0,2,0,0,0,38,31,0,0,185,3,0,0,0,0,0,0,159,31,0,0,2,0,0,0,39,31,0,0,185,3,0,0,0,0,0,0,160,31,0,0,2,0,0,0,96,31,0,0,185,3,0,0,0,0,0,0,161,31,0,0,2,0,0,0,97,31,0,0,185,3,0,0,0,0,0,0,162,31,0,0,2,0,0,0,98,31,0,0,185,3,0,0,0,0,0,0,163,31,0,0,2,0,0,0,99,31,0,0,185,3,0,0,0,0,0,0,164,31,0,0,2,0,0,0,100,31,0,0,185,3,0,0,0,0,0,0,165,31,0,0,2,0,0,0,101,31,0,0,185,3,0,0,0,0,0,0,166,31,0,0,2,0,0,0,102,31,0,0,185,3,0,0,0,0,0,0,167,31,0,0,2,0,0,0,103,31,0,0,185,3,0,0,0,0,0,0,168,31,0,0,2,0,0,0,96,31,0,0,185,3,0,0,0,0,0,0,169,31,0,0,2,0,0,0,97,31,0,0,185,3,0,0,0,0,0,0,170,31,0,0,2,0,0,0,98,31,0,0,185,3,0,0,0,0,0,0,171,31,0,0,2,0,0,0,99,31,0,0,185,3,0,0,0,0,0,0,172,31,0,0,2,0,0,0,100,31,0,0,185,3,0,0,0,0,0,0,173,31,0,0,2,0,0,0,101,31,0,0,185,3,0,0,0,0,0,0,174,31,0,0,2,0,0,0,102,31,0,0,185,3,0,0,0,0,0,0,175,31,0,0,2,0,0,0,103,31,0,0,185,3,0,0,0,0,0,0,178,31,0,0,2,0,0,0,112,31,0,0,185,3,0,0,0,0,0,0,179,31,0,0,2,0,0,0,177,3,0,0,185,3,0,0,0,0,0,0,180,31,0,0,2,0,0,0,172,3,0,0,185,3,0,0,0,0,0,0,182,31,0,0,2,0,0,0,177,3,0,0,66,3,0,0,0,0,0,0,183,31,0,0,3,0,0,0,177,3,0,0,66,3,0,0,185,3,0,0,184,31,0,0,1,0,0,0,176,31,0,0,0,0,0,0,0,0,0,0,185,31,0,0,1,0,0,0,177,31,0,0,0,0,0,0,0,0,0,0,186,31,0,0,1,0,0,0,112,31,0,0,0,0,0,0,0,0,0,0,187,31,0,0,1,0,0,0,113,31,0,0,0,0,0,0,0,0,0,0,188,31,0,0,2,0,0,0,177,3,0,0,185,3,0,0,0,0,0,0,190,31,0,0,1,0,0,0,185,3,0,0,0,0,0,0,0,0,0,0,194,31,0,0,2,0,0,0,116,31,0,0,185,3,0,0,0,0,0,0,195,31,0,0,2,0,0,0,183,3,0,0,185,3,0,0,0,0,0,0,196,31,0,0,2,0,0,0,174,3,0,0,185,3,0,0,0,0,0,0,198,31,0,0,2,0,0,0,183,3,0,0,66,3,0,0,0,0,0,0,199,31,0,0,3,0,0,0,183,3,0,0,66,3,0,0,185,3,0,0,200,31,0,0,1,0,0,0,114,31,0,0,0,0,0,0,0,0,0,0,201,31,0,0,1,0,0,0,115,31,0,0,0,0,0,0,0,0,0,0,202,31,0,0,1,0,0,0,116,31,0,0,0,0,0,0,0,0,0,0,203,31,0,0,1,0,0,0,117,31,0,0,0,0,0,0,0,0,0,0,204,31,0,0,2,0,0,0,183,3,0,0,185,3,0,0,0,0,0,0,210,31,0,0,3,0,0,0,185,3,0,0,8,3,0,0,0,3,0,0,211,31,0,0,3,0,0,0,185,3,0,0,8,3,0,0,1,3,0,0,214,31,0,0,2,0,0,0,185,3,0,0,66,3,0,0,0,0,0,0,215,31,0,0,3,0,0,0,185,3,0,0,8,3,0,0,66,3,0,0,216,31,0,0,1,0,0,0,208,31,0,0,0,0,0,0,0,0,0,0,217,31,0,0,1,0,0,0,209,31,0,0,0,0,0,0,0,0,0,0,218,31,0,0,1,0,0,0,118,31,0,0,0,0,0,0,0,0,0,0,219,31,0,0,1,0,0,0,119,31,0,0,0,0,0,0,0,0,0,0,226,31,0,0,3,0,0,0,197,3,0,0,8,3,0,0,0,3,0,0,227,31,0,0,3,0,0,0,197,3,0,0,8,3,0,0,1,3,0,0,228,31,0,0,2,0,0,0,193,3,0,0,19,3,0,0,0,0,0,0,230,31,0,0,2,0,0,0,197,3,0,0,66,3,0,0,0,0,0,0,231,31,0,0,3,0,0,0,197,3,0,0,8,3,0,0,66,3,0,0,232,31,0,0,1,0,0,0,224,31,0,0,0,0,0,0,0,0,0,0,233,31,0,0,1,0,0,0,225,31,0,0,0,0,0,0,0,0,0,0,234,31,0,0,1,0,0,0,122,31,0,0,0,0,0,0,0,0,0,0,235,31,0,0,1,0,0,0,123,31,0,0,0,0,0,0,0,0,0,0,236,31,0,0,1,0,0,0,229,31,0,0,0,0,0,0,0,0,0,0,242,31,0,0,2,0,0,0,124,31,0,0,185,3,0,0,0,0,0,0,243,31,0,0,2,0,0,0,201,3,0,0,185,3,0,0,0,0,0,0,244,31,0,0,2,0,0,0,206,3,0,0,185,3,0,0,0,0,0,0,246,31,0,0,2,0,0,0,201,3,0,0,66,3,0,0,0,0,0,0,247,31,0,0,3,0,0,0,201,3,0,0,66,3,0,0,185,3,0,0,248,31,0,0,1,0,0,0,120,31,0,0,0,0,0,0,0,0,0,0,249,31,0,0,1,0,0,0,121,31,0,0,0,0,0,0,0,0,0,0,250,31,0,0,1,0,0,0,124,31,0,0,0,0,0,0,0,0,0,0,251,31,0,0,1,0,0,0,125,31,0,0,0,0,0,0,0,0,0,0,252,31,0,0,2,0,0,0,201,3,0,0,185,3,0,0,0,0,0,0,38,33,0,0,1,0,0,0,201,3,0,0,0,0,0,0,0,0,0,0,42,33,0,0,1,0,0,0,107,0,0,0,0,0,0,0,0,0,0,0,43,33,0,0,1,0,0,0,229,0,0,0,0,0,0,0,0,0,0,0,96,33,0,0,1,0,0,0,112,33,0,0,0,0,0,0,0,0,0,0,97,33,0,0,1,0,0,0,113,33,0,0,0,0,0,0,0,0,0,0,98,33,0,0,1,0,0,0,114,33,0,0,0,0,0,0,0,0,0,0,99,33,0,0,1,0,0,0,115,33,0,0,0,0,0,0,0,0,0,0,100,33,0,0,1,0,0,0,116,33,0,0,0,0,0,0,0,0,0,0,101,33,0,0,1,0,0,0,117,33,0,0,0,0,0,0,0,0,0,0,102,33,0,0,1,0,0,0,118,33,0,0,0,0,0,0,0,0,0,0,103,33,0,0,1,0,0,0,119,33,0,0,0,0,0,0,0,0,0,0,104,33,0,0,1,0,0,0,120,33,0,0,0,0,0,0,0,0,0,0,105,33,0,0,1,0,0,0,121,33,0,0,0,0,0,0,0,0,0,0,106,33,0,0,1,0,0,0,122,33,0,0,0,0,0,0,0,0,0,0,107,33,0,0,1,0,0,0,123,33,0,0,0,0,0,0,0,0,0,0,108,33,0,0,1,0,0,0,124,33,0,0,0,0,0,0,0,0,0,0,109,33,0,0,1,0,0,0,125,33,0,0,0,0,0,0,0,0,0,0,110,33,0,0,1,0,0,0,126,33,0,0,0,0,0,0,0,0,0,0,111,33,0,0,1,0,0,0,127,33,0,0,0,0,0,0,0,0,0,0,182,36,0,0,1,0,0,0,208,36,0,0,0,0,0,0,0,0,0,0,183,36,0,0,1,0,0,0,209,36,0,0,0,0,0,0,0,0,0,0,184,36,0,0,1,0,0,0,210,36,0,0,0,0,0,0,0,0,0,0,185,36,0,0,1,0,0,0,211,36,0,0,0,0,0,0,0,0,0,0,186,36,0,0,1,0,0,0,212,36,0,0,0,0,0,0,0,0,0,0,187,36,0,0,1,0,0,0,213,36,0,0,0,0,0,0,0,0,0,0,188,36,0,0,1,0,0,0,214,36,0,0,0,0,0,0,0,0,0,0,189,36,0,0,1,0,0,0,215,36,0,0,0,0,0,0,0,0,0,0,190,36,0,0,1,0,0,0,216,36,0,0,0,0,0,0,0,0,0,0,191,36,0,0,1,0,0,0,217,36,0,0,0,0,0,0,0,0,0,0,192,36,0,0,1,0,0,0,218,36,0,0,0,0,0,0,0,0,0,0,193,36,0,0,1,0,0,0,219,36,0,0,0,0,0,0,0,0,0,0,194,36,0,0,1,0,0,0,220,36,0,0,0,0,0,0,0,0,0,0,195,36,0,0,1,0,0,0,221,36,0,0,0,0,0,0,0,0,0,0,196,36,0,0,1,0,0,0,222,36,0,0,0,0,0,0,0,0,0,0,197,36,0,0,1,0,0,0,223,36,0,0,0,0,0,0,0,0,0,0,198,36,0,0,1,0,0,0,224,36,0,0,0,0,0,0,0,0,0,0,199,36,0,0,1,0,0,0,225,36,0,0,0,0,0,0,0,0,0,0,200,36,0,0,1,0,0,0,226,36,0,0,0,0,0,0,0,0,0,0,201,36,0,0,1,0,0,0,227,36,0,0,0,0,0,0,0,0,0,0,202,36,0,0,1,0,0,0,228,36,0,0,0,0,0,0,0,0,0,0,203,36,0,0,1,0,0,0,229,36,0,0,0,0,0,0,0,0,0,0,204,36,0,0,1,0,0,0,230,36,0,0,0,0,0,0,0,0,0,0,205,36,0,0,1,0,0,0,231,36,0,0,0,0,0,0,0,0,0,0,206,36,0,0,1,0,0,0,232,36,0,0,0,0,0,0,0,0,0,0,207,36,0,0,1,0,0,0,233,36,0,0,0,0,0,0,0,0,0,0,0,44,0,0,1,0,0,0,48,44,0,0,0,0,0,0,0,0,0,0,1,44,0,0,1,0,0,0,49,44,0,0,0,0,0,0,0,0,0,0,2,44,0,0,1,0,0,0,50,44,0,0,0,0,0,0,0,0,0,0,3,44,0,0,1,0,0,0,51,44,0,0,0,0,0,0,0,0,0,0,4,44,0,0,1,0,0,0,52,44,0,0,0,0,0,0,0,0,0,0,5,44,0,0,1,0,0,0,53,44,0,0,0,0,0,0,0,0,0,0,6,44,0,0,1,0,0,0,54,44,0,0,0,0,0,0,0,0,0,0,7,44,0,0,1,0,0,0,55,44,0,0,0,0,0,0,0,0,0,0,8,44,0,0,1,0,0,0,56,44,0,0,0,0,0,0,0,0,0,0,9,44,0,0,1,0,0,0,57,44,0,0,0,0,0,0,0,0,0,0,10,44,0,0,1,0,0,0,58,44,0,0,0,0,0,0,0,0,0,0,11,44,0,0,1,0,0,0,59,44,0,0,0,0,0,0,0,0,0,0,12,44,0,0,1,0,0,0,60,44,0,0,0,0,0,0,0,0,0,0,13,44,0,0,1,0,0,0,61,44,0,0,0,0,0,0,0,0,0,0,14,44,0,0,1,0,0,0,62,44,0,0,0,0,0,0,0,0,0,0,15,44,0,0,1,0,0,0,63,44,0,0,0,0,0,0,0,0,0,0,16,44,0,0,1,0,0,0,64,44,0,0,0,0,0,0,0,0,0,0,17,44,0,0,1,0,0,0,65,44,0,0,0,0,0,0,0,0,0,0,18,44,0,0,1,0,0,0,66,44,0,0,0,0,0,0,0,0,0,0,19,44,0,0,1,0,0,0,67,44,0,0,0,0,0,0,0,0,0,0,20,44,0,0,1,0,0,0,68,44,0,0,0,0,0,0,0,0,0,0,21,44,0,0,1,0,0,0,69,44,0,0,0,0,0,0,0,0,0,0,22,44,0,0,1,0,0,0,70,44,0,0,0,0,0,0,0,0,0,0,23,44,0,0,1,0,0,0,71,44,0,0,0,0,0,0,0,0,0,0,24,44,0,0,1,0,0,0,72,44,0,0,0,0,0,0,0,0,0,0,25,44,0,0,1,0,0,0,73,44,0,0,0,0,0,0,0,0,0,0,26,44,0,0,1,0,0,0,74,44,0,0,0,0,0,0,0,0,0,0,27,44,0,0,1,0,0,0,75,44,0,0,0,0,0,0,0,0,0,0,28,44,0,0,1,0,0,0,76,44,0,0,0,0,0,0,0,0,0,0,29,44,0,0,1,0,0,0,77,44,0,0,0,0,0,0,0,0,0,0,30,44,0,0,1,0,0,0,78,44,0,0,0,0,0,0,0,0,0,0,31,44,0,0,1,0,0,0,79,44,0,0,0,0,0,0,0,0,0,0,32,44,0,0,1,0,0,0,80,44,0,0,0,0,0,0,0,0,0,0,33,44,0,0,1,0,0,0,81,44,0,0,0,0,0,0,0,0,0,0,34,44,0,0,1,0,0,0,82,44,0,0,0,0,0,0,0,0,0,0,35,44,0,0,1,0,0,0,83,44,0,0,0,0,0,0,0,0,0,0,36,44,0,0,1,0,0,0,84,44,0,0,0,0,0,0,0,0,0,0,37,44,0,0,1,0,0,0,85,44,0,0,0,0,0,0,0,0,0,0,38,44,0,0,1,0,0,0,86,44,0,0,0,0,0,0,0,0,0,0,39,44,0,0,1,0,0,0,87,44,0,0,0,0,0,0,0,0,0,0,40,44,0,0,1,0,0,0,88,44,0,0,0,0,0,0,0,0,0,0,41,44,0,0,1,0,0,0,89,44,0,0,0,0,0,0,0,0,0,0,42,44,0,0,1,0,0,0,90,44,0,0,0,0,0,0,0,0,0,0,43,44,0,0,1,0,0,0,91,44,0,0,0,0,0,0,0,0,0,0,44,44,0,0,1,0,0,0,92,44,0,0,0,0,0,0,0,0,0,0,45,44,0,0,1,0,0,0,93,44,0,0,0,0,0,0,0,0,0,0,46,44,0,0,1,0,0,0,94,44,0,0,0,0,0,0,0,0,0,0,128,44,0,0,1,0,0,0,129,44,0,0,0,0,0,0,0,0,0,0,130,44,0,0,1,0,0,0,131,44,0,0,0,0,0,0,0,0,0,0,132,44,0,0,1,0,0,0,133,44,0,0,0,0,0,0,0,0,0,0,134,44,0,0,1,0,0,0,135,44,0,0,0,0,0,0,0,0,0,0,136,44,0,0,1,0,0,0,137,44,0,0,0,0,0,0,0,0,0,0,138,44,0,0,1,0,0,0,139,44,0,0,0,0,0,0,0,0,0,0,140,44,0,0,1,0,0,0,141,44,0,0,0,0,0,0,0,0,0,0,142,44,0,0,1,0,0,0,143,44,0,0,0,0,0,0,0,0,0,0,144,44,0,0,1,0,0,0,145,44,0,0,0,0,0,0,0,0,0,0,146,44,0,0,1,0,0,0,147,44,0,0,0,0,0,0,0,0,0,0,148,44,0,0,1,0,0,0,149,44,0,0,0,0,0,0,0,0,0,0,150,44,0,0,1,0,0,0,151,44,0,0,0,0,0,0,0,0,0,0,152,44,0,0,1,0,0,0,153,44,0,0,0,0,0,0,0,0,0,0,154,44,0,0,1,0,0,0,155,44,0,0,0,0,0,0,0,0,0,0,156,44,0,0,1,0,0,0,157,44,0,0,0,0,0,0,0,0,0,0,158,44,0,0,1,0,0,0,159,44,0,0,0,0,0,0,0,0,0,0,160,44,0,0,1,0,0,0,161,44,0,0,0,0,0,0,0,0,0,0,162,44,0,0,1,0,0,0,163,44,0,0,0,0,0,0,0,0,0,0,164,44,0,0,1,0,0,0,165,44,0,0,0,0,0,0,0,0,0,0,166,44,0,0,1,0,0,0,167,44,0,0,0,0,0,0,0,0,0,0,168,44,0,0,1,0,0,0,169,44,0,0,0,0,0,0,0,0,0,0,170,44,0,0,1,0,0,0,171,44,0,0,0,0,0,0,0,0,0,0,172,44,0,0,1,0,0,0,173,44,0,0,0,0,0,0,0,0,0,0,174,44,0,0,1,0,0,0,175,44,0,0,0,0,0,0,0,0,0,0,176,44,0,0,1,0,0,0,177,44,0,0,0,0,0,0,0,0,0,0,178,44,0,0,1,0,0,0,179,44,0,0,0,0,0,0,0,0,0,0,180,44,0,0,1,0,0,0,181,44,0,0,0,0,0,0,0,0,0,0,182,44,0,0,1,0,0,0,183,44,0,0,0,0,0,0,0,0,0,0,184,44,0,0,1,0,0,0,185,44,0,0,0,0,0,0,0,0,0,0,186,44,0,0,1,0,0,0,187,44,0,0,0,0,0,0,0,0,0,0,188,44,0,0,1,0,0,0,189,44,0,0,0,0,0,0,0,0,0,0,190,44,0,0,1,0,0,0,191,44,0,0,0,0,0,0,0,0,0,0,192,44,0,0,1,0,0,0,193,44,0,0,0,0,0,0,0,0,0,0,194,44,0,0,1,0,0,0,195,44,0,0,0,0,0,0,0,0,0,0,196,44,0,0,1,0,0,0,197,44,0,0,0,0,0,0,0,0,0,0,198,44,0,0,1,0,0,0,199,44,0,0,0,0,0,0,0,0,0,0,200,44,0,0,1,0,0,0,201,44,0,0,0,0,0,0,0,0,0,0,202,44,0,0,1,0,0,0,203,44,0,0,0,0,0,0,0,0,0,0,204,44,0,0,1,0,0,0,205,44,0,0,0,0,0,0,0,0,0,0,206,44,0,0,1,0,0,0,207,44,0,0,0,0,0,0,0,0,0,0,208,44,0,0,1,0,0,0,209,44,0,0,0,0,0,0,0,0,0,0,210,44,0,0,1,0,0,0,211,44,0,0,0,0,0,0,0,0,0,0,212,44,0,0,1,0,0,0,213,44,0,0,0,0,0,0,0,0,0,0,214,44,0,0,1,0,0,0,215,44,0,0,0,0,0,0,0,0,0,0,216,44,0,0,1,0,0,0,217,44,0,0,0,0,0,0,0,0,0,0,218,44,0,0,1,0,0,0,219,44,0,0,0,0,0,0,0,0,0,0,220,44,0,0,1,0,0,0,221,44,0,0,0,0,0,0,0,0,0,0,222,44,0,0,1,0,0,0,223,44,0,0,0,0,0,0,0,0,0,0,224,44,0,0,1,0,0,0,225,44,0,0,0,0,0,0,0,0,0,0,226,44,0,0,1,0,0,0,227,44,0,0,0,0,0,0,0,0,0,0,0,251,0,0,2,0,0,0,102,0,0,0,102,0,0,0,0,0,0,0,1,251,0,0,2,0,0,0,102,0,0,0,105,0,0,0,0,0,0,0,2,251,0,0,2,0,0,0,102,0,0,0,108,0,0,0,0,0,0,0,3,251,0,0,3,0,0,0,102,0,0,0,102,0,0,0,105,0,0,0,4,251,0,0,3,0,0,0,102,0,0,0,102,0,0,0,108,0,0,0,5,251,0,0,2,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,6,251,0,0,2,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,19,251,0,0,2,0,0,0,116,5,0,0,118,5,0,0,0,0,0,0,20,251,0,0,2,0,0,0,116,5,0,0,101,5,0,0,0,0,0,0,21,251,0,0,2,0,0,0,116,5,0,0,107,5,0,0,0,0,0,0,22,251,0,0,2,0,0,0,126,5,0,0,118,5,0,0,0,0,0,0,23,251,0,0,2,0,0,0,116,5,0,0,109,5,0,0,0,0,0,0,33,255,0,0,1,0,0,0,65,255,0,0,0,0,0,0,0,0,0,0,34,255,0,0,1,0,0,0,66,255,0,0,0,0,0,0,0,0,0,0,35,255,0,0,1,0,0,0,67,255,0,0,0,0,0,0,0,0,0,0,36,255,0,0,1,0,0,0,68,255,0,0,0,0,0,0,0,0,0,0,37,255,0,0,1,0,0,0,69,255,0,0,0,0,0,0,0,0,0,0,38,255,0,0,1,0,0,0,70,255,0,0,0,0,0,0,0,0,0,0,39,255,0,0,1,0,0,0,71,255,0,0,0,0,0,0,0,0,0,0,40,255,0,0,1,0,0,0,72,255,0,0,0,0,0,0,0,0,0,0,41,255,0,0,1,0,0,0,73,255,0,0,0,0,0,0,0,0,0,0,42,255,0,0,1,0,0,0,74,255,0,0,0,0,0,0,0,0,0,0,43,255,0,0,1,0,0,0,75,255,0,0,0,0,0,0,0,0,0,0,44,255,0,0,1,0,0,0,76,255,0,0,0,0,0,0,0,0,0,0,45,255,0,0,1,0,0,0,77,255,0,0,0,0,0,0,0,0,0,0,46,255,0,0,1,0,0,0,78,255,0,0,0,0,0,0,0,0,0,0,47,255,0,0,1,0,0,0,79,255,0,0,0,0,0,0,0,0,0,0,48,255,0,0,1,0,0,0,80,255,0,0,0,0,0,0,0,0,0,0,49,255,0,0,1,0,0,0,81,255,0,0,0,0,0,0,0,0,0,0,50,255,0,0,1,0,0,0,82,255,0,0,0,0,0,0,0,0,0,0,51,255,0,0,1,0,0,0,83,255,0,0,0,0,0,0,0,0,0,0,52,255,0,0,1,0,0,0,84,255,0,0,0,0,0,0,0,0,0,0,53,255,0,0,1,0,0,0,85,255,0,0,0,0,0,0,0,0,0,0,54,255,0,0,1,0,0,0,86,255,0,0,0,0,0,0,0,0,0,0,55,255,0,0,1,0,0,0,87,255,0,0,0,0,0,0,0,0,0,0,56,255,0,0,1,0,0,0,88,255,0,0,0,0,0,0,0,0,0,0,57,255,0,0,1,0,0,0,89,255,0,0,0,0,0,0,0,0,0,0,58,255,0,0,1,0,0,0,90,255,0,0,0,0,0,0,0,0,0,0,0,4,1,0,1,0,0,0,40,4,1,0,0,0,0,0,0,0,0,0,1,4,1,0,1,0,0,0,41,4,1,0,0,0,0,0,0,0,0,0,2,4,1,0,1,0,0,0,42,4,1,0,0,0,0,0,0,0,0,0,3,4,1,0,1,0,0,0,43,4,1,0,0,0,0,0,0,0,0,0,4,4,1,0,1,0,0,0,44,4,1,0,0,0,0,0,0,0,0,0,5,4,1,0,1,0,0,0,45,4,1,0,0,0,0,0,0,0,0,0,6,4,1,0,1,0,0,0,46,4,1,0,0,0,0,0,0,0,0,0,7,4,1,0,1,0,0,0,47,4,1,0,0,0,0,0,0,0,0,0,8,4,1,0,1,0,0,0,48,4,1,0,0,0,0,0,0,0,0,0,9,4,1,0,1,0,0,0,49,4,1,0,0,0,0,0,0,0,0,0,10,4,1,0,1,0,0,0,50,4,1,0,0,0,0,0,0,0,0,0,11,4,1,0,1,0,0,0,51,4,1,0,0,0,0,0,0,0,0,0,12,4,1,0,1,0,0,0,52,4,1,0,0,0,0,0,0,0,0,0,13,4,1,0,1,0,0,0,53,4,1,0,0,0,0,0,0,0,0,0,14,4,1,0,1,0,0,0,54,4,1,0,0,0,0,0,0,0,0,0,15,4,1,0,1,0,0,0,55,4,1,0,0,0,0,0,0,0,0,0,16,4,1,0,1,0,0,0,56,4,1,0,0,0,0,0,0,0,0,0,17,4,1,0,1,0,0,0,57,4,1,0,0,0,0,0,0,0,0,0,18,4,1,0,1,0,0,0,58,4,1,0,0,0,0,0,0,0,0,0,19,4,1,0,1,0,0,0,59,4,1,0,0,0,0,0,0,0,0,0,20,4,1,0,1,0,0,0,60,4,1,0,0,0,0,0,0,0,0,0,21,4,1,0,1,0,0,0,61,4,1,0,0,0,0,0,0,0,0,0,22,4,1,0,1,0,0,0,62,4,1,0,0,0,0,0,0,0,0,0,23,4,1,0,1,0,0,0,63,4,1,0,0,0,0,0,0,0,0,0,24,4,1,0,1,0,0,0,64,4,1,0,0,0,0,0,0,0,0,0,25,4,1,0,1,0,0,0,65,4,1,0,0,0,0,0,0,0,0,0,26,4,1,0,1,0,0,0,66,4,1,0,0,0,0,0,0,0,0,0,27,4,1,0,1,0,0,0,67,4,1,0,0,0,0,0,0,0,0,0,28,4,1,0,1,0,0,0,68,4,1,0,0,0,0,0,0,0,0,0,29,4,1,0,1,0,0,0,69,4,1,0,0,0,0,0,0,0,0,0,30,4,1,0,1,0,0,0,70,4,1,0,0,0,0,0,0,0,0,0,31,4,1,0,1,0,0,0,71,4,1,0,0,0,0,0,0,0,0,0,32,4,1,0,1,0,0,0,72,4,1,0,0,0,0,0,0,0,0,0,33,4,1,0,1,0,0,0,73,4,1,0,0,0,0,0,0,0,0,0,34,4,1,0,1,0,0,0,74,4,1,0,0,0,0,0,0,0,0,0,35,4,1,0,1,0,0,0,75,4,1,0,0,0,0,0,0,0,0,0,36,4,1,0,1,0,0,0,76,4,1,0,0,0,0,0,0,0,0,0,37,4,1,0,1,0,0,0,77,4,1,0,0,0,0,0,0,0,0,0,38,4,1,0,1,0,0,0,78,4,1,0,0,0,0,0,0,0,0,0,39,4,1,0,1,0,0,0,79,4,1,0,0,0,0,0,0,0,0,0,73,0,0,0,1,0,0,0,105,0,0,0,0,0,0,0,0,0,0,0,48,1,0,0,2,0,0,0,105,0,0,0,7,3,0,0,0,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,68,217,6,0,0,0,0,0,7,0,0,0,76,217,6,0,1,0,0,0,5,0,0,0,82,217,6,0,2,0,0,0,5,0,0,0,88,217,6,0,3,0,0,0,5,0,0,0,94,217,6,0,4,0,0,0,5,0,0,0,100,217,6,0,5,0,0,0,5,0,0,0,106,217,6,0,6,0,0,0,5,0,0,0,112,217,6,0,7,0,0,0,5,0,0,0,118,217,6,0,8,0,0,0,5,0,0,0,124,217,6,0,9,0,0,0,5,0,0,0,130,217,6,0,10,0,0,0,5,0,0,0,136,217,6,0,11,0,0,0,6,0,0,0,143,217,6,0,12,0,0,0,4,0,0,0,148,217,6,0,13,0,0,0,5,0,0,0,154,217,6,0,14,0,0,0,5,0,0,0,160,217,6,0,15,0,0,0,3,0,0,0,164,217,6,0,16,0,0,0,8,0,0,0,173,217,6,0,17,0,0,0,1,0,0,0,175,217,6,0,18,0,0,0,2,0,0,0,178,217,6,0,19,0,0,0,2,0,0,0,181,217,6,0,20,0,0,0,2,0,0,0,184,217,6,0,21,0,0,0,2,0,0,0,187,217,6,0,22,0,0,0,2,0,0,0,190,217,6,0,23,0,0,0,1,0,0,0,192,217,6,0,24,0,0,0,2,0,0,0,195,217,6,0,25,0,0,0,2,0,0,0,198,217,6,0,26,0,0,0,2,0,0,0,201,217,6,0,27,0,0,0,2,0,0,0,204,217,6,0,28,0,0,0,2,0,0,0,207,217,6,0,29,0,0,0,1,0,0,0,209,217,6,0,30,0,0,0,2,0,0,0,212,217,6,0,31,0,0,0,2,0,0,0,215,217,6,0,32,0,0,0,2,0,0,0,218,217,6,0,33,0,0,0,1,0,0,0,220,217,6,0,34,0,0,0,2,0,0,0,223,217,6,0,35,0,0,0,2,0,0,0,226,217,6,0,36,0,0,0,2,0,0,0,229,217,6,0,37,0,0,0,1,0,0,0,231,217,6,0,38,0,0,0,2,0,0,0,234,217,6,0,39,0,0,0,2,0,0,0,237,217,6,0,40,0,0,0,2,0,0,0,240,217,6,0,41,0,0,0,2,0,0,0,243,217,6,0,42,0,0,0,2,0,0,0,246,217,6,0,43,0,0,0,2,0,0,0,249,217,6,0,44,0,0,0,2,0,0,0,252,217,6,0,45,0,0,0,1,0,0,0,254,217,6,0,46,0,0,0,2,0,0,0,1,218,6,0,47,0,0,0,2,0,0,0,4,218,6,0,48,0,0,0,2,0,0,0,7,218,6,0,49,0,0,0,2,0,0,0,10,218,6,0,50,0,0,0,1,0,0,0,12,218,6,0,51,0,0,0,2,0,0,0,15,218,6,0,52,0,0,0,2,0,0,0,18,218,6,0,53,0,0,0,2,0,0,0,21,218,6,0,54,0,0,0,6,0,0,0,28,218,6,0,55,0,0,0,8,0,0,0,37,218,6,0,56,0,0,0,7,0,0,0,45,218,6,0,57,0,0,0,8,0,0,0,54,218,6,0,58,0,0,0,7,0,0,0,62,218,6,0,59,0,0,0,8,0,0,0,71,218,6,0,60,0,0,0,5,0,0,0,77,218,6,0,61,0,0,0,19,0,0,0,97,218,6,0,62,0,0,0,8,0,0,0,106,218,6,0,63,0,0,0,6,0,0,0,113,218,6,0,64,0,0,0,6,0,0,0,120,218,6,0,65,0,0,0,7,0,0,0,128,218,6,0,66,0,0,0,8,0,0,0,137,218,6,0,67,0,0,0,7,0,0,0,145,218,6,0,68,0,0,0,10,0,0,0,156,218,6,0,69,0,0,0,8,0,0,0,165,218,6,0,70,0,0,0,8,0,0,0,174,218,6,0,71,0,0,0,10], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+365956);
/* memory initializer */ allocate([185,218,6,0,72,0,0,0,6,0,0,0,192,218,6,0,73,0,0,0,5,0,0,0,198,218,6,0,74,0,0,0,8,0,0,0,207,218,6,0,75,0,0,0,8,0,0,0,216,218,6,0,76,0,0,0,3,0,0,0,220,218,6,0,77,0,0,0,6,0,0,0,227,218,6,0,78,0,0,0,7,0,0,0,235,218,6,0,79,0,0,0,6,0,0,0,242,218,6,0,80,0,0,0,8,0,0,0,251,218,6,0,81,0,0,0,9,0,0,0,5,219,6,0,82,0,0,0,7,0,0,0,13,219,6,0,83,0,0,0,8,0,0,0,22,219,6,0,84,0,0,0,10,0,0,0,33,219,6,0,85,0,0,0,5,0,0,0,39,219,6,0,86,0,0,0,3,0,0,0,43,219,6,0,87,0,0,0,5,0,0,0,49,219,6,0,88,0,0,0,5,0,0,0,55,219,6,0,89,0,0,0,8,0,0,0,64,219,6,0,90,0,0,0,9,0,0,0,74,219,6,0,91,0,0,0,9,0,0,0,84,219,6,0,92,0,0,0,7,0,0,0,92,219,6,0,93,0,0,0,11,0,0,0,104,219,6,0,94,0,0,0,5,0,0,0,110,219,6,0,95,0,0,0,10,0,0,0,121,219,6,0,96,0,0,0,11,0,0,0,133,219,6,0,97,0,0,0,5,0,0,0,139,219,6,0,98,0,0,0,7,0,0,0,147,219,6,0,99,0,0,0,5,0,0,0,153,219,6,0,100,0,0,0,7,0,0,0,161,219,6,0,101,0,0,0,7,0,0,0,169,219,6,0,102,0,0,0,12,0,0,0,182,219,6,0,103,0,0,0,6,0,0,0,189,219,6,0,104,0,0,0,7,0,0,0,197,219,6,0,105,0,0,0,8,0,0,0,206,219,6,0,106,0,0,0,6,0,0,0,213,219,6,0,107,0,0,0,5,0,0,0,219,219,6,0,108,0,0,0,6,0,0,0,226,219,6,0,109,0,0,0,6,0,0,0,233,219,6,0,110,0,0,0,4,0,0,0,238,219,6,0,111,0,0,0,7,0,0,0,246,219,6,0,112,0,0,0,8,0,0,0,255,219,6,0,113,0,0,0,8,0,0,0,8,220,6,0,114,0,0,0,2,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,10,0,0,0,10,0,0,0,162,1,0,0,65,0,0,0,90,0,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,181,0,0,0,181,0,0,0,186,0,0,0,186,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,246,0,0,0,248,0,0,0,65,2,0,0,80,2,0,0,193,2,0,0,198,2,0,0,209,2,0,0,224,2,0,0,228,2,0,0,238,2,0,0,238,2,0,0,0,3,0,0,111,3,0,0,122,3,0,0,122,3,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,245,3,0,0,247,3,0,0,129,4,0,0,131,4,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,89,5,0,0,97,5,0,0,135,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,189,5,0,0,191,5,0,0,191,5,0,0,193,5,0,0,194,5,0,0,196,5,0,0,197,5,0,0,199,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,242,5,0,0,16,6,0,0,21,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,110,6,0,0,211,6,0,0,213,6,0,0,220,6,0,0,222,6,0,0,232,6,0,0,234,6,0,0,239,6,0,0,250,6,0,0,252,6,0,0,255,6,0,0,255,6,0,0,16,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,99,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,240,9,0,0,241,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,112,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,113,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,243,13,0,0,1,14,0,0,58,14,0,0,64,14,0,0,78,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,0,15,0,0,24,15,0,0,25,15,0,0,53,15,0,0,53,15,0,0,55,15,0,0,55,15,0,0,57,15,0,0,57,15,0,0,62,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,132,15,0,0,134,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,198,15,0,0,198,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,80,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,250,16,0,0,252,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,95,19,0,0,128,19,0,0,143,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,108,22,0,0,111,22,0,0,118,22,0,0,129,22,0,0,154,22,0,0,160,22,0,0,234,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,52,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,179,23,0,0,182,23,0,0,211,23,0,0,215,23,0,0,215,23,0,0,220,23,0,0,221,23,0,0,11,24,0,0,13,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,80,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,0,26,0,0,27,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,188,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,204,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,224,31,0,0,236,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,252,31,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,144,32,0,0,148,32,0,0,208,32,0,0,235,32,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,10,33,0,0,19,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,47,33,0,0,49,33,0,0,51,33,0,0,57,33,0,0,60,33,0,0,63,33,0,0,69,33,0,0,73,33,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,228,44,0,0,0,45,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,5,48,0,0,6,48,0,0,42,48,0,0,47,48,0,0,49,48,0,0,53,48,0,0,59,48,0,0,60,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,154,48,0,0,157,48,0,0,159,48,0,0,161,48,0,0,250,48,0,0,252,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,160,49,0,0,183,49,0,0,240,49,0,0,255,49,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,160,0,0,140,164,0,0,0,168,0,0,39,168,0,0,0,172,0,0,163,215,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,40,251,0,0,42,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,251,253,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,33,255,0,0,58,255,0,0,65,255,0,0,90,255,0,0,102,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,3,1,0,30,3,1,0,48,3,1,0,73,3,1,0,128,3,1,0,157,3,1,0,160,3,1,0,195,3,1,0,200,3,1,0,207,3,1,0,0,4,1,0,157,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,63,10,1,0,101,209,1,0,105,209,1,0,109,209,1,0,114,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,66,210,1,0,68,210,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,192,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,250,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,52,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,110,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,168,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,0,1,14,0,239,1,14,0,9,0,0,0,9,0,0,0,9,0,0,0,32,0,0,0,32,0,0,0,160,0,0,0,160,0,0,0,128,22,0,0,128,22,0,0,14,24,0,0,14,24,0,0,0,32,0,0,10,32,0,0,47,32,0,0,47,32,0,0,95,32,0,0,95,32,0,0,0,48,0,0,0,48,0,0,19,0,0,0,0,0,0,0,31,0,0,0,127,0,0,0,159,0,0,0,173,0,0,0,173,0,0,0,0,6,0,0,3,6,0,0,221,6,0,0,221,6,0,0,15,7,0,0,15,7,0,0,180,23,0,0,181,23,0,0,11,32,0,0,15,32,0,0,42,32,0,0,46,32,0,0,96,32,0,0,99,32,0,0,106,32,0,0,111,32,0,0,0,216,0,0,255,248,0,0,255,254,0,0,255,254,0,0,249,255,0,0,251,255,0,0,115,209,1,0,122,209,1,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,23,0,0,0,48,0,0,0,57,0,0,0,96,6,0,0,105,6,0,0,240,6,0,0,249,6,0,0,102,9,0,0,111,9,0,0,230,9,0,0,239,9,0,0,102,10,0,0,111,10,0,0,230,10,0,0,239,10,0,0,102,11,0,0,111,11,0,0,230,11,0,0,239,11,0,0,102,12,0,0,111,12,0,0,230,12,0,0,239,12,0,0,102,13,0,0,111,13,0,0,80,14,0,0,89,14,0,0,208,14,0,0,217,14,0,0,32,15,0,0,41,15,0,0,64,16,0,0,73,16,0,0,224,23,0,0,233,23,0,0,16,24,0,0,25,24,0,0,70,25,0,0,79,25,0,0,208,25,0,0,217,25,0,0,16,255,0,0,25,255,0,0,160,4,1,0,169,4,1,0,206,215,1,0,255,215,1,0,168,1,0,0,33,0,0,0,126,0,0,0,161,0,0,0,65,2,0,0,80,2,0,0,111,3,0,0,116,3,0,0,117,3,0,0,122,3,0,0,122,3,0,0,126,3,0,0,126,3,0,0,132,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,95,5,0,0,97,5,0,0,135,5,0,0,137,5,0,0,138,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,244,5,0,0,0,6,0,0,3,6,0,0,11,6,0,0,21,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,96,6,0,0,13,7,0,0,15,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,112,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,250,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,241,10,0,0,241,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,250,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,244,13,0,0,1,14,0,0,58,14,0,0,63,14,0,0,91,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,190,15,0,0,204,15,0,0,207,15,0,0,209,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,124,19,0,0,128,19,0,0,153,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,118,22,0,0,129,22,0,0,156,22,0,0,160,22,0,0,240,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,54,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,0,24,0,0,13,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,64,25,0,0,64,25,0,0,68,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,222,25,0,0,27,26,0,0,30,26,0,0,31,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,196,31,0,0,198,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,221,31,0,0,239,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,254,31,0,0,11,32,0,0,39,32,0,0,42,32,0,0,46,32,0,0,48,32,0,0,94,32,0,0,96,32,0,0,99,32,0,0,106,32,0,0,113,32,0,0,116,32,0,0,142,32,0,0,144,32,0,0,148,32,0,0,160,32,0,0,181,32,0,0,208,32,0,0,235,32,0,0,0,33,0,0,76,33,0,0,83,33,0,0,131,33,0,0,144,33,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,96,36,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,192,39,0,0,198,39,0,0,208,39,0,0,235,39,0,0,240,39,0,0,19,43,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,234,44,0,0,249,44,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,240,47,0,0,251,47,0,0,1,48,0,0,63,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,144,49,0,0,183,49,0,0,192,49,0,0,207,49,0,0,240,49,0,0,30,50,0,0,32,50,0,0,67,50,0,0,80,50,0,0,254,50,0,0,0,51,0,0,181,77,0,0,192,77,0,0,187,159,0,0,0,160,0,0,140,164,0,0,144,164,0,0,198,164,0,0,0,167,0,0,22,167,0,0,0,168,0,0,43,168,0,0,0,172,0,0,163,215,0,0,0,224,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,63,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,253,253,0,0,0,254,0,0,25,254,0,0,32,254,0,0,35,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,102,254,0,0,104,254,0,0,107,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,255,254,0,0,255,254,0,0,1,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,224,255,0,0,230,255,0,0,232,255,0,0,238,255,0,0,249,255,0,0,253,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,1,1,0,2,1,1,0,7,1,1,0,51,1,1,0,55,1,1,0,138,1,1,0,0,3,1,0,30,3,1,0,32,3,1,0,35,3,1,0,48,3,1,0,74,3,1,0,128,3,1,0,157,3,1,0,159,3,1,0,195,3,1,0,200,3,1,0,213,3,1,0,0,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,71,10,1,0,80,10,1,0,88,10,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,221,209,1,0,0,210,1,0,69,210,1,0,0,211,1,0,86,211,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,201,215,1,0,206,215,1,0,255,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,0,1,14,0,239,1,14,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,224,1,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,181,0,0,0,181,0,0,0,186,0,0,0,186,0,0,0,223,0,0,0,246,0,0,0,248,0,0,0,255,0,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,1,0,0,5,1,0,0,5,1,0,0,7,1,0,0,7,1,0,0,9,1,0,0,9,1,0,0,11,1,0,0,11,1,0,0,13,1,0,0,13,1,0,0,15,1,0,0,15,1,0,0,17,1,0,0,17,1,0,0,19,1,0,0,19,1,0,0,21,1,0,0,21,1,0,0,23,1,0,0,23,1,0,0,25,1,0,0,25,1,0,0,27,1,0,0,27,1,0,0,29,1,0,0,29,1,0,0,31,1,0,0,31,1,0,0,33,1,0,0,33,1,0,0,35,1,0,0,35,1,0,0,37,1,0,0,37,1,0,0,39,1,0,0,39,1,0,0,41,1,0,0,41,1,0,0,43,1,0,0,43,1,0,0,45,1,0,0,45,1,0,0,47,1,0,0,47,1,0,0,49,1,0,0,49,1,0,0,51,1,0,0,51,1,0,0,53,1,0,0,53,1,0,0,55,1,0,0,56,1,0,0,58,1,0,0,58,1,0,0,60,1,0,0,60,1,0,0,62,1,0,0,62,1,0,0,64,1,0,0,64,1,0,0,66,1,0,0,66,1,0,0,68,1,0,0,68,1,0,0,70,1,0,0,70,1,0,0,72,1,0,0,73,1,0,0,75,1,0,0,75,1,0,0,77,1,0,0,77,1,0,0,79,1,0,0,79,1,0,0,81,1,0,0,81,1,0,0,83,1,0,0,83,1,0,0,85,1,0,0,85,1,0,0,87,1,0,0,87,1,0,0,89,1,0,0,89,1,0,0,91,1,0,0,91,1,0,0,93,1,0,0,93,1,0,0,95,1,0,0,95,1,0,0,97,1,0,0,97,1,0,0,99,1,0,0,99,1,0,0,101,1,0,0,101,1,0,0,103,1,0,0,103,1,0,0,105,1,0,0,105,1,0,0,107,1,0,0,107,1,0,0,109,1,0,0,109,1,0,0,111,1,0,0,111,1,0,0,113,1,0,0,113,1,0,0,115,1,0,0,115,1,0,0,117,1,0,0,117,1,0,0,119,1,0,0,119,1,0,0,122,1,0,0,122,1,0,0,124,1,0,0,124,1,0,0,126,1,0,0,128,1,0,0,131,1,0,0,131,1,0,0,133,1,0,0,133,1,0,0,136,1,0,0,136,1,0,0,140,1,0,0,141,1,0,0,146,1,0,0,146,1,0,0,149,1,0,0,149,1,0,0,153,1,0,0,155,1,0,0,158,1,0,0,158,1,0,0,161,1,0,0,161,1,0,0,163,1,0,0,163,1,0,0,165,1,0,0,165,1,0,0,168,1,0,0,168,1,0,0,170,1,0,0,171,1,0,0,173,1,0,0,173,1,0,0,176,1,0,0,176,1,0,0,180,1,0,0,180,1,0,0,182,1,0,0,182,1,0,0,185,1,0,0,186,1,0,0,189,1,0,0,191,1,0,0,198,1,0,0,198,1,0,0,201,1,0,0,201,1,0,0,204,1,0,0,204,1,0,0,206,1,0,0,206,1,0,0,208,1,0,0,208,1,0,0,210,1,0,0,210,1,0,0,212,1,0,0,212,1,0,0,214,1,0,0,214,1,0,0,216,1,0,0,216,1,0,0,218,1,0,0,218,1,0,0,220,1,0,0,221,1,0,0,223,1,0,0,223,1,0,0,225,1,0,0,225,1,0,0,227,1,0,0,227,1,0,0,229,1,0,0,229,1,0,0,231,1,0,0,231,1,0,0,233,1,0,0,233,1,0,0,235,1,0,0,235,1,0,0,237,1,0,0,237,1,0,0,239,1,0,0,240,1,0,0,243,1,0,0,243,1,0,0,245,1,0,0,245,1,0,0,249,1,0,0,249,1,0,0,251,1,0,0,251,1,0,0,253,1,0,0,253,1,0,0,255,1,0,0,255,1,0,0,1,2,0,0,1,2,0,0,3,2,0,0,3,2,0,0,5,2,0,0,5,2,0,0,7,2,0,0,7,2,0,0,9,2,0,0,9,2,0,0,11,2,0,0,11,2,0,0,13,2,0,0,13,2,0,0,15,2,0,0,15,2,0,0,17,2,0,0,17,2,0,0,19,2,0,0,19,2,0,0,21,2,0,0,21,2,0,0,23,2,0,0,23,2,0,0,25,2,0,0,25,2,0,0,27,2,0,0,27,2,0,0,29,2,0,0,29,2,0,0,31,2,0,0,31,2,0,0,33,2,0,0,33,2,0,0,35,2,0,0,35,2,0,0,37,2,0,0,37,2,0,0,39,2,0,0,39,2,0,0,41,2,0,0,41,2,0,0,43,2,0,0,43,2,0,0,45,2,0,0,45,2,0,0,47,2,0,0,47,2,0,0,49,2,0,0,49,2,0,0,51,2,0,0,57,2,0,0,60,2,0,0,60,2,0,0,63,2,0,0,64,2,0,0,80,2,0,0,175,2,0,0,144,3,0,0,144,3,0,0,172,3,0,0,206,3,0,0,208,3,0,0,209,3,0,0,213,3,0,0,215,3,0,0,217,3,0,0,217,3,0,0,219,3,0,0,219,3,0,0,221,3,0,0,221,3,0,0,223,3,0,0,223,3,0,0,225,3,0,0,225,3,0,0,227,3,0,0,227,3,0,0,229,3,0,0,229,3,0,0,231,3,0,0,231,3,0,0,233,3,0,0,233,3,0,0,235,3,0,0,235,3,0,0,237,3,0,0,237,3,0,0,239,3,0,0,243,3,0,0,245,3,0,0,245,3,0,0,248,3,0,0,248,3,0,0,251,3,0,0,252,3,0,0,48,4,0,0,95,4,0,0,97,4,0,0,97,4,0,0,99,4,0,0,99,4,0,0,101,4,0,0,101,4,0,0,103,4,0,0,103,4,0,0,105,4,0,0,105,4,0,0,107,4,0,0,107,4,0,0,109,4,0,0,109,4,0,0,111,4,0,0,111,4,0,0,113,4,0,0,113,4,0,0,115,4,0,0,115,4,0,0,117,4,0,0,117,4,0,0,119,4,0,0,119,4,0,0,121,4,0,0,121,4,0,0,123,4,0,0,123,4,0,0,125,4,0,0,125,4,0,0,127,4,0,0,127,4,0,0,129,4,0,0,129,4,0,0,139,4,0,0,139,4,0,0,141,4,0,0,141,4,0,0,143,4,0,0,143,4,0,0,145,4,0,0,145,4,0,0,147,4,0,0,147,4,0,0,149,4,0,0,149,4,0,0,151,4,0,0,151,4,0,0,153,4,0,0,153,4,0,0,155,4,0,0,155,4,0,0,157,4,0,0,157,4,0,0,159,4,0,0,159,4,0,0,161,4,0,0,161,4,0,0,163,4,0,0,163,4,0,0,165,4,0,0,165,4,0,0,167,4,0,0,167,4,0,0,169,4,0,0,169,4,0,0,171,4,0,0,171,4,0,0,173,4,0,0,173,4,0,0,175,4,0,0,175,4,0,0,177,4,0,0,177,4,0,0,179,4,0,0,179,4,0,0,181,4,0,0,181,4,0,0,183,4,0,0,183,4,0,0,185,4,0,0,185,4,0,0,187,4,0,0,187,4,0,0,189,4,0,0,189,4,0,0,191,4,0,0,191,4,0,0,194,4,0,0,194,4,0,0,196,4,0,0,196,4,0,0,198,4,0,0,198,4,0,0,200,4,0,0,200,4,0,0,202,4,0,0,202,4,0,0,204,4,0,0,204,4,0,0,206,4,0,0,206,4,0,0,209,4,0,0,209,4,0,0,211,4,0,0,211,4,0,0,213,4,0,0,213,4,0,0,215,4,0,0,215,4,0,0,217,4,0,0,217,4,0,0,219,4,0,0,219,4,0,0,221,4,0,0,221,4,0,0,223,4,0,0,223,4,0,0,225,4,0,0,225,4,0,0,227,4,0,0,227,4,0,0,229,4,0,0,229,4,0,0,231,4,0,0,231,4,0,0,233,4,0,0,233,4,0,0,235,4,0,0,235,4,0,0,237,4,0,0,237,4,0,0,239,4,0,0,239,4,0,0,241,4,0,0,241,4,0,0,243,4,0,0,243,4,0,0,245,4,0,0,245,4,0,0,247,4,0,0,247,4,0,0,249,4,0,0,249,4,0,0,1,5,0,0,1,5,0,0,3,5,0,0,3,5,0,0,5,5,0,0,5,5,0,0,7,5,0,0,7,5,0,0,9,5,0,0,9,5,0,0,11,5,0,0,11,5,0,0,13,5,0,0,13,5,0,0,15,5,0,0,15,5,0,0,97,5,0,0,135,5,0,0,0,29,0,0,43,29,0,0,98,29,0,0,119,29,0,0,121,29,0,0,154,29,0,0,1,30,0,0,1,30,0,0,3,30,0,0,3,30,0,0,5,30,0,0,5,30,0,0,7,30,0,0,7,30,0,0,9,30,0,0,9,30,0,0,11,30,0,0,11,30,0,0,13,30,0,0,13,30,0,0,15,30,0,0,15,30,0,0,17,30,0,0,17,30,0,0,19,30,0,0,19,30,0,0,21,30,0,0,21,30,0,0,23,30,0,0,23,30,0,0,25,30,0,0,25,30,0,0,27,30,0,0,27,30,0,0,29,30,0,0,29,30,0,0,31,30,0,0,31,30,0,0,33,30,0,0,33,30,0,0,35,30,0,0,35,30,0,0,37,30,0,0,37,30,0,0,39,30,0,0,39,30,0,0,41,30,0,0,41,30,0,0,43,30,0,0,43,30,0,0,45,30,0,0,45,30,0,0,47,30,0,0,47,30,0,0,49,30,0,0,49,30,0,0,51,30,0,0,51,30,0,0,53,30,0,0,53,30,0,0,55,30,0,0,55,30,0,0,57,30,0,0,57,30,0,0,59,30,0,0,59,30,0,0,61,30,0,0,61,30,0,0,63,30,0,0,63,30,0,0,65,30,0,0,65,30,0,0,67,30,0,0,67,30,0,0,69,30,0,0,69,30,0,0,71,30,0,0,71,30,0,0,73,30,0,0,73,30,0,0,75,30,0,0,75,30,0,0,77,30,0,0,77,30,0,0,79,30,0,0,79,30,0,0,81,30,0,0,81,30,0,0,83,30,0,0,83,30,0,0,85,30,0,0,85,30,0,0,87,30,0,0,87,30,0,0,89,30,0,0,89,30,0,0,91,30,0,0,91,30,0,0,93,30,0,0,93,30,0,0,95,30,0,0,95,30,0,0,97,30,0,0,97,30,0,0,99,30,0,0,99,30,0,0,101,30,0,0,101,30,0,0,103,30,0,0,103,30,0,0,105,30,0,0,105,30,0,0,107,30,0,0,107,30,0,0,109,30,0,0,109,30,0,0,111,30,0,0,111,30,0,0,113,30,0,0,113,30,0,0,115,30,0,0,115,30,0,0,117,30,0,0,117,30,0,0,119,30,0,0,119,30,0,0,121,30,0,0,121,30,0,0,123,30,0,0,123,30,0,0,125,30,0,0,125,30,0,0,127,30,0,0,127,30,0,0,129,30,0,0,129,30,0,0,131,30,0,0,131,30,0,0,133,30,0,0,133,30,0,0,135,30,0,0,135,30,0,0,137,30,0,0,137,30,0,0,139,30,0,0,139,30,0,0,141,30], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+376196);
/* memory initializer */ allocate([141,30,0,0,143,30,0,0,143,30,0,0,145,30,0,0,145,30,0,0,147,30,0,0,147,30,0,0,149,30,0,0,155,30,0,0,161,30,0,0,161,30,0,0,163,30,0,0,163,30,0,0,165,30,0,0,165,30,0,0,167,30,0,0,167,30,0,0,169,30,0,0,169,30,0,0,171,30,0,0,171,30,0,0,173,30,0,0,173,30,0,0,175,30,0,0,175,30,0,0,177,30,0,0,177,30,0,0,179,30,0,0,179,30,0,0,181,30,0,0,181,30,0,0,183,30,0,0,183,30,0,0,185,30,0,0,185,30,0,0,187,30,0,0,187,30,0,0,189,30,0,0,189,30,0,0,191,30,0,0,191,30,0,0,193,30,0,0,193,30,0,0,195,30,0,0,195,30,0,0,197,30,0,0,197,30,0,0,199,30,0,0,199,30,0,0,201,30,0,0,201,30,0,0,203,30,0,0,203,30,0,0,205,30,0,0,205,30,0,0,207,30,0,0,207,30,0,0,209,30,0,0,209,30,0,0,211,30,0,0,211,30,0,0,213,30,0,0,213,30,0,0,215,30,0,0,215,30,0,0,217,30,0,0,217,30,0,0,219,30,0,0,219,30,0,0,221,30,0,0,221,30,0,0,223,30,0,0,223,30,0,0,225,30,0,0,225,30,0,0,227,30,0,0,227,30,0,0,229,30,0,0,229,30,0,0,231,30,0,0,231,30,0,0,233,30,0,0,233,30,0,0,235,30,0,0,235,30,0,0,237,30,0,0,237,30,0,0,239,30,0,0,239,30,0,0,241,30,0,0,241,30,0,0,243,30,0,0,243,30,0,0,245,30,0,0,245,30,0,0,247,30,0,0,247,30,0,0,249,30,0,0,249,30,0,0,0,31,0,0,7,31,0,0,16,31,0,0,21,31,0,0,32,31,0,0,39,31,0,0,48,31,0,0,55,31,0,0,64,31,0,0,69,31,0,0,80,31,0,0,87,31,0,0,96,31,0,0,103,31,0,0,112,31,0,0,125,31,0,0,128,31,0,0,135,31,0,0,144,31,0,0,151,31,0,0,160,31,0,0,167,31,0,0,176,31,0,0,180,31,0,0,182,31,0,0,183,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,199,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,215,31,0,0,224,31,0,0,231,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,247,31,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,10,33,0,0,10,33,0,0,14,33,0,0,15,33,0,0,19,33,0,0,19,33,0,0,47,33,0,0,47,33,0,0,52,33,0,0,52,33,0,0,57,33,0,0,57,33,0,0,60,33,0,0,61,33,0,0,70,33,0,0,73,33,0,0,48,44,0,0,94,44,0,0,129,44,0,0,129,44,0,0,131,44,0,0,131,44,0,0,133,44,0,0,133,44,0,0,135,44,0,0,135,44,0,0,137,44,0,0,137,44,0,0,139,44,0,0,139,44,0,0,141,44,0,0,141,44,0,0,143,44,0,0,143,44,0,0,145,44,0,0,145,44,0,0,147,44,0,0,147,44,0,0,149,44,0,0,149,44,0,0,151,44,0,0,151,44,0,0,153,44,0,0,153,44,0,0,155,44,0,0,155,44,0,0,157,44,0,0,157,44,0,0,159,44,0,0,159,44,0,0,161,44,0,0,161,44,0,0,163,44,0,0,163,44,0,0,165,44,0,0,165,44,0,0,167,44,0,0,167,44,0,0,169,44,0,0,169,44,0,0,171,44,0,0,171,44,0,0,173,44,0,0,173,44,0,0,175,44,0,0,175,44,0,0,177,44,0,0,177,44,0,0,179,44,0,0,179,44,0,0,181,44,0,0,181,44,0,0,183,44,0,0,183,44,0,0,185,44,0,0,185,44,0,0,187,44,0,0,187,44,0,0,189,44,0,0,189,44,0,0,191,44,0,0,191,44,0,0,193,44,0,0,193,44,0,0,195,44,0,0,195,44,0,0,197,44,0,0,197,44,0,0,199,44,0,0,199,44,0,0,201,44,0,0,201,44,0,0,203,44,0,0,203,44,0,0,205,44,0,0,205,44,0,0,207,44,0,0,207,44,0,0,209,44,0,0,209,44,0,0,211,44,0,0,211,44,0,0,213,44,0,0,213,44,0,0,215,44,0,0,215,44,0,0,217,44,0,0,217,44,0,0,219,44,0,0,219,44,0,0,221,44,0,0,221,44,0,0,223,44,0,0,223,44,0,0,225,44,0,0,225,44,0,0,227,44,0,0,228,44,0,0,0,45,0,0,37,45,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,65,255,0,0,90,255,0,0,40,4,1,0,79,4,1,0,26,212,1,0,51,212,1,0,78,212,1,0,84,212,1,0,86,212,1,0,103,212,1,0,130,212,1,0,155,212,1,0,182,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,207,212,1,0,234,212,1,0,3,213,1,0,30,213,1,0,55,213,1,0,82,213,1,0,107,213,1,0,134,213,1,0,159,213,1,0,186,213,1,0,211,213,1,0,238,213,1,0,7,214,1,0,34,214,1,0,59,214,1,0,86,214,1,0,111,214,1,0,138,214,1,0,165,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,225,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,27,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,85,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,143,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,167,1,0,0,9,0,0,0,13,0,0,0,32,0,0,0,126,0,0,0,133,0,0,0,133,0,0,0,160,0,0,0,65,2,0,0,80,2,0,0,111,3,0,0,116,3,0,0,117,3,0,0,122,3,0,0,122,3,0,0,126,3,0,0,126,3,0,0,132,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,95,5,0,0,97,5,0,0,135,5,0,0,137,5,0,0,138,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,244,5,0,0,0,6,0,0,3,6,0,0,11,6,0,0,21,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,96,6,0,0,13,7,0,0,15,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,112,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,250,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,241,10,0,0,241,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,250,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,244,13,0,0,1,14,0,0,58,14,0,0,63,14,0,0,91,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,190,15,0,0,204,15,0,0,207,15,0,0,209,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,124,19,0,0,128,19,0,0,153,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,118,22,0,0,128,22,0,0,156,22,0,0,160,22,0,0,240,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,54,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,0,24,0,0,14,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,64,25,0,0,64,25,0,0,68,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,222,25,0,0,27,26,0,0,30,26,0,0,31,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,196,31,0,0,198,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,221,31,0,0,239,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,254,31,0,0,0,32,0,0,99,32,0,0,106,32,0,0,113,32,0,0,116,32,0,0,142,32,0,0,144,32,0,0,148,32,0,0,160,32,0,0,181,32,0,0,208,32,0,0,235,32,0,0,0,33,0,0,76,33,0,0,83,33,0,0,131,33,0,0,144,33,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,96,36,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,192,39,0,0,198,39,0,0,208,39,0,0,235,39,0,0,240,39,0,0,19,43,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,234,44,0,0,249,44,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,240,47,0,0,251,47,0,0,0,48,0,0,63,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,144,49,0,0,183,49,0,0,192,49,0,0,207,49,0,0,240,49,0,0,30,50,0,0,32,50,0,0,67,50,0,0,80,50,0,0,254,50,0,0,0,51,0,0,181,77,0,0,192,77,0,0,187,159,0,0,0,160,0,0,140,164,0,0,144,164,0,0,198,164,0,0,0,167,0,0,22,167,0,0,0,168,0,0,43,168,0,0,0,172,0,0,163,215,0,0,0,224,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,63,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,253,253,0,0,0,254,0,0,25,254,0,0,32,254,0,0,35,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,102,254,0,0,104,254,0,0,107,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,255,254,0,0,255,254,0,0,1,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,224,255,0,0,230,255,0,0,232,255,0,0,238,255,0,0,249,255,0,0,253,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,1,1,0,2,1,1,0,7,1,1,0,51,1,1,0,55,1,1,0,138,1,1,0,0,3,1,0,30,3,1,0,32,3,1,0,35,3,1,0,48,3,1,0,74,3,1,0,128,3,1,0,157,3,1,0,159,3,1,0,195,3,1,0,200,3,1,0,213,3,1,0,0,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,71,10,1,0,80,10,1,0,88,10,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,221,209,1,0,0,210,1,0,69,210,1,0,0,211,1,0,86,211,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,201,215,1,0,206,215,1,0,255,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,0,1,14,0,239,1,14,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,96,0,0,0,33,0,0,0,35,0,0,0,37,0,0,0,42,0,0,0,44,0,0,0,47,0,0,0,58,0,0,0,59,0,0,0,63,0,0,0,64,0,0,0,91,0,0,0,93,0,0,0,95,0,0,0,95,0,0,0,123,0,0,0,123,0,0,0,125,0,0,0,125,0,0,0,161,0,0,0,161,0,0,0,171,0,0,0,171,0,0,0,183,0,0,0,183,0,0,0,187,0,0,0,187,0,0,0,191,0,0,0,191,0,0,0,126,3,0,0,126,3,0,0,135,3,0,0,135,3,0,0,90,5,0,0,95,5,0,0,137,5,0,0,138,5,0,0,190,5,0,0,190,5,0,0,192,5,0,0,192,5,0,0,195,5,0,0,195,5,0,0,198,5,0,0,198,5,0,0,243,5,0,0,244,5,0,0,12,6,0,0,13,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,106,6,0,0,109,6,0,0,212,6,0,0,212,6,0,0,0,7,0,0,13,7,0,0,100,9,0,0,101,9,0,0,112,9,0,0,112,9,0,0,244,13,0,0,244,13,0,0,79,14,0,0,79,14,0,0,90,14,0,0,91,14,0,0,4,15,0,0,18,15,0,0,58,15,0,0,61,15,0,0,133,15,0,0,133,15,0,0,208,15,0,0,209,15,0,0,74,16,0,0,79,16,0,0,251,16,0,0,251,16,0,0,97,19,0,0,104,19,0,0,109,22,0,0,110,22,0,0,155,22,0,0,156,22,0,0,235,22,0,0,237,22,0,0,53,23,0,0,54,23,0,0,212,23,0,0,214,23,0,0,216,23,0,0,218,23,0,0,0,24,0,0,10,24,0,0,68,25,0,0,69,25,0,0,222,25,0,0,223,25,0,0,30,26,0,0,31,26,0,0,16,32,0,0,39,32,0,0,48,32,0,0,67,32,0,0,69,32,0,0,81,32,0,0,83,32,0,0,94,32,0,0,125,32,0,0,126,32,0,0,141,32,0,0,142,32,0,0,41,35,0,0,42,35,0,0,180,35,0,0,182,35,0,0,104,39,0,0,117,39,0,0,197,39,0,0,198,39,0,0,230,39,0,0,235,39,0,0,131,41,0,0,152,41,0,0,216,41,0,0,219,41,0,0,252,41,0,0,253,41,0,0,249,44,0,0,252,44,0,0,254,44,0,0,255,44,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,1,48,0,0,3,48,0,0,8,48,0,0,17,48,0,0,20,48,0,0,31,48,0,0,48,48,0,0,48,48,0,0,61,48,0,0,61,48,0,0,160,48,0,0,160,48,0,0,251,48,0,0,251,48,0,0,62,253,0,0,63,253,0,0,16,254,0,0,25,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,97,254,0,0,99,254,0,0,99,254,0,0,104,254,0,0,104,254,0,0,106,254,0,0,107,254,0,0,1,255,0,0,3,255,0,0,5,255,0,0,10,255,0,0,12,255,0,0,15,255,0,0,26,255,0,0,27,255,0,0,31,255,0,0,32,255,0,0,59,255,0,0,61,255,0,0,63,255,0,0,63,255,0,0,91,255,0,0,91,255,0,0,93,255,0,0,93,255,0,0,95,255,0,0,101,255,0,0,0,1,1,0,1,1,1,0,159,3,1,0,159,3,1,0,80,10,1,0,88,10,1,0,11,0,0,0,9,0,0,0,13,0,0,0,32,0,0,0,32,0,0,0,133,0,0,0,133,0,0,0,160,0,0,0,160,0,0,0,128,22,0,0,128,22,0,0,14,24,0,0,14,24,0,0,0,32,0,0,10,32,0,0,40,32,0,0,41,32,0,0,47,32,0,0,47,32,0,0,95,32,0,0,95,32,0,0,0,48,0,0,0,48,0,0,220,1,0,0,65,0,0,0,90,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,222,0,0,0,0,1,0,0,0,1,0,0,2,1,0,0,2,1,0,0,4,1,0,0,4,1,0,0,6,1,0,0,6,1,0,0,8,1,0,0,8,1,0,0,10,1,0,0,10,1,0,0,12,1,0,0,12,1,0,0,14,1,0,0,14,1,0,0,16,1,0,0,16,1,0,0,18,1,0,0,18,1,0,0,20,1,0,0,20,1,0,0,22,1,0,0,22,1,0,0,24,1,0,0,24,1,0,0,26,1,0,0,26,1,0,0,28,1,0,0,28,1,0,0,30,1,0,0,30,1,0,0,32,1,0,0,32,1,0,0,34,1,0,0,34,1,0,0,36,1,0,0,36,1,0,0,38,1,0,0,38,1,0,0,40,1,0,0,40,1,0,0,42,1,0,0,42,1,0,0,44,1,0,0,44,1,0,0,46,1,0,0,46,1,0,0,48,1,0,0,48,1,0,0,50,1,0,0,50,1,0,0,52,1,0,0,52,1,0,0,54,1,0,0,54,1,0,0,57,1,0,0,57,1,0,0,59,1,0,0,59,1,0,0,61,1,0,0,61,1,0,0,63,1,0,0,63,1,0,0,65,1,0,0,65,1,0,0,67,1,0,0,67,1,0,0,69,1,0,0,69,1,0,0,71,1,0,0,71,1,0,0,74,1,0,0,74,1,0,0,76,1,0,0,76,1,0,0,78,1,0,0,78,1,0,0,80,1,0,0,80,1,0,0,82,1,0,0,82,1,0,0,84,1,0,0,84,1,0,0,86,1,0,0,86,1,0,0,88,1,0,0,88,1,0,0,90,1,0,0,90,1,0,0,92,1,0,0,92,1,0,0,94,1,0,0,94,1,0,0,96,1,0,0,96,1,0,0,98,1,0,0,98,1,0,0,100,1,0,0,100,1,0,0,102,1,0,0,102,1,0,0,104,1,0,0,104,1,0,0,106,1,0,0,106,1,0,0,108,1,0,0,108,1,0,0,110,1,0,0,110,1,0,0,112,1,0,0,112,1,0,0,114,1,0,0,114,1,0,0,116,1,0,0,116,1,0,0,118,1,0,0,118,1,0,0,120,1,0,0,121,1,0,0,123,1,0,0,123,1,0,0,125,1,0,0,125,1,0,0,129,1,0,0,130,1,0,0,132,1,0,0,132,1,0,0,134,1,0,0,135,1,0,0,137,1,0,0,139,1,0,0,142,1,0,0,145,1,0,0,147,1,0,0,148,1,0,0,150,1,0,0,152,1,0,0,156,1,0,0,157,1,0,0,159,1,0,0,160,1,0,0,162,1,0,0,162,1,0,0,164,1,0,0,164,1,0,0,166,1,0,0,167,1,0,0,169,1,0,0,169,1,0,0,172,1,0,0,172,1,0,0,174,1,0,0,175,1,0,0,177,1,0,0,179,1,0,0,181,1,0,0,181,1,0,0,183,1,0,0,184,1,0,0,188,1,0,0,188,1,0,0,196,1,0,0,196,1,0,0,199,1,0,0,199,1,0,0,202,1,0,0,202,1,0,0,205,1,0,0,205,1,0,0,207,1,0,0,207,1,0,0,209,1,0,0,209,1,0,0,211,1,0,0,211,1,0,0,213,1,0,0,213,1,0,0,215,1,0,0,215,1,0,0,217,1,0,0,217,1,0,0,219,1,0,0,219,1,0,0,222,1,0,0,222,1,0,0,224,1,0,0,224,1,0,0,226,1,0,0,226,1,0,0,228,1,0,0,228,1,0,0,230,1,0,0,230,1,0,0,232,1,0,0,232,1,0,0,234,1,0,0,234,1,0,0,236,1,0,0,236,1,0,0,238,1,0,0,238,1,0,0,241,1,0,0,241,1,0,0,244,1,0,0,244,1,0,0,246,1,0,0,248,1,0,0,250,1,0,0,250,1,0,0,252,1,0,0,252,1,0,0,254,1,0,0,254,1,0,0,0,2,0,0,0,2,0,0,2,2,0,0,2,2,0,0,4,2,0,0,4,2,0,0,6,2,0,0,6,2,0,0,8,2,0,0,8,2,0,0,10,2,0,0,10,2,0,0,12,2,0,0,12,2,0,0,14,2,0,0,14,2,0,0,16,2,0,0,16,2,0,0,18,2,0,0,18,2,0,0,20,2,0,0,20,2,0,0,22,2,0,0,22,2,0,0,24,2,0,0,24,2,0,0,26,2,0,0,26,2,0,0,28,2,0,0,28,2,0,0,30,2,0,0,30,2,0,0,32,2,0,0,32,2,0,0,34,2,0,0,34,2,0,0,36,2,0,0,36,2,0,0,38,2,0,0,38,2,0,0,40,2,0,0,40,2,0,0,42,2,0,0,42,2,0,0,44,2,0,0,44,2,0,0,46,2,0,0,46,2,0,0,48,2,0,0,48,2,0,0,50,2,0,0,50,2,0,0,58,2,0,0,59,2,0,0,61,2,0,0,62,2,0,0,65,2,0,0,65,2,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,143,3,0,0,145,3,0,0,161,3,0,0,163,3,0,0,171,3,0,0,210,3,0,0,212,3,0,0,216,3,0,0,216,3,0,0,218,3,0,0,218,3,0,0,220,3,0,0,220,3,0,0,222,3,0,0,222,3,0,0,224,3,0,0,224,3,0,0,226,3,0,0,226,3,0,0,228,3,0,0,228,3,0,0,230,3,0,0,230,3,0,0,232,3,0,0,232,3,0,0,234,3,0,0,234,3,0,0,236,3,0,0,236,3,0,0,238,3,0,0,238,3,0,0,244,3,0,0,244,3,0,0,247,3,0,0,247,3,0,0,249,3,0,0,250,3,0,0,253,3,0,0,47,4,0,0,96,4,0,0,96,4,0,0,98,4,0,0,98,4,0,0,100,4,0,0,100,4,0,0,102,4,0,0,102,4,0,0,104,4,0,0,104,4,0,0,106,4,0,0,106,4,0,0,108,4,0,0,108,4,0,0,110,4,0,0,110,4,0,0,112,4,0,0,112,4,0,0,114,4,0,0,114,4,0,0,116,4,0,0,116,4,0,0,118,4,0,0,118,4,0,0,120,4,0,0,120,4,0,0,122,4,0,0,122,4,0,0,124,4,0,0,124,4,0,0,126,4,0,0,126,4,0,0,128,4,0,0,128,4,0,0,138,4,0,0,138,4,0,0,140,4,0,0,140,4,0,0,142,4,0,0,142,4,0,0,144,4,0,0,144,4,0,0,146,4,0,0,146,4,0,0,148,4,0,0,148,4,0,0,150,4,0,0,150,4,0,0,152,4,0,0,152,4,0,0,154,4,0,0,154,4,0,0,156,4,0,0,156,4,0,0,158,4,0,0,158,4,0,0,160,4,0,0,160,4,0,0,162,4,0,0,162,4,0,0,164,4,0,0,164,4,0,0,166,4,0,0,166,4,0,0,168,4,0,0,168,4,0,0,170,4,0,0,170,4,0,0,172,4,0,0,172,4,0,0,174,4,0,0,174,4,0,0,176,4,0,0,176,4,0,0,178,4,0,0,178,4,0,0,180,4,0,0,180,4,0,0,182,4,0,0,182,4,0,0,184,4,0,0,184,4,0,0,186,4,0,0,186,4,0,0,188,4,0,0,188,4,0,0,190,4,0,0,190,4,0,0,192,4,0,0,193,4,0,0,195,4,0,0,195,4,0,0,197,4,0,0,197,4,0,0,199,4,0,0,199,4,0,0,201,4,0,0,201,4,0,0,203,4,0,0,203,4,0,0,205,4,0,0,205,4,0,0,208,4,0,0,208,4,0,0,210,4,0,0,210,4,0,0,212,4,0,0,212,4,0,0,214,4,0,0,214,4,0,0,216,4,0,0,216,4,0,0,218,4,0,0,218,4,0,0,220,4,0,0,220,4,0,0,222,4,0,0,222,4,0,0,224,4,0,0,224,4,0,0,226,4,0,0,226,4,0,0,228,4,0,0,228,4,0,0,230,4,0,0,230,4,0,0,232,4,0,0,232,4,0,0,234,4,0,0,234,4,0,0,236,4,0,0,236,4,0,0,238,4,0,0,238,4,0,0,240,4,0,0,240,4,0,0,242,4,0,0,242,4,0,0,244,4,0,0,244,4,0,0,246,4,0,0,246,4,0,0,248,4,0,0,248,4,0,0,0,5,0,0,0,5,0,0,2,5,0,0,2,5,0,0,4,5,0,0,4,5,0,0,6,5,0,0,6,5,0,0,8,5,0,0,8,5,0,0,10,5,0,0,10,5,0,0,12,5,0,0,12,5,0,0,14,5,0,0,14,5,0,0,49,5,0,0,86,5,0,0,160,16,0,0,197,16,0,0,0,30,0,0,0,30,0,0,2,30,0,0,2,30,0,0,4,30,0,0,4,30,0,0,6,30,0,0,6,30,0,0,8,30,0,0,8,30,0,0,10,30,0,0,10,30,0,0,12,30,0,0,12,30,0,0,14,30,0,0,14,30,0,0,16,30,0,0,16,30,0,0,18,30,0,0,18,30,0,0,20,30,0,0,20,30,0,0,22,30,0,0,22,30,0,0,24,30,0,0,24,30,0,0,26,30,0,0,26,30,0,0,28,30,0,0,28,30,0,0,30,30,0,0,30,30,0,0,32,30,0,0,32,30,0,0,34,30,0,0,34,30,0,0,36,30,0,0,36,30,0,0,38,30,0,0,38,30,0,0,40,30,0,0,40,30,0,0,42,30,0,0,42,30,0,0,44,30,0,0,44,30,0,0,46,30,0,0,46,30,0,0,48,30,0,0,48,30,0,0,50,30,0,0,50,30,0,0,52,30,0,0,52,30,0,0,54,30,0,0,54,30,0,0,56,30,0,0,56,30,0,0,58,30,0,0,58,30,0,0,60,30,0,0,60,30,0,0,62,30,0,0,62,30,0,0,64,30,0,0,64,30,0,0,66,30,0,0,66,30,0,0,68,30,0,0,68,30,0,0,70,30,0,0,70,30,0,0,72,30,0,0,72,30,0,0,74,30,0,0,74,30,0,0,76,30,0,0,76,30,0,0,78,30,0,0,78,30,0,0,80,30,0,0,80,30,0,0,82,30,0,0,82,30,0,0,84,30,0,0,84,30,0,0,86,30,0,0,86,30,0,0,88,30,0,0,88,30,0,0,90,30,0,0,90,30,0,0,92,30,0,0,92,30,0,0,94,30,0,0,94,30,0,0,96,30,0,0,96,30,0,0,98,30,0,0,98,30,0,0,100,30,0,0,100,30,0,0,102,30,0,0,102,30,0,0,104,30,0,0,104,30,0,0,106,30,0,0,106,30,0,0,108,30,0,0,108,30,0,0,110,30,0,0,110,30,0,0,112,30,0,0,112,30,0,0,114,30,0,0,114,30,0,0,116,30,0,0,116,30,0,0,118,30,0,0,118,30,0,0,120,30,0,0,120,30,0,0,122,30,0,0,122,30,0,0,124,30,0,0,124,30,0,0,126,30,0,0,126,30,0,0,128,30,0,0,128,30,0,0,130,30,0,0,130,30,0,0,132,30,0,0,132,30,0,0,134,30,0,0,134,30,0,0,136,30,0,0,136,30,0,0,138,30,0,0,138,30,0,0,140,30,0,0,140,30,0,0,142,30,0,0,142,30,0,0,144,30,0,0,144,30,0,0,146,30,0,0,146,30,0,0,148,30,0,0,148,30,0,0,160,30,0,0,160,30,0,0,162,30,0,0,162,30,0,0,164,30,0,0,164,30,0,0,166,30,0,0,166,30,0,0,168,30,0,0,168,30,0,0,170,30,0,0,170,30,0,0,172,30,0,0,172,30,0,0,174,30,0,0,174,30,0,0,176,30,0,0,176,30,0,0,178,30,0,0,178,30,0,0,180,30,0,0,180,30,0,0,182,30,0,0,182,30,0,0,184,30,0,0,184,30,0,0,186,30,0,0,186,30,0,0,188,30,0,0,188,30,0,0,190,30,0,0,190,30,0,0,192,30,0,0,192,30,0,0,194,30,0,0,194,30,0,0,196,30,0,0,196,30,0,0,198,30,0,0,198,30,0,0,200,30,0,0,200,30,0,0,202,30,0,0,202,30,0,0,204,30,0,0,204,30,0,0,206,30,0,0,206,30,0,0,208,30,0,0,208,30,0,0,210,30,0,0,210,30,0,0,212,30,0,0,212,30,0,0,214,30,0,0,214,30,0,0,216,30,0,0,216,30,0,0,218,30,0,0,218,30,0,0,220,30,0,0,220,30,0,0,222,30,0,0,222,30,0,0,224,30,0,0,224,30,0,0,226,30,0,0,226,30,0,0,228,30,0,0,228,30,0,0,230,30,0,0,230,30,0,0,232,30,0,0,232,30,0,0,234,30,0,0,234,30,0,0,236,30,0,0,236,30,0,0,238,30,0,0,238,30,0,0,240,30,0,0,240,30,0,0,242,30,0,0,242,30,0,0,244,30,0,0,244,30,0,0,246,30,0,0,246,30,0,0,248,30,0,0,248,30,0,0,8,31,0,0,15,31,0,0,24,31,0,0,29,31,0,0,40,31,0,0,47,31,0,0,56,31,0,0,63,31,0,0,72,31,0,0,77,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,95,31,0,0,104,31,0,0,111,31,0,0,184,31,0,0,187,31,0,0,200,31,0,0,203,31,0,0,216,31,0,0,219,31,0,0,232,31,0,0,236,31,0,0,248,31,0,0,251,31,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,11,33,0,0,13,33,0,0,16,33,0,0,18,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,48,33,0,0,49,33,0,0,51,33,0,0,51,33,0,0,62,33,0,0,63,33,0,0,69,33,0,0,69,33,0,0,0,44,0,0,46,44,0,0,128,44,0,0,128,44,0,0,130,44,0,0,130,44,0,0,132,44,0,0,132,44,0,0,134,44,0,0,134,44,0,0,136,44,0,0,136,44,0,0,138,44,0,0,138,44,0,0,140,44,0,0,140,44,0,0,142,44,0,0,142,44,0,0,144,44,0,0,144,44,0,0,146,44,0,0,146,44,0,0,148,44,0,0,148,44,0,0,150,44,0,0,150,44,0,0,152,44,0,0,152,44,0,0,154,44,0,0,154,44,0,0,156,44,0,0,156,44,0,0,158,44,0,0,158,44,0,0,160,44,0,0,160,44,0,0,162,44,0,0,162,44,0,0,164,44,0,0,164,44,0,0,166,44,0,0,166,44,0,0,168,44,0,0,168,44,0,0,170,44,0,0,170,44,0,0,172,44,0,0,172,44,0,0,174,44,0,0,174,44,0,0,176,44,0,0,176,44,0,0,178,44,0,0,178,44,0,0,180,44,0,0,180,44,0,0,182,44,0,0,182,44,0,0,184,44,0,0,184,44,0,0,186,44,0,0,186,44,0,0,188,44,0,0,188,44,0,0,190,44,0,0,190,44,0,0,192,44,0,0,192,44,0,0,194,44,0,0,194,44,0,0,196,44,0,0,196,44,0,0,198,44,0,0,198,44,0,0,200,44,0,0,200,44,0,0,202,44,0,0,202,44,0,0,204,44,0,0,204,44,0,0,206,44,0,0,206,44,0,0,208,44,0,0,208,44,0,0,210,44,0,0,210,44,0,0,212,44,0,0,212,44,0,0,214,44,0,0,214,44,0,0,216,44,0,0,216,44,0,0,218,44,0,0,218,44,0,0,220,44,0,0,220,44,0,0,222,44,0,0,222,44,0,0,224,44,0,0,224,44,0,0,226,44,0,0,226,44,0,0,33,255,0,0,58,255,0,0,0,4,1,0,39,4,1,0,0,212,1,0,25,212,1,0,52,212,1,0,77,212,1,0,104,212,1,0,129,212,1,0,156,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,181,212,1,0,208,212,1,0,233,212,1,0,4,213,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,56,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,108,213,1,0,133,213,1,0,160,213,1,0,185,213,1,0,212,213,1,0,237,213,1,0,8,214,1,0,33,214,1,0,60,214,1,0,85,214,1,0,112,214,1,0,137,214,1,0,168,214,1,0,192,214,1,0,226,214,1,0,250,214,1,0,28,215,1,0,52,215,1,0,86,215,1,0,110,215,1,0,144,215,1,0,168,215,1,0,3,0,0,0,48,0,0,0,57,0,0,0,65,0,0,0,70,0,0,0,97,0,0,0,102,0,0,0,208,1,0,0,48,0,0,0,57,0,0,0,65,0,0,0,90,0,0,0,95,0,0,0,95,0,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,178,0,0,0,179,0,0,0,181,0,0,0,181,0,0,0,185,0,0,0,186,0,0,0,188,0,0,0,190,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,246,0,0,0,248,0,0,0,65,2,0,0,80,2,0,0,193,2,0,0,198,2,0,0,209,2,0,0,224,2,0,0,228,2,0,0,238,2,0,0,238,2,0,0,0,3,0,0,111,3,0,0,122,3,0,0,122,3,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,245,3,0,0,247,3,0,0,129,4,0,0,131,4,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,89,5,0,0,97,5,0,0,135,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,189,5,0,0,191,5,0,0,191,5,0,0,193,5,0,0,194,5,0,0,196,5,0,0,197,5,0,0,199,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,242,5,0,0,16,6,0,0,21,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,96,6,0,0,105,6,0,0,110,6,0,0,211,6,0,0,213,6,0,0,220,6,0,0,222,6,0,0,232,6,0,0,234,6,0,0,252,6,0,0,255,6,0,0,255,6,0,0,16,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,99,9,0,0,102,9,0,0,111,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,241,9,0,0,244,9,0,0,249,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+386436);
/* memory initializer */ allocate([40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,111,11,0,0,113,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,242,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,243,13,0,0,1,14,0,0,58,14,0,0,64,14,0,0,78,14,0,0,80,14,0,0,89,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,0,15,0,0,24,15,0,0,25,15,0,0,32,15,0,0,51,15,0,0,53,15,0,0,53,15,0,0,55,15,0,0,55,15,0,0,57,15,0,0,57,15,0,0,62,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,132,15,0,0,134,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,198,15,0,0,198,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,73,16,0,0,80,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,250,16,0,0,252,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,95,19,0,0,105,19,0,0,124,19,0,0,128,19,0,0,143,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,108,22,0,0,111,22,0,0,118,22,0,0,129,22,0,0,154,22,0,0,160,22,0,0,234,22,0,0,238,22,0,0,240,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,52,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,179,23,0,0,182,23,0,0,211,23,0,0,215,23,0,0,215,23,0,0,220,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,11,24,0,0,13,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,70,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,0,26,0,0,27,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,188,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,204,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,224,31,0,0,236,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,252,31,0,0,63,32,0,0,64,32,0,0,84,32,0,0,84,32,0,0,112,32,0,0,113,32,0,0,116,32,0,0,121,32,0,0,127,32,0,0,137,32,0,0,144,32,0,0,148,32,0,0,208,32,0,0,235,32,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,10,33,0,0,19,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,47,33,0,0,49,33,0,0,51,33,0,0,57,33,0,0,60,33,0,0,63,33,0,0,69,33,0,0,73,33,0,0,83,33,0,0,131,33,0,0,96,36,0,0,155,36,0,0,234,36,0,0,255,36,0,0,118,39,0,0,147,39,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,228,44,0,0,253,44,0,0,253,44,0,0,0,45,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,5,48,0,0,7,48,0,0,33,48,0,0,47,48,0,0,49,48,0,0,53,48,0,0,56,48,0,0,60,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,154,48,0,0,157,48,0,0,159,48,0,0,161,48,0,0,250,48,0,0,252,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,146,49,0,0,149,49,0,0,160,49,0,0,183,49,0,0,240,49,0,0,255,49,0,0,32,50,0,0,41,50,0,0,81,50,0,0,95,50,0,0,128,50,0,0,137,50,0,0,177,50,0,0,191,50,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,160,0,0,140,164,0,0,0,168,0,0,39,168,0,0,0,172,0,0,163,215,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,40,251,0,0,42,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,251,253,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,51,254,0,0,52,254,0,0,77,254,0,0,79,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,16,255,0,0,25,255,0,0,33,255,0,0,58,255,0,0,63,255,0,0,63,255,0,0,65,255,0,0,90,255,0,0,102,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,7,1,1,0,51,1,1,0,64,1,1,0,120,1,1,0,138,1,1,0,138,1,1,0,0,3,1,0,30,3,1,0,32,3,1,0,35,3,1,0,48,3,1,0,74,3,1,0,128,3,1,0,157,3,1,0,160,3,1,0,195,3,1,0,200,3,1,0,207,3,1,0,209,3,1,0,213,3,1,0,0,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,71,10,1,0,101,209,1,0,105,209,1,0,109,209,1,0,114,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,66,210,1,0,68,210,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,192,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,250,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,52,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,110,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,168,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,206,215,1,0,255,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,0,1,14,0,239,1,14,0,180,1,0,0,48,0,0,0,57,0,0,0,65,0,0,0,90,0,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,181,0,0,0,181,0,0,0,186,0,0,0,186,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,246,0,0,0,248,0,0,0,65,2,0,0,80,2,0,0,193,2,0,0,198,2,0,0,209,2,0,0,224,2,0,0,228,2,0,0,238,2,0,0,238,2,0,0,0,3,0,0,111,3,0,0,122,3,0,0,122,3,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,245,3,0,0,247,3,0,0,129,4,0,0,131,4,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,89,5,0,0,97,5,0,0,135,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,189,5,0,0,191,5,0,0,191,5,0,0,193,5,0,0,194,5,0,0,196,5,0,0,197,5,0,0,199,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,242,5,0,0,16,6,0,0,21,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,96,6,0,0,105,6,0,0,110,6,0,0,211,6,0,0,213,6,0,0,220,6,0,0,222,6,0,0,232,6,0,0,234,6,0,0,252,6,0,0,255,6,0,0,255,6,0,0,16,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,99,9,0,0,102,9,0,0,111,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,241,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,111,11,0,0,113,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,239,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,243,13,0,0,1,14,0,0,58,14,0,0,64,14,0,0,78,14,0,0,80,14,0,0,89,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,0,15,0,0,24,15,0,0,25,15,0,0,32,15,0,0,41,15,0,0,53,15,0,0,53,15,0,0,55,15,0,0,55,15,0,0,57,15,0,0,57,15,0,0,62,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,132,15,0,0,134,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,198,15,0,0,198,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,73,16,0,0,80,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,250,16,0,0,252,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,95,19,0,0,128,19,0,0,143,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,108,22,0,0,111,22,0,0,118,22,0,0,129,22,0,0,154,22,0,0,160,22,0,0,234,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,52,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,179,23,0,0,182,23,0,0,211,23,0,0,215,23,0,0,215,23,0,0,220,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,11,24,0,0,13,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,70,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,0,26,0,0,27,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,188,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,204,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,224,31,0,0,236,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,252,31,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,144,32,0,0,148,32,0,0,208,32,0,0,235,32,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,10,33,0,0,19,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,47,33,0,0,49,33,0,0,51,33,0,0,57,33,0,0,60,33,0,0,63,33,0,0,69,33,0,0,73,33,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,228,44,0,0,0,45,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,5,48,0,0,6,48,0,0,42,48,0,0,47,48,0,0,49,48,0,0,53,48,0,0,59,48,0,0,60,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,154,48,0,0,157,48,0,0,159,48,0,0,161,48,0,0,250,48,0,0,252,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,160,49,0,0,183,49,0,0,240,49,0,0,255,49,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,160,0,0,140,164,0,0,0,168,0,0,39,168,0,0,0,172,0,0,163,215,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,40,251,0,0,42,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,251,253,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,16,255,0,0,25,255,0,0,33,255,0,0,58,255,0,0,65,255,0,0,90,255,0,0,102,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,3,1,0,30,3,1,0,48,3,1,0,73,3,1,0,128,3,1,0,157,3,1,0,160,3,1,0,195,3,1,0,200,3,1,0,207,3,1,0,0,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,63,10,1,0,101,209,1,0,105,209,1,0,109,209,1,0,114,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,66,210,1,0,68,210,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,192,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,250,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,52,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,110,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,168,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,206,215,1,0,255,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,0,1,14,0,239,1,14,0,1,0,0,0,0,0,0,0,127,0,0,0,1,0,0,0,0,0,0,0,255,255,16,0,164,1,0,0,0,0,0,0,65,2,0,0,80,2,0,0,111,3,0,0,116,3,0,0,117,3,0,0,122,3,0,0,122,3,0,0,126,3,0,0,126,3,0,0,132,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,95,5,0,0,97,5,0,0,135,5,0,0,137,5,0,0,138,5,0,0,145,5,0,0,185,5,0,0,187,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,244,5,0,0,0,6,0,0,3,6,0,0,11,6,0,0,21,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,33,6,0,0,58,6,0,0,64,6,0,0,94,6,0,0,96,6,0,0,13,7,0,0,15,7,0,0,74,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,177,7,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,112,9,0,0,125,9,0,0,125,9,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,250,9,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,241,10,0,0,241,10,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,113,11,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,250,11,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,244,13,0,0,1,14,0,0,58,14,0,0,63,14,0,0,91,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,190,15,0,0,204,15,0,0,207,15,0,0,209,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,89,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,124,19,0,0,128,19,0,0,153,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,118,22,0,0,128,22,0,0,156,22,0,0,160,22,0,0,240,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,32,23,0,0,54,23,0,0,64,23,0,0,83,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,128,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,0,24,0,0,14,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,64,25,0,0,64,25,0,0,68,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,222,25,0,0,27,26,0,0,30,26,0,0,31,26,0,0,0,29,0,0,195,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,196,31,0,0,198,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,221,31,0,0,239,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,254,31,0,0,0,32,0,0,99,32,0,0,106,32,0,0,113,32,0,0,116,32,0,0,142,32,0,0,144,32,0,0,148,32,0,0,160,32,0,0,181,32,0,0,208,32,0,0,235,32,0,0,0,33,0,0,76,33,0,0,83,33,0,0,131,33,0,0,144,33,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,96,36,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,192,39,0,0,198,39,0,0,208,39,0,0,235,39,0,0,240,39,0,0,19,43,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,234,44,0,0,249,44,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,240,47,0,0,251,47,0,0,0,48,0,0,63,48,0,0,65,48,0,0,150,48,0,0,153,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,144,49,0,0,183,49,0,0,192,49,0,0,207,49,0,0,240,49,0,0,30,50,0,0,32,50,0,0,67,50,0,0,80,50,0,0,254,50,0,0,0,51,0,0,181,77,0,0,192,77,0,0,187,159,0,0,0,160,0,0,140,164,0,0,144,164,0,0,198,164,0,0,0,167,0,0,22,167,0,0,0,168,0,0,43,168,0,0,0,172,0,0,163,215,0,0,0,216,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,63,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,253,253,0,0,0,254,0,0,25,254,0,0,32,254,0,0,35,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,102,254,0,0,104,254,0,0,107,254,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,255,254,0,0,255,254,0,0,1,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,224,255,0,0,230,255,0,0,232,255,0,0,238,255,0,0,249,255,0,0,253,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,1,1,0,2,1,1,0,7,1,1,0,51,1,1,0,55,1,1,0,138,1,1,0,0,3,1,0,30,3,1,0,32,3,1,0,35,3,1,0,48,3,1,0,74,3,1,0,128,3,1,0,157,3,1,0,159,3,1,0,195,3,1,0,200,3,1,0,213,3,1,0,0,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,71,10,1,0,80,10,1,0,88,10,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,221,209,1,0,0,210,1,0,69,210,1,0,0,211,1,0,86,211,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,201,215,1,0,206,215,1,0,255,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,0,1,14,0,239,1,14,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,166,1,0,0,0,0,0,0,31,0,0,0,127,0,0,0,159,0,0,0,173,0,0,0,173,0,0,0,66,2,0,0,79,2,0,0,112,3,0,0,115,3,0,0,118,3,0,0,121,3,0,0,123,3,0,0,125,3,0,0,127,3,0,0,131,3,0,0,139,3,0,0,139,3,0,0,141,3,0,0,141,3,0,0,162,3,0,0,162,3,0,0,207,3,0,0,207,3,0,0,135,4,0,0,135,4,0,0,207,4,0,0,207,4,0,0,250,4,0,0,255,4,0,0,16,5,0,0,48,5,0,0,87,5,0,0,88,5,0,0,96,5,0,0,96,5,0,0,136,5,0,0,136,5,0,0,139,5,0,0,144,5,0,0,186,5,0,0,186,5,0,0,200,5,0,0,207,5,0,0,235,5,0,0,239,5,0,0,245,5,0,0,10,6,0,0,22,6,0,0,26,6,0,0,28,6,0,0,29,6,0,0,32,6,0,0,32,6,0,0,59,6,0,0,63,6,0,0,95,6,0,0,95,6,0,0,221,6,0,0,221,6,0,0,14,7,0,0,15,7,0,0,75,7,0,0,76,7,0,0,110,7,0,0,127,7,0,0,178,7,0,0,0,9,0,0,58,9,0,0,59,9,0,0,78,9,0,0,79,9,0,0,85,9,0,0,87,9,0,0,113,9,0,0,124,9,0,0,126,9,0,0,128,9,0,0,132,9,0,0,132,9,0,0,141,9,0,0,142,9,0,0,145,9,0,0,146,9,0,0,169,9,0,0,169,9,0,0,177,9,0,0,177,9,0,0,179,9,0,0,181,9,0,0,186,9,0,0,187,9,0,0,197,9,0,0,198,9,0,0,201,9,0,0,202,9,0,0,207,9,0,0,214,9,0,0,216,9,0,0,219,9,0,0,222,9,0,0,222,9,0,0,228,9,0,0,229,9,0,0,251,9,0,0,0,10,0,0,4,10,0,0,4,10,0,0,11,10,0,0,14,10,0,0,17,10,0,0,18,10,0,0,41,10,0,0,41,10,0,0,49,10,0,0,49,10,0,0,52,10,0,0,52,10,0,0,55,10,0,0,55,10], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+396676);
/* memory initializer */ allocate([58,10,0,0,59,10,0,0,61,10,0,0,61,10,0,0,67,10,0,0,70,10,0,0,73,10,0,0,74,10,0,0,78,10,0,0,88,10,0,0,93,10,0,0,93,10,0,0,95,10,0,0,101,10,0,0,117,10,0,0,128,10,0,0,132,10,0,0,132,10,0,0,142,10,0,0,142,10,0,0,146,10,0,0,146,10,0,0,169,10,0,0,169,10,0,0,177,10,0,0,177,10,0,0,180,10,0,0,180,10,0,0,186,10,0,0,187,10,0,0,198,10,0,0,198,10,0,0,202,10,0,0,202,10,0,0,206,10,0,0,207,10,0,0,209,10,0,0,223,10,0,0,228,10,0,0,229,10,0,0,240,10,0,0,240,10,0,0,242,10,0,0,0,11,0,0,4,11,0,0,4,11,0,0,13,11,0,0,14,11,0,0,17,11,0,0,18,11,0,0,41,11,0,0,41,11,0,0,49,11,0,0,49,11,0,0,52,11,0,0,52,11,0,0,58,11,0,0,59,11,0,0,68,11,0,0,70,11,0,0,73,11,0,0,74,11,0,0,78,11,0,0,85,11,0,0,88,11,0,0,91,11,0,0,94,11,0,0,94,11,0,0,98,11,0,0,101,11,0,0,114,11,0,0,129,11,0,0,132,11,0,0,132,11,0,0,139,11,0,0,141,11,0,0,145,11,0,0,145,11,0,0,150,11,0,0,152,11,0,0,155,11,0,0,155,11,0,0,157,11,0,0,157,11,0,0,160,11,0,0,162,11,0,0,165,11,0,0,167,11,0,0,171,11,0,0,173,11,0,0,186,11,0,0,189,11,0,0,195,11,0,0,197,11,0,0,201,11,0,0,201,11,0,0,206,11,0,0,214,11,0,0,216,11,0,0,229,11,0,0,251,11,0,0,0,12,0,0,4,12,0,0,4,12,0,0,13,12,0,0,13,12,0,0,17,12,0,0,17,12,0,0,41,12,0,0,41,12,0,0,52,12,0,0,52,12,0,0,58,12,0,0,61,12,0,0,69,12,0,0,69,12,0,0,73,12,0,0,73,12,0,0,78,12,0,0,84,12,0,0,87,12,0,0,95,12,0,0,98,12,0,0,101,12,0,0,112,12,0,0,129,12,0,0,132,12,0,0,132,12,0,0,141,12,0,0,141,12,0,0,145,12,0,0,145,12,0,0,169,12,0,0,169,12,0,0,180,12,0,0,180,12,0,0,186,12,0,0,187,12,0,0,197,12,0,0,197,12,0,0,201,12,0,0,201,12,0,0,206,12,0,0,212,12,0,0,215,12,0,0,221,12,0,0,223,12,0,0,223,12,0,0,226,12,0,0,229,12,0,0,240,12,0,0,1,13,0,0,4,13,0,0,4,13,0,0,13,13,0,0,13,13,0,0,17,13,0,0,17,13,0,0,41,13,0,0,41,13,0,0,58,13,0,0,61,13,0,0,68,13,0,0,69,13,0,0,73,13,0,0,73,13,0,0,78,13,0,0,86,13,0,0,88,13,0,0,95,13,0,0,98,13,0,0,101,13,0,0,112,13,0,0,129,13,0,0,132,13,0,0,132,13,0,0,151,13,0,0,153,13,0,0,178,13,0,0,178,13,0,0,188,13,0,0,188,13,0,0,190,13,0,0,191,13,0,0,199,13,0,0,201,13,0,0,203,13,0,0,206,13,0,0,213,13,0,0,213,13,0,0,215,13,0,0,215,13,0,0,224,13,0,0,241,13,0,0,245,13,0,0,0,14,0,0,59,14,0,0,62,14,0,0,92,14,0,0,128,14,0,0,131,14,0,0,131,14,0,0,133,14,0,0,134,14,0,0,137,14,0,0,137,14,0,0,139,14,0,0,140,14,0,0,142,14,0,0,147,14,0,0,152,14,0,0,152,14,0,0,160,14,0,0,160,14,0,0,164,14,0,0,164,14,0,0,166,14,0,0,166,14,0,0,168,14,0,0,169,14,0,0,172,14,0,0,172,14,0,0,186,14,0,0,186,14,0,0,190,14,0,0,191,14,0,0,197,14,0,0,197,14,0,0,199,14,0,0,199,14,0,0,206,14,0,0,207,14,0,0,218,14,0,0,219,14,0,0,222,14,0,0,255,14,0,0,72,15,0,0,72,15,0,0,107,15,0,0,112,15,0,0,140,15,0,0,143,15,0,0,152,15,0,0,152,15,0,0,189,15,0,0,189,15,0,0,205,15,0,0,206,15,0,0,210,15,0,0,255,15,0,0,34,16,0,0,34,16,0,0,40,16,0,0,40,16,0,0,43,16,0,0,43,16,0,0,51,16,0,0,53,16,0,0,58,16,0,0,63,16,0,0,90,16,0,0,159,16,0,0,198,16,0,0,207,16,0,0,253,16,0,0,255,16,0,0,90,17,0,0,94,17,0,0,163,17,0,0,167,17,0,0,250,17,0,0,255,17,0,0,73,18,0,0,73,18,0,0,78,18,0,0,79,18,0,0,87,18,0,0,87,18,0,0,89,18,0,0,89,18,0,0,94,18,0,0,95,18,0,0,137,18,0,0,137,18,0,0,142,18,0,0,143,18,0,0,177,18,0,0,177,18,0,0,182,18,0,0,183,18,0,0,191,18,0,0,191,18,0,0,193,18,0,0,193,18,0,0,198,18,0,0,199,18,0,0,215,18,0,0,215,18,0,0,17,19,0,0,17,19,0,0,22,19,0,0,23,19,0,0,91,19,0,0,94,19,0,0,125,19,0,0,127,19,0,0,154,19,0,0,159,19,0,0,245,19,0,0,0,20,0,0,119,22,0,0,127,22,0,0,157,22,0,0,159,22,0,0,241,22,0,0,255,22,0,0,13,23,0,0,13,23,0,0,21,23,0,0,31,23,0,0,55,23,0,0,63,23,0,0,84,23,0,0,95,23,0,0,109,23,0,0,109,23,0,0,113,23,0,0,113,23,0,0,116,23,0,0,127,23,0,0,180,23,0,0,181,23,0,0,222,23,0,0,223,23,0,0,234,23,0,0,239,23,0,0,250,23,0,0,255,23,0,0,15,24,0,0,15,24,0,0,26,24,0,0,31,24,0,0,120,24,0,0,127,24,0,0,170,24,0,0,255,24,0,0,29,25,0,0,31,25,0,0,44,25,0,0,47,25,0,0,60,25,0,0,63,25,0,0,65,25,0,0,67,25,0,0,110,25,0,0,111,25,0,0,117,25,0,0,127,25,0,0,170,25,0,0,175,25,0,0,202,25,0,0,207,25,0,0,218,25,0,0,221,25,0,0,28,26,0,0,29,26,0,0,32,26,0,0,255,28,0,0,196,29,0,0,255,29,0,0,156,30,0,0,159,30,0,0,250,30,0,0,255,30,0,0,22,31,0,0,23,31,0,0,30,31,0,0,31,31,0,0,70,31,0,0,71,31,0,0,78,31,0,0,79,31,0,0,88,31,0,0,88,31,0,0,90,31,0,0,90,31,0,0,92,31,0,0,92,31,0,0,94,31,0,0,94,31,0,0,126,31,0,0,127,31,0,0,181,31,0,0,181,31,0,0,197,31,0,0,197,31,0,0,212,31,0,0,213,31,0,0,220,31,0,0,220,31,0,0,240,31,0,0,241,31,0,0,245,31,0,0,245,31,0,0,255,31,0,0,255,31,0,0,11,32,0,0,15,32,0,0,42,32,0,0,46,32,0,0,96,32,0,0,111,32,0,0,114,32,0,0,115,32,0,0,143,32,0,0,143,32,0,0,149,32,0,0,159,32,0,0,182,32,0,0,207,32,0,0,236,32,0,0,255,32,0,0,77,33,0,0,82,33,0,0,132,33,0,0,143,33,0,0,220,35,0,0,255,35,0,0,39,36,0,0,63,36,0,0,75,36,0,0,95,36,0,0,157,38,0,0,159,38,0,0,178,38,0,0,0,39,0,0,5,39,0,0,5,39,0,0,10,39,0,0,11,39,0,0,40,39,0,0,40,39,0,0,76,39,0,0,76,39,0,0,78,39,0,0,78,39,0,0,83,39,0,0,85,39,0,0,87,39,0,0,87,39,0,0,95,39,0,0,96,39,0,0,149,39,0,0,151,39,0,0,176,39,0,0,176,39,0,0,191,39,0,0,191,39,0,0,199,39,0,0,207,39,0,0,236,39,0,0,239,39,0,0,20,43,0,0,255,43,0,0,47,44,0,0,47,44,0,0,95,44,0,0,127,44,0,0,235,44,0,0,248,44,0,0,38,45,0,0,47,45,0,0,102,45,0,0,110,45,0,0,112,45,0,0,127,45,0,0,151,45,0,0,159,45,0,0,167,45,0,0,167,45,0,0,175,45,0,0,175,45,0,0,183,45,0,0,183,45,0,0,191,45,0,0,191,45,0,0,199,45,0,0,199,45,0,0,207,45,0,0,207,45,0,0,215,45,0,0,215,45,0,0,223,45,0,0,255,45,0,0,24,46,0,0,27,46,0,0,30,46,0,0,127,46,0,0,154,46,0,0,154,46,0,0,244,46,0,0,255,46,0,0,214,47,0,0,239,47,0,0,252,47,0,0,255,47,0,0,64,48,0,0,64,48,0,0,151,48,0,0,152,48,0,0,0,49,0,0,4,49,0,0,45,49,0,0,48,49,0,0,143,49,0,0,143,49,0,0,184,49,0,0,191,49,0,0,208,49,0,0,239,49,0,0,31,50,0,0,31,50,0,0,68,50,0,0,79,50,0,0,255,50,0,0,255,50,0,0,182,77,0,0,191,77,0,0,188,159,0,0,255,159,0,0,141,164,0,0,143,164,0,0,199,164,0,0,255,166,0,0,23,167,0,0,255,167,0,0,44,168,0,0,255,171,0,0,164,215,0,0,255,248,0,0,46,250,0,0,47,250,0,0,107,250,0,0,111,250,0,0,218,250,0,0,255,250,0,0,7,251,0,0,18,251,0,0,24,251,0,0,28,251,0,0,55,251,0,0,55,251,0,0,61,251,0,0,61,251,0,0,63,251,0,0,63,251,0,0,66,251,0,0,66,251,0,0,69,251,0,0,69,251,0,0,178,251,0,0,210,251,0,0,64,253,0,0,79,253,0,0,144,253,0,0,145,253,0,0,200,253,0,0,239,253,0,0,254,253,0,0,255,253,0,0,26,254,0,0,31,254,0,0,36,254,0,0,47,254,0,0,83,254,0,0,83,254,0,0,103,254,0,0,103,254,0,0,108,254,0,0,111,254,0,0,117,254,0,0,117,254,0,0,253,254,0,0,0,255,0,0,191,255,0,0,193,255,0,0,200,255,0,0,201,255,0,0,208,255,0,0,209,255,0,0,216,255,0,0,217,255,0,0,221,255,0,0,223,255,0,0,231,255,0,0,231,255,0,0,239,255,0,0,251,255,0,0,254,255,0,0,255,255,0,0,12,0,1,0,12,0,1,0,39,0,1,0,39,0,1,0,59,0,1,0,59,0,1,0,62,0,1,0,62,0,1,0,78,0,1,0,79,0,1,0,94,0,1,0,127,0,1,0,251,0,1,0,255,0,1,0,3,1,1,0,6,1,1,0,52,1,1,0,54,1,1,0,139,1,1,0,255,2,1,0,31,3,1,0,31,3,1,0,36,3,1,0,47,3,1,0,75,3,1,0,127,3,1,0,158,3,1,0,158,3,1,0,196,3,1,0,199,3,1,0,214,3,1,0,255,3,1,0,158,4,1,0,159,4,1,0,170,4,1,0,255,7,1,0,6,8,1,0,7,8,1,0,9,8,1,0,9,8,1,0,54,8,1,0,54,8,1,0,57,8,1,0,59,8,1,0,61,8,1,0,62,8,1,0,64,8,1,0,255,9,1,0,4,10,1,0,4,10,1,0,7,10,1,0,11,10,1,0,20,10,1,0,20,10,1,0,24,10,1,0,24,10,1,0,52,10,1,0,55,10,1,0,59,10,1,0,62,10,1,0,72,10,1,0,79,10,1,0,89,10,1,0,255,207,1,0,246,208,1,0,255,208,1,0,39,209,1,0,41,209,1,0,115,209,1,0,122,209,1,0,222,209,1,0,255,209,1,0,70,210,1,0,255,210,1,0,87,211,1,0,255,211,1,0,85,212,1,0,85,212,1,0,157,212,1,0,157,212,1,0,160,212,1,0,161,212,1,0,163,212,1,0,164,212,1,0,167,212,1,0,168,212,1,0,173,212,1,0,173,212,1,0,186,212,1,0,186,212,1,0,188,212,1,0,188,212,1,0,196,212,1,0,196,212,1,0,6,213,1,0,6,213,1,0,11,213,1,0,12,213,1,0,21,213,1,0,21,213,1,0,29,213,1,0,29,213,1,0,58,213,1,0,58,213,1,0,63,213,1,0,63,213,1,0,69,213,1,0,69,213,1,0,71,213,1,0,73,213,1,0,81,213,1,0,81,213,1,0,166,214,1,0,167,214,1,0,202,215,1,0,205,215,1,0,0,216,1,0,255,255,1,0,215,166,2,0,255,247,2,0,30,250,2,0,255,0,14,0,240,1,14,0,255,255,16,0,2,0,0,0,0,0,0,0,31,0,0,0,127,0,0,0,159,0,0,0,14,0,0,0,173,0,0,0,173,0,0,0,0,6,0,0,3,6,0,0,221,6,0,0,221,6,0,0,15,7,0,0,15,7,0,0,180,23,0,0,181,23,0,0,11,32,0,0,15,32,0,0,42,32,0,0,46,32,0,0,96,32,0,0,99,32,0,0,106,32,0,0,111,32,0,0,255,254,0,0,255,254,0,0,249,255,0,0,251,255,0,0,115,209,1,0,122,209,1,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,164,1,0,0,66,2,0,0,79,2,0,0,112,3,0,0,115,3,0,0,118,3,0,0,121,3,0,0,123,3,0,0,125,3,0,0,127,3,0,0,131,3,0,0,139,3,0,0,139,3,0,0,141,3,0,0,141,3,0,0,162,3,0,0,162,3,0,0,207,3,0,0,207,3,0,0,135,4,0,0,135,4,0,0,207,4,0,0,207,4,0,0,250,4,0,0,255,4,0,0,16,5,0,0,48,5,0,0,87,5,0,0,88,5,0,0,96,5,0,0,96,5,0,0,136,5,0,0,136,5,0,0,139,5,0,0,144,5,0,0,186,5,0,0,186,5,0,0,200,5,0,0,207,5,0,0,235,5,0,0,239,5,0,0,245,5,0,0,255,5,0,0,4,6,0,0,10,6,0,0,22,6,0,0,26,6,0,0,28,6,0,0,29,6,0,0,32,6,0,0,32,6,0,0,59,6,0,0,63,6,0,0,95,6,0,0,95,6,0,0,14,7,0,0,14,7,0,0,75,7,0,0,76,7,0,0,110,7,0,0,127,7,0,0,178,7,0,0,0,9,0,0,58,9,0,0,59,9,0,0,78,9,0,0,79,9,0,0,85,9,0,0,87,9,0,0,113,9,0,0,124,9,0,0,126,9,0,0,128,9,0,0,132,9,0,0,132,9,0,0,141,9,0,0,142,9,0,0,145,9,0,0,146,9,0,0,169,9,0,0,169,9,0,0,177,9,0,0,177,9,0,0,179,9,0,0,181,9,0,0,186,9,0,0,187,9,0,0,197,9,0,0,198,9,0,0,201,9,0,0,202,9,0,0,207,9,0,0,214,9,0,0,216,9,0,0,219,9,0,0,222,9,0,0,222,9,0,0,228,9,0,0,229,9,0,0,251,9,0,0,0,10,0,0,4,10,0,0,4,10,0,0,11,10,0,0,14,10,0,0,17,10,0,0,18,10,0,0,41,10,0,0,41,10,0,0,49,10,0,0,49,10,0,0,52,10,0,0,52,10,0,0,55,10,0,0,55,10,0,0,58,10,0,0,59,10,0,0,61,10,0,0,61,10,0,0,67,10,0,0,70,10,0,0,73,10,0,0,74,10,0,0,78,10,0,0,88,10,0,0,93,10,0,0,93,10,0,0,95,10,0,0,101,10,0,0,117,10,0,0,128,10,0,0,132,10,0,0,132,10,0,0,142,10,0,0,142,10,0,0,146,10,0,0,146,10,0,0,169,10,0,0,169,10,0,0,177,10,0,0,177,10,0,0,180,10,0,0,180,10,0,0,186,10,0,0,187,10,0,0,198,10,0,0,198,10,0,0,202,10,0,0,202,10,0,0,206,10,0,0,207,10,0,0,209,10,0,0,223,10,0,0,228,10,0,0,229,10,0,0,240,10,0,0,240,10,0,0,242,10,0,0,0,11,0,0,4,11,0,0,4,11,0,0,13,11,0,0,14,11,0,0,17,11,0,0,18,11,0,0,41,11,0,0,41,11,0,0,49,11,0,0,49,11,0,0,52,11,0,0,52,11,0,0,58,11,0,0,59,11,0,0,68,11,0,0,70,11,0,0,73,11,0,0,74,11,0,0,78,11,0,0,85,11,0,0,88,11,0,0,91,11,0,0,94,11,0,0,94,11,0,0,98,11,0,0,101,11,0,0,114,11,0,0,129,11,0,0,132,11,0,0,132,11,0,0,139,11,0,0,141,11,0,0,145,11,0,0,145,11,0,0,150,11,0,0,152,11,0,0,155,11,0,0,155,11,0,0,157,11,0,0,157,11,0,0,160,11,0,0,162,11,0,0,165,11,0,0,167,11,0,0,171,11,0,0,173,11,0,0,186,11,0,0,189,11,0,0,195,11,0,0,197,11,0,0,201,11,0,0,201,11,0,0,206,11,0,0,214,11,0,0,216,11,0,0,229,11,0,0,251,11,0,0,0,12,0,0,4,12,0,0,4,12,0,0,13,12,0,0,13,12,0,0,17,12,0,0,17,12,0,0,41,12,0,0,41,12,0,0,52,12,0,0,52,12,0,0,58,12,0,0,61,12,0,0,69,12,0,0,69,12,0,0,73,12,0,0,73,12,0,0,78,12,0,0,84,12,0,0,87,12,0,0,95,12,0,0,98,12,0,0,101,12,0,0,112,12,0,0,129,12,0,0,132,12,0,0,132,12,0,0,141,12,0,0,141,12,0,0,145,12,0,0,145,12,0,0,169,12,0,0,169,12,0,0,180,12,0,0,180,12,0,0,186,12,0,0,187,12,0,0,197,12,0,0,197,12,0,0,201,12,0,0,201,12,0,0,206,12,0,0,212,12,0,0,215,12,0,0,221,12,0,0,223,12,0,0,223,12,0,0,226,12,0,0,229,12,0,0,240,12,0,0,1,13,0,0,4,13,0,0,4,13,0,0,13,13,0,0,13,13,0,0,17,13,0,0,17,13,0,0,41,13,0,0,41,13,0,0,58,13,0,0,61,13,0,0,68,13,0,0,69,13,0,0,73,13,0,0,73,13,0,0,78,13,0,0,86,13,0,0,88,13,0,0,95,13,0,0,98,13,0,0,101,13,0,0,112,13,0,0,129,13,0,0,132,13,0,0,132,13,0,0,151,13,0,0,153,13,0,0,178,13,0,0,178,13,0,0,188,13,0,0,188,13,0,0,190,13,0,0,191,13,0,0,199,13,0,0,201,13,0,0,203,13,0,0,206,13,0,0,213,13,0,0,213,13,0,0,215,13,0,0,215,13,0,0,224,13,0,0,241,13,0,0,245,13,0,0,0,14,0,0,59,14,0,0,62,14,0,0,92,14,0,0,128,14,0,0,131,14,0,0,131,14,0,0,133,14,0,0,134,14,0,0,137,14,0,0,137,14,0,0,139,14,0,0,140,14,0,0,142,14,0,0,147,14,0,0,152,14,0,0,152,14,0,0,160,14,0,0,160,14,0,0,164,14,0,0,164,14,0,0,166,14,0,0,166,14,0,0,168,14,0,0,169,14,0,0,172,14,0,0,172,14,0,0,186,14,0,0,186,14,0,0,190,14,0,0,191,14,0,0,197,14,0,0,197,14,0,0,199,14,0,0,199,14,0,0,206,14,0,0,207,14,0,0,218,14,0,0,219,14,0,0,222,14,0,0,255,14,0,0,72,15,0,0,72,15,0,0,107,15,0,0,112,15,0,0,140,15,0,0,143,15,0,0,152,15,0,0,152,15,0,0,189,15,0,0,189,15,0,0,205,15,0,0,206,15,0,0,210,15,0,0,255,15,0,0,34,16,0,0,34,16,0,0,40,16,0,0,40,16,0,0,43,16,0,0,43,16,0,0,51,16,0,0,53,16,0,0,58,16,0,0,63,16,0,0,90,16,0,0,159,16,0,0,198,16,0,0,207,16,0,0,253,16,0,0,255,16,0,0,90,17,0,0,94,17,0,0,163,17,0,0,167,17,0,0,250,17,0,0,255,17,0,0,73,18,0,0,73,18,0,0,78,18,0,0,79,18,0,0,87,18,0,0,87,18,0,0,89,18,0,0,89,18,0,0,94,18,0,0,95,18,0,0,137,18,0,0,137,18,0,0,142,18,0,0,143,18,0,0,177,18,0,0,177,18,0,0,182,18,0,0,183,18,0,0,191,18,0,0,191,18,0,0,193,18,0,0,193,18,0,0,198,18,0,0,199,18,0,0,215,18,0,0,215,18,0,0,17,19,0,0,17,19,0,0,22,19,0,0,23,19,0,0,91,19,0,0,94,19,0,0,125,19,0,0,127,19,0,0,154,19,0,0,159,19,0,0,245,19,0,0,0,20,0,0,119,22,0,0,127,22,0,0,157,22,0,0,159,22,0,0,241,22,0,0,255,22,0,0,13,23,0,0,13,23,0,0,21,23,0,0,31,23,0,0,55,23,0,0,63,23,0,0,84,23,0,0,95,23,0,0,109,23,0,0,109,23,0,0,113,23,0,0,113,23,0,0,116,23,0,0,127,23,0,0,222,23,0,0,223,23,0,0,234,23,0,0,239,23,0,0,250,23,0,0,255,23,0,0,15,24,0,0,15,24,0,0,26,24,0,0,31,24,0,0,120,24,0,0,127,24,0,0,170,24,0,0,255,24,0,0,29,25,0,0,31,25,0,0,44,25,0,0,47,25,0,0,60,25,0,0,63,25,0,0,65,25,0,0,67,25,0,0,110,25,0,0,111,25,0,0,117,25,0,0,127,25,0,0,170,25,0,0,175,25,0,0,202,25,0,0,207,25,0,0,218,25,0,0,221,25,0,0,28,26,0,0,29,26,0,0,32,26,0,0,255,28,0,0,196,29,0,0,255,29,0,0,156,30,0,0,159,30,0,0,250,30,0,0,255,30,0,0,22,31,0,0,23,31,0,0,30,31,0,0,31,31,0,0,70,31,0,0,71,31,0,0,78,31,0,0,79,31,0,0,88,31,0,0,88,31,0,0,90,31,0,0,90,31,0,0,92,31,0,0,92,31,0,0,94,31,0,0,94,31,0,0,126,31,0,0,127,31,0,0,181,31,0,0,181,31,0,0,197,31,0,0,197,31,0,0,212,31,0,0,213,31,0,0,220,31,0,0,220,31,0,0,240,31,0,0,241,31,0,0,245,31,0,0,245,31,0,0,255,31,0,0,255,31,0,0,100,32,0,0,105,32,0,0,114,32,0,0,115,32,0,0,143,32,0,0,143,32,0,0,149,32,0,0,159,32,0,0,182,32,0,0,207,32,0,0,236,32,0,0,255,32,0,0,77,33,0,0,82,33,0,0,132,33,0,0,143,33,0,0,220,35,0,0,255,35,0,0,39,36,0,0,63,36,0,0,75,36,0,0,95,36,0,0,157,38,0,0,159,38,0,0,178,38,0,0,0,39,0,0,5,39,0,0,5,39,0,0,10,39,0,0,11,39,0,0,40,39,0,0,40,39,0,0,76,39,0,0,76,39,0,0,78,39,0,0,78,39,0,0,83,39,0,0,85,39,0,0,87,39,0,0,87,39,0,0,95,39,0,0,96,39,0,0,149,39,0,0,151,39,0,0,176,39,0,0,176,39,0,0,191,39,0,0,191,39,0,0,199,39,0,0,207,39,0,0,236,39,0,0,239,39,0,0,20,43,0,0,255,43,0,0,47,44,0,0,47,44,0,0,95,44,0,0,127,44,0,0,235,44,0,0,248,44,0,0,38,45,0,0,47,45,0,0,102,45,0,0,110,45,0,0,112,45,0,0,127,45,0,0,151,45,0,0,159,45,0,0,167,45,0,0,167,45,0,0,175,45,0,0,175,45,0,0,183,45,0,0,183,45,0,0,191,45,0,0,191,45,0,0,199,45,0,0,199,45,0,0,207,45,0,0,207,45,0,0,215,45,0,0,215,45,0,0,223,45,0,0,255,45,0,0,24,46,0,0,27,46,0,0,30,46,0,0,127,46,0,0,154,46,0,0,154,46,0,0,244,46,0,0,255,46,0,0,214,47,0,0,239,47,0,0,252,47,0,0,255,47,0,0,64,48,0,0,64,48,0,0,151,48,0,0,152,48,0,0,0,49,0,0,4,49,0,0,45,49,0,0,48,49,0,0,143,49,0,0,143,49,0,0,184,49,0,0,191,49,0,0,208,49,0,0,239,49,0,0,31,50,0,0,31,50,0,0,68,50,0,0,79,50,0,0,255,50,0,0,255,50,0,0,182,77,0,0,191,77,0,0,188,159,0,0,255,159,0,0,141,164,0,0,143,164,0,0,199,164,0,0,255,166,0,0,23,167,0,0,255,167,0,0,44,168,0,0,255,171,0,0,164,215,0,0,255,215,0,0,46,250,0,0,47,250,0,0,107,250,0,0,111,250,0,0,218,250,0,0,255,250,0,0,7,251,0,0,18,251,0,0,24,251,0,0,28,251,0,0,55,251,0,0,55,251,0,0,61,251,0,0,61,251,0,0,63,251,0,0,63,251,0,0,66,251,0,0,66,251,0,0,69,251,0,0,69,251,0,0,178,251,0,0,210,251,0,0,64,253,0,0,79,253,0,0,144,253,0,0,145,253,0,0,200,253,0,0,239,253,0,0,254,253,0,0,255,253,0,0,26,254,0,0,31,254,0,0,36,254,0,0,47,254,0,0,83,254,0,0,83,254,0,0,103,254,0,0,103,254,0,0,108,254,0,0,111,254,0,0,117,254,0,0,117,254,0,0,253,254,0,0,254,254,0,0,0,255,0,0,0,255,0,0,191,255,0,0,193,255,0,0,200,255,0,0,201,255,0,0,208,255,0,0,209,255,0,0,216,255,0,0,217,255,0,0,221,255,0,0,223,255,0,0,231,255,0,0,231,255,0,0,239,255,0,0,248,255,0,0,254,255,0,0,255,255,0,0,12,0,1,0,12,0,1,0,39,0,1,0,39,0,1,0,59,0,1,0,59,0,1,0,62,0,1,0,62,0,1,0,78,0,1,0,79,0,1,0,94,0,1,0,127,0,1,0,251,0,1,0,255,0,1,0,3,1,1,0,6,1,1,0,52,1,1,0,54,1,1,0,139,1,1,0,255,2,1,0,31,3,1,0,31,3,1,0,36,3,1,0,47,3,1,0,75,3,1,0,127,3,1,0,158,3,1,0,158,3,1,0,196,3,1,0,199,3,1,0,214,3,1,0,255,3,1,0,158,4,1,0,159,4,1,0,170,4,1,0,255,7,1,0,6,8,1,0,7,8,1,0,9,8,1,0,9,8,1,0,54,8,1,0,54,8,1,0,57,8,1,0,59,8,1,0,61,8,1,0,62,8,1,0,64,8,1,0,255,9,1,0,4,10,1,0,4,10,1,0,7,10,1,0,11,10,1,0,20,10,1,0,20,10,1,0,24,10,1,0,24,10,1,0,52,10,1,0,55,10,1,0,59,10,1,0,62,10,1,0,72,10,1,0,79,10,1,0,89,10,1,0,255,207,1,0,246,208,1,0,255,208,1,0,39,209,1,0,41,209,1,0,222,209,1,0,255,209,1,0,70,210,1,0,255,210,1,0,87,211,1,0,255,211,1,0,85,212,1,0,85,212,1,0,157,212,1,0,157,212,1,0,160,212,1,0,161,212,1,0,163,212,1,0,164,212,1,0,167,212,1,0,168,212,1,0,173,212,1,0,173,212,1,0,186,212,1,0,186,212,1,0,188,212,1,0,188,212,1,0,196,212,1,0,196,212,1,0,6,213,1,0,6,213,1,0,11,213,1,0,12,213,1,0,21,213,1,0,21,213,1,0,29,213,1,0,29,213,1,0,58,213,1,0,58,213,1,0,63,213,1,0,63,213,1,0,69,213,1,0,69,213,1,0,71,213,1,0,73,213,1,0,81,213,1,0,81,213,1,0,166,214,1,0,167,214,1,0,202,215,1,0,205,215,1,0,0,216,1,0,255,255,1,0,215,166,2,0,255,247,2,0,30,250,2,0,0,0,14,0,2,0,14,0,31,0,14,0,128,0,14,0,255,0,14,0,240,1,14,0,255,255,14,0,254,255,15,0,255,255,15,0,254,255,16,0,255,255,16,0,3,0,0,0,0,224,0,0,255,248,0,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,1,0,0,0,0,216,0,0,255,223,0,0,91,1,0,0,65,0,0,0,90,0,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,181,0,0,0,181,0,0,0,186,0,0,0,186,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,246,0,0,0,248,0,0,0,65,2,0,0,80,2,0,0,193,2,0,0,198,2,0,0,209,2,0,0,224,2,0,0,228,2,0,0,238,2,0,0,238,2,0,0,122,3,0,0,122,3,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,245,3,0,0,247,3,0,0,129,4,0,0,138,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,49,5,0,0,86,5,0,0,89,5,0,0,89,5,0,0,97,5,0,0,135,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,242,5,0,0,33,6,0,0,58,6,0,0,64,6,0,0,74,6,0,0,110,6,0,0,111,6,0,0,113,6,0,0,211,6,0,0,213,6,0,0,213,6,0,0,229,6,0,0,230,6,0,0,238,6,0,0,239,6,0,0,250,6,0,0,252,6,0,0,255,6,0,0,255,6,0,0,16,7,0,0,16,7,0,0,18,7,0,0,47,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,165,7,0,0,177,7,0,0,177,7,0,0,4,9,0,0,57,9,0,0,61,9,0,0,61,9,0,0,80,9,0,0,80,9,0,0,88,9,0,0,97,9,0,0,125,9,0,0,125,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,189,9,0,0,189,9,0,0,206,9,0,0,206,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,225,9,0,0,240,9,0,0,241,9,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,114,10,0,0,116,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,189,10,0,0,189,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,225,10,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,61,11,0,0,61,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,113,11,0,0,113,11,0,0,131,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,96,12,0,0,97,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,189,12,0,0,189,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,96,13,0,0,97,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,1,14,0,0,48,14,0,0,50,14,0,0,51,14,0,0,64,14,0,0,70,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,176,14,0,0,178,14,0,0,179,14,0,0,189,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,0,15,0,0,64,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,136,15,0,0,139,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,80,16,0,0,85,16,0,0,160,16,0,0,197,16,0,0,208,16,0,0,250,16,0,0,252,16,0,0,252,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,128,19,0,0,143,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,108,22,0,0,111,22,0,0,118,22,0,0,129,22,0,0,154,22,0,0,160,22,0,0,234,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,17,23,0,0,32,23,0,0,49,23,0,0,64,23,0,0,81,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,128,23,0,0,179,23,0,0,215,23,0,0,215,23,0,0,220,23,0,0,220,23,0,0,32,24,0,0,119,24,0,0,128,24,0,0,168,24,0,0,0,25,0,0,28,25,0,0,80,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,193,25,0,0,199,25,0,0,0,26,0,0,22,26,0,0,0,29,0,0,191,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31,0,0,80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,188,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,204,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,224,31,0,0,236,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,252,31,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,144,32,0,0,148,32,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,10,33,0,0,19,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,47,33,0,0,49,33,0,0,51,33,0,0,57,33,0,0,60,33,0,0,63,33,0,0,69,33,0,0,73,33,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,128,44,0,0,228,44,0,0,0,45,0,0,37,45,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,5,48,0,0,6,48,0,0,49,48,0,0,53,48,0,0,59,48,0,0,60,48,0,0,65,48,0,0,150,48,0,0,157,48,0,0,159,48,0,0,161,48,0,0,250,48,0,0,252,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,160,49,0,0,183,49,0,0,240,49,0,0,255,49,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,160,0,0,140,164,0,0,0,168,0,0,1,168,0,0,3,168,0,0,5,168,0,0,7,168,0,0,10,168,0,0,12,168,0,0,34,168,0,0,0,172,0,0,163,215,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,29,251,0,0,29,251,0,0,31,251,0,0,40,251,0,0,42,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,251,253,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,33,255,0,0,58,255,0,0,65,255,0,0,90,255,0,0,102,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,3,1,0,30,3,1,0,48,3,1,0,73,3,1,0,128,3,1,0,157,3,1,0,160,3,1,0,195,3,1,0,200,3,1,0,207,3,1,0,0,4,1,0,157,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,0,10,1,0,16,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,192,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,250,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,52,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,110,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,168,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,224,1,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,181,0,0,0,181,0,0,0,186,0,0,0,186,0,0,0,223,0,0,0,246,0,0,0,248,0,0,0,255,0,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,1,0,0,5,1,0,0,5,1,0,0,7,1,0,0,7,1,0,0,9,1,0,0,9,1,0,0,11,1,0,0,11,1,0,0,13,1,0,0,13,1,0,0,15,1,0,0,15,1,0,0,17,1,0,0,17,1,0,0,19,1,0,0,19,1,0,0,21,1,0,0,21,1,0,0,23,1,0,0,23,1,0,0,25,1,0,0,25,1,0,0,27,1,0,0,27,1,0,0,29,1,0,0,29,1,0,0,31,1,0,0,31,1,0,0,33,1,0,0,33,1,0,0,35,1,0,0,35,1,0,0,37,1,0,0,37,1,0,0,39,1,0,0,39,1,0,0,41,1,0,0,41,1,0,0,43,1,0,0,43,1,0,0,45,1,0,0,45,1,0,0,47,1,0,0,47,1,0,0,49,1,0,0,49,1,0,0,51,1,0,0,51,1,0,0,53,1,0,0,53,1,0,0,55,1,0,0,56,1,0,0,58,1,0,0,58,1,0,0,60,1,0,0,60,1,0,0,62,1,0,0,62,1,0,0,64,1,0,0,64,1,0,0,66,1,0,0,66,1,0,0,68,1,0,0,68,1,0,0,70,1,0,0,70,1,0,0,72,1,0,0,73,1,0,0,75,1,0,0,75,1,0,0,77,1,0,0,77,1,0,0,79,1,0,0,79,1,0,0,81,1,0,0,81,1,0,0,83,1,0,0,83,1,0,0,85,1,0,0,85,1,0,0,87,1,0,0,87,1,0,0,89,1,0,0,89,1,0,0,91,1,0,0,91,1,0,0,93,1,0,0,93,1,0,0,95,1,0,0,95,1,0,0,97,1,0,0,97,1,0,0,99,1,0,0,99,1,0,0,101,1,0,0,101,1,0,0,103,1,0,0,103,1,0,0,105,1,0,0,105,1,0,0,107,1,0,0,107,1,0,0,109,1,0,0,109,1,0,0,111,1,0,0,111,1,0,0,113,1,0,0,113,1,0,0,115,1,0,0,115,1,0,0,117,1,0,0,117,1,0,0,119,1,0,0,119,1,0,0,122,1,0,0,122,1,0,0,124,1,0,0,124,1,0,0,126,1,0,0,128,1,0,0,131,1,0,0,131,1,0,0,133,1,0,0,133,1,0,0,136,1,0,0,136,1,0,0,140,1,0,0,141,1,0,0,146,1,0,0,146,1,0,0,149,1,0,0,149,1,0,0,153,1,0,0,155,1,0,0,158,1,0,0,158,1,0,0,161,1,0,0,161,1,0,0,163,1,0,0,163,1,0,0,165,1,0,0,165,1,0,0,168,1,0,0,168,1,0,0,170,1,0,0,171,1,0,0,173,1,0,0,173,1,0,0,176,1,0,0,176,1,0,0,180,1,0,0,180,1,0,0,182,1,0,0,182,1,0,0,185,1,0,0,186,1,0,0,189,1,0,0,191,1,0,0,198,1,0,0,198,1,0,0,201,1,0,0,201,1,0,0,204,1,0,0,204,1,0,0,206,1,0,0,206,1,0,0,208,1,0,0,208,1,0,0,210,1,0,0,210,1,0,0,212,1,0,0,212,1,0,0,214,1,0,0,214,1,0,0,216,1,0,0,216,1,0,0,218,1,0,0,218,1,0,0,220,1,0,0,221,1,0,0,223,1,0,0,223,1,0,0,225,1,0,0,225,1,0,0,227,1,0,0,227,1,0,0,229,1,0,0,229,1,0,0,231,1,0,0,231,1,0,0,233,1,0,0,233,1,0,0,235,1,0,0,235,1,0,0,237,1,0,0,237,1,0,0,239,1,0,0,240,1,0,0,243,1,0,0,243,1,0,0,245,1,0,0,245,1,0,0,249,1,0,0,249,1,0,0,251,1,0,0,251,1,0,0,253,1,0,0,253,1,0,0,255,1,0,0,255,1,0,0,1,2,0,0,1,2,0,0,3,2,0,0,3,2,0,0,5,2,0,0,5,2,0,0,7,2,0,0,7,2,0,0,9,2,0,0,9,2,0,0,11,2,0,0,11,2,0,0,13,2,0,0,13,2,0,0,15,2,0,0,15,2,0,0,17,2,0,0,17,2,0,0,19,2,0,0,19,2,0,0,21,2,0,0,21,2,0,0,23,2,0,0,23,2,0,0,25,2,0,0,25,2,0,0,27,2,0,0,27,2,0,0,29,2], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+406916);
/* memory initializer */ allocate([29,2,0,0,31,2,0,0,31,2,0,0,33,2,0,0,33,2,0,0,35,2,0,0,35,2,0,0,37,2,0,0,37,2,0,0,39,2,0,0,39,2,0,0,41,2,0,0,41,2,0,0,43,2,0,0,43,2,0,0,45,2,0,0,45,2,0,0,47,2,0,0,47,2,0,0,49,2,0,0,49,2,0,0,51,2,0,0,57,2,0,0,60,2,0,0,60,2,0,0,63,2,0,0,64,2,0,0,80,2,0,0,175,2,0,0,144,3,0,0,144,3,0,0,172,3,0,0,206,3,0,0,208,3,0,0,209,3,0,0,213,3,0,0,215,3,0,0,217,3,0,0,217,3,0,0,219,3,0,0,219,3,0,0,221,3,0,0,221,3,0,0,223,3,0,0,223,3,0,0,225,3,0,0,225,3,0,0,227,3,0,0,227,3,0,0,229,3,0,0,229,3,0,0,231,3,0,0,231,3,0,0,233,3,0,0,233,3,0,0,235,3,0,0,235,3,0,0,237,3,0,0,237,3,0,0,239,3,0,0,243,3,0,0,245,3,0,0,245,3,0,0,248,3,0,0,248,3,0,0,251,3,0,0,252,3,0,0,48,4,0,0,95,4,0,0,97,4,0,0,97,4,0,0,99,4,0,0,99,4,0,0,101,4,0,0,101,4,0,0,103,4,0,0,103,4,0,0,105,4,0,0,105,4,0,0,107,4,0,0,107,4,0,0,109,4,0,0,109,4,0,0,111,4,0,0,111,4,0,0,113,4,0,0,113,4,0,0,115,4,0,0,115,4,0,0,117,4,0,0,117,4,0,0,119,4,0,0,119,4,0,0,121,4,0,0,121,4,0,0,123,4,0,0,123,4,0,0,125,4,0,0,125,4,0,0,127,4,0,0,127,4,0,0,129,4,0,0,129,4,0,0,139,4,0,0,139,4,0,0,141,4,0,0,141,4,0,0,143,4,0,0,143,4,0,0,145,4,0,0,145,4,0,0,147,4,0,0,147,4,0,0,149,4,0,0,149,4,0,0,151,4,0,0,151,4,0,0,153,4,0,0,153,4,0,0,155,4,0,0,155,4,0,0,157,4,0,0,157,4,0,0,159,4,0,0,159,4,0,0,161,4,0,0,161,4,0,0,163,4,0,0,163,4,0,0,165,4,0,0,165,4,0,0,167,4,0,0,167,4,0,0,169,4,0,0,169,4,0,0,171,4,0,0,171,4,0,0,173,4,0,0,173,4,0,0,175,4,0,0,175,4,0,0,177,4,0,0,177,4,0,0,179,4,0,0,179,4,0,0,181,4,0,0,181,4,0,0,183,4,0,0,183,4,0,0,185,4,0,0,185,4,0,0,187,4,0,0,187,4,0,0,189,4,0,0,189,4,0,0,191,4,0,0,191,4,0,0,194,4,0,0,194,4,0,0,196,4,0,0,196,4,0,0,198,4,0,0,198,4,0,0,200,4,0,0,200,4,0,0,202,4,0,0,202,4,0,0,204,4,0,0,204,4,0,0,206,4,0,0,206,4,0,0,209,4,0,0,209,4,0,0,211,4,0,0,211,4,0,0,213,4,0,0,213,4,0,0,215,4,0,0,215,4,0,0,217,4,0,0,217,4,0,0,219,4,0,0,219,4,0,0,221,4,0,0,221,4,0,0,223,4,0,0,223,4,0,0,225,4,0,0,225,4,0,0,227,4,0,0,227,4,0,0,229,4,0,0,229,4,0,0,231,4,0,0,231,4,0,0,233,4,0,0,233,4,0,0,235,4,0,0,235,4,0,0,237,4,0,0,237,4,0,0,239,4,0,0,239,4,0,0,241,4,0,0,241,4,0,0,243,4,0,0,243,4,0,0,245,4,0,0,245,4,0,0,247,4,0,0,247,4,0,0,249,4,0,0,249,4,0,0,1,5,0,0,1,5,0,0,3,5,0,0,3,5,0,0,5,5,0,0,5,5,0,0,7,5,0,0,7,5,0,0,9,5,0,0,9,5,0,0,11,5,0,0,11,5,0,0,13,5,0,0,13,5,0,0,15,5,0,0,15,5,0,0,97,5,0,0,135,5,0,0,0,29,0,0,43,29,0,0,98,29,0,0,119,29,0,0,121,29,0,0,154,29,0,0,1,30,0,0,1,30,0,0,3,30,0,0,3,30,0,0,5,30,0,0,5,30,0,0,7,30,0,0,7,30,0,0,9,30,0,0,9,30,0,0,11,30,0,0,11,30,0,0,13,30,0,0,13,30,0,0,15,30,0,0,15,30,0,0,17,30,0,0,17,30,0,0,19,30,0,0,19,30,0,0,21,30,0,0,21,30,0,0,23,30,0,0,23,30,0,0,25,30,0,0,25,30,0,0,27,30,0,0,27,30,0,0,29,30,0,0,29,30,0,0,31,30,0,0,31,30,0,0,33,30,0,0,33,30,0,0,35,30,0,0,35,30,0,0,37,30,0,0,37,30,0,0,39,30,0,0,39,30,0,0,41,30,0,0,41,30,0,0,43,30,0,0,43,30,0,0,45,30,0,0,45,30,0,0,47,30,0,0,47,30,0,0,49,30,0,0,49,30,0,0,51,30,0,0,51,30,0,0,53,30,0,0,53,30,0,0,55,30,0,0,55,30,0,0,57,30,0,0,57,30,0,0,59,30,0,0,59,30,0,0,61,30,0,0,61,30,0,0,63,30,0,0,63,30,0,0,65,30,0,0,65,30,0,0,67,30,0,0,67,30,0,0,69,30,0,0,69,30,0,0,71,30,0,0,71,30,0,0,73,30,0,0,73,30,0,0,75,30,0,0,75,30,0,0,77,30,0,0,77,30,0,0,79,30,0,0,79,30,0,0,81,30,0,0,81,30,0,0,83,30,0,0,83,30,0,0,85,30,0,0,85,30,0,0,87,30,0,0,87,30,0,0,89,30,0,0,89,30,0,0,91,30,0,0,91,30,0,0,93,30,0,0,93,30,0,0,95,30,0,0,95,30,0,0,97,30,0,0,97,30,0,0,99,30,0,0,99,30,0,0,101,30,0,0,101,30,0,0,103,30,0,0,103,30,0,0,105,30,0,0,105,30,0,0,107,30,0,0,107,30,0,0,109,30,0,0,109,30,0,0,111,30,0,0,111,30,0,0,113,30,0,0,113,30,0,0,115,30,0,0,115,30,0,0,117,30,0,0,117,30,0,0,119,30,0,0,119,30,0,0,121,30,0,0,121,30,0,0,123,30,0,0,123,30,0,0,125,30,0,0,125,30,0,0,127,30,0,0,127,30,0,0,129,30,0,0,129,30,0,0,131,30,0,0,131,30,0,0,133,30,0,0,133,30,0,0,135,30,0,0,135,30,0,0,137,30,0,0,137,30,0,0,139,30,0,0,139,30,0,0,141,30,0,0,141,30,0,0,143,30,0,0,143,30,0,0,145,30,0,0,145,30,0,0,147,30,0,0,147,30,0,0,149,30,0,0,155,30,0,0,161,30,0,0,161,30,0,0,163,30,0,0,163,30,0,0,165,30,0,0,165,30,0,0,167,30,0,0,167,30,0,0,169,30,0,0,169,30,0,0,171,30,0,0,171,30,0,0,173,30,0,0,173,30,0,0,175,30,0,0,175,30,0,0,177,30,0,0,177,30,0,0,179,30,0,0,179,30,0,0,181,30,0,0,181,30,0,0,183,30,0,0,183,30,0,0,185,30,0,0,185,30,0,0,187,30,0,0,187,30,0,0,189,30,0,0,189,30,0,0,191,30,0,0,191,30,0,0,193,30,0,0,193,30,0,0,195,30,0,0,195,30,0,0,197,30,0,0,197,30,0,0,199,30,0,0,199,30,0,0,201,30,0,0,201,30,0,0,203,30,0,0,203,30,0,0,205,30,0,0,205,30,0,0,207,30,0,0,207,30,0,0,209,30,0,0,209,30,0,0,211,30,0,0,211,30,0,0,213,30,0,0,213,30,0,0,215,30,0,0,215,30,0,0,217,30,0,0,217,30,0,0,219,30,0,0,219,30,0,0,221,30,0,0,221,30,0,0,223,30,0,0,223,30,0,0,225,30,0,0,225,30,0,0,227,30,0,0,227,30,0,0,229,30,0,0,229,30,0,0,231,30,0,0,231,30,0,0,233,30,0,0,233,30,0,0,235,30,0,0,235,30,0,0,237,30,0,0,237,30,0,0,239,30,0,0,239,30,0,0,241,30,0,0,241,30,0,0,243,30,0,0,243,30,0,0,245,30,0,0,245,30,0,0,247,30,0,0,247,30,0,0,249,30,0,0,249,30,0,0,0,31,0,0,7,31,0,0,16,31,0,0,21,31,0,0,32,31,0,0,39,31,0,0,48,31,0,0,55,31,0,0,64,31,0,0,69,31,0,0,80,31,0,0,87,31,0,0,96,31,0,0,103,31,0,0,112,31,0,0,125,31,0,0,128,31,0,0,135,31,0,0,144,31,0,0,151,31,0,0,160,31,0,0,167,31,0,0,176,31,0,0,180,31,0,0,182,31,0,0,183,31,0,0,190,31,0,0,190,31,0,0,194,31,0,0,196,31,0,0,198,31,0,0,199,31,0,0,208,31,0,0,211,31,0,0,214,31,0,0,215,31,0,0,224,31,0,0,231,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,247,31,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,10,33,0,0,10,33,0,0,14,33,0,0,15,33,0,0,19,33,0,0,19,33,0,0,47,33,0,0,47,33,0,0,52,33,0,0,52,33,0,0,57,33,0,0,57,33,0,0,60,33,0,0,61,33,0,0,70,33,0,0,73,33,0,0,48,44,0,0,94,44,0,0,129,44,0,0,129,44,0,0,131,44,0,0,131,44,0,0,133,44,0,0,133,44,0,0,135,44,0,0,135,44,0,0,137,44,0,0,137,44,0,0,139,44,0,0,139,44,0,0,141,44,0,0,141,44,0,0,143,44,0,0,143,44,0,0,145,44,0,0,145,44,0,0,147,44,0,0,147,44,0,0,149,44,0,0,149,44,0,0,151,44,0,0,151,44,0,0,153,44,0,0,153,44,0,0,155,44,0,0,155,44,0,0,157,44,0,0,157,44,0,0,159,44,0,0,159,44,0,0,161,44,0,0,161,44,0,0,163,44,0,0,163,44,0,0,165,44,0,0,165,44,0,0,167,44,0,0,167,44,0,0,169,44,0,0,169,44,0,0,171,44,0,0,171,44,0,0,173,44,0,0,173,44,0,0,175,44,0,0,175,44,0,0,177,44,0,0,177,44,0,0,179,44,0,0,179,44,0,0,181,44,0,0,181,44,0,0,183,44,0,0,183,44,0,0,185,44,0,0,185,44,0,0,187,44,0,0,187,44,0,0,189,44,0,0,189,44,0,0,191,44,0,0,191,44,0,0,193,44,0,0,193,44,0,0,195,44,0,0,195,44,0,0,197,44,0,0,197,44,0,0,199,44,0,0,199,44,0,0,201,44,0,0,201,44,0,0,203,44,0,0,203,44,0,0,205,44,0,0,205,44,0,0,207,44,0,0,207,44,0,0,209,44,0,0,209,44,0,0,211,44,0,0,211,44,0,0,213,44,0,0,213,44,0,0,215,44,0,0,215,44,0,0,217,44,0,0,217,44,0,0,219,44,0,0,219,44,0,0,221,44,0,0,221,44,0,0,223,44,0,0,223,44,0,0,225,44,0,0,225,44,0,0,227,44,0,0,228,44,0,0,0,45,0,0,37,45,0,0,0,251,0,0,6,251,0,0,19,251,0,0,23,251,0,0,65,255,0,0,90,255,0,0,40,4,1,0,79,4,1,0,26,212,1,0,51,212,1,0,78,212,1,0,84,212,1,0,86,212,1,0,103,212,1,0,130,212,1,0,155,212,1,0,182,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,207,212,1,0,234,212,1,0,3,213,1,0,30,213,1,0,55,213,1,0,82,213,1,0,107,213,1,0,134,213,1,0,159,213,1,0,186,213,1,0,211,213,1,0,238,213,1,0,7,214,1,0,34,214,1,0,59,214,1,0,86,214,1,0,111,214,1,0,138,214,1,0,165,214,1,0,194,214,1,0,218,214,1,0,220,214,1,0,225,214,1,0,252,214,1,0,20,215,1,0,22,215,1,0,27,215,1,0,54,215,1,0,78,215,1,0,80,215,1,0,85,215,1,0,112,215,1,0,136,215,1,0,138,215,1,0,143,215,1,0,170,215,1,0,194,215,1,0,196,215,1,0,201,215,1,0,26,0,0,0,176,2,0,0,193,2,0,0,198,2,0,0,209,2,0,0,224,2,0,0,228,2,0,0,238,2,0,0,238,2,0,0,122,3,0,0,122,3,0,0,89,5,0,0,89,5,0,0,64,6,0,0,64,6,0,0,229,6,0,0,230,6,0,0,70,14,0,0,70,14,0,0,198,14,0,0,198,14,0,0,252,16,0,0,252,16,0,0,215,23,0,0,215,23,0,0,67,24,0,0,67,24,0,0,44,29,0,0,97,29,0,0,120,29,0,0,120,29,0,0,155,29,0,0,191,29,0,0,144,32,0,0,148,32,0,0,111,45,0,0,111,45,0,0,5,48,0,0,5,48,0,0,49,48,0,0,53,48,0,0,59,48,0,0,59,48,0,0,157,48,0,0,158,48,0,0,252,48,0,0,254,48,0,0,21,160,0,0,21,160,0,0,112,255,0,0,112,255,0,0,158,255,0,0,159,255,0,0,245,0,0,0,187,1,0,0,187,1,0,0,192,1,0,0,195,1,0,0,208,5,0,0,234,5,0,0,240,5,0,0,242,5,0,0,33,6,0,0,58,6,0,0,65,6,0,0,74,6,0,0,110,6,0,0,111,6,0,0,113,6,0,0,211,6,0,0,213,6,0,0,213,6,0,0,238,6,0,0,239,6,0,0,250,6,0,0,252,6,0,0,255,6,0,0,255,6,0,0,16,7,0,0,16,7,0,0,18,7,0,0,47,7,0,0,77,7,0,0,109,7,0,0,128,7,0,0,165,7,0,0,177,7,0,0,177,7,0,0,4,9,0,0,57,9,0,0,61,9,0,0,61,9,0,0,80,9,0,0,80,9,0,0,88,9,0,0,97,9,0,0,125,9,0,0,125,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,189,9,0,0,189,9,0,0,206,9,0,0,206,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,225,9,0,0,240,9,0,0,241,9,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,114,10,0,0,116,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,189,10,0,0,189,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,225,10,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,61,11,0,0,61,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,113,11,0,0,113,11,0,0,131,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,96,12,0,0,97,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,189,12,0,0,189,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,96,13,0,0,97,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,1,14,0,0,48,14,0,0,50,14,0,0,51,14,0,0,64,14,0,0,69,14,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,176,14,0,0,178,14,0,0,179,14,0,0,189,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,220,14,0,0,221,14,0,0,0,15,0,0,0,15,0,0,64,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,136,15,0,0,139,15,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,80,16,0,0,85,16,0,0,208,16,0,0,250,16,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,128,19,0,0,143,19,0,0,160,19,0,0,244,19,0,0,1,20,0,0,108,22,0,0,111,22,0,0,118,22,0,0,129,22,0,0,154,22,0,0,160,22,0,0,234,22,0,0,0,23,0,0,12,23,0,0,14,23,0,0,17,23,0,0,32,23,0,0,49,23,0,0,64,23,0,0,81,23,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,128,23,0,0,179,23,0,0,220,23,0,0,220,23,0,0,32,24,0,0,66,24,0,0,68,24,0,0,119,24,0,0,128,24,0,0,168,24,0,0,0,25,0,0,28,25,0,0,80,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,128,25,0,0,169,25,0,0,193,25,0,0,199,25,0,0,0,26,0,0,22,26,0,0,53,33,0,0,56,33,0,0,48,45,0,0,101,45,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,6,48,0,0,6,48,0,0,60,48,0,0,60,48,0,0,65,48,0,0,150,48,0,0,159,48,0,0,159,48,0,0,161,48,0,0,250,48,0,0,255,48,0,0,255,48,0,0,5,49,0,0,44,49,0,0,49,49,0,0,142,49,0,0,160,49,0,0,183,49,0,0,240,49,0,0,255,49,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,160,0,0,20,160,0,0,22,160,0,0,140,164,0,0,0,168,0,0,1,168,0,0,3,168,0,0,5,168,0,0,7,168,0,0,10,168,0,0,12,168,0,0,34,168,0,0,0,172,0,0,163,215,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,29,251,0,0,29,251,0,0,31,251,0,0,40,251,0,0,42,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,251,253,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,102,255,0,0,111,255,0,0,113,255,0,0,157,255,0,0,160,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,0,3,1,0,30,3,1,0,48,3,1,0,73,3,1,0,128,3,1,0,157,3,1,0,160,3,1,0,195,3,1,0,200,3,1,0,207,3,1,0,80,4,1,0,157,4,1,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,0,10,1,0,0,10,1,0,16,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,10,0,0,0,197,1,0,0,197,1,0,0,200,1,0,0,200,1,0,0,203,1,0,0,203,1,0,0,242,1,0,0,242,1,0,0,136,31,0,0,143,31,0,0,152,31,0,0,159,31,0,0,168,31,0,0,175,31,0,0,188,31,0,0,188,31,0,0,204,31,0,0,204,31,0,0,252,31,0,0,252,31,0,0,220,1,0,0,65,0,0,0,90,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,222,0,0,0,0,1,0,0,0,1,0,0,2,1,0,0,2,1,0,0,4,1,0,0,4,1,0,0,6,1,0,0,6,1,0,0,8,1,0,0,8,1,0,0,10,1,0,0,10,1,0,0,12,1,0,0,12,1,0,0,14,1,0,0,14,1,0,0,16,1,0,0,16,1,0,0,18,1,0,0,18,1,0,0,20,1,0,0,20,1,0,0,22,1,0,0,22,1,0,0,24,1,0,0,24,1,0,0,26,1,0,0,26,1,0,0,28,1,0,0,28,1,0,0,30,1,0,0,30,1,0,0,32,1,0,0,32,1,0,0,34,1,0,0,34,1,0,0,36,1,0,0,36,1,0,0,38,1,0,0,38,1,0,0,40,1,0,0,40,1,0,0,42,1,0,0,42,1,0,0,44,1,0,0,44,1,0,0,46,1,0,0,46,1,0,0,48,1,0,0,48,1,0,0,50,1,0,0,50,1,0,0,52,1,0,0,52,1,0,0,54,1,0,0,54,1,0,0,57,1,0,0,57,1,0,0,59,1,0,0,59,1,0,0,61,1,0,0,61,1,0,0,63,1,0,0,63,1,0,0,65,1,0,0,65,1,0,0,67,1,0,0,67,1,0,0,69,1,0,0,69,1,0,0,71,1,0,0,71,1,0,0,74,1,0,0,74,1,0,0,76,1,0,0,76,1,0,0,78,1,0,0,78,1,0,0,80,1,0,0,80,1,0,0,82,1,0,0,82,1,0,0,84,1,0,0,84,1,0,0,86,1,0,0,86,1,0,0,88,1,0,0,88,1,0,0,90,1,0,0,90,1,0,0,92,1,0,0,92,1,0,0,94,1,0,0,94,1,0,0,96,1,0,0,96,1,0,0,98,1,0,0,98,1,0,0,100,1,0,0,100,1,0,0,102,1,0,0,102,1,0,0,104,1,0,0,104,1,0,0,106,1,0,0,106,1,0,0,108,1,0,0,108,1,0,0,110,1,0,0,110,1,0,0,112,1,0,0,112,1,0,0,114,1,0,0,114,1,0,0,116,1,0,0,116,1,0,0,118,1,0,0,118,1,0,0,120,1,0,0,121,1,0,0,123,1,0,0,123,1,0,0,125,1,0,0,125,1,0,0,129,1,0,0,130,1,0,0,132,1,0,0,132,1,0,0,134,1,0,0,135,1,0,0,137,1,0,0,139,1,0,0,142,1,0,0,145,1,0,0,147,1,0,0,148,1,0,0,150,1,0,0,152,1,0,0,156,1,0,0,157,1,0,0,159,1,0,0,160,1,0,0,162,1,0,0,162,1,0,0,164,1,0,0,164,1,0,0,166,1,0,0,167,1,0,0,169,1,0,0,169,1,0,0,172,1,0,0,172,1,0,0,174,1,0,0,175,1,0,0,177,1,0,0,179,1,0,0,181,1,0,0,181,1,0,0,183,1,0,0,184,1,0,0,188,1,0,0,188,1,0,0,196,1,0,0,196,1,0,0,199,1,0,0,199,1,0,0,202,1,0,0,202,1,0,0,205,1,0,0,205,1,0,0,207,1,0,0,207,1,0,0,209,1,0,0,209,1,0,0,211,1,0,0,211,1,0,0,213,1,0,0,213,1,0,0,215,1,0,0,215,1,0,0,217,1,0,0,217,1,0,0,219,1,0,0,219,1,0,0,222,1,0,0,222,1,0,0,224,1,0,0,224,1,0,0,226,1,0,0,226,1,0,0,228,1,0,0,228,1,0,0,230,1,0,0,230,1,0,0,232,1,0,0,232,1,0,0,234,1,0,0,234,1,0,0,236,1,0,0,236,1,0,0,238,1,0,0,238,1,0,0,241,1,0,0,241,1,0,0,244,1,0,0,244,1,0,0,246,1,0,0,248,1,0,0,250,1,0,0,250,1,0,0,252,1,0,0,252,1,0,0,254,1,0,0,254,1,0,0,0,2,0,0,0,2,0,0,2,2,0,0,2,2,0,0,4,2,0,0,4,2,0,0,6,2,0,0,6,2,0,0,8,2,0,0,8,2,0,0,10,2,0,0,10,2,0,0,12,2,0,0,12,2,0,0,14,2,0,0,14,2,0,0,16,2,0,0,16,2,0,0,18,2,0,0,18,2,0,0,20,2,0,0,20,2,0,0,22,2,0,0,22,2,0,0,24,2,0,0,24,2,0,0,26,2,0,0,26,2,0,0,28,2,0,0,28,2,0,0,30,2,0,0,30,2,0,0,32,2,0,0,32,2,0,0,34,2,0,0,34,2,0,0,36,2,0,0,36,2,0,0,38,2,0,0,38,2,0,0,40,2,0,0,40,2,0,0,42,2,0,0,42,2,0,0,44,2,0,0,44,2,0,0,46,2,0,0,46,2,0,0,48,2,0,0,48,2,0,0,50,2,0,0,50,2,0,0,58,2,0,0,59,2,0,0,61,2,0,0,62,2,0,0,65,2,0,0,65,2,0,0,134,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,143,3,0,0,145,3,0,0,161,3,0,0,163,3,0,0,171,3,0,0,210,3,0,0,212,3,0,0,216,3,0,0,216,3,0,0,218,3,0,0,218,3,0,0,220,3,0,0,220,3,0,0,222,3,0,0,222,3,0,0,224,3,0,0,224,3,0,0,226,3,0,0,226,3,0,0,228,3,0,0,228,3,0,0,230,3,0,0,230,3,0,0,232,3,0,0,232,3,0,0,234,3,0,0,234,3,0,0,236,3,0,0,236,3,0,0,238,3,0,0,238,3,0,0,244,3,0,0,244,3,0,0,247,3,0,0,247,3,0,0,249,3,0,0,250,3,0,0,253,3,0,0,47,4,0,0,96,4,0,0,96,4,0,0,98,4,0,0,98,4,0,0,100,4,0,0,100,4,0,0,102,4,0,0,102,4,0,0,104,4,0,0,104,4,0,0,106,4,0,0,106,4,0,0,108,4,0,0,108,4,0,0,110,4,0,0,110,4,0,0,112,4,0,0,112,4,0,0,114,4,0,0,114,4,0,0,116,4,0,0,116,4,0,0,118,4,0,0,118,4,0,0,120,4,0,0,120,4,0,0,122,4,0,0,122,4,0,0,124,4,0,0,124,4,0,0,126,4,0,0,126,4,0,0,128,4,0,0,128,4,0,0,138,4,0,0,138,4,0,0,140,4,0,0,140,4,0,0,142,4,0,0,142,4,0,0,144,4,0,0,144,4,0,0,146,4,0,0,146,4,0,0,148,4,0,0,148,4,0,0,150,4,0,0,150,4,0,0,152,4,0,0,152,4,0,0,154,4,0,0,154,4,0,0,156,4,0,0,156,4,0,0,158,4,0,0,158,4,0,0,160,4,0,0,160,4,0,0,162,4,0,0,162,4,0,0,164,4,0,0,164,4,0,0,166,4,0,0,166,4,0,0,168,4,0,0,168,4,0,0,170,4,0,0,170,4,0,0,172,4,0,0,172,4,0,0,174,4,0,0,174,4,0,0,176,4,0,0,176,4,0,0,178,4,0,0,178,4,0,0,180,4,0,0,180,4,0,0,182,4,0,0,182,4,0,0,184,4,0,0,184,4,0,0,186,4,0,0,186,4,0,0,188,4,0,0,188,4,0,0,190,4,0,0,190,4,0,0,192,4,0,0,193,4,0,0,195,4,0,0,195,4,0,0,197,4,0,0,197,4,0,0,199,4,0,0,199,4,0,0,201,4,0,0,201,4,0,0,203,4,0,0,203,4,0,0,205,4,0,0,205,4,0,0,208,4,0,0,208,4,0,0,210,4,0,0,210,4,0,0,212,4,0,0,212,4,0,0,214,4,0,0,214,4,0,0,216,4,0,0,216,4,0,0,218,4,0,0,218,4,0,0,220,4,0,0,220,4,0,0,222,4,0,0,222,4,0,0,224,4,0,0,224,4,0,0,226,4,0,0,226,4,0,0,228,4,0,0,228,4,0,0,230,4,0,0,230,4,0,0,232,4,0,0,232,4,0,0,234,4,0,0,234,4,0,0,236,4,0,0,236,4,0,0,238,4,0,0,238,4,0,0,240,4,0,0,240,4,0,0,242,4,0,0,242,4,0,0,244,4,0,0,244,4,0,0,246,4,0,0,246,4,0,0,248,4,0,0,248,4,0,0,0,5,0,0,0,5,0,0,2,5,0,0,2,5,0,0,4,5,0,0,4,5,0,0,6,5,0,0,6,5,0,0,8,5,0,0,8,5,0,0,10,5,0,0,10,5,0,0,12,5,0,0,12,5,0,0,14,5,0,0,14,5,0,0,49,5,0,0,86,5,0,0,160,16,0,0,197,16,0,0,0,30,0,0,0,30,0,0,2,30,0,0,2,30,0,0,4,30,0,0,4,30,0,0,6,30,0,0,6,30,0,0,8,30,0,0,8,30,0,0,10,30,0,0,10,30,0,0,12,30,0,0,12,30,0,0,14,30,0,0,14,30,0,0,16,30,0,0,16,30,0,0,18,30,0,0,18,30,0,0,20,30,0,0,20,30,0,0,22,30,0,0,22,30,0,0,24,30,0,0,24,30,0,0,26,30,0,0,26,30,0,0,28,30,0,0,28,30,0,0,30,30,0,0,30,30,0,0,32,30,0,0,32,30,0,0,34,30,0,0,34,30,0,0,36,30,0,0,36,30,0,0,38,30,0,0,38,30,0,0,40,30,0,0,40,30,0,0,42,30,0,0,42,30,0,0,44,30,0,0,44,30,0,0,46,30,0,0,46,30,0,0,48,30,0,0,48,30,0,0,50,30,0,0,50,30,0,0,52,30,0,0,52,30,0,0,54,30,0,0,54,30,0,0,56,30,0,0,56,30,0,0,58,30,0,0,58,30,0,0,60,30,0,0,60,30,0,0,62,30,0,0,62,30,0,0,64,30,0,0,64,30,0,0,66,30,0,0,66,30,0,0,68,30,0,0,68,30,0,0,70,30,0,0,70,30,0,0,72,30,0,0,72,30,0,0,74,30,0,0,74,30,0,0,76,30,0,0,76,30,0,0,78,30,0,0,78,30,0,0,80,30,0,0,80,30,0,0,82,30,0,0,82,30,0,0,84,30,0,0,84,30,0,0,86,30,0,0,86,30,0,0,88,30,0,0,88,30,0,0,90,30,0,0,90,30,0,0,92,30,0,0,92,30,0,0,94,30,0,0,94,30,0,0,96,30,0,0,96,30,0,0,98,30,0,0,98,30,0,0,100,30,0,0,100,30,0,0,102,30,0,0,102,30,0,0,104,30,0,0,104,30,0,0,106,30,0,0,106,30,0,0,108,30,0,0,108,30,0,0,110,30,0,0,110,30,0,0,112,30,0,0,112,30,0,0,114,30,0,0,114,30,0,0,116,30,0,0,116,30,0,0,118,30,0,0,118,30,0,0,120,30,0,0,120,30,0,0,122,30,0,0,122,30,0,0,124,30,0,0,124,30,0,0,126,30,0,0,126,30,0,0,128,30,0,0,128,30,0,0,130,30,0,0,130,30,0,0,132,30,0,0,132,30,0,0,134,30,0,0,134,30,0,0,136,30,0,0,136,30,0,0,138,30,0,0,138,30,0,0,140,30,0,0,140,30,0,0,142,30,0,0,142,30,0,0,144,30,0,0,144,30,0,0,146,30,0,0,146,30,0,0,148,30,0,0,148,30,0,0,160,30,0,0,160,30,0,0,162,30,0,0,162,30,0,0,164,30,0,0,164,30,0,0,166,30,0,0,166,30,0,0,168,30,0,0,168,30,0,0,170,30,0,0,170,30,0,0,172,30,0,0,172,30,0,0,174,30,0,0,174,30,0,0,176,30,0,0,176,30,0,0,178,30,0,0,178,30,0,0,180,30,0,0,180,30,0,0,182,30,0,0,182,30,0,0,184,30,0,0,184,30,0,0,186,30,0,0,186,30,0,0,188,30,0,0,188,30,0,0,190,30,0,0,190,30,0,0,192,30,0,0,192,30,0,0,194,30,0,0,194,30,0,0,196,30,0,0,196,30,0,0,198,30,0,0,198,30,0,0,200,30,0,0,200,30,0,0,202,30,0,0,202,30,0,0,204,30,0,0,204,30,0,0,206,30,0,0,206,30,0,0,208,30,0,0,208,30,0,0,210,30,0,0,210,30,0,0,212,30,0,0,212,30,0,0,214,30,0,0,214,30,0,0,216,30,0,0,216,30,0,0,218,30,0,0,218,30,0,0,220,30,0,0,220,30,0,0,222,30,0,0,222,30,0,0,224,30,0,0,224,30,0,0,226,30,0,0,226,30,0,0,228,30,0,0,228,30,0,0,230,30,0,0,230,30,0,0,232,30,0,0,232,30,0,0,234,30,0,0,234,30,0,0,236,30,0,0,236,30,0,0,238,30,0,0,238,30,0,0,240,30,0,0,240,30,0,0,242,30,0,0,242,30,0,0,244,30,0,0,244,30,0,0,246,30,0,0,246,30,0,0,248,30,0,0,248,30,0,0,8,31,0,0,15,31,0,0,24,31,0,0,29,31,0,0,40,31,0,0,47,31,0,0,56,31,0,0,63,31,0,0,72,31,0,0,77,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,95,31,0,0,104,31,0,0,111,31,0,0,184,31,0,0,187,31,0,0,200,31,0,0,203,31,0,0,216,31,0,0,219,31,0,0,232,31,0,0,236,31,0,0,248,31,0,0,251,31,0,0,2,33,0,0,2,33,0,0,7,33,0,0,7,33,0,0,11,33,0,0,13,33,0,0,16,33,0,0,18,33,0,0,21,33,0,0,21,33,0,0,25,33,0,0,29,33,0,0,36,33,0,0,36,33,0,0,38,33,0,0,38,33,0,0,40,33,0,0,40,33,0,0,42,33,0,0,45,33,0,0,48,33,0,0,49,33,0,0,51,33,0,0,51,33,0,0,62,33,0,0,63,33,0,0,69,33,0,0,69,33,0,0,0,44,0,0,46,44,0,0,128,44,0,0,128,44,0,0,130,44,0,0,130,44,0,0,132,44,0,0,132,44,0,0,134,44,0,0,134,44,0,0,136,44,0,0,136,44,0,0,138,44,0,0,138,44,0,0,140,44,0,0,140,44,0,0,142,44,0,0,142,44,0,0,144,44,0,0,144,44,0,0,146,44,0,0,146,44,0,0,148,44,0,0,148,44,0,0,150,44,0,0,150,44,0,0,152,44,0,0,152,44,0,0,154,44,0,0,154,44,0,0,156,44,0,0,156,44,0,0,158,44,0,0,158,44,0,0,160,44,0,0,160,44,0,0,162,44,0,0,162,44,0,0,164,44,0,0,164,44,0,0,166,44,0,0,166,44,0,0,168,44,0,0,168,44,0,0,170,44,0,0,170,44,0,0,172,44,0,0,172,44,0,0,174,44,0,0,174,44,0,0,176,44,0,0,176,44,0,0,178,44,0,0,178,44,0,0,180,44,0,0,180,44,0,0,182,44,0,0,182,44,0,0,184,44,0,0,184,44,0,0,186,44,0,0,186,44,0,0,188,44,0,0,188,44,0,0,190,44,0,0,190,44,0,0,192,44,0,0,192,44,0,0,194,44,0,0,194,44,0,0,196,44,0,0,196,44,0,0,198,44,0,0,198,44,0,0,200,44,0,0,200,44,0,0,202,44,0,0,202,44,0,0,204,44,0,0,204,44,0,0,206,44,0,0,206,44,0,0,208,44,0,0,208,44,0,0,210,44,0,0,210,44,0,0,212,44,0,0,212,44,0,0,214,44,0,0,214,44,0,0,216,44,0,0,216,44,0,0,218,44,0,0,218,44,0,0,220,44,0,0,220,44,0,0,222,44,0,0,222,44,0,0,224,44,0,0,224,44,0,0,226,44,0,0,226,44,0,0,33,255,0,0,58,255,0,0,0,4,1,0,39,4,1,0,0,212,1,0,25,212,1,0,52,212,1,0,77,212,1,0,104,212,1,0,129,212,1,0,156,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,181,212,1,0,208,212,1,0,233,212,1,0,4,213,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,56,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,108,213,1,0,133,213,1,0,160,213,1,0,185,213,1,0,212,213,1,0,237,213,1,0,8,214,1,0,33,214,1,0,60,214,1,0,85,214,1,0,112,214,1,0,137,214,1,0,168,214,1,0,192,214,1,0,226,214,1,0,250,214,1,0,28,215,1,0,52,215,1,0,86,215,1,0,110,215,1,0,144,215,1,0,168,215,1,0,133,0,0,0,0,3,0,0,111,3,0,0,131,4,0,0,134,4,0,0,136,4,0,0,137,4,0,0,145,5,0,0,185,5,0,0,187,5,0,0,189,5,0,0,191,5,0,0,191,5,0,0,193,5,0,0,194,5,0,0,196,5,0,0,197,5,0,0,199,5,0,0,199,5,0,0,16,6,0,0,21,6,0,0,75,6,0,0,94,6,0,0,112,6,0,0,112,6,0,0,214,6,0,0,220,6,0,0,222,6,0,0,228,6,0,0,231,6,0,0,232,6,0,0,234,6,0,0,237,6,0,0,17,7,0,0,17,7,0,0,48,7,0,0,74,7,0,0,166,7,0,0,176,7,0,0,1,9,0,0,3,9,0,0,60,9,0,0,60,9,0,0,62,9,0,0,77,9,0,0,81,9,0,0,84,9,0,0,98,9,0,0,99,9,0,0,129,9,0,0,131,9,0,0,188,9,0,0,188,9,0,0,190,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,205,9,0,0,215,9,0,0,215,9,0,0,226,9,0,0,227,9,0,0,1,10,0,0,3,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,112,10,0,0,113,10,0,0,129,10,0,0,131,10,0,0,188,10,0,0,188,10,0,0,190,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,226,10,0,0,227,10,0,0,1,11,0,0,3,11,0,0,60,11,0,0,60,11,0,0,62,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,130,11,0,0,130,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,1,12,0,0,3,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,130,12,0,0,131,12,0,0,188,12,0,0,188,12,0,0,190,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,2,13,0,0,3,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,130,13,0,0,131,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,243,13,0,0,49,14,0,0,49,14,0,0,52,14,0,0,58,14,0,0,71,14,0,0,78,14,0,0,177,14,0,0,177,14,0,0,180,14,0,0,185,14,0,0,187,14,0,0,188,14,0,0,200,14,0,0,205,14,0,0,24,15,0,0,25,15,0,0,53,15,0,0,53,15,0,0,55,15,0,0,55,15,0,0,57,15,0,0,57,15,0,0,62,15,0,0,63,15,0,0,113,15,0,0,132,15,0,0,134,15,0,0,135,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,198,15,0,0,198,15,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,86,16,0,0,89,16,0,0,95,19,0,0,95,19,0,0,18,23,0,0,20,23,0,0,50,23,0,0,52,23,0,0,82,23,0,0,83,23,0,0,114,23,0,0,115,23,0,0,182,23,0,0,211,23,0,0,221,23,0,0,221,23,0,0,11,24,0,0,13,24,0,0,169,24,0,0,169,24,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,176,25,0,0,192,25,0,0,200,25,0,0,201,25,0,0,23,26,0,0,27,26,0,0,192,29,0,0,195,29,0,0,208,32,0,0,235,32,0,0,42,48,0,0,47,48,0,0,153,48,0,0,154,48,0,0,2,168,0,0,2,168,0,0,6,168,0,0,6,168,0,0,11,168,0,0,11,168,0,0,35,168,0,0,39,168,0,0,30,251,0,0,30,251,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,1,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,15,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,63,10,1,0,101,209,1,0,105,209,1,0,109,209,1,0,114,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,66,210,1,0,68,210,1,0,0,1,14,0,239,1,14,0,63,0,0,0,3,9,0,0,3,9,0,0,62,9,0,0,64,9,0,0,73,9,0,0,76,9,0,0,130,9,0,0,131,9,0,0,190,9,0,0,192,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,204,9,0,0,215,9,0,0,215,9,0,0,3,10,0,0,3,10,0,0,62,10,0,0,64,10,0,0,131,10,0,0,131,10,0,0,190,10,0,0,192,10,0,0,201,10,0,0,201,10,0,0,203,10,0,0,204,10,0,0,2,11,0,0,3,11,0,0,62,11,0,0,62,11,0,0,64,11,0,0,64,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,76,11,0,0,87,11,0,0,87,11,0,0,190,11,0,0,191,11,0,0,193,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,204,11,0,0,215,11,0,0,215,11,0,0,1,12,0,0,3,12,0,0,65,12,0,0,68,12,0,0,130,12,0,0,131,12,0,0,190,12,0,0,190,12,0,0,192,12,0,0,196,12,0,0,199,12,0,0,200,12,0,0,202,12,0,0,203,12,0,0,213,12,0,0,214,12,0,0,2,13,0,0,3,13,0,0,62,13], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+417156);
/* memory initializer */ allocate([64,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,76,13,0,0,87,13,0,0,87,13,0,0,130,13,0,0,131,13,0,0,207,13,0,0,209,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,243,13,0,0,62,15,0,0,63,15,0,0,127,15,0,0,127,15,0,0,44,16,0,0,44,16,0,0,49,16,0,0,49,16,0,0,56,16,0,0,56,16,0,0,86,16,0,0,87,16,0,0,182,23,0,0,182,23,0,0,190,23,0,0,197,23,0,0,199,23,0,0,200,23,0,0,35,25,0,0,38,25,0,0,41,25,0,0,43,25,0,0,48,25,0,0,49,25,0,0,51,25,0,0,56,25,0,0,176,25,0,0,192,25,0,0,200,25,0,0,201,25,0,0,25,26,0,0,27,26,0,0,2,168,0,0,2,168,0,0,35,168,0,0,36,168,0,0,39,168,0,0,39,168,0,0,101,209,1,0,102,209,1,0,109,209,1,0,114,209,1,0,4,0,0,0,136,4,0,0,137,4,0,0,222,6,0,0,222,6,0,0,221,32,0,0,224,32,0,0,226,32,0,0,228,32,0,0,124,0,0,0,0,3,0,0,111,3,0,0,131,4,0,0,134,4,0,0,145,5,0,0,185,5,0,0,187,5,0,0,189,5,0,0,191,5,0,0,191,5,0,0,193,5,0,0,194,5,0,0,196,5,0,0,197,5,0,0,199,5,0,0,199,5,0,0,16,6,0,0,21,6,0,0,75,6,0,0,94,6,0,0,112,6,0,0,112,6,0,0,214,6,0,0,220,6,0,0,223,6,0,0,228,6,0,0,231,6,0,0,232,6,0,0,234,6,0,0,237,6,0,0,17,7,0,0,17,7,0,0,48,7,0,0,74,7,0,0,166,7,0,0,176,7,0,0,1,9,0,0,2,9,0,0,60,9,0,0,60,9,0,0,65,9,0,0,72,9,0,0,77,9,0,0,77,9,0,0,81,9,0,0,84,9,0,0,98,9,0,0,99,9,0,0,129,9,0,0,129,9,0,0,188,9,0,0,188,9,0,0,193,9,0,0,196,9,0,0,205,9,0,0,205,9,0,0,226,9,0,0,227,9,0,0,1,10,0,0,2,10,0,0,60,10,0,0,60,10,0,0,65,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,112,10,0,0,113,10,0,0,129,10,0,0,130,10,0,0,188,10,0,0,188,10,0,0,193,10,0,0,197,10,0,0,199,10,0,0,200,10,0,0,205,10,0,0,205,10,0,0,226,10,0,0,227,10,0,0,1,11,0,0,1,11,0,0,60,11,0,0,60,11,0,0,63,11,0,0,63,11,0,0,65,11,0,0,67,11,0,0,77,11,0,0,77,11,0,0,86,11,0,0,86,11,0,0,130,11,0,0,130,11,0,0,192,11,0,0,192,11,0,0,205,11,0,0,205,11,0,0,62,12,0,0,64,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,188,12,0,0,188,12,0,0,191,12,0,0,191,12,0,0,198,12,0,0,198,12,0,0,204,12,0,0,205,12,0,0,65,13,0,0,67,13,0,0,77,13,0,0,77,13,0,0,202,13,0,0,202,13,0,0,210,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,49,14,0,0,49,14,0,0,52,14,0,0,58,14,0,0,71,14,0,0,78,14,0,0,177,14,0,0,177,14,0,0,180,14,0,0,185,14,0,0,187,14,0,0,188,14,0,0,200,14,0,0,205,14,0,0,24,15,0,0,25,15,0,0,53,15,0,0,53,15,0,0,55,15,0,0,55,15,0,0,57,15,0,0,57,15,0,0,113,15,0,0,126,15,0,0,128,15,0,0,132,15,0,0,134,15,0,0,135,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,198,15,0,0,198,15,0,0,45,16,0,0,48,16,0,0,50,16,0,0,50,16,0,0,54,16,0,0,55,16,0,0,57,16,0,0,57,16,0,0,88,16,0,0,89,16,0,0,95,19,0,0,95,19,0,0,18,23,0,0,20,23,0,0,50,23,0,0,52,23,0,0,82,23,0,0,83,23,0,0,114,23,0,0,115,23,0,0,183,23,0,0,189,23,0,0,198,23,0,0,198,23,0,0,201,23,0,0,211,23,0,0,221,23,0,0,221,23,0,0,11,24,0,0,13,24,0,0,169,24,0,0,169,24,0,0,32,25,0,0,34,25,0,0,39,25,0,0,40,25,0,0,50,25,0,0,50,25,0,0,57,25,0,0,59,25,0,0,23,26,0,0,24,26,0,0,192,29,0,0,195,29,0,0,208,32,0,0,220,32,0,0,225,32,0,0,225,32,0,0,229,32,0,0,235,32,0,0,42,48,0,0,47,48,0,0,153,48,0,0,154,48,0,0,6,168,0,0,6,168,0,0,11,168,0,0,11,168,0,0,37,168,0,0,38,168,0,0,30,251,0,0,30,251,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,1,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,15,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,63,10,1,0,103,209,1,0,105,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,66,210,1,0,68,210,1,0,0,1,14,0,239,1,14,0,53,0,0,0,48,0,0,0,57,0,0,0,178,0,0,0,179,0,0,0,185,0,0,0,185,0,0,0,188,0,0,0,190,0,0,0,96,6,0,0,105,6,0,0,240,6,0,0,249,6,0,0,102,9,0,0,111,9,0,0,230,9,0,0,239,9,0,0,244,9,0,0,249,9,0,0,102,10,0,0,111,10,0,0,230,10,0,0,239,10,0,0,102,11,0,0,111,11,0,0,230,11,0,0,242,11,0,0,102,12,0,0,111,12,0,0,230,12,0,0,239,12,0,0,102,13,0,0,111,13,0,0,80,14,0,0,89,14,0,0,208,14,0,0,217,14,0,0,32,15,0,0,51,15,0,0,64,16,0,0,73,16,0,0,105,19,0,0,124,19,0,0,238,22,0,0,240,22,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,16,24,0,0,25,24,0,0,70,25,0,0,79,25,0,0,208,25,0,0,217,25,0,0,112,32,0,0,112,32,0,0,116,32,0,0,121,32,0,0,128,32,0,0,137,32,0,0,83,33,0,0,131,33,0,0,96,36,0,0,155,36,0,0,234,36,0,0,255,36,0,0,118,39,0,0,147,39,0,0,253,44,0,0,253,44,0,0,7,48,0,0,7,48,0,0,33,48,0,0,41,48,0,0,56,48,0,0,58,48,0,0,146,49,0,0,149,49,0,0,32,50,0,0,41,50,0,0,81,50,0,0,95,50,0,0,128,50,0,0,137,50,0,0,177,50,0,0,191,50,0,0,16,255,0,0,25,255,0,0,7,1,1,0,51,1,1,0,64,1,1,0,120,1,1,0,138,1,1,0,138,1,1,0,32,3,1,0,35,3,1,0,74,3,1,0,74,3,1,0,209,3,1,0,213,3,1,0,160,4,1,0,169,4,1,0,64,10,1,0,71,10,1,0,206,215,1,0,255,215,1,0,23,0,0,0,48,0,0,0,57,0,0,0,96,6,0,0,105,6,0,0,240,6,0,0,249,6,0,0,102,9,0,0,111,9,0,0,230,9,0,0,239,9,0,0,102,10,0,0,111,10,0,0,230,10,0,0,239,10,0,0,102,11,0,0,111,11,0,0,230,11,0,0,239,11,0,0,102,12,0,0,111,12,0,0,230,12,0,0,239,12,0,0,102,13,0,0,111,13,0,0,80,14,0,0,89,14,0,0,208,14,0,0,217,14,0,0,32,15,0,0,41,15,0,0,64,16,0,0,73,16,0,0,224,23,0,0,233,23,0,0,16,24,0,0,25,24,0,0,70,25,0,0,79,25,0,0,208,25,0,0,217,25,0,0,16,255,0,0,25,255,0,0,160,4,1,0,169,4,1,0,206,215,1,0,255,215,1,0,8,0,0,0,238,22,0,0,240,22,0,0,96,33,0,0,131,33,0,0,7,48,0,0,7,48,0,0,33,48,0,0,41,48,0,0,56,48,0,0,58,48,0,0,64,1,1,0,116,1,1,0,74,3,1,0,74,3,1,0,209,3,1,0,213,3,1,0,26,0,0,0,178,0,0,0,179,0,0,0,185,0,0,0,185,0,0,0,188,0,0,0,190,0,0,0,244,9,0,0,249,9,0,0,240,11,0,0,242,11,0,0,42,15,0,0,51,15,0,0,105,19,0,0,124,19,0,0,240,23,0,0,249,23,0,0,112,32,0,0,112,32,0,0,116,32,0,0,121,32,0,0,128,32,0,0,137,32,0,0,83,33,0,0,95,33,0,0,96,36,0,0,155,36,0,0,234,36,0,0,255,36,0,0,118,39,0,0,147,39,0,0,253,44,0,0,253,44,0,0,146,49,0,0,149,49,0,0,32,50,0,0,41,50,0,0,81,50,0,0,95,50,0,0,128,50,0,0,137,50,0,0,177,50,0,0,191,50,0,0,7,1,1,0,51,1,1,0,117,1,1,0,120,1,1,0,138,1,1,0,138,1,1,0,32,3,1,0,35,3,1,0,64,10,1,0,71,10,1,0,96,0,0,0,33,0,0,0,35,0,0,0,37,0,0,0,42,0,0,0,44,0,0,0,47,0,0,0,58,0,0,0,59,0,0,0,63,0,0,0,64,0,0,0,91,0,0,0,93,0,0,0,95,0,0,0,95,0,0,0,123,0,0,0,123,0,0,0,125,0,0,0,125,0,0,0,161,0,0,0,161,0,0,0,171,0,0,0,171,0,0,0,183,0,0,0,183,0,0,0,187,0,0,0,187,0,0,0,191,0,0,0,191,0,0,0,126,3,0,0,126,3,0,0,135,3,0,0,135,3,0,0,90,5,0,0,95,5,0,0,137,5,0,0,138,5,0,0,190,5,0,0,190,5,0,0,192,5,0,0,192,5,0,0,195,5,0,0,195,5,0,0,198,5,0,0,198,5,0,0,243,5,0,0,244,5,0,0,12,6,0,0,13,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,106,6,0,0,109,6,0,0,212,6,0,0,212,6,0,0,0,7,0,0,13,7,0,0,100,9,0,0,101,9,0,0,112,9,0,0,112,9,0,0,244,13,0,0,244,13,0,0,79,14,0,0,79,14,0,0,90,14,0,0,91,14,0,0,4,15,0,0,18,15,0,0,58,15,0,0,61,15,0,0,133,15,0,0,133,15,0,0,208,15,0,0,209,15,0,0,74,16,0,0,79,16,0,0,251,16,0,0,251,16,0,0,97,19,0,0,104,19,0,0,109,22,0,0,110,22,0,0,155,22,0,0,156,22,0,0,235,22,0,0,237,22,0,0,53,23,0,0,54,23,0,0,212,23,0,0,214,23,0,0,216,23,0,0,218,23,0,0,0,24,0,0,10,24,0,0,68,25,0,0,69,25,0,0,222,25,0,0,223,25,0,0,30,26,0,0,31,26,0,0,16,32,0,0,39,32,0,0,48,32,0,0,67,32,0,0,69,32,0,0,81,32,0,0,83,32,0,0,94,32,0,0,125,32,0,0,126,32,0,0,141,32,0,0,142,32,0,0,41,35,0,0,42,35,0,0,180,35,0,0,182,35,0,0,104,39,0,0,117,39,0,0,197,39,0,0,198,39,0,0,230,39,0,0,235,39,0,0,131,41,0,0,152,41,0,0,216,41,0,0,219,41,0,0,252,41,0,0,253,41,0,0,249,44,0,0,252,44,0,0,254,44,0,0,255,44,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,1,48,0,0,3,48,0,0,8,48,0,0,17,48,0,0,20,48,0,0,31,48,0,0,48,48,0,0,48,48,0,0,61,48,0,0,61,48,0,0,160,48,0,0,160,48,0,0,251,48,0,0,251,48,0,0,62,253,0,0,63,253,0,0,16,254,0,0,25,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,97,254,0,0,99,254,0,0,99,254,0,0,104,254,0,0,104,254,0,0,106,254,0,0,107,254,0,0,1,255,0,0,3,255,0,0,5,255,0,0,10,255,0,0,12,255,0,0,15,255,0,0,26,255,0,0,27,255,0,0,31,255,0,0,32,255,0,0,59,255,0,0,61,255,0,0,63,255,0,0,63,255,0,0,91,255,0,0,91,255,0,0,93,255,0,0,93,255,0,0,95,255,0,0,101,255,0,0,0,1,1,0,1,1,1,0,159,3,1,0,159,3,1,0,80,10,1,0,88,10,1,0,6,0,0,0,95,0,0,0,95,0,0,0,63,32,0,0,64,32,0,0,84,32,0,0,84,32,0,0,51,254,0,0,52,254,0,0,77,254,0,0,79,254,0,0,63,255,0,0,63,255,0,0,12,0,0,0,45,0,0,0,45,0,0,0,138,5,0,0,138,5,0,0,6,24,0,0,6,24,0,0,16,32,0,0,21,32,0,0,23,46,0,0,23,46,0,0,28,48,0,0,28,48,0,0,48,48,0,0,48,48,0,0,160,48,0,0,160,48,0,0,49,254,0,0,50,254,0,0,88,254,0,0,88,254,0,0,99,254,0,0,99,254,0,0,13,255,0,0,13,255,0,0,65,0,0,0,41,0,0,0,41,0,0,0,93,0,0,0,93,0,0,0,125,0,0,0,125,0,0,0,59,15,0,0,59,15,0,0,61,15,0,0,61,15,0,0,156,22,0,0,156,22,0,0,70,32,0,0,70,32,0,0,126,32,0,0,126,32,0,0,142,32,0,0,142,32,0,0,42,35,0,0,42,35,0,0,181,35,0,0,181,35,0,0,105,39,0,0,105,39,0,0,107,39,0,0,107,39,0,0,109,39,0,0,109,39,0,0,111,39,0,0,111,39,0,0,113,39,0,0,113,39,0,0,115,39,0,0,115,39,0,0,117,39,0,0,117,39,0,0,198,39,0,0,198,39,0,0,231,39,0,0,231,39,0,0,233,39,0,0,233,39,0,0,235,39,0,0,235,39,0,0,132,41,0,0,132,41,0,0,134,41,0,0,134,41,0,0,136,41,0,0,136,41,0,0,138,41,0,0,138,41,0,0,140,41,0,0,140,41,0,0,142,41,0,0,142,41,0,0,144,41,0,0,144,41,0,0,146,41,0,0,146,41,0,0,148,41,0,0,148,41,0,0,150,41,0,0,150,41,0,0,152,41,0,0,152,41,0,0,217,41,0,0,217,41,0,0,219,41,0,0,219,41,0,0,253,41,0,0,253,41,0,0,9,48,0,0,9,48,0,0,11,48,0,0,11,48,0,0,13,48,0,0,13,48,0,0,15,48,0,0,15,48,0,0,17,48,0,0,17,48,0,0,21,48,0,0,21,48,0,0,23,48,0,0,23,48,0,0,25,48,0,0,25,48,0,0,27,48,0,0,27,48,0,0,30,48,0,0,31,48,0,0,63,253,0,0,63,253,0,0,24,254,0,0,24,254,0,0,54,254,0,0,54,254,0,0,56,254,0,0,56,254,0,0,58,254,0,0,58,254,0,0,60,254,0,0,60,254,0,0,62,254,0,0,62,254,0,0,64,254,0,0,64,254,0,0,66,254,0,0,66,254,0,0,68,254,0,0,68,254,0,0,72,254,0,0,72,254,0,0,90,254,0,0,90,254,0,0,92,254,0,0,92,254,0,0,94,254,0,0,94,254,0,0,9,255,0,0,9,255,0,0,61,255,0,0,61,255,0,0,93,255,0,0,93,255,0,0,96,255,0,0,96,255,0,0,99,255,0,0,99,255,0,0,9,0,0,0,187,0,0,0,187,0,0,0,25,32,0,0,25,32,0,0,29,32,0,0,29,32,0,0,58,32,0,0,58,32,0,0,3,46,0,0,3,46,0,0,5,46,0,0,5,46,0,0,10,46,0,0,10,46,0,0,13,46,0,0,13,46,0,0,29,46,0,0,29,46,0,0,10,0,0,0,171,0,0,0,171,0,0,0,24,32,0,0,24,32,0,0,27,32,0,0,28,32,0,0,31,32,0,0,31,32,0,0,57,32,0,0,57,32,0,0,2,46,0,0,2,46,0,0,4,46,0,0,4,46,0,0,9,46,0,0,9,46,0,0,12,46,0,0,12,46,0,0,28,46,0,0,28,46,0,0,88,0,0,0,33,0,0,0,35,0,0,0,37,0,0,0,39,0,0,0,42,0,0,0,42,0,0,0,44,0,0,0,44,0,0,0,46,0,0,0,47,0,0,0,58,0,0,0,59,0,0,0,63,0,0,0,64,0,0,0,92,0,0,0,92,0,0,0,161,0,0,0,161,0,0,0,183,0,0,0,183,0,0,0,191,0,0,0,191,0,0,0,126,3,0,0,126,3,0,0,135,3,0,0,135,3,0,0,90,5,0,0,95,5,0,0,137,5,0,0,137,5,0,0,190,5,0,0,190,5,0,0,192,5,0,0,192,5,0,0,195,5,0,0,195,5,0,0,198,5,0,0,198,5,0,0,243,5,0,0,244,5,0,0,12,6,0,0,13,6,0,0,27,6,0,0,27,6,0,0,30,6,0,0,31,6,0,0,106,6,0,0,109,6,0,0,212,6,0,0,212,6,0,0,0,7,0,0,13,7,0,0,100,9,0,0,101,9,0,0,112,9,0,0,112,9,0,0,244,13,0,0,244,13,0,0,79,14,0,0,79,14,0,0,90,14,0,0,91,14,0,0,4,15,0,0,18,15,0,0,133,15,0,0,133,15,0,0,208,15,0,0,209,15,0,0,74,16,0,0,79,16,0,0,251,16,0,0,251,16,0,0,97,19,0,0,104,19,0,0,109,22,0,0,110,22,0,0,235,22,0,0,237,22,0,0,53,23,0,0,54,23,0,0,212,23,0,0,214,23,0,0,216,23,0,0,218,23,0,0,0,24,0,0,5,24,0,0,7,24,0,0,10,24,0,0,68,25,0,0,69,25,0,0,222,25,0,0,223,25,0,0,30,26,0,0,31,26,0,0,22,32,0,0,23,32,0,0,32,32,0,0,39,32,0,0,48,32,0,0,56,32,0,0,59,32,0,0,62,32,0,0,65,32,0,0,67,32,0,0,71,32,0,0,81,32,0,0,83,32,0,0,83,32,0,0,85,32,0,0,94,32,0,0,182,35,0,0,182,35,0,0,249,44,0,0,252,44,0,0,254,44,0,0,255,44,0,0,0,46,0,0,1,46,0,0,6,46,0,0,8,46,0,0,11,46,0,0,11,46,0,0,14,46,0,0,22,46,0,0,1,48,0,0,3,48,0,0,61,48,0,0,61,48,0,0,251,48,0,0,251,48,0,0,16,254,0,0,22,254,0,0,25,254,0,0,25,254,0,0,48,254,0,0,48,254,0,0,69,254,0,0,70,254,0,0,73,254,0,0,76,254,0,0,80,254,0,0,82,254,0,0,84,254,0,0,87,254,0,0,95,254,0,0,97,254,0,0,104,254,0,0,104,254,0,0,106,254,0,0,107,254,0,0,1,255,0,0,3,255,0,0,5,255,0,0,7,255,0,0,10,255,0,0,10,255,0,0,12,255,0,0,12,255,0,0,14,255,0,0,15,255,0,0,26,255,0,0,27,255,0,0,31,255,0,0,32,255,0,0,60,255,0,0,60,255,0,0,97,255,0,0,97,255,0,0,100,255,0,0,101,255,0,0,0,1,1,0,1,1,1,0,159,3,1,0,159,3,1,0,80,10,1,0,88,10,1,0,67,0,0,0,40,0,0,0,40,0,0,0,91,0,0,0,91,0,0,0,123,0,0,0,123,0,0,0,58,15,0,0,58,15,0,0,60,15,0,0,60,15,0,0,155,22,0,0,155,22,0,0,26,32,0,0,26,32,0,0,30,32,0,0,30,32,0,0,69,32,0,0,69,32,0,0,125,32,0,0,125,32,0,0,141,32,0,0,141,32,0,0,41,35,0,0,41,35,0,0,180,35,0,0,180,35,0,0,104,39,0,0,104,39,0,0,106,39,0,0,106,39,0,0,108,39,0,0,108,39,0,0,110,39,0,0,110,39,0,0,112,39,0,0,112,39,0,0,114,39,0,0,114,39,0,0,116,39,0,0,116,39,0,0,197,39,0,0,197,39,0,0,230,39,0,0,230,39,0,0,232,39,0,0,232,39,0,0,234,39,0,0,234,39,0,0,131,41,0,0,131,41,0,0,133,41,0,0,133,41,0,0,135,41,0,0,135,41,0,0,137,41,0,0,137,41,0,0,139,41,0,0,139,41,0,0,141,41,0,0,141,41,0,0,143,41,0,0,143,41,0,0,145,41,0,0,145,41,0,0,147,41,0,0,147,41,0,0,149,41,0,0,149,41,0,0,151,41,0,0,151,41,0,0,216,41,0,0,216,41,0,0,218,41,0,0,218,41,0,0,252,41,0,0,252,41,0,0,8,48,0,0,8,48,0,0,10,48,0,0,10,48,0,0,12,48,0,0,12,48,0,0,14,48,0,0,14,48,0,0,16,48,0,0,16,48,0,0,20,48,0,0,20,48,0,0,22,48,0,0,22,48,0,0,24,48,0,0,24,48,0,0,26,48,0,0,26,48,0,0,29,48,0,0,29,48,0,0,62,253,0,0,62,253,0,0,23,254,0,0,23,254,0,0,53,254,0,0,53,254,0,0,55,254,0,0,55,254,0,0,57,254,0,0,57,254,0,0,59,254,0,0,59,254,0,0,61,254,0,0,61,254,0,0,63,254,0,0,63,254,0,0,65,254,0,0,65,254,0,0,67,254,0,0,67,254,0,0,71,254,0,0,71,254,0,0,89,254,0,0,89,254,0,0,91,254,0,0,91,254,0,0,93,254,0,0,93,254,0,0,8,255,0,0,8,255,0,0,59,255,0,0,59,255,0,0,91,255,0,0,91,255,0,0,95,255,0,0,95,255,0,0,98,255,0,0,98,255,0,0,162,0,0,0,36,0,0,0,36,0,0,0,43,0,0,0,43,0,0,0,60,0,0,0,62,0,0,0,94,0,0,0,94,0,0,0,96,0,0,0,96,0,0,0,124,0,0,0,124,0,0,0,126,0,0,0,126,0,0,0,162,0,0,0,169,0,0,0,172,0,0,0,172,0,0,0,174,0,0,0,177,0,0,0,180,0,0,0,180,0,0,0,182,0,0,0,182,0,0,0,184,0,0,0,184,0,0,0,215,0,0,0,215,0,0,0,247,0,0,0,247,0,0,0,194,2,0,0,197,2,0,0,210,2,0,0,223,2,0,0,229,2,0,0,237,2,0,0,239,2,0,0,255,2,0,0,116,3,0,0,117,3,0,0,132,3,0,0,133,3,0,0,246,3,0,0,246,3,0,0,130,4,0,0,130,4,0,0,11,6,0,0,11,6,0,0,14,6,0,0,15,6,0,0,233,6,0,0,233,6,0,0,253,6,0,0,254,6,0,0,242,9,0,0,243,9,0,0,250,9,0,0,250,9,0,0,241,10,0,0,241,10,0,0,112,11,0,0,112,11,0,0,243,11,0,0,250,11,0,0,63,14,0,0,63,14,0,0,1,15,0,0,3,15,0,0,19,15,0,0,23,15,0,0,26,15,0,0,31,15,0,0,52,15,0,0,52,15,0,0,54,15,0,0,54,15,0,0,56,15,0,0,56,15,0,0,190,15,0,0,197,15,0,0,199,15,0,0,204,15,0,0,207,15,0,0,207,15,0,0,96,19,0,0,96,19,0,0,144,19,0,0,153,19,0,0,219,23,0,0,219,23,0,0,64,25,0,0,64,25,0,0,224,25,0,0,255,25,0,0,189,31,0,0,189,31,0,0,191,31,0,0,193,31,0,0,205,31,0,0,207,31,0,0,221,31,0,0,223,31,0,0,237,31,0,0,239,31,0,0,253,31,0,0,254,31,0,0,68,32,0,0,68,32,0,0,82,32,0,0,82,32,0,0,122,32,0,0,124,32,0,0,138,32,0,0,140,32,0,0,160,32,0,0,181,32,0,0,0,33,0,0,1,33,0,0,3,33,0,0,6,33,0,0,8,33,0,0,9,33,0,0,20,33,0,0,20,33,0,0,22,33,0,0,24,33,0,0,30,33,0,0,35,33,0,0,37,33,0,0,37,33,0,0,39,33,0,0,39,33,0,0,41,33,0,0,41,33,0,0,46,33,0,0,46,33,0,0,50,33,0,0,50,33,0,0,58,33,0,0,59,33,0,0,64,33,0,0,68,33,0,0,74,33,0,0,76,33,0,0,144,33,0,0,40,35,0,0,43,35,0,0,179,35,0,0,183,35,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,156,36,0,0,233,36,0,0,0,37,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,103,39,0,0,148,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,192,39,0,0,196,39,0,0,208,39,0,0,229,39,0,0,240,39,0,0,130,41,0,0,153,41,0,0,215,41,0,0,220,41,0,0,251,41,0,0,254,41,0,0,19,43,0,0,229,44,0,0,234,44,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,240,47,0,0,251,47,0,0,4,48,0,0,4,48,0,0,18,48,0,0,19,48,0,0,32,48,0,0,32,48,0,0,54,48,0,0,55,48,0,0,62,48,0,0,63,48,0,0,155,48,0,0,156,48,0,0,144,49,0,0,145,49,0,0,150,49,0,0,159,49,0,0,192,49,0,0,207,49,0,0,0,50,0,0,30,50,0,0,42,50,0,0,67,50,0,0,80,50,0,0,80,50,0,0,96,50,0,0,127,50,0,0,138,50,0,0,176,50,0,0,192,50,0,0,254,50,0,0,0,51,0,0,255,51,0,0,192,77,0,0,255,77,0,0,144,164,0,0,198,164,0,0,0,167,0,0,22,167,0,0,40,168,0,0,43,168,0,0,41,251,0,0,41,251,0,0,252,253,0,0,253,253,0,0,98,254,0,0,98,254,0,0,100,254,0,0,102,254,0,0,105,254,0,0,105,254,0,0,4,255,0,0,4,255,0,0,11,255,0,0,11,255,0,0,28,255,0,0,30,255,0,0,62,255,0,0,62,255,0,0,64,255,0,0,64,255,0,0,92,255,0,0,92,255,0,0,94,255,0,0,94,255,0,0,224,255,0,0,230,255,0,0,232,255,0,0,238,255,0,0,252,255,0,0,253,255,0,0,2,1,1,0,2,1,1,0,55,1,1,0,63,1,1,0,121,1,1,0,137,1,1,0,208,3,1,0,208,3,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,100,209,1,0,106,209,1,0,108,209,1,0,131,209,1,0,132,209,1,0,140,209,1,0,169,209,1,0,174,209,1,0,221,209,1,0,0,210,1,0,65,210,1,0,69,210,1,0,69,210,1,0,0,211,1,0,86,211,1,0,193,214,1,0,193,214,1,0,219,214,1,0,219,214,1,0,251,214,1,0,251,214,1,0,21,215,1,0,21,215,1,0,53,215,1,0,53,215,1,0,79,215,1,0,79,215,1,0,111,215,1,0,111,215,1,0,137,215,1,0,137,215,1,0,169,215,1,0,169,215,1,0,195,215,1,0,195,215,1,0,14,0,0,0,36,0,0,0,36,0,0,0,162,0,0,0,165,0,0,0,11,6,0,0,11,6,0,0,242,9,0,0,243,9,0,0,241,10,0,0,241,10,0,0,249,11,0,0,249,11,0,0,63,14,0,0,63,14,0,0,219,23,0,0,219,23,0,0,160,32,0,0,181,32,0,0,252,253,0,0,252,253,0,0,105,254,0,0,105,254,0,0,4,255,0,0,4,255,0,0,224,255,0,0,225,255,0,0,229,255,0,0,230,255,0,0,23,0,0,0,94,0,0,0,94,0,0,0,96,0,0,0,96,0,0,0,168,0,0,0,168,0,0,0,175,0,0,0,175,0,0,0,180,0,0,0,180,0,0,0,184,0,0,0,184,0,0,0,194,2,0,0,197,2,0,0,210,2,0,0,223,2,0,0,229,2,0,0,237,2,0,0,239,2,0,0,255,2,0,0,116,3,0,0,117,3,0,0,132,3,0,0,133,3,0,0,189,31,0,0,189,31,0,0,191,31,0,0,193,31,0,0,205,31,0,0,207,31,0,0,221,31,0,0,223,31,0,0,237,31,0,0,239,31,0,0,253,31,0,0,254,31,0,0,155,48,0,0,156,48,0,0,0,167,0,0,22,167,0,0,62,255,0,0,62,255,0,0,64,255,0,0,64,255,0,0,227,255,0,0,227,255,0,0,59,0,0,0,43,0,0,0,43,0,0,0,60,0,0,0,62,0,0,0,124,0,0,0,124,0,0,0,126,0,0,0,126,0,0,0,172,0,0,0,172,0,0,0,177,0,0,0,177,0,0,0,215,0,0,0,215,0,0,0,247,0,0,0,247,0,0,0,246,3,0,0,246,3,0,0,68,32,0,0,68,32,0,0,82,32,0,0,82,32,0,0,122,32,0,0,124,32,0,0,138,32,0,0,140,32,0,0,64,33,0,0,68,33,0,0,75,33,0,0,75,33,0,0,144,33,0,0,148,33,0,0,154,33,0,0,155,33,0,0,160,33,0,0,160,33,0,0,163,33,0,0,163,33,0,0,166,33,0,0,166,33,0,0,174,33,0,0,174,33,0,0,206,33,0,0,207,33,0,0,210,33,0,0,210,33,0,0,212,33,0,0,212,33,0,0,244,33,0,0,255,34,0,0,8,35,0,0,11,35,0,0,32,35,0,0,33,35,0,0,124,35,0,0,124,35,0,0,155,35,0,0,179,35,0,0,183,37,0,0,183,37,0,0,193,37,0,0,193,37,0,0,248,37,0,0,255,37,0,0,111,38,0,0,111,38,0,0,192,39,0,0,196,39,0,0,208,39,0,0,229,39,0,0,240,39,0,0,255,39,0,0,0,41,0,0,130,41,0,0,153,41,0,0,215,41,0,0,220,41,0,0,251,41,0,0,254,41,0,0,255,42,0,0,41,251,0,0,41,251,0,0,98,254,0,0,98,254,0,0,100,254,0,0,102,254,0,0,11,255,0,0,11,255,0,0,28,255,0,0,30,255,0,0,92,255,0,0,92,255,0,0,94,255,0,0,94,255,0,0,226,255,0,0,226,255,0,0,233,255,0,0,236,255,0,0,193,214,1,0,193,214,1,0,219,214,1,0,219,214,1,0,251,214,1,0,251,214,1,0,21,215,1,0,21,215,1,0,53,215,1,0,53,215,1,0,79,215,1,0,79,215,1,0,111,215,1,0,111,215,1,0,137,215,1,0,137,215,1,0,169,215,1,0,169,215,1,0,195,215,1,0,195,215,1,0,120,0,0,0,166,0,0,0,167,0,0,0,169,0,0,0,169,0,0,0,174,0,0,0,174,0,0,0,176,0,0,0,176,0,0,0,182,0,0,0,182,0,0,0,130,4,0,0,130,4,0,0,14,6,0,0,15,6,0,0,233,6,0,0,233,6,0,0,253,6,0,0,254,6,0,0,250,9,0,0,250,9,0,0,112,11,0,0,112,11,0,0,243,11,0,0,248,11,0,0,250,11,0,0,250,11,0,0,1,15,0,0,3,15,0,0,19,15,0,0,23,15,0,0,26,15,0,0,31,15,0,0,52,15,0,0,52,15,0,0,54,15,0,0,54,15,0,0,56,15,0,0,56,15,0,0,190,15,0,0,197,15,0,0,199,15,0,0,204,15,0,0,207,15,0,0,207,15,0,0,96,19,0,0,96,19,0,0,144,19,0,0,153,19,0,0,64,25,0,0,64,25,0,0,224,25,0,0,255,25,0,0,0,33,0,0,1,33,0,0,3,33,0,0,6,33,0,0,8,33,0,0,9,33,0,0,20,33,0,0,20,33,0,0,22,33,0,0,24,33,0,0,30,33,0,0,35,33,0,0,37,33,0,0,37,33,0,0,39,33,0,0,39,33,0,0,41,33,0,0,41,33,0,0,46,33,0,0,46,33,0,0,50,33,0,0,50,33,0,0,58,33,0,0,59,33,0,0,74,33,0,0,74,33,0,0,76,33,0,0,76,33,0,0,149,33,0,0,153,33,0,0,156,33,0,0,159,33,0,0,161,33,0,0,162,33,0,0,164,33,0,0,165,33,0,0,167,33,0,0,173,33,0,0,175,33,0,0,205,33,0,0,208,33,0,0,209,33,0,0,211,33,0,0,211,33,0,0,213,33,0,0,243,33,0,0,0,35,0,0,7,35,0,0,12,35,0,0,31,35,0,0,34,35,0,0,40,35,0,0,43,35,0,0,123,35,0,0,125,35,0,0,154,35,0,0,183,35,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,156,36,0,0,233,36,0,0,0,37,0,0,182,37,0,0,184,37,0,0,192,37,0,0,194,37,0,0,247,37,0,0,0,38,0,0,110,38,0,0,112,38,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,103,39,0,0,148,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,0,40,0,0,255,40,0,0,0,43,0,0,19,43,0,0,229,44,0,0,234,44,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,240,47,0,0,251,47,0,0,4,48,0,0,4,48,0,0,18,48,0,0,19,48,0,0,32,48,0,0,32,48,0,0,54,48,0,0,55,48,0,0,62,48,0,0,63,48,0,0,144,49,0,0,145,49,0,0,150,49,0,0,159,49,0,0,192,49,0,0,207,49,0,0,0,50,0,0,30,50,0,0,42,50,0,0,67,50,0,0,80,50,0,0,80,50,0,0,96,50,0,0,127,50,0,0,138,50,0,0,176,50,0,0,192,50,0,0,254,50,0,0,0,51,0,0,255,51,0,0,192,77,0,0,255,77,0,0,144,164,0,0,198,164,0,0,40,168,0,0,43,168,0,0,253,253,0,0,253,253,0,0,228,255,0,0,228,255,0,0,232,255,0,0,232,255,0,0,237,255,0,0,238,255,0,0,252,255,0,0,253,255,0,0,2,1,1,0,2,1,1,0,55,1,1,0,63,1,1,0,121,1,1,0,137,1,1,0,208,3,1,0,208,3,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,100,209,1,0,106,209,1,0,108,209,1,0,131,209,1,0,132,209,1,0,140,209,1,0,169,209,1,0,174,209,1,0,221,209,1,0,0,210,1,0,65,210,1,0,69,210,1,0,69,210,1,0,0,211,1,0,86,211,1,0,9,0,0,0,32,0,0,0,32,0,0,0,160,0,0,0,160,0,0,0,128,22,0,0,128,22,0,0,14,24,0,0,14,24,0,0,0,32,0,0,10,32,0,0,40,32,0,0,41,32,0,0,47,32,0,0,47,32,0,0,95,32,0,0,95,32,0,0,0,48,0,0,0,48,0,0,1,0,0,0,40,32,0,0,40,32,0,0,1,0,0,0,41,32,0,0,41,32,0,0,8,0,0,0,32,0,0,0,32,0,0,0,160,0,0,0,160,0,0,0,128,22,0,0,128,22,0,0,14,24,0,0,14,24,0,0,0,32,0,0,10,32,0,0,47,32,0,0,47,32,0,0,95,32,0,0,95,32,0,0,0,48,0,0,0,48,0,0,17,0,0,0,11,6,0,0,11,6,0,0,13,6,0,0,21,6,0,0,30,6,0,0,30,6,0,0,33,6,0,0,58,6,0,0,65,6,0,0,74,6,0,0,86,6,0,0,94,6,0,0,106,6,0,0,111,6,0,0,113,6,0,0,220,6,0,0,222,6,0,0,255,6,0,0,80,7,0,0,109,7,0,0,80,251,0,0,177,251,0,0,211,251,0,0,61,253,0,0,80,253,0,0,143,253,0,0,146,253,0,0,199,253,0,0,240,253,0,0,252,253,0,0,112,254,0,0,116,254,0,0,118,254,0,0,252,254,0,0,5,0,0,0,49,5,0,0,86,5,0,0,89,5,0,0,95,5,0,0,97,5,0,0,135,5,0,0,138,5,0,0,138,5,0,0,19,251,0,0,23,251,0,0,14,0,0,0,129,9,0,0,131,9,0,0,133,9,0,0,140,9,0,0,143,9,0,0,144,9,0,0,147,9,0,0,168,9,0,0,170,9,0,0,176,9,0,0,178,9,0,0,178,9,0,0,182,9,0,0,185,9,0,0,188,9,0,0,196,9,0,0,199,9,0,0,200,9,0,0,203,9,0,0,206,9,0,0,215,9,0,0,215,9,0,0,220,9,0,0,221,9,0,0,223,9,0,0,227,9,0,0,230,9,0,0,250,9,0,0,2,0,0,0,5,49,0,0,44,49,0,0,160,49,0,0,183,49,0,0,1,0,0,0,0,40,0,0,255,40,0,0,2,0,0,0,0,26,0,0,27,26,0,0,30,26,0,0,31,26,0,0,1,0,0,0,64,23,0,0,83,23,0,0,1,0,0,0,1,20,0,0,118,22,0,0,1,0,0,0,160,19,0,0,244,19,0,0,126,0,0,0,0,0,0,0,64,0,0,0,91,0,0,0,96,0,0,0,123,0,0,0,169,0,0,0,171,0,0,0,185,0,0,0,187,0,0,0,191,0,0,0,215,0,0,0,215,0,0,0,247,0,0,0,247,0,0,0,185,2,0,0,223,2,0,0,229,2,0,0,255,2,0,0,126,3,0,0,126,3,0,0,135,3,0,0,135,3,0,0,137,5,0,0,137,5,0,0,0,6,0,0,3,6,0,0,12,6,0,0,12,6,0,0,27,6,0,0,27,6,0,0,31,6,0,0,31,6,0,0,64,6,0,0,64,6,0,0,96,6,0,0,105,6,0,0,221,6,0,0,221,6,0,0,100,9,0,0,101,9,0,0,112,9,0,0,112,9,0,0,63,14,0,0,63,14,0,0,251,16,0,0,251,16,0,0,235,22,0,0,237,22,0,0,53,23,0,0,54,23,0,0,0,32,0,0,11,32,0,0,14,32,0,0,99,32,0,0,106,32,0,0,112,32,0,0,116,32,0,0,126,32,0,0,128,32,0,0,142,32,0,0,160,32,0,0,181,32,0,0,0,33,0,0,37,33,0,0,39,33,0,0,41,33,0,0,44,33,0,0,76,33,0,0,83,33,0,0,131,33,0,0,144,33,0,0,219,35,0,0,0,36,0,0,38,36,0,0,64,36,0,0,74,36,0,0,96,36,0,0,156,38,0,0,160,38,0,0,177,38,0,0,1,39,0,0,4,39,0,0,6,39,0,0,9,39,0,0,12,39,0,0,39,39,0,0,41,39,0,0,75,39,0,0,77,39,0,0,77,39,0,0,79,39,0,0,82,39,0,0,86,39,0,0,86,39,0,0,88,39,0,0,94,39,0,0,97,39,0,0,148,39,0,0,152,39,0,0,175,39,0,0,177,39,0,0,190,39,0,0,192,39,0,0,198,39,0,0,208,39,0,0,235,39,0,0,240,39,0,0,255,39,0,0,0,41,0,0,19,43,0,0,0,46,0,0,23,46,0,0,28,46,0,0,29,46,0,0,240,47,0,0,251,47,0,0,0,48,0,0,4,48,0,0,6,48,0,0,6,48,0,0,8,48,0,0,32,48,0,0,48,48,0,0,55,48,0,0,60,48,0,0,63,48,0,0,155,48,0,0,156,48,0,0,160,48,0,0,160,48,0,0,251,48,0,0,252,48,0,0,144,49,0,0,159,49,0,0,192,49,0,0,207,49,0,0,32,50,0,0,67,50,0,0,80,50,0,0,95,50,0,0,126,50,0,0,254,50,0,0,0,51,0,0,255,51,0,0,192,77,0,0,255,77,0,0,0,167,0,0,22,167,0,0,0,224,0,0,255,248,0,0,62,253,0,0,63,253,0,0,253,253,0,0,253,253,0,0,16,254,0,0,25,254,0,0,48,254,0,0,82,254,0,0,84,254,0,0,102,254,0,0,104,254,0,0,107,254,0,0,255,254,0,0,255,254,0,0,1,255,0,0,32,255,0,0,59,255,0,0,64,255,0,0,91,255,0,0,101,255,0,0,112,255,0,0,112,255,0,0,158,255,0,0,159,255,0,0,224,255,0,0,230,255,0,0,232,255,0,0,238,255,0,0,249,255,0,0,253,255,0,0,0,1,1,0,2,1,1,0,7,1,1,0,51,1,1,0,55,1,1,0,63,1,1,0,0,208,1,0,245,208,1,0,0,209,1,0,38,209,1,0,42,209,1,0,102,209,1,0,106,209,1,0,122,209,1,0,131,209,1,0,132,209,1,0,140,209,1,0,169,209,1,0,174,209,1,0,221,209,1,0,0,211,1,0,86,211,1,0,0,212,1,0,84,212,1,0,86,212,1,0,156,212,1,0,158,212,1,0,159,212,1,0,162,212,1,0,162,212,1,0,165,212,1,0,166,212,1,0,169,212,1,0,172,212,1,0,174,212,1,0,185,212,1,0,187,212,1,0,187,212,1,0,189,212,1,0,195,212,1,0,197,212,1,0,5,213,1,0,7,213,1,0,10,213,1,0,13,213,1,0,20,213,1,0,22,213,1,0,28,213,1,0,30,213,1,0,57,213,1,0,59,213,1,0,62,213,1,0,64,213,1,0,68,213,1,0,70,213,1,0,70,213,1,0,74,213,1,0,80,213,1,0,82,213,1,0,165,214,1,0,168,214,1,0,201,215,1,0,206,215,1,0,255,215,1,0,1,0,14,0,1,0,14,0,32,0,14,0,127,0,14,0,0,0,15,0,253,255,15,0,0,0,16,0,253,255,16,0,3,0,0,0,226,3,0,0,239,3,0,0,128,44,0,0,234,44,0,0,249,44,0,0,255,44,0,0,6,0,0,0,0,8,1,0,5,8,1,0,8,8,1,0,8,8,1,0,10,8,1,0,53,8,1,0,55,8,1,0,56,8,1,0,60,8,1,0,60,8,1,0,63,8,1,0,63,8,1,0,6,0,0,0,0,4,0,0,134,4,0,0,136,4,0,0,206,4,0,0,208,4,0,0,249,4,0,0,0,5,0,0,15,5,0,0,43,29,0,0,43,29,0,0,120,29,0,0,120,29,0,0,1,0,0,0,0,4,1,0,79,4,1,0,6,0,0,0,1,9,0,0,57,9,0,0,60,9,0,0,77,9,0,0,80,9,0,0,84,9,0,0,88,9,0,0,99,9,0,0,102,9,0,0,111,9,0,0,125,9,0,0,125,9,0,0,27,0,0,0,0,18,0,0,72,18,0,0,74,18,0,0,77,18,0,0,80,18,0,0,86,18,0,0,88,18,0,0,88,18,0,0,90,18,0,0,93,18,0,0,96,18,0,0,136,18,0,0,138,18,0,0,141,18,0,0,144,18,0,0,176,18,0,0,178,18,0,0,181,18,0,0,184,18,0,0,190,18,0,0,192,18,0,0,192,18,0,0,194,18,0,0,197,18,0,0,200,18,0,0,214,18,0,0,216,18,0,0,16,19,0,0,18,19,0,0,21,19,0,0,24,19,0,0,90,19,0,0,95,19,0,0,124,19,0,0,128,19,0,0,153,19,0,0,128,45,0,0,150,45,0,0,160,45,0,0,166,45,0,0,168,45,0,0,174,45,0,0,176,45,0,0,182,45,0,0,184,45,0,0,190,45,0,0,192,45,0,0,198,45,0,0,200,45,0,0,206,45,0,0,208,45,0,0,214,45,0,0,216,45,0,0,222,45,0,0,4,0,0,0,160,16,0,0,197,16,0,0,208,16,0,0,250,16,0,0,252,16,0,0,252,16,0,0,0,45,0,0,37,45,0,0,2,0,0,0,0,44,0,0,46,44,0,0,48,44,0,0,94,44,0,0,1,0,0,0,48,3,1,0,74,3,1,0,31,0,0,0,116,3,0,0,117,3,0,0,122,3,0,0,122,3,0,0,132,3,0,0,134,3,0,0,136,3,0,0,138,3,0,0,140,3,0,0,140,3,0,0,142,3,0,0,161,3,0,0,163,3,0,0,206,3,0,0,208,3,0,0,225,3,0,0,240,3,0,0,255,3,0,0,38,29,0,0,42,29,0,0,93,29,0,0,97,29,0,0,102,29,0,0,106,29,0,0,0,31,0,0,21,31,0,0,24,31,0,0,29,31,0,0,32,31,0,0,69,31,0,0,72,31,0,0,77,31], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+427396);
/* memory initializer */ allocate([80,31,0,0,87,31,0,0,89,31,0,0,89,31,0,0,91,31,0,0,91,31,0,0,93,31,0,0,93,31,0,0,95,31,0,0,125,31,0,0,128,31,0,0,180,31,0,0,182,31,0,0,196,31,0,0,198,31,0,0,211,31,0,0,214,31,0,0,219,31,0,0,221,31,0,0,239,31,0,0,242,31,0,0,244,31,0,0,246,31,0,0,254,31,0,0,38,33,0,0,38,33,0,0,64,1,1,0,138,1,1,0,0,210,1,0,69,210,1,0,14,0,0,0,129,10,0,0,131,10,0,0,133,10,0,0,141,10,0,0,143,10,0,0,145,10,0,0,147,10,0,0,168,10,0,0,170,10,0,0,176,10,0,0,178,10,0,0,179,10,0,0,181,10,0,0,185,10,0,0,188,10,0,0,197,10,0,0,199,10,0,0,201,10,0,0,203,10,0,0,205,10,0,0,208,10,0,0,208,10,0,0,224,10,0,0,227,10,0,0,230,10,0,0,239,10,0,0,241,10,0,0,241,10,0,0,15,0,0,0,1,10,0,0,3,10,0,0,5,10,0,0,10,10,0,0,15,10,0,0,16,10,0,0,19,10,0,0,40,10,0,0,42,10,0,0,48,10,0,0,50,10,0,0,51,10,0,0,53,10,0,0,54,10,0,0,56,10,0,0,57,10,0,0,60,10,0,0,60,10,0,0,62,10,0,0,66,10,0,0,71,10,0,0,72,10,0,0,75,10,0,0,77,10,0,0,89,10,0,0,92,10,0,0,94,10,0,0,94,10,0,0,102,10,0,0,116,10,0,0,14,0,0,0,128,46,0,0,153,46,0,0,155,46,0,0,243,46,0,0,0,47,0,0,213,47,0,0,5,48,0,0,5,48,0,0,7,48,0,0,7,48,0,0,33,48,0,0,41,48,0,0,56,48,0,0,59,48,0,0,0,52,0,0,181,77,0,0,0,78,0,0,187,159,0,0,0,249,0,0,45,250,0,0,48,250,0,0,106,250,0,0,112,250,0,0,217,250,0,0,0,0,2,0,214,166,2,0,0,248,2,0,29,250,2,0,12,0,0,0,0,17,0,0,89,17,0,0,95,17,0,0,162,17,0,0,168,17,0,0,249,17,0,0,49,49,0,0,142,49,0,0,0,50,0,0,30,50,0,0,96,50,0,0,125,50,0,0,0,172,0,0,163,215,0,0,160,255,0,0,190,255,0,0,194,255,0,0,199,255,0,0,202,255,0,0,207,255,0,0,210,255,0,0,215,255,0,0,218,255,0,0,220,255,0,0,1,0,0,0,32,23,0,0,52,23,0,0,10,0,0,0,145,5,0,0,185,5,0,0,187,5,0,0,199,5,0,0,208,5,0,0,234,5,0,0,240,5,0,0,244,5,0,0,29,251,0,0,54,251,0,0,56,251,0,0,60,251,0,0,62,251,0,0,62,251,0,0,64,251,0,0,65,251,0,0,67,251,0,0,68,251,0,0,70,251,0,0,79,251,0,0,2,0,0,0,65,48,0,0,150,48,0,0,157,48,0,0,159,48,0,0,15,0,0,0,0,3,0,0,111,3,0,0,75,6,0,0,85,6,0,0,112,6,0,0,112,6,0,0,192,29,0,0,195,29,0,0,12,32,0,0,13,32,0,0,208,32,0,0,235,32,0,0,42,48,0,0,47,48,0,0,153,48,0,0,154,48,0,0,0,254,0,0,15,254,0,0,32,254,0,0,35,254,0,0,103,209,1,0,105,209,1,0,123,209,1,0,130,209,1,0,133,209,1,0,139,209,1,0,170,209,1,0,173,209,1,0,0,1,14,0,239,1,14,0,13,0,0,0,130,12,0,0,131,12,0,0,133,12,0,0,140,12,0,0,142,12,0,0,144,12,0,0,146,12,0,0,168,12,0,0,170,12,0,0,179,12,0,0,181,12,0,0,185,12,0,0,188,12,0,0,196,12,0,0,198,12,0,0,200,12,0,0,202,12,0,0,205,12,0,0,213,12,0,0,214,12,0,0,222,12,0,0,222,12,0,0,224,12,0,0,225,12,0,0,230,12,0,0,239,12,0,0,5,0,0,0,161,48,0,0,250,48,0,0,253,48,0,0,255,48,0,0,240,49,0,0,255,49,0,0,102,255,0,0,111,255,0,0,113,255,0,0,157,255,0,0,8,0,0,0,0,10,1,0,3,10,1,0,5,10,1,0,6,10,1,0,12,10,1,0,19,10,1,0,21,10,1,0,23,10,1,0,25,10,1,0,51,10,1,0,56,10,1,0,58,10,1,0,63,10,1,0,71,10,1,0,80,10,1,0,88,10,1,0,4,0,0,0,128,23,0,0,221,23,0,0,224,23,0,0,233,23,0,0,240,23,0,0,249,23,0,0,224,25,0,0,255,25,0,0,18,0,0,0,129,14,0,0,130,14,0,0,132,14,0,0,132,14,0,0,135,14,0,0,136,14,0,0,138,14,0,0,138,14,0,0,141,14,0,0,141,14,0,0,148,14,0,0,151,14,0,0,153,14,0,0,159,14,0,0,161,14,0,0,163,14,0,0,165,14,0,0,165,14,0,0,167,14,0,0,167,14,0,0,170,14,0,0,171,14,0,0,173,14,0,0,185,14,0,0,187,14,0,0,189,14,0,0,192,14,0,0,196,14,0,0,198,14,0,0,198,14,0,0,200,14,0,0,205,14,0,0,208,14,0,0,217,14,0,0,220,14,0,0,221,14,0,0,23,0,0,0,65,0,0,0,90,0,0,0,97,0,0,0,122,0,0,0,170,0,0,0,170,0,0,0,186,0,0,0,186,0,0,0,192,0,0,0,214,0,0,0,216,0,0,0,246,0,0,0,248,0,0,0,65,2,0,0,80,2,0,0,184,2,0,0,224,2,0,0,228,2,0,0,0,29,0,0,37,29,0,0,44,29,0,0,92,29,0,0,98,29,0,0,101,29,0,0,107,29,0,0,119,29,0,0,121,29,0,0,191,29,0,0,0,30,0,0,155,30,0,0,160,30,0,0,249,30,0,0,113,32,0,0,113,32,0,0,127,32,0,0,127,32,0,0,144,32,0,0,148,32,0,0,42,33,0,0,43,33,0,0,0,251,0,0,6,251,0,0,33,255,0,0,58,255,0,0,65,255,0,0,90,255,0,0,5,0,0,0,0,25,0,0,28,25,0,0,32,25,0,0,43,25,0,0,48,25,0,0,59,25,0,0,64,25,0,0,64,25,0,0,68,25,0,0,79,25,0,0,7,0,0,0,0,0,1,0,11,0,1,0,13,0,1,0,38,0,1,0,40,0,1,0,58,0,1,0,60,0,1,0,61,0,1,0,63,0,1,0,77,0,1,0,80,0,1,0,93,0,1,0,128,0,1,0,250,0,1,0,11,0,0,0,2,13,0,0,3,13,0,0,5,13,0,0,12,13,0,0,14,13,0,0,16,13,0,0,18,13,0,0,40,13,0,0,42,13,0,0,57,13,0,0,62,13,0,0,67,13,0,0,70,13,0,0,72,13,0,0,74,13,0,0,77,13,0,0,87,13,0,0,87,13,0,0,96,13,0,0,97,13,0,0,102,13,0,0,111,13,0,0,4,0,0,0,0,24,0,0,14,24,0,0,16,24,0,0,25,24,0,0,32,24,0,0,119,24,0,0,128,24,0,0,169,24,0,0,6,0,0,0,0,16,0,0,33,16,0,0,35,16,0,0,39,16,0,0,41,16,0,0,42,16,0,0,44,16,0,0,50,16,0,0,54,16,0,0,57,16,0,0,64,16,0,0,89,16,0,0,4,0,0,0,128,25,0,0,169,25,0,0,176,25,0,0,201,25,0,0,208,25,0,0,217,25,0,0,222,25,0,0,223,25,0,0,1,0,0,0,128,22,0,0,156,22,0,0,2,0,0,0,0,3,1,0,30,3,1,0,32,3,1,0,35,3,1,0,2,0,0,0,160,3,1,0,195,3,1,0,200,3,1,0,213,3,1,0,14,0,0,0,1,11,0,0,3,11,0,0,5,11,0,0,12,11,0,0,15,11,0,0,16,11,0,0,19,11,0,0,40,11,0,0,42,11,0,0,48,11,0,0,50,11,0,0,51,11,0,0,53,11,0,0,57,11,0,0,60,11,0,0,67,11,0,0,71,11,0,0,72,11,0,0,75,11,0,0,77,11,0,0,86,11,0,0,87,11,0,0,92,11,0,0,93,11,0,0,95,11,0,0,97,11,0,0,102,11,0,0,113,11,0,0,2,0,0,0,128,4,1,0,157,4,1,0,160,4,1,0,169,4,1,0,2,0,0,0,160,22,0,0,234,22,0,0,238,22,0,0,240,22,0,0,1,0,0,0,80,4,1,0,127,4,1,0,11,0,0,0,130,13,0,0,131,13,0,0,133,13,0,0,150,13,0,0,154,13,0,0,177,13,0,0,179,13,0,0,187,13,0,0,189,13,0,0,189,13,0,0,192,13,0,0,198,13,0,0,202,13,0,0,202,13,0,0,207,13,0,0,212,13,0,0,214,13,0,0,214,13,0,0,216,13,0,0,223,13,0,0,242,13,0,0,244,13,0,0,1,0,0,0,0,168,0,0,43,168,0,0,3,0,0,0,0,7,0,0,13,7,0,0,15,7,0,0,74,7,0,0,77,7,0,0,79,7,0,0,2,0,0,0,0,23,0,0,12,23,0,0,14,23,0,0,20,23,0,0,3,0,0,0,96,23,0,0,108,23,0,0,110,23,0,0,112,23,0,0,114,23,0,0,115,23,0,0,2,0,0,0,80,25,0,0,109,25,0,0,112,25,0,0,116,25,0,0,15,0,0,0,130,11,0,0,131,11,0,0,133,11,0,0,138,11,0,0,142,11,0,0,144,11,0,0,146,11,0,0,149,11,0,0,153,11,0,0,154,11,0,0,156,11,0,0,156,11,0,0,158,11,0,0,159,11,0,0,163,11,0,0,164,11,0,0,168,11,0,0,170,11,0,0,174,11,0,0,185,11,0,0,190,11,0,0,194,11,0,0,198,11,0,0,200,11,0,0,202,11,0,0,205,11,0,0,215,11,0,0,215,11,0,0,230,11,0,0,250,11,0,0,12,0,0,0,1,12,0,0,3,12,0,0,5,12,0,0,12,12,0,0,14,12,0,0,16,12,0,0,18,12,0,0,40,12,0,0,42,12,0,0,51,12,0,0,53,12,0,0,57,12,0,0,62,12,0,0,68,12,0,0,70,12,0,0,72,12,0,0,74,12,0,0,77,12,0,0,85,12,0,0,86,12,0,0,96,12,0,0,97,12,0,0,102,12,0,0,111,12,0,0,1,0,0,0,128,7,0,0,177,7,0,0,2,0,0,0,1,14,0,0,58,14,0,0,64,14,0,0,91,14,0,0,7,0,0,0,0,15,0,0,71,15,0,0,73,15,0,0,106,15,0,0,113,15,0,0,139,15,0,0,144,15,0,0,151,15,0,0,153,15,0,0,188,15,0,0,190,15,0,0,204,15,0,0,207,15,0,0,209,15,0,0,2,0,0,0,48,45,0,0,101,45,0,0,111,45,0,0,111,45,0,0,2,0,0,0,128,3,1,0,157,3,1,0,159,3,1,0,159,3,1,0,2,0,0,0,0,160,0,0,140,164,0,0,144,164,0,0,198,164,0,0,25,0,0,0,11,220,6,0,4,0,0,0,2,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,38,0,0,0,20,220,6,0,4,0,0,0,2,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,31,0,0,0,44,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,45,0,0,0,37,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,192,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,49,0,0,0,149,227,6,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,67,0,84,0,32,0,39,0,0,0,39,0,0,0,39,0,39,0,0,0,39,0,44,0,39,0,0,0,39,0,58,0,0,0,13,0,10,0,69,0,78,0,68,0,0,0,32,0,95,0,0,0,81,0,83,0,80,0,71,0,65,0,77,0,69,0,0,0,114,0,98,0,0,0,79,0,78,0,71,0,83,0,65,0,86,0,69,0,0,0,81,0,83,0,80,0,83,0,65,0,86,0,69,0,68,0,71,0,65,0,77,0,69,0,0,0,119,0,98,0,0,0,79,0,78,0,71,0,76,0,79,0,65,0,68,0,0,0,68,0,69,0,66,0,85,0,71,0,0,0,77,0,79,0,68,0,0,0,60,0,62,0,0,0,60,0,61,0,0,0,61,0,60,0,0,0,62,0,61,0,0,0,61,0,62,0,0,0,60,0,0,0,62,0,0,0,65,0,78,0,68,0,0,0,79,0,82,0,0,0,76,0,79,0,67,0,0,0,79,0,66,0,74,0,0,0,78,0,79,0,0,0,77,0,73,0,78,0,0,0,36,0,77,0,73,0,78,0,0,0,77,0,65,0,88,0,0,0,36,0,77,0,65,0,88,0,0,0,82,0,65,0,78,0,68,0,0,0,73,0,73,0,70,0,0,0,36,0,73,0,73,0,70,0,0,0,82,0,71,0,66,0,0,0,76,0,69,0,78,0,0,0,73,0,83,0,78,0,85,0,77,0,0,0,76,0,67,0,65,0,83,0,69,0,0,0,36,0,76,0,67,0,65,0,83,0,69,0,0,0,85,0,67,0,65,0,83,0,69,0,0,0,36,0,85,0,67,0,65,0,83,0,69,0,0,0,73,0,78,0,80,0,85,0,84,0,0,0,36,0,73,0,78,0,80,0,85,0,84,0,0,0,83,0,84,0,82,0,0,0,36,0,83,0,84,0,82,0,0,0,86,0,65,0,76,0,0,0,65,0,82,0,82,0,83,0,73,0,90,0,69,0,0,0,73,0,83,0,80,0,76,0,65,0,89,0,0,0,68,0,69,0,83,0,67,0,0,0,36,0,68,0,69,0,83,0,67,0,0,0,84,0,82,0,73,0,77,0,0,0,36,0,84,0,82,0,73,0,77,0,0,0,71,0,69,0,84,0,79,0,66,0,74,0,0,0,36,0,71,0,69,0,84,0,79,0,66,0,74,0,0,0,83,0,84,0,82,0,67,0,79,0,77,0,80,0,0,0,83,0,84,0,82,0,70,0,73,0,78,0,68,0,0,0,36,0,83,0,84,0,82,0,70,0,73,0,78,0,68,0,0,0,83,0,84,0,82,0,80,0,79,0,83,0,0,0,77,0,73,0,68,0,0,0,36,0,77,0,73,0,68,0,0,0,65,0,82,0,82,0,80,0,79,0,83,0,0,0,65,0,82,0,82,0,67,0,79,0,77,0,80,0,0,0,73,0,78,0,83,0,84,0,82,0,0,0,82,0,69,0,80,0,76,0,65,0,67,0,69,0,0,0,36,0,82,0,69,0,80,0,76,0,65,0,67,0,69,0,0,0,70,0,85,0,78,0,67,0,0,0,36,0,70,0,85,0,78,0,67,0,0,0,68,0,89,0,78,0,69,0,86,0,65,0,76,0,0,0,36,0,68,0,89,0,78,0,69,0,86,0,65,0,76,0,0,0,82,0,78,0,68,0,0,0,67,0,79,0,85,0,78,0,84,0,79,0,66,0,74,0,0,0,77,0,83,0,69,0,67,0,83,0,67,0,79,0,85,0,78,0,84,0,0,0,81,0,83,0,80,0,86,0,69,0,82,0,0,0,36,0,81,0,83,0,80,0,86,0,69,0,82,0,0,0,85,0,83,0,69,0,82,0,95,0,84,0,69,0,88,0,84,0,0,0,36,0,85,0,83,0,69,0,82,0,95,0,84,0,69,0,88,0,84,0,0,0,85,0,83,0,82,0,84,0,88,0,84,0,0,0,36,0,85,0,83,0,82,0,84,0,88,0,84,0,0,0,67,0,85,0,82,0,76,0,79,0,67,0,0,0,36,0,67,0,85,0,82,0,76,0,79,0,67,0,0,0,83,0,69,0,76,0,79,0,66,0,74,0,0,0,36,0,83,0,69,0,76,0,79,0,66,0,74,0,0,0,83,0,69,0,76,0,65,0,67,0,84,0,0,0,36,0,83,0,69,0,76,0,65,0,67,0,84,0,0,0,77,0,65,0,73,0,78,0,84,0,88,0,84,0,0,0,36,0,77,0,65,0,73,0,78,0,84,0,88,0,84,0,0,0,83,0,84,0,65,0,84,0,84,0,88,0,84,0,0,0,36,0,83,0,84,0,65,0,84,0,84,0,88,0,84,0,0,0,67,0,85,0,82,0,65,0,67,0,84,0,83,0,0,0,36,0,67,0,85,0,82,0,65,0,67,0,84,0,83,0,0,0,71,0,69,0,84,0,80,0,76,0,65,0,89,0,69,0,82,0,0,0,36,0,71,0,69,0,84,0,80,0,76,0,65,0,89,0,69,0,82,0,0,0,124,0,0,0,32,0,9,0,39,0,34,0,123,0,40,0,0,0,82,0,69,0,83,0,85,0,76,0,84,0,0,0,42,0,0,0,32,0,9,0,0,0,39,0,34,0,123,0,40,0,91,0,0,0,39,0,34,0,0,0,123,0,0,0,125,0,0,0,68,0,73,0,83,0,65,0,66,0,76,0,69,0,83,0,85,0,66,0,69,0,88,0,0,0,60,0,60,0,0,0,62,0,62,0,0,0,43,0,45,0,47,0,42,0,0,0,43,0,0,0,45,0,47,0,42,0,0,0,45,0,0,0,47,0,0,0,93,0,0,0,68,0,105,0,118,0,105,0,115,0,105,0,111,0,110,0,32,0,98,0,121,0,32,0,122,0,101,0,114,0,111,0,33,0,0,0,84,0,121,0,112,0,101,0,32,0,109,0,105,0,115,0,109,0,97,0,116,0,99,0,104,0,33,0,0,0,83,0,116,0,97,0,99,0,107,0,32,0,111,0,118,0,101,0,114,0,102,0,108,0,111,0,119,0,33,0,0,0,84,0,111,0,111,0,32,0,109,0,97,0,110,0,121,0,32,0,105,0,116,0,101,0,109,0,115,0,32,0,105,0,110,0,32,0,101,0,120,0,112,0,114,0,101,0,115,0,115,0,105,0,111,0,110,0,33,0,0,0,70,0,105,0,108,0,101,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,67,0,97,0,110,0,39,0,116,0,32,0,108,0,111,0,97,0,100,0,32,0,102,0,105,0,108,0,101,0,33,0,0,0,71,0,97,0,109,0,101,0,32,0,110,0,111,0,116,0,32,0,108,0,111,0,97,0,100,0,101,0,100,0,33,0,0,0,83,0,105,0,103,0,110,0,32,0,91,0,58,0,93,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,67,0,97,0,110,0,39,0,116,0,32,0,97,0,100,0,100,0,32,0,102,0,105,0,108,0,101,0,33,0,0,0,67,0,97,0,110,0,39,0,116,0,32,0,97,0,100,0,100,0,32,0,97,0,99,0,116,0,105,0,111,0,110,0,33,0,0,0,83,0,105,0,103,0,110,0,32,0,91,0,61,0,93,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,76,0,111,0,99,0,97,0,116,0,105,0,111,0,110,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,91,0,101,0,110,0,100,0,93,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,76,0,97,0,98,0,101,0,108,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,73,0,110,0,99,0,111,0,114,0,114,0,101,0,99,0,116,0,32,0,118,0,97,0,114,0,105,0,97,0,98,0,108,0,101,0,39,0,115,0,32,0,110,0,97,0,109,0,101,0,33,0,0,0,81,0,117,0,111,0,116,0,101,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,66,0,114,0,97,0,99,0,107,0,101,0,116,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,66,0,114,0,97,0,99,0,107,0,101,0,116,0,115,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,83,0,121,0,110,0,116,0,97,0,120,0,32,0,101,0,114,0,114,0,111,0,114,0,33,0,0,0,85,0,110,0,107,0,110,0,111,0,119,0,110,0,32,0,97,0,99,0,116,0,105,0,111,0,110,0,33,0,0,0,73,0,110,0,99,0,111,0,114,0,114,0,101,0,99,0,116,0,32,0,97,0,114,0,103,0,117,0,109,0,101,0,110,0,116,0,115,0,39,0,32,0,99,0,111,0,117,0,110,0,116,0,33,0,0,0,67,0,97,0,110,0,39,0,116,0,32,0,97,0,100,0,100,0,32,0,111,0,98,0,106,0,101,0,99,0,116,0,33,0,0,0,67,0,97,0,110,0,39,0,116,0,32,0,97,0,100,0,100,0,32,0,109,0,101,0,110,0,117,0,39,0,115,0,32,0,105,0,116,0,101,0,109,0,33,0,0,0,84,0,111,0,111,0,32,0,109,0,97,0,110,0,121,0,32,0,118,0,97,0,114,0,105,0,97,0,98,0,108,0,101,0,115,0,33,0,0,0,82,0,101,0,103,0,117,0,108,0,97,0,114,0,32,0,101,0,120,0,112,0,114,0,101,0,115,0,115,0,105,0,111,0,110,0,39,0,115,0,32,0,101,0,114,0,114,0,111,0,114,0,33,0,0,0,67,0,111,0,100,0,101,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,91,0,116,0,111,0,93,0,32,0,110,0,111,0,116,0,32,0,102,0,111,0,117,0,110,0,100,0,33,0,0,0,85,0,110,0,107,0,110,0,111,0,119,0,110,0,32,0,101,0,114,0,114,0,111,0,114,0,33,0,0,0,79,0,78,0,78,0,69,0,87,0,76,0,79,0,67,0,0,0,79,0,78,0,79,0,66,0,74,0,68,0,69,0,76,0,0,0,79,0,78,0,79,0,66,0,74,0,65,0,68,0,68,0,0,0,69,0,76,0,83,0,69,0,0,0,69,0,76,0,83,0,69,0,73,0,70,0,0,0,69,0,78,0,68,0,0,0,76,0,79,0,67,0,65,0,76,0,0,0,83,0,69,0,84,0,0,0,76,0,69,0,84,0,0,0,73,0,70,0,0,0,65,0,67,0,84,0,0,0,70,0,79,0,82,0,0,0,65,0,68,0,68,0,79,0,66,0,74,0,0,0,65,0,68,0,68,0,32,0,79,0,66,0,74,0,0,0,67,0,76,0,65,0,0,0,67,0,76,0,79,0,83,0,69,0,32,0,65,0,76,0,76,0,0,0,67,0,76,0,79,0,83,0,69,0,0,0,67,0,76,0,83,0,0,0,67,0,77,0,68,0,67,0,76,0,69,0,65,0,82,0,0,0,67,0,77,0,68,0,67,0,76,0,82,0,0,0,67,0,79,0,80,0,89,0,65,0,82,0,82,0,0,0,68,0,69,0,76,0,65,0,67,0,84,0,0,0,68,0,69,0,76,0,32,0,65,0,67,0,84,0,0,0,68,0,69,0,76,0,79,0,66,0,74,0,0,0,68,0,69,0,76,0,32,0,79,0,66,0,74,0,0,0,68,0,89,0,78,0,65,0,77,0,73,0,67,0,0,0,69,0,88,0,69,0,67,0,0,0,69,0,88,0,73,0,84,0,0,0,70,0,82,0,69,0,69,0,76,0,73,0,66,0,0,0,71,0,79,0,83,0,85,0,66,0,0,0,71,0,83,0,0,0,71,0,79,0,84,0,79,0,0,0,71,0,84,0,0,0,73,0,78,0,67,0,76,0,73,0,66,0,0,0,74,0,85,0,77,0,80,0,0,0,75,0,73,0,76,0,76,0,65,0,76,0,76,0,0,0,75,0,73,0,76,0,76,0,79,0,66,0,74,0,0,0,75,0,73,0,76,0,76,0,86,0,65,0,82,0,0,0,77,0,69,0,78,0,85,0,0,0,42,0,67,0,76,0,69,0,65,0,82,0,0,0,42,0,67,0,76,0,82,0,0,0,42,0,78,0,76,0,0,0,42,0,80,0,76,0,0,0,42,0,80,0,0,0,67,0,76,0,69,0,65,0,82,0,0,0,67,0,76,0,82,0,0,0,78,0,76,0,0,0,80,0,76,0,0,0,80,0,0,0,77,0,83,0,71,0,0,0,79,0,80,0,69,0,78,0,71,0,65,0,77,0,69,0,0,0,79,0,80,0,69,0,78,0,81,0,83,0,84,0,0,0,80,0,76,0,65,0,89,0,0,0,82,0,69,0,70,0,73,0,78,0,84,0,0,0,83,0,65,0,86,0,69,0,71,0,65,0,77,0,69,0,0,0,83,0,69,0,84,0,84,0,73,0,77,0,69,0,82,0,0,0,83,0,72,0,79,0,87,0,65,0,67,0,84,0,83,0,0,0,83,0,72,0,79,0,87,0,73,0,78,0,80,0,85,0,84,0,0,0,83,0,72,0,79,0,87,0,79,0,66,0,74,0,83,0,0,0,83,0,72,0,79,0,87,0,83,0,84,0,65,0,84,0,0,0,85,0,78,0,83,0,69,0,76,0,69,0,67,0,84,0,0,0,85,0,78,0,83,0,69,0,76,0,0,0,86,0,73,0,69,0,87,0,0,0,87,0,65,0,73,0,84,0,0,0,88,0,71,0,79,0,84,0,79,0,0,0,88,0,71,0,84,0,0,0,40,0,0,0,41,0,0,0,44,0,0,0,65,0,82,0,71,0,83,0,0,0,58,0,0,0,38,0,0,0,61,0,0,0,33,0,0,0,32,0,9,0,38,0,39,0,34,0,40,0,41,0,91,0,93,0,61,0,33,0,60,0,62,0,43,0,45,0,47,0,42,0,58,0,44,0,123,0,125,0,0,0,36,0,0,0,83,0,84,0,69,0,80,0,0,0,91,0,0,0,84,0,79,0,0,0,13,0,10,0,0,0,232,3,244,1,77,1,250,0,200,0,167,0,143,0,125,0,111,0,100,0,91,0,83,0,77,0,71,0,67,0,63,0,59,0,56,0,53,0,50,0,48,0,45,0,43,0,42,0,40,0,38,0,37,0,36,0,34,0,33,0,32,0,31,0,30,0,29,0,29,0,28,0,27,0,26,0,26,0,25,0,24,0,24,0,23,0,23,0,22,0,22,0,21,0,21,0,20,0,20,0,20,0,19,0,19,0,19,0,18,0,18,0,18,0,17,0,17,0,17,0,16,0,16,0,16,0,16,0,15,0,15,0,15,0,15,0,14,0,14,0,14,0,14,0,14,0,14,0,13,0,13,0,13,0,13,0,13,0,13,0,12,0,12,0,12,0,12,0,12,0,12,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,10,0,10,0,10,0,10,0,10,0,5,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,10,0,10,0,1,0,1,0,10,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,12,0,4,0,7,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,6,0,6,0,6,0,6,0,7,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,5,0,6,0,5,0,5,0,5,0,5,0,6,0,6,0,6,0,6,0,7,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,5,0,5,0,5,0,5,0,1,0,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,12,66,9,66,8,66,8,66,8,66,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,132,66,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,160,65,160,65,160,65,160,65,160,65,160,65,160,65,162,124,162,124,162,124,162,124,162,124,162,124,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,160,65,160,65,160,65,160,65,160,81,160,65,226,120,226,120,226,120,226,120,226,120,226,120,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,160,65,160,65,160,65,160,65,8,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,46,0,55,0,46,0,48,0,0,0,77,0,97,0,121,0,32,0,50,0,49,0,32,0,50,0,48,0,49,0,54,0,44,0,32,0,48,0,48,0,58,0,51,0,55,0,58,0,52,0,48,0,0,0,79,0,78,0,65,0,67,0,84,0,83,0,69,0,76,0,0,0,79,0,78,0,79,0,66,0,74,0,83,0,69,0,76,0,0,0,67,0,79,0,85,0,78,0,84,0,69,0,82,0,0,0,85,0,83,0,69,0,82,0,67,0,79,0,77,0,0,0,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,140,66,137,66,136,66,136,66,136,66,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,132,66,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,160,65,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,176,120,160,65,160,65,160,65,160,65,160,65,160,65,160,65,162,124,162,124,162,124,162,124,162,124,162,124,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,162,116,160,65,160,65,160,65,160,65,160,81,160,65,226,120,226,120,226,120,226,120,226,120,226,120,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,226,112,160,65,160,65,160,65,160,65,8,64,8,0,8,0,8,0,8,0,8,0,136,2,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,132,2,160,1,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,226,48,160,1,160,0,168,0,160,0,160,0,160,0,160,0,160,16,160,16,160,0,226,48,160,0,160,1,160,0,160,16,226,48,160,1,160,16,160,16,160,16,160,1,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+437636);
/* memory initializer */ allocate([162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,162,52,160,0,162,52,162,52,162,52,162,52,162,52,162,52,162,52,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,160,0,226,48,226,48,226,48,226,48,226,48,226,48,226,48,226,48,12,107,53,36,133,5,43,172,50,38,243,76,143,244,142,188,236,105,77,149,119,104,195,219,194,113,31,209,20,170,10,9,13,6,211,81,233,49,54,158,157,128,37,239,226,85,238,144,90,180,231,41,4,193,103,0,212,210,117,208,248,116,132,70,200,68,230,99,61,216,156,218,7,181,57,106,167,222,80,249,102,168,189,201,25,206,125,235,228,205,253,165,33,131,163,217,151,16,191,139,213,129,65,30,110,17,78,174,87,146,196,161,63,124,74,24,35,109,59,150,175,224,79,245,126,34,183,48,89,21,71,220,225,101,166,32,27,66,204,29,148,207,202,83,154,40,135,60,140,120,45,147,141,56,3,162,221,73,98,240,223,160,242,72,114,111,127,198,115,26,118,173,11,254,130,108,186,15,58,96,18,123,51,190,159,93,1,100,182,23,215,152,2,185,75,255,171,176,91,179,22,247,203,252,197,14,82,92,232,42,134,97,199,46,229,164,250,121,39,251,192,122,138,55,178,237,169,95,187,62,69,47,84,88,44,112,64,227,86,184,234,145,52,246,136,67,153,214,137,155,8,241,94,28,177,19,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,58,32,47,0,92,120,37,48,50,120,0,0,114,101,100,117,110,100,97,110,116,32,110,101,115,116,101,100,32,114,101,112,101,97,116,32,111,112,101,114,97,116,111,114,0,110,101,115,116,101,100,32,114,101,112,101,97,116,32,111,112,101,114,97,116,111,114,32,37,115,32,97,110,100,32,37,115,32,119,97,115,32,114,101,112,108,97,99,101,100,32,119,105,116,104,32,39,37,115,39,0,0,42,0,42,63,0,63,63,0,43,32,97,110,100,32,63,63,0,43,63,32,97,110,100,32,63,0,63,0,43,0,43,63,0,93,0,91,0,45,0,58,93,0,97,108,110,117,109,0,97,108,112,104,97,0,98,108,97,110,107,0,99,110,116,114,108,0,100,105,103,105,116,0,103,114,97,112,104,0,108,111,119,101,114,0,112,114,105,110,116,0,112,117,110,99,116,0,115,112,97,99,101,0,117,112,112,101,114,0,120,100,105,103,105,116,0,97,115,99,105,105,0,119,111,114,100,0,99,104,97,114,97,99,116,101,114,32,99,108,97,115,115,32,104,97,115,32,39,37,115,39,32,119,105,116,104,111,117,116,32,101,115,99,97,112,101,0,114,101,103,117,108,97,114,32,101,120,112,114,101,115,115,105,111,110,32,104,97,115,32,39,37,115,39,32,119,105,116,104,111,117,116,32,101,115,99,97,112,101,0,114,117,115,115,105,97,110,0,85,83,45,65,83,67,73,73,0,78,69,87,76,73,78,69,0,65,108,112,104,97,0,66,108,97,110,107,0,67,110,116,114,108,0,68,105,103,105,116,0,71,114,97,112,104,0,76,111,119,101,114,0,80,114,105,110,116,0,80,117,110,99,116,0,83,112,97,99,101,0,85,112,112,101,114,0,88,68,105,103,105,116,0,87,111,114,100,0,65,108,110,117,109,0,65,83,67,73,73,0,65,110,121,0,65,115,115,105,103,110,101,100,0,67,0,67,99,0,67,102,0,67,110,0,67,111,0,67,115,0,76,0,76,108,0,76,109,0,76,111,0,76,116,0,76,117,0,77,0,77,99,0,77,101,0,77,110,0,78,0,78,100,0,78,108,0,78,111,0,80,0,80,99,0,80,100,0,80,101,0,80,102,0,80,105,0,80,111,0,80,115,0,83,0,83,99,0,83,107,0,83,109,0,83,111,0,90,0,90,108,0,90,112,0,90,115,0,65,114,97,98,105,99,0,65,114,109,101,110,105,97,110,0,66,101,110,103,97,108,105,0,66,111,112,111,109,111,102,111,0,66,114,97,105,108,108,101,0,66,117,103,105,110,101,115,101,0,66,117,104,105,100,0,67,97,110,97,100,105,97,110,95,65,98,111,114,105,103,105,110,97,108,0,67,104,101,114,111,107,101,101,0,67,111,109,109,111,110,0,67,111,112,116,105,99,0,67,121,112,114,105,111,116,0,67,121,114,105,108,108,105,99,0,68,101,115,101,114,101,116,0,68,101,118,97,110,97,103,97,114,105,0,69,116,104,105,111,112,105,99,0,71,101,111,114,103,105,97,110,0,71,108,97,103,111,108,105,116,105,99,0,71,111,116,104,105,99,0,71,114,101,101,107,0,71,117,106,97,114,97,116,105,0,71,117,114,109,117,107,104,105,0,72,97,110,0,72,97,110,103,117,108,0,72,97,110,117,110,111,111,0,72,101,98,114,101,119,0,72,105,114,97,103,97,110,97,0,73,110,104,101,114,105,116,101,100,0,75,97,110,110,97,100,97,0,75,97,116,97,107,97,110,97,0,75,104,97,114,111,115,104,116,104,105,0,75,104,109,101,114,0,76,97,111,0,76,97,116,105,110,0,76,105,109,98,117,0,76,105,110,101,97,114,95,66,0,77,97,108,97,121,97,108,97,109,0,77,111,110,103,111,108,105,97,110,0,77,121,97,110,109,97,114,0,78,101,119,95,84,97,105,95,76,117,101,0,79,103,104,97,109,0,79,108,100,95,73,116,97,108,105,99,0,79,108,100,95,80,101,114,115,105,97,110,0,79,114,105,121,97,0,79,115,109,97,110,121,97,0,82,117,110,105,99,0,83,104,97,118,105,97,110,0,83,105,110,104,97,108,97,0,83,121,108,111,116,105,95,78,97,103,114,105,0,83,121,114,105,97,99,0,84,97,103,97,108,111,103,0,84,97,103,98,97,110,119,97,0,84,97,105,95,76,101,0,84,97,109,105,108,0,84,101,108,117,103,117,0,84,104,97,97,110,97,0,84,104,97,105,0,84,105,98,101,116,97,110,0,84,105,102,105,110,97,103,104,0,85,103,97,114,105,116,105,99,0,89,105,0,85,84,70,45,49,54,66,69,0,85,84,70,45,49,54,76,69,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,67,46,85,84,70,45,56,0,114,119,97], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+447876);
/* memory initializer */ allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+452493);





/* no memory initializer */
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


  var _BDtoIHigh=true;

   
  Module["_i64Subtract"] = _i64Subtract;

   
  Module["_i64Add"] = _i64Add;

  function _pthread_cleanup_push(routine, arg) {
      __ATEXIT__.push(function() { Runtime.dynCall('vi', routine, [arg]) })
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

   
  Module["_memset"] = _memset;

  var _BDtoILow=true;

   
  Module["_bitshift64Lshr"] = _bitshift64Lshr;

   
  Module["_bitshift64Shl"] = _bitshift64Shl;

  function _pthread_cleanup_pop() {
      assert(_pthread_cleanup_push.level == __ATEXIT__.length, 'cannot pop if something else added meanwhile!');
      __ATEXIT__.pop();
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

  function _abort() {
      Module['abort']();
    }

  
  
  
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  
  function ___setErrNo(value) {
      if (Module['___errno_location']) HEAP32[((Module['___errno_location']())>>2)]=value;
      else Module.printErr('failed to set errno from JS');
      return value;
    }
  
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function (stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = new Buffer(BUFSIZE);
              var bytesRead = 0;
  
              var fd = process.stdin.fd;
              // Linux and Mac cannot use process.stdin.fd (which isn't set up as sync)
              var usingDevice = false;
              try {
                fd = fs.openSync('/dev/stdin', 'r');
                usingDevice = true;
              } catch (e) {}
  
              bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
  
              if (usingDevice) { fs.closeSync(fd); }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
  
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  var MEMFS={ops_table:null,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.buffer.byteLength which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },getFileDataAsRegularArray:function (node) {
        if (node.contents && node.contents.subarray) {
          var arr = [];
          for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
          return arr; // Returns a copy of the original data.
        }
        return node.contents; // No-op, the file contents are already in a JS array. Return as-is.
      },getFileDataAsTypedArray:function (node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function (node, newCapacity) {
        // If we are asked to expand the size of a file that already exists, revert to using a standard JS array to store the file
        // instead of a typed array. This makes resizing the array more flexible because we can just .push() elements at the back to
        // increase the size.
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node);
          node.usedBytes = node.contents.length; // We might be writing to a lazy-loaded file which had overridden this property, so force-reset it.
        }
  
        if (!node.contents || node.contents.subarray) { // Keep using a typed array if creating a new storage, or if old one was a typed array as well.
          var prevCapacity = node.contents ? node.contents.buffer.byteLength : 0;
          if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
          // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
          // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
          // avoid overshooting the allocation cap by a very large margin.
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) | 0);
          if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity); // Allocate new storage.
          if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
          return;
        }
        // Not using a typed array to back the file storage. Use a standard JS array instead.
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0);
      },resizeFileStorage:function (node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
          return;
        }
        if (!node.contents || node.contents.subarray) { // Resize a typed array if that is being used as the backing store.
          var oldContents = node.contents;
          node.contents = new Uint8Array(new ArrayBuffer(newSize)); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
          return;
        }
        // Backing with a JS array.
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) { // Can we just reuse the buffer we are given?
              assert(position === 0, 'canOwn must imply no weird position inside the file');
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); // Use typed array write if available.
          else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position+length);
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function (stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  var IDBFS={dbs:{},indexedDB:function () {
        if (typeof indexedDB !== 'undefined') return indexedDB;
        var ret = null;
        if (typeof window === 'object') ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, 'IDBFS used, but indexedDB not supported');
        return ret;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
  
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
  
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
  
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
  
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;
  
          var fileStore;
  
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }
  
          if (!fileStore.indexNames.contains('timestamp')) {
            fileStore.createIndex('timestamp', 'timestamp', { unique: false });
          }
        };
        req.onsuccess = function() {
          db = req.result;
  
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};
  
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
  
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  
        while (check.length) {
          var path = check.pop();
          var stat;
  
          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
  
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }
  
          entries[path] = { timestamp: stat.mtime };
        }
  
        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};
  
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
  
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function(e) {
            callback(this.error);
            e.preventDefault();
          };
  
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          var index = store.index('timestamp');
  
          index.openKeyCursor().onsuccess = function(event) {
            var cursor = event.target.result;
  
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, entries: entries });
            }
  
            entries[cursor.primaryKey] = { timestamp: cursor.key };
  
            cursor.continue();
          };
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;
  
        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }
  
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          // Performance consideration: storing a normal JavaScript array to a IndexedDB is much slower than storing a typed array.
          // Therefore always convert the file contents to a typed array first before writing the data to IndexedDB.
          node.contents = MEMFS.getFileDataAsTypedArray(node);
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { encoding: 'binary', canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }
  
          FS.chmod(path, entry.mode);
          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);
  
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },reconcile:function (src, dst, callback) {
        var total = 0;
  
        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });
  
        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });
  
        if (!total) {
          return callback(null);
        }
  
        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };
  
        transaction.onerror = function(e) {
          done(this.error);
          e.preventDefault();
        };
  
        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });
  
        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};
  
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        flags &= ~0100000 /*O_LARGEFILE*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            path = fs.readlinkSync(path);
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
            return path;
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          if (length === 0) return 0; // node errors on 0 length reads
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
  
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
  
          return position;
        }}};
  
  var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function (mount) {
        assert(ENVIRONMENT_IS_WORKER);
        if (!WORKERFS.reader) WORKERFS.reader = new FileReaderSync();
        var root = WORKERFS.createNode(null, '/', WORKERFS.DIR_MODE, 0);
        var createdParents = {};
        function ensureParent(path) {
          // return the parent node, creating subdirs as necessary
          var parts = path.split('/');
          var parent = root;
          for (var i = 0; i < parts.length-1; i++) {
            var curr = parts.slice(0, i+1).join('/');
            if (!createdParents[curr]) {
              createdParents[curr] = WORKERFS.createNode(parent, curr, WORKERFS.DIR_MODE, 0);
            }
            parent = createdParents[curr];
          }
          return parent;
        }
        function base(path) {
          var parts = path.split('/');
          return parts[parts.length-1];
        }
        // We also accept FileList here, by using Array.prototype
        Array.prototype.forEach.call(mount.opts["files"] || [], function(file) {
          WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file, file.lastModifiedDate);
        });
        (mount.opts["blobs"] || []).forEach(function(obj) {
          WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"]);
        });
        (mount.opts["packages"] || []).forEach(function(pack) {
          pack['metadata'].files.forEach(function(file) {
            var name = file.filename.substr(1); // remove initial slash
            WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0, pack['blob'].slice(file.start, file.end));
          });
        });
        return root;
      },createNode:function (parent, name, mode, dev, contents, mtime) {
        var node = FS.createNode(parent, name, mode);
        node.mode = mode;
        node.node_ops = WORKERFS.node_ops;
        node.stream_ops = WORKERFS.stream_ops;
        node.timestamp = (mtime || new Date).getTime();
        assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE);
        if (mode === WORKERFS.FILE_MODE) {
          node.size = contents.size;
          node.contents = contents;
        } else {
          node.size = 4096;
          node.contents = {};
        }
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          return {
            dev: 1,
            ino: undefined,
            mode: node.mode,
            nlink: 1,
            uid: 0,
            gid: 0,
            rdev: undefined,
            size: node.size,
            atime: new Date(node.timestamp),
            mtime: new Date(node.timestamp),
            ctime: new Date(node.timestamp),
            blksize: 4096,
            blocks: Math.ceil(node.size / 4096),
          };
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rename:function (oldNode, newDir, newName) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },unlink:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rmdir:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readdir:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },symlink:function (parent, newName, oldPath) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readlink:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          if (position >= stream.node.size) return 0;
          var chunk = stream.node.contents.slice(position, position + length);
          var ab = WORKERFS.reader.readAsArrayBuffer(chunk);
          buffer.set(new Uint8Array(ab), offset);
          return chunk.size;
        },write:function (stream, buffer, offset, length, position) {
          throw new FS.ErrnoError(ERRNO_CODES.EIO);
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.size;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        }}};
  
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
  
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };
  
          FS.FSNode.prototype = {};
  
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
  
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); }
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); }
            }
          });
        }
  
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var perms = ['r', 'w', 'rw'][flag & 3];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        var err = FS.nodePermissions(dir, 'x');
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0;
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            callback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        try {
          if (FS.trackingDelegate['willMovePath']) {
            FS.trackingDelegate['willMovePath'](old_path, new_path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
        try {
          if (FS.trackingDelegate['onMovePath']) FS.trackingDelegate['onMovePath'](old_path, new_path);
        } catch(e) {
          console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // if asked only for a directory, then this must be one
        if ((flags & 65536) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var err = FS.mayOpen(node, flags);
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        try {
          if (FS.trackingDelegate['onOpenFile']) {
            var trackingFlags = 0;
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ;
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE;
            }
            FS.trackingDelegate['onOpenFile'](path, trackingFlags);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: " + e.message);
        }
        return stream;
      },close:function (stream) {
        if (stream.getdents) stream.getdents = null; // free readdir state
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
          if (stream.path && FS.trackingDelegate['onWriteToFile']) FS.trackingDelegate['onWriteToFile'](stream.path);
        } catch(e) {
          console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: " + e.message);
        }
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },msync:function (stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function (stream) {
        return 0;
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device;
        if (typeof crypto !== 'undefined') {
          // for modern web browsers
          var randomBuffer = new Uint8Array(1);
          random_device = function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
        } else if (ENVIRONMENT_IS_NODE) {
          // for nodejs
          random_device = function() { return require('crypto').randomBytes(1)[0]; };
        } else {
          // default for ES5 platforms
          random_device = function() { return (Math.random()*256)|0; };
        }
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createSpecialDirectories:function () {
        // create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the name of the stream for fd 6 (see test_unistd_ttyname)
        FS.mkdir('/proc');
        FS.mkdir('/proc/self');
        FS.mkdir('/proc/self/fd');
        FS.mount({
          mount: function() {
            var node = FS.createNode('/proc/self', 'fd', 16384 | 0777, 73);
            node.node_ops = {
              lookup: function(parent, name) {
                var fd = +name;
                var stream = FS.getStream(fd);
                if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
                var ret = {
                  parent: null,
                  mount: { mountpoint: 'fake' },
                  node_ops: { readlink: function() { return stream.path } }
                };
                ret.parent = ret; // make it look like a simple root node
                return ret;
              }
            };
            return node;
          }
        }, {}, '/proc/self/fd');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');
  
        var stdout = FS.open('/dev/stdout', 'w');
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');
  
        var stderr = FS.open('/dev/stderr', 'w');
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
          //Module.printErr(stackTrace()); // useful for debugging
          this.node = node;
          this.setErrno = function(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key;
                break;
              }
            }
          };
          this.setErrno(errno);
          this.message = ERRNO_MESSAGES[errno];
          if (this.stack) this.stack = demangleAll(this.stack);
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
        FS.createSpecialDirectories();
  
        FS.filesystems = {
          'MEMFS': MEMFS,
          'IDBFS': IDBFS,
          'NODEFS': NODEFS,
          'WORKERFS': WORKERFS,
        };
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        // force-flush all streams, so we get musl std streams printed out
        var fflush = Module['_fflush'];
        if (fflush) fflush(0);
        // close all of our streams
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperty(node, "usedBytes", {
            get: function() { return this.contents.length; }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function (dirfd, path) {
        if (path[0] !== '/') {
          // relative path
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = FS.getStream(dirfd);
            if (!dirstream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
            dir = dirstream.path;
          }
          path = PATH.join2(dir, path);
        }
        return path;
      },doStat:function (func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -ERRNO_CODES.ENOTDIR;
          }
          throw e;
        }
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode;
        HEAP32[(((buf)+(16))>>2)]=stat.nlink;
        HEAP32[(((buf)+(20))>>2)]=stat.uid;
        HEAP32[(((buf)+(24))>>2)]=stat.gid;
        HEAP32[(((buf)+(28))>>2)]=stat.rdev;
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size;
        HEAP32[(((buf)+(40))>>2)]=4096;
        HEAP32[(((buf)+(44))>>2)]=stat.blocks;
        HEAP32[(((buf)+(48))>>2)]=(stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(52))>>2)]=0;
        HEAP32[(((buf)+(56))>>2)]=(stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)]=0;
        HEAP32[(((buf)+(64))>>2)]=(stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)]=0;
        HEAP32[(((buf)+(72))>>2)]=stat.ino;
        return 0;
      },doMsync:function (addr, stream, len, flags) {
        var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len));
        FS.msync(stream, buffer, 0, len, flags);
      },doMkdir:function (path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function (path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -ERRNO_CODES.EINVAL;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function (path, buf, bufsize) {
        if (bufsize <= 0) return -ERRNO_CODES.EINVAL;
        var ret = FS.readlink(path);
        ret = ret.slice(0, Math.max(0, bufsize));
        writeStringToMemory(ret, buf, true);
        return ret.length;
      },doAccess:function (path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -ERRNO_CODES.EINVAL;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -ERRNO_CODES.EACCES;
        }
        return 0;
      },doDup:function (path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:0,get:function (varargs) {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function () {
        var ret = Pointer_stringify(SYSCALLS.get());
        return ret;
      },getStreamFromFD:function () {
        var stream = FS.getStream(SYSCALLS.get());
        if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return stream;
      },getSocketFromFD:function () {
        var socket = SOCKFS.getSocket(SYSCALLS.get());
        if (!socket) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return socket;
      },getSocketAddress:function (allowNull) {
        var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get();
        if (allowNull && addrp === 0) return null;
        var info = __read_sockaddr(addrp, addrlen);
        if (info.errno) throw new FS.ErrnoError(info.errno);
        info.addr = DNS.lookup_addr(info.addr) || info.addr;
        return info;
      },get64:function () {
        var low = SYSCALLS.get(), high = SYSCALLS.get();
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      },getZero:function () {
        assert(SYSCALLS.get() === 0);
      }};function ___syscall5(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // open
      var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get() // optional TODO
      var stream = FS.open(pathname, flags, mode);
      return stream.fd;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___lock() {}

  function ___unlock() {}

  function ___syscall6(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // close
      var stream = SYSCALLS.getStreamFromFD();
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 85: return totalMemory / PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 79:
          return 0;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: {
          if (typeof navigator === 'object') return navigator['hardwareConcurrency'] || 1;
          return 1;
        }
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) {
        var success = self.alloc(bytes);
        if (!success) return -1 >>> 0; // sbrk failure code
      }
      return ret;  // Previous break location.
    }

  
  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 
  Module["_memcpy"] = _memcpy; 
  Module["_memmove"] = _memmove;

  var _BItoD=true;


  
  
  function _emscripten_set_main_loop_timing(mode, value) {
      Browser.mainLoop.timingMode = mode;
      Browser.mainLoop.timingValue = value;
  
      if (!Browser.mainLoop.func) {
        console.error('emscripten_set_main_loop_timing: Cannot set timing mode for main loop since a main loop does not exist! Call emscripten_set_main_loop first to set one up.');
        return 1; // Return non-zero on failure, can't set timing mode when there is no main loop.
      }
  
      if (mode == 0 /*EM_TIMING_SETTIMEOUT*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setTimeout() {
          setTimeout(Browser.mainLoop.runner, value); // doing this each time means that on exception, we stop
        };
        Browser.mainLoop.method = 'timeout';
      } else if (mode == 1 /*EM_TIMING_RAF*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_rAF() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'rAF';
      } else if (mode == 2 /*EM_TIMING_SETIMMEDIATE*/) {
        if (!window['setImmediate']) {
          // Emulate setImmediate. (note: not a complete polyfill, we don't emulate clearImmediate() to keep code size to minimum, since not needed)
          var setImmediates = [];
          var emscriptenMainLoopMessageId = '__emcc';
          function Browser_setImmediate_messageHandler(event) {
            if (event.source === window && event.data === emscriptenMainLoopMessageId) {
              event.stopPropagation();
              setImmediates.shift()();
            }
          }
          window.addEventListener("message", Browser_setImmediate_messageHandler, true);
          window['setImmediate'] = function Browser_emulated_setImmediate(func) {
            setImmediates.push(func);
            window.postMessage(emscriptenMainLoopMessageId, "*");
          }
        }
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setImmediate() {
          window['setImmediate'](Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'immediate';
      }
      return 0;
    }function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
      Module['noExitRuntime'] = true;
  
      assert(!Browser.mainLoop.func, 'emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.');
  
      Browser.mainLoop.func = func;
      Browser.mainLoop.arg = arg;
  
      var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
  
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
  
        // catch pauses from non-main loop sources
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Implement very basic swap interval control
        Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
        if (Browser.mainLoop.timingMode == 1/*EM_TIMING_RAF*/ && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
          // Not the scheduled time to render this frame - skip.
          Browser.mainLoop.scheduler();
          return;
        }
  
        // Signal GL rendering layer that processing of a new frame is about to start. This helps it optimize
        // VBO double-buffering and reduce GPU stalls.
  
        if (Browser.mainLoop.method === 'timeout' && Module.ctx) {
          Module.printErr('Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!');
          Browser.mainLoop.method = ''; // just warn once per call to set main loop
        }
  
        Browser.mainLoop.runIter(function() {
          if (typeof arg !== 'undefined') {
            Runtime.dynCall('vi', func, [arg]);
          } else {
            Runtime.dynCall('v', func);
          }
        });
  
        // catch pauses from the main loop itself
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Queue new audio data. This is important to be right after the main loop invocation, so that we will immediately be able
        // to queue the newest produced audio samples.
        // TODO: Consider adding pre- and post- rAF callbacks so that GL.newRenderingFrameStarted() and SDL.audio.queueNewAudioData()
        //       do not need to be hardcoded into this function, but can be more generic.
        if (typeof SDL === 'object' && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
  
        Browser.mainLoop.scheduler();
      }
  
      if (!noSetTiming) {
        if (fps && fps > 0) _emscripten_set_main_loop_timing(0/*EM_TIMING_SETTIMEOUT*/, 1000.0 / fps);
        else _emscripten_set_main_loop_timing(1/*EM_TIMING_RAF*/, 1); // Do rAF by rendering each frame (no decimating)
  
        Browser.mainLoop.scheduler();
      }
  
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:function () {
          Browser.mainLoop.scheduler = null;
          Browser.mainLoop.currentlyRunningMainloop++; // Incrementing this signals the previous main loop that it's now become old, and it must return.
        },resume:function () {
          Browser.mainLoop.currentlyRunningMainloop++;
          var timingMode = Browser.mainLoop.timingMode;
          var timingValue = Browser.mainLoop.timingValue;
          var func = Browser.mainLoop.func;
          Browser.mainLoop.func = null;
          _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg, true /* do not set timing and call scheduler, we will do it on the next lines */);
          _emscripten_set_main_loop_timing(timingMode, timingValue);
          Browser.mainLoop.scheduler();
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        },runIter:function (func) {
          if (ABORT) return;
          if (Module['preMainLoop']) {
            var preRet = Module['preMainLoop']();
            if (preRet === false) {
              return; // |return false| skips a frame
            }
          }
          try {
            func();
          } catch (e) {
            if (e instanceof ExitStatus) {
              return;
            } else {
              if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
              throw e;
            }
          }
          if (Module['postMainLoop']) Module['postMainLoop']();
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
  
        if (Browser.initted) return;
        Browser.initted = true;
  
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
  
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
  
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          assert(typeof url == 'string', 'createObjectURL must return a url as a string');
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
  
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            assert(typeof url == 'string', 'createObjectURL must return a url as a string');
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
  
        // Canvas event setup
  
        var canvas = Module['canvas'];
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas ||
                                document['msPointerLockElement'] === canvas;
        }
        if (canvas) {
          // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
          // Module['forcedAspectRatio'] = 4 / 3;
          
          canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                      canvas['mozRequestPointerLock'] ||
                                      canvas['webkitRequestPointerLock'] ||
                                      canvas['msRequestPointerLock'] ||
                                      function(){};
          canvas.exitPointerLock = document['exitPointerLock'] ||
                                   document['mozExitPointerLock'] ||
                                   document['webkitExitPointerLock'] ||
                                   document['msExitPointerLock'] ||
                                   function(){}; // no-op if function does not exist
          canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
  
  
          document.addEventListener('pointerlockchange', pointerLockChange, false);
          document.addEventListener('mozpointerlockchange', pointerLockChange, false);
          document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
          document.addEventListener('mspointerlockchange', pointerLockChange, false);
  
          if (Module['elementPointerLock']) {
            canvas.addEventListener("click", function(ev) {
              if (!Browser.pointerLock && canvas.requestPointerLock) {
                canvas.requestPointerLock();
                ev.preventDefault();
              }
            }, false);
          }
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx; // no need to recreate GL context if it's already been created for this canvas.
  
        var ctx;
        var contextHandle;
        if (useWebGL) {
          // For GLES2/desktop GL compatibility, adjust a few defaults to be different to WebGL defaults, so that they align better with the desktop defaults.
          var contextAttributes = {
            antialias: false,
            alpha: false
          };
  
          if (webGLContextAttributes) {
            for (var attribute in webGLContextAttributes) {
              contextAttributes[attribute] = webGLContextAttributes[attribute];
            }
          }
  
          contextHandle = GL.createContext(canvas, contextAttributes);
          if (contextHandle) {
            ctx = GL.getContext(contextHandle).GLctx;
          }
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
        } else {
          ctx = canvas.getContext('2d');
        }
  
        if (!ctx) return null;
  
        if (setInModule) {
          if (!useWebGL) assert(typeof GLctx === 'undefined', 'cannot set in module if GLctx is used, but we are a non-GL context that would replace it');
  
          Module.ctx = ctx;
          if (useWebGL) GL.makeContextCurrent(contextHandle);
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas, vrDevice) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        Browser.vrDevice = vrDevice;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        if (typeof Browser.vrDevice === 'undefined') Browser.vrDevice = null;
  
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          var canvasContainer = canvas.parentNode;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement'] ||
               document['msFullScreenElement'] || document['msFullscreenElement'] ||
               document['webkitCurrentFullScreenElement']) === canvasContainer) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'] ||
                                      document['msExitFullscreen'] ||
                                      document['exitFullscreen'] ||
                                      function() {};
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else {
            
            // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
            canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
            canvasContainer.parentNode.removeChild(canvasContainer);
            
            if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
          Browser.updateCanvasDimensions(canvas);
        }
  
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
          document.addEventListener('MSFullscreenChange', fullScreenChange, false);
        }
  
        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);
  
        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullScreen = canvasContainer['requestFullScreen'] ||
                                            canvasContainer['mozRequestFullScreen'] ||
                                            canvasContainer['msRequestFullscreen'] ||
                                           (canvasContainer['webkitRequestFullScreen'] ? function() { canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
  
        if (vrDevice) {
          canvasContainer.requestFullScreen({ vrDisplay: vrDevice });
        } else {
          canvasContainer.requestFullScreen();
        }
      },nextRAF:0,fakeRequestAnimationFrame:function (func) {
        // try to keep 60fps between calls to here
        var now = Date.now();
        if (Browser.nextRAF === 0) {
          Browser.nextRAF = now + 1000/60;
        } else {
          while (now + 2 >= Browser.nextRAF) { // fudge a little, to avoid timer jitter causing us to do lots of delay:0
            Browser.nextRAF += 1000/60;
          }
        }
        var delay = Math.max(Browser.nextRAF - now, 0);
        setTimeout(func, delay);
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          Browser.fakeRequestAnimationFrame(func);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           Browser.fakeRequestAnimationFrame;
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:function () {
        Browser.allowAsyncCallbacks = false;
      },resumeAsyncCallbacks:function () { // marks future callbacks as ok to execute, and synchronously runs any remaining ones right now
        Browser.allowAsyncCallbacks = true;
        if (Browser.queuedAsyncCallbacks.length > 0) {
          var callbacks = Browser.queuedAsyncCallbacks;
          Browser.queuedAsyncCallbacks = [];
          callbacks.forEach(function(func) {
            func();
          });
        }
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        });
      },safeSetTimeout:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setTimeout(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setInterval(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } // drop it on the floor otherwise, next interval will kick in
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },getMouseWheelDelta:function (event) {
        var delta = 0;
        switch (event.type) {
          case 'DOMMouseScroll': 
            delta = event.detail;
            break;
          case 'mousewheel': 
            delta = event.wheelDelta;
            break;
          case 'wheel': 
            delta = event['deltaY'];
            break;
          default:
            throw 'unrecognized mouse wheel event: ' + event.type;
        }
        return delta;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
  
          // Neither .scrollX or .pageXOffset are defined in a spec, but
          // we prefer .scrollX because it is currently in a spec draft.
          // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
          var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
          var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
          // If this assert lands, it's likely because the browser doesn't support scrollX or pageXOffset
          // and we have no viable fallback.
          assert((typeof scrollX !== 'undefined') && (typeof scrollY !== 'undefined'), 'Unable to retrieve scroll position, mouse positions likely broken.');
  
          if (event.type === 'touchstart' || event.type === 'touchend' || event.type === 'touchmove') {
            var touch = event.touch;
            if (touch === undefined) {
              return; // the "touch" property is only defined in SDL
  
            }
            var adjustedX = touch.pageX - (scrollX + rect.left);
            var adjustedY = touch.pageY - (scrollY + rect.top);
  
            adjustedX = adjustedX * (cw / rect.width);
            adjustedY = adjustedY * (ch / rect.height);
  
            var coords = { x: adjustedX, y: adjustedY };
            
            if (event.type === 'touchstart') {
              Browser.lastTouches[touch.identifier] = coords;
              Browser.touches[touch.identifier] = coords;
            } else if (event.type === 'touchend' || event.type === 'touchmove') {
              var last = Browser.touches[touch.identifier];
              if (!last) last = coords;
              Browser.lastTouches[touch.identifier] = last;
              Browser.touches[touch.identifier] = coords;
            } 
            return;
          }
  
          var x = event.pageX - (scrollX + rect.left);
          var y = event.pageY - (scrollY + rect.top);
  
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
  
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },updateCanvasDimensions:function (canvas, wNative, hNative) {
        if (wNative && hNative) {
          canvas.widthNative = wNative;
          canvas.heightNative = hNative;
        } else {
          wNative = canvas.widthNative;
          hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
          if (w/h < Module['forcedAspectRatio']) {
            w = Math.round(h * Module['forcedAspectRatio']);
          } else {
            h = Math.round(w / Module['forcedAspectRatio']);
          }
        }
        if (((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
             document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
             document['fullScreenElement'] || document['fullscreenElement'] ||
             document['msFullScreenElement'] || document['msFullscreenElement'] ||
             document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
           var factor = Math.min(screen.width / w, screen.height / h);
           w = Math.round(w * factor);
           h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
          if (canvas.width  != w) canvas.width  = w;
          if (canvas.height != h) canvas.height = h;
          if (typeof canvas.style != 'undefined') {
            canvas.style.removeProperty( "width");
            canvas.style.removeProperty("height");
          }
        } else {
          if (canvas.width  != wNative) canvas.width  = wNative;
          if (canvas.height != hNative) canvas.height = hNative;
          if (typeof canvas.style != 'undefined') {
            if (w != wNative || h != hNative) {
              canvas.style.setProperty( "width", w + "px", "important");
              canvas.style.setProperty("height", h + "px", "important");
            } else {
              canvas.style.removeProperty( "width");
              canvas.style.removeProperty("height");
            }
          }
        }
      },wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:function () {
        var handle = Browser.nextWgetRequestHandle;
        Browser.nextWgetRequestHandle++;
        return handle;
      }};

  function _time(ptr) {
      var ret = (Date.now()/1000)|0;
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

  function _pthread_self() {
      //FIXME: assumes only a single thread
      return 0;
    }

  function ___syscall140(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // llseek
      var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
      var offset = offset_low;
      assert(offset_high === 0);
      FS.llseek(stream, offset, whence);
      HEAP32[((result)>>2)]=stream.position;
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall146(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // writev
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doWritev(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall54(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ioctl
      var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get();
      switch (op) {
        case 21505: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        case 21506: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0; // no-op, not actually adjusting terminal settings
        }
        case 21519: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          var argp = SYSCALLS.get();
          HEAP32[((argp)>>2)]=0;
          return 0;
        }
        case 21520: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return -ERRNO_CODES.EINVAL; // not supported
        }
        case 21531: {
          var argp = SYSCALLS.get();
          return FS.ioctl(stream, op, argp);
        }
        default: abort('bad ioctl syscall ' + op);
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall221(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fcntl64
      var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get();
      switch (cmd) {
        case 0: {
          var arg = SYSCALLS.get();
          if (arg < 0) {
            return -ERRNO_CODES.EINVAL;
          }
          var newStream;
          newStream = FS.open(stream.path, stream.flags, 0, arg);
          return newStream.fd;
        }
        case 1:
        case 2:
          return 0;  // FD_CLOEXEC makes no sense for a single process.
        case 3:
          return stream.flags;
        case 4: {
          var arg = SYSCALLS.get();
          stream.flags |= arg;
          return 0;
        }
        case 12:
        case 12: {
          var arg = SYSCALLS.get();
          var offset = 0;
          // We're always unlocked.
          HEAP16[(((arg)+(offset))>>1)]=2;
          return 0;
        }
        case 13:
        case 14:
        case 13:
        case 14:
          return 0; // Pretend that the locking is successful.
        case 16:
        case 8:
          return -ERRNO_CODES.EINVAL; // These are for sockets. We don't have them fully implemented yet.
        case 9:
          // musl trusts getown return values, due to a bug where they must be, as they overlap with errors. just return -1 here, so fnctl() returns that, and we set errno ourselves.
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        default: {
          return -ERRNO_CODES.EINVAL;
        }
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall145(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // readv
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doReadv(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function _qspCurMenuItems() {
  Module['printErr']('missing function: qspCurMenuItems'); abort(-1);
  }

  function _qspCurMenuLocs() {
  Module['printErr']('missing function: qspCurMenuLocs'); abort(-1);
  }
FS.staticInit();__ATINIT__.unshift(function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() });__ATMAIN__.push(function() { FS.ignorePermissions = false });__ATEXIT__.push(function() { FS.quit() });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;Module["FS_unlink"] = FS.unlink;
__ATINIT__.unshift(function() { TTY.init() });__ATEXIT__.push(function() { TTY.shutdown() });
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); var NODEJS_PATH = require("path"); NODEFS.staticInit(); }
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas, vrDevice) { Browser.requestFullScreen(lockPointer, resizeCanvas, vrDevice) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
  Module["createContext"] = function Module_createContext(canvas, useWebGL, setInModule, webGLContextAttributes) { return Browser.createContext(canvas, useWebGL, setInModule, webGLContextAttributes) }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);


function nullFunc_iiii(x) { Module["printErr"]("Invalid function pointer called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_i(x) { Module["printErr"]("Invalid function pointer called with signature 'i'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vi(x) { Module["printErr"]("Invalid function pointer called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_ii(x) { Module["printErr"]("Invalid function pointer called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viii(x) { Module["printErr"]("Invalid function pointer called with signature 'viii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'iiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iii(x) { Module["printErr"]("Invalid function pointer called with signature 'iii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };

Module.asmLibraryArg = { "abort": abort, "assert": assert, "nullFunc_iiii": nullFunc_iiii, "nullFunc_i": nullFunc_i, "nullFunc_vi": nullFunc_vi, "nullFunc_ii": nullFunc_ii, "nullFunc_viii": nullFunc_viii, "nullFunc_iiiii": nullFunc_iiiii, "nullFunc_iii": nullFunc_iii, "invoke_iiii": invoke_iiii, "invoke_i": invoke_i, "invoke_vi": invoke_vi, "invoke_ii": invoke_ii, "invoke_viii": invoke_viii, "invoke_iiiii": invoke_iiiii, "invoke_iii": invoke_iii, "_pthread_cleanup_pop": _pthread_cleanup_pop, "___syscall221": ___syscall221, "_pthread_self": _pthread_self, "_sysconf": _sysconf, "___lock": ___lock, "___syscall6": ___syscall6, "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing, "_abort": _abort, "_sbrk": _sbrk, "_time": _time, "___syscall5": ___syscall5, "_emscripten_memcpy_big": _emscripten_memcpy_big, "___syscall54": ___syscall54, "___unlock": ___unlock, "___syscall140": ___syscall140, "_pthread_cleanup_push": _pthread_cleanup_push, "_emscripten_set_main_loop": _emscripten_set_main_loop, "___syscall145": ___syscall145, "___syscall146": ___syscall146, "___setErrNo": ___setErrNo, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "cttz_i8": cttz_i8, "_qspCurMenuItems": _qspCurMenuItems, "_qspCurMenuLocs": _qspCurMenuLocs };
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'almost asm';
  
  
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);


  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var _qspCurMenuItems=env._qspCurMenuItems|0;
  var _qspCurMenuLocs=env._qspCurMenuLocs|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var nullFunc_iiii=env.nullFunc_iiii;
  var nullFunc_i=env.nullFunc_i;
  var nullFunc_vi=env.nullFunc_vi;
  var nullFunc_ii=env.nullFunc_ii;
  var nullFunc_viii=env.nullFunc_viii;
  var nullFunc_iiiii=env.nullFunc_iiiii;
  var nullFunc_iii=env.nullFunc_iii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_i=env.invoke_i;
  var invoke_vi=env.invoke_vi;
  var invoke_ii=env.invoke_ii;
  var invoke_viii=env.invoke_viii;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_iii=env.invoke_iii;
  var _pthread_cleanup_pop=env._pthread_cleanup_pop;
  var ___syscall221=env.___syscall221;
  var _pthread_self=env._pthread_self;
  var _sysconf=env._sysconf;
  var ___lock=env.___lock;
  var ___syscall6=env.___syscall6;
  var _emscripten_set_main_loop_timing=env._emscripten_set_main_loop_timing;
  var _abort=env._abort;
  var _sbrk=env._sbrk;
  var _time=env._time;
  var ___syscall5=env.___syscall5;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var ___syscall54=env.___syscall54;
  var ___unlock=env.___unlock;
  var ___syscall140=env.___syscall140;
  var _pthread_cleanup_push=env._pthread_cleanup_push;
  var _emscripten_set_main_loop=env._emscripten_set_main_loop;
  var ___syscall145=env.___syscall145;
  var ___syscall146=env.___syscall146;
  var ___setErrNo=env.___setErrNo;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS
function stackAlloc(size) {
  size = size|0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = (STACKTOP + size)|0;
  STACKTOP = (STACKTOP + 15)&-16;
if ((STACKTOP|0) >= (STACK_MAX|0)) abort();

  return ret|0;
}
function stackSave() {
  return STACKTOP|0;
}
function stackRestore(top) {
  top = top|0;
  STACKTOP = top;
}
function establishStackSpace(stackBase, stackMax) {
  stackBase = stackBase|0;
  stackMax = stackMax|0;
  STACKTOP = stackBase;
  STACK_MAX = stackMax;
}

function setThrew(threw, value) {
  threw = threw|0;
  value = value|0;
  if ((__THREW__|0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}
function copyTempFloat(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
}
function copyTempDouble(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
  HEAP8[tempDoublePtr+4>>0] = HEAP8[ptr+4>>0];
  HEAP8[tempDoublePtr+5>>0] = HEAP8[ptr+5>>0];
  HEAP8[tempDoublePtr+6>>0] = HEAP8[ptr+6>>0];
  HEAP8[tempDoublePtr+7>>0] = HEAP8[ptr+7>>0];
}

function setTempRet0(value) {
  value = value|0;
  tempRet0 = value;
}
function getTempRet0() {
  return tempRet0|0;
}

function _qspClearActions($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $1 = $0;
 $2 = ($1|0)==(0);
 $3 = HEAP32[8>>2]|0;
 $4 = ($3|0)!=(0);
 $or$cond = $2 & $4;
 if (!($or$cond)) {
  HEAP32[8>>2] = 0;
  HEAP32[12>>2] = -1;
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $5 = $i;
  $6 = HEAP32[8>>2]|0;
  $7 = ($5|0)<($6|0);
  if (!($7)) {
   break;
  }
  $8 = $i;
  $9 = (24 + ($8<<5)|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = ($10|0)!=(0|0);
  if ($11) {
   $12 = $i;
   $13 = (24 + ($12<<5)|0);
   $14 = HEAP32[$13>>2]|0;
   _free($14);
  }
  $15 = $i;
  $16 = (24 + ($15<<5)|0);
  $17 = ((($16)) + 4|0);
  $18 = HEAP32[$17>>2]|0;
  _free($18);
  $19 = $i;
  $20 = (24 + ($19<<5)|0);
  $21 = ((($20)) + 8|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = $i;
  $24 = (24 + ($23<<5)|0);
  $25 = ((($24)) + 12|0);
  $26 = HEAP32[$25>>2]|0;
  _qspFreePrepLines($22,$26);
  $27 = $i;
  $28 = (($27) + 1)|0;
  $i = $28;
 }
 HEAP32[16>>2] = 1;
 HEAP32[8>>2] = 0;
 HEAP32[12>>2] = -1;
 STACKTOP = sp;return;
}
function _qspAddAction($args,$count,$code,$start,$end,$isManageLines) {
 $args = $args|0;
 $count = $count|0;
 $code = $code|0;
 $start = $start|0;
 $end = $end|0;
 $isManageLines = $isManageLines|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $act = 0, $imgPath = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $code;
 $3 = $start;
 $4 = $end;
 $5 = $isManageLines;
 $6 = $0;
 $7 = HEAP32[$6>>2]|0;
 $8 = (_qspActIndex($7)|0);
 $9 = ($8|0)>=(0);
 if ($9) {
  STACKTOP = sp;return;
 }
 $10 = HEAP32[8>>2]|0;
 $11 = ($10|0)==(50);
 if ($11) {
  _qspSetError(109);
  STACKTOP = sp;return;
 }
 $12 = $1;
 $13 = ($12|0)==(2);
 if ($13) {
  $14 = $0;
  $15 = ((($14)) + 8|0);
  $16 = HEAP32[$15>>2]|0;
  $17 = (_qspIsAnyString($16)|0);
  $18 = ($17|0)!=(0);
  if ($18) {
   $19 = $0;
   $20 = ((($19)) + 8|0);
   $21 = HEAP32[$20>>2]|0;
   $22 = (_qspGetAbsFromRelPath($21)|0);
   $imgPath = $22;
  } else {
   label = 7;
  }
 } else {
  label = 7;
 }
 if ((label|0) == 7) {
  $imgPath = 0;
 }
 $23 = HEAP32[8>>2]|0;
 $24 = (($23) + 1)|0;
 HEAP32[8>>2] = $24;
 $25 = (24 + ($23<<5)|0);
 $act = $25;
 $26 = $imgPath;
 $27 = $act;
 HEAP32[$27>>2] = $26;
 $28 = $0;
 $29 = HEAP32[$28>>2]|0;
 $30 = (_qspGetNewText($29,-1)|0);
 $31 = $act;
 $32 = ((($31)) + 4|0);
 HEAP32[$32>>2] = $30;
 $33 = $act;
 $34 = ((($33)) + 8|0);
 $35 = $2;
 $36 = $3;
 $37 = $4;
 _qspCopyPrepLines($34,$35,$36,$37);
 $38 = $4;
 $39 = $3;
 $40 = (($38) - ($39))|0;
 $41 = $act;
 $42 = ((($41)) + 12|0);
 HEAP32[$42>>2] = $40;
 $43 = HEAP32[320476>>2]|0;
 $44 = $act;
 $45 = ((($44)) + 16|0);
 HEAP32[$45>>2] = $43;
 $46 = HEAP32[320484>>2]|0;
 $47 = $act;
 $48 = ((($47)) + 20|0);
 HEAP32[$48>>2] = $46;
 $49 = HEAP32[320480>>2]|0;
 $50 = $act;
 $51 = ((($50)) + 24|0);
 HEAP32[$51>>2] = $49;
 $52 = $5;
 $53 = $act;
 $54 = ((($53)) + 28|0);
 HEAP32[$54>>2] = $52;
 HEAP32[16>>2] = 1;
 STACKTOP = sp;return;
}
function _qspExecAction($ind) {
 $ind = $ind|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $act = 0;
 var $code = 0, $count = 0, $oldActIndex = 0, $oldLine = 0, $oldLoc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $code = sp + 16|0;
 $0 = $ind;
 $1 = HEAP32[320476>>2]|0;
 $oldLoc = $1;
 $2 = HEAP32[320484>>2]|0;
 $oldActIndex = $2;
 $3 = HEAP32[320480>>2]|0;
 $oldLine = $3;
 $4 = $0;
 $5 = (24 + ($4<<5)|0);
 $act = $5;
 $6 = $act;
 $7 = ((($6)) + 16|0);
 $8 = HEAP32[$7>>2]|0;
 HEAP32[320476>>2] = $8;
 $9 = $act;
 $10 = ((($9)) + 20|0);
 $11 = HEAP32[$10>>2]|0;
 HEAP32[320484>>2] = $11;
 $12 = $act;
 $13 = ((($12)) + 12|0);
 $14 = HEAP32[$13>>2]|0;
 $count = $14;
 $15 = $act;
 $16 = ((($15)) + 8|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = $count;
 _qspCopyPrepLines($code,$17,0,$18);
 $19 = $act;
 $20 = ((($19)) + 28|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ($21|0)!=(0);
 if ($22) {
  $23 = HEAP32[$code>>2]|0;
  $24 = $count;
  $25 = $act;
  $26 = ((($25)) + 24|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = (($27) + 1)|0;
  (_qspExecTopCodeWithLocals($23,$24,$28,0)|0);
  $34 = HEAP32[$code>>2]|0;
  $35 = $count;
  _qspFreePrepLines($34,$35);
  $36 = $oldLine;
  HEAP32[320480>>2] = $36;
  $37 = $oldActIndex;
  HEAP32[320484>>2] = $37;
  $38 = $oldLoc;
  HEAP32[320476>>2] = $38;
  STACKTOP = sp;return;
 } else {
  $29 = $act;
  $30 = ((($29)) + 24|0);
  $31 = HEAP32[$30>>2]|0;
  HEAP32[320480>>2] = $31;
  $32 = HEAP32[$code>>2]|0;
  $33 = $count;
  (_qspExecTopCodeWithLocals($32,$33,0,0)|0);
  $34 = HEAP32[$code>>2]|0;
  $35 = $count;
  _qspFreePrepLines($34,$35);
  $36 = $oldLine;
  HEAP32[320480>>2] = $36;
  $37 = $oldActIndex;
  HEAP32[320484>>2] = $37;
  $38 = $oldLoc;
  HEAP32[320476>>2] = $38;
  STACKTOP = sp;return;
 }
}
function _qspGetAllActionsAsCode() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $8 = 0, $9 = 0, $count = 0, $i = 0, $len = 0, $res = 0, $temp = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $res = sp + 4|0;
 $len = 0;
 $0 = (_qspGetNewText(447354,0)|0);
 HEAP32[$res>>2] = $0;
 $i = 0;
 while(1) {
  $1 = $i;
  $2 = HEAP32[8>>2]|0;
  $3 = ($1|0)<($2|0);
  if (!($3)) {
   break;
  }
  $4 = $len;
  $5 = (_qspAddText($res,443116,$4,5,0)|0);
  $len = $5;
  $6 = $i;
  $7 = (24 + ($6<<5)|0);
  $8 = ((($7)) + 4|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = (_qspReplaceText($9,443128,443132)|0);
  $temp = $10;
  $11 = $temp;
  $12 = $len;
  $13 = (_qspAddText($res,$11,$12,-1,0)|0);
  $len = $13;
  $14 = $temp;
  _free($14);
  $15 = $i;
  $16 = (24 + ($15<<5)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = ($17|0)!=(0|0);
  if ($18) {
   $19 = $len;
   $20 = (_qspAddText($res,443138,$19,3,0)|0);
   $len = $20;
   $21 = $i;
   $22 = (24 + ($21<<5)|0);
   $23 = HEAP32[$22>>2]|0;
   $24 = HEAP32[2936>>2]|0;
   $25 = (($23) + ($24<<1)|0);
   $26 = (_qspReplaceText($25,443128,443132)|0);
   $temp = $26;
   $27 = $temp;
   $28 = $len;
   $29 = (_qspAddText($res,$27,$28,-1,0)|0);
   $len = $29;
   $30 = $temp;
   _free($30);
  }
  $31 = $len;
  $32 = (_qspAddText($res,443146,$31,2,0)|0);
  $len = $32;
  $33 = $i;
  $34 = (24 + ($33<<5)|0);
  $35 = ((($34)) + 12|0);
  $36 = HEAP32[$35>>2]|0;
  $count = $36;
  $37 = $count;
  $38 = ($37|0)==(1);
  if ($38) {
   $39 = $i;
   $40 = (24 + ($39<<5)|0);
   $41 = ((($40)) + 8|0);
   $42 = HEAP32[$41>>2]|0;
   $43 = HEAP32[$42>>2]|0;
   $44 = (_qspIsAnyString($43)|0);
   $45 = ($44|0)!=(0);
   if ($45) {
    $46 = $i;
    $47 = (24 + ($46<<5)|0);
    $48 = ((($47)) + 8|0);
    $49 = HEAP32[$48>>2]|0;
    $50 = HEAP32[$49>>2]|0;
    $51 = $len;
    $52 = (_qspAddText($res,$50,$51,-1,0)|0);
    $len = $52;
   } else {
    label = 8;
   }
  } else {
   label = 8;
  }
  if ((label|0) == 8) {
   label = 0;
   $53 = $count;
   $54 = ($53|0)>=(2);
   if ($54) {
    $55 = $len;
    $56 = (_qspAddText($res,446380,$55,2,0)|0);
    $len = $56;
    $57 = $i;
    $58 = (24 + ($57<<5)|0);
    $59 = ((($58)) + 8|0);
    $60 = HEAP32[$59>>2]|0;
    $61 = $count;
    $62 = (_qspJoinPrepLines($60,$61,446380)|0);
    $temp = $62;
    $63 = $temp;
    $64 = $len;
    $65 = (_qspAddText($res,$63,$64,-1,0)|0);
    $len = $65;
    $66 = $temp;
    _free($66);
   }
   $67 = $len;
   $68 = (_qspAddText($res,443152,$67,5,0)|0);
   $len = $68;
  }
  $69 = $len;
  $70 = (_qspAddText($res,446380,$69,2,0)|0);
  $len = $70;
  $71 = $i;
  $72 = (($71) + 1)|0;
  $i = $72;
 }
 $73 = HEAP32[$res>>2]|0;
 STACKTOP = sp;return ($73|0);
}
function _qspStatementSinglelineAddAct($s,$statPos,$endPos) {
 $s = $s|0;
 $statPos = $statPos|0;
 $endPos = $endPos|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $args = 0, $ch = 0, $code = 0, $count = 0, $i = 0, $offset = 0, $oldRefreshCount = 0, $or$cond = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $args = sp + 48|0;
 $code = sp + 24|0;
 $0 = $s;
 $1 = $statPos;
 $2 = $endPos;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $5 = $1;
 $6 = $0;
 $7 = ((($6)) + 16|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (($8) + (($5*12)|0)|0);
 $10 = ((($9)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($4) + ($11<<1)|0);
 $pos = $12;
 $13 = $pos;
 $14 = HEAP16[$13>>1]|0;
 $15 = $14&65535;
 $16 = HEAP16[446296>>1]|0;
 $17 = $16&65535;
 $18 = ($15|0)!=($17|0);
 if ($18) {
  _qspSetError(107);
  STACKTOP = sp;return;
 }
 $19 = $1;
 $20 = $2;
 $21 = (($20) - 1)|0;
 $22 = ($19|0)==($21|0);
 if ($22) {
  _qspSetError(125);
  STACKTOP = sp;return;
 }
 $23 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $23;
 $24 = $pos;
 HEAP16[$24>>1] = 0;
 $25 = $0;
 $26 = HEAP32[$25>>2]|0;
 $27 = $1;
 $28 = $0;
 $29 = ((($28)) + 16|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = (($30) + (($27*12)|0)|0);
 $32 = ((($31)) + 8|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = (($26) + ($33<<1)|0);
 $35 = (_qspGetStatArgs($34,3,$args)|0);
 $count = $35;
 $36 = HEAP16[446296>>1]|0;
 $37 = $pos;
 HEAP16[$37>>1] = $36;
 $38 = HEAP32[320504>>2]|0;
 $39 = $oldRefreshCount;
 $40 = ($38|0)!=($39|0);
 $41 = HEAP32[320460>>2]|0;
 $42 = ($41|0)!=(0);
 $or$cond = $40 | $42;
 if ($or$cond) {
  STACKTOP = sp;return;
 }
 $43 = $1;
 $44 = (($43) + 1)|0;
 $1 = $44;
 $45 = $pos;
 $46 = ((($45)) + 2|0);
 HEAP32[$code>>2] = $46;
 $47 = HEAP32[$code>>2]|0;
 $48 = (_qspGetLineLabel($47)|0);
 $49 = ((($code)) + 12|0);
 HEAP32[$49>>2] = $48;
 $50 = ((($code)) + 4|0);
 HEAP32[$50>>2] = 0;
 $51 = ((($code)) + 8|0);
 HEAP32[$51>>2] = 0;
 $52 = $0;
 $53 = HEAP32[$52>>2]|0;
 $54 = $2;
 $55 = (($54) - 1)|0;
 $56 = $0;
 $57 = ((($56)) + 16|0);
 $58 = HEAP32[$57>>2]|0;
 $59 = (($58) + (($55*12)|0)|0);
 $60 = ((($59)) + 4|0);
 $61 = HEAP32[$60>>2]|0;
 $62 = (($53) + ($61<<1)|0);
 $pos = $62;
 $63 = $pos;
 $64 = HEAP16[$63>>1]|0;
 $65 = $64&65535;
 $66 = HEAP16[446296>>1]|0;
 $67 = $66&65535;
 $68 = ($65|0)==($67|0);
 if ($68) {
  $69 = $pos;
  $70 = ((($69)) + 2|0);
  $pos = $70;
 }
 $71 = $pos;
 $72 = HEAP16[$71>>1]|0;
 $ch = $72;
 $73 = $pos;
 HEAP16[$73>>1] = 0;
 $74 = $2;
 $75 = $1;
 $76 = (($74) - ($75))|0;
 $77 = ((($code)) + 20|0);
 HEAP32[$77>>2] = $76;
 $78 = ((($code)) + 20|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = ($79*12)|0;
 $81 = (_malloc($80)|0);
 $82 = ((($code)) + 16|0);
 HEAP32[$82>>2] = $81;
 $83 = HEAP32[$code>>2]|0;
 $84 = $0;
 $85 = HEAP32[$84>>2]|0;
 $86 = $83;
 $87 = $85;
 $88 = (($86) - ($87))|0;
 $89 = (($88|0) / 2)&-1;
 $offset = $89;
 $i = 0;
 while(1) {
  $90 = $i;
  $91 = ((($code)) + 20|0);
  $92 = HEAP32[$91>>2]|0;
  $93 = ($90|0)<($92|0);
  if (!($93)) {
   break;
  }
  $94 = $1;
  $95 = $0;
  $96 = ((($95)) + 16|0);
  $97 = HEAP32[$96>>2]|0;
  $98 = (($97) + (($94*12)|0)|0);
  $99 = HEAP32[$98>>2]|0;
  $100 = $i;
  $101 = ((($code)) + 16|0);
  $102 = HEAP32[$101>>2]|0;
  $103 = (($102) + (($100*12)|0)|0);
  HEAP32[$103>>2] = $99;
  $104 = $1;
  $105 = $0;
  $106 = ((($105)) + 16|0);
  $107 = HEAP32[$106>>2]|0;
  $108 = (($107) + (($104*12)|0)|0);
  $109 = ((($108)) + 4|0);
  $110 = HEAP32[$109>>2]|0;
  $111 = $offset;
  $112 = (($110) - ($111))|0;
  $113 = $i;
  $114 = ((($code)) + 16|0);
  $115 = HEAP32[$114>>2]|0;
  $116 = (($115) + (($113*12)|0)|0);
  $117 = ((($116)) + 4|0);
  HEAP32[$117>>2] = $112;
  $118 = $1;
  $119 = $0;
  $120 = ((($119)) + 16|0);
  $121 = HEAP32[$120>>2]|0;
  $122 = (($121) + (($118*12)|0)|0);
  $123 = ((($122)) + 8|0);
  $124 = HEAP32[$123>>2]|0;
  $125 = $offset;
  $126 = (($124) - ($125))|0;
  $127 = $i;
  $128 = ((($code)) + 16|0);
  $129 = HEAP32[$128>>2]|0;
  $130 = (($129) + (($127*12)|0)|0);
  $131 = ((($130)) + 8|0);
  HEAP32[$131>>2] = $126;
  $132 = $1;
  $133 = (($132) + 1)|0;
  $1 = $133;
  $134 = $i;
  $135 = (($134) + 1)|0;
  $i = $135;
 }
 $136 = $count;
 _qspAddAction($args,$136,$code,0,1,0);
 $137 = $ch;
 $138 = $pos;
 HEAP16[$138>>1] = $137;
 $139 = $count;
 _qspFreeVariants($args,$139);
 $140 = ((($code)) + 16|0);
 $141 = HEAP32[$140>>2]|0;
 _free($141);
 $142 = ((($code)) + 12|0);
 $143 = HEAP32[$142>>2]|0;
 $144 = ($143|0)!=(0|0);
 if (!($144)) {
  STACKTOP = sp;return;
 }
 $145 = ((($code)) + 12|0);
 $146 = HEAP32[$145>>2]|0;
 _free($146);
 STACKTOP = sp;return;
}
function _qspStatementMultilineAddAct($s,$endLine,$lineInd,$isManageLines) {
 $s = $s|0;
 $endLine = $endLine|0;
 $lineInd = $lineInd|0;
 $isManageLines = $isManageLines|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $args = 0, $count = 0, $line = 0, $oldRefreshCount = 0, $or$cond = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $args = sp + 16|0;
 $0 = $s;
 $1 = $endLine;
 $2 = $lineInd;
 $3 = $isManageLines;
 $4 = $0;
 $5 = $2;
 $6 = (($4) + (($5*24)|0)|0);
 $line = $6;
 $7 = $line;
 $8 = HEAP32[$7>>2]|0;
 $9 = $line;
 $10 = ((($9)) + 16|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($11)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($8) + ($13<<1)|0);
 $pos = $14;
 $15 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $15;
 $16 = $pos;
 HEAP16[$16>>1] = 0;
 $17 = $line;
 $18 = HEAP32[$17>>2]|0;
 $19 = $line;
 $20 = ((($19)) + 16|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ((($21)) + 8|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = (($18) + ($23<<1)|0);
 $25 = (_qspGetStatArgs($24,3,$args)|0);
 $count = $25;
 $26 = HEAP16[446296>>1]|0;
 $27 = $pos;
 HEAP16[$27>>1] = $26;
 $28 = HEAP32[320504>>2]|0;
 $29 = $oldRefreshCount;
 $30 = ($28|0)!=($29|0);
 $31 = HEAP32[320460>>2]|0;
 $32 = ($31|0)!=(0);
 $or$cond = $30 | $32;
 if ($or$cond) {
  STACKTOP = sp;return;
 }
 $33 = $count;
 $34 = $0;
 $35 = $2;
 $36 = (($35) + 1)|0;
 $37 = $1;
 $38 = $3;
 _qspAddAction($args,$33,$34,$36,$37,$38);
 $39 = $count;
 _qspFreeVariants($args,$39);
 STACKTOP = sp;return;
}
function _qspStatementDelAct($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $actInd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = $1;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_qspActIndex($6)|0);
 $actInd = $7;
 $8 = $actInd;
 $9 = ($8|0)<(0);
 if ($9) {
  $0 = 0;
  $44 = $0;
  STACKTOP = sp;return ($44|0);
 }
 $10 = HEAP32[12>>2]|0;
 $11 = $actInd;
 $12 = ($10|0)>=($11|0);
 if ($12) {
  HEAP32[12>>2] = -1;
 }
 $13 = $actInd;
 $14 = (24 + ($13<<5)|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)!=(0|0);
 if ($16) {
  $17 = $actInd;
  $18 = (24 + ($17<<5)|0);
  $19 = HEAP32[$18>>2]|0;
  _free($19);
 }
 $20 = $actInd;
 $21 = (24 + ($20<<5)|0);
 $22 = ((($21)) + 4|0);
 $23 = HEAP32[$22>>2]|0;
 _free($23);
 $24 = $actInd;
 $25 = (24 + ($24<<5)|0);
 $26 = ((($25)) + 8|0);
 $27 = HEAP32[$26>>2]|0;
 $28 = $actInd;
 $29 = (24 + ($28<<5)|0);
 $30 = ((($29)) + 12|0);
 $31 = HEAP32[$30>>2]|0;
 _qspFreePrepLines($27,$31);
 $32 = HEAP32[8>>2]|0;
 $33 = (($32) + -1)|0;
 HEAP32[8>>2] = $33;
 while(1) {
  $34 = $actInd;
  $35 = HEAP32[8>>2]|0;
  $36 = ($34|0)<($35|0);
  if (!($36)) {
   break;
  }
  $37 = $actInd;
  $38 = (24 + ($37<<5)|0);
  $39 = $actInd;
  $40 = (($39) + 1)|0;
  $41 = (24 + ($40<<5)|0);
  ;HEAP32[$38>>2]=HEAP32[$41>>2]|0;HEAP32[$38+4>>2]=HEAP32[$41+4>>2]|0;HEAP32[$38+8>>2]=HEAP32[$41+8>>2]|0;HEAP32[$38+12>>2]=HEAP32[$41+12>>2]|0;HEAP32[$38+16>>2]=HEAP32[$41+16>>2]|0;HEAP32[$38+20>>2]=HEAP32[$41+20>>2]|0;HEAP32[$38+24>>2]=HEAP32[$41+24>>2]|0;HEAP32[$38+28>>2]=HEAP32[$41+28>>2]|0;
  $42 = $actInd;
  $43 = (($42) + 1)|0;
  $actInd = $43;
 }
 HEAP32[16>>2] = 1;
 $0 = 0;
 $44 = $0;
 STACKTOP = sp;return ($44|0);
}
function _qspActIndex($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $actNameLen = 0, $buf = 0, $bufSize = 0, $i = 0, $uName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = HEAP32[8>>2]|0;
 $3 = ($2|0)!=(0);
 if (!($3)) {
  $0 = -1;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 $4 = $1;
 $5 = (_qspGetNewText($4,-1)|0);
 $uName = $5;
 _qspUpperStr($5);
 $bufSize = 64;
 $6 = $bufSize;
 $7 = $6<<1;
 $8 = (_malloc($7)|0);
 $buf = $8;
 $i = 0;
 while(1) {
  $9 = $i;
  $10 = HEAP32[8>>2]|0;
  $11 = ($9|0)<($10|0);
  if (!($11)) {
   label = 10;
   break;
  }
  $12 = $i;
  $13 = (24 + ($12<<5)|0);
  $14 = ((($13)) + 4|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = (_qspStrLen($15)|0);
  $actNameLen = $16;
  $17 = $actNameLen;
  $18 = $bufSize;
  $19 = ($17|0)>=($18|0);
  if ($19) {
   $20 = $actNameLen;
   $21 = (($20) + 16)|0;
   $bufSize = $21;
   $22 = $buf;
   $23 = $bufSize;
   $24 = $23<<1;
   $25 = (_realloc($22,$24)|0);
   $buf = $25;
  }
  $26 = $buf;
  $27 = $i;
  $28 = (24 + ($27<<5)|0);
  $29 = ((($28)) + 4|0);
  $30 = HEAP32[$29>>2]|0;
  (_qspStrCopy($26,$30)|0);
  $31 = $buf;
  _qspUpperStr($31);
  $32 = $buf;
  $33 = $uName;
  $34 = (_qspStrsComp($32,$33)|0);
  $35 = ($34|0)!=(0);
  if (!($35)) {
   label = 8;
   break;
  }
  $39 = $i;
  $40 = (($39) + 1)|0;
  $i = $40;
 }
 if ((label|0) == 8) {
  $36 = $uName;
  _free($36);
  $37 = $buf;
  _free($37);
  $38 = $i;
  $0 = $38;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 else if ((label|0) == 10) {
  $41 = $uName;
  _free($41);
  $42 = $buf;
  _free($42);
  $0 = -1;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 return (0)|0;
}
function _qspFreePrepLines($strs,$count) {
 $strs = $strs|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $strs;
 $1 = $count;
 $2 = $0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 while(1) {
  $4 = $1;
  $5 = (($4) + -1)|0;
  $1 = $5;
  $6 = ($5|0)>=(0);
  if (!($6)) {
   break;
  }
  $7 = $1;
  $8 = $0;
  $9 = (($8) + (($7*24)|0)|0);
  $10 = HEAP32[$9>>2]|0;
  _free($10);
  $11 = $1;
  $12 = $0;
  $13 = (($12) + (($11*24)|0)|0);
  $14 = ((($13)) + 12|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = ($15|0)!=(0|0);
  if ($16) {
   $17 = $1;
   $18 = $0;
   $19 = (($18) + (($17*24)|0)|0);
   $20 = ((($19)) + 12|0);
   $21 = HEAP32[$20>>2]|0;
   _free($21);
  }
  $22 = $1;
  $23 = $0;
  $24 = (($23) + (($22*24)|0)|0);
  $25 = ((($24)) + 16|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = ($26|0)!=(0|0);
  if (!($27)) {
   continue;
  }
  $28 = $1;
  $29 = $0;
  $30 = (($29) + (($28*24)|0)|0);
  $31 = ((($30)) + 16|0);
  $32 = HEAP32[$31>>2]|0;
  _free($32);
 }
 $33 = $0;
 _free($33);
 STACKTOP = sp;return;
}
function _qspCopyPrepLines($dest,$src,$start,$end) {
 $dest = $dest|0;
 $src = $src|0;
 $start = $start|0;
 $end = $end|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $count = 0, $i = 0, $line = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $dest;
 $1 = $src;
 $2 = $start;
 $3 = $end;
 $4 = $3;
 $5 = $2;
 $6 = (($4) - ($5))|0;
 $count = $6;
 $7 = $1;
 $8 = ($7|0)!=(0|0);
 $9 = $count;
 $10 = ($9|0)!=(0);
 $or$cond = $8 & $10;
 if (!($or$cond)) {
  $124 = $0;
  HEAP32[$124>>2] = 0;
  STACKTOP = sp;return;
 }
 $11 = $count;
 $12 = ($11*24)|0;
 $13 = (_malloc($12)|0);
 $14 = $0;
 HEAP32[$14>>2] = $13;
 $15 = $0;
 $16 = HEAP32[$15>>2]|0;
 $line = $16;
 while(1) {
  $17 = $2;
  $18 = $3;
  $19 = ($17|0)<($18|0);
  if (!($19)) {
   break;
  }
  $20 = $2;
  $21 = $1;
  $22 = (($21) + (($20*24)|0)|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = (_qspGetNewText($23,-1)|0);
  $25 = $line;
  HEAP32[$25>>2] = $24;
  $26 = $2;
  $27 = $1;
  $28 = (($27) + (($26*24)|0)|0);
  $29 = ((($28)) + 4|0);
  $30 = HEAP32[$29>>2]|0;
  $31 = $line;
  $32 = ((($31)) + 4|0);
  HEAP32[$32>>2] = $30;
  $33 = $2;
  $34 = $1;
  $35 = (($34) + (($33*24)|0)|0);
  $36 = ((($35)) + 20|0);
  $37 = HEAP32[$36>>2]|0;
  $38 = $line;
  $39 = ((($38)) + 20|0);
  HEAP32[$39>>2] = $37;
  $count = $37;
  $40 = $count;
  $41 = ($40|0)!=(0);
  L8: do {
   if ($41) {
    $42 = $count;
    $43 = ($42*12)|0;
    $44 = (_malloc($43)|0);
    $45 = $line;
    $46 = ((($45)) + 16|0);
    HEAP32[$46>>2] = $44;
    $i = 0;
    while(1) {
     $47 = $i;
     $48 = $count;
     $49 = ($47|0)<($48|0);
     if (!($49)) {
      break L8;
     }
     $50 = $i;
     $51 = $2;
     $52 = $1;
     $53 = (($52) + (($51*24)|0)|0);
     $54 = ((($53)) + 16|0);
     $55 = HEAP32[$54>>2]|0;
     $56 = (($55) + (($50*12)|0)|0);
     $57 = HEAP32[$56>>2]|0;
     $58 = $i;
     $59 = $line;
     $60 = ((($59)) + 16|0);
     $61 = HEAP32[$60>>2]|0;
     $62 = (($61) + (($58*12)|0)|0);
     HEAP32[$62>>2] = $57;
     $63 = $i;
     $64 = $2;
     $65 = $1;
     $66 = (($65) + (($64*24)|0)|0);
     $67 = ((($66)) + 16|0);
     $68 = HEAP32[$67>>2]|0;
     $69 = (($68) + (($63*12)|0)|0);
     $70 = ((($69)) + 4|0);
     $71 = HEAP32[$70>>2]|0;
     $72 = $i;
     $73 = $line;
     $74 = ((($73)) + 16|0);
     $75 = HEAP32[$74>>2]|0;
     $76 = (($75) + (($72*12)|0)|0);
     $77 = ((($76)) + 4|0);
     HEAP32[$77>>2] = $71;
     $78 = $i;
     $79 = $2;
     $80 = $1;
     $81 = (($80) + (($79*24)|0)|0);
     $82 = ((($81)) + 16|0);
     $83 = HEAP32[$82>>2]|0;
     $84 = (($83) + (($78*12)|0)|0);
     $85 = ((($84)) + 8|0);
     $86 = HEAP32[$85>>2]|0;
     $87 = $i;
     $88 = $line;
     $89 = ((($88)) + 16|0);
     $90 = HEAP32[$89>>2]|0;
     $91 = (($90) + (($87*12)|0)|0);
     $92 = ((($91)) + 8|0);
     HEAP32[$92>>2] = $86;
     $93 = $i;
     $94 = (($93) + 1)|0;
     $i = $94;
    }
   } else {
    $95 = $line;
    $96 = ((($95)) + 16|0);
    HEAP32[$96>>2] = 0;
   }
  } while(0);
  $97 = $2;
  $98 = $1;
  $99 = (($98) + (($97*24)|0)|0);
  $100 = ((($99)) + 8|0);
  $101 = HEAP32[$100>>2]|0;
  $102 = $line;
  $103 = ((($102)) + 8|0);
  HEAP32[$103>>2] = $101;
  $104 = $2;
  $105 = $1;
  $106 = (($105) + (($104*24)|0)|0);
  $107 = ((($106)) + 12|0);
  $108 = HEAP32[$107>>2]|0;
  $109 = ($108|0)!=(0|0);
  if ($109) {
   $110 = $2;
   $111 = $1;
   $112 = (($111) + (($110*24)|0)|0);
   $113 = ((($112)) + 12|0);
   $114 = HEAP32[$113>>2]|0;
   $115 = (_qspGetNewText($114,-1)|0);
   $116 = $line;
   $117 = ((($116)) + 12|0);
   HEAP32[$117>>2] = $115;
  } else {
   $118 = $line;
   $119 = ((($118)) + 12|0);
   HEAP32[$119>>2] = 0;
  }
  $120 = $line;
  $121 = ((($120)) + 24|0);
  $line = $121;
  $122 = $2;
  $123 = (($122) + 1)|0;
  $2 = $123;
 }
 STACKTOP = sp;return;
}
function _qspJoinPrepLines($s,$count,$delim) {
 $s = $s|0;
 $count = $count|0;
 $delim = $delim|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $bufSize = 0;
 var $delimLen = 0, $i = 0, $lastIndex = 0, $txt = 0, $txtLen = 0, $txtRealLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $count;
 $2 = $delim;
 $txtLen = 0;
 $txtRealLen = 0;
 $bufSize = 256;
 $3 = $1;
 $4 = (($3) - 1)|0;
 $lastIndex = $4;
 $5 = $2;
 $6 = (_qspStrLen($5)|0);
 $delimLen = $6;
 $7 = $bufSize;
 $8 = $7<<1;
 $9 = (_malloc($8)|0);
 $txt = $9;
 $10 = $txt;
 HEAP16[$10>>1] = 0;
 $i = 0;
 while(1) {
  $11 = $i;
  $12 = $1;
  $13 = ($11|0)<($12|0);
  if (!($13)) {
   label = 9;
   break;
  }
  $14 = $i;
  $15 = $0;
  $16 = (($15) + (($14*24)|0)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_qspStrLen($17)|0);
  $19 = $txtLen;
  $20 = (($19) + ($18))|0;
  $txtLen = $20;
  $21 = $bufSize;
  $22 = ($20|0)>=($21|0);
  if ($22) {
   $23 = $txtLen;
   $24 = (($23) + 128)|0;
   $bufSize = $24;
   $25 = $txt;
   $26 = $bufSize;
   $27 = $26<<1;
   $28 = (_realloc($25,$27)|0);
   $txt = $28;
  }
  $29 = $txt;
  $30 = $txtRealLen;
  $31 = (($29) + ($30<<1)|0);
  $32 = $i;
  $33 = $0;
  $34 = (($33) + (($32*24)|0)|0);
  $35 = HEAP32[$34>>2]|0;
  (_qspStrCopy($31,$35)|0);
  $36 = $i;
  $37 = $lastIndex;
  $38 = ($36|0)==($37|0);
  if ($38) {
   label = 9;
   break;
  }
  $39 = $txtLen;
  $txtRealLen = $39;
  $40 = $delimLen;
  $41 = $txtLen;
  $42 = (($41) + ($40))|0;
  $txtLen = $42;
  $43 = $bufSize;
  $44 = ($42|0)>=($43|0);
  if ($44) {
   $45 = $txtLen;
   $46 = (($45) + 128)|0;
   $bufSize = $46;
   $47 = $txt;
   $48 = $bufSize;
   $49 = $48<<1;
   $50 = (_realloc($47,$49)|0);
   $txt = $50;
  }
  $51 = $txt;
  $52 = $txtRealLen;
  $53 = (($51) + ($52<<1)|0);
  $54 = $2;
  (_qspStrCopy($53,$54)|0);
  $55 = $txtLen;
  $txtRealLen = $55;
  $56 = $i;
  $57 = (($56) + 1)|0;
  $i = $57;
 }
 if ((label|0) == 9) {
  $58 = $txt;
  STACKTOP = sp;return ($58|0);
 }
 return (0)|0;
}
function _qspPreprocessData($data,$strs) {
 $data = $data|0;
 $strs = $strs|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $res = 0, $s = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $s = sp + 8|0;
 $0 = $data;
 $1 = $strs;
 $2 = $0;
 $3 = (_qspProcessPreformattedStrings($2,$s)|0);
 $count = $3;
 $4 = HEAP32[$s>>2]|0;
 $5 = $count;
 $6 = $1;
 $7 = (_qspProcessEOLExtensions($4,$5,$6)|0);
 $res = $7;
 $8 = HEAP32[$s>>2]|0;
 $9 = $count;
 _qspFreePrepLines($8,$9);
 $10 = $res;
 STACKTOP = sp;return ($10|0);
}
function _qspProcessPreformattedStrings($data,$strs) {
 $data = $data|0;
 $strs = $strs|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bufSize = 0, $count = 0, $isNewLine = 0, $lastLineNum = 0;
 var $line = 0, $lineNum = 0, $or$cond = 0, $quot = 0, $quotsCount = 0, $ret = 0, $str = 0, $strBufSize = 0, $strLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $data;
 $1 = $strs;
 $quot = 0;
 $lineNum = 0;
 $lastLineNum = 0;
 $count = 0;
 $quotsCount = 0;
 $strLen = 0;
 $bufSize = 8;
 $strBufSize = 256;
 $2 = $strBufSize;
 $3 = $2<<1;
 $4 = (_malloc($3)|0);
 $str = $4;
 $5 = $bufSize;
 $6 = ($5*24)|0;
 $7 = (_malloc($6)|0);
 $ret = $7;
 while(1) {
  $8 = $0;
  $9 = HEAP16[$8>>1]|0;
  $10 = ($9<<16>>16)!=(0);
  if (!($10)) {
   break;
  }
  $11 = $0;
  $12 = (_qspStrsNComp($11,446380,2)|0);
  $13 = ($12|0)==(0);
  $14 = $13&1;
  $isNewLine = $14;
  $15 = $isNewLine;
  $16 = ($15|0)!=(0);
  if ($16) {
   $17 = $lineNum;
   $18 = (($17) + 1)|0;
   $lineNum = $18;
  }
  $19 = $quotsCount;
  $20 = ($19|0)!=(0);
  if (!($20)) {
   $21 = $quot;
   $22 = $21&65535;
   $23 = ($22|0)==(0);
   $24 = $isNewLine;
   $25 = ($24|0)!=(0);
   $or$cond = $23 & $25;
   if ($or$cond) {
    $97 = $strLen;
    $98 = $str;
    $99 = (($98) + ($97<<1)|0);
    HEAP16[$99>>1] = 0;
    $100 = $count;
    $101 = (($100) + 1)|0;
    $count = $101;
    $102 = $bufSize;
    $103 = ($101|0)>($102|0);
    if ($103) {
     $104 = $bufSize;
     $105 = (($104) + 16)|0;
     $bufSize = $105;
     $106 = $ret;
     $107 = $bufSize;
     $108 = ($107*24)|0;
     $109 = (_realloc($106,$108)|0);
     $ret = $109;
    }
    $110 = $ret;
    $111 = $count;
    $112 = (($110) + (($111*24)|0)|0);
    $113 = ((($112)) + -24|0);
    $line = $113;
    $114 = $str;
    $115 = (_qspDelSpc($114)|0);
    $116 = $line;
    HEAP32[$116>>2] = $115;
    $117 = $lastLineNum;
    $118 = $line;
    $119 = ((($118)) + 4|0);
    HEAP32[$119>>2] = $117;
    $120 = $line;
    $121 = ((($120)) + 12|0);
    HEAP32[$121>>2] = 0;
    $122 = $line;
    $123 = ((($122)) + 16|0);
    HEAP32[$123>>2] = 0;
    $124 = $lineNum;
    $lastLineNum = $124;
    $strLen = 0;
    $125 = $0;
    $126 = ((($125)) + 4|0);
    $0 = $126;
    continue;
   }
  }
  $26 = $strLen;
  $27 = (($26) + 1)|0;
  $strLen = $27;
  $28 = $strBufSize;
  $29 = ($27|0)>=($28|0);
  if ($29) {
   $30 = $strBufSize;
   $31 = (($30) + 256)|0;
   $strBufSize = $31;
   $32 = $str;
   $33 = $strBufSize;
   $34 = $33<<1;
   $35 = (_realloc($32,$34)|0);
   $str = $35;
  }
  $36 = $0;
  $37 = HEAP16[$36>>1]|0;
  $38 = $strLen;
  $39 = (($38) - 1)|0;
  $40 = $str;
  $41 = (($40) + ($39<<1)|0);
  HEAP16[$41>>1] = $37;
  $42 = $quot;
  $43 = ($42<<16>>16)!=(0);
  $44 = $0;
  $45 = HEAP16[$44>>1]|0;
  $46 = $45&65535;
  do {
   if ($43) {
    $47 = $quot;
    $48 = $47&65535;
    $49 = ($46|0)==($48|0);
    if ($49) {
     $50 = $0;
     $51 = ((($50)) + 2|0);
     $52 = HEAP16[$51>>1]|0;
     $53 = $52&65535;
     $54 = $quot;
     $55 = $54&65535;
     $56 = ($53|0)==($55|0);
     if (!($56)) {
      $quot = 0;
      break;
     }
     $57 = $strLen;
     $58 = (($57) + 1)|0;
     $strLen = $58;
     $59 = $strBufSize;
     $60 = ($58|0)>=($59|0);
     if ($60) {
      $61 = $strBufSize;
      $62 = (($61) + 256)|0;
      $strBufSize = $62;
      $63 = $str;
      $64 = $strBufSize;
      $65 = $64<<1;
      $66 = (_realloc($63,$65)|0);
      $str = $66;
     }
     $67 = $0;
     $68 = ((($67)) + 2|0);
     $0 = $68;
     $69 = HEAP16[$67>>1]|0;
     $70 = $strLen;
     $71 = (($70) - 1)|0;
     $72 = $str;
     $73 = (($72) + ($71<<1)|0);
     HEAP16[$73>>1] = $69;
    }
   } else {
    $74 = HEAP16[444308>>1]|0;
    $75 = $74&65535;
    $76 = ($46|0)==($75|0);
    if ($76) {
     $77 = $quotsCount;
     $78 = (($77) + 1)|0;
     $quotsCount = $78;
     break;
    }
    $79 = $0;
    $80 = HEAP16[$79>>1]|0;
    $81 = $80&65535;
    $82 = HEAP16[444312>>1]|0;
    $83 = $82&65535;
    $84 = ($81|0)==($83|0);
    if ($84) {
     $85 = $quotsCount;
     $86 = ($85|0)!=(0);
     if (!($86)) {
      break;
     }
     $87 = $quotsCount;
     $88 = (($87) + -1)|0;
     $quotsCount = $88;
     break;
    } else {
     $89 = $0;
     $90 = HEAP16[$89>>1]|0;
     $91 = (_qspIsInList(444302,$90)|0);
     $92 = ($91|0)!=(0);
     if (!($92)) {
      break;
     }
     $93 = $0;
     $94 = HEAP16[$93>>1]|0;
     $quot = $94;
     break;
    }
   }
  } while(0);
  $95 = $0;
  $96 = ((($95)) + 2|0);
  $0 = $96;
 }
 $127 = $strLen;
 $128 = $str;
 $129 = (($128) + ($127<<1)|0);
 HEAP16[$129>>1] = 0;
 $130 = $count;
 $131 = (($130) + 1)|0;
 $count = $131;
 $132 = $bufSize;
 $133 = ($131|0)>($132|0);
 if (!($133)) {
  $138 = $ret;
  $139 = $count;
  $140 = (($138) + (($139*24)|0)|0);
  $141 = ((($140)) + -24|0);
  $line = $141;
  $142 = $str;
  $143 = (_qspDelSpc($142)|0);
  $144 = $line;
  HEAP32[$144>>2] = $143;
  $145 = $lastLineNum;
  $146 = $line;
  $147 = ((($146)) + 4|0);
  HEAP32[$147>>2] = $145;
  $148 = $line;
  $149 = ((($148)) + 12|0);
  HEAP32[$149>>2] = 0;
  $150 = $line;
  $151 = ((($150)) + 16|0);
  HEAP32[$151>>2] = 0;
  $152 = $str;
  _free($152);
  $153 = $ret;
  $154 = $1;
  HEAP32[$154>>2] = $153;
  $155 = $count;
  STACKTOP = sp;return ($155|0);
 }
 $134 = $ret;
 $135 = $count;
 $136 = ($135*24)|0;
 $137 = (_realloc($134,$136)|0);
 $ret = $137;
 $138 = $ret;
 $139 = $count;
 $140 = (($138) + (($139*24)|0)|0);
 $141 = ((($140)) + -24|0);
 $line = $141;
 $142 = $str;
 $143 = (_qspDelSpc($142)|0);
 $144 = $line;
 HEAP32[$144>>2] = $143;
 $145 = $lastLineNum;
 $146 = $line;
 $147 = ((($146)) + 4|0);
 HEAP32[$147>>2] = $145;
 $148 = $line;
 $149 = ((($148)) + 12|0);
 HEAP32[$149>>2] = 0;
 $150 = $line;
 $151 = ((($150)) + 16|0);
 HEAP32[$151>>2] = 0;
 $152 = $str;
 _free($152);
 $153 = $ret;
 $154 = $1;
 HEAP32[$154>>2] = $153;
 $155 = $count;
 STACKTOP = sp;return ($155|0);
}
function _qspProcessEOLExtensions($s,$count,$strs) {
 $s = $s|0;
 $count = $count|0;
 $strs = $strs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $bufSize = 0, $i = 0, $lastNum = 0, $len = 0, $newCount = 0, $ret = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $str = sp + 20|0;
 $0 = $s;
 $1 = $count;
 $2 = $strs;
 $lastNum = 0;
 $i = 0;
 $bufSize = 8;
 $newCount = 0;
 $3 = $bufSize;
 $4 = ($3*24)|0;
 $5 = (_malloc($4)|0);
 $ret = $5;
 while(1) {
  $6 = $i;
  $7 = $1;
  $8 = ($6|0)<($7|0);
  if (!($8)) {
   break;
  }
  $9 = $i;
  $10 = $0;
  $11 = (($10) + (($9*24)|0)|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = (_qspAddText($str,$12,0,-1,1)|0);
  $len = $13;
  $14 = $len;
  $15 = ($14>>>0)>=(2);
  L4: do {
   if ($15) {
    while(1) {
     $16 = HEAP32[$str>>2]|0;
     $17 = $len;
     $18 = (($16) + ($17<<1)|0);
     $19 = ((($18)) + -4|0);
     $20 = (_qspStrsComp($19,443164)|0);
     $21 = ($20|0)!=(0);
     $22 = $21 ^ 1;
     if (!($22)) {
      break L4;
     }
     $23 = $i;
     $24 = (($23) + 1)|0;
     $i = $24;
     $25 = $1;
     $26 = ($24|0)==($25|0);
     if ($26) {
      break L4;
     }
     $27 = $i;
     $28 = $0;
     $29 = (($28) + (($27*24)|0)|0);
     $30 = HEAP32[$29>>2]|0;
     $31 = $len;
     $32 = (($31) - 1)|0;
     $33 = (_qspAddText($str,$30,$32,-1,0)|0);
     $len = $33;
    }
   }
  } while(0);
  $34 = $newCount;
  $35 = (($34) + 1)|0;
  $newCount = $35;
  $36 = $bufSize;
  $37 = ($35|0)>($36|0);
  if ($37) {
   $38 = $bufSize;
   $39 = (($38) + 16)|0;
   $bufSize = $39;
   $40 = $ret;
   $41 = $bufSize;
   $42 = ($41*24)|0;
   $43 = (_realloc($40,$42)|0);
   $ret = $43;
  }
  $44 = $ret;
  $45 = $newCount;
  $46 = (($44) + (($45*24)|0)|0);
  $47 = ((($46)) + -24|0);
  $48 = HEAP32[$str>>2]|0;
  $49 = $lastNum;
  _qspInitLineOfCode($47,$48,$49);
  $50 = $i;
  $51 = (($50) + 1)|0;
  $i = $51;
  $52 = $i;
  $53 = $0;
  $54 = (($53) + (($52*24)|0)|0);
  $55 = ((($54)) + 4|0);
  $56 = HEAP32[$55>>2]|0;
  $lastNum = $56;
 }
 $57 = $ret;
 $58 = $2;
 HEAP32[$58>>2] = $57;
 $59 = $newCount;
 STACKTOP = sp;return ($59|0);
}
function _qspPrepareExecution() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 _qspResetError();
 HEAP32[16>>2] = 0;
 HEAP32[320520>>2] = 0;
 HEAP32[1664>>2] = 0;
 HEAP32[1660>>2] = 0;
 return;
}
function _qspMemClear($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $1 = $0;
 _qspClearIncludes($1);
 $2 = $0;
 _qspClearVars($2);
 $3 = $0;
 _qspClearObjects($3);
 $4 = $0;
 _qspClearActions($4);
 $5 = $0;
 _qspClearPlayList($5);
 $6 = $0;
 $7 = ($6|0)!=(0);
 if (!($7)) {
  $8 = HEAP32[1628>>2]|0;
  $9 = ($8|0)!=(0|0);
  if ($9) {
   $10 = HEAP32[1628>>2]|0;
   _free($10);
   $11 = HEAP32[1632>>2]|0;
   $12 = ($11|0)!=(0);
   if ($12) {
    HEAP32[1660>>2] = 1;
   }
  }
  $13 = HEAP32[1636>>2]|0;
  $14 = ($13|0)!=(0|0);
  if ($14) {
   $15 = HEAP32[1636>>2]|0;
   _free($15);
   $16 = HEAP32[1640>>2]|0;
   $17 = ($16|0)!=(0);
   if ($17) {
    HEAP32[1664>>2] = 1;
   }
  }
  $18 = HEAP32[1644>>2]|0;
  $19 = ($18|0)!=(0|0);
  if ($19) {
   $20 = HEAP32[1644>>2]|0;
   _free($20);
  }
  $21 = HEAP32[1652>>2]|0;
  $22 = ($21|0)!=(0|0);
  if ($22) {
   $23 = HEAP32[1652>>2]|0;
   _free($23);
  }
  $24 = HEAP32[12644>>2]|0;
  $25 = (($24) - 1)|0;
  $i = $25;
  while(1) {
   $26 = $i;
   $27 = ($26|0)>=(0);
   if (!($27)) {
    break;
   }
   $28 = $i;
   $29 = HEAP32[12640>>2]|0;
   $30 = (($29) + ($28<<3)|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = $i;
   $33 = HEAP32[12640>>2]|0;
   $34 = (($33) + ($32<<3)|0);
   $35 = ((($34)) + 4|0);
   $36 = HEAP32[$35>>2]|0;
   _qspClearVarsList($31,$36);
   $37 = $i;
   $38 = (($37) + -1)|0;
   $i = $38;
  }
  $39 = HEAP32[12640>>2]|0;
  $40 = ($39|0)!=(0|0);
  if ($40) {
   $41 = HEAP32[12640>>2]|0;
   _free($41);
  }
 }
 HEAP32[1628>>2] = 0;
 HEAP32[1632>>2] = 0;
 HEAP32[1636>>2] = 0;
 HEAP32[1640>>2] = 0;
 HEAP32[1644>>2] = 0;
 HEAP32[1648>>2] = 0;
 HEAP32[1652>>2] = 0;
 HEAP32[12640>>2] = 0;
 HEAP32[12644>>2] = 0;
 STACKTOP = sp;return;
}
function _qspSetSeed($seed) {
 $seed = $seed|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $seed;
 HEAP32[1676>>2] = 1;
 $1 = $0;
 HEAP32[(1680)>>2] = $1;
 $i = 2;
 while(1) {
  $2 = $i;
  $3 = ($2|0)<(55);
  if (!($3)) {
   break;
  }
  $4 = $i;
  $5 = (($4) - 1)|0;
  $6 = (1676 + ($5<<2)|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = $i;
  $9 = (($8) - 2)|0;
  $10 = (1676 + ($9<<2)|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (($7) + ($11))|0;
  $13 = $i;
  $14 = (1676 + ($13<<2)|0);
  HEAP32[$14>>2] = $12;
  $15 = $i;
  $16 = (($15) + 1)|0;
  $i = $16;
 }
 HEAP32[1896>>2] = 23;
 HEAP32[1900>>2] = 54;
 $i = 255;
 while(1) {
  $17 = $i;
  $18 = ($17|0)>=(0);
  if (!($18)) {
   break;
  }
  (_qspURand()|0);
  $19 = $i;
  $20 = (($19) + -1)|0;
  $i = $20;
 }
 $i = 255;
 while(1) {
  $21 = $i;
  $22 = ($21|0)>=(0);
  $23 = (_qspURand()|0);
  if (!($22)) {
   break;
  }
  $24 = $i;
  $25 = (1904 + ($24<<2)|0);
  HEAP32[$25>>2] = $23;
  $26 = $i;
  $27 = (($26) + -1)|0;
  $i = $27;
 }
 HEAP32[2928>>2] = $23;
 STACKTOP = sp;return;
}
function _qspRand() {
 var $$ = 0, $$1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = HEAP32[2928>>2]|0;
 $1 = $0 >>> 24;
 $i = $1;
 $2 = $i;
 $3 = (1904 + ($2<<2)|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[2928>>2] = $4;
 $5 = HEAP32[1896>>2]|0;
 $6 = (($5) + -1)|0;
 HEAP32[1896>>2] = $6;
 $7 = ($6|0)<(0);
 $$ = $7 ? 54 : $6;
 HEAP32[1896>>2] = $$;
 $8 = HEAP32[1900>>2]|0;
 $9 = (($8) + -1)|0;
 HEAP32[1900>>2] = $9;
 $10 = ($9|0)<(0);
 $$1 = $10 ? 54 : $9;
 HEAP32[1900>>2] = $$1;
 $11 = HEAP32[1896>>2]|0;
 $12 = (1676 + ($11<<2)|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = HEAP32[1900>>2]|0;
 $15 = (1676 + ($14<<2)|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = (($16) + ($13))|0;
 HEAP32[$15>>2] = $17;
 $18 = $i;
 $19 = (1904 + ($18<<2)|0);
 HEAP32[$19>>2] = $17;
 $20 = HEAP32[2928>>2]|0;
 $21 = $20 & 2147483647;
 STACKTOP = sp;return ($21|0);
}
function _qspURand() {
 var $$ = 0, $$1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[1896>>2]|0;
 $1 = (($0) + -1)|0;
 HEAP32[1896>>2] = $1;
 $2 = ($1|0)<(0);
 $$ = $2 ? 54 : $1;
 HEAP32[1896>>2] = $$;
 $3 = HEAP32[1900>>2]|0;
 $4 = (($3) + -1)|0;
 HEAP32[1900>>2] = $4;
 $5 = ($4|0)<(0);
 $$1 = $5 ? 54 : $4;
 HEAP32[1900>>2] = $$1;
 $6 = HEAP32[1896>>2]|0;
 $7 = (1676 + ($6<<2)|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = HEAP32[1900>>2]|0;
 $10 = (1676 + ($9<<2)|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($11) + ($8))|0;
 HEAP32[$10>>2] = $12;
 return ($12|0);
}
function _qspGetAbsFromRelPath($path) {
 $path = $path|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $absPath = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $path;
 $1 = HEAP32[2932>>2]|0;
 $2 = HEAP32[2936>>2]|0;
 $3 = (_qspGetNewText($1,$2)|0);
 $absPath = $3;
 $4 = $absPath;
 $5 = $0;
 $6 = HEAP32[2936>>2]|0;
 $7 = (_qspGetAddText($4,$5,$6,-1)|0);
 STACKTOP = sp;return ($7|0);
}
function _qspClearIncludes($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $i = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $1 = $0;
 $2 = ($1|0)!=(0);
 if (!($2)) {
  $i = 0;
  while(1) {
   $3 = $i;
   $4 = HEAP32[2948>>2]|0;
   $5 = ($3|0)<($4|0);
   if (!($5)) {
    break;
   }
   $6 = $i;
   $7 = (3980 + ($6<<2)|0);
   $8 = HEAP32[$7>>2]|0;
   _free($8);
   $9 = $i;
   $10 = (($9) + 1)|0;
   $i = $10;
  }
  $11 = HEAP32[2952>>2]|0;
  $12 = ($11|0)!=(0);
  if ($12) {
   $13 = HEAP32[320496>>2]|0;
   $14 = HEAP32[2952>>2]|0;
   $15 = (($13) - ($14))|0;
   $count = $15;
   $16 = $count;
   $17 = $count;
   _qspCreateWorld($16,$17);
   _qspPrepareLocs();
  }
 }
 HEAP32[2948>>2] = 0;
 HEAP32[2952>>2] = 0;
 STACKTOP = sp;return;
}
function _qspNewGame($isReset) {
 $isReset = $isReset|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isReset;
 $1 = HEAP32[320496>>2]|0;
 $2 = ($1|0)!=(0);
 if (!($2)) {
  _qspSetError(106);
  STACKTOP = sp;return;
 }
 HEAP32[320500>>2] = 0;
 $3 = $0;
 $4 = ($3|0)!=(0);
 if ($4) {
  $5 = (_time((0|0))|0);
  _qspSetSeed($5);
  HEAP32[1656>>2] = 500;
  HEAP32[1672>>2] = 1;
  HEAP32[1668>>2] = 1;
  HEAP32[20>>2] = 1;
  HEAP32[320524>>2] = 1;
  _qspMemClear(0);
  _qspResetTime(0);
  _qspCallShowWindow(0,1);
  _qspCallShowWindow(1,1);
  _qspCallShowWindow(2,1);
  _qspCallShowWindow(3,1);
  _qspCallSetInputStrText(0);
  _qspCallShowPicture(0);
  _qspCallCloseFile(0);
  _qspCallSetTimer(500);
 }
 _qspRefreshCurLoc(1,0,0);
 STACKTOP = sp;return;
}
function _qspOpenQuestFromData($data,$dataSize,$fileName,$isAddLocs) {
 $data = $data|0;
 $dataSize = $dataSize|0;
 $fileName = $fileName|0;
 $isAddLocs = $isAddLocs|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $actsCount = 0, $buf = 0, $count = 0;
 var $crc = 0, $delim = 0, $end = 0, $i = 0, $ind = 0, $isAddLoc = 0, $isOldFormat = 0, $isUCS2 = 0, $j = 0, $locsCount = 0, $start = 0, $strs = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $strs = sp;
 $0 = $data;
 $1 = $dataSize;
 $2 = $fileName;
 $3 = $isAddLocs;
 $4 = $1;
 $5 = ($4|0)<(2);
 if ($5) {
  _qspSetError(105);
  STACKTOP = sp;return;
 }
 $6 = $3;
 $7 = ($6|0)!=(0);
 if (!($7)) {
  $8 = $0;
  $9 = $1;
  $10 = (_qspCRC($8,$9)|0);
  $crc = $10;
 }
 $11 = $0;
 $12 = $0;
 $13 = ((($12)) + 1|0);
 $14 = HEAP8[$13>>0]|0;
 $15 = ($14<<24>>24)!=(0);
 $16 = $15 ^ 1;
 $17 = $16&1;
 $isUCS2 = $17;
 $18 = (_qspSplitGameStr($11,$17,446380,$strs)|0);
 $count = $18;
 $19 = HEAP32[$strs>>2]|0;
 $20 = $count;
 $21 = $isUCS2;
 $22 = (_qspCheckQuest($19,$20,$21)|0);
 $23 = ($22|0)!=(0);
 if (!($23)) {
  _qspSetError(105);
  $24 = HEAP32[$strs>>2]|0;
  $25 = $count;
  _qspFreeStrs($24,$25);
  STACKTOP = sp;return;
 }
 $26 = HEAP32[$strs>>2]|0;
 $27 = HEAP32[$26>>2]|0;
 $28 = $isUCS2;
 $29 = (_qspGameToQSPString($27,$28,0)|0);
 $buf = $29;
 $30 = $buf;
 $31 = (_qspStrsComp($30,443170)|0);
 $32 = ($31|0)!=(0);
 $33 = $32&1;
 $isOldFormat = $33;
 $34 = $buf;
 _free($34);
 $35 = $isOldFormat;
 $36 = ($35|0)!=(0);
 $37 = HEAP32[$strs>>2]|0;
 if ($36) {
  $38 = HEAP32[$37>>2]|0;
  $39 = $isUCS2;
  $40 = (_qspGameToQSPString($38,$39,0)|0);
  $45 = $40;
 } else {
  $41 = ((($37)) + 12|0);
  $42 = HEAP32[$41>>2]|0;
  $43 = $isUCS2;
  $44 = (_qspGameToQSPString($42,$43,1)|0);
  $45 = $44;
 }
 $buf = $45;
 $46 = $buf;
 $47 = (_qspStrToNum($46,0)|0);
 $locsCount = $47;
 $48 = $buf;
 _free($48);
 $49 = $3;
 $50 = ($49|0)!=(0);
 if ($50) {
  $51 = HEAP32[320496>>2]|0;
  $start = $51;
  $52 = $start;
  $53 = $locsCount;
  $54 = (($52) + ($53))|0;
  $end = $54;
 } else {
  _qspClearIncludes(0);
  $start = 0;
  $55 = $locsCount;
  $end = $55;
 }
 $56 = HEAP32[320496>>2]|0;
 $locsCount = $56;
 $57 = $start;
 $58 = $end;
 _qspCreateWorld($57,$58);
 $59 = $locsCount;
 HEAP32[320496>>2] = $59;
 $60 = $start;
 $locsCount = $60;
 $61 = $isOldFormat;
 $62 = ($61|0)!=(0);
 $63 = $62 ? 30 : 4;
 $ind = $63;
 $64 = $start;
 $i = $64;
 while(1) {
  $65 = $i;
  $66 = $end;
  $67 = ($65|0)<($66|0);
  if (!($67)) {
   break;
  }
  $68 = $ind;
  $69 = (($68) + 1)|0;
  $ind = $69;
  $70 = HEAP32[$strs>>2]|0;
  $71 = (($70) + ($68<<2)|0);
  $72 = HEAP32[$71>>2]|0;
  $73 = $isUCS2;
  $74 = (_qspGameToQSPString($72,$73,1)|0);
  $buf = $74;
  $75 = $3;
  $76 = ($75|0)!=(0);
  if ($76) {
   $77 = $buf;
   $78 = (_qspLocIndex($77)|0);
   $79 = ($78|0)<(0);
   $81 = $79;
  } else {
   $81 = 1;
  }
  $80 = $81&1;
  $isAddLoc = $80;
  $82 = $buf;
  if ($81) {
   $83 = $locsCount;
   $84 = HEAP32[320488>>2]|0;
   $85 = (($84) + (($83*816)|0)|0);
   HEAP32[$85>>2] = $82;
  } else {
   _free($82);
  }
  $86 = $isAddLoc;
  $87 = ($86|0)!=(0);
  $88 = $ind;
  if ($87) {
   $89 = (($88) + 1)|0;
   $ind = $89;
   $90 = HEAP32[$strs>>2]|0;
   $91 = (($90) + ($88<<2)|0);
   $92 = HEAP32[$91>>2]|0;
   $93 = $isUCS2;
   $94 = (_qspGameToQSPString($92,$93,1)|0);
   $95 = $locsCount;
   $96 = HEAP32[320488>>2]|0;
   $97 = (($96) + (($95*816)|0)|0);
   $98 = ((($97)) + 4|0);
   HEAP32[$98>>2] = $94;
   $99 = $ind;
   $100 = (($99) + 1)|0;
   $ind = $100;
   $101 = HEAP32[$strs>>2]|0;
   $102 = (($101) + ($99<<2)|0);
   $103 = HEAP32[$102>>2]|0;
   $104 = $isUCS2;
   $105 = (_qspGameToQSPString($103,$104,1)|0);
   $buf = $105;
   $106 = $buf;
   $107 = $locsCount;
   $108 = HEAP32[320488>>2]|0;
   $109 = (($108) + (($107*816)|0)|0);
   $110 = ((($109)) + 8|0);
   $111 = (_qspPreprocessData($106,$110)|0);
   $112 = $locsCount;
   $113 = HEAP32[320488>>2]|0;
   $114 = (($113) + (($112*816)|0)|0);
   $115 = ((($114)) + 12|0);
   HEAP32[$115>>2] = $111;
   $116 = $buf;
   _free($116);
  } else {
   $117 = (($88) + 2)|0;
   $ind = $117;
  }
  $118 = $isOldFormat;
  $119 = ($118|0)!=(0);
  if ($119) {
   $actsCount = 20;
  } else {
   $120 = $ind;
   $121 = (($120) + 1)|0;
   $ind = $121;
   $122 = HEAP32[$strs>>2]|0;
   $123 = (($122) + ($120<<2)|0);
   $124 = HEAP32[$123>>2]|0;
   $125 = $isUCS2;
   $126 = (_qspGameToQSPString($124,$125,1)|0);
   $buf = $126;
   $127 = $buf;
   $128 = (_qspStrToNum($127,0)|0);
   $actsCount = $128;
   $129 = $buf;
   _free($129);
  }
  $130 = $isAddLoc;
  $131 = ($130|0)!=(0);
  if ($131) {
   $j = 0;
   while(1) {
    $132 = $j;
    $133 = $actsCount;
    $134 = ($132|0)<($133|0);
    if (!($134)) {
     break;
    }
    $135 = $isOldFormat;
    $136 = ($135|0)!=(0);
    if ($136) {
     $150 = 0;
    } else {
     $137 = $ind;
     $138 = (($137) + 1)|0;
     $ind = $138;
     $139 = HEAP32[$strs>>2]|0;
     $140 = (($139) + ($137<<2)|0);
     $141 = HEAP32[$140>>2]|0;
     $142 = $isUCS2;
     $143 = (_qspGameToQSPString($141,$142,1)|0);
     $150 = $143;
    }
    $144 = $j;
    $145 = $locsCount;
    $146 = HEAP32[320488>>2]|0;
    $147 = (($146) + (($145*816)|0)|0);
    $148 = ((($147)) + 16|0);
    $149 = (($148) + ($144<<4)|0);
    HEAP32[$149>>2] = $150;
    $151 = $ind;
    $152 = (($151) + 1)|0;
    $ind = $152;
    $153 = HEAP32[$strs>>2]|0;
    $154 = (($153) + ($151<<2)|0);
    $155 = HEAP32[$154>>2]|0;
    $156 = $isUCS2;
    $157 = (_qspGameToQSPString($155,$156,1)|0);
    $158 = $j;
    $159 = $locsCount;
    $160 = HEAP32[320488>>2]|0;
    $161 = (($160) + (($159*816)|0)|0);
    $162 = ((($161)) + 16|0);
    $163 = (($162) + ($158<<4)|0);
    $164 = ((($163)) + 4|0);
    HEAP32[$164>>2] = $157;
    $165 = $ind;
    $166 = (($165) + 1)|0;
    $ind = $166;
    $167 = HEAP32[$strs>>2]|0;
    $168 = (($167) + ($165<<2)|0);
    $169 = HEAP32[$168>>2]|0;
    $170 = $isUCS2;
    $171 = (_qspGameToQSPString($169,$170,1)|0);
    $buf = $171;
    $172 = $buf;
    $173 = $j;
    $174 = $locsCount;
    $175 = HEAP32[320488>>2]|0;
    $176 = (($175) + (($174*816)|0)|0);
    $177 = ((($176)) + 16|0);
    $178 = (($177) + ($173<<4)|0);
    $179 = ((($178)) + 8|0);
    $180 = (_qspPreprocessData($172,$179)|0);
    $181 = $j;
    $182 = $locsCount;
    $183 = HEAP32[320488>>2]|0;
    $184 = (($183) + (($182*816)|0)|0);
    $185 = ((($184)) + 16|0);
    $186 = (($185) + ($181<<4)|0);
    $187 = ((($186)) + 12|0);
    HEAP32[$187>>2] = $180;
    $188 = $buf;
    _free($188);
    $189 = $j;
    $190 = (($189) + 1)|0;
    $j = $190;
   }
   $191 = $locsCount;
   $192 = (($191) + 1)|0;
   $locsCount = $192;
  } else {
   $193 = $actsCount;
   $194 = $isOldFormat;
   $195 = ($194|0)!=(0);
   $196 = $195 ? 2 : 3;
   $197 = Math_imul($193, $196)|0;
   $198 = $ind;
   $199 = (($198) + ($197))|0;
   $ind = $199;
  }
  $200 = $i;
  $201 = (($200) + 1)|0;
  $i = $201;
 }
 $202 = HEAP32[$strs>>2]|0;
 $203 = $count;
 _qspFreeStrs($202,$203);
 $204 = $end;
 HEAP32[320496>>2] = $204;
 $205 = $end;
 $206 = $locsCount;
 _qspCreateWorld($205,$206);
 $207 = $locsCount;
 $208 = $start;
 $209 = (($207) - ($208))|0;
 $count = $209;
 $210 = $count;
 $211 = ($210|0)!=(0);
 if ($211) {
  _qspPrepareLocs();
 }
 $212 = $3;
 $213 = ($212|0)!=(0);
 if ($213) {
  $214 = $count;
  $215 = HEAP32[2952>>2]|0;
  $216 = (($215) + ($214))|0;
  HEAP32[2952>>2] = $216;
  STACKTOP = sp;return;
 }
 $217 = HEAP32[2940>>2]|0;
 $218 = $2;
 $219 = (_qspGetAddText($217,$218,0,-1)|0);
 HEAP32[2940>>2] = $219;
 $220 = HEAP32[2940>>2]|0;
 $221 = (_qspInStrRChars($220,444380,0)|0);
 $delim = $221;
 $222 = $delim;
 $223 = ($222|0)!=(0|0);
 if ($223) {
  $224 = $delim;
  $225 = HEAP32[2940>>2]|0;
  $226 = $224;
  $227 = $225;
  $228 = (($226) - ($227))|0;
  $229 = (($228|0) / 2)&-1;
  $230 = (($229) + 1)|0;
  $231 = $230;
 } else {
  $231 = 0;
 }
 HEAP32[2936>>2] = $231;
 $232 = HEAP32[2932>>2]|0;
 $233 = HEAP32[2940>>2]|0;
 $234 = HEAP32[2936>>2]|0;
 $235 = (_qspGetAddText($232,$233,0,$234)|0);
 HEAP32[2932>>2] = $235;
 $236 = $crc;
 HEAP32[2944>>2] = $236;
 HEAP32[320500>>2] = -1;
 STACKTOP = sp;return;
}
function _qspOpenQuest($fileName,$isAddLocs) {
 $fileName = $fileName|0;
 $isAddLocs = $isAddLocs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $f = 0, $fileSize = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $fileName;
 $1 = $isAddLocs;
 $2 = $0;
 $3 = (_qspFileOpen($2,443186)|0);
 $f = $3;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = $f;
  (_fseek($5,0,2)|0);
  $6 = $f;
  $7 = (_ftell($6)|0);
  $fileSize = $7;
  $8 = $fileSize;
  $9 = (($8) + 3)|0;
  $10 = (_malloc($9)|0);
  $buf = $10;
  $11 = $f;
  (_fseek($11,0,0)|0);
  $12 = $buf;
  $13 = $fileSize;
  $14 = $f;
  (_fread($12,1,$13,$14)|0);
  $15 = $f;
  (_fclose($15)|0);
  $16 = $fileSize;
  $17 = (($16) + 2)|0;
  $18 = $buf;
  $19 = (($18) + ($17)|0);
  HEAP8[$19>>0] = 0;
  $20 = $fileSize;
  $21 = (($20) + 1)|0;
  $22 = $buf;
  $23 = (($22) + ($21)|0);
  HEAP8[$23>>0] = 0;
  $24 = $fileSize;
  $25 = $buf;
  $26 = (($25) + ($24)|0);
  HEAP8[$26>>0] = 0;
  $27 = $buf;
  $28 = $fileSize;
  $29 = (($28) + 3)|0;
  $30 = $0;
  $31 = $1;
  _qspOpenQuestFromData($27,$29,$30,$31);
  $32 = $buf;
  _free($32);
  STACKTOP = sp;return;
 } else {
  _qspSetError(104);
  STACKTOP = sp;return;
 }
}
function _qspSaveGameStatusToString($buf) {
 $buf = $buf|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $j = 0, $len = 0;
 var $locName = 0, $oldRefreshCount = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $buf;
 $2 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $2;
 _qspExecLocByVarNameWithArgs(443192,0,0);
 $3 = HEAP32[320504>>2]|0;
 $4 = $oldRefreshCount;
 $5 = ($3|0)!=($4|0);
 $6 = HEAP32[320460>>2]|0;
 $7 = ($6|0)!=(0);
 $or$cond = $5 | $7;
 if ($or$cond) {
  $0 = 0;
  $316 = $0;
  STACKTOP = sp;return ($316|0);
 }
 $8 = $1;
 HEAP32[$8>>2] = 0;
 _qspRefreshPlayList();
 $9 = HEAP32[320500>>2]|0;
 $10 = ($9|0)>=(0);
 if ($10) {
  $11 = HEAP32[320500>>2]|0;
  $12 = HEAP32[320488>>2]|0;
  $13 = (($12) + (($11*816)|0)|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = $14;
 } else {
  $15 = 0;
 }
 $locName = $15;
 $16 = $1;
 $17 = (_qspCodeWriteVal($16,0,443208,0)|0);
 $len = $17;
 $18 = $1;
 $19 = $len;
 $20 = (_qspCodeWriteVal($18,$19,447356,0)|0);
 $len = $20;
 $21 = $1;
 $22 = $len;
 $23 = HEAP32[2944>>2]|0;
 $24 = (_qspCodeWriteIntVal($21,$22,$23,1)|0);
 $len = $24;
 $25 = $1;
 $26 = $len;
 $27 = (_qspGetTime()|0);
 $28 = (_qspCodeWriteIntVal($25,$26,$27,1)|0);
 $len = $28;
 $29 = $1;
 $30 = $len;
 $31 = HEAP32[12>>2]|0;
 $32 = (_qspCodeWriteIntVal($29,$30,$31,1)|0);
 $len = $32;
 $33 = $1;
 $34 = $len;
 $35 = HEAP32[320516>>2]|0;
 $36 = (_qspCodeWriteIntVal($33,$34,$35,1)|0);
 $len = $36;
 $37 = $1;
 $38 = $len;
 $39 = HEAP32[1652>>2]|0;
 $40 = (_qspCodeWriteVal($37,$38,$39,1)|0);
 $len = $40;
 $41 = $1;
 $42 = $len;
 $43 = HEAP32[1644>>2]|0;
 $44 = (_qspCodeWriteVal($41,$42,$43,1)|0);
 $len = $44;
 $45 = $1;
 $46 = $len;
 $47 = HEAP32[1628>>2]|0;
 $48 = (_qspCodeWriteVal($45,$46,$47,1)|0);
 $len = $48;
 $49 = $1;
 $50 = $len;
 $51 = HEAP32[1636>>2]|0;
 $52 = (_qspCodeWriteVal($49,$50,$51,1)|0);
 $len = $52;
 $53 = $1;
 $54 = $len;
 $55 = $locName;
 $56 = (_qspCodeWriteVal($53,$54,$55,1)|0);
 $len = $56;
 $57 = $1;
 $58 = $len;
 $59 = HEAP32[20>>2]|0;
 $60 = (_qspCodeWriteIntVal($57,$58,$59,1)|0);
 $len = $60;
 $61 = $1;
 $62 = $len;
 $63 = HEAP32[320524>>2]|0;
 $64 = (_qspCodeWriteIntVal($61,$62,$63,1)|0);
 $len = $64;
 $65 = $1;
 $66 = $len;
 $67 = HEAP32[1668>>2]|0;
 $68 = (_qspCodeWriteIntVal($65,$66,$67,1)|0);
 $len = $68;
 $69 = $1;
 $70 = $len;
 $71 = HEAP32[1672>>2]|0;
 $72 = (_qspCodeWriteIntVal($69,$70,$71,1)|0);
 $len = $72;
 $73 = $1;
 $74 = $len;
 $75 = HEAP32[1656>>2]|0;
 $76 = (_qspCodeWriteIntVal($73,$74,$75,1)|0);
 $len = $76;
 $77 = $1;
 $78 = $len;
 $79 = HEAP32[10636>>2]|0;
 $80 = (_qspCodeWriteIntVal($77,$78,$79,1)|0);
 $len = $80;
 $i = 0;
 while(1) {
  $81 = $i;
  $82 = HEAP32[10636>>2]|0;
  $83 = ($81|0)<($82|0);
  $84 = $1;
  $85 = $len;
  if (!($83)) {
   break;
  }
  $86 = $i;
  $87 = (10640 + ($86<<2)|0);
  $88 = HEAP32[$87>>2]|0;
  $89 = (_qspCodeWriteVal($84,$85,$88,1)|0);
  $len = $89;
  $90 = $i;
  $91 = (($90) + 1)|0;
  $i = $91;
 }
 $92 = HEAP32[2948>>2]|0;
 $93 = (_qspCodeWriteIntVal($84,$85,$92,1)|0);
 $len = $93;
 $i = 0;
 while(1) {
  $94 = $i;
  $95 = HEAP32[2948>>2]|0;
  $96 = ($94|0)<($95|0);
  $97 = $1;
  $98 = $len;
  if (!($96)) {
   break;
  }
  $99 = $i;
  $100 = (3980 + ($99<<2)|0);
  $101 = HEAP32[$100>>2]|0;
  $102 = (_qspCodeWriteVal($97,$98,$101,1)|0);
  $len = $102;
  $103 = $i;
  $104 = (($103) + 1)|0;
  $i = $104;
 }
 $105 = HEAP32[8>>2]|0;
 $106 = (_qspCodeWriteIntVal($97,$98,$105,1)|0);
 $len = $106;
 $i = 0;
 while(1) {
  $107 = $i;
  $108 = HEAP32[8>>2]|0;
  $109 = ($107|0)<($108|0);
  if (!($109)) {
   break;
  }
  $110 = $i;
  $111 = (24 + ($110<<5)|0);
  $112 = HEAP32[$111>>2]|0;
  $113 = ($112|0)!=(0|0);
  $114 = $1;
  $115 = $len;
  if ($113) {
   $116 = $i;
   $117 = (24 + ($116<<5)|0);
   $118 = HEAP32[$117>>2]|0;
   $119 = HEAP32[2936>>2]|0;
   $120 = (($118) + ($119<<1)|0);
   $121 = (_qspCodeWriteVal($114,$115,$120,1)|0);
   $len = $121;
  } else {
   $122 = (_qspCodeWriteVal($114,$115,0,0)|0);
   $len = $122;
  }
  $123 = $1;
  $124 = $len;
  $125 = $i;
  $126 = (24 + ($125<<5)|0);
  $127 = ((($126)) + 4|0);
  $128 = HEAP32[$127>>2]|0;
  $129 = (_qspCodeWriteVal($123,$124,$128,1)|0);
  $len = $129;
  $130 = $1;
  $131 = $len;
  $132 = $i;
  $133 = (24 + ($132<<5)|0);
  $134 = ((($133)) + 12|0);
  $135 = HEAP32[$134>>2]|0;
  $136 = (_qspCodeWriteIntVal($130,$131,$135,1)|0);
  $len = $136;
  $j = 0;
  while(1) {
   $137 = $j;
   $138 = $i;
   $139 = (24 + ($138<<5)|0);
   $140 = ((($139)) + 12|0);
   $141 = HEAP32[$140>>2]|0;
   $142 = ($137|0)<($141|0);
   $143 = $1;
   $144 = $len;
   if (!($142)) {
    break;
   }
   $145 = $j;
   $146 = $i;
   $147 = (24 + ($146<<5)|0);
   $148 = ((($147)) + 8|0);
   $149 = HEAP32[$148>>2]|0;
   $150 = (($149) + (($145*24)|0)|0);
   $151 = HEAP32[$150>>2]|0;
   $152 = (_qspCodeWriteVal($143,$144,$151,1)|0);
   $len = $152;
   $153 = $1;
   $154 = $len;
   $155 = $j;
   $156 = $i;
   $157 = (24 + ($156<<5)|0);
   $158 = ((($157)) + 8|0);
   $159 = HEAP32[$158>>2]|0;
   $160 = (($159) + (($155*24)|0)|0);
   $161 = ((($160)) + 4|0);
   $162 = HEAP32[$161>>2]|0;
   $163 = (_qspCodeWriteIntVal($153,$154,$162,1)|0);
   $len = $163;
   $164 = $j;
   $165 = (($164) + 1)|0;
   $j = $165;
  }
  $166 = $i;
  $167 = (24 + ($166<<5)|0);
  $168 = ((($167)) + 16|0);
  $169 = HEAP32[$168>>2]|0;
  $170 = (_qspCodeWriteIntVal($143,$144,$169,1)|0);
  $len = $170;
  $171 = $1;
  $172 = $len;
  $173 = $i;
  $174 = (24 + ($173<<5)|0);
  $175 = ((($174)) + 20|0);
  $176 = HEAP32[$175>>2]|0;
  $177 = (_qspCodeWriteIntVal($171,$172,$176,1)|0);
  $len = $177;
  $178 = $1;
  $179 = $len;
  $180 = $i;
  $181 = (24 + ($180<<5)|0);
  $182 = ((($181)) + 24|0);
  $183 = HEAP32[$182>>2]|0;
  $184 = (_qspCodeWriteIntVal($178,$179,$183,1)|0);
  $len = $184;
  $185 = $1;
  $186 = $len;
  $187 = $i;
  $188 = (24 + ($187<<5)|0);
  $189 = ((($188)) + 28|0);
  $190 = HEAP32[$189>>2]|0;
  $191 = (_qspCodeWriteIntVal($185,$186,$190,1)|0);
  $len = $191;
  $192 = $i;
  $193 = (($192) + 1)|0;
  $i = $193;
 }
 $194 = $1;
 $195 = $len;
 $196 = HEAP32[320512>>2]|0;
 $197 = (_qspCodeWriteIntVal($194,$195,$196,1)|0);
 $len = $197;
 $i = 0;
 while(1) {
  $198 = $i;
  $199 = HEAP32[320512>>2]|0;
  $200 = ($198|0)<($199|0);
  if (!($200)) {
   break;
  }
  $201 = $i;
  $202 = (320528 + ($201<<3)|0);
  $203 = HEAP32[$202>>2]|0;
  $204 = ($203|0)!=(0|0);
  $205 = $1;
  $206 = $len;
  if ($204) {
   $207 = $i;
   $208 = (320528 + ($207<<3)|0);
   $209 = HEAP32[$208>>2]|0;
   $210 = HEAP32[2936>>2]|0;
   $211 = (($209) + ($210<<1)|0);
   $212 = (_qspCodeWriteVal($205,$206,$211,1)|0);
   $len = $212;
  } else {
   $213 = (_qspCodeWriteVal($205,$206,0,0)|0);
   $len = $213;
  }
  $214 = $1;
  $215 = $len;
  $216 = $i;
  $217 = (320528 + ($216<<3)|0);
  $218 = ((($217)) + 4|0);
  $219 = HEAP32[$218>>2]|0;
  $220 = (_qspCodeWriteVal($214,$215,$219,1)|0);
  $len = $220;
  $221 = $i;
  $222 = (($221) + 1)|0;
  $i = $222;
 }
 $223 = $1;
 $224 = $len;
 $225 = (_qspGetVarsCount()|0);
 $226 = (_qspCodeWriteIntVal($223,$224,$225,1)|0);
 $len = $226;
 $i = 0;
 while(1) {
  $227 = $i;
  $228 = ($227|0)<(12800);
  if (!($228)) {
   break;
  }
  $229 = $i;
  $230 = (12648 + (($229*24)|0)|0);
  $231 = HEAP32[$230>>2]|0;
  $232 = ($231|0)!=(0|0);
  L39: do {
   if ($232) {
    $233 = $1;
    $234 = $len;
    $235 = $i;
    $236 = (_qspCodeWriteIntVal($233,$234,$235,1)|0);
    $len = $236;
    $237 = $1;
    $238 = $len;
    $239 = $i;
    $240 = (12648 + (($239*24)|0)|0);
    $241 = HEAP32[$240>>2]|0;
    $242 = (_qspCodeWriteVal($237,$238,$241,1)|0);
    $len = $242;
    $243 = $1;
    $244 = $len;
    $245 = $i;
    $246 = (12648 + (($245*24)|0)|0);
    $247 = ((($246)) + 8|0);
    $248 = HEAP32[$247>>2]|0;
    $249 = (_qspCodeWriteIntVal($243,$244,$248,1)|0);
    $len = $249;
    $j = 0;
    while(1) {
     $250 = $j;
     $251 = $i;
     $252 = (12648 + (($251*24)|0)|0);
     $253 = ((($252)) + 8|0);
     $254 = HEAP32[$253>>2]|0;
     $255 = ($250|0)<($254|0);
     $256 = $1;
     $257 = $len;
     if (!($255)) {
      break;
     }
     $258 = $j;
     $259 = $i;
     $260 = (12648 + (($259*24)|0)|0);
     $261 = ((($260)) + 4|0);
     $262 = HEAP32[$261>>2]|0;
     $263 = (($262) + ($258<<3)|0);
     $264 = HEAP32[$263>>2]|0;
     $265 = (_qspCodeWriteIntVal($256,$257,$264,1)|0);
     $len = $265;
     $266 = $1;
     $267 = $len;
     $268 = $j;
     $269 = $i;
     $270 = (12648 + (($269*24)|0)|0);
     $271 = ((($270)) + 4|0);
     $272 = HEAP32[$271>>2]|0;
     $273 = (($272) + ($268<<3)|0);
     $274 = ((($273)) + 4|0);
     $275 = HEAP32[$274>>2]|0;
     $276 = (_qspCodeWriteVal($266,$267,$275,1)|0);
     $len = $276;
     $277 = $j;
     $278 = (($277) + 1)|0;
     $j = $278;
    }
    $279 = $i;
    $280 = (12648 + (($279*24)|0)|0);
    $281 = ((($280)) + 16|0);
    $282 = HEAP32[$281>>2]|0;
    $283 = (_qspCodeWriteIntVal($256,$257,$282,1)|0);
    $len = $283;
    $j = 0;
    while(1) {
     $284 = $j;
     $285 = $i;
     $286 = (12648 + (($285*24)|0)|0);
     $287 = ((($286)) + 16|0);
     $288 = HEAP32[$287>>2]|0;
     $289 = ($284|0)<($288|0);
     if (!($289)) {
      break L39;
     }
     $290 = $1;
     $291 = $len;
     $292 = $j;
     $293 = $i;
     $294 = (12648 + (($293*24)|0)|0);
     $295 = ((($294)) + 12|0);
     $296 = HEAP32[$295>>2]|0;
     $297 = (($296) + ($292<<3)|0);
     $298 = HEAP32[$297>>2]|0;
     $299 = (_qspCodeWriteIntVal($290,$291,$298,1)|0);
     $len = $299;
     $300 = $1;
     $301 = $len;
     $302 = $j;
     $303 = $i;
     $304 = (12648 + (($303*24)|0)|0);
     $305 = ((($304)) + 12|0);
     $306 = HEAP32[$305>>2]|0;
     $307 = (($306) + ($302<<3)|0);
     $308 = ((($307)) + 4|0);
     $309 = HEAP32[$308>>2]|0;
     $310 = (_qspCodeWriteVal($300,$301,$309,1)|0);
     $len = $310;
     $311 = $j;
     $312 = (($311) + 1)|0;
     $j = $312;
    }
   }
  } while(0);
  $313 = $i;
  $314 = (($313) + 1)|0;
  $i = $314;
 }
 $315 = $len;
 $0 = $315;
 $316 = $0;
 STACKTOP = sp;return ($316|0);
}
function _qspSaveGameStatus($fileName) {
 $fileName = $fileName|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $f = 0, $len = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $buf = sp;
 $0 = $fileName;
 $1 = $0;
 $2 = (_qspFileOpen($1,443234)|0);
 $f = $2;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  _qspSetError(104);
  STACKTOP = sp;return;
 }
 $4 = (_qspSaveGameStatusToString($buf)|0);
 $len = $4;
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = HEAP32[$buf>>2]|0;
  $7 = $len;
  $8 = $f;
  (_fwrite($6,2,$7,$8)|0);
  $9 = HEAP32[$buf>>2]|0;
  _free($9);
 }
 $10 = $f;
 (_fclose($10)|0);
 STACKTOP = sp;return;
}
function _qspOpenGameStatusFromString($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0;
 var $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0;
 var $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0;
 var $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0;
 var $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0;
 var $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0;
 var $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $count = 0, $file = 0, $i = 0, $ind = 0, $j = 0, $locName = 0, $strs = 0, $valsCount = 0, $varInd = 0, $varsCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $strs = sp + 8|0;
 $0 = $str;
 $1 = $0;
 $2 = (_qspSplitStr($1,446380,$strs)|0);
 $count = $2;
 $3 = HEAP32[$strs>>2]|0;
 $4 = $count;
 $5 = (_qspCheckGameStatus($3,$4)|0);
 $6 = ($5|0)!=(0);
 if (!($6)) {
  _qspSetError(105);
  $7 = HEAP32[$strs>>2]|0;
  $8 = $count;
  _qspFreeStrs($7,$8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[320504>>2]|0;
 $10 = (($9) + 1)|0;
 HEAP32[320504>>2] = $10;
 $11 = HEAP32[320508>>2]|0;
 $12 = (($11) + 1)|0;
 HEAP32[320508>>2] = $12;
 _qspMemClear(0);
 $13 = HEAP32[$strs>>2]|0;
 $14 = ((($13)) + 12|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_qspReCodeGetIntVal($15)|0);
 _qspResetTime($16);
 $17 = HEAP32[$strs>>2]|0;
 $18 = ((($17)) + 16|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = (_qspReCodeGetIntVal($19)|0);
 HEAP32[12>>2] = $20;
 $21 = HEAP32[$strs>>2]|0;
 $22 = ((($21)) + 20|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = (_qspReCodeGetIntVal($23)|0);
 HEAP32[320516>>2] = $24;
 $25 = HEAP32[$strs>>2]|0;
 $26 = ((($25)) + 24|0);
 $27 = HEAP32[$26>>2]|0;
 $28 = HEAP16[$27>>1]|0;
 $29 = ($28<<16>>16)!=(0);
 if ($29) {
  $30 = HEAP32[$strs>>2]|0;
  $31 = ((($30)) + 24|0);
  $32 = HEAP32[$31>>2]|0;
  $33 = (_qspCodeReCode($32,0)|0);
  HEAP32[1652>>2] = $33;
 }
 $34 = HEAP32[$strs>>2]|0;
 $35 = ((($34)) + 28|0);
 $36 = HEAP32[$35>>2]|0;
 $37 = HEAP16[$36>>1]|0;
 $38 = ($37<<16>>16)!=(0);
 if ($38) {
  $39 = HEAP32[$strs>>2]|0;
  $40 = ((($39)) + 28|0);
  $41 = HEAP32[$40>>2]|0;
  $42 = (_qspCodeReCode($41,0)|0);
  HEAP32[1644>>2] = $42;
  $43 = (_qspStrLen($42)|0);
  HEAP32[1648>>2] = $43;
 }
 $44 = HEAP32[$strs>>2]|0;
 $45 = ((($44)) + 32|0);
 $46 = HEAP32[$45>>2]|0;
 $47 = HEAP16[$46>>1]|0;
 $48 = ($47<<16>>16)!=(0);
 if ($48) {
  $49 = HEAP32[$strs>>2]|0;
  $50 = ((($49)) + 32|0);
  $51 = HEAP32[$50>>2]|0;
  $52 = (_qspCodeReCode($51,0)|0);
  HEAP32[1628>>2] = $52;
  $53 = (_qspStrLen($52)|0);
  HEAP32[1632>>2] = $53;
 }
 $54 = HEAP32[$strs>>2]|0;
 $55 = ((($54)) + 36|0);
 $56 = HEAP32[$55>>2]|0;
 $57 = HEAP16[$56>>1]|0;
 $58 = ($57<<16>>16)!=(0);
 if ($58) {
  $59 = HEAP32[$strs>>2]|0;
  $60 = ((($59)) + 36|0);
  $61 = HEAP32[$60>>2]|0;
  $62 = (_qspCodeReCode($61,0)|0);
  HEAP32[1636>>2] = $62;
  $63 = (_qspStrLen($62)|0);
  HEAP32[1640>>2] = $63;
 }
 $64 = HEAP32[$strs>>2]|0;
 $65 = ((($64)) + 40|0);
 $66 = HEAP32[$65>>2]|0;
 $67 = (_qspCodeReCode($66,0)|0);
 $locName = $67;
 $68 = HEAP32[$strs>>2]|0;
 $69 = ((($68)) + 44|0);
 $70 = HEAP32[$69>>2]|0;
 $71 = (_qspReCodeGetIntVal($70)|0);
 $72 = ($71|0)!=(0);
 $73 = $72&1;
 HEAP32[20>>2] = $73;
 $74 = HEAP32[$strs>>2]|0;
 $75 = ((($74)) + 48|0);
 $76 = HEAP32[$75>>2]|0;
 $77 = (_qspReCodeGetIntVal($76)|0);
 $78 = ($77|0)!=(0);
 $79 = $78&1;
 HEAP32[320524>>2] = $79;
 $80 = HEAP32[$strs>>2]|0;
 $81 = ((($80)) + 52|0);
 $82 = HEAP32[$81>>2]|0;
 $83 = (_qspReCodeGetIntVal($82)|0);
 $84 = ($83|0)!=(0);
 $85 = $84&1;
 HEAP32[1668>>2] = $85;
 $86 = HEAP32[$strs>>2]|0;
 $87 = ((($86)) + 56|0);
 $88 = HEAP32[$87>>2]|0;
 $89 = (_qspReCodeGetIntVal($88)|0);
 $90 = ($89|0)!=(0);
 $91 = $90&1;
 HEAP32[1672>>2] = $91;
 $92 = HEAP32[$strs>>2]|0;
 $93 = ((($92)) + 60|0);
 $94 = HEAP32[$93>>2]|0;
 $95 = (_qspReCodeGetIntVal($94)|0);
 HEAP32[1656>>2] = $95;
 $96 = HEAP32[$strs>>2]|0;
 $97 = ((($96)) + 64|0);
 $98 = HEAP32[$97>>2]|0;
 $99 = (_qspReCodeGetIntVal($98)|0);
 HEAP32[10636>>2] = $99;
 $ind = 17;
 $i = 0;
 while(1) {
  $100 = $i;
  $101 = HEAP32[10636>>2]|0;
  $102 = ($100|0)<($101|0);
  $103 = $ind;
  $104 = (($103) + 1)|0;
  $ind = $104;
  $105 = HEAP32[$strs>>2]|0;
  $106 = (($105) + ($103<<2)|0);
  $107 = HEAP32[$106>>2]|0;
  if (!($102)) {
   break;
  }
  $108 = (_qspCodeReCode($107,0)|0);
  $109 = $i;
  $110 = (10640 + ($109<<2)|0);
  HEAP32[$110>>2] = $108;
  $111 = $i;
  $112 = (($111) + 1)|0;
  $i = $112;
 }
 $113 = (_qspReCodeGetIntVal($107)|0);
 HEAP32[2948>>2] = $113;
 $i = 0;
 while(1) {
  $114 = $i;
  $115 = HEAP32[2948>>2]|0;
  $116 = ($114|0)<($115|0);
  $117 = $ind;
  $118 = (($117) + 1)|0;
  $ind = $118;
  $119 = HEAP32[$strs>>2]|0;
  $120 = (($119) + ($117<<2)|0);
  $121 = HEAP32[$120>>2]|0;
  if (!($116)) {
   break;
  }
  $122 = (_qspCodeReCode($121,0)|0);
  $123 = $i;
  $124 = (3980 + ($123<<2)|0);
  HEAP32[$124>>2] = $122;
  $125 = $i;
  $126 = (($125) + 1)|0;
  $i = $126;
 }
 $127 = (_qspReCodeGetIntVal($121)|0);
 HEAP32[8>>2] = $127;
 $i = 0;
 while(1) {
  $128 = $i;
  $129 = HEAP32[8>>2]|0;
  $130 = ($128|0)<($129|0);
  $131 = $ind;
  if (!($130)) {
   break;
  }
  $132 = HEAP32[$strs>>2]|0;
  $133 = (($132) + ($131<<2)|0);
  $134 = HEAP32[$133>>2]|0;
  $135 = HEAP16[$134>>1]|0;
  $136 = ($135<<16>>16)!=(0);
  if ($136) {
   $137 = $ind;
   $138 = HEAP32[$strs>>2]|0;
   $139 = (($138) + ($137<<2)|0);
   $140 = HEAP32[$139>>2]|0;
   $141 = (_qspCodeReCode($140,0)|0);
   $0 = $141;
   $142 = $0;
   $143 = (_qspGetAbsFromRelPath($142)|0);
   $144 = $i;
   $145 = (24 + ($144<<5)|0);
   HEAP32[$145>>2] = $143;
   $146 = $0;
   _free($146);
  } else {
   $147 = $i;
   $148 = (24 + ($147<<5)|0);
   HEAP32[$148>>2] = 0;
  }
  $149 = $ind;
  $150 = (($149) + 1)|0;
  $ind = $150;
  $151 = $ind;
  $152 = (($151) + 1)|0;
  $ind = $152;
  $153 = HEAP32[$strs>>2]|0;
  $154 = (($153) + ($151<<2)|0);
  $155 = HEAP32[$154>>2]|0;
  $156 = (_qspCodeReCode($155,0)|0);
  $157 = $i;
  $158 = (24 + ($157<<5)|0);
  $159 = ((($158)) + 4|0);
  HEAP32[$159>>2] = $156;
  $160 = $ind;
  $161 = (($160) + 1)|0;
  $ind = $161;
  $162 = HEAP32[$strs>>2]|0;
  $163 = (($162) + ($160<<2)|0);
  $164 = HEAP32[$163>>2]|0;
  $165 = (_qspReCodeGetIntVal($164)|0);
  $166 = $i;
  $167 = (24 + ($166<<5)|0);
  $168 = ((($167)) + 12|0);
  HEAP32[$168>>2] = $165;
  $valsCount = $165;
  $169 = $valsCount;
  $170 = ($169|0)!=(0);
  L32: do {
   if ($170) {
    $171 = $valsCount;
    $172 = ($171*24)|0;
    $173 = (_malloc($172)|0);
    $174 = $i;
    $175 = (24 + ($174<<5)|0);
    $176 = ((($175)) + 8|0);
    HEAP32[$176>>2] = $173;
    $j = 0;
    while(1) {
     $177 = $j;
     $178 = $valsCount;
     $179 = ($177|0)<($178|0);
     if (!($179)) {
      break L32;
     }
     $180 = $i;
     $181 = (24 + ($180<<5)|0);
     $182 = ((($181)) + 8|0);
     $183 = HEAP32[$182>>2]|0;
     $184 = $j;
     $185 = (($183) + (($184*24)|0)|0);
     $186 = $ind;
     $187 = (($186) + 1)|0;
     $ind = $187;
     $188 = HEAP32[$strs>>2]|0;
     $189 = (($188) + ($186<<2)|0);
     $190 = HEAP32[$189>>2]|0;
     $191 = (_qspCodeReCode($190,0)|0);
     _qspInitLineOfCode($185,$191,0);
     $192 = $ind;
     $193 = (($192) + 1)|0;
     $ind = $193;
     $194 = HEAP32[$strs>>2]|0;
     $195 = (($194) + ($192<<2)|0);
     $196 = HEAP32[$195>>2]|0;
     $197 = (_qspReCodeGetIntVal($196)|0);
     $198 = $j;
     $199 = $i;
     $200 = (24 + ($199<<5)|0);
     $201 = ((($200)) + 8|0);
     $202 = HEAP32[$201>>2]|0;
     $203 = (($202) + (($198*24)|0)|0);
     $204 = ((($203)) + 4|0);
     HEAP32[$204>>2] = $197;
     $205 = $j;
     $206 = (($205) + 1)|0;
     $j = $206;
    }
   } else {
    $207 = $i;
    $208 = (24 + ($207<<5)|0);
    $209 = ((($208)) + 8|0);
    HEAP32[$209>>2] = 0;
   }
  } while(0);
  $210 = $ind;
  $211 = (($210) + 1)|0;
  $ind = $211;
  $212 = HEAP32[$strs>>2]|0;
  $213 = (($212) + ($210<<2)|0);
  $214 = HEAP32[$213>>2]|0;
  $215 = (_qspReCodeGetIntVal($214)|0);
  $216 = $i;
  $217 = (24 + ($216<<5)|0);
  $218 = ((($217)) + 16|0);
  HEAP32[$218>>2] = $215;
  $219 = $ind;
  $220 = (($219) + 1)|0;
  $ind = $220;
  $221 = HEAP32[$strs>>2]|0;
  $222 = (($221) + ($219<<2)|0);
  $223 = HEAP32[$222>>2]|0;
  $224 = (_qspReCodeGetIntVal($223)|0);
  $225 = $i;
  $226 = (24 + ($225<<5)|0);
  $227 = ((($226)) + 20|0);
  HEAP32[$227>>2] = $224;
  $228 = $ind;
  $229 = (($228) + 1)|0;
  $ind = $229;
  $230 = HEAP32[$strs>>2]|0;
  $231 = (($230) + ($228<<2)|0);
  $232 = HEAP32[$231>>2]|0;
  $233 = (_qspReCodeGetIntVal($232)|0);
  $234 = $i;
  $235 = (24 + ($234<<5)|0);
  $236 = ((($235)) + 24|0);
  HEAP32[$236>>2] = $233;
  $237 = $ind;
  $238 = (($237) + 1)|0;
  $ind = $238;
  $239 = HEAP32[$strs>>2]|0;
  $240 = (($239) + ($237<<2)|0);
  $241 = HEAP32[$240>>2]|0;
  $242 = (_qspReCodeGetIntVal($241)|0);
  $243 = ($242|0)!=(0);
  $244 = $243&1;
  $245 = $i;
  $246 = (24 + ($245<<5)|0);
  $247 = ((($246)) + 28|0);
  HEAP32[$247>>2] = $244;
  $248 = $i;
  $249 = (($248) + 1)|0;
  $i = $249;
 }
 $250 = (($131) + 1)|0;
 $ind = $250;
 $251 = HEAP32[$strs>>2]|0;
 $252 = (($251) + ($131<<2)|0);
 $253 = HEAP32[$252>>2]|0;
 $254 = (_qspReCodeGetIntVal($253)|0);
 HEAP32[320512>>2] = $254;
 $i = 0;
 while(1) {
  $255 = $i;
  $256 = HEAP32[320512>>2]|0;
  $257 = ($255|0)<($256|0);
  $258 = $ind;
  if (!($257)) {
   break;
  }
  $259 = HEAP32[$strs>>2]|0;
  $260 = (($259) + ($258<<2)|0);
  $261 = HEAP32[$260>>2]|0;
  $262 = HEAP16[$261>>1]|0;
  $263 = ($262<<16>>16)!=(0);
  if ($263) {
   $264 = $ind;
   $265 = HEAP32[$strs>>2]|0;
   $266 = (($265) + ($264<<2)|0);
   $267 = HEAP32[$266>>2]|0;
   $268 = (_qspCodeReCode($267,0)|0);
   $0 = $268;
   $269 = $0;
   $270 = (_qspGetAbsFromRelPath($269)|0);
   $271 = $i;
   $272 = (320528 + ($271<<3)|0);
   HEAP32[$272>>2] = $270;
   $273 = $0;
   _free($273);
  } else {
   $274 = $i;
   $275 = (320528 + ($274<<3)|0);
   HEAP32[$275>>2] = 0;
  }
  $276 = $ind;
  $277 = (($276) + 1)|0;
  $ind = $277;
  $278 = $ind;
  $279 = (($278) + 1)|0;
  $ind = $279;
  $280 = HEAP32[$strs>>2]|0;
  $281 = (($280) + ($278<<2)|0);
  $282 = HEAP32[$281>>2]|0;
  $283 = (_qspCodeReCode($282,0)|0);
  $284 = $i;
  $285 = (320528 + ($284<<3)|0);
  $286 = ((($285)) + 4|0);
  HEAP32[$286>>2] = $283;
  $287 = $i;
  $288 = (($287) + 1)|0;
  $i = $288;
 }
 $289 = (($258) + 1)|0;
 $ind = $289;
 $290 = HEAP32[$strs>>2]|0;
 $291 = (($290) + ($258<<2)|0);
 $292 = HEAP32[$291>>2]|0;
 $293 = (_qspReCodeGetIntVal($292)|0);
 $varsCount = $293;
 $i = 0;
 while(1) {
  $294 = $i;
  $295 = $varsCount;
  $296 = ($294|0)<($295|0);
  if (!($296)) {
   break;
  }
  $297 = $ind;
  $298 = (($297) + 1)|0;
  $ind = $298;
  $299 = HEAP32[$strs>>2]|0;
  $300 = (($299) + ($297<<2)|0);
  $301 = HEAP32[$300>>2]|0;
  $302 = (_qspReCodeGetIntVal($301)|0);
  $varInd = $302;
  $303 = $ind;
  $304 = (($303) + 1)|0;
  $ind = $304;
  $305 = HEAP32[$strs>>2]|0;
  $306 = (($305) + ($303<<2)|0);
  $307 = HEAP32[$306>>2]|0;
  $308 = (_qspCodeReCode($307,0)|0);
  $309 = $varInd;
  $310 = (12648 + (($309*24)|0)|0);
  HEAP32[$310>>2] = $308;
  $311 = $ind;
  $312 = (($311) + 1)|0;
  $ind = $312;
  $313 = HEAP32[$strs>>2]|0;
  $314 = (($313) + ($311<<2)|0);
  $315 = HEAP32[$314>>2]|0;
  $316 = (_qspReCodeGetIntVal($315)|0);
  $valsCount = $316;
  $317 = $valsCount;
  $318 = ($317|0)!=(0);
  L51: do {
   if ($318) {
    $319 = $valsCount;
    $320 = $varInd;
    $321 = (12648 + (($320*24)|0)|0);
    $322 = ((($321)) + 8|0);
    HEAP32[$322>>2] = $319;
    $323 = $valsCount;
    $324 = $323<<3;
    $325 = (_malloc($324)|0);
    $326 = $varInd;
    $327 = (12648 + (($326*24)|0)|0);
    $328 = ((($327)) + 4|0);
    HEAP32[$328>>2] = $325;
    $j = 0;
    while(1) {
     $329 = $j;
     $330 = $valsCount;
     $331 = ($329|0)<($330|0);
     if (!($331)) {
      break L51;
     }
     $332 = $ind;
     $333 = (($332) + 1)|0;
     $ind = $333;
     $334 = HEAP32[$strs>>2]|0;
     $335 = (($334) + ($332<<2)|0);
     $336 = HEAP32[$335>>2]|0;
     $337 = (_qspReCodeGetIntVal($336)|0);
     $338 = $j;
     $339 = $varInd;
     $340 = (12648 + (($339*24)|0)|0);
     $341 = ((($340)) + 4|0);
     $342 = HEAP32[$341>>2]|0;
     $343 = (($342) + ($338<<3)|0);
     HEAP32[$343>>2] = $337;
     $344 = $ind;
     $345 = HEAP32[$strs>>2]|0;
     $346 = (($345) + ($344<<2)|0);
     $347 = HEAP32[$346>>2]|0;
     $348 = HEAP16[$347>>1]|0;
     $349 = $348&65535;
     $350 = ($349|0)!=(0);
     if ($350) {
      $351 = $ind;
      $352 = HEAP32[$strs>>2]|0;
      $353 = (($352) + ($351<<2)|0);
      $354 = HEAP32[$353>>2]|0;
      $355 = (_qspCodeReCode($354,0)|0);
      $363 = $355;
     } else {
      $363 = 0;
     }
     $356 = $j;
     $357 = $varInd;
     $358 = (12648 + (($357*24)|0)|0);
     $359 = ((($358)) + 4|0);
     $360 = HEAP32[$359>>2]|0;
     $361 = (($360) + ($356<<3)|0);
     $362 = ((($361)) + 4|0);
     HEAP32[$362>>2] = $363;
     $364 = $ind;
     $365 = (($364) + 1)|0;
     $ind = $365;
     $366 = $j;
     $367 = (($366) + 1)|0;
     $j = $367;
    }
   }
  } while(0);
  $368 = $ind;
  $369 = (($368) + 1)|0;
  $ind = $369;
  $370 = HEAP32[$strs>>2]|0;
  $371 = (($370) + ($368<<2)|0);
  $372 = HEAP32[$371>>2]|0;
  $373 = (_qspReCodeGetIntVal($372)|0);
  $valsCount = $373;
  $374 = $valsCount;
  $375 = ($374|0)!=(0);
  L60: do {
   if ($375) {
    $376 = $valsCount;
    $377 = $varInd;
    $378 = (12648 + (($377*24)|0)|0);
    $379 = ((($378)) + 16|0);
    HEAP32[$379>>2] = $376;
    $380 = $varInd;
    $381 = (12648 + (($380*24)|0)|0);
    $382 = ((($381)) + 20|0);
    HEAP32[$382>>2] = $376;
    $383 = $valsCount;
    $384 = $383<<3;
    $385 = (_malloc($384)|0);
    $386 = $varInd;
    $387 = (12648 + (($386*24)|0)|0);
    $388 = ((($387)) + 12|0);
    HEAP32[$388>>2] = $385;
    $j = 0;
    while(1) {
     $389 = $j;
     $390 = $valsCount;
     $391 = ($389|0)<($390|0);
     if (!($391)) {
      break L60;
     }
     $392 = $ind;
     $393 = (($392) + 1)|0;
     $ind = $393;
     $394 = HEAP32[$strs>>2]|0;
     $395 = (($394) + ($392<<2)|0);
     $396 = HEAP32[$395>>2]|0;
     $397 = (_qspReCodeGetIntVal($396)|0);
     $398 = $j;
     $399 = $varInd;
     $400 = (12648 + (($399*24)|0)|0);
     $401 = ((($400)) + 12|0);
     $402 = HEAP32[$401>>2]|0;
     $403 = (($402) + ($398<<3)|0);
     HEAP32[$403>>2] = $397;
     $404 = $ind;
     $405 = (($404) + 1)|0;
     $ind = $405;
     $406 = HEAP32[$strs>>2]|0;
     $407 = (($406) + ($404<<2)|0);
     $408 = HEAP32[$407>>2]|0;
     $409 = (_qspCodeReCode($408,0)|0);
     $410 = $j;
     $411 = $varInd;
     $412 = (12648 + (($411*24)|0)|0);
     $413 = ((($412)) + 12|0);
     $414 = HEAP32[$413>>2]|0;
     $415 = (($414) + ($410<<3)|0);
     $416 = ((($415)) + 4|0);
     HEAP32[$416>>2] = $409;
     $417 = $j;
     $418 = (($417) + 1)|0;
     $j = $418;
    }
   }
  } while(0);
  $419 = $i;
  $420 = (($419) + 1)|0;
  $i = $420;
 }
 $421 = HEAP32[$strs>>2]|0;
 $422 = $count;
 _qspFreeStrs($421,$422);
 HEAP32[16>>2] = 1;
 HEAP32[320520>>2] = 1;
 HEAP32[1664>>2] = 1;
 HEAP32[1660>>2] = 1;
 _qspOpenIncludes();
 $423 = $locName;
 $424 = (_qspLocIndex($423)|0);
 HEAP32[320500>>2] = $424;
 $425 = $locName;
 _free($425);
 $426 = HEAP32[320460>>2]|0;
 $427 = ($426|0)!=(0);
 if ($427) {
  STACKTOP = sp;return;
 }
 $428 = HEAP32[20>>2]|0;
 _qspCallShowWindow(0,$428);
 $429 = HEAP32[320524>>2]|0;
 _qspCallShowWindow(1,$429);
 $430 = HEAP32[1668>>2]|0;
 _qspCallShowWindow(2,$430);
 $431 = HEAP32[1672>>2]|0;
 _qspCallShowWindow(3,$431);
 $432 = HEAP32[1644>>2]|0;
 _qspCallSetInputStrText($432);
 $433 = HEAP32[1652>>2]|0;
 $434 = ($433|0)!=(0|0);
 if ($434) {
  $435 = HEAP32[1652>>2]|0;
  $436 = (_qspGetAbsFromRelPath($435)|0);
  $file = $436;
  $437 = $file;
  _qspCallShowPicture($437);
  $438 = $file;
  _free($438);
 } else {
  _qspCallShowPicture(0);
 }
 _qspCallCloseFile(0);
 _qspPlayPLFiles();
 $439 = HEAP32[1656>>2]|0;
 _qspCallSetTimer($439);
 _qspExecLocByVarNameWithArgs(443240,0,0);
 STACKTOP = sp;return;
}
function _qspOpenGameStatus($fileName) {
 $fileName = $fileName|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $buf = 0, $f = 0, $fileLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $fileName;
 $1 = $0;
 $2 = (_qspFileOpen($1,443186)|0);
 $f = $2;
 $3 = ($2|0)!=(0|0);
 if ($3) {
  $4 = $f;
  (_fseek($4,0,2)|0);
  $5 = $f;
  $6 = (_ftell($5)|0);
  $7 = (($6>>>0) / 2)&-1;
  $fileLen = $7;
  $8 = $fileLen;
  $9 = (($8) + 1)|0;
  $10 = $9<<1;
  $11 = (_malloc($10)|0);
  $buf = $11;
  $12 = $f;
  (_fseek($12,0,0)|0);
  $13 = $buf;
  $14 = $fileLen;
  $15 = $f;
  (_fread($13,2,$14,$15)|0);
  $16 = $f;
  (_fclose($16)|0);
  $17 = $fileLen;
  $18 = $buf;
  $19 = (($18) + ($17<<1)|0);
  HEAP16[$19>>1] = 0;
  $20 = $buf;
  _qspOpenGameStatusFromString($20);
  $21 = $buf;
  _free($21);
  STACKTOP = sp;return;
 } else {
  _qspSetError(104);
  STACKTOP = sp;return;
 }
}
function _qspStatementOpenQst($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $file = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = $4;
 L1: do {
  switch ($5|0) {
  case 0:  {
   $6 = $1;
   $7 = HEAP32[$6>>2]|0;
   $8 = (_qspIsAnyString($7)|0);
   $9 = ($8|0)!=(0);
   if ($9) {
    $10 = $1;
    $11 = HEAP32[$10>>2]|0;
    $12 = (_qspGetAbsFromRelPath($11)|0);
    $file = $12;
    $13 = $file;
    _qspOpenQuest($13,0);
    $14 = $file;
    _free($14);
    $15 = HEAP32[320460>>2]|0;
    $16 = ($15|0)!=(0);
    if (!($16)) {
     _qspNewGame(0);
     break L1;
    }
    $0 = 0;
    $19 = $0;
    STACKTOP = sp;return ($19|0);
   }
   break;
  }
  case 1:  {
   $17 = $1;
   $18 = HEAP32[$17>>2]|0;
   _qspIncludeFile($18);
   break;
  }
  default: {
  }
  }
 } while(0);
 $0 = 0;
 $19 = $0;
 STACKTOP = sp;return ($19|0);
}
function _qspStatementOpenGame($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 $4 = $1;
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = $0;
  $7 = HEAP32[$6>>2]|0;
  $8 = (_qspIsAnyString($7)|0);
  $9 = ($8|0)!=(0);
  if ($9) {
   $10 = $0;
   $11 = HEAP32[$10>>2]|0;
   $12 = (_qspGetAbsFromRelPath($11)|0);
   $file = $12;
   $13 = $file;
   _qspCallOpenGame($13);
   $14 = $file;
   _free($14);
   STACKTOP = sp;return 0;
  }
 }
 _qspCallOpenGame(0);
 STACKTOP = sp;return 0;
}
function _qspStatementSaveGame($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 $4 = $1;
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = $0;
  $7 = HEAP32[$6>>2]|0;
  $8 = (_qspIsAnyString($7)|0);
  $9 = ($8|0)!=(0);
  if ($9) {
   $10 = $0;
   $11 = HEAP32[$10>>2]|0;
   $12 = (_qspGetAbsFromRelPath($11)|0);
   $file = $12;
   $13 = $file;
   _qspCallSaveGame($13);
   $14 = $file;
   _free($14);
   STACKTOP = sp;return 0;
  }
 }
 _qspCallSaveGame(0);
 STACKTOP = sp;return 0;
}
function _qspCRC($data,$len) {
 $data = $data|0;
 $len = $len|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $crc = 0;
 var $ptr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $data;
 $1 = $len;
 $crc = 0;
 $2 = $0;
 $ptr = $2;
 while(1) {
  $3 = $1;
  $4 = (($3) + -1)|0;
  $1 = $4;
  $5 = ($3|0)!=(0);
  $6 = $crc;
  if (!($5)) {
   break;
  }
  $7 = $6 & 255;
  $8 = $ptr;
  $9 = ((($8)) + 1|0);
  $ptr = $9;
  $10 = HEAP8[$8>>0]|0;
  $11 = $10&255;
  $12 = $7 ^ $11;
  $13 = (2956 + ($12<<2)|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = $crc;
  $16 = $15 >> 8;
  $17 = $14 ^ $16;
  $18 = $17 ^ -771559539;
  $crc = $18;
 }
 STACKTOP = sp;return ($6|0);
}
function _qspCheckQuest($strs,$count,$isUCS2) {
 $strs = $strs|0;
 $count = $count|0;
 $isUCS2 = $isUCS2|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $8 = 0, $9 = 0, $actsCount = 0, $buf = 0, $i = 0, $ind = 0, $isOldFormat = 0, $locsCount = 0;
 var $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $strs;
 $2 = $count;
 $3 = $isUCS2;
 $4 = $1;
 $5 = HEAP32[$4>>2]|0;
 $6 = $3;
 $7 = (_qspGameToQSPString($5,$6,0)|0);
 $buf = $7;
 $8 = $buf;
 $9 = (_qspStrsComp($8,443170)|0);
 $10 = ($9|0)!=(0);
 $11 = $10&1;
 $isOldFormat = $11;
 $12 = $buf;
 _free($12);
 $13 = $isOldFormat;
 $14 = ($13|0)!=(0);
 $15 = $14 ? 30 : 4;
 $ind = $15;
 $16 = $ind;
 $17 = $2;
 $18 = ($16|0)>($17|0);
 if ($18) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 $19 = $isOldFormat;
 $20 = ($19|0)!=(0);
 $21 = $1;
 if ($20) {
  $22 = HEAP32[$21>>2]|0;
  $23 = $3;
  $24 = (_qspGameToQSPString($22,$23,0)|0);
  $29 = $24;
 } else {
  $25 = ((($21)) + 12|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = $3;
  $28 = (_qspGameToQSPString($26,$27,1)|0);
  $29 = $28;
 }
 $buf = $29;
 $30 = $buf;
 $31 = (_qspStrToNum($30,0)|0);
 $locsCount = $31;
 $32 = $buf;
 _free($32);
 $33 = $locsCount;
 $34 = ($33|0)<=(0);
 if ($34) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 $i = 0;
 while(1) {
  $35 = $i;
  $36 = $locsCount;
  $37 = ($35|0)<($36|0);
  if (!($37)) {
   label = 21;
   break;
  }
  $38 = $ind;
  $39 = (($38) + 3)|0;
  $ind = $39;
  $40 = $2;
  $41 = ($39|0)>($40|0);
  if ($41) {
   label = 11;
   break;
  }
  $42 = $isOldFormat;
  $43 = ($42|0)!=(0);
  if ($43) {
   $actsCount = 20;
  } else {
   $44 = $ind;
   $45 = (($44) + 1)|0;
   $46 = $2;
   $47 = ($45|0)>($46|0);
   if ($47) {
    label = 15;
    break;
   }
   $48 = $ind;
   $49 = (($48) + 1)|0;
   $ind = $49;
   $50 = $1;
   $51 = (($50) + ($48<<2)|0);
   $52 = HEAP32[$51>>2]|0;
   $53 = $3;
   $54 = (_qspGameToQSPString($52,$53,1)|0);
   $buf = $54;
   $55 = $buf;
   $56 = (_qspStrToNum($55,0)|0);
   $actsCount = $56;
   $57 = $buf;
   _free($57);
   $58 = $actsCount;
   $59 = ($58|0)<(0);
   $60 = $actsCount;
   $61 = ($60|0)>(50);
   $or$cond = $59 | $61;
   if ($or$cond) {
    label = 17;
    break;
   }
  }
  $62 = $actsCount;
  $63 = $isOldFormat;
  $64 = ($63|0)!=(0);
  $65 = $64 ? 2 : 3;
  $66 = Math_imul($62, $65)|0;
  $67 = $ind;
  $68 = (($67) + ($66))|0;
  $ind = $68;
  $69 = $2;
  $70 = ($68|0)>($69|0);
  if ($70) {
   label = 19;
   break;
  }
  $71 = $i;
  $72 = (($71) + 1)|0;
  $i = $72;
 }
 if ((label|0) == 11) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 else if ((label|0) == 15) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 else if ((label|0) == 17) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 else if ((label|0) == 19) {
  $0 = 0;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 else if ((label|0) == 21) {
  $0 = 1;
  $73 = $0;
  STACKTOP = sp;return ($73|0);
 }
 return (0)|0;
}
function _qspFileOpen($fileName,$fileMode) {
 $fileName = $fileName|0;
 $fileMode = $fileMode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, $mode = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $fileName;
 $1 = $fileMode;
 $2 = $0;
 $3 = (_qspToSysString($2)|0);
 $file = $3;
 $4 = $1;
 $5 = (_qspToSysString($4)|0);
 $mode = $5;
 $6 = $file;
 $7 = $mode;
 $8 = (_fopen($6,$7)|0);
 $ret = $8;
 $9 = $file;
 _free($9);
 $10 = $mode;
 _free($10);
 $11 = $ret;
 STACKTOP = sp;return ($11|0);
}
function _qspCheckGameStatus($strs,$strsCount) {
 $strs = $strs|0;
 $strsCount = $strsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $count = 0, $i = 0, $ind = 0, $j = 0, $lastInd = 0;
 var $linesCount = 0, $or$cond = 0, $or$cond3 = 0, $or$cond5 = 0, $or$cond7 = 0, $or$cond9 = 0, $selAction = 0, $selObject = 0, $temp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $strs;
 $2 = $strsCount;
 $ind = 17;
 $3 = $ind;
 $4 = $2;
 $5 = ($3|0)>($4|0);
 L1: do {
  if ($5) {
   $0 = 0;
  } else {
   $6 = $1;
   $7 = HEAP32[$6>>2]|0;
   $8 = (_qspStrsComp($7,443208)|0);
   $9 = ($8|0)!=(0);
   if (!($9)) {
    $10 = $1;
    $11 = ((($10)) + 4|0);
    $12 = HEAP32[$11>>2]|0;
    $13 = (_qspStrsComp($12,447356)|0);
    $14 = ($13|0)<(0);
    if (!($14)) {
     $15 = $1;
     $16 = ((($15)) + 4|0);
     $17 = HEAP32[$16>>2]|0;
     $18 = (_qspStrsComp($17,447356)|0);
     $19 = ($18|0)>(0);
     if (!($19)) {
      $20 = (_qspGetVarNumValue(443256)|0);
      $21 = ($20|0)!=(0);
      if (!($21)) {
       $22 = $1;
       $23 = ((($22)) + 8|0);
       $24 = HEAP32[$23>>2]|0;
       $25 = (_qspReCodeGetIntVal($24)|0);
       $26 = HEAP32[2944>>2]|0;
       $27 = ($25|0)!=($26|0);
       if ($27) {
        $0 = 0;
        break;
       }
      }
      $28 = $1;
      $29 = ((($28)) + 16|0);
      $30 = HEAP32[$29>>2]|0;
      $31 = (_qspReCodeGetIntVal($30)|0);
      $selAction = $31;
      $32 = $1;
      $33 = ((($32)) + 20|0);
      $34 = HEAP32[$33>>2]|0;
      $35 = (_qspReCodeGetIntVal($34)|0);
      $selObject = $35;
      $36 = $1;
      $37 = ((($36)) + 60|0);
      $38 = HEAP32[$37>>2]|0;
      $39 = (_qspReCodeGetIntVal($38)|0);
      $40 = ($39|0)<(0);
      if ($40) {
       $0 = 0;
       break;
      }
      $41 = $1;
      $42 = ((($41)) + 64|0);
      $43 = HEAP32[$42>>2]|0;
      $44 = (_qspReCodeGetIntVal($43)|0);
      $temp = $44;
      $45 = $temp;
      $46 = ($45|0)<(0);
      $47 = $temp;
      $48 = ($47|0)>(500);
      $or$cond = $46 | $48;
      if (!($or$cond)) {
       $49 = $temp;
       $50 = $ind;
       $51 = (($50) + ($49))|0;
       $ind = $51;
       $52 = $2;
       $53 = ($51|0)>($52|0);
       if (!($53)) {
        $54 = $ind;
        $55 = (($54) + 1)|0;
        $56 = $2;
        $57 = ($55|0)>($56|0);
        if ($57) {
         $0 = 0;
         break;
        }
        $58 = $ind;
        $59 = (($58) + 1)|0;
        $ind = $59;
        $60 = $1;
        $61 = (($60) + ($58<<2)|0);
        $62 = HEAP32[$61>>2]|0;
        $63 = (_qspReCodeGetIntVal($62)|0);
        $temp = $63;
        $64 = $temp;
        $65 = ($64|0)<(0);
        $66 = $temp;
        $67 = ($66|0)>(100);
        $or$cond3 = $65 | $67;
        if (!($or$cond3)) {
         $68 = $temp;
         $69 = $ind;
         $70 = (($69) + ($68))|0;
         $ind = $70;
         $71 = $2;
         $72 = ($70|0)>($71|0);
         if (!($72)) {
          $73 = $ind;
          $74 = (($73) + 1)|0;
          $75 = $2;
          $76 = ($74|0)>($75|0);
          if ($76) {
           $0 = 0;
           break;
          }
          $77 = $ind;
          $78 = (($77) + 1)|0;
          $ind = $78;
          $79 = $1;
          $80 = (($79) + ($77<<2)|0);
          $81 = HEAP32[$80>>2]|0;
          $82 = (_qspReCodeGetIntVal($81)|0);
          $count = $82;
          $83 = $count;
          $84 = ($83|0)<(0);
          $85 = $count;
          $86 = ($85|0)>(50);
          $or$cond5 = $84 | $86;
          if (!($or$cond5)) {
           $87 = $selAction;
           $88 = $count;
           $89 = ($87|0)>=($88|0);
           if (!($89)) {
            $i = 0;
            L30: while(1) {
             $90 = $i;
             $91 = $count;
             $92 = ($90|0)<($91|0);
             $93 = $ind;
             if (!($92)) {
              label = 52;
              break;
             }
             $94 = (($93) + 2)|0;
             $ind = $94;
             $95 = $2;
             $96 = ($94|0)>($95|0);
             if ($96) {
              label = 28;
              break;
             }
             $97 = $ind;
             $98 = (($97) + 1)|0;
             $99 = $2;
             $100 = ($98|0)>($99|0);
             if ($100) {
              label = 30;
              break;
             }
             $101 = $ind;
             $102 = (($101) + 1)|0;
             $ind = $102;
             $103 = $1;
             $104 = (($103) + ($101<<2)|0);
             $105 = HEAP32[$104>>2]|0;
             $106 = (_qspReCodeGetIntVal($105)|0);
             $linesCount = $106;
             $107 = $linesCount;
             $108 = ($107|0)<(0);
             if ($108) {
              label = 33;
              break;
             }
             $109 = $ind;
             $110 = $linesCount;
             $111 = $110<<1;
             $112 = (($109) + ($111))|0;
             $113 = $2;
             $114 = ($112|0)>($113|0);
             if ($114) {
              label = 33;
              break;
             }
             $j = 0;
             while(1) {
              $115 = $j;
              $116 = $linesCount;
              $117 = ($115|0)<($116|0);
              $118 = $ind;
              $119 = (($118) + 1)|0;
              if (!($117)) {
               break;
              }
              $ind = $119;
              $120 = $ind;
              $121 = (($120) + 1)|0;
              $ind = $121;
              $122 = $1;
              $123 = (($122) + ($120<<2)|0);
              $124 = HEAP32[$123>>2]|0;
              $125 = (_qspReCodeGetIntVal($124)|0);
              $126 = ($125|0)<(0);
              if ($126) {
               label = 37;
               break L30;
              }
              $127 = $j;
              $128 = (($127) + 1)|0;
              $j = $128;
             }
             $129 = $2;
             $130 = ($119|0)>($129|0);
             if ($130) {
              label = 40;
              break;
             }
             $131 = $ind;
             $132 = (($131) + 1)|0;
             $ind = $132;
             $133 = $1;
             $134 = (($133) + ($131<<2)|0);
             $135 = HEAP32[$134>>2]|0;
             $136 = (_qspReCodeGetIntVal($135)|0);
             $137 = ($136|0)<(0);
             if ($137) {
              label = 42;
              break;
             }
             $138 = $ind;
             $139 = (($138) + 1)|0;
             $ind = $139;
             $140 = $2;
             $141 = ($139|0)>($140|0);
             if ($141) {
              label = 44;
              break;
             }
             $142 = $ind;
             $143 = (($142) + 1)|0;
             $144 = $2;
             $145 = ($143|0)>($144|0);
             if ($145) {
              label = 46;
              break;
             }
             $146 = $ind;
             $147 = (($146) + 1)|0;
             $ind = $147;
             $148 = $1;
             $149 = (($148) + ($146<<2)|0);
             $150 = HEAP32[$149>>2]|0;
             $151 = (_qspReCodeGetIntVal($150)|0);
             $152 = ($151|0)<(0);
             if ($152) {
              label = 48;
              break;
             }
             $153 = $ind;
             $154 = (($153) + 1)|0;
             $ind = $154;
             $155 = $2;
             $156 = ($154|0)>($155|0);
             if ($156) {
              label = 50;
              break;
             }
             $157 = $i;
             $158 = (($157) + 1)|0;
             $i = $158;
            }
            switch (label|0) {
             case 28: {
              $0 = 0;
              break L1;
              break;
             }
             case 30: {
              $0 = 0;
              break L1;
              break;
             }
             case 33: {
              $0 = 0;
              break L1;
              break;
             }
             case 37: {
              $0 = 0;
              break L1;
              break;
             }
             case 40: {
              $0 = 0;
              break L1;
              break;
             }
             case 42: {
              $0 = 0;
              break L1;
              break;
             }
             case 44: {
              $0 = 0;
              break L1;
              break;
             }
             case 46: {
              $0 = 0;
              break L1;
              break;
             }
             case 48: {
              $0 = 0;
              break L1;
              break;
             }
             case 50: {
              $0 = 0;
              break L1;
              break;
             }
             case 52: {
              $159 = (($93) + 1)|0;
              $160 = $2;
              $161 = ($159|0)>($160|0);
              if ($161) {
               $0 = 0;
               break L1;
              }
              $162 = $ind;
              $163 = (($162) + 1)|0;
              $ind = $163;
              $164 = $1;
              $165 = (($164) + ($162<<2)|0);
              $166 = HEAP32[$165>>2]|0;
              $167 = (_qspReCodeGetIntVal($166)|0);
              $temp = $167;
              $168 = $temp;
              $169 = ($168|0)<(0);
              $170 = $temp;
              $171 = ($170|0)>(1000);
              $or$cond7 = $169 | $171;
              do {
               if (!($or$cond7)) {
                $172 = $selObject;
                $173 = $temp;
                $174 = ($172|0)>=($173|0);
                if ($174) {
                 break;
                }
                $175 = $temp;
                $176 = $175<<1;
                $177 = $ind;
                $178 = (($177) + ($176))|0;
                $ind = $178;
                $179 = $2;
                $180 = ($178|0)>($179|0);
                if ($180) {
                 break;
                }
                $181 = $ind;
                $182 = (($181) + 1)|0;
                $183 = $2;
                $184 = ($182|0)>($183|0);
                if ($184) {
                 $0 = 0;
                 break L1;
                }
                $185 = $ind;
                $186 = (($185) + 1)|0;
                $ind = $186;
                $187 = $1;
                $188 = (($187) + ($185<<2)|0);
                $189 = HEAP32[$188>>2]|0;
                $190 = (_qspReCodeGetIntVal($189)|0);
                $count = $190;
                $191 = $count;
                $192 = ($191|0)<(0);
                if ($192) {
                 $0 = 0;
                 break L1;
                }
                $lastInd = -1;
                $i = 0;
                while(1) {
                 $193 = $i;
                 $194 = $count;
                 $195 = ($193|0)<($194|0);
                 if (!($195)) {
                  label = 81;
                  break;
                 }
                 $196 = $ind;
                 $197 = (($196) + 1)|0;
                 $198 = $2;
                 $199 = ($197|0)>($198|0);
                 if ($199) {
                  label = 65;
                  break;
                 }
                 $200 = $ind;
                 $201 = (($200) + 1)|0;
                 $ind = $201;
                 $202 = $1;
                 $203 = (($202) + ($200<<2)|0);
                 $204 = HEAP32[$203>>2]|0;
                 $205 = (_qspReCodeGetIntVal($204)|0);
                 $temp = $205;
                 $206 = $temp;
                 $207 = $lastInd;
                 $208 = ($206|0)<=($207|0);
                 $209 = $temp;
                 $210 = ($209|0)>=(12800);
                 $or$cond9 = $208 | $210;
                 if ($or$cond9) {
                  label = 67;
                  break;
                 }
                 $211 = $temp;
                 $lastInd = $211;
                 $212 = $ind;
                 $213 = (($212) + 1)|0;
                 $ind = $213;
                 $214 = $2;
                 $215 = ($213|0)>($214|0);
                 if ($215) {
                  label = 69;
                  break;
                 }
                 $216 = $ind;
                 $217 = (($216) + 1)|0;
                 $218 = $2;
                 $219 = ($217|0)>($218|0);
                 if ($219) {
                  label = 71;
                  break;
                 }
                 $220 = $ind;
                 $221 = (($220) + 1)|0;
                 $ind = $221;
                 $222 = $1;
                 $223 = (($222) + ($220<<2)|0);
                 $224 = HEAP32[$223>>2]|0;
                 $225 = (_qspReCodeGetIntVal($224)|0);
                 $temp = $225;
                 $226 = $temp;
                 $227 = ($226|0)<(0);
                 if ($227) {
                  label = 74;
                  break;
                 }
                 $228 = $temp;
                 $229 = $228<<1;
                 $230 = $ind;
                 $231 = (($230) + ($229))|0;
                 $ind = $231;
                 $232 = $2;
                 $233 = ($231|0)>($232|0);
                 if ($233) {
                  label = 74;
                  break;
                 }
                 $234 = $ind;
                 $235 = (($234) + 1)|0;
                 $236 = $2;
                 $237 = ($235|0)>($236|0);
                 if ($237) {
                  label = 76;
                  break;
                 }
                 $238 = $ind;
                 $239 = (($238) + 1)|0;
                 $ind = $239;
                 $240 = $1;
                 $241 = (($240) + ($238<<2)|0);
                 $242 = HEAP32[$241>>2]|0;
                 $243 = (_qspReCodeGetIntVal($242)|0);
                 $temp = $243;
                 $244 = $temp;
                 $245 = ($244|0)<(0);
                 if ($245) {
                  label = 79;
                  break;
                 }
                 $246 = $temp;
                 $247 = $246<<1;
                 $248 = $ind;
                 $249 = (($248) + ($247))|0;
                 $ind = $249;
                 $250 = $2;
                 $251 = ($249|0)>($250|0);
                 if ($251) {
                  label = 79;
                  break;
                 }
                 $252 = $i;
                 $253 = (($252) + 1)|0;
                 $i = $253;
                }
                if ((label|0) == 65) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 67) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 69) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 71) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 74) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 76) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 79) {
                 $0 = 0;
                 break L1;
                }
                else if ((label|0) == 81) {
                 $0 = 1;
                 break L1;
                }
               }
              } while(0);
              $0 = 0;
              break L1;
              break;
             }
            }
           }
          }
          $0 = 0;
          break;
         }
        }
        $0 = 0;
        break;
       }
      }
      $0 = 0;
      break;
     }
    }
   }
   $0 = 0;
  }
 } while(0);
 $254 = $0;
 STACKTOP = sp;return ($254|0);
}
function _qspOpenIncludes() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = HEAP32[2948>>2]|0;
  $2 = ($0|0)<($1|0);
  if (!($2)) {
   label = 5;
   break;
  }
  $3 = $i;
  $4 = (3980 + ($3<<2)|0);
  $5 = HEAP32[$4>>2]|0;
  $6 = (_qspGetAbsFromRelPath($5)|0);
  $file = $6;
  $7 = $file;
  _qspOpenQuest($7,1);
  $8 = $file;
  _free($8);
  $9 = HEAP32[320460>>2]|0;
  $10 = ($9|0)!=(0);
  if ($10) {
   label = 5;
   break;
  }
  $11 = $i;
  $12 = (($11) + 1)|0;
  $i = $12;
 }
 if ((label|0) == 5) {
  STACKTOP = sp;return;
 }
}
function _qspIncludeFile($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $file = 0, $oldCurIncLocsCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $0;
 $2 = (_qspIsAnyString($1)|0);
 $3 = ($2|0)!=(0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $4 = HEAP32[2948>>2]|0;
 $5 = ($4|0)==(100);
 if ($5) {
  _qspSetError(108);
  STACKTOP = sp;return;
 }
 $6 = HEAP32[2952>>2]|0;
 $oldCurIncLocsCount = $6;
 $7 = $0;
 $8 = (_qspGetAbsFromRelPath($7)|0);
 $file = $8;
 $9 = $file;
 _qspOpenQuest($9,1);
 $10 = $file;
 _free($10);
 $11 = HEAP32[320460>>2]|0;
 $12 = ($11|0)!=(0);
 if ($12) {
  STACKTOP = sp;return;
 }
 $13 = HEAP32[2952>>2]|0;
 $14 = $oldCurIncLocsCount;
 $15 = ($13|0)!=($14|0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = $0;
 $17 = (_qspGetNewText($16,-1)|0);
 $18 = HEAP32[2948>>2]|0;
 $19 = (($18) + 1)|0;
 HEAP32[2948>>2] = $19;
 $20 = (3980 + ($18<<2)|0);
 HEAP32[$20>>2] = $17;
 STACKTOP = sp;return;
}
function _qspInitMath() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer104 = 0, $vararg_buffer108 = 0;
 var $vararg_buffer11 = 0, $vararg_buffer113 = 0, $vararg_buffer119 = 0, $vararg_buffer122 = 0, $vararg_buffer125 = 0, $vararg_buffer128 = 0, $vararg_buffer131 = 0, $vararg_buffer134 = 0, $vararg_buffer137 = 0, $vararg_buffer140 = 0, $vararg_buffer143 = 0, $vararg_buffer146 = 0, $vararg_buffer149 = 0, $vararg_buffer15 = 0, $vararg_buffer152 = 0, $vararg_buffer155 = 0, $vararg_buffer159 = 0, $vararg_buffer164 = 0, $vararg_buffer169 = 0, $vararg_buffer174 = 0;
 var $vararg_buffer179 = 0, $vararg_buffer184 = 0, $vararg_buffer189 = 0, $vararg_buffer19 = 0, $vararg_buffer194 = 0, $vararg_buffer206 = 0, $vararg_buffer218 = 0, $vararg_buffer220 = 0, $vararg_buffer222 = 0, $vararg_buffer224 = 0, $vararg_buffer226 = 0, $vararg_buffer228 = 0, $vararg_buffer23 = 0, $vararg_buffer230 = 0, $vararg_buffer232 = 0, $vararg_buffer234 = 0, $vararg_buffer236 = 0, $vararg_buffer238 = 0, $vararg_buffer240 = 0, $vararg_buffer27 = 0;
 var $vararg_buffer3 = 0, $vararg_buffer31 = 0, $vararg_buffer35 = 0, $vararg_buffer39 = 0, $vararg_buffer43 = 0, $vararg_buffer47 = 0, $vararg_buffer5 = 0, $vararg_buffer51 = 0, $vararg_buffer55 = 0, $vararg_buffer59 = 0, $vararg_buffer63 = 0, $vararg_buffer67 = 0, $vararg_buffer7 = 0, $vararg_buffer71 = 0, $vararg_buffer74 = 0, $vararg_buffer77 = 0, $vararg_buffer80 = 0, $vararg_buffer9 = 0, $vararg_buffer92 = 0, $vararg_ptr100 = 0;
 var $vararg_ptr101 = 0, $vararg_ptr102 = 0, $vararg_ptr103 = 0, $vararg_ptr107 = 0, $vararg_ptr111 = 0, $vararg_ptr112 = 0, $vararg_ptr116 = 0, $vararg_ptr117 = 0, $vararg_ptr118 = 0, $vararg_ptr14 = 0, $vararg_ptr158 = 0, $vararg_ptr162 = 0, $vararg_ptr163 = 0, $vararg_ptr167 = 0, $vararg_ptr168 = 0, $vararg_ptr172 = 0, $vararg_ptr173 = 0, $vararg_ptr177 = 0, $vararg_ptr178 = 0, $vararg_ptr18 = 0;
 var $vararg_ptr182 = 0, $vararg_ptr183 = 0, $vararg_ptr187 = 0, $vararg_ptr188 = 0, $vararg_ptr192 = 0, $vararg_ptr193 = 0, $vararg_ptr197 = 0, $vararg_ptr198 = 0, $vararg_ptr199 = 0, $vararg_ptr200 = 0, $vararg_ptr201 = 0, $vararg_ptr202 = 0, $vararg_ptr203 = 0, $vararg_ptr204 = 0, $vararg_ptr205 = 0, $vararg_ptr209 = 0, $vararg_ptr210 = 0, $vararg_ptr211 = 0, $vararg_ptr212 = 0, $vararg_ptr213 = 0;
 var $vararg_ptr214 = 0, $vararg_ptr215 = 0, $vararg_ptr216 = 0, $vararg_ptr217 = 0, $vararg_ptr22 = 0, $vararg_ptr26 = 0, $vararg_ptr30 = 0, $vararg_ptr34 = 0, $vararg_ptr38 = 0, $vararg_ptr42 = 0, $vararg_ptr46 = 0, $vararg_ptr50 = 0, $vararg_ptr54 = 0, $vararg_ptr58 = 0, $vararg_ptr62 = 0, $vararg_ptr66 = 0, $vararg_ptr70 = 0, $vararg_ptr83 = 0, $vararg_ptr84 = 0, $vararg_ptr85 = 0;
 var $vararg_ptr86 = 0, $vararg_ptr87 = 0, $vararg_ptr88 = 0, $vararg_ptr89 = 0, $vararg_ptr90 = 0, $vararg_ptr91 = 0, $vararg_ptr95 = 0, $vararg_ptr96 = 0, $vararg_ptr97 = 0, $vararg_ptr98 = 0, $vararg_ptr99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 704|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $vararg_buffer240 = sp + 696|0;
 $vararg_buffer238 = sp + 688|0;
 $vararg_buffer236 = sp + 680|0;
 $vararg_buffer234 = sp + 672|0;
 $vararg_buffer232 = sp + 664|0;
 $vararg_buffer230 = sp + 656|0;
 $vararg_buffer228 = sp + 648|0;
 $vararg_buffer226 = sp + 640|0;
 $vararg_buffer224 = sp + 632|0;
 $vararg_buffer222 = sp + 624|0;
 $vararg_buffer220 = sp + 616|0;
 $vararg_buffer218 = sp + 608|0;
 $vararg_buffer206 = sp + 568|0;
 $vararg_buffer194 = sp + 528|0;
 $vararg_buffer189 = sp + 512|0;
 $vararg_buffer184 = sp + 496|0;
 $vararg_buffer179 = sp + 480|0;
 $vararg_buffer174 = sp + 464|0;
 $vararg_buffer169 = sp + 448|0;
 $vararg_buffer164 = sp + 432|0;
 $vararg_buffer159 = sp + 416|0;
 $vararg_buffer155 = sp + 408|0;
 $vararg_buffer152 = sp + 400|0;
 $vararg_buffer149 = sp + 392|0;
 $vararg_buffer146 = sp + 384|0;
 $vararg_buffer143 = sp + 376|0;
 $vararg_buffer140 = sp + 368|0;
 $vararg_buffer137 = sp + 360|0;
 $vararg_buffer134 = sp + 352|0;
 $vararg_buffer131 = sp + 344|0;
 $vararg_buffer128 = sp + 336|0;
 $vararg_buffer125 = sp + 328|0;
 $vararg_buffer122 = sp + 320|0;
 $vararg_buffer119 = sp + 312|0;
 $vararg_buffer113 = sp + 296|0;
 $vararg_buffer108 = sp + 280|0;
 $vararg_buffer104 = sp + 272|0;
 $vararg_buffer92 = sp + 232|0;
 $vararg_buffer80 = sp + 192|0;
 $vararg_buffer77 = sp + 184|0;
 $vararg_buffer74 = sp + 176|0;
 $vararg_buffer71 = sp + 168|0;
 $vararg_buffer67 = sp + 160|0;
 $vararg_buffer63 = sp + 152|0;
 $vararg_buffer59 = sp + 144|0;
 $vararg_buffer55 = sp + 136|0;
 $vararg_buffer51 = sp + 128|0;
 $vararg_buffer47 = sp + 120|0;
 $vararg_buffer43 = sp + 112|0;
 $vararg_buffer39 = sp + 104|0;
 $vararg_buffer35 = sp + 96|0;
 $vararg_buffer31 = sp + 88|0;
 $vararg_buffer27 = sp + 80|0;
 $vararg_buffer23 = sp + 72|0;
 $vararg_buffer19 = sp + 64|0;
 $vararg_buffer15 = sp + 56|0;
 $vararg_buffer11 = sp + 48|0;
 $vararg_buffer9 = sp + 40|0;
 $vararg_buffer7 = sp + 32|0;
 $vararg_buffer5 = sp + 24|0;
 $vararg_buffer3 = sp + 16|0;
 $vararg_buffer1 = sp + 8|0;
 $vararg_buffer = sp;
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = ($0|0)<(2);
  if (!($1)) {
   break;
  }
  $2 = $i;
  $3 = (4384 + ($2<<2)|0);
  HEAP32[$3>>2] = 0;
  $4 = $i;
  $5 = (($4) + 1)|0;
  $i = $5;
 }
 HEAP32[4380>>2] = 0;
 _qspAddOperation(3,0,0,0,0,0,$vararg_buffer);
 _qspAddOperation(1,127,0,0,0,0,$vararg_buffer1);
 _qspAddOperation(2,0,0,0,0,0,$vararg_buffer3);
 _qspAddOperation(4,127,0,0,0,0,$vararg_buffer5);
 _qspAddOperation(7,0,0,0,0,0,$vararg_buffer7);
 HEAP32[$vararg_buffer9>>2] = 2;
 _qspAddOperation(5,18,0,2,1,1,$vararg_buffer9);
 HEAP32[$vararg_buffer11>>2] = 0;
 $vararg_ptr14 = ((($vararg_buffer11)) + 4|0);
 HEAP32[$vararg_ptr14>>2] = 0;
 _qspAddOperation(10,14,0,0,2,2,$vararg_buffer11);
 HEAP32[$vararg_buffer15>>2] = 2;
 $vararg_ptr18 = ((($vararg_buffer15)) + 4|0);
 HEAP32[$vararg_ptr18>>2] = 2;
 _qspAddOperation(11,14,0,2,2,2,$vararg_buffer15);
 HEAP32[$vararg_buffer19>>2] = 2;
 $vararg_ptr22 = ((($vararg_buffer19)) + 4|0);
 HEAP32[$vararg_ptr22>>2] = 2;
 _qspAddOperation(8,17,0,2,2,2,$vararg_buffer19);
 HEAP32[$vararg_buffer23>>2] = 2;
 $vararg_ptr26 = ((($vararg_buffer23)) + 4|0);
 HEAP32[$vararg_ptr26>>2] = 2;
 _qspAddOperation(9,17,0,2,2,2,$vararg_buffer23);
 HEAP32[$vararg_buffer27>>2] = 2;
 $vararg_ptr30 = ((($vararg_buffer27)) + 4|0);
 HEAP32[$vararg_ptr30>>2] = 2;
 _qspAddOperation(12,16,0,2,2,2,$vararg_buffer27);
 HEAP32[$vararg_buffer31>>2] = 0;
 $vararg_ptr34 = ((($vararg_buffer31)) + 4|0);
 HEAP32[$vararg_ptr34>>2] = 0;
 _qspAddOperation(13,10,0,2,2,2,$vararg_buffer31);
 HEAP32[$vararg_buffer35>>2] = 0;
 $vararg_ptr38 = ((($vararg_buffer35)) + 4|0);
 HEAP32[$vararg_ptr38>>2] = 0;
 _qspAddOperation(14,10,0,2,2,2,$vararg_buffer35);
 HEAP32[$vararg_buffer39>>2] = 0;
 $vararg_ptr42 = ((($vararg_buffer39)) + 4|0);
 HEAP32[$vararg_ptr42>>2] = 0;
 _qspAddOperation(15,10,0,2,2,2,$vararg_buffer39);
 HEAP32[$vararg_buffer43>>2] = 0;
 $vararg_ptr46 = ((($vararg_buffer43)) + 4|0);
 HEAP32[$vararg_ptr46>>2] = 0;
 _qspAddOperation(16,10,0,2,2,2,$vararg_buffer43);
 HEAP32[$vararg_buffer47>>2] = 0;
 $vararg_ptr50 = ((($vararg_buffer47)) + 4|0);
 HEAP32[$vararg_ptr50>>2] = 0;
 _qspAddOperation(17,10,0,2,2,2,$vararg_buffer47);
 HEAP32[$vararg_buffer51>>2] = 0;
 $vararg_ptr54 = ((($vararg_buffer51)) + 4|0);
 HEAP32[$vararg_ptr54>>2] = 0;
 _qspAddOperation(18,10,0,2,2,2,$vararg_buffer51);
 HEAP32[$vararg_buffer55>>2] = 1;
 $vararg_ptr58 = ((($vararg_buffer55)) + 4|0);
 HEAP32[$vararg_ptr58>>2] = 1;
 _qspAddOperation(21,4,0,1,2,2,$vararg_buffer55);
 HEAP32[$vararg_buffer59>>2] = 1;
 $vararg_ptr62 = ((($vararg_buffer59)) + 4|0);
 HEAP32[$vararg_ptr62>>2] = 1;
 _qspAddOperation(6,0,0,1,2,2,$vararg_buffer59);
 HEAP32[$vararg_buffer63>>2] = 2;
 $vararg_ptr66 = ((($vararg_buffer63)) + 4|0);
 HEAP32[$vararg_ptr66>>2] = 2;
 _qspAddOperation(19,7,0,2,2,2,$vararg_buffer63);
 HEAP32[$vararg_buffer67>>2] = 2;
 $vararg_ptr70 = ((($vararg_buffer67)) + 4|0);
 HEAP32[$vararg_ptr70>>2] = 2;
 _qspAddOperation(20,6,0,2,2,2,$vararg_buffer67);
 HEAP32[$vararg_buffer71>>2] = 1;
 _qspAddOperation(23,8,0,2,1,1,$vararg_buffer71);
 HEAP32[$vararg_buffer74>>2] = 1;
 _qspAddOperation(24,8,0,2,1,1,$vararg_buffer74);
 HEAP32[$vararg_buffer77>>2] = 2;
 _qspAddOperation(22,8,0,2,1,1,$vararg_buffer77);
 HEAP32[$vararg_buffer80>>2] = 0;
 $vararg_ptr83 = ((($vararg_buffer80)) + 4|0);
 HEAP32[$vararg_ptr83>>2] = 0;
 $vararg_ptr84 = ((($vararg_buffer80)) + 8|0);
 HEAP32[$vararg_ptr84>>2] = 0;
 $vararg_ptr85 = ((($vararg_buffer80)) + 12|0);
 HEAP32[$vararg_ptr85>>2] = 0;
 $vararg_ptr86 = ((($vararg_buffer80)) + 16|0);
 HEAP32[$vararg_ptr86>>2] = 0;
 $vararg_ptr87 = ((($vararg_buffer80)) + 20|0);
 HEAP32[$vararg_ptr87>>2] = 0;
 $vararg_ptr88 = ((($vararg_buffer80)) + 24|0);
 HEAP32[$vararg_ptr88>>2] = 0;
 $vararg_ptr89 = ((($vararg_buffer80)) + 28|0);
 HEAP32[$vararg_ptr89>>2] = 0;
 $vararg_ptr90 = ((($vararg_buffer80)) + 32|0);
 HEAP32[$vararg_ptr90>>2] = 0;
 $vararg_ptr91 = ((($vararg_buffer80)) + 36|0);
 HEAP32[$vararg_ptr91>>2] = 0;
 _qspAddOperation(25,30,50,0,1,10,$vararg_buffer80);
 HEAP32[$vararg_buffer92>>2] = 0;
 $vararg_ptr95 = ((($vararg_buffer92)) + 4|0);
 HEAP32[$vararg_ptr95>>2] = 0;
 $vararg_ptr96 = ((($vararg_buffer92)) + 8|0);
 HEAP32[$vararg_ptr96>>2] = 0;
 $vararg_ptr97 = ((($vararg_buffer92)) + 12|0);
 HEAP32[$vararg_ptr97>>2] = 0;
 $vararg_ptr98 = ((($vararg_buffer92)) + 16|0);
 HEAP32[$vararg_ptr98>>2] = 0;
 $vararg_ptr99 = ((($vararg_buffer92)) + 20|0);
 HEAP32[$vararg_ptr99>>2] = 0;
 $vararg_ptr100 = ((($vararg_buffer92)) + 24|0);
 HEAP32[$vararg_ptr100>>2] = 0;
 $vararg_ptr101 = ((($vararg_buffer92)) + 28|0);
 HEAP32[$vararg_ptr101>>2] = 0;
 $vararg_ptr102 = ((($vararg_buffer92)) + 32|0);
 HEAP32[$vararg_ptr102>>2] = 0;
 $vararg_ptr103 = ((($vararg_buffer92)) + 36|0);
 HEAP32[$vararg_ptr103>>2] = 0;
 _qspAddOperation(26,30,51,0,1,10,$vararg_buffer92);
 HEAP32[$vararg_buffer104>>2] = 2;
 $vararg_ptr107 = ((($vararg_buffer104)) + 4|0);
 HEAP32[$vararg_ptr107>>2] = 2;
 _qspAddOperation(27,30,52,2,1,2,$vararg_buffer104);
 HEAP32[$vararg_buffer108>>2] = 2;
 $vararg_ptr111 = ((($vararg_buffer108)) + 4|0);
 HEAP32[$vararg_ptr111>>2] = 0;
 $vararg_ptr112 = ((($vararg_buffer108)) + 8|0);
 HEAP32[$vararg_ptr112>>2] = 0;
 _qspAddOperation(28,30,0,0,3,3,$vararg_buffer108);
 HEAP32[$vararg_buffer113>>2] = 2;
 $vararg_ptr116 = ((($vararg_buffer113)) + 4|0);
 HEAP32[$vararg_ptr116>>2] = 2;
 $vararg_ptr117 = ((($vararg_buffer113)) + 8|0);
 HEAP32[$vararg_ptr117>>2] = 2;
 $vararg_ptr118 = ((($vararg_buffer113)) + 12|0);
 HEAP32[$vararg_ptr118>>2] = 2;
 _qspAddOperation(29,30,53,2,3,4,$vararg_buffer113);
 HEAP32[$vararg_buffer119>>2] = 1;
 _qspAddOperation(30,30,0,2,1,1,$vararg_buffer119);
 HEAP32[$vararg_buffer122>>2] = 0;
 _qspAddOperation(31,30,0,2,1,1,$vararg_buffer122);
 HEAP32[$vararg_buffer125>>2] = 1;
 _qspAddOperation(32,30,0,1,1,1,$vararg_buffer125);
 HEAP32[$vararg_buffer128>>2] = 1;
 _qspAddOperation(33,30,0,1,1,1,$vararg_buffer128);
 HEAP32[$vararg_buffer131>>2] = 1;
 _qspAddOperation(34,30,0,1,1,1,$vararg_buffer131);
 HEAP32[$vararg_buffer134>>2] = 1;
 _qspAddOperation(35,30,0,1,1,1,$vararg_buffer134);
 HEAP32[$vararg_buffer137>>2] = 0;
 _qspAddOperation(36,30,0,2,1,1,$vararg_buffer137);
 HEAP32[$vararg_buffer140>>2] = 1;
 _qspAddOperation(37,30,0,2,1,1,$vararg_buffer140);
 HEAP32[$vararg_buffer143>>2] = 1;
 _qspAddOperation(38,30,54,2,1,1,$vararg_buffer143);
 HEAP32[$vararg_buffer146>>2] = 1;
 _qspAddOperation(39,30,55,1,1,1,$vararg_buffer146);
 HEAP32[$vararg_buffer149>>2] = 1;
 _qspAddOperation(40,30,0,1,1,1,$vararg_buffer149);
 HEAP32[$vararg_buffer152>>2] = 2;
 _qspAddOperation(41,30,56,1,1,1,$vararg_buffer152);
 HEAP32[$vararg_buffer155>>2] = 1;
 $vararg_ptr158 = ((($vararg_buffer155)) + 4|0);
 HEAP32[$vararg_ptr158>>2] = 1;
 _qspAddOperation(42,30,57,2,2,2,$vararg_buffer155);
 HEAP32[$vararg_buffer159>>2] = 1;
 $vararg_ptr162 = ((($vararg_buffer159)) + 4|0);
 HEAP32[$vararg_ptr162>>2] = 1;
 $vararg_ptr163 = ((($vararg_buffer159)) + 8|0);
 HEAP32[$vararg_ptr163>>2] = 2;
 _qspAddOperation(43,30,58,1,2,3,$vararg_buffer159);
 HEAP32[$vararg_buffer164>>2] = 1;
 $vararg_ptr167 = ((($vararg_buffer164)) + 4|0);
 HEAP32[$vararg_ptr167>>2] = 1;
 $vararg_ptr168 = ((($vararg_buffer164)) + 8|0);
 HEAP32[$vararg_ptr168>>2] = 2;
 _qspAddOperation(44,30,59,2,2,3,$vararg_buffer164);
 HEAP32[$vararg_buffer169>>2] = 1;
 $vararg_ptr172 = ((($vararg_buffer169)) + 4|0);
 HEAP32[$vararg_ptr172>>2] = 2;
 $vararg_ptr173 = ((($vararg_buffer169)) + 8|0);
 HEAP32[$vararg_ptr173>>2] = 2;
 _qspAddOperation(45,30,60,1,2,3,$vararg_buffer169);
 HEAP32[$vararg_buffer174>>2] = 1;
 $vararg_ptr177 = ((($vararg_buffer174)) + 4|0);
 HEAP32[$vararg_ptr177>>2] = 0;
 $vararg_ptr178 = ((($vararg_buffer174)) + 8|0);
 HEAP32[$vararg_ptr178>>2] = 2;
 _qspAddOperation(46,30,61,2,2,3,$vararg_buffer174);
 HEAP32[$vararg_buffer179>>2] = 1;
 $vararg_ptr182 = ((($vararg_buffer179)) + 4|0);
 HEAP32[$vararg_ptr182>>2] = 0;
 $vararg_ptr183 = ((($vararg_buffer179)) + 8|0);
 HEAP32[$vararg_ptr183>>2] = 2;
 _qspAddOperation(47,30,62,2,2,3,$vararg_buffer179);
 HEAP32[$vararg_buffer184>>2] = 1;
 $vararg_ptr187 = ((($vararg_buffer184)) + 4|0);
 HEAP32[$vararg_ptr187>>2] = 1;
 $vararg_ptr188 = ((($vararg_buffer184)) + 8|0);
 HEAP32[$vararg_ptr188>>2] = 2;
 _qspAddOperation(48,30,63,2,2,3,$vararg_buffer184);
 HEAP32[$vararg_buffer189>>2] = 1;
 $vararg_ptr192 = ((($vararg_buffer189)) + 4|0);
 HEAP32[$vararg_ptr192>>2] = 1;
 $vararg_ptr193 = ((($vararg_buffer189)) + 8|0);
 HEAP32[$vararg_ptr193>>2] = 1;
 _qspAddOperation(49,30,64,1,2,3,$vararg_buffer189);
 HEAP32[$vararg_buffer194>>2] = 1;
 $vararg_ptr197 = ((($vararg_buffer194)) + 4|0);
 HEAP32[$vararg_ptr197>>2] = 0;
 $vararg_ptr198 = ((($vararg_buffer194)) + 8|0);
 HEAP32[$vararg_ptr198>>2] = 0;
 $vararg_ptr199 = ((($vararg_buffer194)) + 12|0);
 HEAP32[$vararg_ptr199>>2] = 0;
 $vararg_ptr200 = ((($vararg_buffer194)) + 16|0);
 HEAP32[$vararg_ptr200>>2] = 0;
 $vararg_ptr201 = ((($vararg_buffer194)) + 20|0);
 HEAP32[$vararg_ptr201>>2] = 0;
 $vararg_ptr202 = ((($vararg_buffer194)) + 24|0);
 HEAP32[$vararg_ptr202>>2] = 0;
 $vararg_ptr203 = ((($vararg_buffer194)) + 28|0);
 HEAP32[$vararg_ptr203>>2] = 0;
 $vararg_ptr204 = ((($vararg_buffer194)) + 32|0);
 HEAP32[$vararg_ptr204>>2] = 0;
 $vararg_ptr205 = ((($vararg_buffer194)) + 36|0);
 HEAP32[$vararg_ptr205>>2] = 0;
 _qspAddOperation(50,30,65,0,1,10,$vararg_buffer194);
 HEAP32[$vararg_buffer206>>2] = 1;
 $vararg_ptr209 = ((($vararg_buffer206)) + 4|0);
 HEAP32[$vararg_ptr209>>2] = 0;
 $vararg_ptr210 = ((($vararg_buffer206)) + 8|0);
 HEAP32[$vararg_ptr210>>2] = 0;
 $vararg_ptr211 = ((($vararg_buffer206)) + 12|0);
 HEAP32[$vararg_ptr211>>2] = 0;
 $vararg_ptr212 = ((($vararg_buffer206)) + 16|0);
 HEAP32[$vararg_ptr212>>2] = 0;
 $vararg_ptr213 = ((($vararg_buffer206)) + 20|0);
 HEAP32[$vararg_ptr213>>2] = 0;
 $vararg_ptr214 = ((($vararg_buffer206)) + 24|0);
 HEAP32[$vararg_ptr214>>2] = 0;
 $vararg_ptr215 = ((($vararg_buffer206)) + 28|0);
 HEAP32[$vararg_ptr215>>2] = 0;
 $vararg_ptr216 = ((($vararg_buffer206)) + 32|0);
 HEAP32[$vararg_ptr216>>2] = 0;
 $vararg_ptr217 = ((($vararg_buffer206)) + 36|0);
 HEAP32[$vararg_ptr217>>2] = 0;
 _qspAddOperation(51,30,66,0,1,10,$vararg_buffer206);
 _qspAddOperation(52,30,0,2,0,0,$vararg_buffer218);
 _qspAddOperation(53,30,0,2,0,0,$vararg_buffer220);
 _qspAddOperation(54,30,0,2,0,0,$vararg_buffer222);
 _qspAddOperation(55,30,0,1,0,0,$vararg_buffer224);
 _qspAddOperation(56,30,0,1,0,0,$vararg_buffer226);
 _qspAddOperation(57,30,0,1,0,0,$vararg_buffer228);
 _qspAddOperation(58,30,0,1,0,0,$vararg_buffer230);
 _qspAddOperation(59,30,0,1,0,0,$vararg_buffer232);
 _qspAddOperation(60,30,0,1,0,0,$vararg_buffer234);
 _qspAddOperation(61,30,0,1,0,0,$vararg_buffer236);
 _qspAddOperation(62,30,0,1,0,0,$vararg_buffer238);
 HEAP32[$vararg_buffer240>>2] = 1;
 _qspAddOperation(63,30,0,1,1,1,$vararg_buffer240);
 _qspAddOpName(7,446278,1);
 _qspAddOpName(10,444364,1);
 _qspAddOpName(11,444376,1);
 _qspAddOpName(8,444280,1);
 _qspAddOpName(9,444380,1);
 _qspAddOpName(12,443268,1);
 _qspAddOpName(13,446308,1);
 _qspAddOpName(13,443276,0);
 _qspAddOpName(14,443282,0);
 _qspAddOpName(14,443288,0);
 _qspAddOpName(15,443294,0);
 _qspAddOpName(15,443300,0);
 _qspAddOpName(16,446304,1);
 _qspAddOpName(17,443306,1);
 _qspAddOpName(18,443310,1);
 _qspAddOpName(21,446300,1);
 _qspAddOpName(6,446282,1);
 _qspAddOpName(19,443314,1);
 _qspAddOpName(20,443322,1);
 _qspAddOpName(23,443328,1);
 _qspAddOpName(24,443336,1);
 _qspAddOpName(22,443344,1);
 _qspAddOpName(25,443350,1);
 _qspAddOpName(25,443358,1);
 _qspAddOpName(26,443368,1);
 _qspAddOpName(26,443376,1);
 _qspAddOpName(27,443386,1);
 _qspAddOpName(28,443396,1);
 _qspAddOpName(28,443404,1);
 _qspAddOpName(29,443414,1);
 _qspAddOpName(30,443422,1);
 _qspAddOpName(31,443430,1);
 _qspAddOpName(32,443442,1);
 _qspAddOpName(32,443454,1);
 _qspAddOpName(33,443468,1);
 _qspAddOpName(33,443480,1);
 _qspAddOpName(34,443494,1);
 _qspAddOpName(34,443506,1);
 _qspAddOpName(35,443520,1);
 _qspAddOpName(35,443528,1);
 _qspAddOpName(36,443538,1);
 _qspAddOpName(37,443546,1);
 _qspAddOpName(38,443562,1);
 _qspAddOpName(39,443576,1);
 _qspAddOpName(39,443586,1);
 _qspAddOpName(40,443598,1);
 _qspAddOpName(40,443608,1);
 _qspAddOpName(41,443620,1);
 _qspAddOpName(41,443634,1);
 _qspAddOpName(42,443650,1);
 _qspAddOpName(43,443666,1);
 _qspAddOpName(43,443682,1);
 _qspAddOpName(44,443700,1);
 _qspAddOpName(45,443714,1);
 _qspAddOpName(45,443722,1);
 _qspAddOpName(46,443732,1);
 _qspAddOpName(47,443746,1);
 _qspAddOpName(48,443762,1);
 _qspAddOpName(49,443774,1);
 _qspAddOpName(49,443790,1);
 _qspAddOpName(50,443808,1);
 _qspAddOpName(50,443818,1);
 _qspAddOpName(51,443830,1);
 _qspAddOpName(51,443846,1);
 _qspAddOpName(52,443864,1);
 _qspAddOpName(53,443872,1);
 _qspAddOpName(54,443890,1);
 _qspAddOpName(55,443912,1);
 _qspAddOpName(55,443926,1);
 _qspAddOpName(56,443942,1);
 _qspAddOpName(56,443962,1);
 _qspAddOpName(56,443984,1);
 _qspAddOpName(56,443998,1);
 _qspAddOpName(57,444014,1);
 _qspAddOpName(57,444028,1);
 _qspAddOpName(58,444044,1);
 _qspAddOpName(58,444058,1);
 _qspAddOpName(59,444074,1);
 _qspAddOpName(59,444088,1);
 _qspAddOpName(60,444104,1);
 _qspAddOpName(60,444120,1);
 _qspAddOpName(61,444138,1);
 _qspAddOpName(61,444154,1);
 _qspAddOpName(62,444172,1);
 _qspAddOpName(62,444188,1);
 _qspAddOpName(63,444206,1);
 _qspAddOpName(63,444226,1);
 $i = 0;
 while(1) {
  $6 = $i;
  $7 = ($6|0)<(2);
  if (!($7)) {
   break;
  }
  $8 = $i;
  $9 = (4392 + (($8*1200)|0)|0);
  $10 = $i;
  $11 = (4384 + ($10<<2)|0);
  $12 = HEAP32[$11>>2]|0;
  _qsort($9,$12,12,67);
  $13 = $i;
  $14 = (($13) + 1)|0;
  $i = $14;
 }
 STACKTOP = sp;return;
}
function _qspExprValue($agg$result,$expr) {
 $agg$result = $agg$result|0;
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $compArgsCounts = 0, $compOpCodes = 0, $compValues = 0, $itemsCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1616|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $compValues = sp + 808|0;
 $compOpCodes = sp + 408|0;
 $compArgsCounts = sp + 8|0;
 $0 = $expr;
 $1 = $0;
 $2 = (_qspCompileExpression($1,$compValues,$compOpCodes,$compArgsCounts)|0);
 $itemsCount = $2;
 $3 = ($2|0)!=(0);
 if ($3) {
  $4 = $itemsCount;
  _qspValue($agg$result,$4,$compValues,$compOpCodes,$compArgsCounts);
  STACKTOP = sp;return;
 } else {
  _qspGetEmptyVariant($agg$result,0);
  STACKTOP = sp;return;
 }
}
function _qspAddOperation($opCode,$priority,$func,$resType,$minArgs,$maxArgs,$varargs) {
 $opCode = $opCode|0;
 $priority = $priority|0;
 $func = $func|0;
 $resType = $resType|0;
 $minArgs = $minArgs|0;
 $maxArgs = $maxArgs|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $arglist_current = 0, $arglist_next = 0, $expanded = 0, $expanded2 = 0, $expanded4 = 0, $expanded5 = 0, $expanded6 = 0, $i = 0, $marker = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $marker = sp;
 $0 = $opCode;
 $1 = $priority;
 $2 = $func;
 $3 = $resType;
 $4 = $minArgs;
 $5 = $maxArgs;
 $6 = $1;
 $7 = $0;
 $8 = (6792 + (($7*60)|0)|0);
 HEAP32[$8>>2] = $6;
 $9 = $2;
 $10 = $0;
 $11 = (6792 + (($10*60)|0)|0);
 $12 = ((($11)) + 56|0);
 HEAP32[$12>>2] = $9;
 $13 = $3;
 $14 = $0;
 $15 = (6792 + (($14*60)|0)|0);
 $16 = ((($15)) + 4|0);
 HEAP32[$16>>2] = $13;
 $17 = $4;
 $18 = $0;
 $19 = (6792 + (($18*60)|0)|0);
 $20 = ((($19)) + 8|0);
 HEAP32[$20>>2] = $17;
 $21 = $5;
 $22 = $0;
 $23 = (6792 + (($22*60)|0)|0);
 $24 = ((($23)) + 12|0);
 HEAP32[$24>>2] = $21;
 $25 = $5;
 $26 = ($25|0)>(0);
 if (!($26)) {
  STACKTOP = sp;return;
 }
 HEAP32[$marker>>2] = $varargs;
 $i = 0;
 while(1) {
  $27 = $i;
  $28 = $5;
  $29 = ($27|0)<($28|0);
  if (!($29)) {
   break;
  }
  $arglist_current = HEAP32[$marker>>2]|0;
  $30 = $arglist_current;
  $31 = ((0) + 4|0);
  $expanded2 = $31;
  $expanded = (($expanded2) - 1)|0;
  $32 = (($30) + ($expanded))|0;
  $33 = ((0) + 4|0);
  $expanded6 = $33;
  $expanded5 = (($expanded6) - 1)|0;
  $expanded4 = $expanded5 ^ -1;
  $34 = $32 & $expanded4;
  $35 = $34;
  $36 = HEAP32[$35>>2]|0;
  $arglist_next = ((($35)) + 4|0);
  HEAP32[$marker>>2] = $arglist_next;
  $37 = $i;
  $38 = $0;
  $39 = (6792 + (($38*60)|0)|0);
  $40 = ((($39)) + 16|0);
  $41 = (($40) + ($37<<2)|0);
  HEAP32[$41>>2] = $36;
  $42 = $i;
  $43 = (($42) + 1)|0;
  $i = $43;
 }
 STACKTOP = sp;return;
}
function _qspFunctionMin($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $minInd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $3 = sp;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $4 = $1;
 $5 = ($4|0)==(1);
 if ($5) {
  $6 = $0;
  (_qspConvertVariantTo($6,1)|0);
  $7 = $2;
  $8 = $0;
  $9 = HEAP32[$8>>2]|0;
  _qspArrayMinMaxItem($3,$9,1);
  ;HEAP32[$7>>2]=HEAP32[$3>>2]|0;HEAP32[$7+4>>2]=HEAP32[$3+4>>2]|0;
  STACKTOP = sp;return;
 }
 $minInd = 0;
 $i = 1;
 while(1) {
  $10 = $i;
  $11 = $1;
  $12 = ($10|0)<($11|0);
  if (!($12)) {
   break;
  }
  $13 = $0;
  $14 = $i;
  $15 = (($13) + ($14<<3)|0);
  $16 = $0;
  $17 = $minInd;
  $18 = (($16) + ($17<<3)|0);
  $19 = (_qspAutoConvertCompare($15,$18)|0);
  $20 = ($19|0)<(0);
  if ($20) {
   $21 = $i;
   $minInd = $21;
  }
  $22 = $i;
  $23 = (($22) + 1)|0;
  $i = $23;
 }
 $24 = $2;
 $25 = $0;
 $26 = $minInd;
 $27 = (($25) + ($26<<3)|0);
 _qspCopyVariant($24,$27);
 STACKTOP = sp;return;
}
function _qspFunctionMax($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $maxInd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $3 = sp;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $4 = $1;
 $5 = ($4|0)==(1);
 if ($5) {
  $6 = $0;
  (_qspConvertVariantTo($6,1)|0);
  $7 = $2;
  $8 = $0;
  $9 = HEAP32[$8>>2]|0;
  _qspArrayMinMaxItem($3,$9,0);
  ;HEAP32[$7>>2]=HEAP32[$3>>2]|0;HEAP32[$7+4>>2]=HEAP32[$3+4>>2]|0;
  STACKTOP = sp;return;
 }
 $maxInd = 0;
 $i = 1;
 while(1) {
  $10 = $i;
  $11 = $1;
  $12 = ($10|0)<($11|0);
  if (!($12)) {
   break;
  }
  $13 = $0;
  $14 = $i;
  $15 = (($13) + ($14<<3)|0);
  $16 = $0;
  $17 = $maxInd;
  $18 = (($16) + ($17<<3)|0);
  $19 = (_qspAutoConvertCompare($15,$18)|0);
  $20 = ($19|0)>(0);
  if ($20) {
   $21 = $i;
   $maxInd = $21;
  }
  $22 = $i;
  $23 = (($22) + 1)|0;
  $i = $23;
 }
 $24 = $2;
 $25 = $0;
 $26 = $maxInd;
 $27 = (($25) + ($26<<3)|0);
 _qspCopyVariant($24,$27);
 STACKTOP = sp;return;
}
function _qspFunctionRand($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $max = 0, $min = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $min = $4;
 $5 = $1;
 $6 = ($5|0)==(2);
 if ($6) {
  $7 = $0;
  $8 = ((($7)) + 8|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = $9;
 } else {
  $10 = 0;
 }
 $max = $10;
 $11 = $min;
 $12 = $max;
 $13 = ($11|0)>($12|0);
 if ($13) {
  $14 = $max;
  $min = $14;
  $15 = $0;
  $16 = HEAP32[$15>>2]|0;
  $max = $16;
 }
 $17 = (_qspRand()|0);
 $18 = $max;
 $19 = $min;
 $20 = (($18) - ($19))|0;
 $21 = (($20) + 1)|0;
 $22 = (($17|0) % ($21|0))&-1;
 $23 = $min;
 $24 = (($22) + ($23))|0;
 $25 = $2;
 HEAP32[$25>>2] = $24;
 STACKTOP = sp;return;
}
function _qspFunctionRGB($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $a = 0, $b = 0, $g = 0, $r = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $a = 255;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $r = $4;
 $5 = $0;
 $6 = ((($5)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $g = $7;
 $8 = $0;
 $9 = ((($8)) + 16|0);
 $10 = HEAP32[$9>>2]|0;
 $b = $10;
 $11 = $1;
 $12 = ($11|0)==(4);
 do {
  if ($12) {
   $13 = $0;
   $14 = ((($13)) + 24|0);
   $15 = HEAP32[$14>>2]|0;
   $a = $15;
   $16 = $a;
   $17 = ($16|0)<(0);
   if ($17) {
    $a = 0;
    break;
   }
   $18 = $a;
   $19 = ($18|0)>(255);
   if ($19) {
    $a = 255;
   }
  }
 } while(0);
 $20 = $r;
 $21 = ($20|0)<(0);
 if ($21) {
  $r = 0;
 } else {
  $22 = $r;
  $23 = ($22|0)>(255);
  if ($23) {
   $r = 255;
  }
 }
 $24 = $g;
 $25 = ($24|0)<(0);
 if ($25) {
  $g = 0;
 } else {
  $26 = $g;
  $27 = ($26|0)>(255);
  if ($27) {
   $g = 255;
  }
 }
 $28 = $b;
 $29 = ($28|0)<(0);
 if ($29) {
  $b = 0;
 } else {
  $30 = $b;
  $31 = ($30|0)>(255);
  if ($31) {
   $b = 255;
  }
 }
 $32 = $a;
 $33 = $32 << 24;
 $34 = $b;
 $35 = $34 << 16;
 $36 = $33 | $35;
 $37 = $g;
 $38 = $37 << 8;
 $39 = $36 | $38;
 $40 = $r;
 $41 = $39 | $40;
 $42 = $2;
 HEAP32[$42>>2] = $41;
 STACKTOP = sp;return;
}
function _qspFunctionIsPlay($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $5 = (_qspIsAnyString($4)|0);
 $6 = ($5|0)!=(0);
 if ($6) {
  $7 = $0;
  $8 = HEAP32[$7>>2]|0;
  $9 = (_qspGetAbsFromRelPath($8)|0);
  $file = $9;
  $10 = $file;
  $11 = (_qspCallIsPlayingFile($10)|0);
  $12 = ($11|0)!=(0);
  $13 = $12&1;
  $14 = (0 - ($13))|0;
  $15 = $2;
  HEAP32[$15>>2] = $14;
  $16 = $file;
  _free($16);
  STACKTOP = sp;return;
 } else {
  $17 = $2;
  HEAP32[$17>>2] = 0;
  STACKTOP = sp;return;
 }
}
function _qspFunctionDesc($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $desc = 0, $index = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $5 = (_qspLocIndex($4)|0);
 $index = $5;
 $6 = $index;
 $7 = ($6|0)<(0);
 if ($7) {
  _qspSetError(111);
  STACKTOP = sp;return;
 }
 $8 = $index;
 $9 = HEAP32[320488>>2]|0;
 $10 = (($9) + (($8*816)|0)|0);
 $11 = ((($10)) + 4|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = (_qspFormatText($12,0)|0);
 $desc = $13;
 $14 = ($13|0)!=(0|0);
 if (!($14)) {
  STACKTOP = sp;return;
 }
 $15 = $desc;
 $16 = $2;
 HEAP32[$16>>2] = $15;
 STACKTOP = sp;return;
}
function _qspFunctionGetObj($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ind = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = HEAP32[$3>>2]|0;
 $5 = (($4) - 1)|0;
 $ind = $5;
 $6 = $ind;
 $7 = ($6|0)>=(0);
 if ($7) {
  $8 = $ind;
  $9 = HEAP32[320512>>2]|0;
  $10 = ($8|0)<($9|0);
  if ($10) {
   $11 = $ind;
   $12 = (320528 + ($11<<3)|0);
   $13 = ((($12)) + 4|0);
   $14 = HEAP32[$13>>2]|0;
   $15 = (_qspGetNewText($14,-1)|0);
   $16 = $2;
   HEAP32[$16>>2] = $15;
   STACKTOP = sp;return;
  }
 }
 $17 = (_qspGetNewText(447354,0)|0);
 $18 = $2;
 HEAP32[$18>>2] = $17;
 STACKTOP = sp;return;
}
function _qspFunctionStrComp($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $onigExp = 0, $onigInfo = 0;
 var $tempBeg = 0, $tempEnd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $onigExp = sp + 12|0;
 $onigInfo = sp;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $tempBeg = $5;
 $6 = $0;
 $7 = ((($6)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_qspStrEnd($8)|0);
 $tempEnd = $9;
 $10 = $tempBeg;
 $11 = $tempEnd;
 $12 = HEAP8[10632>>0]|0;
 $13 = $12 << 24 >> 24;
 $14 = ($13|0)==(1);
 $15 = $14 ? 441256 : 440168;
 $16 = (_onig_new($onigExp,$10,$11,0,$15,336328,$onigInfo)|0);
 $17 = ($16|0)!=(0);
 if ($17) {
  _qspSetError(124);
  STACKTOP = sp;return;
 } else {
  $18 = $0;
  $19 = HEAP32[$18>>2]|0;
  $tempBeg = $19;
  $20 = $0;
  $21 = HEAP32[$20>>2]|0;
  $22 = (_qspStrEnd($21)|0);
  $tempEnd = $22;
  $23 = HEAP32[$onigExp>>2]|0;
  $24 = $tempBeg;
  $25 = $tempEnd;
  $26 = $tempBeg;
  $27 = (_onig_match($23,$24,$25,$26,0,0)|0);
  $28 = $tempEnd;
  $29 = $tempBeg;
  $30 = $28;
  $31 = $29;
  $32 = (($30) - ($31))|0;
  $33 = ($27|0)==($32|0);
  $34 = $33&1;
  $35 = (0 - ($34))|0;
  $36 = $2;
  HEAP32[$36>>2] = $35;
  $37 = HEAP32[$onigExp>>2]|0;
  _onig_free($37);
  STACKTOP = sp;return;
 }
}
function _qspFunctionStrFind($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $9 = 0, $len = 0, $onigExp = 0, $onigInfo = 0, $onigReg = 0, $pos = 0, $tempBeg = 0, $tempEnd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $onigExp = sp + 16|0;
 $onigInfo = sp;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $tempBeg = $5;
 $6 = $0;
 $7 = ((($6)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_qspStrEnd($8)|0);
 $tempEnd = $9;
 $10 = $tempBeg;
 $11 = $tempEnd;
 $12 = HEAP8[10632>>0]|0;
 $13 = $12 << 24 >> 24;
 $14 = ($13|0)==(1);
 $15 = $14 ? 441256 : 440168;
 $16 = (_onig_new($onigExp,$10,$11,0,$15,336328,$onigInfo)|0);
 $17 = ($16|0)!=(0);
 if ($17) {
  _qspSetError(124);
  STACKTOP = sp;return;
 }
 $18 = (_onig_region_new()|0);
 $onigReg = $18;
 $19 = $0;
 $20 = HEAP32[$19>>2]|0;
 $tempBeg = $20;
 $21 = $0;
 $22 = HEAP32[$21>>2]|0;
 $23 = (_qspStrEnd($22)|0);
 $tempEnd = $23;
 $24 = $1;
 $25 = ($24|0)==(3);
 if ($25) {
  $26 = $0;
  $27 = ((($26)) + 16|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = ($28|0)>=(0);
  if ($29) {
   $30 = $0;
   $31 = ((($30)) + 16|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = $32;
  } else {
   $33 = 0;
  }
 } else {
  $33 = 0;
 }
 $pos = $33;
 $34 = HEAP32[$onigExp>>2]|0;
 $35 = $tempBeg;
 $36 = $tempEnd;
 $37 = $tempBeg;
 $38 = $tempEnd;
 $39 = $onigReg;
 $40 = (_onig_search($34,$35,$36,$37,$38,$39,0)|0);
 $41 = ($40|0)>=(0);
 if ($41) {
  $42 = $pos;
  $43 = $onigReg;
  $44 = ((($43)) + 4|0);
  $45 = HEAP32[$44>>2]|0;
  $46 = ($42|0)<($45|0);
  if ($46) {
   $47 = $pos;
   $48 = $onigReg;
   $49 = ((($48)) + 8|0);
   $50 = HEAP32[$49>>2]|0;
   $51 = (($50) + ($47<<2)|0);
   $52 = HEAP32[$51>>2]|0;
   $53 = ($52|0)>=(0);
   if ($53) {
    $54 = $pos;
    $55 = $onigReg;
    $56 = ((($55)) + 12|0);
    $57 = HEAP32[$56>>2]|0;
    $58 = (($57) + ($54<<2)|0);
    $59 = HEAP32[$58>>2]|0;
    $60 = $pos;
    $61 = $onigReg;
    $62 = ((($61)) + 8|0);
    $63 = HEAP32[$62>>2]|0;
    $64 = (($63) + ($60<<2)|0);
    $65 = HEAP32[$64>>2]|0;
    $66 = (($59) - ($65))|0;
    $67 = (($66>>>0) / 2)&-1;
    $len = $67;
    $68 = $tempBeg;
    $69 = $pos;
    $70 = $onigReg;
    $71 = ((($70)) + 8|0);
    $72 = HEAP32[$71>>2]|0;
    $73 = (($72) + ($69<<2)|0);
    $74 = HEAP32[$73>>2]|0;
    $75 = (($68) + ($74)|0);
    $76 = $len;
    $77 = (_qspGetNewText($75,$76)|0);
    $78 = $2;
    HEAP32[$78>>2] = $77;
   } else {
    label = 10;
   }
  } else {
   label = 10;
  }
 } else {
  label = 10;
 }
 if ((label|0) == 10) {
  $79 = (_qspGetNewText(447354,0)|0);
  $80 = $2;
  HEAP32[$80>>2] = $79;
 }
 $81 = $onigReg;
 _onig_region_free($81,1);
 $82 = HEAP32[$onigExp>>2]|0;
 _onig_free($82);
 STACKTOP = sp;return;
}
function _qspFunctionStrPos($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $7 = 0, $8 = 0, $9 = 0, $onigExp = 0, $onigInfo = 0, $onigReg = 0, $pos = 0, $tempBeg = 0, $tempEnd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $onigExp = sp + 16|0;
 $onigInfo = sp;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $tempBeg = $5;
 $6 = $0;
 $7 = ((($6)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_qspStrEnd($8)|0);
 $tempEnd = $9;
 $10 = $tempBeg;
 $11 = $tempEnd;
 $12 = HEAP8[10632>>0]|0;
 $13 = $12 << 24 >> 24;
 $14 = ($13|0)==(1);
 $15 = $14 ? 441256 : 440168;
 $16 = (_onig_new($onigExp,$10,$11,0,$15,336328,$onigInfo)|0);
 $17 = ($16|0)!=(0);
 if ($17) {
  _qspSetError(124);
  STACKTOP = sp;return;
 }
 $18 = (_onig_region_new()|0);
 $onigReg = $18;
 $19 = $0;
 $20 = HEAP32[$19>>2]|0;
 $tempBeg = $20;
 $21 = $0;
 $22 = HEAP32[$21>>2]|0;
 $23 = (_qspStrEnd($22)|0);
 $tempEnd = $23;
 $24 = $1;
 $25 = ($24|0)==(3);
 if ($25) {
  $26 = $0;
  $27 = ((($26)) + 16|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = ($28|0)>=(0);
  if ($29) {
   $30 = $0;
   $31 = ((($30)) + 16|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = $32;
  } else {
   $33 = 0;
  }
 } else {
  $33 = 0;
 }
 $pos = $33;
 $34 = HEAP32[$onigExp>>2]|0;
 $35 = $tempBeg;
 $36 = $tempEnd;
 $37 = $tempBeg;
 $38 = $tempEnd;
 $39 = $onigReg;
 $40 = (_onig_search($34,$35,$36,$37,$38,$39,0)|0);
 $41 = ($40|0)>=(0);
 if ($41) {
  $42 = $pos;
  $43 = $onigReg;
  $44 = ((($43)) + 4|0);
  $45 = HEAP32[$44>>2]|0;
  $46 = ($42|0)<($45|0);
  if ($46) {
   $47 = $pos;
   $48 = $onigReg;
   $49 = ((($48)) + 8|0);
   $50 = HEAP32[$49>>2]|0;
   $51 = (($50) + ($47<<2)|0);
   $52 = HEAP32[$51>>2]|0;
   $53 = ($52|0)>=(0);
   if ($53) {
    $54 = $pos;
    $55 = $onigReg;
    $56 = ((($55)) + 8|0);
    $57 = HEAP32[$56>>2]|0;
    $58 = (($57) + ($54<<2)|0);
    $59 = HEAP32[$58>>2]|0;
    $60 = (($59>>>0) / 2)&-1;
    $61 = (($60) + 1)|0;
    $62 = $2;
    HEAP32[$62>>2] = $61;
   } else {
    label = 10;
   }
  } else {
   label = 10;
  }
 } else {
  label = 10;
 }
 if ((label|0) == 10) {
  $63 = $2;
  HEAP32[$63>>2] = 0;
 }
 $64 = $onigReg;
 _onig_region_free($64,1);
 $65 = HEAP32[$onigExp>>2]|0;
 _onig_free($65);
 STACKTOP = sp;return;
}
function _qspFunctionMid($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $beg = 0;
 var $len = 0, $subLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (($5) - 1)|0;
 $beg = $6;
 $7 = $beg;
 $8 = ($7|0)<(0);
 $$ = $8 ? 0 : $6;
 $beg = $$;
 $9 = $0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_qspStrLen($10)|0);
 $len = $11;
 $12 = $beg;
 $13 = $len;
 $14 = ($12|0)<($13|0);
 if (!($14)) {
  $36 = (_qspGetNewText(447354,0)|0);
  $37 = $2;
  HEAP32[$37>>2] = $36;
  STACKTOP = sp;return;
 }
 $15 = $beg;
 $16 = $len;
 $17 = (($16) - ($15))|0;
 $len = $17;
 $18 = $1;
 $19 = ($18|0)==(3);
 do {
  if ($19) {
   $20 = $0;
   $21 = ((($20)) + 16|0);
   $22 = HEAP32[$21>>2]|0;
   $subLen = $22;
   $23 = $subLen;
   $24 = ($23|0)<(0);
   if ($24) {
    $len = 0;
    break;
   }
   $25 = $subLen;
   $26 = $len;
   $27 = ($25|0)<($26|0);
   if ($27) {
    $28 = $subLen;
    $len = $28;
   }
  }
 } while(0);
 $29 = $0;
 $30 = HEAP32[$29>>2]|0;
 $31 = $beg;
 $32 = (($30) + ($31<<1)|0);
 $33 = $len;
 $34 = (_qspGetNewText($32,$33)|0);
 $35 = $2;
 HEAP32[$35>>2] = $34;
 STACKTOP = sp;return;
}
function _qspFunctionArrPos($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $1;
 $4 = ($3|0)==(2);
 $5 = $0;
 $6 = HEAP32[$5>>2]|0;
 $7 = $0;
 $8 = ((($7)) + 8|0);
 if ($4) {
  $9 = (_qspArrayPos($6,$8,0,0)|0);
  $10 = $2;
  HEAP32[$10>>2] = $9;
  STACKTOP = sp;return;
 } else {
  $11 = $0;
  $12 = ((($11)) + 16|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (_qspArrayPos($6,$8,$13,0)|0);
  $15 = $2;
  HEAP32[$15>>2] = $14;
  STACKTOP = sp;return;
 }
}
function _qspFunctionArrComp($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $1;
 $4 = ($3|0)==(2);
 $5 = $0;
 $6 = HEAP32[$5>>2]|0;
 $7 = $0;
 $8 = ((($7)) + 8|0);
 if ($4) {
  $9 = (_qspArrayPos($6,$8,0,1)|0);
  $10 = $2;
  HEAP32[$10>>2] = $9;
  STACKTOP = sp;return;
 } else {
  $11 = $0;
  $12 = ((($11)) + 16|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (_qspArrayPos($6,$8,$13,1)|0);
  $15 = $2;
  HEAP32[$15>>2] = $14;
  STACKTOP = sp;return;
 }
}
function _qspFunctionInstr($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $beg = 0, $str = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $1;
 $4 = ($3|0)==(2);
 if ($4) {
  $beg = 0;
 } else {
  $5 = $0;
  $6 = ((($5)) + 16|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = (($7) - 1)|0;
  $beg = $8;
  $9 = $beg;
  $10 = ($9|0)<(0);
  $$ = $10 ? 0 : $8;
  $beg = $$;
 }
 $11 = $beg;
 $12 = $0;
 $13 = HEAP32[$12>>2]|0;
 $14 = (_qspStrLen($13)|0);
 $15 = ($11|0)<($14|0);
 if (!($15)) {
  $36 = $2;
  HEAP32[$36>>2] = 0;
  STACKTOP = sp;return;
 }
 $16 = $0;
 $17 = HEAP32[$16>>2]|0;
 $18 = $beg;
 $19 = (($17) + ($18<<1)|0);
 $20 = $0;
 $21 = ((($20)) + 8|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = (_qspStrStr($19,$22)|0);
 $str = $23;
 $24 = $str;
 $25 = ($24|0)!=(0|0);
 if ($25) {
  $26 = $str;
  $27 = $0;
  $28 = HEAP32[$27>>2]|0;
  $29 = $26;
  $30 = $28;
  $31 = (($29) - ($30))|0;
  $32 = (($31|0) / 2)&-1;
  $33 = (($32) + 1)|0;
  $35 = $33;
 } else {
  $35 = 0;
 }
 $34 = $2;
 HEAP32[$34>>2] = $35;
 STACKTOP = sp;return;
}
function _qspFunctionReplace($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $searchTxt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $searchTxt = $5;
 $6 = $searchTxt;
 $7 = HEAP16[$6>>1]|0;
 $8 = ($7<<16>>16)!=(0);
 if (!($8)) {
  $9 = $0;
  $10 = HEAP32[$9>>2]|0;
  $11 = (_qspGetNewText($10,-1)|0);
  $12 = $2;
  HEAP32[$12>>2] = $11;
  STACKTOP = sp;return;
 }
 $13 = $1;
 $14 = ($13|0)==(2);
 $15 = $0;
 $16 = HEAP32[$15>>2]|0;
 $17 = $searchTxt;
 if ($14) {
  $18 = (_qspReplaceText($16,$17,447354)|0);
  $19 = $2;
  HEAP32[$19>>2] = $18;
  STACKTOP = sp;return;
 } else {
  $20 = $0;
  $21 = ((($20)) + 16|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = (_qspReplaceText($16,$17,$22)|0);
  $24 = $2;
  HEAP32[$24>>2] = $23;
  STACKTOP = sp;return;
 }
}
function _qspFunctionFunc($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $oldRefreshCount = 0, $or$cond = 0, $result = 0, $varRes = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $result = sp + 8|0;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = (_qspVarReference(444266,1)|0);
 $varRes = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = $varRes;
 _qspMoveVar($result,$5);
 $6 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $6;
 $7 = $0;
 $8 = HEAP32[$7>>2]|0;
 $9 = $0;
 $10 = ((($9)) + 8|0);
 $11 = $1;
 $12 = (($11) - 1)|0;
 _qspExecLocByNameWithArgs($8,$10,$12);
 $13 = HEAP32[320504>>2]|0;
 $14 = $oldRefreshCount;
 $15 = ($13|0)!=($14|0);
 $16 = HEAP32[320460>>2]|0;
 $17 = ($16|0)!=(0);
 $or$cond = $15 | $17;
 if ($or$cond) {
  _qspEmptyVar($result);
  STACKTOP = sp;return;
 }
 $18 = (_qspVarReference(444266,1)|0);
 $varRes = $18;
 $19 = ($18|0)!=(0|0);
 if ($19) {
  $20 = $varRes;
  $21 = $2;
  _qspApplyResult($20,$21);
  $22 = $varRes;
  _qspEmptyVar($22);
  $23 = $varRes;
  _qspMoveVar($23,$result);
  STACKTOP = sp;return;
 } else {
  _qspEmptyVar($result);
  STACKTOP = sp;return;
 }
}
function _qspFunctionDynEval($args,$count,$tos) {
 $args = $args|0;
 $count = $count|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $oldRefreshCount = 0, $or$cond = 0, $result = 0, $varRes = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $result = sp + 8|0;
 $0 = $args;
 $1 = $count;
 $2 = $tos;
 $3 = (_qspVarReference(444266,1)|0);
 $varRes = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = $varRes;
 _qspMoveVar($result,$5);
 $6 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $6;
 $7 = $0;
 $8 = HEAP32[$7>>2]|0;
 $9 = $0;
 $10 = ((($9)) + 8|0);
 $11 = $1;
 $12 = (($11) - 1)|0;
 _qspExecStringAsCodeWithArgs($8,$10,$12);
 $13 = HEAP32[320504>>2]|0;
 $14 = $oldRefreshCount;
 $15 = ($13|0)!=($14|0);
 $16 = HEAP32[320460>>2]|0;
 $17 = ($16|0)!=(0);
 $or$cond = $15 | $17;
 if ($or$cond) {
  _qspEmptyVar($result);
  STACKTOP = sp;return;
 }
 $18 = (_qspVarReference(444266,1)|0);
 $varRes = $18;
 $19 = ($18|0)!=(0|0);
 if ($19) {
  $20 = $varRes;
  $21 = $2;
  _qspApplyResult($20,$21);
  $22 = $varRes;
  _qspEmptyVar($22);
  $23 = $varRes;
  _qspMoveVar($23,$result);
  STACKTOP = sp;return;
 } else {
  _qspEmptyVar($result);
  STACKTOP = sp;return;
 }
}
function _qspAddOpName($opCode,$opName,$level) {
 $opCode = $opCode|0;
 $opName = $opName|0;
 $level = $level|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $len = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $opCode;
 $1 = $opName;
 $2 = $level;
 $3 = $1;
 $4 = (_qspStrLen($3)|0);
 $len = $4;
 $5 = $2;
 $6 = (4384 + ($5<<2)|0);
 $7 = HEAP32[$6>>2]|0;
 $count = $7;
 $8 = $1;
 $9 = $count;
 $10 = $2;
 $11 = (4392 + (($10*1200)|0)|0);
 $12 = (($11) + (($9*12)|0)|0);
 $13 = ((($12)) + 4|0);
 HEAP32[$13>>2] = $8;
 $14 = $len;
 $15 = $count;
 $16 = $2;
 $17 = (4392 + (($16*1200)|0)|0);
 $18 = (($17) + (($15*12)|0)|0);
 $19 = ((($18)) + 8|0);
 HEAP32[$19>>2] = $14;
 $20 = $0;
 $21 = $count;
 $22 = $2;
 $23 = (4392 + (($22*1200)|0)|0);
 $24 = (($23) + (($21*12)|0)|0);
 HEAP32[$24>>2] = $20;
 $25 = $count;
 $26 = (($25) + 1)|0;
 $27 = $2;
 $28 = (4384 + ($27<<2)|0);
 HEAP32[$28>>2] = $26;
 $29 = $len;
 $30 = HEAP32[4380>>2]|0;
 $31 = ($29|0)>($30|0);
 if (!($31)) {
  STACKTOP = sp;return;
 }
 $32 = $len;
 HEAP32[4380>>2] = $32;
 STACKTOP = sp;return;
}
function _qspMathOpsCompare($opName1,$opName2) {
 $opName1 = $opName1|0;
 $opName2 = $opName2|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $opName1;
 $1 = $opName2;
 $2 = $0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = $1;
 $6 = ((($5)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (_qspStrsComp($4,$7)|0);
 STACKTOP = sp;return ($8|0);
}
function _qspCompileExpression($s,$compValues,$compOpCodes,$compArgsCounts) {
 $s = $s|0;
 $compValues = $compValues|0;
 $compOpCodes = $compOpCodes|0;
 $compArgsCounts = $compArgsCounts|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $argSp = 0, $argStack = 0, $itemsCount = 0, $name = 0, $oldRefreshCount = 0, $opCode = 0, $opSp = 0, $opStack = 0, $or$cond = 0, $or$cond3 = 0, $or$cond5 = 0, $or$cond7 = 0, $v = 0, $v$byval_copy = 0;
 var $v$byval_copy10 = 0, $v$byval_copy11 = 0, $v$byval_copy12 = 0, $v$byval_copy13 = 0, $v$byval_copy8 = 0, $v$byval_copy9 = 0, $waitForOperator = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 368|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $v$byval_copy13 = sp + 360|0;
 $v$byval_copy12 = sp + 352|0;
 $v$byval_copy11 = sp + 344|0;
 $v$byval_copy10 = sp + 336|0;
 $v$byval_copy9 = sp + 328|0;
 $v$byval_copy8 = sp + 320|0;
 $v$byval_copy = sp + 312|0;
 $1 = sp + 300|0;
 $v = sp + 280|0;
 $opStack = sp + 144|0;
 $argStack = sp + 24|0;
 $itemsCount = sp + 16|0;
 $opSp = sp + 12|0;
 $argSp = sp + 8|0;
 $5 = sp;
 HEAP32[$1>>2] = $s;
 $2 = $compValues;
 $3 = $compOpCodes;
 $4 = $compArgsCounts;
 $waitForOperator = 0;
 HEAP32[$itemsCount>>2] = 0;
 HEAP32[$opSp>>2] = -1;
 HEAP32[$argSp>>2] = -1;
 _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,1);
 $6 = HEAP32[320460>>2]|0;
 $7 = ($6|0)!=(0);
 if ($7) {
  $0 = 0;
  $325 = $0;
  STACKTOP = sp;return ($325|0);
 }
 $8 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $8;
 L5: while(1) {
  $9 = HEAP32[$1>>2]|0;
  $10 = (_qspSkipSpaces($9)|0);
  HEAP32[$1>>2] = $10;
  $11 = $waitForOperator;
  $12 = ($11|0)!=(0);
  if ($12) {
   $13 = (_qspOperatorOpCode($1)|0);
   $opCode = $13;
   $14 = $opCode;
   $15 = ($14|0)==(0);
   $16 = $opCode;
   $17 = ($16|0)>=(22);
   $or$cond = $15 | $17;
   if ($or$cond) {
    label = 6;
    break;
   }
   $18 = $opCode;
   $19 = ($18|0)==(19);
   $20 = $opCode;
   $21 = ($20|0)==(20);
   $or$cond3 = $19 | $21;
   $22 = $opCode;
   $23 = ($22|0)==(12);
   $or$cond5 = $or$cond3 | $23;
   if ($or$cond5) {
    $24 = HEAP32[$1>>2]|0;
    $25 = HEAP16[$24>>1]|0;
    $26 = (_qspIsInList(444252,$25)|0);
    $27 = ($26|0)!=(0);
    if (!($27)) {
     label = 9;
     break;
    }
   }
   while(1) {
    $28 = $opCode;
    $29 = (6792 + (($28*60)|0)|0);
    $30 = HEAP32[$29>>2]|0;
    $31 = HEAP32[$opSp>>2]|0;
    $32 = (($opStack) + ($31<<2)|0);
    $33 = HEAP32[$32>>2]|0;
    $34 = (6792 + (($33*60)|0)|0);
    $35 = HEAP32[$34>>2]|0;
    $36 = ($30|0)<=($35|0);
    if (!($36)) {
     break;
    }
    $37 = HEAP32[$opSp>>2]|0;
    $38 = (($opStack) + ($37<<2)|0);
    $39 = HEAP32[$38>>2]|0;
    $40 = (6792 + (($39*60)|0)|0);
    $41 = HEAP32[$40>>2]|0;
    $42 = ($41|0)!=(127);
    if (!($42)) {
     break;
    }
    $43 = HEAP32[$opSp>>2]|0;
    $44 = (($opStack) + ($43<<2)|0);
    $45 = HEAP32[$44>>2]|0;
    $46 = ($45|0)>=(22);
    if ($46) {
     $47 = HEAP32[$argSp>>2]|0;
     $48 = (($argStack) + ($47<<2)|0);
     $49 = HEAP32[$48>>2]|0;
     $50 = (($49) + 1)|0;
     HEAP32[$48>>2] = $50;
    }
    $51 = HEAP32[$opSp>>2]|0;
    $52 = (($opStack) + ($51<<2)|0);
    $53 = HEAP32[$52>>2]|0;
    $54 = $2;
    $55 = $3;
    $56 = $4;
    $57 = HEAP32[$argSp>>2]|0;
    $58 = (($argStack) + ($57<<2)|0);
    $59 = HEAP32[$58>>2]|0;
    ;HEAP32[$v$byval_copy>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy+4>>2]=HEAP32[$v+4>>2]|0;
    _qspAppendToCompiled($53,$itemsCount,$54,$55,$56,$59,$v$byval_copy);
    $60 = HEAP32[320460>>2]|0;
    $61 = ($60|0)!=(0);
    if ($61) {
     break;
    }
    $62 = HEAP32[$opSp>>2]|0;
    $63 = (($62) + -1)|0;
    HEAP32[$opSp>>2] = $63;
    $64 = ($63|0)<(0);
    if ($64) {
     label = 17;
     break;
    }
    $65 = HEAP32[$argSp>>2]|0;
    $66 = (($65) + -1)|0;
    HEAP32[$argSp>>2] = $66;
    $67 = ($66|0)<(0);
    if ($67) {
     label = 17;
     break;
    }
   }
   if ((label|0) == 17) {
    label = 0;
    _qspSetError(118);
   }
   $68 = HEAP32[320460>>2]|0;
   $69 = ($68|0)!=(0);
   if ($69) {
    break;
   }
   $70 = $opCode;
   L25: do {
    switch ($70|0) {
    case 2:  {
     $71 = HEAP32[$opSp>>2]|0;
     $72 = ($71|0)!=(0);
     if (!($72)) {
      label = 22;
      break L5;
     }
     _qspSetError(116);
     break;
    }
    case 7:  {
     $74 = HEAP32[$opSp>>2]|0;
     $75 = (($opStack) + ($74<<2)|0);
     $76 = HEAP32[$75>>2]|0;
     $77 = ($76|0)!=(4);
     if ($77) {
      _qspSetError(116);
      break L25;
     }
     $78 = HEAP32[$opSp>>2]|0;
     $79 = (($78) + -1)|0;
     HEAP32[$opSp>>2] = $79;
     $80 = (($opStack) + ($79<<2)|0);
     $81 = HEAP32[$80>>2]|0;
     $opCode = $81;
     $82 = $opCode;
     $83 = ($82|0)>=(22);
     $84 = HEAP32[$argSp>>2]|0;
     if (!($83)) {
      $102 = (($84) + -1)|0;
      HEAP32[$argSp>>2] = $102;
      break L25;
     }
     $85 = (($argStack) + ($84<<2)|0);
     $86 = HEAP32[$85>>2]|0;
     $87 = (($86) + 1)|0;
     $88 = $opCode;
     $89 = (6792 + (($88*60)|0)|0);
     $90 = ((($89)) + 8|0);
     $91 = HEAP32[$90>>2]|0;
     $92 = ($87|0)<($91|0);
     if (!($92)) {
      $93 = HEAP32[$argSp>>2]|0;
      $94 = (($argStack) + ($93<<2)|0);
      $95 = HEAP32[$94>>2]|0;
      $96 = (($95) + 1)|0;
      $97 = $opCode;
      $98 = (6792 + (($97*60)|0)|0);
      $99 = ((($98)) + 12|0);
      $100 = HEAP32[$99>>2]|0;
      $101 = ($96|0)>($100|0);
      if (!($101)) {
       break L25;
      }
     }
     _qspSetError(120);
     break;
    }
    case 6:  {
     $103 = HEAP32[$opSp>>2]|0;
     $104 = ($103|0)!=(0);
     if ($104) {
      $105 = HEAP32[$opSp>>2]|0;
      $106 = (($105) - 1)|0;
      $107 = (($opStack) + ($106<<2)|0);
      $108 = HEAP32[$107>>2]|0;
      $109 = ($108|0)>=(22);
      if ($109) {
       $110 = HEAP32[$argSp>>2]|0;
       $111 = (($argStack) + ($110<<2)|0);
       $112 = HEAP32[$111>>2]|0;
       $113 = (($112) + 1)|0;
       HEAP32[$111>>2] = $113;
       $114 = HEAP32[$opSp>>2]|0;
       $115 = (($114) - 1)|0;
       $116 = (($opStack) + ($115<<2)|0);
       $117 = HEAP32[$116>>2]|0;
       $118 = (6792 + (($117*60)|0)|0);
       $119 = ((($118)) + 12|0);
       $120 = HEAP32[$119>>2]|0;
       $121 = ($113|0)>($120|0);
       if ($121) {
        _qspSetError(120);
        break L25;
       }
      } else {
       label = 34;
      }
     } else {
      label = 34;
     }
     if ((label|0) == 34) {
      label = 0;
      _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,6);
      $122 = HEAP32[320460>>2]|0;
      $123 = ($122|0)!=(0);
      if ($123) {
       break L25;
      }
     }
     $waitForOperator = 0;
     break;
    }
    default: {
     $124 = $opCode;
     _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,$124);
     $125 = HEAP32[320460>>2]|0;
     $126 = ($125|0)!=(0);
     if (!($126)) {
      $waitForOperator = 0;
     }
    }
    }
   } while(0);
   $127 = HEAP32[320460>>2]|0;
   $128 = ($127|0)!=(0);
   if ($128) {
    break;
   } else {
    continue;
   }
  }
  $129 = HEAP32[$1>>2]|0;
  $130 = HEAP16[$129>>1]|0;
  $131 = (_qspIsDigit($130)|0);
  $132 = ($131|0)!=(0);
  if ($132) {
   $133 = ((($v)) + 4|0);
   HEAP32[$133>>2] = 0;
   $134 = (_qspGetNumber($1)|0);
   HEAP32[$v>>2] = $134;
   $135 = HEAP32[$opSp>>2]|0;
   $136 = (($opStack) + ($135<<2)|0);
   $137 = HEAP32[$136>>2]|0;
   $138 = ($137|0)==(5);
   if ($138) {
    $139 = HEAP32[$v>>2]|0;
    $140 = (0 - ($139))|0;
    HEAP32[$v>>2] = $140;
    $141 = HEAP32[$opSp>>2]|0;
    $142 = (($141) + -1)|0;
    HEAP32[$opSp>>2] = $142;
    $143 = HEAP32[$argSp>>2]|0;
    $144 = (($143) + -1)|0;
    HEAP32[$argSp>>2] = $144;
   }
   $145 = $2;
   $146 = $3;
   $147 = $4;
   ;HEAP32[$v$byval_copy8>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy8+4>>2]=HEAP32[$v+4>>2]|0;
   _qspAppendToCompiled(3,$itemsCount,$145,$146,$147,0,$v$byval_copy8);
   $148 = HEAP32[320460>>2]|0;
   $149 = ($148|0)!=(0);
   if ($149) {
    break;
   }
   $waitForOperator = 1;
   continue;
  }
  $150 = HEAP32[$1>>2]|0;
  $151 = HEAP16[$150>>1]|0;
  $152 = (_qspIsInList(444302,$151)|0);
  $153 = ($152|0)!=(0);
  if ($153) {
   $154 = (_qspGetString($1)|0);
   $name = $154;
   $155 = ($154|0)!=(0|0);
   if (!($155)) {
    break;
   }
   $156 = ((($v)) + 4|0);
   HEAP32[$156>>2] = 1;
   $157 = $name;
   HEAP32[$v>>2] = $157;
   $158 = $2;
   $159 = $3;
   $160 = $4;
   ;HEAP32[$v$byval_copy9>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy9+4>>2]=HEAP32[$v+4>>2]|0;
   _qspAppendToCompiled(3,$itemsCount,$158,$159,$160,0,$v$byval_copy9);
   $161 = HEAP32[320460>>2]|0;
   $162 = ($161|0)!=(0);
   if ($162) {
    label = 47;
    break;
   }
   $waitForOperator = 1;
   continue;
  }
  $164 = HEAP32[$1>>2]|0;
  $165 = HEAP16[$164>>1]|0;
  $166 = $165&65535;
  $167 = HEAP16[444308>>1]|0;
  $168 = $167&65535;
  $169 = ($166|0)==($168|0);
  if ($169) {
   $170 = (_qspGetQString($1)|0);
   $name = $170;
   $171 = ($170|0)!=(0|0);
   if (!($171)) {
    break;
   }
   $172 = ((($v)) + 4|0);
   HEAP32[$172>>2] = 1;
   $173 = $name;
   HEAP32[$v>>2] = $173;
   $174 = $2;
   $175 = $3;
   $176 = $4;
   ;HEAP32[$v$byval_copy10>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy10+4>>2]=HEAP32[$v+4>>2]|0;
   _qspAppendToCompiled(3,$itemsCount,$174,$175,$176,0,$v$byval_copy10);
   $177 = HEAP32[320460>>2]|0;
   $178 = ($177|0)!=(0);
   if ($178) {
    label = 52;
    break;
   }
   $waitForOperator = 1;
   continue;
  }
  $180 = HEAP32[$1>>2]|0;
  $181 = HEAP16[$180>>1]|0;
  $182 = $181&65535;
  $183 = HEAP16[444364>>1]|0;
  $184 = $183&65535;
  $185 = ($182|0)==($184|0);
  $186 = HEAP32[$1>>2]|0;
  if ($185) {
   $187 = ((($186)) + 2|0);
   HEAP32[$1>>2] = $187;
   continue;
  }
  $188 = HEAP16[$186>>1]|0;
  $189 = $188&65535;
  $190 = HEAP16[444376>>1]|0;
  $191 = $190&65535;
  $192 = ($189|0)==($191|0);
  if ($192) {
   _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,5);
   $193 = HEAP32[320460>>2]|0;
   $194 = ($193|0)!=(0);
   if ($194) {
    break;
   }
   $195 = HEAP32[$1>>2]|0;
   $196 = ((($195)) + 2|0);
   HEAP32[$1>>2] = $196;
   continue;
  }
  $197 = HEAP32[$1>>2]|0;
  $198 = HEAP16[$197>>1]|0;
  $199 = $198&65535;
  $200 = HEAP16[446274>>1]|0;
  $201 = $200&65535;
  $202 = ($199|0)==($201|0);
  if ($202) {
   _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,4);
   $203 = HEAP32[320460>>2]|0;
   $204 = ($203|0)!=(0);
   if ($204) {
    break;
   }
   $205 = HEAP32[$1>>2]|0;
   $206 = ((($205)) + 2|0);
   HEAP32[$1>>2] = $206;
   continue;
  }
  $207 = HEAP32[$1>>2]|0;
  $208 = HEAP16[$207>>1]|0;
  $209 = $208&65535;
  $210 = HEAP16[446278>>1]|0;
  $211 = $210&65535;
  $212 = ($209|0)==($211|0);
  if ($212) {
   $213 = HEAP32[$opSp>>2]|0;
   $214 = (($opStack) + ($213<<2)|0);
   $215 = HEAP32[$214>>2]|0;
   $opCode = $215;
   $216 = $opCode;
   $217 = ($216|0)!=(4);
   if ($217) {
    label = 64;
    break;
   }
   $220 = HEAP32[$opSp>>2]|0;
   $221 = (($220) + -1)|0;
   HEAP32[$opSp>>2] = $221;
   $222 = (($opStack) + ($221<<2)|0);
   $223 = HEAP32[$222>>2]|0;
   $opCode = $223;
   $224 = $opCode;
   $225 = ($224|0)<(22);
   if ($225) {
    label = 68;
    break;
   }
   $226 = $opCode;
   $227 = (6792 + (($226*60)|0)|0);
   $228 = ((($227)) + 8|0);
   $229 = HEAP32[$228>>2]|0;
   $230 = ($229|0)!=(0);
   if ($230) {
    label = 70;
    break;
   }
   $231 = HEAP32[$1>>2]|0;
   $232 = ((($231)) + 2|0);
   HEAP32[$1>>2] = $232;
   $233 = $opCode;
   $234 = $2;
   $235 = $3;
   $236 = $4;
   ;HEAP32[$v$byval_copy11>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy11+4>>2]=HEAP32[$v+4>>2]|0;
   _qspAppendToCompiled($233,$itemsCount,$234,$235,$236,0,$v$byval_copy11);
   $237 = HEAP32[320460>>2]|0;
   $238 = ($237|0)!=(0);
   if ($238) {
    break;
   }
   $239 = HEAP32[$opSp>>2]|0;
   $240 = (($239) + -1)|0;
   HEAP32[$opSp>>2] = $240;
   $241 = HEAP32[$argSp>>2]|0;
   $242 = (($241) + -1)|0;
   HEAP32[$argSp>>2] = $242;
   $waitForOperator = 1;
   continue;
  }
  $243 = HEAP32[$1>>2]|0;
  $244 = HEAP16[$243>>1]|0;
  $245 = (_qspIsInListEOL(446312,$244)|0);
  $246 = ($245|0)!=(0);
  if ($246) {
   label = 91;
   break;
  }
  $247 = (_qspGetName($1)|0);
  $name = $247;
  $248 = ($247|0)!=(0|0);
  if (!($248)) {
   break;
  }
  $249 = $name;
  $250 = (_qspFunctionOpCode($249)|0);
  $opCode = $250;
  $251 = $opCode;
  $252 = ($251|0)>=(22);
  $253 = $name;
  if (!($252)) {
   _qspGetVar($5,$253);
   ;HEAP32[$v>>2]=HEAP32[$5>>2]|0;HEAP32[$v+4>>2]=HEAP32[$5+4>>2]|0;
   $288 = $name;
   _free($288);
   $289 = HEAP32[320504>>2]|0;
   $290 = $oldRefreshCount;
   $291 = ($289|0)!=($290|0);
   $292 = HEAP32[320460>>2]|0;
   $293 = ($292|0)!=(0);
   $or$cond7 = $291 | $293;
   if ($or$cond7) {
    break;
   }
   $294 = $2;
   $295 = $3;
   $296 = $4;
   ;HEAP32[$v$byval_copy13>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy13+4>>2]=HEAP32[$v+4>>2]|0;
   _qspAppendToCompiled(3,$itemsCount,$294,$295,$296,0,$v$byval_copy13);
   $297 = HEAP32[320460>>2]|0;
   $298 = ($297|0)!=(0);
   if ($298) {
    label = 88;
    break;
   }
   $waitForOperator = 1;
   continue;
  }
  _free($253);
  $254 = HEAP32[$1>>2]|0;
  $255 = HEAP16[$254>>1]|0;
  $256 = $255&65535;
  $257 = HEAP16[446274>>1]|0;
  $258 = $257&65535;
  $259 = ($256|0)==($258|0);
  if ($259) {
   $260 = $opCode;
   _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,$260);
   $261 = HEAP32[320460>>2]|0;
   $262 = ($261|0)!=(0);
   if ($262) {
    break;
   }
   _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,4);
   $263 = HEAP32[320460>>2]|0;
   $264 = ($263|0)!=(0);
   if ($264) {
    break;
   }
   $265 = HEAP32[$1>>2]|0;
   $266 = ((($265)) + 2|0);
   HEAP32[$1>>2] = $266;
   $267 = HEAP32[$argSp>>2]|0;
   $268 = (($267) + -1)|0;
   HEAP32[$argSp>>2] = $268;
   continue;
  }
  $269 = $opCode;
  $270 = (6792 + (($269*60)|0)|0);
  $271 = ((($270)) + 8|0);
  $272 = HEAP32[$271>>2]|0;
  $273 = ($272|0)<(2);
  if (!($273)) {
   label = 85;
   break;
  }
  $274 = $opCode;
  $275 = (6792 + (($274*60)|0)|0);
  $276 = ((($275)) + 8|0);
  $277 = HEAP32[$276>>2]|0;
  $278 = ($277|0)!=(0);
  if ($278) {
   $279 = $opCode;
   _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,$279);
   $280 = HEAP32[320460>>2]|0;
   $281 = ($280|0)!=(0);
   if ($281) {
    break;
   } else {
    continue;
   }
  }
  $282 = $opCode;
  $283 = $2;
  $284 = $3;
  $285 = $4;
  ;HEAP32[$v$byval_copy12>>2]=HEAP32[$v>>2]|0;HEAP32[$v$byval_copy12+4>>2]=HEAP32[$v+4>>2]|0;
  _qspAppendToCompiled($282,$itemsCount,$283,$284,$285,0,$v$byval_copy12);
  $286 = HEAP32[320460>>2]|0;
  $287 = ($286|0)!=(0);
  if ($287) {
   break;
  }
  $waitForOperator = 1;
 }
 switch (label|0) {
  case 6: {
   _qspSetError(119);
   break;
  }
  case 9: {
   _qspSetError(118);
   break;
  }
  case 22: {
   $73 = HEAP32[$itemsCount>>2]|0;
   $0 = $73;
   $325 = $0;
   STACKTOP = sp;return ($325|0);
   break;
  }
  case 47: {
   $163 = HEAP32[$v>>2]|0;
   _free($163);
   break;
  }
  case 52: {
   $179 = HEAP32[$v>>2]|0;
   _free($179);
   break;
  }
  case 64: {
   $218 = $opCode;
   $219 = ($218|0)>=(22);
   if ($219) {
    _qspSetError(120);
    break;
   } else {
    _qspSetError(118);
    break;
   }
   break;
  }
  case 68: {
   _qspSetError(118);
   break;
  }
  case 70: {
   _qspSetError(120);
   break;
  }
  case 85: {
   _qspSetError(117);
   break;
  }
  case 88: {
   $299 = ((($v)) + 4|0);
   $300 = HEAP32[$299>>2]|0;
   $301 = ($300|0)!=(0);
   if ($301) {
    $302 = HEAP32[$v>>2]|0;
    _free($302);
   }
   break;
  }
  case 91: {
   $303 = HEAP32[$opSp>>2]|0;
   $304 = (($opStack) + ($303<<2)|0);
   $305 = HEAP32[$304>>2]|0;
   $306 = ($305|0)>=(22);
   if ($306) {
    _qspSetError(120);
    break;
   } else {
    _qspSetError(118);
    break;
   }
   break;
  }
 }
 while(1) {
  $307 = HEAP32[$itemsCount>>2]|0;
  $308 = (($307) + -1)|0;
  HEAP32[$itemsCount>>2] = $308;
  $309 = ($308|0)>=(0);
  if (!($309)) {
   break;
  }
  $310 = HEAP32[$itemsCount>>2]|0;
  $311 = $3;
  $312 = (($311) + ($310<<2)|0);
  $313 = HEAP32[$312>>2]|0;
  $314 = ($313|0)==(3);
  if (!($314)) {
   continue;
  }
  $315 = HEAP32[$itemsCount>>2]|0;
  $316 = $2;
  $317 = (($316) + ($315<<3)|0);
  $318 = ((($317)) + 4|0);
  $319 = HEAP32[$318>>2]|0;
  $320 = ($319|0)!=(0);
  if (!($320)) {
   continue;
  }
  $321 = HEAP32[$itemsCount>>2]|0;
  $322 = $2;
  $323 = (($322) + ($321<<3)|0);
  $324 = HEAP32[$323>>2]|0;
  _free($324);
 }
 $0 = 0;
 $325 = $0;
 STACKTOP = sp;return ($325|0);
}
function _qspValue($agg$result,$itemsCount,$compValues,$compOpCodes,$compArgsCounts) {
 $agg$result = $agg$result|0;
 $itemsCount = $itemsCount|0;
 $compValues = $compValues|0;
 $compOpCodes = $compOpCodes|0;
 $compArgsCounts = $compArgsCounts|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0;
 var $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0;
 var $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0;
 var $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0;
 var $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $args = 0, $argsCount = 0, $i = 0, $index = 0, $j = 0, $len = 0, $oldRefreshCount = 0, $opCode = 0, $or$cond = 0, $sp = 0, $stack = 0, $tos = 0;
 var $type = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 384|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $stack = sp + 120|0;
 $args = sp + 40|0;
 $tos = sp + 32|0;
 $0 = $itemsCount;
 $1 = $compValues;
 $2 = $compOpCodes;
 $3 = $compArgsCounts;
 $sp = -1;
 $index = 0;
 $4 = ((($tos)) + 4|0);
 HEAP32[$4>>2] = 0;
 HEAP32[$tos>>2] = 0;
 $5 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $5;
 L1: while(1) {
  $6 = $index;
  $7 = $0;
  $8 = ($6|0)==($7|0);
  if ($8) {
   label = 3;
   break;
  }
  $9 = $index;
  $10 = $2;
  $11 = (($10) + ($9<<2)|0);
  $12 = HEAP32[$11>>2]|0;
  $opCode = $12;
  $13 = $index;
  $14 = $3;
  $15 = (($14) + ($13<<2)|0);
  $16 = HEAP32[$15>>2]|0;
  $argsCount = $16;
  $17 = $argsCount;
  $18 = ($17|0)!=(0);
  L4: do {
   if ($18) {
    $19 = $argsCount;
    $20 = (($19) - 2)|0;
    $i = $20;
    $21 = $sp;
    $j = $21;
    $22 = $i;
    $23 = (($22) + 1)|0;
    $24 = (($args) + ($23<<3)|0);
    ;HEAP32[$24>>2]=HEAP32[$tos>>2]|0;HEAP32[$24+4>>2]=HEAP32[$tos+4>>2]|0;
    while(1) {
     $25 = $i;
     $26 = ($25|0)>=(0);
     if (!($26)) {
      break;
     }
     $27 = $i;
     $28 = (($args) + ($27<<3)|0);
     $29 = $j;
     $30 = (($stack) + ($29<<3)|0);
     ;HEAP32[$28>>2]=HEAP32[$30>>2]|0;HEAP32[$28+4>>2]=HEAP32[$30+4>>2]|0;
     $31 = $i;
     $32 = (($31) + -1)|0;
     $i = $32;
     $33 = $j;
     $34 = (($33) + -1)|0;
     $j = $34;
    }
    $i = 0;
    while(1) {
     $35 = $i;
     $36 = $argsCount;
     $37 = ($35|0)<($36|0);
     if (!($37)) {
      break L4;
     }
     $38 = $i;
     $39 = $opCode;
     $40 = (6792 + (($39*60)|0)|0);
     $41 = ((($40)) + 16|0);
     $42 = (($41) + ($38<<2)|0);
     $43 = HEAP32[$42>>2]|0;
     $type = $43;
     $44 = $type;
     $45 = ($44|0)!=(0);
     if ($45) {
      $46 = $i;
      $47 = (($args) + ($46<<3)|0);
      $48 = $type;
      $49 = ($48|0)==(1);
      $50 = $49&1;
      $51 = (_qspConvertVariantTo($47,$50)|0);
      $52 = ($51|0)!=(0);
      if ($52) {
       break;
      }
     }
     $53 = $i;
     $54 = (($53) + 1)|0;
     $i = $54;
    }
    _qspSetError(101);
   } else {
    $55 = $sp;
    $56 = ($55|0)==(29);
    if ($56) {
     label = 15;
     break L1;
    }
    $61 = $sp;
    $62 = (($61) + 1)|0;
    $sp = $62;
    $63 = (($stack) + ($62<<3)|0);
    ;HEAP32[$63>>2]=HEAP32[$tos>>2]|0;HEAP32[$63+4>>2]=HEAP32[$tos+4>>2]|0;
   }
  } while(0);
  $64 = HEAP32[320460>>2]|0;
  $65 = ($64|0)!=(0);
  L20: do {
   if (!($65)) {
    $66 = $opCode;
    $67 = (6792 + (($66*60)|0)|0);
    $68 = ((($67)) + 4|0);
    $69 = HEAP32[$68>>2]|0;
    $type = $69;
    $70 = $type;
    $71 = ($70|0)!=(0);
    if ($71) {
     $72 = $type;
     $73 = ($72|0)==(1);
     $74 = $73&1;
     $75 = ((($tos)) + 4|0);
     HEAP32[$75>>2] = $74;
    }
    $76 = $opCode;
    do {
     switch ($76|0) {
     case 3:  {
      $77 = $index;
      $78 = $1;
      $79 = (($78) + ($77<<3)|0);
      ;HEAP32[$tos>>2]=HEAP32[$79>>2]|0;HEAP32[$tos+4>>2]=HEAP32[$79+4>>2]|0;
      break L20;
      break;
     }
     case 8:  {
      $80 = HEAP32[$args>>2]|0;
      $81 = ((($args)) + 8|0);
      $82 = HEAP32[$81>>2]|0;
      $83 = Math_imul($80, $82)|0;
      HEAP32[$tos>>2] = $83;
      break L20;
      break;
     }
     case 9:  {
      $84 = ((($args)) + 8|0);
      $85 = HEAP32[$84>>2]|0;
      $86 = ($85|0)!=(0);
      if ($86) {
       $87 = HEAP32[$args>>2]|0;
       $88 = ((($args)) + 8|0);
       $89 = HEAP32[$88>>2]|0;
       $90 = (($87|0) / ($89|0))&-1;
       HEAP32[$tos>>2] = $90;
       break L20;
      } else {
       _qspSetError(100);
       break L20;
      }
      break;
     }
     case 10:  {
      $91 = ((($args)) + 4|0);
      $92 = HEAP32[$91>>2]|0;
      $93 = ($92|0)!=(0);
      if ($93) {
       $94 = ((($args)) + 8|0);
       $95 = ((($94)) + 4|0);
       $96 = HEAP32[$95>>2]|0;
       $97 = ($96|0)!=(0);
       if ($97) {
        $98 = ((($tos)) + 4|0);
        HEAP32[$98>>2] = 1;
        $99 = HEAP32[$args>>2]|0;
        $100 = (_qspAddText($tos,$99,0,-1,1)|0);
        $len = $100;
        $101 = HEAP32[$tos>>2]|0;
        $102 = ((($args)) + 8|0);
        $103 = HEAP32[$102>>2]|0;
        $104 = $len;
        $105 = (_qspGetAddText($101,$103,$104,-1)|0);
        HEAP32[$tos>>2] = $105;
        break L20;
       }
      }
      $106 = (_qspIsCanConvertToNum($args)|0);
      $107 = ($106|0)!=(0);
      if ($107) {
       $108 = ((($args)) + 8|0);
       $109 = (_qspIsCanConvertToNum($108)|0);
       $110 = ($109|0)!=(0);
       if ($110) {
        (_qspConvertVariantTo($args,0)|0);
        $111 = ((($args)) + 8|0);
        (_qspConvertVariantTo($111,0)|0);
        $112 = ((($tos)) + 4|0);
        HEAP32[$112>>2] = 0;
        $113 = HEAP32[$args>>2]|0;
        $114 = ((($args)) + 8|0);
        $115 = HEAP32[$114>>2]|0;
        $116 = (($113) + ($115))|0;
        HEAP32[$tos>>2] = $116;
        break L20;
       }
      }
      (_qspConvertVariantTo($args,1)|0);
      $117 = ((($args)) + 8|0);
      (_qspConvertVariantTo($117,1)|0);
      $118 = ((($tos)) + 4|0);
      HEAP32[$118>>2] = 1;
      $119 = HEAP32[$args>>2]|0;
      $120 = (_qspAddText($tos,$119,0,-1,1)|0);
      $len = $120;
      $121 = HEAP32[$tos>>2]|0;
      $122 = ((($args)) + 8|0);
      $123 = HEAP32[$122>>2]|0;
      $124 = $len;
      $125 = (_qspGetAddText($121,$123,$124,-1)|0);
      HEAP32[$tos>>2] = $125;
      break L20;
      break;
     }
     case 11:  {
      $126 = HEAP32[$args>>2]|0;
      $127 = ((($args)) + 8|0);
      $128 = HEAP32[$127>>2]|0;
      $129 = (($126) - ($128))|0;
      HEAP32[$tos>>2] = $129;
      break L20;
      break;
     }
     case 12:  {
      $130 = ((($args)) + 8|0);
      $131 = HEAP32[$130>>2]|0;
      $132 = ($131|0)!=(0);
      if ($132) {
       $133 = HEAP32[$args>>2]|0;
       $134 = ((($args)) + 8|0);
       $135 = HEAP32[$134>>2]|0;
       $136 = (($133|0) % ($135|0))&-1;
       HEAP32[$tos>>2] = $136;
       break L20;
      } else {
       _qspSetError(100);
       break L20;
      }
      break;
     }
     case 21:  {
      $137 = HEAP32[$args>>2]|0;
      $138 = (_qspAddText($tos,$137,0,-1,1)|0);
      $len = $138;
      $139 = HEAP32[$tos>>2]|0;
      $140 = ((($args)) + 8|0);
      $141 = HEAP32[$140>>2]|0;
      $142 = $len;
      $143 = (_qspGetAddText($139,$141,$142,-1)|0);
      HEAP32[$tos>>2] = $143;
      break L20;
      break;
     }
     case 6:  {
      $144 = HEAP32[$args>>2]|0;
      $145 = (_qspAddText($tos,$144,0,-1,1)|0);
      $len = $145;
      $146 = $len;
      $147 = (_qspAddText($tos,444248,$146,1,0)|0);
      $len = $147;
      $148 = HEAP32[$tos>>2]|0;
      $149 = ((($args)) + 8|0);
      $150 = HEAP32[$149>>2]|0;
      $151 = $len;
      $152 = (_qspGetAddText($148,$150,$151,-1)|0);
      HEAP32[$tos>>2] = $152;
      break L20;
      break;
     }
     case 16:  {
      $153 = ((($args)) + 8|0);
      $154 = (_qspAutoConvertCompare($args,$153)|0);
      $155 = ($154|0)!=(0);
      $156 = $155 ^ 1;
      $157 = $156&1;
      $158 = (0 - ($157))|0;
      HEAP32[$tos>>2] = $158;
      break L20;
      break;
     }
     case 17:  {
      $159 = ((($args)) + 8|0);
      $160 = (_qspAutoConvertCompare($args,$159)|0);
      $161 = ($160|0)<(0);
      $162 = $161&1;
      $163 = (0 - ($162))|0;
      HEAP32[$tos>>2] = $163;
      break L20;
      break;
     }
     case 18:  {
      $164 = ((($args)) + 8|0);
      $165 = (_qspAutoConvertCompare($args,$164)|0);
      $166 = ($165|0)>(0);
      $167 = $166&1;
      $168 = (0 - ($167))|0;
      HEAP32[$tos>>2] = $168;
      break L20;
      break;
     }
     case 14:  {
      $169 = ((($args)) + 8|0);
      $170 = (_qspAutoConvertCompare($args,$169)|0);
      $171 = ($170|0)<=(0);
      $172 = $171&1;
      $173 = (0 - ($172))|0;
      HEAP32[$tos>>2] = $173;
      break L20;
      break;
     }
     case 15:  {
      $174 = ((($args)) + 8|0);
      $175 = (_qspAutoConvertCompare($args,$174)|0);
      $176 = ($175|0)>=(0);
      $177 = $176&1;
      $178 = (0 - ($177))|0;
      HEAP32[$tos>>2] = $178;
      break L20;
      break;
     }
     case 13:  {
      $179 = ((($args)) + 8|0);
      $180 = (_qspAutoConvertCompare($args,$179)|0);
      $181 = ($180|0)!=(0);
      $182 = $181&1;
      $183 = (0 - ($182))|0;
      HEAP32[$tos>>2] = $183;
      break L20;
      break;
     }
     case 5:  {
      $184 = HEAP32[$args>>2]|0;
      $185 = (0 - ($184))|0;
      HEAP32[$tos>>2] = $185;
      break L20;
      break;
     }
     case 23:  {
      $186 = HEAP32[$args>>2]|0;
      $187 = (_qspLocIndex($186)|0);
      $188 = ($187|0)>=(0);
      $189 = $188&1;
      $190 = (0 - ($189))|0;
      HEAP32[$tos>>2] = $190;
      break L20;
      break;
     }
     case 24:  {
      $191 = HEAP32[$args>>2]|0;
      $192 = (_qspObjIndex($191)|0);
      $193 = ($192|0)>=(0);
      $194 = $193&1;
      $195 = (0 - ($194))|0;
      HEAP32[$tos>>2] = $195;
      break L20;
      break;
     }
     case 22:  {
      $196 = HEAP32[$args>>2]|0;
      $197 = $196 ^ -1;
      HEAP32[$tos>>2] = $197;
      break L20;
      break;
     }
     case 19:  {
      $198 = HEAP32[$args>>2]|0;
      $199 = ((($args)) + 8|0);
      $200 = HEAP32[$199>>2]|0;
      $201 = $198 & $200;
      HEAP32[$tos>>2] = $201;
      break L20;
      break;
     }
     case 20:  {
      $202 = HEAP32[$args>>2]|0;
      $203 = ((($args)) + 8|0);
      $204 = HEAP32[$203>>2]|0;
      $205 = $202 | $204;
      HEAP32[$tos>>2] = $205;
      break L20;
      break;
     }
     case 28:  {
      $206 = HEAP32[$args>>2]|0;
      $207 = ($206|0)!=(0);
      $208 = ((($args)) + 8|0);
      $209 = ((($args)) + 16|0);
      $210 = $207 ? $208 : $209;
      _qspCopyVariant($tos,$210);
      break L20;
      break;
     }
     case 30:  {
      $211 = HEAP32[$args>>2]|0;
      $212 = (_qspStrLen($211)|0);
      HEAP32[$tos>>2] = $212;
      break L20;
      break;
     }
     case 31:  {
      $213 = (_qspIsCanConvertToNum($args)|0);
      $214 = (0 - ($213))|0;
      HEAP32[$tos>>2] = $214;
      break L20;
      break;
     }
     case 32:  {
      $215 = HEAP32[$args>>2]|0;
      $216 = (_qspGetNewText($215,-1)|0);
      HEAP32[$tos>>2] = $216;
      _qspLowerStr($216);
      break L20;
      break;
     }
     case 33:  {
      $217 = HEAP32[$args>>2]|0;
      $218 = (_qspGetNewText($217,-1)|0);
      HEAP32[$tos>>2] = $218;
      _qspUpperStr($218);
      break L20;
      break;
     }
     case 35:  {
      $219 = HEAP32[$args>>2]|0;
      $220 = (_qspGetNewText($219,-1)|0);
      HEAP32[$tos>>2] = $220;
      break L20;
      break;
     }
     case 36:  {
      $221 = (_qspConvertVariantTo($args,0)|0);
      $222 = ($221|0)!=(0);
      if ($222) {
       HEAP32[$tos>>2] = 0;
       break L20;
      } else {
       $223 = HEAP32[$args>>2]|0;
       HEAP32[$tos>>2] = $223;
       break L20;
      }
      break;
     }
     case 37:  {
      $224 = HEAP32[$args>>2]|0;
      $225 = (_qspArraySize($224)|0);
      HEAP32[$tos>>2] = $225;
      break L20;
      break;
     }
     case 40:  {
      $226 = HEAP32[$args>>2]|0;
      $227 = (_qspDelSpc($226)|0);
      HEAP32[$tos>>2] = $227;
      break L20;
      break;
     }
     case 34:  {
      $228 = HEAP32[$args>>2]|0;
      $229 = (_qspCallInputBox($228)|0);
      HEAP32[$tos>>2] = $229;
      break L20;
      break;
     }
     case 52:  {
      $230 = (_qspRand()|0);
      $231 = (($230|0) % 1000)&-1;
      $232 = (($231) + 1)|0;
      HEAP32[$tos>>2] = $232;
      break L20;
      break;
     }
     case 53:  {
      $233 = HEAP32[320512>>2]|0;
      HEAP32[$tos>>2] = $233;
      break L20;
      break;
     }
     case 54:  {
      $234 = (_qspGetTime()|0);
      HEAP32[$tos>>2] = $234;
      break L20;
      break;
     }
     case 55:  {
      $235 = (_qspGetNewText(447356,5)|0);
      HEAP32[$tos>>2] = $235;
      break L20;
      break;
     }
     case 56:  {
      $236 = HEAP32[1644>>2]|0;
      $237 = ($236|0)!=(0|0);
      if ($237) {
       $238 = HEAP32[1644>>2]|0;
       $239 = HEAP32[1648>>2]|0;
       $240 = (_qspGetNewText($238,$239)|0);
       $242 = $240;
      } else {
       $241 = (_qspGetNewText(447354,0)|0);
       $242 = $241;
      }
      HEAP32[$tos>>2] = $242;
      break L20;
      break;
     }
     case 57:  {
      $243 = HEAP32[320500>>2]|0;
      $244 = ($243|0)>=(0);
      if ($244) {
       $245 = HEAP32[320500>>2]|0;
       $246 = HEAP32[320488>>2]|0;
       $247 = (($246) + (($245*816)|0)|0);
       $248 = HEAP32[$247>>2]|0;
       $249 = (_qspGetNewText($248,-1)|0);
       $251 = $249;
      } else {
       $250 = (_qspGetNewText(447354,0)|0);
       $251 = $250;
      }
      HEAP32[$tos>>2] = $251;
      break L20;
      break;
     }
     case 58:  {
      $252 = HEAP32[320516>>2]|0;
      $253 = ($252|0)>=(0);
      if ($253) {
       $254 = HEAP32[320516>>2]|0;
       $255 = (320528 + ($254<<3)|0);
       $256 = ((($255)) + 4|0);
       $257 = HEAP32[$256>>2]|0;
       $258 = (_qspGetNewText($257,-1)|0);
       $260 = $258;
      } else {
       $259 = (_qspGetNewText(447354,0)|0);
       $260 = $259;
      }
      HEAP32[$tos>>2] = $260;
      break L20;
      break;
     }
     case 59:  {
      $261 = HEAP32[12>>2]|0;
      $262 = ($261|0)>=(0);
      if ($262) {
       $263 = HEAP32[12>>2]|0;
       $264 = (24 + ($263<<5)|0);
       $265 = ((($264)) + 4|0);
       $266 = HEAP32[$265>>2]|0;
       $267 = (_qspGetNewText($266,-1)|0);
       $269 = $267;
      } else {
       $268 = (_qspGetNewText(447354,0)|0);
       $269 = $268;
      }
      HEAP32[$tos>>2] = $269;
      break L20;
      break;
     }
     case 60:  {
      $270 = HEAP32[1628>>2]|0;
      $271 = ($270|0)!=(0|0);
      if ($271) {
       $272 = HEAP32[1628>>2]|0;
       $273 = HEAP32[1632>>2]|0;
       $274 = (_qspGetNewText($272,$273)|0);
       $276 = $274;
      } else {
       $275 = (_qspGetNewText(447354,0)|0);
       $276 = $275;
      }
      HEAP32[$tos>>2] = $276;
      break L20;
      break;
     }
     case 61:  {
      $277 = HEAP32[1636>>2]|0;
      $278 = ($277|0)!=(0|0);
      if ($278) {
       $279 = HEAP32[1636>>2]|0;
       $280 = HEAP32[1640>>2]|0;
       $281 = (_qspGetNewText($279,$280)|0);
       $283 = $281;
      } else {
       $282 = (_qspGetNewText(447354,0)|0);
       $283 = $282;
      }
      HEAP32[$tos>>2] = $283;
      break L20;
      break;
     }
     case 62:  {
      $284 = (_qspGetAllActionsAsCode()|0);
      HEAP32[$tos>>2] = $284;
      break L20;
      break;
     }
     case 63:  {
      $285 = HEAP32[$args>>2]|0;
      $286 = (_qspCallPlayerInfo($285)|0);
      HEAP32[$tos>>2] = $286;
      break L20;
      break;
     }
     default: {
      $287 = $opCode;
      $288 = (6792 + (($287*60)|0)|0);
      $289 = ((($288)) + 56|0);
      $290 = HEAP32[$289>>2]|0;
      $291 = $argsCount;
      FUNCTION_TABLE_viii[$290 & 127]($args,$291,$tos);
      break L20;
     }
     }
    } while(0);
   }
  } while(0);
  $292 = $argsCount;
  $293 = ($292|0)!=(0);
  if ($293) {
   $294 = $argsCount;
   _qspFreeVariants($args,$294);
   $295 = $argsCount;
   $296 = (($295) - 1)|0;
   $297 = $sp;
   $298 = (($297) - ($296))|0;
   $sp = $298;
  }
  $299 = HEAP32[320504>>2]|0;
  $300 = $oldRefreshCount;
  $301 = ($299|0)!=($300|0);
  $302 = HEAP32[320460>>2]|0;
  $303 = ($302|0)!=(0);
  $or$cond = $301 | $303;
  if ($or$cond) {
   break;
  }
  $304 = $index;
  $305 = (($304) + 1)|0;
  $index = $305;
 }
 if ((label|0) == 3) {
  ;HEAP32[$agg$result>>2]=HEAP32[$tos>>2]|0;HEAP32[$agg$result+4>>2]=HEAP32[$tos+4>>2]|0;
  STACKTOP = sp;return;
 }
 else if ((label|0) == 15) {
  _qspSetError(102);
  $57 = ((($tos)) + 4|0);
  $58 = HEAP32[$57>>2]|0;
  $59 = ($58|0)!=(0);
  if ($59) {
   $60 = HEAP32[$tos>>2]|0;
   _free($60);
  }
 }
 $306 = $sp;
 $307 = (($306) + 1)|0;
 _qspFreeVariants($stack,$307);
 while(1) {
  $308 = $index;
  $309 = $0;
  $310 = ($308|0)<($309|0);
  if (!($310)) {
   break;
  }
  $311 = $index;
  $312 = $2;
  $313 = (($312) + ($311<<2)|0);
  $314 = HEAP32[$313>>2]|0;
  $315 = ($314|0)==(3);
  if ($315) {
   $316 = $index;
   $317 = $1;
   $318 = (($317) + ($316<<3)|0);
   $319 = ((($318)) + 4|0);
   $320 = HEAP32[$319>>2]|0;
   $321 = ($320|0)!=(0);
   if ($321) {
    $322 = $index;
    $323 = $1;
    $324 = (($323) + ($322<<3)|0);
    $325 = HEAP32[$324>>2]|0;
    _free($325);
   }
  }
  $326 = $index;
  $327 = (($326) + 1)|0;
  $index = $327;
 }
 _qspGetEmptyVariant($agg$result,0);
 STACKTOP = sp;return;
}
function _qspCompileExprPushOpCode($opStack,$opSp,$argStack,$argSp,$opCode) {
 $opStack = $opStack|0;
 $opSp = $opSp|0;
 $argStack = $argStack|0;
 $argSp = $argSp|0;
 $opCode = $opCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $opStack;
 $1 = $opSp;
 $2 = $argStack;
 $3 = $argSp;
 $4 = $opCode;
 $5 = $1;
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)==(29);
 if (!($7)) {
  $8 = $3;
  $9 = HEAP32[$8>>2]|0;
  $10 = ($9|0)==(29);
  if (!($10)) {
   $11 = $4;
   $12 = $1;
   $13 = HEAP32[$12>>2]|0;
   $14 = (($13) + 1)|0;
   HEAP32[$12>>2] = $14;
   $15 = $0;
   $16 = (($15) + ($14<<2)|0);
   HEAP32[$16>>2] = $11;
   $17 = $4;
   $18 = ($17|0)<(22);
   if ($18) {
    $19 = $4;
    $20 = (6792 + (($19*60)|0)|0);
    $21 = ((($20)) + 8|0);
    $22 = HEAP32[$21>>2]|0;
    $28 = $22;
   } else {
    $28 = 0;
   }
   $23 = $3;
   $24 = HEAP32[$23>>2]|0;
   $25 = (($24) + 1)|0;
   HEAP32[$23>>2] = $25;
   $26 = $2;
   $27 = (($26) + ($25<<2)|0);
   HEAP32[$27>>2] = $28;
   STACKTOP = sp;return;
  }
 }
 _qspSetError(102);
 STACKTOP = sp;return;
}
function _qspOperatorOpCode($expr) {
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $name = 0, $uStr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $expr;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $4 = HEAP16[$3>>1]|0;
 $5 = ($4<<16>>16)!=(0);
 if (!($5)) {
  $0 = 2;
  $32 = $0;
  STACKTOP = sp;return ($32|0);
 }
 $6 = $1;
 $7 = HEAP32[$6>>2]|0;
 $8 = HEAP32[4380>>2]|0;
 $9 = (_qspGetNewText($7,$8)|0);
 $uStr = $9;
 _qspUpperStr($9);
 $i = 0;
 while(1) {
  $10 = $i;
  $11 = ($10|0)<(2);
  $12 = $uStr;
  if (!($11)) {
   label = 8;
   break;
  }
  $13 = $i;
  $14 = (4392 + (($13*1200)|0)|0);
  $15 = $i;
  $16 = (4384 + ($15<<2)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_bsearch($12,$14,$17,12,68)|0);
  $name = $18;
  $19 = $name;
  $20 = ($19|0)!=(0|0);
  if ($20) {
   label = 6;
   break;
  }
  $30 = $i;
  $31 = (($30) + 1)|0;
  $i = $31;
 }
 if ((label|0) == 6) {
  $21 = $name;
  $22 = ((($21)) + 8|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = $1;
  $25 = HEAP32[$24>>2]|0;
  $26 = (($25) + ($23<<1)|0);
  HEAP32[$24>>2] = $26;
  $27 = $uStr;
  _free($27);
  $28 = $name;
  $29 = HEAP32[$28>>2]|0;
  $0 = $29;
  $32 = $0;
  STACKTOP = sp;return ($32|0);
 }
 else if ((label|0) == 8) {
  _free($12);
  $0 = 0;
  $32 = $0;
  STACKTOP = sp;return ($32|0);
 }
 return (0)|0;
}
function _qspAppendToCompiled($opCode,$itemsCount,$compValues,$compOpCodes,$compArgsCounts,$argsCount,$v) {
 $opCode = $opCode|0;
 $itemsCount = $itemsCount|0;
 $compValues = $compValues|0;
 $compOpCodes = $compOpCodes|0;
 $compArgsCounts = $compArgsCounts|0;
 $argsCount = $argsCount|0;
 $v = $v|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $opCode;
 $1 = $itemsCount;
 $2 = $compValues;
 $3 = $compOpCodes;
 $4 = $compArgsCounts;
 $5 = $argsCount;
 $6 = $1;
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(100);
 if ($8) {
  _qspSetError(103);
  STACKTOP = sp;return;
 }
 $9 = $0;
 $10 = $1;
 $11 = HEAP32[$10>>2]|0;
 $12 = $3;
 $13 = (($12) + ($11<<2)|0);
 HEAP32[$13>>2] = $9;
 $14 = $5;
 $15 = $1;
 $16 = HEAP32[$15>>2]|0;
 $17 = $4;
 $18 = (($17) + ($16<<2)|0);
 HEAP32[$18>>2] = $14;
 $19 = $0;
 $20 = ($19|0)==(3);
 if ($20) {
  $21 = $1;
  $22 = HEAP32[$21>>2]|0;
  $23 = $2;
  $24 = (($23) + ($22<<3)|0);
  ;HEAP32[$24>>2]=HEAP32[$v>>2]|0;HEAP32[$24+4>>2]=HEAP32[$v+4>>2]|0;
 }
 $25 = $1;
 $26 = HEAP32[$25>>2]|0;
 $27 = (($26) + 1)|0;
 HEAP32[$25>>2] = $27;
 STACKTOP = sp;return;
}
function _qspGetNumber($expr) {
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $i = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $buf = sp + 16|0;
 $1 = $expr;
 $i = 0;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $pos = $3;
 while(1) {
  $4 = $pos;
  $5 = HEAP16[$4>>1]|0;
  $6 = (_qspIsDigit($5)|0);
  $7 = ($6|0)!=(0);
  if (!($7)) {
   break;
  }
  $8 = $i;
  $9 = ($8>>>0)<(10);
  if ($9) {
   $10 = $pos;
   $11 = HEAP16[$10>>1]|0;
   $12 = $i;
   $13 = (($buf) + ($12<<1)|0);
   HEAP16[$13>>1] = $11;
  }
  $14 = $i;
  $15 = (($14) + 1)|0;
  $i = $15;
  $16 = $pos;
  $17 = ((($16)) + 2|0);
  $pos = $17;
 }
 $18 = $pos;
 $19 = $1;
 HEAP32[$19>>2] = $18;
 $20 = $i;
 $21 = ($20>>>0)>(10);
 if ($21) {
  $0 = 2147483647;
  $25 = $0;
  STACKTOP = sp;return ($25|0);
 } else {
  $22 = $i;
  $23 = (($buf) + ($22<<1)|0);
  HEAP16[$23>>1] = 0;
  $24 = (_qspStrToNum($buf,0)|0);
  $0 = $24;
  $25 = $0;
  STACKTOP = sp;return ($25|0);
 }
 return (0)|0;
}
function _qspGetString($expr) {
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $bufSize = 0, $pos = 0, $quot = 0;
 var $strLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $expr;
 $strLen = 0;
 $bufSize = 16;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $pos = $3;
 $4 = $pos;
 $5 = HEAP16[$4>>1]|0;
 $quot = $5;
 $6 = $bufSize;
 $7 = $6<<1;
 $8 = (_malloc($7)|0);
 $buf = $8;
 while(1) {
  $9 = $pos;
  $10 = ((($9)) + 2|0);
  $pos = $10;
  $11 = HEAP16[$10>>1]|0;
  $12 = ($11<<16>>16)!=(0);
  if (!($12)) {
   label = 3;
   break;
  }
  $14 = $pos;
  $15 = HEAP16[$14>>1]|0;
  $16 = $15&65535;
  $17 = $quot;
  $18 = $17&65535;
  $19 = ($16|0)==($18|0);
  if ($19) {
   $20 = $pos;
   $21 = ((($20)) + 2|0);
   $pos = $21;
   $22 = HEAP16[$21>>1]|0;
   $23 = $22&65535;
   $24 = $quot;
   $25 = $24&65535;
   $26 = ($23|0)!=($25|0);
   if ($26) {
    break;
   }
  }
  $27 = $strLen;
  $28 = (($27) + 1)|0;
  $strLen = $28;
  $29 = $bufSize;
  $30 = ($28|0)>=($29|0);
  if ($30) {
   $31 = $bufSize;
   $32 = (($31) + 128)|0;
   $bufSize = $32;
   $33 = $buf;
   $34 = $bufSize;
   $35 = $34<<1;
   $36 = (_realloc($33,$35)|0);
   $buf = $36;
  }
  $37 = $pos;
  $38 = HEAP16[$37>>1]|0;
  $39 = $strLen;
  $40 = (($39) - 1)|0;
  $41 = $buf;
  $42 = (($41) + ($40<<1)|0);
  HEAP16[$42>>1] = $38;
 }
 if ((label|0) == 3) {
  _qspSetError(115);
  $13 = $buf;
  _free($13);
  $0 = 0;
  $55 = $0;
  STACKTOP = sp;return ($55|0);
 }
 $43 = $strLen;
 $44 = $buf;
 $45 = (($44) + ($43<<1)|0);
 HEAP16[$45>>1] = 0;
 $46 = $pos;
 $47 = $1;
 HEAP32[$47>>2] = $46;
 $48 = $buf;
 $49 = (_qspFormatText($48,1)|0);
 $pos = $49;
 $50 = $pos;
 $51 = $buf;
 $52 = ($50|0)!=($51|0);
 if ($52) {
  $53 = $buf;
  _free($53);
 }
 $54 = $pos;
 $0 = $54;
 $55 = $0;
 STACKTOP = sp;return ($55|0);
}
function _qspGetQString($expr) {
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $buf = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $expr;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $buf = $3;
 $4 = $buf;
 $5 = (_qspStrPos($4,444312,0)|0);
 $pos = $5;
 $6 = $pos;
 $7 = ($6|0)!=(0|0);
 if ($7) {
  $8 = $pos;
  $9 = ((($8)) + 2|0);
  $10 = $1;
  HEAP32[$10>>2] = $9;
  $11 = $buf;
  $12 = ((($11)) + 2|0);
  $13 = $pos;
  $14 = $buf;
  $15 = $13;
  $16 = $14;
  $17 = (($15) - ($16))|0;
  $18 = (($17|0) / 2)&-1;
  $19 = (($18) - 1)|0;
  $20 = (_qspGetNewText($12,$19)|0);
  $0 = $20;
  $21 = $0;
  STACKTOP = sp;return ($21|0);
 } else {
  _qspSetError(115);
  $0 = 0;
  $21 = $0;
  STACKTOP = sp;return ($21|0);
 }
 return (0)|0;
}
function _qspGetName($expr) {
 $expr = $expr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pos = 0, $startPos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $expr;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $startPos = $3;
 $4 = $startPos;
 $pos = $4;
 while(1) {
  $5 = $pos;
  $6 = ((($5)) + 2|0);
  $pos = $6;
  $7 = HEAP16[$6>>1]|0;
  $8 = $7&65535;
  $9 = HEAP16[446370>>1]|0;
  $10 = $9&65535;
  $11 = ($8|0)==($10|0);
  $12 = $pos;
  if ($11) {
   label = 3;
   break;
  }
  $17 = HEAP16[$12>>1]|0;
  $18 = (_qspIsInListEOL(446312,$17)|0);
  $19 = ($18|0)!=(0);
  $20 = $19 ^ 1;
  if (!($20)) {
   break;
  }
 }
 do {
  if ((label|0) == 3) {
   $13 = (_qspStrPos($12,444384,0)|0);
   $pos = $13;
   $14 = ($13|0)!=(0|0);
   if ($14) {
    $15 = $pos;
    $16 = ((($15)) + 2|0);
    $pos = $16;
    break;
   }
   _qspSetError(116);
   $0 = 0;
   $32 = $0;
   STACKTOP = sp;return ($32|0);
  }
 } while(0);
 $21 = $pos;
 $22 = (_qspSkipSpaces($21)|0);
 $23 = $1;
 HEAP32[$23>>2] = $22;
 $24 = $startPos;
 $25 = $pos;
 $26 = $startPos;
 $27 = $25;
 $28 = $26;
 $29 = (($27) - ($28))|0;
 $30 = (($29|0) / 2)&-1;
 $31 = (_qspGetNewText($24,$30)|0);
 $0 = $31;
 $32 = $0;
 STACKTOP = sp;return ($32|0);
}
function _qspFunctionOpCode($funName) {
 $funName = $funName|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $name = 0, $uName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $funName;
 $2 = $1;
 $3 = (_qspGetNewText($2,-1)|0);
 $uName = $3;
 _qspUpperStr($3);
 $4 = $uName;
 $5 = HEAP32[(4388)>>2]|0;
 $6 = (_bsearch($4,(5592),$5,12,69)|0);
 $name = $6;
 $7 = $uName;
 _free($7);
 $8 = $name;
 $9 = ($8|0)!=(0|0);
 if ($9) {
  $10 = $name;
  $11 = HEAP32[$10>>2]|0;
  $0 = $11;
  $12 = $0;
  STACKTOP = sp;return ($12|0);
 } else {
  $0 = 0;
  $12 = $0;
  STACKTOP = sp;return ($12|0);
 }
 return (0)|0;
}
function _qspMathOpStringFullCompare($name,$compareTo) {
 $name = $name|0;
 $compareTo = $compareTo|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $compareTo;
 $2 = $0;
 $3 = $1;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (_qspStrsComp($2,$5)|0);
 STACKTOP = sp;return ($6|0);
}
function _qspMathOpStringCompare($name,$compareTo) {
 $name = $name|0;
 $compareTo = $compareTo|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $compareTo;
 $2 = $0;
 $3 = $1;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = $1;
 $7 = ((($6)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_qspStrsNComp($2,$5,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function _qspApplyResult($varRes,$tos) {
 $varRes = $varRes|0;
 $tos = $tos|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $text = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $varRes;
 $1 = $tos;
 $2 = $0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)!=(0);
 if (!($5)) {
  $22 = $1;
  $23 = ((($22)) + 4|0);
  HEAP32[$23>>2] = 1;
  $24 = (_qspGetNewText(447354,0)|0);
  $25 = $1;
  HEAP32[$25>>2] = $24;
  STACKTOP = sp;return;
 }
 $6 = $0;
 $7 = ((($6)) + 4|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $text = $10;
 $11 = ($10|0)!=(0|0);
 $12 = $1;
 $13 = ((($12)) + 4|0);
 if ($11) {
  HEAP32[$13>>2] = 1;
  $14 = $text;
  $15 = (_qspGetNewText($14,-1)|0);
  $16 = $1;
  HEAP32[$16>>2] = $15;
  STACKTOP = sp;return;
 } else {
  HEAP32[$13>>2] = 0;
  $17 = $0;
  $18 = ((($17)) + 4|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = HEAP32[$19>>2]|0;
  $21 = $1;
  HEAP32[$21>>2] = $20;
  STACKTOP = sp;return;
 }
}
function _qspStatementShowMenu($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $$ = 0, $$1 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $arg = 0, $imgPath = 0, $ind = 0, $itemsCount = 0, $len = 0, $maxItems = 0, $menuLocs = 0, $pos = 0, $pos2 = 0, $str = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 464|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $arg = sp + 432|0;
 $menuLocs = sp + 16|0;
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = $1;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_qspVarReferenceWithType($6,0,0)|0);
 $var = $7;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  $0 = 0;
  $102 = $0;
  STACKTOP = sp;return ($102|0);
 }
 _qspCallDeleteMenu();
 $9 = $2;
 $10 = ($9|0)==(1);
 do {
  if ($10) {
   $ind = 0;
   $maxItems = 100;
  } else {
   $11 = $1;
   $12 = ((($11)) + 8|0);
   $13 = HEAP32[$12>>2]|0;
   $ind = $13;
   $14 = $ind;
   $15 = ($14|0)<(0);
   $$ = $15 ? 0 : $13;
   $ind = $$;
   $16 = $2;
   $17 = ($16|0)==(2);
   if ($17) {
    $maxItems = 100;
    break;
   } else {
    $18 = $1;
    $19 = ((($18)) + 16|0);
    $20 = HEAP32[$19>>2]|0;
    $maxItems = $20;
    $21 = $maxItems;
    $22 = ($21|0)<(0);
    $$1 = $22 ? 0 : $20;
    $maxItems = $$1;
    break;
   }
  }
 } while(0);
 $itemsCount = 0;
 while(1) {
  $23 = $ind;
  $24 = $var;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = ($23|0)<($26|0);
  if (!($27)) {
   label = 25;
   break;
  }
  $28 = $itemsCount;
  $29 = $maxItems;
  $30 = ($28|0)==($29|0);
  if ($30) {
   label = 25;
   break;
  }
  $31 = $ind;
  $32 = $var;
  $33 = ((($32)) + 4|0);
  $34 = HEAP32[$33>>2]|0;
  $35 = (($34) + ($31<<3)|0);
  $36 = ((($35)) + 4|0);
  $37 = HEAP32[$36>>2]|0;
  $str = $37;
  $38 = ($37|0)!=(0|0);
  if (!($38)) {
   label = 25;
   break;
  }
  $39 = $str;
  $40 = (_qspIsAnyString($39)|0);
  $41 = ($40|0)!=(0);
  if (!($41)) {
   label = 25;
   break;
  }
  $42 = $str;
  $43 = (_qspInStrRChars($42,446296,0)|0);
  $pos2 = $43;
  $44 = ($43|0)!=(0|0);
  if (!($44)) {
   label = 14;
   break;
  }
  $45 = $itemsCount;
  $46 = ($45|0)==(100);
  if ($46) {
   label = 16;
   break;
  }
  $47 = $str;
  $48 = $pos2;
  $49 = (_qspInStrRChars($47,446296,$48)|0);
  $pos = $49;
  $50 = ($49|0)!=(0|0);
  $51 = $pos2;
  if ($50) {
   $52 = $pos;
   $53 = $51;
   $54 = $52;
   $55 = (($53) - ($54))|0;
   $56 = (($55|0) / 2)&-1;
   $57 = (($56) - 1)|0;
   $len = $57;
   $58 = $pos2;
   $59 = ((($58)) + 2|0);
   $pos2 = $59;
   $60 = (_qspIsAnyString($59)|0);
   $61 = ($60|0)!=(0);
   if ($61) {
    $62 = $pos2;
    $63 = (_qspGetAbsFromRelPath($62)|0);
    $64 = $63;
   } else {
    $64 = 0;
   }
   $imgPath = $64;
  } else {
   $pos = $51;
   $len = -1;
   $imgPath = 0;
  }
  $65 = $pos;
  $66 = ((($65)) + 2|0);
  $67 = $len;
  $68 = (_qspGetNewText($66,$67)|0);
  $69 = $itemsCount;
  $70 = (($69) + 1)|0;
  $itemsCount = $70;
  $71 = (($menuLocs) + ($69<<2)|0);
  HEAP32[$71>>2] = $68;
  $72 = $pos;
  HEAP16[$72>>1] = 0;
  $73 = $str;
  $74 = $imgPath;
  _qspCallAddMenuItem($73,$74);
  $75 = HEAP16[446296>>1]|0;
  $76 = $pos;
  HEAP16[$76>>1] = $75;
  $77 = $imgPath;
  $78 = ($77|0)!=(0|0);
  if ($78) {
   $79 = $imgPath;
   _free($79);
  }
  $80 = $ind;
  $81 = (($80) + 1)|0;
  $ind = $81;
 }
 if ((label|0) == 14) {
  _qspSetError(107);
  $0 = 0;
  $102 = $0;
  STACKTOP = sp;return ($102|0);
 }
 else if ((label|0) == 16) {
  _qspSetError(122);
  $0 = 0;
  $102 = $0;
  STACKTOP = sp;return ($102|0);
 }
 else if ((label|0) == 25) {
  $82 = $itemsCount;
  $83 = ($82|0)!=(0);
  L32: do {
   if ($83) {
    $84 = (_qspCallShowMenu()|0);
    $ind = $84;
    $85 = $ind;
    $86 = ($85|0)>=(0);
    if ($86) {
     $87 = $ind;
     $88 = $itemsCount;
     $89 = ($87|0)<($88|0);
     if ($89) {
      $90 = ((($arg)) + 4|0);
      HEAP32[$90>>2] = 0;
      $91 = $ind;
      $92 = (($91) + 1)|0;
      HEAP32[$arg>>2] = $92;
      $93 = $ind;
      $94 = (($menuLocs) + ($93<<2)|0);
      $95 = HEAP32[$94>>2]|0;
      _qspExecLocByNameWithArgs($95,$arg,1);
     }
    }
    while(1) {
     $96 = $itemsCount;
     $97 = (($96) + -1)|0;
     $itemsCount = $97;
     $98 = ($97|0)>=(0);
     if (!($98)) {
      break L32;
     }
     $99 = $itemsCount;
     $100 = (($menuLocs) + ($99<<2)|0);
     $101 = HEAP32[$100>>2]|0;
     _free($101);
    }
   }
  } while(0);
  $0 = 0;
  $102 = $0;
  STACKTOP = sp;return ($102|0);
 }
 return (0)|0;
}
function _qspClearPlayList($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $1 = $0;
 $2 = ($1|0)!=(0);
 if ($2) {
  HEAP32[10636>>2] = 0;
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $3 = $i;
  $4 = HEAP32[10636>>2]|0;
  $5 = ($3|0)<($4|0);
  if (!($5)) {
   break;
  }
  $6 = $i;
  $7 = (10640 + ($6<<2)|0);
  $8 = HEAP32[$7>>2]|0;
  _free($8);
  $9 = $i;
  $10 = (($9) + 1)|0;
  $i = $10;
 }
 HEAP32[10636>>2] = 0;
 STACKTOP = sp;return;
}
function _qspPlayPLFiles() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = HEAP32[10636>>2]|0;
  $2 = ($0|0)<($1|0);
  if (!($2)) {
   break;
  }
  $3 = $i;
  $4 = (10640 + ($3<<2)|0);
  $5 = HEAP32[$4>>2]|0;
  $6 = HEAP16[444280>>1]|0;
  $7 = (_qspStrChar($5,$6)|0);
  $pos = $7;
  $8 = $pos;
  $9 = ($8|0)!=(0|0);
  if ($9) {
   $10 = $pos;
   HEAP16[$10>>1] = 0;
   $11 = $i;
   $12 = (10640 + ($11<<2)|0);
   $13 = HEAP32[$12>>2]|0;
   $14 = $pos;
   $15 = ((($14)) + 2|0);
   $16 = (_qspStrToNum($15,0)|0);
   _qspPlayFile($13,$16,0);
   $17 = HEAP16[444280>>1]|0;
   $18 = $pos;
   HEAP16[$18>>1] = $17;
  } else {
   $19 = $i;
   $20 = (10640 + ($19<<2)|0);
   $21 = HEAP32[$20>>2]|0;
   _qspPlayFile($21,100,0);
  }
  $22 = $i;
  $23 = (($22) + 1)|0;
  $i = $23;
 }
 STACKTOP = sp;return;
}
function _qspRefreshPlayList() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $count = 0, $file = 0, $pos = 0, $s = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $s = sp + 16|0;
 $0 = HEAP32[10636>>2]|0;
 $count = $0;
 $1 = $count;
 $2 = ($1|0)!=(0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = $count;
 _qspCopyStrs($s,10640,0,$3);
 _qspClearPlayList(0);
 while(1) {
  $4 = $count;
  $5 = (($4) + -1)|0;
  $count = $5;
  $6 = ($5|0)>=(0);
  if (!($6)) {
   break;
  }
  $7 = $count;
  $8 = HEAP32[$s>>2]|0;
  $9 = (($8) + ($7<<2)|0);
  $10 = HEAP32[$9>>2]|0;
  $str = $10;
  $11 = $str;
  $12 = HEAP16[444280>>1]|0;
  $13 = (_qspStrChar($11,$12)|0);
  $pos = $13;
  $14 = $pos;
  $15 = ($14|0)!=(0|0);
  if ($15) {
   $16 = $pos;
   HEAP16[$16>>1] = 0;
  }
  $17 = $str;
  $18 = (_qspIsAnyString($17)|0);
  $19 = ($18|0)!=(0);
  if ($19) {
   $20 = $str;
   $21 = (_qspGetAbsFromRelPath($20)|0);
   $file = $21;
   $22 = $str;
   $23 = (_qspSearchPlayList($22)|0);
   $24 = ($23|0)<(0);
   if ($24) {
    $25 = $file;
    $26 = (_qspCallIsPlayingFile($25)|0);
    $27 = ($26|0)!=(0);
    if ($27) {
     $28 = $pos;
     $29 = ($28|0)!=(0|0);
     if ($29) {
      $30 = HEAP16[444280>>1]|0;
      $31 = $pos;
      HEAP16[$31>>1] = $30;
     }
     $32 = $str;
     $33 = (_qspGetNewText($32,-1)|0);
     $34 = HEAP32[10636>>2]|0;
     $35 = (($34) + 1)|0;
     HEAP32[10636>>2] = $35;
     $36 = (10640 + ($34<<2)|0);
     HEAP32[$36>>2] = $33;
    }
   }
   $37 = $file;
   _free($37);
  }
  $38 = $str;
  _free($38);
 }
 $39 = HEAP32[$s>>2]|0;
 _free($39);
 STACKTOP = sp;return;
}
function _qspStatementPlayFile($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $volume = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 $4 = $1;
 $5 = ($4|0)==(2);
 if ($5) {
  $6 = $0;
  $7 = ((($6)) + 8|0);
  $8 = HEAP32[$7>>2]|0;
  $9 = $8;
 } else {
  $9 = 100;
 }
 $volume = $9;
 $10 = $0;
 $11 = HEAP32[$10>>2]|0;
 $12 = $volume;
 _qspPlayFile($11,$12,1);
 STACKTOP = sp;return 0;
}
function _qspStatementCloseFile($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $file = 0, $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = HEAP32[10636>>2]|0;
 $6 = ($5|0)!=(0);
 if (!($6)) {
  $0 = 0;
  $44 = $0;
  STACKTOP = sp;return ($44|0);
 }
 $7 = $2;
 $8 = ($7|0)!=(0);
 if ($8) {
  $9 = $1;
  $10 = HEAP32[$9>>2]|0;
  $11 = (_qspIsAnyString($10)|0);
  $12 = ($11|0)!=(0);
  if ($12) {
   $13 = $1;
   $14 = HEAP32[$13>>2]|0;
   $15 = (_qspSearchPlayList($14)|0);
   $pos = $15;
   $16 = $pos;
   $17 = ($16|0)>=(0);
   if ($17) {
    $18 = $1;
    $19 = HEAP32[$18>>2]|0;
    $20 = (_qspGetAbsFromRelPath($19)|0);
    $file = $20;
    $21 = $file;
    _qspCallCloseFile($21);
    $22 = $file;
    _free($22);
    while(1) {
     $23 = $pos;
     $24 = (10640 + ($23<<2)|0);
     $25 = HEAP32[$24>>2]|0;
     _free($25);
     $26 = HEAP32[10636>>2]|0;
     $27 = (($26) + -1)|0;
     HEAP32[10636>>2] = $27;
     while(1) {
      $28 = $pos;
      $29 = HEAP32[10636>>2]|0;
      $30 = ($28|0)<($29|0);
      if (!($30)) {
       break;
      }
      $31 = $pos;
      $32 = (($31) + 1)|0;
      $33 = (10640 + ($32<<2)|0);
      $34 = HEAP32[$33>>2]|0;
      $35 = $pos;
      $36 = (10640 + ($35<<2)|0);
      HEAP32[$36>>2] = $34;
      $37 = $pos;
      $38 = (($37) + 1)|0;
      $pos = $38;
     }
     $39 = $1;
     $40 = HEAP32[$39>>2]|0;
     $41 = (_qspSearchPlayList($40)|0);
     $pos = $41;
     $42 = $pos;
     $43 = ($42|0)>=(0);
     if (!($43)) {
      break;
     }
    }
   }
  }
 } else {
  _qspClearPlayList(0);
  _qspCallCloseFile(0);
 }
 $0 = 0;
 $44 = $0;
 STACKTOP = sp;return ($44|0);
}
function _qspPlayFile($s,$volume,$isAddToPlayList) {
 $s = $s|0;
 $volume = $volume|0;
 $isAddToPlayList = $isAddToPlayList|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $file = 0, $len = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $buf = sp + 24|0;
 $file = sp;
 $0 = $s;
 $1 = $volume;
 $2 = $isAddToPlayList;
 $3 = $0;
 $4 = (_qspIsAnyString($3)|0);
 $5 = ($4|0)!=(0);
 if (!($5)) {
  STACKTOP = sp;return;
 }
 $6 = $1;
 $7 = ($6|0)<(0);
 if ($7) {
  $1 = 0;
 } else {
  $8 = $1;
  $9 = ($8|0)>(100);
  if ($9) {
   $1 = 100;
  }
 }
 $10 = $0;
 $11 = (_qspGetAbsFromRelPath($10)|0);
 HEAP32[$file>>2] = $11;
 $12 = HEAP32[$file>>2]|0;
 $13 = $1;
 _qspCallPlayFile($12,$13);
 $14 = HEAP32[$file>>2]|0;
 _free($14);
 $15 = $2;
 $16 = ($15|0)!=(0);
 if (!($16)) {
  STACKTOP = sp;return;
 }
 $17 = HEAP32[10636>>2]|0;
 $18 = ($17|0)==(500);
 if ($18) {
  _qspRefreshPlayList();
  $19 = HEAP32[10636>>2]|0;
  $20 = ($19|0)==(500);
  if ($20) {
   STACKTOP = sp;return;
  }
 }
 $21 = $0;
 $22 = (_qspAddText($file,$21,0,-1,1)|0);
 $len = $22;
 $23 = $1;
 $24 = ($23|0)!=(100);
 if ($24) {
  $25 = $len;
  $26 = (_qspAddText($file,444280,$25,1,0)|0);
  $len = $26;
  $27 = HEAP32[$file>>2]|0;
  $28 = $1;
  $29 = (_qspNumToStr($buf,$28)|0);
  $30 = $len;
  $31 = (_qspGetAddText($27,$29,$30,-1)|0);
  HEAP32[$file>>2] = $31;
 }
 $32 = HEAP32[$file>>2]|0;
 $33 = HEAP32[10636>>2]|0;
 $34 = (($33) + 1)|0;
 HEAP32[10636>>2] = $34;
 $35 = (10640 + ($33<<2)|0);
 HEAP32[$35>>2] = $32;
 STACKTOP = sp;return;
}
function _qspSearchPlayList($file) {
 $file = $file|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $bufSize = 0, $i = 0, $itemLen = 0, $len = 0, $uName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $file;
 $2 = HEAP32[10636>>2]|0;
 $3 = ($2|0)!=(0);
 if (!($3)) {
  $0 = -1;
  $51 = $0;
  STACKTOP = sp;return ($51|0);
 }
 $4 = $1;
 $5 = (_qspStrLen($4)|0);
 $len = $5;
 $6 = $1;
 $7 = $len;
 $8 = (_qspGetNewText($6,$7)|0);
 $uName = $8;
 _qspUpperStr($8);
 $bufSize = 32;
 $9 = $bufSize;
 $10 = $9<<1;
 $11 = (_malloc($10)|0);
 $buf = $11;
 $i = 0;
 while(1) {
  $12 = $i;
  $13 = HEAP32[10636>>2]|0;
  $14 = ($12|0)<($13|0);
  if (!($14)) {
   label = 11;
   break;
  }
  $15 = $i;
  $16 = (10640 + ($15<<2)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_qspStrLen($17)|0);
  $itemLen = $18;
  $19 = $itemLen;
  $20 = $bufSize;
  $21 = ($19|0)>=($20|0);
  if ($21) {
   $22 = $itemLen;
   $23 = (($22) + 8)|0;
   $bufSize = $23;
   $24 = $buf;
   $25 = $bufSize;
   $26 = $25<<1;
   $27 = (_realloc($24,$26)|0);
   $buf = $27;
  }
  $28 = $buf;
  $29 = $i;
  $30 = (10640 + ($29<<2)|0);
  $31 = HEAP32[$30>>2]|0;
  (_qspStrCopy($28,$31)|0);
  $32 = $buf;
  _qspUpperStr($32);
  $33 = $buf;
  $34 = $uName;
  $35 = $len;
  $36 = (_qspStrsNComp($33,$34,$35)|0);
  $37 = ($36|0)!=(0);
  if (!($37)) {
   $38 = $len;
   $39 = $buf;
   $40 = (($39) + ($38<<1)|0);
   $41 = HEAP16[$40>>1]|0;
   $42 = (_qspIsInListEOL(444280,$41)|0);
   $43 = ($42|0)!=(0);
   if ($43) {
    label = 9;
    break;
   }
  }
  $47 = $i;
  $48 = (($47) + 1)|0;
  $i = $48;
 }
 if ((label|0) == 9) {
  $44 = $uName;
  _free($44);
  $45 = $buf;
  _free($45);
  $46 = $i;
  $0 = $46;
  $51 = $0;
  STACKTOP = sp;return ($51|0);
 }
 else if ((label|0) == 11) {
  $49 = $uName;
  _free($49);
  $50 = $buf;
  _free($50);
  $0 = -1;
  $51 = $0;
  STACKTOP = sp;return ($51|0);
 }
 return (0)|0;
}
function _qspAddText($dest,$val,$destLen,$valLen,$isCreate) {
 $dest = $dest|0;
 $val = $val|0;
 $destLen = $destLen|0;
 $valLen = $valLen|0;
 $isCreate = $isCreate|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $destPtr = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $dest;
 $1 = $val;
 $2 = $destLen;
 $3 = $valLen;
 $4 = $isCreate;
 $5 = $3;
 $6 = ($5|0)<(0);
 if ($6) {
  $7 = $1;
  $8 = (_qspStrLen($7)|0);
  $3 = $8;
 }
 $9 = $4;
 $10 = ($9|0)!=(0);
 if (!($10)) {
  $11 = $0;
  $12 = HEAP32[$11>>2]|0;
  $13 = ($12|0)!=(0|0);
  if ($13) {
   $14 = $2;
   $15 = ($14|0)<(0);
   if ($15) {
    $16 = $0;
    $17 = HEAP32[$16>>2]|0;
    $18 = (_qspStrLen($17)|0);
    $2 = $18;
   }
   $19 = $2;
   $20 = $3;
   $21 = (($19) + ($20))|0;
   $ret = $21;
   $22 = $0;
   $23 = HEAP32[$22>>2]|0;
   $24 = $ret;
   $25 = (($24) + 1)|0;
   $26 = $25<<1;
   $27 = (_realloc($23,$26)|0);
   $destPtr = $27;
   $28 = $destPtr;
   $29 = $0;
   HEAP32[$29>>2] = $28;
   $30 = $2;
   $31 = $destPtr;
   $32 = (($31) + ($30<<1)|0);
   $destPtr = $32;
   $40 = $destPtr;
   $41 = $1;
   $42 = $3;
   (_qspStrNCopy($40,$41,$42)|0);
   $43 = $3;
   $44 = $destPtr;
   $45 = (($44) + ($43<<1)|0);
   HEAP16[$45>>1] = 0;
   $46 = $ret;
   STACKTOP = sp;return ($46|0);
  }
 }
 $33 = $3;
 $ret = $33;
 $34 = $ret;
 $35 = (($34) + 1)|0;
 $36 = $35<<1;
 $37 = (_malloc($36)|0);
 $destPtr = $37;
 $38 = $destPtr;
 $39 = $0;
 HEAP32[$39>>2] = $38;
 $40 = $destPtr;
 $41 = $1;
 $42 = $3;
 (_qspStrNCopy($40,$41,$42)|0);
 $43 = $3;
 $44 = $destPtr;
 $45 = (($44) + ($43<<1)|0);
 HEAP16[$45>>1] = 0;
 $46 = $ret;
 STACKTOP = sp;return ($46|0);
}
function _qspStrLen($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $bos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $0;
 $bos = $1;
 while(1) {
  $2 = $0;
  $3 = HEAP16[$2>>1]|0;
  $4 = ($3<<16>>16)!=(0);
  $5 = $0;
  if (!($4)) {
   break;
  }
  $6 = ((($5)) + 2|0);
  $0 = $6;
 }
 $7 = $bos;
 $8 = $5;
 $9 = $7;
 $10 = (($8) - ($9))|0;
 $11 = (($10|0) / 2)&-1;
 STACKTOP = sp;return ($11|0);
}
function _qspStrNCopy($strDest,$strSource,$maxLen) {
 $strDest = $strDest|0;
 $strSource = $strSource|0;
 $maxLen = $maxLen|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $strDest;
 $1 = $strSource;
 $2 = $maxLen;
 $3 = $0;
 $ret = $3;
 while(1) {
  $4 = $2;
  $5 = (($4) + -1)|0;
  $2 = $5;
  $6 = ($4|0)!=(0);
  if (!($6)) {
   label = 4;
   break;
  }
  $7 = $1;
  $8 = ((($7)) + 2|0);
  $1 = $8;
  $9 = HEAP16[$7>>1]|0;
  $10 = $0;
  $11 = ((($10)) + 2|0);
  $0 = $11;
  HEAP16[$10>>1] = $9;
  $12 = $9&65535;
  $13 = ($12|0)!=(0);
  if (!($13)) {
   label = 4;
   break;
  }
 }
 if ((label|0) == 4) {
  $14 = $ret;
  STACKTOP = sp;return ($14|0);
 }
 return (0)|0;
}
function _qspGetNewText($val,$valLen) {
 $val = $val|0;
 $valLen = $valLen|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $buf = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $buf = sp;
 $0 = $val;
 $1 = $valLen;
 $2 = $0;
 $3 = $1;
 (_qspAddText($buf,$2,0,$3,1)|0);
 $4 = HEAP32[$buf>>2]|0;
 STACKTOP = sp;return ($4|0);
}
function _qspGetAddText($dest,$val,$destLen,$valLen) {
 $dest = $dest|0;
 $val = $val|0;
 $destLen = $destLen|0;
 $valLen = $valLen|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = sp + 12|0;
 HEAP32[$0>>2] = $dest;
 $1 = $val;
 $2 = $destLen;
 $3 = $valLen;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 (_qspAddText($0,$4,$5,$6,0)|0);
 $7 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _qspClearText($text,$textLen) {
 $text = $text|0;
 $textLen = $textLen|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $text;
 $2 = $textLen;
 $3 = $1;
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)!=(0|0);
 if ($5) {
  $6 = $1;
  $7 = HEAP32[$6>>2]|0;
  _free($7);
  $8 = $1;
  HEAP32[$8>>2] = 0;
  $9 = $2;
  $10 = HEAP32[$9>>2]|0;
  $11 = ($10|0)!=(0);
  if ($11) {
   $12 = $2;
   HEAP32[$12>>2] = 0;
   $0 = 1;
   $13 = $0;
   STACKTOP = sp;return ($13|0);
  }
 }
 $0 = 0;
 $13 = $0;
 STACKTOP = sp;return ($13|0);
}
function _qspIsInList($list,$ch) {
 $list = $list|0;
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $list;
 $2 = $ch;
 while(1) {
  $3 = $1;
  $4 = HEAP16[$3>>1]|0;
  $5 = ($4<<16>>16)!=(0);
  if (!($5)) {
   label = 5;
   break;
  }
  $6 = $1;
  $7 = ((($6)) + 2|0);
  $1 = $7;
  $8 = HEAP16[$6>>1]|0;
  $9 = $8&65535;
  $10 = $2;
  $11 = $10&65535;
  $12 = ($9|0)==($11|0);
  if ($12) {
   label = 4;
   break;
  }
 }
 if ((label|0) == 4) {
  $0 = 1;
  $13 = $0;
  STACKTOP = sp;return ($13|0);
 }
 else if ((label|0) == 5) {
  $0 = 0;
  $13 = $0;
  STACKTOP = sp;return ($13|0);
 }
 return (0)|0;
}
function _qspIsInListEOL($list,$ch) {
 $list = $list|0;
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $list;
 $1 = $ch;
 while(1) {
  $2 = $0;
  $3 = HEAP16[$2>>1]|0;
  $4 = $3&65535;
  $5 = ($4|0)!=(0);
  if ($5) {
   $6 = $0;
   $7 = HEAP16[$6>>1]|0;
   $8 = $7&65535;
   $9 = $1;
   $10 = $9&65535;
   $11 = ($8|0)!=($10|0);
   $20 = $11;
  } else {
   $20 = 0;
  }
  $12 = $0;
  if (!($20)) {
   break;
  }
  $13 = ((($12)) + 2|0);
  $0 = $13;
 }
 $14 = HEAP16[$12>>1]|0;
 $15 = $14&65535;
 $16 = $1;
 $17 = $16&65535;
 $18 = ($15|0)==($17|0);
 $19 = $18&1;
 STACKTOP = sp;return ($19|0);
}
function _qspIsDigit($ch) {
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $ch;
 $1 = $0;
 $2 = $1&65535;
 $3 = ($2|0)>=(48);
 if ($3) {
  $4 = $0;
  $5 = $4&65535;
  $6 = ($5|0)<=(57);
  $8 = $6;
 } else {
  $8 = 0;
 }
 $7 = $8&1;
 STACKTOP = sp;return ($7|0);
}
function _qspSkipSpaces($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 while(1) {
  $1 = $0;
  $2 = HEAP16[$1>>1]|0;
  $3 = (_qspIsInList(444284,$2)|0);
  $4 = ($3|0)!=(0);
  $5 = $0;
  if (!($4)) {
   break;
  }
  $6 = ((($5)) + 2|0);
  $0 = $6;
 }
 STACKTOP = sp;return ($5|0);
}
function _qspStrEnd($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 while(1) {
  $1 = $0;
  $2 = HEAP16[$1>>1]|0;
  $3 = ($2<<16>>16)!=(0);
  $4 = $0;
  if (!($3)) {
   break;
  }
  $5 = ((($4)) + 2|0);
  $0 = $5;
 }
 STACKTOP = sp;return ($4|0);
}
function _qspDelSpc($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $begin = 0, $end = 0, $len = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $0;
 $2 = (_qspSkipSpaces($1)|0);
 $begin = $2;
 $3 = $begin;
 $4 = (_qspStrEnd($3)|0);
 $end = $4;
 while(1) {
  $5 = $begin;
  $6 = $end;
  $7 = ($5>>>0)<($6>>>0);
  if ($7) {
   $8 = $end;
   $9 = ((($8)) + -2|0);
   $10 = HEAP16[$9>>1]|0;
   $11 = (_qspIsInList(444284,$10)|0);
   $12 = ($11|0)!=(0);
   $31 = $12;
  } else {
   $31 = 0;
  }
  $13 = $end;
  if (!($31)) {
   break;
  }
  $14 = ((($13)) + -2|0);
  $end = $14;
 }
 $15 = $begin;
 $16 = $13;
 $17 = $15;
 $18 = (($16) - ($17))|0;
 $19 = (($18|0) / 2)&-1;
 $len = $19;
 $20 = $len;
 $21 = (($20) + 1)|0;
 $22 = $21<<1;
 $23 = (_malloc($22)|0);
 $str = $23;
 $24 = $str;
 $25 = $begin;
 $26 = $len;
 (_qspStrNCopy($24,$25,$26)|0);
 $27 = $len;
 $28 = $str;
 $29 = (($28) + ($27<<1)|0);
 HEAP16[$29>>1] = 0;
 $30 = $str;
 STACKTOP = sp;return ($30|0);
}
function _qspDelSpcCanRetSelf($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $begin = 0, $end = 0, $len = 0, $origEnd = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $s;
 $2 = $1;
 $3 = (_qspSkipSpaces($2)|0);
 $begin = $3;
 $4 = $begin;
 $5 = (_qspStrEnd($4)|0);
 $end = $5;
 $6 = $end;
 $origEnd = $6;
 while(1) {
  $7 = $begin;
  $8 = $end;
  $9 = ($7>>>0)<($8>>>0);
  if (!($9)) {
   break;
  }
  $10 = $end;
  $11 = ((($10)) + -2|0);
  $12 = HEAP16[$11>>1]|0;
  $13 = (_qspIsInList(444284,$12)|0);
  $14 = ($13|0)!=(0);
  if (!($14)) {
   break;
  }
  $15 = $end;
  $16 = ((($15)) + -2|0);
  $end = $16;
 }
 $17 = $begin;
 $18 = $1;
 $19 = ($17|0)==($18|0);
 if ($19) {
  $20 = $end;
  $21 = $origEnd;
  $22 = ($20|0)==($21|0);
  if ($22) {
   $23 = $1;
   $0 = $23;
   $41 = $0;
   STACKTOP = sp;return ($41|0);
  }
 }
 $24 = $end;
 $25 = $begin;
 $26 = $24;
 $27 = $25;
 $28 = (($26) - ($27))|0;
 $29 = (($28|0) / 2)&-1;
 $len = $29;
 $30 = $len;
 $31 = (($30) + 1)|0;
 $32 = $31<<1;
 $33 = (_malloc($32)|0);
 $str = $33;
 $34 = $str;
 $35 = $begin;
 $36 = $len;
 (_qspStrNCopy($34,$35,$36)|0);
 $37 = $len;
 $38 = $str;
 $39 = (($38) + ($37<<1)|0);
 HEAP16[$39>>1] = 0;
 $40 = $str;
 $0 = $40;
 $41 = $0;
 STACKTOP = sp;return ($41|0);
}
function _qspIsAnyString($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $0;
 $2 = (_qspSkipSpaces($1)|0);
 $3 = HEAP16[$2>>1]|0;
 $4 = $3&65535;
 $5 = ($4|0)!=(0);
 $6 = $5&1;
 STACKTOP = sp;return ($6|0);
}
function _qspLowerStr($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 while(1) {
  $1 = $0;
  $2 = HEAP16[$1>>1]|0;
  $3 = ($2<<16>>16)!=(0);
  if (!($3)) {
   break;
  }
  $4 = $0;
  $5 = HEAP16[$4>>1]|0;
  $6 = $5&65535;
  $7 = (_qspToWLower($6)|0);
  $8 = $7&65535;
  $9 = $0;
  $10 = ((($9)) + 2|0);
  $0 = $10;
  HEAP16[$9>>1] = $8;
 }
 STACKTOP = sp;return;
}
function _qspUpperStr($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 while(1) {
  $1 = $0;
  $2 = HEAP16[$1>>1]|0;
  $3 = ($2<<16>>16)!=(0);
  if (!($3)) {
   break;
  }
  $4 = $0;
  $5 = HEAP16[$4>>1]|0;
  $6 = $5&65535;
  $7 = (_qspToWUpper($6)|0);
  $8 = $7&65535;
  $9 = $0;
  $10 = ((($9)) + 2|0);
  $0 = $10;
  HEAP16[$9>>1] = $8;
 }
 STACKTOP = sp;return;
}
function _qspStrsNComp($str1,$str2,$maxLen) {
 $str1 = $str1|0;
 $str2 = $str2|0;
 $maxLen = $maxLen|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $delta = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str1;
 $1 = $str2;
 $2 = $maxLen;
 $delta = 0;
 while(1) {
  $3 = $2;
  $4 = (($3) + -1)|0;
  $2 = $4;
  $5 = ($3|0)!=(0);
  if (!($5)) {
   label = 6;
   break;
  }
  $6 = $0;
  $7 = HEAP16[$6>>1]|0;
  $8 = $7&65535;
  $9 = $1;
  $10 = HEAP16[$9>>1]|0;
  $11 = $10&65535;
  $12 = (($8) - ($11))|0;
  $delta = $12;
  $13 = ($12|0)!=(0);
  if ($13) {
   label = 6;
   break;
  }
  $14 = $1;
  $15 = HEAP16[$14>>1]|0;
  $16 = $15&65535;
  $17 = ($16|0)!=(0);
  if (!($17)) {
   label = 6;
   break;
  }
  $18 = $0;
  $19 = ((($18)) + 2|0);
  $0 = $19;
  $20 = $1;
  $21 = ((($20)) + 2|0);
  $1 = $21;
 }
 if ((label|0) == 6) {
  $22 = $delta;
  STACKTOP = sp;return ($22|0);
 }
 return (0)|0;
}
function _qspStrsComp($str1,$str2) {
 $str1 = $str1|0;
 $str2 = $str2|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str1;
 $2 = $str2;
 $ret = 0;
 while(1) {
  $3 = $1;
  $4 = HEAP16[$3>>1]|0;
  $5 = $4&65535;
  $6 = $2;
  $7 = HEAP16[$6>>1]|0;
  $8 = $7&65535;
  $9 = (($5) - ($8))|0;
  $ret = $9;
  $10 = ($9|0)!=(0);
  if ($10) {
   break;
  }
  $11 = $2;
  $12 = HEAP16[$11>>1]|0;
  $13 = $12&65535;
  $14 = ($13|0)!=(0);
  if (!($14)) {
   break;
  }
  $15 = $1;
  $16 = ((($15)) + 2|0);
  $1 = $16;
  $17 = $2;
  $18 = ((($17)) + 2|0);
  $2 = $18;
 }
 $19 = $ret;
 $20 = ($19|0)<(0);
 if ($20) {
  $0 = -1;
  $23 = $0;
  STACKTOP = sp;return ($23|0);
 }
 $21 = $ret;
 $22 = ($21|0)>(0);
 if ($22) {
  $0 = 1;
  $23 = $0;
  STACKTOP = sp;return ($23|0);
 } else {
  $0 = 0;
  $23 = $0;
  STACKTOP = sp;return ($23|0);
 }
 return (0)|0;
}
function _qspStrCopy($strDest,$strSource) {
 $strDest = $strDest|0;
 $strSource = $strSource|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $strDest;
 $1 = $strSource;
 $2 = $0;
 $ret = $2;
 while(1) {
  $3 = $1;
  $4 = ((($3)) + 2|0);
  $1 = $4;
  $5 = HEAP16[$3>>1]|0;
  $6 = $0;
  $7 = ((($6)) + 2|0);
  $0 = $7;
  HEAP16[$6>>1] = $5;
  $8 = ($5<<16>>16)!=(0);
  if (!($8)) {
   break;
  }
 }
 $9 = $ret;
 STACKTOP = sp;return ($9|0);
}
function _qspStrChar($str,$ch) {
 $str = $str|0;
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str;
 $2 = $ch;
 while(1) {
  $3 = $1;
  $4 = HEAP16[$3>>1]|0;
  $5 = $4&65535;
  $6 = ($5|0)!=(0);
  if ($6) {
   $7 = $1;
   $8 = HEAP16[$7>>1]|0;
   $9 = $8&65535;
   $10 = $2;
   $11 = $10&65535;
   $12 = ($9|0)!=($11|0);
   $22 = $12;
  } else {
   $22 = 0;
  }
  $13 = $1;
  if (!($22)) {
   break;
  }
  $14 = ((($13)) + 2|0);
  $1 = $14;
 }
 $15 = HEAP16[$13>>1]|0;
 $16 = $15&65535;
 $17 = $2;
 $18 = $17&65535;
 $19 = ($16|0)==($18|0);
 if ($19) {
  $20 = $1;
  $0 = $20;
  $21 = $0;
  STACKTOP = sp;return ($21|0);
 } else {
  $0 = 0;
  $21 = $0;
  STACKTOP = sp;return ($21|0);
 }
 return (0)|0;
}
function _qspStrStr($str,$strSearch) {
 $str = $str|0;
 $strSearch = $strSearch|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $s1 = 0, $s2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str;
 $2 = $strSearch;
 while(1) {
  $3 = $1;
  $4 = HEAP16[$3>>1]|0;
  $5 = ($4<<16>>16)!=(0);
  if (!($5)) {
   label = 11;
   break;
  }
  $6 = $1;
  $s1 = $6;
  $7 = $2;
  $s2 = $7;
  while(1) {
   $8 = $s1;
   $9 = HEAP16[$8>>1]|0;
   $10 = $9&65535;
   $11 = ($10|0)!=(0);
   if (!($11)) {
    break;
   }
   $12 = $s2;
   $13 = HEAP16[$12>>1]|0;
   $14 = $13&65535;
   $15 = ($14|0)!=(0);
   if (!($15)) {
    break;
   }
   $16 = $s1;
   $17 = HEAP16[$16>>1]|0;
   $18 = $17&65535;
   $19 = $s2;
   $20 = HEAP16[$19>>1]|0;
   $21 = $20&65535;
   $22 = (($18) - ($21))|0;
   $23 = ($22|0)!=(0);
   $24 = $23 ^ 1;
   if (!($24)) {
    break;
   }
   $25 = $s1;
   $26 = ((($25)) + 2|0);
   $s1 = $26;
   $27 = $s2;
   $28 = ((($27)) + 2|0);
   $s2 = $28;
  }
  $29 = $s2;
  $30 = HEAP16[$29>>1]|0;
  $31 = ($30<<16>>16)!=(0);
  $32 = $1;
  if (!($31)) {
   label = 9;
   break;
  }
  $33 = ((($32)) + 2|0);
  $1 = $33;
 }
 if ((label|0) == 9) {
  $0 = $32;
  $34 = $0;
  STACKTOP = sp;return ($34|0);
 }
 else if ((label|0) == 11) {
  $0 = 0;
  $34 = $0;
  STACKTOP = sp;return ($34|0);
 }
 return (0)|0;
}
function _qspStrPBrk($str,$strCharSet) {
 $str = $str|0;
 $strCharSet = $strCharSet|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $set = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str;
 $2 = $strCharSet;
 L1: while(1) {
  $3 = $1;
  $4 = HEAP16[$3>>1]|0;
  $5 = ($4<<16>>16)!=(0);
  if (!($5)) {
   label = 9;
   break;
  }
  $6 = $2;
  $set = $6;
  while(1) {
   $7 = $set;
   $8 = HEAP16[$7>>1]|0;
   $9 = ($8<<16>>16)!=(0);
   if (!($9)) {
    break;
   }
   $10 = $set;
   $11 = HEAP16[$10>>1]|0;
   $12 = $11&65535;
   $13 = $1;
   $14 = HEAP16[$13>>1]|0;
   $15 = $14&65535;
   $16 = ($12|0)==($15|0);
   if ($16) {
    label = 6;
    break L1;
   }
   $18 = $set;
   $19 = ((($18)) + 2|0);
   $set = $19;
  }
  $20 = $1;
  $21 = ((($20)) + 2|0);
  $1 = $21;
 }
 if ((label|0) == 6) {
  $17 = $1;
  $0 = $17;
  $22 = $0;
  STACKTOP = sp;return ($22|0);
 }
 else if ((label|0) == 9) {
  $0 = 0;
  $22 = $0;
  STACKTOP = sp;return ($22|0);
 }
 return (0)|0;
}
function _qspInStrRChars($str,$chars,$end) {
 $str = $str|0;
 $chars = $chars|0;
 $end = $end|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $pos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $chars;
 $2 = $end;
 $pos = 0;
 while(1) {
  $3 = $0;
  $4 = HEAP16[$3>>1]|0;
  $5 = ($4<<16>>16)!=(0);
  if (!($5)) {
   label = 8;
   break;
  }
  $6 = $2;
  $7 = ($6|0)!=(0|0);
  if ($7) {
   $8 = $0;
   $9 = $2;
   $10 = ($8|0)==($9|0);
   if ($10) {
    label = 8;
    break;
   }
  }
  $11 = $1;
  $12 = $0;
  $13 = HEAP16[$12>>1]|0;
  $14 = (_qspIsInList($11,$13)|0);
  $15 = ($14|0)!=(0);
  if ($15) {
   $16 = $0;
   $pos = $16;
  }
  $17 = $0;
  $18 = ((($17)) + 2|0);
  $0 = $18;
 }
 if ((label|0) == 8) {
  $19 = $pos;
  STACKTOP = sp;return ($19|0);
 }
 return (0)|0;
}
function _qspSplitStr($str,$delim,$res) {
 $str = $str|0;
 $delim = $delim|0;
 $res = $res|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $8 = 0, $9 = 0, $allocChars = 0, $bufSize = 0, $count = 0, $curPos = 0, $delimLen = 0, $found = 0;
 var $newStr = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $delim;
 $2 = $res;
 $count = 0;
 $bufSize = 8;
 $3 = $1;
 $4 = (_qspStrLen($3)|0);
 $delimLen = $4;
 $5 = $0;
 $curPos = $5;
 $6 = $0;
 $7 = $1;
 $8 = (_qspStrStr($6,$7)|0);
 $found = $8;
 $9 = $bufSize;
 $10 = $9<<2;
 $11 = (_malloc($10)|0);
 $ret = $11;
 while(1) {
  $12 = $found;
  $13 = ($12|0)!=(0|0);
  if (!($13)) {
   break;
  }
  $14 = $found;
  $15 = $curPos;
  $16 = $14;
  $17 = $15;
  $18 = (($16) - ($17))|0;
  $19 = (($18|0) / 2)&-1;
  $allocChars = $19;
  $20 = $allocChars;
  $21 = (($20) + 1)|0;
  $22 = $21<<1;
  $23 = (_malloc($22)|0);
  $newStr = $23;
  $24 = $newStr;
  $25 = $curPos;
  $26 = $allocChars;
  (_qspStrNCopy($24,$25,$26)|0);
  $27 = $allocChars;
  $28 = $newStr;
  $29 = (($28) + ($27<<1)|0);
  HEAP16[$29>>1] = 0;
  $30 = $count;
  $31 = (($30) + 1)|0;
  $count = $31;
  $32 = $bufSize;
  $33 = ($31|0)>($32|0);
  if ($33) {
   $34 = $bufSize;
   $35 = (($34) + 16)|0;
   $bufSize = $35;
   $36 = $ret;
   $37 = $bufSize;
   $38 = $37<<2;
   $39 = (_realloc($36,$38)|0);
   $ret = $39;
  }
  $40 = $newStr;
  $41 = $count;
  $42 = (($41) - 1)|0;
  $43 = $ret;
  $44 = (($43) + ($42<<2)|0);
  HEAP32[$44>>2] = $40;
  $45 = $found;
  $46 = $delimLen;
  $47 = (($45) + ($46<<1)|0);
  $curPos = $47;
  $48 = $curPos;
  $49 = $1;
  $50 = (_qspStrStr($48,$49)|0);
  $found = $50;
 }
 $51 = $curPos;
 $52 = (_qspStrLen($51)|0);
 $53 = (($52) + 1)|0;
 $54 = $53<<1;
 $55 = (_malloc($54)|0);
 $newStr = $55;
 $56 = $newStr;
 $57 = $curPos;
 (_qspStrCopy($56,$57)|0);
 $58 = $count;
 $59 = (($58) + 1)|0;
 $count = $59;
 $60 = $bufSize;
 $61 = ($59|0)>($60|0);
 if (!($61)) {
  $66 = $newStr;
  $67 = $count;
  $68 = (($67) - 1)|0;
  $69 = $ret;
  $70 = (($69) + ($68<<2)|0);
  HEAP32[$70>>2] = $66;
  $71 = $ret;
  $72 = $2;
  HEAP32[$72>>2] = $71;
  $73 = $count;
  STACKTOP = sp;return ($73|0);
 }
 $62 = $ret;
 $63 = $count;
 $64 = $63<<2;
 $65 = (_realloc($62,$64)|0);
 $ret = $65;
 $66 = $newStr;
 $67 = $count;
 $68 = (($67) - 1)|0;
 $69 = $ret;
 $70 = (($69) + ($68<<2)|0);
 HEAP32[$70>>2] = $66;
 $71 = $ret;
 $72 = $2;
 HEAP32[$72>>2] = $71;
 $73 = $count;
 STACKTOP = sp;return ($73|0);
}
function _qspCopyStrs($dest,$src,$start,$end) {
 $dest = $dest|0;
 $src = $src|0;
 $start = $start|0;
 $end = $end|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $i = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $dest;
 $1 = $src;
 $2 = $start;
 $3 = $end;
 $4 = $3;
 $5 = $2;
 $6 = (($4) - ($5))|0;
 $count = $6;
 $7 = $1;
 $8 = ($7|0)!=(0|0);
 $9 = $count;
 $10 = ($9|0)!=(0);
 $or$cond = $8 & $10;
 if (!($or$cond)) {
  $28 = $0;
  HEAP32[$28>>2] = 0;
  STACKTOP = sp;return;
 }
 $11 = $count;
 $12 = $11<<2;
 $13 = (_malloc($12)|0);
 $14 = $0;
 HEAP32[$14>>2] = $13;
 $i = 0;
 while(1) {
  $15 = $2;
  $16 = $3;
  $17 = ($15|0)<($16|0);
  if (!($17)) {
   break;
  }
  $18 = $0;
  $19 = HEAP32[$18>>2]|0;
  $20 = $i;
  $21 = (($20) + 1)|0;
  $i = $21;
  $22 = (($19) + ($20<<2)|0);
  $23 = $2;
  $24 = (($23) + 1)|0;
  $2 = $24;
  $25 = $1;
  $26 = (($25) + ($23<<2)|0);
  $27 = HEAP32[$26>>2]|0;
  (_qspAddText($22,$27,0,-1,1)|0);
 }
 STACKTOP = sp;return;
}
function _qspFreeStrs($strs,$count) {
 $strs = $strs|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $strs;
 $1 = $count;
 $2 = $0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 while(1) {
  $4 = $1;
  $5 = (($4) + -1)|0;
  $1 = $5;
  $6 = ($5|0)>=(0);
  if (!($6)) {
   break;
  }
  $7 = $1;
  $8 = $0;
  $9 = (($8) + ($7<<2)|0);
  $10 = HEAP32[$9>>2]|0;
  _free($10);
 }
 $11 = $0;
 _free($11);
 STACKTOP = sp;return;
}
function _qspStrToNum($s,$endChar) {
 $s = $s|0;
 $endChar = $endChar|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $isNeg = 0, $num = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $s;
 $2 = $endChar;
 $num = 0;
 $isNeg = 0;
 $3 = $1;
 $4 = (_qspSkipSpaces($3)|0);
 $1 = $4;
 $5 = $1;
 $6 = HEAP16[$5>>1]|0;
 $7 = $6&65535;
 $8 = ($7|0)==(45);
 if ($8) {
  $isNeg = 1;
  $9 = $1;
  $10 = ((($9)) + 2|0);
  $1 = $10;
 } else {
  $11 = $1;
  $12 = HEAP16[$11>>1]|0;
  $13 = $12&65535;
  $14 = ($13|0)==(43);
  if ($14) {
   $15 = $1;
   $16 = ((($15)) + 2|0);
   $1 = $16;
  }
 }
 while(1) {
  $17 = $1;
  $18 = HEAP16[$17>>1]|0;
  $19 = (_qspIsDigit($18)|0);
  $20 = ($19|0)!=(0);
  if (!($20)) {
   break;
  }
  $21 = $num;
  $22 = ($21*10)|0;
  $23 = $1;
  $24 = HEAP16[$23>>1]|0;
  $25 = $24&65535;
  $26 = (($25) - 48)|0;
  $27 = (($22) + ($26))|0;
  $num = $27;
  $28 = $1;
  $29 = ((($28)) + 2|0);
  $1 = $29;
 }
 $30 = $2;
 $31 = ($30|0)!=(0|0);
 if ($31) {
  $32 = $1;
  $33 = (_qspSkipSpaces($32)|0);
  $34 = $2;
  HEAP32[$34>>2] = $33;
  $35 = $2;
  $36 = HEAP32[$35>>2]|0;
  $37 = HEAP16[$36>>1]|0;
  $38 = ($37<<16>>16)!=(0);
  if ($38) {
   $0 = 0;
   $43 = $0;
   STACKTOP = sp;return ($43|0);
  }
 }
 $39 = $isNeg;
 $40 = ($39|0)!=(0);
 $41 = $num;
 if ($40) {
  $42 = (0 - ($41))|0;
  $0 = $42;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 } else {
  $0 = $41;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 return (0)|0;
}
function _qspNumToStr($buf,$val) {
 $buf = $buf|0;
 $val = $val|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $first = 0;
 var $str = 0, $temp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $buf;
 $1 = $val;
 $2 = $0;
 $str = $2;
 $3 = $str;
 $first = $3;
 $4 = $1;
 $5 = ($4|0)<(0);
 if ($5) {
  $6 = $str;
  $7 = ((($6)) + 2|0);
  $str = $7;
  HEAP16[$6>>1] = 45;
  $8 = $1;
  $9 = (0 - ($8))|0;
  $1 = $9;
  $10 = $first;
  $11 = ((($10)) + 2|0);
  $first = $11;
 }
 while(1) {
  $12 = $1;
  $13 = (($12|0) % 10)&-1;
  $14 = (($13) + 48)|0;
  $15 = $14&65535;
  $16 = $str;
  $17 = ((($16)) + 2|0);
  $str = $17;
  HEAP16[$16>>1] = $15;
  $18 = $1;
  $19 = (($18|0) / 10)&-1;
  $1 = $19;
  $20 = $1;
  $21 = ($20|0)>(0);
  if (!($21)) {
   break;
  }
 }
 $22 = $str;
 $23 = ((($22)) + -2|0);
 $str = $23;
 HEAP16[$22>>1] = 0;
 while(1) {
  $24 = $first;
  $25 = $str;
  $26 = ($24>>>0)<($25>>>0);
  if (!($26)) {
   break;
  }
  $27 = $str;
  $28 = HEAP16[$27>>1]|0;
  $temp = $28;
  $29 = $first;
  $30 = HEAP16[$29>>1]|0;
  $31 = $str;
  HEAP16[$31>>1] = $30;
  $32 = $temp;
  $33 = $first;
  HEAP16[$33>>1] = $32;
  $34 = $str;
  $35 = ((($34)) + -2|0);
  $str = $35;
  $36 = $first;
  $37 = ((($36)) + 2|0);
  $first = $37;
 }
 $38 = $0;
 STACKTOP = sp;return ($38|0);
}
function _qspStrPos($txt,$str,$isIsolated) {
 $txt = $txt|0;
 $str = $str|0;
 $isIsolated = $isIsolated|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $c1 = 0, $c2 = 0, $c3 = 0, $isLastDelim = 0, $or$cond = 0, $or$cond3 = 0, $or$cond5 = 0, $pos = 0, $quot = 0, $strLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $txt;
 $2 = $str;
 $3 = $isIsolated;
 $4 = $1;
 $5 = $2;
 $6 = (_qspStrStr($4,$5)|0);
 $pos = $6;
 $7 = $pos;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  $0 = 0;
  $139 = $0;
  STACKTOP = sp;return ($139|0);
 }
 $9 = $3;
 $10 = ($9|0)!=(0);
 if (!($10)) {
  $11 = $1;
  $12 = (_qspStrPBrk($11,444290)|0);
  $13 = ($12|0)!=(0|0);
  if (!($13)) {
   $14 = $pos;
   $0 = $14;
   $139 = $0;
   STACKTOP = sp;return ($139|0);
  }
 }
 $15 = $2;
 $16 = (_qspStrLen($15)|0);
 $strLen = $16;
 $17 = $1;
 $18 = (_qspStrEnd($17)|0);
 $19 = $strLen;
 $20 = (0 - ($19))|0;
 $21 = (($18) + ($20<<1)|0);
 $22 = ((($21)) + 2|0);
 $pos = $22;
 $c3 = 0;
 $c2 = 0;
 $c1 = 0;
 $isLastDelim = 1;
 L10: while(1) {
  $23 = $1;
  $24 = $pos;
  $25 = ($23>>>0)<($24>>>0);
  if (!($25)) {
   label = 42;
   break;
  }
  $26 = $1;
  $27 = HEAP16[$26>>1]|0;
  $28 = (_qspIsInList(444302,$27)|0);
  $29 = ($28|0)!=(0);
  if ($29) {
   $30 = $1;
   $31 = HEAP16[$30>>1]|0;
   $quot = $31;
   while(1) {
    $32 = $1;
    $33 = ((($32)) + 2|0);
    $1 = $33;
    $34 = $pos;
    $35 = ($33>>>0)<($34>>>0);
    if (!($35)) {
     break;
    }
    $36 = $1;
    $37 = HEAP16[$36>>1]|0;
    $38 = $37&65535;
    $39 = $quot;
    $40 = $39&65535;
    $41 = ($38|0)==($40|0);
    if (!($41)) {
     continue;
    }
    $42 = $1;
    $43 = ((($42)) + 2|0);
    $1 = $43;
    $44 = HEAP16[$43>>1]|0;
    $45 = $44&65535;
    $46 = $quot;
    $47 = $46&65535;
    $48 = ($45|0)!=($47|0);
    if ($48) {
     break;
    }
   }
   $49 = $1;
   $50 = $pos;
   $51 = ($49>>>0)>=($50>>>0);
   if ($51) {
    label = 14;
    break;
   }
   $isLastDelim = 1;
  }
  $52 = $1;
  $53 = HEAP16[$52>>1]|0;
  $54 = $53&65535;
  $55 = HEAP16[446274>>1]|0;
  $56 = $55&65535;
  $57 = ($54|0)==($56|0);
  do {
   if ($57) {
    $58 = $c1;
    $59 = (($58) + 1)|0;
    $c1 = $59;
   } else {
    $60 = $1;
    $61 = HEAP16[$60>>1]|0;
    $62 = $61&65535;
    $63 = HEAP16[446278>>1]|0;
    $64 = $63&65535;
    $65 = ($62|0)==($64|0);
    if ($65) {
     $66 = $c1;
     $67 = ($66|0)!=(0);
     if (!($67)) {
      break;
     }
     $68 = $c1;
     $69 = (($68) + -1)|0;
     $c1 = $69;
     break;
    }
    $70 = $1;
    $71 = HEAP16[$70>>1]|0;
    $72 = $71&65535;
    $73 = HEAP16[446370>>1]|0;
    $74 = $73&65535;
    $75 = ($72|0)==($74|0);
    if ($75) {
     $76 = $c2;
     $77 = (($76) + 1)|0;
     $c2 = $77;
     break;
    }
    $78 = $1;
    $79 = HEAP16[$78>>1]|0;
    $80 = $79&65535;
    $81 = HEAP16[444384>>1]|0;
    $82 = $81&65535;
    $83 = ($80|0)==($82|0);
    if ($83) {
     $84 = $c2;
     $85 = ($84|0)!=(0);
     if (!($85)) {
      break;
     }
     $86 = $c2;
     $87 = (($86) + -1)|0;
     $c2 = $87;
     break;
    }
    $88 = $1;
    $89 = HEAP16[$88>>1]|0;
    $90 = $89&65535;
    $91 = HEAP16[444308>>1]|0;
    $92 = $91&65535;
    $93 = ($90|0)==($92|0);
    if ($93) {
     $94 = $c3;
     $95 = (($94) + 1)|0;
     $c3 = $95;
     break;
    }
    $96 = $1;
    $97 = HEAP16[$96>>1]|0;
    $98 = $97&65535;
    $99 = HEAP16[444312>>1]|0;
    $100 = $99&65535;
    $101 = ($98|0)==($100|0);
    $102 = $c3;
    $103 = ($102|0)!=(0);
    $or$cond5 = $101 & $103;
    if ($or$cond5) {
     $104 = $c3;
     $105 = (($104) + -1)|0;
     $c3 = $105;
    }
   }
  } while(0);
  $106 = $c1;
  $107 = ($106|0)!=(0);
  $108 = $c2;
  $109 = ($108|0)!=(0);
  $or$cond = $107 | $109;
  $110 = $c3;
  $111 = ($110|0)!=(0);
  $or$cond3 = $or$cond | $111;
  do {
   if (!($or$cond3)) {
    $112 = $3;
    $113 = ($112|0)!=(0);
    $114 = $1;
    if (!($113)) {
     $132 = $2;
     $133 = $strLen;
     $134 = (_qspStrsNComp($114,$132,$133)|0);
     $135 = ($134|0)!=(0);
     if ($135) {
      break;
     } else {
      label = 40;
      break L10;
     }
    }
    $115 = HEAP16[$114>>1]|0;
    $116 = (_qspIsInList(446312,$115)|0);
    $117 = ($116|0)!=(0);
    if ($117) {
     $isLastDelim = 1;
     break;
    }
    $118 = $isLastDelim;
    $119 = ($118|0)!=(0);
    if ($119) {
     $120 = $strLen;
     $121 = $1;
     $122 = (($121) + ($120<<1)|0);
     $123 = HEAP16[$122>>1]|0;
     $124 = (_qspIsInListEOL(446312,$123)|0);
     $125 = ($124|0)!=(0);
     if ($125) {
      $126 = $1;
      $127 = $2;
      $128 = $strLen;
      $129 = (_qspStrsNComp($126,$127,$128)|0);
      $130 = ($129|0)!=(0);
      if (!($130)) {
       label = 37;
       break L10;
      }
     }
     $isLastDelim = 0;
    }
   }
  } while(0);
  $137 = $1;
  $138 = ((($137)) + 2|0);
  $1 = $138;
 }
 if ((label|0) == 14) {
  $0 = 0;
  $139 = $0;
  STACKTOP = sp;return ($139|0);
 }
 else if ((label|0) == 37) {
  $131 = $1;
  $0 = $131;
  $139 = $0;
  STACKTOP = sp;return ($139|0);
 }
 else if ((label|0) == 40) {
  $136 = $1;
  $0 = $136;
  $139 = $0;
  STACKTOP = sp;return ($139|0);
 }
 else if ((label|0) == 42) {
  $0 = 0;
  $139 = $0;
  STACKTOP = sp;return ($139|0);
 }
 return (0)|0;
}
function _qspReplaceText($txt,$searchTxt,$repTxt) {
 $txt = $txt|0;
 $searchTxt = $searchTxt|0;
 $repTxt = $repTxt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $bufSize = 0, $len = 0, $newTxt = 0, $oldTxtLen = 0, $pos = 0, $repLen = 0, $searchLen = 0, $txtLen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $txt;
 $2 = $searchTxt;
 $3 = $repTxt;
 $4 = $1;
 $5 = $2;
 $6 = (_qspStrStr($4,$5)|0);
 $pos = $6;
 $7 = $pos;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  $9 = $1;
  $10 = (_qspGetNewText($9,-1)|0);
  $0 = $10;
  $61 = $0;
  STACKTOP = sp;return ($61|0);
 }
 $bufSize = 256;
 $oldTxtLen = 0;
 $txtLen = 0;
 $11 = $2;
 $12 = (_qspStrLen($11)|0);
 $searchLen = $12;
 $13 = $3;
 $14 = (_qspStrLen($13)|0);
 $repLen = $14;
 $15 = $bufSize;
 $16 = $15<<1;
 $17 = (_malloc($16)|0);
 $newTxt = $17;
 while(1) {
  $18 = $pos;
  $19 = $1;
  $20 = $18;
  $21 = $19;
  $22 = (($20) - ($21))|0;
  $23 = (($22|0) / 2)&-1;
  $len = $23;
  $24 = $len;
  $25 = $repLen;
  $26 = (($24) + ($25))|0;
  $27 = $txtLen;
  $28 = (($27) + ($26))|0;
  $txtLen = $28;
  $29 = $bufSize;
  $30 = ($28|0)>=($29|0);
  if ($30) {
   $31 = $txtLen;
   $32 = (($31) + 128)|0;
   $bufSize = $32;
   $33 = $newTxt;
   $34 = $bufSize;
   $35 = $34<<1;
   $36 = (_realloc($33,$35)|0);
   $newTxt = $36;
  }
  $37 = $newTxt;
  $38 = $oldTxtLen;
  $39 = (($37) + ($38<<1)|0);
  $40 = $1;
  $41 = $len;
  (_qspStrNCopy($39,$40,$41)|0);
  $42 = $newTxt;
  $43 = $oldTxtLen;
  $44 = (($42) + ($43<<1)|0);
  $45 = $len;
  $46 = (($44) + ($45<<1)|0);
  $47 = $3;
  (_qspStrCopy($46,$47)|0);
  $48 = $txtLen;
  $oldTxtLen = $48;
  $49 = $pos;
  $50 = $searchLen;
  $51 = (($49) + ($50<<1)|0);
  $1 = $51;
  $52 = $1;
  $53 = $2;
  $54 = (_qspStrStr($52,$53)|0);
  $pos = $54;
  $55 = $pos;
  $56 = ($55|0)!=(0|0);
  if (!($56)) {
   break;
  }
 }
 $57 = $newTxt;
 $58 = $1;
 $59 = $txtLen;
 $60 = (_qspGetAddText($57,$58,$59,-1)|0);
 $0 = $60;
 $61 = $0;
 STACKTOP = sp;return ($61|0);
}
function _qspFormatText($txt,$canReturnSelf) {
 $txt = $txt|0;
 $canReturnSelf = $canReturnSelf|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $bufSize = 0, $lPos = 0, $len = 0, $newTxt = 0, $oldRefreshCount = 0, $oldTxtLen = 0, $or$cond = 0, $rPos = 0, $txtLen = 0;
 var $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $val = sp + 40|0;
 $3 = sp;
 $1 = $txt;
 $2 = $canReturnSelf;
 $4 = (_qspGetVarNumValue(444316)|0);
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = $2;
  $7 = ($6|0)!=(0);
  $8 = $1;
  if ($7) {
   $0 = $8;
   $90 = $0;
   STACKTOP = sp;return ($90|0);
  } else {
   $9 = (_qspGetNewText($8,-1)|0);
   $0 = $9;
   $90 = $0;
   STACKTOP = sp;return ($90|0);
  }
 }
 $10 = $1;
 $11 = (_qspStrStr($10,444342)|0);
 $lPos = $11;
 $12 = $lPos;
 $13 = ($12|0)!=(0|0);
 if (!($13)) {
  $14 = $2;
  $15 = ($14|0)!=(0);
  $16 = $1;
  if ($15) {
   $0 = $16;
   $90 = $0;
   STACKTOP = sp;return ($90|0);
  } else {
   $17 = (_qspGetNewText($16,-1)|0);
   $0 = $17;
   $90 = $0;
   STACKTOP = sp;return ($90|0);
  }
 }
 $bufSize = 256;
 $18 = $bufSize;
 $19 = $18<<1;
 $20 = (_malloc($19)|0);
 $newTxt = $20;
 $oldTxtLen = 0;
 $txtLen = 0;
 $21 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $21;
 while(1) {
  $22 = $lPos;
  $23 = $1;
  $24 = $22;
  $25 = $23;
  $26 = (($24) - ($25))|0;
  $27 = (($26|0) / 2)&-1;
  $len = $27;
  $28 = $len;
  $29 = $txtLen;
  $30 = (($29) + ($28))|0;
  $txtLen = $30;
  $31 = $bufSize;
  $32 = ($30|0)>=($31|0);
  if ($32) {
   $33 = $txtLen;
   $34 = (($33) + 128)|0;
   $bufSize = $34;
   $35 = $newTxt;
   $36 = $bufSize;
   $37 = $36<<1;
   $38 = (_realloc($35,$37)|0);
   $newTxt = $38;
  }
  $39 = $newTxt;
  $40 = $oldTxtLen;
  $41 = (($39) + ($40<<1)|0);
  $42 = $1;
  $43 = $len;
  (_qspStrNCopy($41,$42,$43)|0);
  $44 = $txtLen;
  $oldTxtLen = $44;
  $45 = $lPos;
  $46 = ((($45)) + 4|0);
  $1 = $46;
  $47 = $1;
  $48 = (_qspStrPos($47,444348,0)|0);
  $rPos = $48;
  $49 = $rPos;
  $50 = ($49|0)!=(0|0);
  if (!($50)) {
   label = 13;
   break;
  }
  $52 = $rPos;
  HEAP16[$52>>1] = 0;
  $53 = $1;
  _qspExprValue($3,$53);
  ;HEAP32[$val>>2]=HEAP32[$3>>2]|0;HEAP32[$val+4>>2]=HEAP32[$3+4>>2]|0;
  $54 = HEAP16[444348>>1]|0;
  $55 = $rPos;
  HEAP16[$55>>1] = $54;
  $56 = HEAP32[320504>>2]|0;
  $57 = $oldRefreshCount;
  $58 = ($56|0)!=($57|0);
  $59 = HEAP32[320460>>2]|0;
  $60 = ($59|0)!=(0);
  $or$cond = $58 | $60;
  if ($or$cond) {
   label = 15;
   break;
  }
  (_qspConvertVariantTo($val,1)|0);
  $62 = HEAP32[$val>>2]|0;
  $63 = (_qspStrLen($62)|0);
  $64 = $txtLen;
  $65 = (($64) + ($63))|0;
  $txtLen = $65;
  $66 = $bufSize;
  $67 = ($65|0)>=($66|0);
  if ($67) {
   $68 = $txtLen;
   $69 = (($68) + 128)|0;
   $bufSize = $69;
   $70 = $newTxt;
   $71 = $bufSize;
   $72 = $71<<1;
   $73 = (_realloc($70,$72)|0);
   $newTxt = $73;
  }
  $74 = $newTxt;
  $75 = $oldTxtLen;
  $76 = (($74) + ($75<<1)|0);
  $77 = HEAP32[$val>>2]|0;
  (_qspStrCopy($76,$77)|0);
  $78 = HEAP32[$val>>2]|0;
  _free($78);
  $79 = $txtLen;
  $oldTxtLen = $79;
  $80 = $rPos;
  $81 = ((($80)) + 4|0);
  $1 = $81;
  $82 = $1;
  $83 = (_qspStrStr($82,444342)|0);
  $lPos = $83;
  $84 = $lPos;
  $85 = ($84|0)!=(0|0);
  if (!($85)) {
   label = 19;
   break;
  }
 }
 if ((label|0) == 13) {
  _qspSetError(116);
  $51 = $newTxt;
  _free($51);
  $0 = 0;
  $90 = $0;
  STACKTOP = sp;return ($90|0);
 }
 else if ((label|0) == 15) {
  $61 = $newTxt;
  _free($61);
  $0 = 0;
  $90 = $0;
  STACKTOP = sp;return ($90|0);
 }
 else if ((label|0) == 19) {
  $86 = $newTxt;
  $87 = $1;
  $88 = $txtLen;
  $89 = (_qspGetAddText($86,$87,$88,-1)|0);
  $0 = $89;
  $90 = $0;
  STACKTOP = sp;return ($90|0);
 }
 return (0)|0;
}
function _qspToWLower($c) {
 $c = $c|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $k = 0;
 var $k1 = 0, $k2 = 0, $or$cond = 0, $or$cond11 = 0, $or$cond13 = 0, $or$cond15 = 0, $or$cond17 = 0, $or$cond19 = 0, $or$cond21 = 0, $or$cond23 = 0, $or$cond25 = 0, $or$cond27 = 0, $or$cond29 = 0, $or$cond3 = 0, $or$cond31 = 0, $or$cond33 = 0, $or$cond35 = 0, $or$cond37 = 0, $or$cond39 = 0, $or$cond41 = 0;
 var $or$cond43 = 0, $or$cond45 = 0, $or$cond47 = 0, $or$cond49 = 0, $or$cond5 = 0, $or$cond51 = 0, $or$cond53 = 0, $or$cond55 = 0, $or$cond57 = 0, $or$cond59 = 0, $or$cond61 = 0, $or$cond63 = 0, $or$cond65 = 0, $or$cond67 = 0, $or$cond69 = 0, $or$cond7 = 0, $or$cond71 = 0, $or$cond73 = 0, $or$cond75 = 0, $or$cond77 = 0;
 var $or$cond79 = 0, $or$cond81 = 0, $or$cond9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $c;
 $2 = $1;
 $3 = ($2|0)<(256);
 $4 = $1;
 L1: do {
  if ($3) {
   $5 = ($4|0)>=(65);
   $6 = $1;
   $7 = ($6|0)<=(90);
   $or$cond = $5 & $7;
   if (!($or$cond)) {
    $8 = $1;
    $9 = ($8|0)>=(192);
    $10 = $1;
    $11 = ($10|0)<=(222);
    $or$cond3 = $9 & $11;
    if (!($or$cond3)) {
     $14 = $1;
     $15 = ($14|0)==(181);
     if ($15) {
      $0 = 956;
      break;
     } else {
      $16 = $1;
      $0 = $16;
      break;
     }
    }
   }
   $12 = $1;
   $13 = (($12) + 32)|0;
   $0 = $13;
  } else {
   $17 = ($4|0)<(768);
   $18 = $1;
   do {
    if ($17) {
     $19 = ($18|0)>=(256);
     $20 = $1;
     $21 = ($20|0)<=(302);
     $or$cond5 = $19 & $21;
     if (!($or$cond5)) {
      $22 = $1;
      $23 = ($22|0)>=(306);
      $24 = $1;
      $25 = ($24|0)<=(310);
      $or$cond7 = $23 & $25;
      if (!($or$cond7)) {
       $26 = $1;
       $27 = ($26|0)>=(330);
       $28 = $1;
       $29 = ($28|0)<=(374);
       $or$cond9 = $27 & $29;
       if (!($or$cond9)) {
        $30 = $1;
        $31 = ($30|0)>=(478);
        $32 = $1;
        $33 = ($32|0)<=(494);
        $or$cond11 = $31 & $33;
        if (!($or$cond11)) {
         $34 = $1;
         $35 = ($34|0)>=(504);
         $36 = $1;
         $37 = ($36|0)<=(542);
         $or$cond13 = $35 & $37;
         if (!($or$cond13)) {
          $38 = $1;
          $39 = ($38|0)>=(546);
          $40 = $1;
          $41 = ($40|0)<=(562);
          $or$cond15 = $39 & $41;
          if (!($or$cond15)) {
           $47 = $1;
           $48 = ($47|0)>=(313);
           $49 = $1;
           $50 = ($49|0)<=(327);
           $or$cond17 = $48 & $50;
           if (!($or$cond17)) {
            $51 = $1;
            $52 = ($51|0)>=(461);
            $53 = $1;
            $54 = ($53|0)<=(37339);
            $or$cond19 = $52 & $54;
            if (!($or$cond19)) {
             $60 = $1;
             $61 = ($60|0)>=(376);
             $62 = $1;
             $63 = ($62|0)<=(503);
             $or$cond21 = $61 & $63;
             if ($or$cond21) {
              $64 = $1;
              do {
               switch ($64|0) {
               case 376:  {
                $k = 255;
                break;
               }
               case 500: case 498: case 475: case 473: case 471: case 469: case 467: case 465: case 463: case 461: case 459: case 456: case 453: case 444: case 440: case 437: case 435: case 431: case 428: case 423: case 420: case 418: case 416: case 408: case 401: case 395: case 391: case 388: case 386: case 381: case 379: case 377:  {
                $65 = $1;
                $66 = (($65) + 1)|0;
                $k = $66;
                break;
               }
               case 383:  {
                $k = 115;
                break;
               }
               case 385:  {
                $k = 595;
                break;
               }
               case 390:  {
                $k = 596;
                break;
               }
               case 393:  {
                $k = 598;
                break;
               }
               case 394:  {
                $k = 599;
                break;
               }
               case 398:  {
                $k = 477;
                break;
               }
               case 399:  {
                $k = 601;
                break;
               }
               case 400:  {
                $k = 603;
                break;
               }
               case 403:  {
                $k = 608;
                break;
               }
               case 404:  {
                $k = 611;
                break;
               }
               case 406:  {
                $k = 617;
                break;
               }
               case 407:  {
                $k = 616;
                break;
               }
               case 412:  {
                $k = 623;
                break;
               }
               case 413:  {
                $k = 626;
                break;
               }
               case 415:  {
                $k = 629;
                break;
               }
               case 422:  {
                $k = 640;
                break;
               }
               case 425:  {
                $k = 643;
                break;
               }
               case 430:  {
                $k = 648;
                break;
               }
               case 433:  {
                $k = 650;
                break;
               }
               case 434:  {
                $k = 651;
                break;
               }
               case 439:  {
                $k = 658;
                break;
               }
               case 497: case 458: case 455: case 452:  {
                $67 = $1;
                $68 = (($67) + 2)|0;
                $k = $68;
                break;
               }
               case 502:  {
                $k = 405;
                break;
               }
               case 503:  {
                $k = 447;
                break;
               }
               default: {
                $k = 0;
               }
               }
              } while(0);
              $69 = $k;
              $70 = ($69|0)!=(0);
              if ($70) {
               $71 = $k;
               $0 = $71;
               break L1;
              }
             }
             $72 = $1;
             $73 = ($72|0)==(544);
             if (!($73)) {
              break;
             }
             $0 = 414;
             break L1;
            }
           }
           $55 = $1;
           $56 = $55 & 1;
           $57 = ($56|0)!=(0);
           $58 = $1;
           if ($57) {
            $59 = (($58) + 1)|0;
            $0 = $59;
            break L1;
           } else {
            $0 = $58;
            break L1;
           }
          }
         }
        }
       }
      }
     }
     $42 = $1;
     $43 = $42 & 1;
     $44 = ($43|0)!=(0);
     $45 = $1;
     if ($44) {
      $0 = $45;
      break L1;
     } else {
      $46 = (($45) + 1)|0;
      $0 = $46;
      break L1;
     }
    } else {
     $74 = ($18|0)<(1024);
     $75 = $1;
     if ($74) {
      $76 = ($75|0)>=(913);
      $77 = $1;
      $78 = ($77|0)<=(939);
      $or$cond23 = $76 & $78;
      $79 = $1;
      $80 = ($79|0)!=(930);
      $or$cond25 = $or$cond23 & $80;
      $81 = $1;
      if ($or$cond25) {
       $82 = (($81) + 32)|0;
       $0 = $82;
       break L1;
      }
      $83 = ($81|0)>=(984);
      $84 = $1;
      $85 = ($84|0)<=(1006);
      $or$cond27 = $83 & $85;
      if ($or$cond27) {
       $86 = $1;
       $87 = $86 & 1;
       $88 = ($87|0)!=(0);
       if (!($88)) {
        $89 = $1;
        $90 = (($89) + 1)|0;
        $0 = $90;
        break L1;
       }
      }
      $91 = $1;
      $92 = ($91|0)>=(902);
      $93 = $1;
      $94 = ($93|0)<=(1013);
      $or$cond29 = $92 & $94;
      if ($or$cond29) {
       $95 = $1;
       do {
        switch ($95|0) {
        case 902:  {
         $k1 = 940;
         break;
        }
        case 904:  {
         $k1 = 941;
         break;
        }
        case 905:  {
         $k1 = 942;
         break;
        }
        case 906:  {
         $k1 = 943;
         break;
        }
        case 908:  {
         $k1 = 972;
         break;
        }
        case 910:  {
         $k1 = 973;
         break;
        }
        case 911:  {
         $k1 = 911;
         break;
        }
        case 962:  {
         $k1 = 963;
         break;
        }
        case 976:  {
         $k1 = 946;
         break;
        }
        case 977:  {
         $k1 = 952;
         break;
        }
        case 981:  {
         $k1 = 966;
         break;
        }
        case 982:  {
         $k1 = 960;
         break;
        }
        case 1008:  {
         $k1 = 954;
         break;
        }
        case 1009:  {
         $k1 = 961;
         break;
        }
        case 1010:  {
         $k1 = 963;
         break;
        }
        case 1012:  {
         $k1 = 952;
         break;
        }
        case 1013:  {
         $k1 = 949;
         break;
        }
        default: {
         $k1 = 0;
        }
        }
       } while(0);
       $96 = $k1;
       $97 = ($96|0)!=(0);
       if ($97) {
        $98 = $k1;
        $0 = $98;
        break L1;
       }
      }
      $99 = $1;
      $100 = ($99|0)==(837);
      if (!($100)) {
       break;
      }
      $0 = 953;
      break L1;
     }
     $101 = ($75|0)<(1280);
     $102 = $1;
     if ($101) {
      $103 = ($102|0)>=(1024);
      $104 = $1;
      $105 = ($104|0)<=(1039);
      $or$cond31 = $103 & $105;
      $106 = $1;
      if ($or$cond31) {
       $107 = (($106) + 80)|0;
       $0 = $107;
       break L1;
      }
      $108 = ($106|0)>=(1040);
      $109 = $1;
      $110 = ($109|0)<=(1071);
      $or$cond33 = $108 & $110;
      $111 = $1;
      if ($or$cond33) {
       $112 = (($111) + 32)|0;
       $0 = $112;
       break L1;
      }
      $113 = ($111|0)>=(1120);
      $114 = $1;
      $115 = ($114|0)<=(1152);
      $or$cond35 = $113 & $115;
      if (!($or$cond35)) {
       $116 = $1;
       $117 = ($116|0)>=(1162);
       $118 = $1;
       $119 = ($118|0)<=(1214);
       $or$cond37 = $117 & $119;
       if (!($or$cond37)) {
        $120 = $1;
        $121 = ($120|0)>=(1232);
        $122 = $1;
        $123 = ($122|0)<=(1268);
        $or$cond39 = $121 & $123;
        $124 = $1;
        $125 = ($124|0)==(1272);
        $or$cond41 = $or$cond39 | $125;
        if (!($or$cond41)) {
         $131 = $1;
         $132 = ($131|0)>=(1217);
         $133 = $1;
         $134 = ($133|0)<=(1229);
         $or$cond43 = $132 & $134;
         if (!($or$cond43)) {
          break;
         }
         $135 = $1;
         $136 = $135 & 1;
         $137 = ($136|0)!=(0);
         $138 = $1;
         if ($137) {
          $139 = (($138) + 1)|0;
          $0 = $139;
          break L1;
         } else {
          $0 = $138;
          break L1;
         }
        }
       }
      }
      $126 = $1;
      $127 = $126 & 1;
      $128 = ($127|0)!=(0);
      $129 = $1;
      if ($128) {
       $0 = $129;
       break L1;
      } else {
       $130 = (($129) + 1)|0;
       $0 = $130;
       break L1;
      }
     }
     $140 = ($102|0)<(7936);
     $141 = $1;
     if ($140) {
      $142 = ($141|0)>=(1280);
      $143 = $1;
      $144 = ($143|0)<=(1294);
      $or$cond45 = $142 & $144;
      if (!($or$cond45)) {
       $145 = $1;
       $146 = ($145|0)>=(7680);
       $147 = $1;
       $148 = ($147|0)<=(7828);
       $or$cond47 = $146 & $148;
       if (!($or$cond47)) {
        $149 = $1;
        $150 = ($149|0)>=(7840);
        $151 = $1;
        $152 = ($151|0)<=(7928);
        $or$cond49 = $150 & $152;
        if (!($or$cond49)) {
         $158 = $1;
         $159 = ($158|0)>=(1329);
         $160 = $1;
         $161 = ($160|0)<=(1366);
         $or$cond51 = $159 & $161;
         $162 = $1;
         if ($or$cond51) {
          $163 = (($162) + 48)|0;
          $0 = $163;
          break L1;
         }
         $164 = ($162|0)==(7835);
         if (!($164)) {
          break;
         }
         $0 = 7777;
         break L1;
        }
       }
      }
      $153 = $1;
      $154 = $153 & 1;
      $155 = ($154|0)!=(0);
      $156 = $1;
      if ($155) {
       $0 = $156;
       break L1;
      } else {
       $157 = (($156) + 1)|0;
       $0 = $157;
       break L1;
      }
     }
     $165 = ($141|0)<(8192);
     $166 = $1;
     if (!($165)) {
      $232 = ($166|0)>=(8544);
      $233 = $1;
      $234 = ($233|0)<=(8559);
      $or$cond75 = $232 & $234;
      $235 = $1;
      if ($or$cond75) {
       $236 = (($235) + 16)|0;
       $0 = $236;
       break L1;
      }
      $237 = ($235|0)>=(9398);
      $238 = $1;
      $239 = ($238|0)<=(9423);
      $or$cond77 = $237 & $239;
      $240 = $1;
      if ($or$cond77) {
       $241 = (($240) + 26)|0;
       $0 = $241;
       break L1;
      }
      $242 = ($240|0)>=(65313);
      $243 = $1;
      $244 = ($243|0)<=(65338);
      $or$cond79 = $242 & $244;
      $245 = $1;
      if ($or$cond79) {
       $246 = (($245) + 32)|0;
       $0 = $246;
       break L1;
      }
      $247 = ($245|0)>=(66560);
      $248 = $1;
      $249 = ($248|0)<=(66597);
      $or$cond81 = $247 & $249;
      $250 = $1;
      if ($or$cond81) {
       $251 = (($250) + 40)|0;
       $0 = $251;
       break L1;
      }
      $252 = ($250|0)==(8486);
      if ($252) {
       $0 = 969;
       break L1;
      }
      $253 = $1;
      $254 = ($253|0)==(8490);
      if ($254) {
       $0 = 107;
       break L1;
      }
      $255 = $1;
      $256 = ($255|0)==(8491);
      if (!($256)) {
       break;
      }
      $0 = 229;
      break L1;
     }
     $167 = ($166|0)>=(7944);
     $168 = $1;
     $169 = ($168|0)<=(7951);
     $or$cond53 = $167 & $169;
     if (!($or$cond53)) {
      $170 = $1;
      $171 = ($170|0)>=(7960);
      $172 = $1;
      $173 = ($172|0)<=(7965);
      $or$cond55 = $171 & $173;
      if (!($or$cond55)) {
       $174 = $1;
       $175 = ($174|0)>=(7976);
       $176 = $1;
       $177 = ($176|0)<=(7983);
       $or$cond57 = $175 & $177;
       if (!($or$cond57)) {
        $178 = $1;
        $179 = ($178|0)>=(7992);
        $180 = $1;
        $181 = ($180|0)<=(7999);
        $or$cond59 = $179 & $181;
        if (!($or$cond59)) {
         $182 = $1;
         $183 = ($182|0)>=(8008);
         $184 = $1;
         $185 = ($184|0)<=(8013);
         $or$cond61 = $183 & $185;
         if (!($or$cond61)) {
          $186 = $1;
          $187 = ($186|0)>=(8040);
          $188 = $1;
          $189 = ($188|0)<=(8047);
          $or$cond63 = $187 & $189;
          if (!($or$cond63)) {
           $190 = $1;
           $191 = ($190|0)>=(8072);
           $192 = $1;
           $193 = ($192|0)<=(8079);
           $or$cond65 = $191 & $193;
           if (!($or$cond65)) {
            $194 = $1;
            $195 = ($194|0)>=(8088);
            $196 = $1;
            $197 = ($196|0)<=(8095);
            $or$cond67 = $195 & $197;
            if (!($or$cond67)) {
             $198 = $1;
             $199 = ($198|0)>=(8104);
             $200 = $1;
             $201 = ($200|0)<=(8111);
             $or$cond69 = $199 & $201;
             if (!($or$cond69)) {
              $204 = $1;
              $205 = ($204|0)>=(8025);
              $206 = $1;
              $207 = ($206|0)<=(8031);
              $or$cond71 = $205 & $207;
              $208 = $1;
              if ($or$cond71) {
               $209 = $208 & 1;
               $210 = ($209|0)!=(0);
               $211 = $1;
               if ($210) {
                $212 = (($211) - 8)|0;
                $0 = $212;
                break L1;
               } else {
                $0 = $211;
                break L1;
               }
              }
              $213 = ($208|0)>=(8120);
              $214 = $1;
              $215 = ($214|0)<=(8188);
              $or$cond73 = $213 & $215;
              if (!($or$cond73)) {
               break;
              }
              $216 = $1;
              do {
               switch ($216|0) {
               case 8169: case 8168: case 8153: case 8152: case 8121: case 8120:  {
                $217 = $1;
                $218 = (($217) - 8)|0;
                $k2 = $218;
                break;
               }
               case 8123: case 8122:  {
                $219 = $1;
                $220 = (($219) - 74)|0;
                $k2 = $220;
                break;
               }
               case 8124:  {
                $k2 = 8115;
                break;
               }
               case 8126:  {
                $k2 = 953;
                break;
               }
               case 8139: case 8138: case 8137: case 8136:  {
                $221 = $1;
                $222 = (($221) - 86)|0;
                $k2 = $222;
                break;
               }
               case 8140:  {
                $k2 = 8131;
                break;
               }
               case 8155: case 8154:  {
                $223 = $1;
                $224 = (($223) - 100)|0;
                $k2 = $224;
                break;
               }
               case 8171: case 8170:  {
                $225 = $1;
                $226 = (($225) - 112)|0;
                $k2 = $226;
                break;
               }
               case 8172:  {
                $k2 = 8165;
                break;
               }
               case 8187: case 8186:  {
                $227 = $1;
                $228 = (($227) - 126)|0;
                $k2 = $228;
                break;
               }
               case 8188:  {
                $k2 = 8179;
                break;
               }
               default: {
                $k2 = 0;
               }
               }
              } while(0);
              $229 = $k2;
              $230 = ($229|0)!=(0);
              if (!($230)) {
               break;
              }
              $231 = $k2;
              $0 = $231;
              break L1;
             }
            }
           }
          }
         }
        }
       }
      }
     }
     $202 = $1;
     $203 = (($202) - 8)|0;
     $0 = $203;
     break L1;
    }
   } while(0);
   $257 = $1;
   $0 = $257;
  }
 } while(0);
 $258 = $0;
 STACKTOP = sp;return ($258|0);
}
function _qspClearVars($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $var = 12648;
 $i = 0;
 while(1) {
  $1 = $i;
  $2 = ($1|0)<(12800);
  if (!($2)) {
   break;
  }
  $3 = $0;
  $4 = ($3|0)!=(0);
  $5 = $var;
  if ($4) {
   _qspInitVarData($5);
  } else {
   $6 = HEAP32[$5>>2]|0;
   $7 = ($6|0)!=(0|0);
   if ($7) {
    $8 = $var;
    $9 = HEAP32[$8>>2]|0;
    _free($9);
   }
   $10 = $var;
   _qspEmptyVar($10);
  }
  $11 = $var;
  HEAP32[$11>>2] = 0;
  $12 = $var;
  $13 = ((($12)) + 24|0);
  $var = $13;
  $14 = $i;
  $15 = (($14) + 1)|0;
  $i = $15;
 }
 STACKTOP = sp;return;
}
function _qspEmptyVar($var) {
 $var = $var|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $var;
 $1 = $0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = $0;
  $6 = ((($5)) + 8|0);
  $7 = HEAP32[$6>>2]|0;
  $count = $7;
  while(1) {
   $8 = $count;
   $9 = (($8) + -1)|0;
   $count = $9;
   $10 = ($9|0)>=(0);
   if (!($10)) {
    break;
   }
   $11 = $count;
   $12 = $0;
   $13 = ((($12)) + 4|0);
   $14 = HEAP32[$13>>2]|0;
   $15 = (($14) + ($11<<3)|0);
   $16 = ((($15)) + 4|0);
   $17 = HEAP32[$16>>2]|0;
   $18 = ($17|0)!=(0|0);
   if (!($18)) {
    continue;
   }
   $19 = $count;
   $20 = $0;
   $21 = ((($20)) + 4|0);
   $22 = HEAP32[$21>>2]|0;
   $23 = (($22) + ($19<<3)|0);
   $24 = ((($23)) + 4|0);
   $25 = HEAP32[$24>>2]|0;
   _free($25);
  }
  $26 = $0;
  $27 = ((($26)) + 4|0);
  $28 = HEAP32[$27>>2]|0;
  _free($28);
 }
 $29 = $0;
 $30 = ((($29)) + 12|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = ($31|0)!=(0|0);
 if (!($32)) {
  $49 = $0;
  _qspInitVarData($49);
  STACKTOP = sp;return;
 }
 $33 = $0;
 $34 = ((($33)) + 16|0);
 $35 = HEAP32[$34>>2]|0;
 $count = $35;
 while(1) {
  $36 = $count;
  $37 = (($36) + -1)|0;
  $count = $37;
  $38 = ($37|0)>=(0);
  if (!($38)) {
   break;
  }
  $39 = $count;
  $40 = $0;
  $41 = ((($40)) + 12|0);
  $42 = HEAP32[$41>>2]|0;
  $43 = (($42) + ($39<<3)|0);
  $44 = ((($43)) + 4|0);
  $45 = HEAP32[$44>>2]|0;
  _free($45);
 }
 $46 = $0;
 $47 = ((($46)) + 12|0);
 $48 = HEAP32[$47>>2]|0;
 _free($48);
 $49 = $0;
 _qspInitVarData($49);
 STACKTOP = sp;return;
}
function _qspVarReference($name,$isCreate) {
 $name = $name|0;
 $isCreate = $isCreate|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $7 = 0, $8 = 0, $9 = 0, $bCode = 0, $i = 0, $uName = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = $isCreate;
 $3 = $1;
 $4 = HEAP16[$3>>1]|0;
 $5 = $4&65535;
 $6 = HEAP16[446356>>1]|0;
 $7 = $6&65535;
 $8 = ($5|0)==($7|0);
 if ($8) {
  $9 = $1;
  $10 = ((($9)) + 2|0);
  $1 = $10;
 }
 $11 = $1;
 $12 = HEAP16[$11>>1]|0;
 $13 = ($12<<16>>16)!=(0);
 if ($13) {
  $14 = $1;
  $15 = HEAP16[$14>>1]|0;
  $16 = (_qspIsDigit($15)|0);
  $17 = ($16|0)!=(0);
  if (!($17)) {
   $18 = $1;
   $19 = (_qspStrPBrk($18,446312)|0);
   $20 = ($19|0)!=(0|0);
   if (!($20)) {
    $21 = $1;
    $22 = (_qspGetNewText($21,-1)|0);
    $uName = $22;
    _qspUpperStr($22);
    $bCode = 0;
    $i = 0;
    while(1) {
     $23 = $i;
     $24 = $uName;
     $25 = (($24) + ($23<<1)|0);
     $26 = HEAP16[$25>>1]|0;
     $27 = ($26<<16>>16)!=(0);
     $28 = $bCode;
     $29 = $28&255;
     if (!($27)) {
      break;
     }
     $30 = $i;
     $31 = $uName;
     $32 = (($31) + ($30<<1)|0);
     $33 = HEAP16[$32>>1]|0;
     $34 = $33&255;
     $35 = $34&255;
     $36 = $29 ^ $35;
     $37 = (447992 + ($36)|0);
     $38 = HEAP8[$37>>0]|0;
     $bCode = $38;
     $39 = $i;
     $40 = (($39) + 1)|0;
     $i = $40;
    }
    $41 = ($29*50)|0;
    $42 = (12648 + (($41*24)|0)|0);
    $var = $42;
    $i = 0;
    while(1) {
     $43 = $i;
     $44 = ($43|0)<(50);
     if (!($44)) {
      label = 20;
      break;
     }
     $45 = $var;
     $46 = HEAP32[$45>>2]|0;
     $47 = ($46|0)!=(0|0);
     if (!($47)) {
      label = 13;
      break;
     }
     $53 = $var;
     $54 = HEAP32[$53>>2]|0;
     $55 = $uName;
     $56 = (_qspStrsComp($54,$55)|0);
     $57 = ($56|0)!=(0);
     if (!($57)) {
      label = 18;
      break;
     }
     $60 = $var;
     $61 = ((($60)) + 24|0);
     $var = $61;
     $62 = $i;
     $63 = (($62) + 1)|0;
     $i = $63;
    }
    if ((label|0) == 13) {
     $48 = $2;
     $49 = ($48|0)!=(0);
     $50 = $uName;
     if ($49) {
      $51 = $var;
      HEAP32[$51>>2] = $50;
     } else {
      _free($50);
     }
     $52 = $var;
     $0 = $52;
     $65 = $0;
     STACKTOP = sp;return ($65|0);
    }
    else if ((label|0) == 18) {
     $58 = $uName;
     _free($58);
     $59 = $var;
     $0 = $59;
     $65 = $0;
     STACKTOP = sp;return ($65|0);
    }
    else if ((label|0) == 20) {
     $64 = $uName;
     _free($64);
     _qspSetError(123);
     $0 = 0;
     $65 = $0;
     STACKTOP = sp;return ($65|0);
    }
   }
  }
 }
 _qspSetError(114);
 $0 = 0;
 $65 = $0;
 STACKTOP = sp;return ($65|0);
}
function _qspVarReferenceWithType($name,$isCreate,$isString) {
 $name = $name|0;
 $isCreate = $isCreate|0;
 $isString = $isString|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $var = 0, $varName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $isCreate;
 $2 = $isString;
 $3 = $0;
 $4 = (_qspDelSpcCanRetSelf($3)|0);
 $varName = $4;
 $5 = $2;
 $6 = ($5|0)!=(0|0);
 if ($6) {
  $7 = $varName;
  $8 = HEAP16[$7>>1]|0;
  $9 = $8&65535;
  $10 = HEAP16[446356>>1]|0;
  $11 = $10&65535;
  $12 = ($9|0)==($11|0);
  $13 = $12&1;
  $14 = $2;
  HEAP32[$14>>2] = $13;
 }
 $15 = $varName;
 $16 = $1;
 $17 = (_qspVarReference($15,$16)|0);
 $var = $17;
 $18 = $varName;
 $19 = $0;
 $20 = ($18|0)!=($19|0);
 if (!($20)) {
  $22 = $var;
  STACKTOP = sp;return ($22|0);
 }
 $21 = $varName;
 _free($21);
 $22 = $var;
 STACKTOP = sp;return ($22|0);
}
function _qspSetVarValueByReference($var,$ind,$val) {
 $var = $var|0;
 $ind = $ind|0;
 $val = $val|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $oldCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $var;
 $1 = $ind;
 $2 = $val;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $oldCount = $5;
 $6 = $1;
 $7 = $oldCount;
 $8 = ($6|0)>=($7|0);
 L1: do {
  if ($8) {
   $9 = $1;
   $10 = (($9) + 1)|0;
   $11 = $0;
   $12 = ((($11)) + 8|0);
   HEAP32[$12>>2] = $10;
   $count = $10;
   $13 = $0;
   $14 = ((($13)) + 4|0);
   $15 = HEAP32[$14>>2]|0;
   $16 = $count;
   $17 = $16<<3;
   $18 = (_realloc($15,$17)|0);
   $19 = $0;
   $20 = ((($19)) + 4|0);
   HEAP32[$20>>2] = $18;
   while(1) {
    $21 = $oldCount;
    $22 = $count;
    $23 = ($21|0)<($22|0);
    if (!($23)) {
     break L1;
    }
    $24 = $oldCount;
    $25 = $0;
    $26 = ((($25)) + 4|0);
    $27 = HEAP32[$26>>2]|0;
    $28 = (($27) + ($24<<3)|0);
    HEAP32[$28>>2] = 0;
    $29 = $oldCount;
    $30 = $0;
    $31 = ((($30)) + 4|0);
    $32 = HEAP32[$31>>2]|0;
    $33 = (($32) + ($29<<3)|0);
    $34 = ((($33)) + 4|0);
    HEAP32[$34>>2] = 0;
    $35 = $oldCount;
    $36 = (($35) + 1)|0;
    $oldCount = $36;
   }
  }
 } while(0);
 $37 = $1;
 $38 = ($37|0)>=(0);
 if (!($38)) {
  STACKTOP = sp;return;
 }
 $39 = $2;
 $40 = ((($39)) + 4|0);
 $41 = HEAP32[$40>>2]|0;
 $42 = ($41|0)!=(0);
 if ($42) {
  $43 = $1;
  $44 = $0;
  $45 = ((($44)) + 4|0);
  $46 = HEAP32[$45>>2]|0;
  $47 = (($46) + ($43<<3)|0);
  $48 = ((($47)) + 4|0);
  $49 = HEAP32[$48>>2]|0;
  $50 = $2;
  $51 = HEAP32[$50>>2]|0;
  $52 = (_qspGetAddText($49,$51,0,-1)|0);
  $53 = $1;
  $54 = $0;
  $55 = ((($54)) + 4|0);
  $56 = HEAP32[$55>>2]|0;
  $57 = (($56) + ($53<<3)|0);
  $58 = ((($57)) + 4|0);
  HEAP32[$58>>2] = $52;
  STACKTOP = sp;return;
 } else {
  $59 = $2;
  $60 = HEAP32[$59>>2]|0;
  $61 = $1;
  $62 = $0;
  $63 = ((($62)) + 4|0);
  $64 = HEAP32[$63>>2]|0;
  $65 = (($64) + ($61<<3)|0);
  HEAP32[$65>>2] = $60;
  STACKTOP = sp;return;
 }
}
function _qspGetVarValueByReference($agg$result,$var,$ind,$isStringType) {
 $agg$result = $agg$result|0;
 $var = $var|0;
 $ind = $ind|0;
 $isStringType = $isStringType|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ret = 0, $text = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $ret = sp + 8|0;
 $0 = $var;
 $1 = $ind;
 $2 = $isStringType;
 $3 = $1;
 $4 = ($3|0)>=(0);
 if ($4) {
  $5 = $1;
  $6 = $0;
  $7 = ((($6)) + 8|0);
  $8 = HEAP32[$7>>2]|0;
  $9 = ($5|0)<($8|0);
  if ($9) {
   $10 = $2;
   $11 = ((($ret)) + 4|0);
   HEAP32[$11>>2] = $10;
   $12 = ($10|0)!=(0);
   $13 = $1;
   $14 = $0;
   $15 = ((($14)) + 4|0);
   $16 = HEAP32[$15>>2]|0;
   $17 = (($16) + ($13<<3)|0);
   if ($12) {
    $18 = ((($17)) + 4|0);
    $19 = HEAP32[$18>>2]|0;
    $text = $19;
    $20 = $text;
    $21 = ($20|0)!=(0|0);
    if ($21) {
     $22 = $text;
     $23 = (_qspGetNewText($22,-1)|0);
     $25 = $23;
    } else {
     $24 = (_qspGetNewText(447354,0)|0);
     $25 = $24;
    }
    HEAP32[$ret>>2] = $25;
   } else {
    $26 = HEAP32[$17>>2]|0;
    HEAP32[$ret>>2] = $26;
   }
   ;HEAP32[$agg$result>>2]=HEAP32[$ret>>2]|0;HEAP32[$agg$result+4>>2]=HEAP32[$ret+4>>2]|0;
   STACKTOP = sp;return;
  }
 }
 $27 = $2;
 _qspGetEmptyVariant($agg$result,$27);
 STACKTOP = sp;return;
}
function _qspGetVarNumValue($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = $1;
 $3 = (_qspVarReference($2,0)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = $var;
  $6 = ((($5)) + 8|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = ($7|0)!=(0);
  if ($8) {
   $9 = $var;
   $10 = ((($9)) + 4|0);
   $11 = HEAP32[$10>>2]|0;
   $12 = HEAP32[$11>>2]|0;
   $0 = $12;
   $13 = $0;
   STACKTOP = sp;return ($13|0);
  }
 } else {
  _qspResetError();
 }
 $0 = 0;
 $13 = $0;
 STACKTOP = sp;return ($13|0);
}
function _qspGetVar($agg$result,$name) {
 $agg$result = $agg$result|0;
 $name = $name|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $index = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $index = sp;
 $0 = $name;
 $1 = $0;
 $2 = (_qspGetVarData($1,0,$index)|0);
 $var = $2;
 $3 = ($2|0)!=(0|0);
 if ($3) {
  $4 = $var;
  $5 = HEAP32[$index>>2]|0;
  $6 = $0;
  $7 = HEAP16[$6>>1]|0;
  $8 = $7&65535;
  $9 = HEAP16[446356>>1]|0;
  $10 = $9&65535;
  $11 = ($8|0)==($10|0);
  $12 = $11&1;
  _qspGetVarValueByReference($agg$result,$4,$5,$12);
  STACKTOP = sp;return;
 } else {
  _qspGetEmptyVariant($agg$result,0);
  STACKTOP = sp;return;
 }
}
function _qspPrepareGlobalVars() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $j = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = HEAP32[12644>>2]|0;
 $1 = (($0) - 1)|0;
 $i = $1;
 L1: while(1) {
  $2 = $i;
  $3 = ($2|0)>=(0);
  if (!($3)) {
   label = 8;
   break;
  }
  $4 = $i;
  $5 = HEAP32[12640>>2]|0;
  $6 = (($5) + ($4<<3)|0);
  $7 = ((($6)) + 4|0);
  $8 = HEAP32[$7>>2]|0;
  $9 = (($8) - 1)|0;
  $j = $9;
  while(1) {
   $10 = $j;
   $11 = ($10|0)>=(0);
   if (!($11)) {
    break;
   }
   $12 = $j;
   $13 = $i;
   $14 = HEAP32[12640>>2]|0;
   $15 = (($14) + ($13<<3)|0);
   $16 = HEAP32[$15>>2]|0;
   $17 = (($16) + (($12*24)|0)|0);
   $18 = HEAP32[$17>>2]|0;
   $19 = (_qspVarReference($18,1)|0);
   $var = $19;
   $20 = ($19|0)!=(0|0);
   if (!($20)) {
    label = 8;
    break L1;
   }
   $21 = $var;
   _qspEmptyVar($21);
   $22 = $var;
   $23 = $j;
   $24 = $i;
   $25 = HEAP32[12640>>2]|0;
   $26 = (($25) + ($24<<3)|0);
   $27 = HEAP32[$26>>2]|0;
   $28 = (($27) + (($23*24)|0)|0);
   _qspMoveVar($22,$28);
   $29 = $j;
   $30 = (($29) + -1)|0;
   $j = $30;
  }
  $31 = $i;
  $32 = (($31) + -1)|0;
  $i = $32;
 }
 if ((label|0) == 8) {
  STACKTOP = sp;return;
 }
}
function _qspMoveVar($dest,$src) {
 $dest = $dest|0;
 $src = $src|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $dest;
 $1 = $src;
 $2 = $1;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = $0;
 $6 = ((($5)) + 4|0);
 HEAP32[$6>>2] = $4;
 $7 = $1;
 $8 = ((($7)) + 8|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = $0;
 $11 = ((($10)) + 8|0);
 HEAP32[$11>>2] = $9;
 $12 = $1;
 $13 = ((($12)) + 12|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $0;
 $16 = ((($15)) + 12|0);
 HEAP32[$16>>2] = $14;
 $17 = $1;
 $18 = ((($17)) + 16|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = $0;
 $21 = ((($20)) + 16|0);
 HEAP32[$21>>2] = $19;
 $22 = $1;
 $23 = ((($22)) + 20|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = $0;
 $26 = ((($25)) + 20|0);
 HEAP32[$26>>2] = $24;
 $27 = $1;
 _qspInitVarData($27);
 STACKTOP = sp;return;
}
function _qspPrepareLocalVars($vars) {
 $vars = $vars|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $ind = 0, $j = 0, $savedVars = 0, $var = 0, $varsCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $vars;
 $varsCount = 0;
 $2 = HEAP32[12644>>2]|0;
 $3 = (($2) - 1)|0;
 $i = $3;
 while(1) {
  $4 = $i;
  $5 = ($4|0)>=(0);
  if (!($5)) {
   break;
  }
  $6 = $i;
  $7 = HEAP32[12640>>2]|0;
  $8 = (($7) + ($6<<3)|0);
  $9 = ((($8)) + 4|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = $varsCount;
  $12 = (($11) + ($10))|0;
  $varsCount = $12;
  $13 = $i;
  $14 = (($13) + -1)|0;
  $i = $14;
 }
 $15 = $varsCount;
 $16 = ($15|0)!=(0);
 if (!($16)) {
  $17 = $1;
  HEAP32[$17>>2] = 0;
  $0 = 0;
  $68 = $0;
  STACKTOP = sp;return ($68|0);
 }
 $18 = $varsCount;
 $19 = ($18*24)|0;
 $20 = (_malloc($19)|0);
 $savedVars = $20;
 $ind = 0;
 $21 = HEAP32[12644>>2]|0;
 $22 = (($21) - 1)|0;
 $i = $22;
 L9: while(1) {
  $23 = $i;
  $24 = ($23|0)>=(0);
  if (!($24)) {
   label = 16;
   break;
  }
  $25 = $i;
  $26 = HEAP32[12640>>2]|0;
  $27 = (($26) + ($25<<3)|0);
  $28 = ((($27)) + 4|0);
  $29 = HEAP32[$28>>2]|0;
  $30 = (($29) - 1)|0;
  $j = $30;
  while(1) {
   $31 = $j;
   $32 = ($31|0)>=(0);
   if (!($32)) {
    break;
   }
   $33 = $j;
   $34 = $i;
   $35 = HEAP32[12640>>2]|0;
   $36 = (($35) + ($34<<3)|0);
   $37 = HEAP32[$36>>2]|0;
   $38 = (($37) + (($33*24)|0)|0);
   $39 = HEAP32[$38>>2]|0;
   $40 = (_qspVarReference($39,1)|0);
   $var = $40;
   $41 = ($40|0)!=(0|0);
   if (!($41)) {
    break L9;
   }
   $48 = $savedVars;
   $49 = $ind;
   $50 = (($48) + (($49*24)|0)|0);
   $51 = $var;
   _qspMoveVar($50,$51);
   $52 = $var;
   $53 = $j;
   $54 = $i;
   $55 = HEAP32[12640>>2]|0;
   $56 = (($55) + ($54<<3)|0);
   $57 = HEAP32[$56>>2]|0;
   $58 = (($57) + (($53*24)|0)|0);
   _qspMoveVar($52,$58);
   $59 = $ind;
   $60 = (($59) + 1)|0;
   $ind = $60;
   $61 = $j;
   $62 = (($61) + -1)|0;
   $j = $62;
  }
  $63 = $i;
  $64 = (($63) + -1)|0;
  $i = $64;
 }
 if ((label|0) == 16) {
  $65 = $savedVars;
  $66 = $1;
  HEAP32[$66>>2] = $65;
  $67 = $varsCount;
  $0 = $67;
  $68 = $0;
  STACKTOP = sp;return ($68|0);
 }
 while(1) {
  $42 = $ind;
  $43 = (($42) + -1)|0;
  $ind = $43;
  $44 = ($43|0)>=(0);
  $45 = $savedVars;
  if (!($44)) {
   break;
  }
  $46 = $ind;
  $47 = (($45) + (($46*24)|0)|0);
  _qspEmptyVar($47);
 }
 _free($45);
 $0 = 0;
 $68 = $0;
 STACKTOP = sp;return ($68|0);
}
function _qspRestoreLocalVars($savedVars,$varsCount,$savedGroups,$groupsCount) {
 $savedVars = $savedVars|0;
 $varsCount = $varsCount|0;
 $savedGroups = $savedGroups|0;
 $groupsCount = $groupsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $ind = 0, $j = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $savedVars;
 $1 = $varsCount;
 $2 = $savedGroups;
 $3 = $groupsCount;
 $4 = $0;
 $5 = ($4|0)!=(0|0);
 if (!($5)) {
  STACKTOP = sp;return;
 }
 $ind = 0;
 $6 = $3;
 $7 = (($6) - 1)|0;
 $i = $7;
 L4: while(1) {
  $8 = $i;
  $9 = ($8|0)>=(0);
  if (!($9)) {
   label = 12;
   break;
  }
  $10 = $i;
  $11 = $2;
  $12 = (($11) + ($10<<3)|0);
  $13 = ((($12)) + 4|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = (($14) - 1)|0;
  $j = $15;
  while(1) {
   $16 = $j;
   $17 = ($16|0)>=(0);
   if (!($17)) {
    break;
   }
   $18 = $j;
   $19 = $i;
   $20 = $2;
   $21 = (($20) + ($19<<3)|0);
   $22 = HEAP32[$21>>2]|0;
   $23 = (($22) + (($18*24)|0)|0);
   $24 = HEAP32[$23>>2]|0;
   $25 = (_qspVarReference($24,1)|0);
   $var = $25;
   $26 = ($25|0)!=(0|0);
   if (!($26)) {
    break L4;
   }
   $35 = $j;
   $36 = $i;
   $37 = $2;
   $38 = (($37) + ($36<<3)|0);
   $39 = HEAP32[$38>>2]|0;
   $40 = (($39) + (($35*24)|0)|0);
   $41 = $var;
   _qspMoveVar($40,$41);
   $42 = $var;
   $43 = $0;
   $44 = $ind;
   $45 = (($43) + (($44*24)|0)|0);
   _qspMoveVar($42,$45);
   $46 = $ind;
   $47 = (($46) + 1)|0;
   $ind = $47;
   $48 = $j;
   $49 = (($48) + -1)|0;
   $j = $49;
  }
  $50 = $i;
  $51 = (($50) + -1)|0;
  $i = $51;
 }
 if ((label|0) == 12) {
  $52 = $0;
  _free($52);
  STACKTOP = sp;return;
 }
 while(1) {
  $27 = $ind;
  $28 = $1;
  $29 = ($27|0)<($28|0);
  $30 = $0;
  if (!($29)) {
   break;
  }
  $31 = $ind;
  $32 = (($30) + (($31*24)|0)|0);
  _qspEmptyVar($32);
  $33 = $ind;
  $34 = (($33) + 1)|0;
  $ind = $34;
 }
 _free($30);
 STACKTOP = sp;return;
}
function _qspClearLocalVars($savedVars,$varsCount) {
 $savedVars = $savedVars|0;
 $varsCount = $varsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $savedVars;
 $1 = $varsCount;
 $2 = $0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $4 = $i;
  $5 = $1;
  $6 = ($4|0)<($5|0);
  $7 = $0;
  if (!($6)) {
   break;
  }
  $8 = $i;
  $9 = (($7) + (($8*24)|0)|0);
  _qspEmptyVar($9);
  $10 = $i;
  $11 = (($10) + 1)|0;
  $i = $11;
 }
 _free($7);
 STACKTOP = sp;return;
}
function _qspGetVarsList($s,$vars) {
 $s = $s|0;
 $vars = $vars|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $bufSize = 0, $count = 0;
 var $i = 0, $ind = 0, $isVarFound = 0, $oldCount = 0, $pos = 0, $savedVars = 0, $var = 0, $varName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $s;
 $2 = $vars;
 $3 = $1;
 $4 = (_qspSkipSpaces($3)|0);
 $1 = $4;
 $5 = $1;
 $6 = HEAP16[$5>>1]|0;
 $7 = ($6<<16>>16)!=(0);
 if (!($7)) {
  _qspSetError(118);
  $0 = 0;
  $97 = $0;
  STACKTOP = sp;return ($97|0);
 }
 $count = 0;
 $bufSize = 8;
 $8 = $bufSize;
 $9 = ($8*24)|0;
 $10 = (_malloc($9)|0);
 $savedVars = $10;
 $11 = HEAP32[12644>>2]|0;
 $12 = (($11) - 1)|0;
 $ind = $12;
 $13 = $ind;
 $14 = HEAP32[12640>>2]|0;
 $15 = (($14) + ($13<<3)|0);
 $16 = ((($15)) + 4|0);
 $17 = HEAP32[$16>>2]|0;
 $oldCount = $17;
 $isVarFound = 0;
 while(1) {
  $18 = $1;
  $19 = (_qspStrPos($18,446282,0)|0);
  $pos = $19;
  $20 = $pos;
  $21 = ($20|0)!=(0|0);
  if ($21) {
   $22 = $pos;
   HEAP16[$22>>1] = 0;
   $23 = $1;
   $24 = (_qspDelSpc($23)|0);
   $varName = $24;
   $25 = HEAP16[446282>>1]|0;
   $26 = $pos;
   HEAP16[$26>>1] = $25;
  } else {
   $27 = $1;
   $28 = (_qspDelSpc($27)|0);
   $varName = $28;
  }
  $29 = $varName;
  _qspUpperStr($29);
  $i = 0;
  while(1) {
   $30 = $i;
   $31 = $oldCount;
   $32 = ($30|0)<($31|0);
   if (!($32)) {
    break;
   }
   $33 = $varName;
   $34 = $i;
   $35 = $ind;
   $36 = HEAP32[12640>>2]|0;
   $37 = (($36) + ($35<<3)|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = (($38) + (($34*24)|0)|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (_qspStrsComp($33,$40)|0);
   $42 = ($41|0)!=(0);
   if (!($42)) {
    label = 10;
    break;
   }
   $43 = $i;
   $44 = (($43) + 1)|0;
   $i = $44;
  }
  if ((label|0) == 10) {
   label = 0;
   $isVarFound = 1;
  }
  $45 = $isVarFound;
  $46 = ($45|0)!=(0);
  if ($46) {
   $isVarFound = 0;
   $47 = $varName;
   _free($47);
  } else {
   $48 = $varName;
   $49 = (_qspVarReference($48,0)|0);
   $var = $49;
   $50 = ($49|0)!=(0|0);
   if (!($50)) {
    label = 15;
    break;
   }
   $52 = $count;
   $53 = $bufSize;
   $54 = ($52|0)==($53|0);
   if ($54) {
    $55 = $bufSize;
    $56 = (($55) + 8)|0;
    $bufSize = $56;
    $57 = $savedVars;
    $58 = $bufSize;
    $59 = ($58*24)|0;
    $60 = (_realloc($57,$59)|0);
    $savedVars = $60;
   }
   $61 = $savedVars;
   $62 = $count;
   $63 = (($61) + (($62*24)|0)|0);
   $64 = $var;
   _qspMoveVar($63,$64);
   $65 = $varName;
   $66 = $count;
   $67 = $savedVars;
   $68 = (($67) + (($66*24)|0)|0);
   HEAP32[$68>>2] = $65;
   $69 = $count;
   $70 = (($69) + 1)|0;
   $count = $70;
  }
  $71 = $pos;
  $72 = ($71|0)!=(0|0);
  if (!($72)) {
   break;
  }
  $73 = $pos;
  $74 = ((($73)) + 2|0);
  $75 = (_qspSkipSpaces($74)|0);
  $1 = $75;
  $76 = $1;
  $77 = HEAP16[$76>>1]|0;
  $78 = ($77<<16>>16)!=(0);
  if (!($78)) {
   label = 21;
   break;
  }
 }
 if ((label|0) == 15) {
  $51 = $varName;
  _free($51);
 }
 else if ((label|0) == 21) {
  _qspSetError(118);
 }
 $79 = HEAP32[320460>>2]|0;
 $80 = ($79|0)!=(0);
 if (!($80)) {
  $94 = $savedVars;
  $95 = $2;
  HEAP32[$95>>2] = $94;
  $96 = $count;
  $0 = $96;
  $97 = $0;
  STACKTOP = sp;return ($97|0);
 }
 $i = 0;
 while(1) {
  $81 = $i;
  $82 = $count;
  $83 = ($81|0)<($82|0);
  if (!($83)) {
   break;
  }
  $84 = $i;
  $85 = $savedVars;
  $86 = (($85) + (($84*24)|0)|0);
  $87 = HEAP32[$86>>2]|0;
  _free($87);
  $88 = $savedVars;
  $89 = $i;
  $90 = (($88) + (($89*24)|0)|0);
  _qspEmptyVar($90);
  $91 = $i;
  $92 = (($91) + 1)|0;
  $i = $92;
 }
 $93 = $savedVars;
 _free($93);
 $0 = 0;
 $97 = $0;
 STACKTOP = sp;return ($97|0);
}
function _qspRestoreVarsList($vars,$varsCount) {
 $vars = $vars|0;
 $varsCount = $varsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $var = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $vars;
 $1 = $varsCount;
 $2 = $0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $4 = $i;
  $5 = $1;
  $6 = ($4|0)<($5|0);
  if (!($6)) {
   label = 9;
   break;
  }
  $7 = $i;
  $8 = $0;
  $9 = (($8) + (($7*24)|0)|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = (_qspVarReference($10,1)|0);
  $var = $11;
  $12 = ($11|0)!=(0|0);
  if (!($12)) {
   break;
  }
  $26 = $i;
  $27 = $0;
  $28 = (($27) + (($26*24)|0)|0);
  $29 = HEAP32[$28>>2]|0;
  _free($29);
  $30 = $var;
  _qspEmptyVar($30);
  $31 = $var;
  $32 = $0;
  $33 = $i;
  $34 = (($32) + (($33*24)|0)|0);
  _qspMoveVar($31,$34);
  $35 = $i;
  $36 = (($35) + 1)|0;
  $i = $36;
 }
 if ((label|0) == 9) {
  $37 = $0;
  _free($37);
  STACKTOP = sp;return;
 }
 while(1) {
  $13 = $i;
  $14 = $1;
  $15 = ($13|0)<($14|0);
  if (!($15)) {
   break;
  }
  $16 = $i;
  $17 = $0;
  $18 = (($17) + (($16*24)|0)|0);
  $19 = HEAP32[$18>>2]|0;
  _free($19);
  $20 = $0;
  $21 = $i;
  $22 = (($20) + (($21*24)|0)|0);
  _qspEmptyVar($22);
  $23 = $i;
  $24 = (($23) + 1)|0;
  $i = $24;
 }
 $25 = $0;
 _free($25);
 STACKTOP = sp;return;
}
function _qspClearVarsList($vars,$varsCount) {
 $vars = $vars|0;
 $varsCount = $varsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $vars;
 $1 = $varsCount;
 $2 = $0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $4 = $i;
  $5 = $1;
  $6 = ($4|0)<($5|0);
  if (!($6)) {
   break;
  }
  $7 = $i;
  $8 = $0;
  $9 = (($8) + (($7*24)|0)|0);
  $10 = HEAP32[$9>>2]|0;
  _free($10);
  $11 = $0;
  $12 = $i;
  $13 = (($11) + (($12*24)|0)|0);
  _qspEmptyVar($13);
  $14 = $i;
  $15 = (($14) + 1)|0;
  $i = $15;
 }
 $16 = $0;
 _free($16);
 STACKTOP = sp;return;
}
function _qspArraySize($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = $1;
 $3 = (_qspVarReferenceWithType($2,0,0)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = $var;
  $6 = ((($5)) + 8|0);
  $7 = HEAP32[$6>>2]|0;
  $0 = $7;
  $8 = $0;
  STACKTOP = sp;return ($8|0);
 } else {
  $0 = 0;
  $8 = $0;
  STACKTOP = sp;return ($8|0);
 }
 return (0)|0;
}
function _qspArrayPos($varName,$val,$ind,$isRegExp) {
 $varName = $varName|0;
 $val = $val|0;
 $ind = $ind|0;
 $isRegExp = $isRegExp|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $count = 0, $isString = 0, $num = 0, $onigExp = 0, $onigInfo = 0, $str = 0, $tempBeg = 0, $tempEnd = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $onigExp = sp + 16|0;
 $onigInfo = sp + 4|0;
 $isString = sp;
 $1 = $varName;
 $2 = $val;
 $3 = $ind;
 $4 = $isRegExp;
 $5 = $1;
 $6 = (_qspVarReferenceWithType($5,0,$isString)|0);
 $var = $6;
 $7 = ($6|0)!=(0|0);
 if (!($7)) {
  $0 = -1;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 $8 = $2;
 $9 = $4;
 $10 = ($9|0)!=(0);
 $11 = HEAP32[$isString>>2]|0;
 $12 = ($11|0)!=(0);
 $13 = $10 ? 1 : $12;
 $14 = $13&1;
 $15 = (_qspConvertVariantTo($8,$14)|0);
 $16 = ($15|0)!=(0);
 if ($16) {
  _qspSetError(101);
  $0 = -1;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 $17 = $4;
 $18 = ($17|0)!=(0);
 if ($18) {
  $19 = $2;
  $20 = HEAP32[$19>>2]|0;
  $tempBeg = $20;
  $21 = $2;
  $22 = HEAP32[$21>>2]|0;
  $23 = (_qspStrEnd($22)|0);
  $tempEnd = $23;
  $24 = $tempBeg;
  $25 = $tempEnd;
  $26 = HEAP8[319848>>0]|0;
  $27 = $26 << 24 >> 24;
  $28 = ($27|0)==(1);
  $29 = $28 ? 441256 : 440168;
  $30 = (_onig_new($onigExp,$24,$25,0,$29,336328,$onigInfo)|0);
  $31 = ($30|0)!=(0);
  if ($31) {
   _qspSetError(124);
   $0 = -1;
   $99 = $0;
   STACKTOP = sp;return ($99|0);
  }
 }
 $32 = $var;
 $33 = ((($32)) + 8|0);
 $34 = HEAP32[$33>>2]|0;
 $count = $34;
 $35 = $3;
 $36 = ($35|0)<(0);
 if ($36) {
  $3 = 0;
 } else {
  $37 = $3;
  $38 = $count;
  $39 = ($37|0)>($38|0);
  if ($39) {
   $40 = $count;
   $3 = $40;
  }
 }
 L18: while(1) {
  $41 = $3;
  $42 = $count;
  $43 = ($41|0)<=($42|0);
  if (!($43)) {
   label = 27;
   break;
  }
  $44 = $2;
  $45 = ((($44)) + 4|0);
  $46 = HEAP32[$45>>2]|0;
  $47 = ($46|0)!=(0);
  $48 = $3;
  $49 = $count;
  $50 = ($48|0)<($49|0);
  do {
   if ($47) {
    if ($50) {
     $51 = $3;
     $52 = $var;
     $53 = ((($52)) + 4|0);
     $54 = HEAP32[$53>>2]|0;
     $55 = (($54) + ($51<<3)|0);
     $56 = ((($55)) + 4|0);
     $57 = HEAP32[$56>>2]|0;
     $str = $57;
     $58 = ($57|0)!=(0|0);
     if (!($58)) {
      label = 16;
     }
    } else {
     label = 16;
    }
    if ((label|0) == 16) {
     label = 0;
     $str = 447354;
    }
    $59 = $4;
    $60 = ($59|0)!=(0);
    $61 = $str;
    if ($60) {
     $tempBeg = $61;
     $62 = $str;
     $63 = (_qspStrEnd($62)|0);
     $tempEnd = $63;
     $64 = HEAP32[$onigExp>>2]|0;
     $65 = $tempBeg;
     $66 = $tempEnd;
     $67 = $tempBeg;
     $68 = (_onig_match($64,$65,$66,$67,0,0)|0);
     $69 = $tempEnd;
     $70 = $tempBeg;
     $71 = $69;
     $72 = $70;
     $73 = (($71) - ($72))|0;
     $74 = ($68|0)==($73|0);
     if ($74) {
      label = 19;
      break L18;
     } else {
      break;
     }
    } else {
     $77 = $2;
     $78 = HEAP32[$77>>2]|0;
     $79 = (_qspStrsComp($61,$78)|0);
     $80 = ($79|0)!=(0);
     if ($80) {
      break;
     } else {
      label = 21;
      break L18;
     }
    }
   } else {
    if ($50) {
     $82 = $3;
     $83 = $var;
     $84 = ((($83)) + 4|0);
     $85 = HEAP32[$84>>2]|0;
     $86 = (($85) + ($82<<3)|0);
     $87 = HEAP32[$86>>2]|0;
     $88 = $87;
    } else {
     $88 = 0;
    }
    $num = $88;
    $89 = $num;
    $90 = $2;
    $91 = HEAP32[$90>>2]|0;
    $92 = ($89|0)==($91|0);
    if ($92) {
     label = 25;
     break L18;
    }
   }
  } while(0);
  $94 = $3;
  $95 = (($94) + 1)|0;
  $3 = $95;
 }
 if ((label|0) == 19) {
  $75 = HEAP32[$onigExp>>2]|0;
  _onig_free($75);
  $76 = $3;
  $0 = $76;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 else if ((label|0) == 21) {
  $81 = $3;
  $0 = $81;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 else if ((label|0) == 25) {
  $93 = $3;
  $0 = $93;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 else if ((label|0) == 27) {
  $96 = $4;
  $97 = ($96|0)!=(0);
  if ($97) {
   $98 = HEAP32[$onigExp>>2]|0;
   _onig_free($98);
  }
  $0 = -1;
  $99 = $0;
  STACKTOP = sp;return ($99|0);
 }
 return (0)|0;
}
function _qspArrayMinMaxItem($agg$result,$name,$isMin) {
 $agg$result = $agg$result|0;
 $name = $name|0;
 $isMin = $isMin|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $8 = 0, $9 = 0, $count = 0;
 var $curInd = 0, $isString = 0, $res = 0, $str = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $isString = sp + 16|0;
 $res = sp;
 $0 = $name;
 $1 = $isMin;
 $2 = $0;
 $3 = (_qspVarReferenceWithType($2,0,$isString)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  _qspGetEmptyVariant($agg$result,0);
  STACKTOP = sp;return;
 }
 $curInd = -1;
 $5 = $var;
 $6 = ((($5)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $count = $7;
 while(1) {
  $8 = $count;
  $9 = (($8) + -1)|0;
  $count = $9;
  $10 = ($9|0)>=(0);
  if (!($10)) {
   break;
  }
  $11 = HEAP32[$isString>>2]|0;
  $12 = ($11|0)!=(0);
  if (!($12)) {
   $44 = $curInd;
   $45 = ($44|0)>=(0);
   if (!($45)) {
    $64 = $count;
    $curInd = $64;
    continue;
   }
   $46 = $1;
   $47 = ($46|0)!=(0);
   $48 = $count;
   $49 = $var;
   $50 = ((($49)) + 4|0);
   $51 = HEAP32[$50>>2]|0;
   $52 = (($51) + ($48<<3)|0);
   $53 = HEAP32[$52>>2]|0;
   $54 = $curInd;
   $55 = $var;
   $56 = ((($55)) + 4|0);
   $57 = HEAP32[$56>>2]|0;
   $58 = (($57) + ($54<<3)|0);
   $59 = HEAP32[$58>>2]|0;
   if ($47) {
    $60 = ($53|0)<($59|0);
    if (!($60)) {
     continue;
    }
    $61 = $count;
    $curInd = $61;
    continue;
   } else {
    $62 = ($53|0)>($59|0);
    if (!($62)) {
     continue;
    }
    $63 = $count;
    $curInd = $63;
    continue;
   }
  }
  $13 = $count;
  $14 = $var;
  $15 = ((($14)) + 4|0);
  $16 = HEAP32[$15>>2]|0;
  $17 = (($16) + ($13<<3)|0);
  $18 = ((($17)) + 4|0);
  $19 = HEAP32[$18>>2]|0;
  $str = $19;
  $20 = $str;
  $21 = ($20|0)!=(0|0);
  if (!($21)) {
   continue;
  }
  $22 = $str;
  $23 = HEAP16[$22>>1]|0;
  $24 = $23&65535;
  $25 = ($24|0)!=(0);
  if (!($25)) {
   continue;
  }
  $26 = $curInd;
  $27 = ($26|0)>=(0);
  if (!($27)) {
   $43 = $count;
   $curInd = $43;
   continue;
  }
  $28 = $1;
  $29 = ($28|0)!=(0);
  $30 = $str;
  $31 = $curInd;
  $32 = $var;
  $33 = ((($32)) + 4|0);
  $34 = HEAP32[$33>>2]|0;
  $35 = (($34) + ($31<<3)|0);
  $36 = ((($35)) + 4|0);
  $37 = HEAP32[$36>>2]|0;
  $38 = (_qspStrsComp($30,$37)|0);
  if ($29) {
   $39 = ($38|0)<(0);
   if (!($39)) {
    continue;
   }
   $40 = $count;
   $curInd = $40;
   continue;
  } else {
   $41 = ($38|0)>(0);
   if (!($41)) {
    continue;
   }
   $42 = $count;
   $curInd = $42;
   continue;
  }
 }
 $65 = $curInd;
 $66 = ($65|0)<(0);
 $67 = HEAP32[$isString>>2]|0;
 if ($66) {
  _qspGetEmptyVariant($agg$result,$67);
  STACKTOP = sp;return;
 }
 $68 = ((($res)) + 4|0);
 HEAP32[$68>>2] = $67;
 $69 = ($67|0)!=(0);
 $70 = $curInd;
 $71 = $var;
 $72 = ((($71)) + 4|0);
 $73 = HEAP32[$72>>2]|0;
 $74 = (($73) + ($70<<3)|0);
 if ($69) {
  $75 = ((($74)) + 4|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = (_qspGetNewText($76,-1)|0);
  HEAP32[$res>>2] = $77;
 } else {
  $78 = HEAP32[$74>>2]|0;
  HEAP32[$res>>2] = $78;
 }
 ;HEAP32[$agg$result>>2]=HEAP32[$res>>2]|0;HEAP32[$agg$result+4>>2]=HEAP32[$res+4>>2]|0;
 STACKTOP = sp;return;
}
function _qspGetVarsCount() {
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $count = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $count = 0;
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = ($0|0)<(12800);
  if (!($1)) {
   break;
  }
  $2 = $i;
  $3 = (12648 + (($2*24)|0)|0);
  $4 = HEAP32[$3>>2]|0;
  $5 = ($4|0)!=(0|0);
  if ($5) {
   $6 = $count;
   $7 = (($6) + 1)|0;
   $count = $7;
  }
  $8 = $i;
  $9 = (($8) + 1)|0;
  $i = $9;
 }
 $10 = $count;
 STACKTOP = sp;return ($10|0);
}
function _qspSetArgs($var,$args,$count) {
 $var = $var|0;
 $args = $args|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $var;
 $1 = $args;
 $2 = $count;
 while(1) {
  $3 = $2;
  $4 = (($3) + -1)|0;
  $2 = $4;
  $5 = ($4|0)>=(0);
  if (!($5)) {
   break;
  }
  $6 = $0;
  $7 = $2;
  $8 = $1;
  $9 = $2;
  $10 = (($8) + ($9<<3)|0);
  _qspSetVarValueByReference($6,$7,$10);
 }
 STACKTOP = sp;return;
}
function _qspStatementSetVarValue($s) {
 $s = $s|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $ch = 0, $name = 0, $oldRefreshCount = 0, $or$cond = 0, $pos = 0, $v = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $v = sp + 24|0;
 $1 = sp;
 $0 = $s;
 $2 = $0;
 $3 = (_qspStrPos($2,446304,0)|0);
 $pos = $3;
 $4 = $pos;
 $5 = ($4|0)!=(0|0);
 if (!($5)) {
  _qspSetError(110);
  STACKTOP = sp;return;
 }
 $6 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $6;
 $7 = $pos;
 $8 = ((($7)) + 2|0);
 _qspExprValue($1,$8);
 ;HEAP32[$v>>2]=HEAP32[$1>>2]|0;HEAP32[$v+4>>2]=HEAP32[$1+4>>2]|0;
 $9 = HEAP32[320504>>2]|0;
 $10 = $oldRefreshCount;
 $11 = ($9|0)!=($10|0);
 $12 = HEAP32[320460>>2]|0;
 $13 = ($12|0)!=(0);
 $or$cond = $11 | $13;
 if ($or$cond) {
  STACKTOP = sp;return;
 }
 $14 = $pos;
 $15 = $0;
 $16 = ($14|0)!=($15|0);
 if ($16) {
  $17 = $pos;
  $18 = ((($17)) + -2|0);
  $19 = HEAP16[$18>>1]|0;
  $20 = (_qspIsInList(444354,$19)|0);
  $21 = ($20|0)!=(0);
  if ($21) {
   $22 = $pos;
   $23 = ((($22)) + -2|0);
   $pos = $23;
  }
 }
 $24 = $pos;
 $25 = HEAP16[$24>>1]|0;
 $ch = $25;
 $26 = $pos;
 HEAP16[$26>>1] = 0;
 $27 = $0;
 $28 = (_qspDelSpcCanRetSelf($27)|0);
 $name = $28;
 $29 = $name;
 $30 = $ch;
 _qspSetVar($29,$v,$30);
 $31 = $ch;
 $32 = $pos;
 HEAP16[$32>>1] = $31;
 $33 = $name;
 $34 = $0;
 $35 = ($33|0)!=($34|0);
 if ($35) {
  $36 = $name;
  _free($36);
 }
 $37 = ((($v)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $39 = ($38|0)!=(0);
 if (!($39)) {
  STACKTOP = sp;return;
 }
 $40 = HEAP32[$v>>2]|0;
 _free($40);
 STACKTOP = sp;return;
}
function _qspStatementCopyArr($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $dest = 0, $num = 0;
 var $src = 0, $start = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = $1;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_qspVarReferenceWithType($6,1,0)|0);
 $dest = $7;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  $0 = 0;
  $37 = $0;
  STACKTOP = sp;return ($37|0);
 }
 $9 = $1;
 $10 = ((($9)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (_qspVarReferenceWithType($11,0,0)|0);
 $src = $12;
 $13 = ($12|0)!=(0|0);
 if (!($13)) {
  $0 = 0;
  $37 = $0;
  STACKTOP = sp;return ($37|0);
 }
 $14 = $dest;
 $15 = $src;
 $16 = ($14|0)!=($15|0);
 if ($16) {
  $17 = $2;
  $18 = ($17|0)>=(3);
  if ($18) {
   $19 = $1;
   $20 = ((($19)) + 16|0);
   $21 = HEAP32[$20>>2]|0;
   $22 = $21;
  } else {
   $22 = 0;
  }
  $start = $22;
  $23 = $2;
  $24 = ($23|0)==(4);
  if ($24) {
   $25 = $1;
   $26 = ((($25)) + 24|0);
   $27 = HEAP32[$26>>2]|0;
   $31 = $27;
  } else {
   $28 = $src;
   $29 = ((($28)) + 8|0);
   $30 = HEAP32[$29>>2]|0;
   $31 = $30;
  }
  $num = $31;
  $32 = $dest;
  _qspEmptyVar($32);
  $33 = $dest;
  $34 = $src;
  $35 = $start;
  $36 = $num;
  _qspCopyVar($33,$34,$35,$36);
 }
 $0 = 0;
 $37 = $0;
 STACKTOP = sp;return ($37|0);
}
function _qspStatementKillVar($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 $4 = $1;
 $5 = ($4|0)==(1);
 if ($5) {
  $6 = $0;
  $7 = HEAP32[$6>>2]|0;
  _qspRemoveArray($7);
  STACKTOP = sp;return 0;
 }
 $8 = $1;
 $9 = ($8|0)==(2);
 if ($9) {
  $10 = $0;
  $11 = HEAP32[$10>>2]|0;
  $12 = $0;
  $13 = ((($12)) + 8|0);
  $14 = HEAP32[$13>>2]|0;
  _qspRemoveArrayItem($11,$14);
  STACKTOP = sp;return 0;
 } else {
  _qspClearVars(0);
  STACKTOP = sp;return 0;
 }
 return (0)|0;
}
function _qspInitVarData($var) {
 $var = $var|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $var;
 $1 = $0;
 $2 = ((($1)) + 4|0);
 HEAP32[$2>>2] = 0;
 $3 = $0;
 $4 = ((($3)) + 8|0);
 HEAP32[$4>>2] = 0;
 $5 = $0;
 $6 = ((($5)) + 12|0);
 HEAP32[$6>>2] = 0;
 $7 = $0;
 $8 = ((($7)) + 16|0);
 HEAP32[$8>>2] = 0;
 $9 = $0;
 $10 = ((($9)) + 20|0);
 HEAP32[$10>>2] = 0;
 STACKTOP = sp;return;
}
function _qspGetVarData($s,$isSet,$index) {
 $s = $s|0;
 $isSet = $isSet|0;
 $index = $index|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $7 = 0, $8 = 0, $9 = 0, $ind = 0, $lPos = 0, $oldRefreshCount = 0, $or$cond = 0, $rPos = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $ind = sp + 24|0;
 $4 = sp;
 $1 = $s;
 $2 = $isSet;
 $3 = $index;
 $5 = $1;
 $6 = HEAP16[446370>>1]|0;
 $7 = (_qspStrChar($5,$6)|0);
 $lPos = $7;
 $8 = $lPos;
 $9 = ($8|0)!=(0|0);
 if (!($9)) {
  $63 = $3;
  HEAP32[$63>>2] = 0;
  $64 = $1;
  $65 = $2;
  $66 = (_qspVarReference($64,$65)|0);
  $0 = $66;
  $67 = $0;
  STACKTOP = sp;return ($67|0);
 }
 $10 = $lPos;
 HEAP16[$10>>1] = 0;
 $11 = $1;
 $12 = $2;
 $13 = (_qspVarReference($11,$12)|0);
 $var = $13;
 $14 = HEAP16[446370>>1]|0;
 $15 = $lPos;
 HEAP16[$15>>1] = $14;
 $16 = $var;
 $17 = ($16|0)!=(0|0);
 if (!($17)) {
  $0 = 0;
  $67 = $0;
  STACKTOP = sp;return ($67|0);
 }
 $18 = $lPos;
 $19 = (_qspStrPos($18,444384,0)|0);
 $rPos = $19;
 $20 = $rPos;
 $21 = ($20|0)!=(0|0);
 if (!($21)) {
  _qspSetError(116);
  $0 = 0;
  $67 = $0;
  STACKTOP = sp;return ($67|0);
 }
 $22 = $lPos;
 $23 = ((($22)) + 2|0);
 $24 = (_qspSkipSpaces($23)|0);
 $1 = $24;
 $25 = $1;
 $26 = $rPos;
 $27 = ($25|0)==($26|0);
 do {
  if ($27) {
   $28 = $2;
   $29 = ($28|0)!=(0);
   $30 = $var;
   $31 = ((($30)) + 8|0);
   $32 = HEAP32[$31>>2]|0;
   if ($29) {
    $33 = $3;
    HEAP32[$33>>2] = $32;
    break;
   }
   $34 = ($32|0)!=(0);
   if ($34) {
    $35 = $var;
    $36 = ((($35)) + 8|0);
    $37 = HEAP32[$36>>2]|0;
    $38 = (($37) - 1)|0;
    $40 = $38;
   } else {
    $40 = 0;
   }
   $39 = $3;
   HEAP32[$39>>2] = $40;
  } else {
   $41 = HEAP32[320504>>2]|0;
   $oldRefreshCount = $41;
   $42 = $rPos;
   HEAP16[$42>>1] = 0;
   $43 = $1;
   _qspExprValue($4,$43);
   ;HEAP32[$ind>>2]=HEAP32[$4>>2]|0;HEAP32[$ind+4>>2]=HEAP32[$4+4>>2]|0;
   $44 = HEAP16[444384>>1]|0;
   $45 = $rPos;
   HEAP16[$45>>1] = $44;
   $46 = HEAP32[320504>>2]|0;
   $47 = $oldRefreshCount;
   $48 = ($46|0)!=($47|0);
   $49 = HEAP32[320460>>2]|0;
   $50 = ($49|0)!=(0);
   $or$cond = $48 | $50;
   if ($or$cond) {
    $0 = 0;
    $67 = $0;
    STACKTOP = sp;return ($67|0);
   }
   $51 = ((($ind)) + 4|0);
   $52 = HEAP32[$51>>2]|0;
   $53 = ($52|0)!=(0);
   if ($53) {
    $54 = $var;
    $55 = HEAP32[$ind>>2]|0;
    $56 = $2;
    $57 = (_qspGetVarTextIndex($54,$55,$56)|0);
    $58 = $3;
    HEAP32[$58>>2] = $57;
    $59 = HEAP32[$ind>>2]|0;
    _free($59);
    break;
   } else {
    $60 = HEAP32[$ind>>2]|0;
    $61 = $3;
    HEAP32[$61>>2] = $60;
    break;
   }
  }
 } while(0);
 $62 = $var;
 $0 = $62;
 $67 = $0;
 STACKTOP = sp;return ($67|0);
}
function _qspSetVar($name,$val,$op) {
 $name = $name|0;
 $val = $val|0;
 $op = $op|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $index = 0, $oldVal = 0, $var = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $oldVal = sp + 24|0;
 $index = sp + 16|0;
 $3 = sp + 8|0;
 $4 = sp;
 $0 = $name;
 $1 = $val;
 $2 = $op;
 $5 = $0;
 $6 = (_qspGetVarData($5,1,$index)|0);
 $var = $6;
 $7 = ($6|0)!=(0|0);
 if (!($7)) {
  STACKTOP = sp;return;
 }
 $8 = $2;
 $9 = $8&65535;
 $10 = HEAP16[446304>>1]|0;
 $11 = $10&65535;
 $12 = ($9|0)==($11|0);
 if ($12) {
  $13 = $1;
  $14 = $0;
  $15 = HEAP16[$14>>1]|0;
  $16 = $15&65535;
  $17 = HEAP16[446356>>1]|0;
  $18 = $17&65535;
  $19 = ($16|0)==($18|0);
  $20 = $19&1;
  $21 = (_qspConvertVariantTo($13,$20)|0);
  $22 = ($21|0)!=(0);
  if ($22) {
   _qspSetError(101);
   STACKTOP = sp;return;
  } else {
   $23 = $var;
   $24 = HEAP32[$index>>2]|0;
   $25 = $1;
   _qspSetVarValueByReference($23,$24,$25);
   STACKTOP = sp;return;
  }
 }
 $26 = $2;
 $27 = $26&65535;
 $28 = HEAP16[444364>>1]|0;
 $29 = $28&65535;
 $30 = ($27|0)==($29|0);
 if ($30) {
  $31 = $var;
  $32 = HEAP32[$index>>2]|0;
  $33 = $0;
  $34 = HEAP16[$33>>1]|0;
  $35 = $34&65535;
  $36 = HEAP16[446356>>1]|0;
  $37 = $36&65535;
  $38 = ($35|0)==($37|0);
  $39 = $38&1;
  _qspGetVarValueByReference($3,$31,$32,$39);
  ;HEAP32[$oldVal>>2]=HEAP32[$3>>2]|0;HEAP32[$oldVal+4>>2]=HEAP32[$3+4>>2]|0;
  $40 = ((($oldVal)) + 4|0);
  $41 = HEAP32[$40>>2]|0;
  $42 = ($41|0)!=(0);
  if ($42) {
   $43 = $1;
   $44 = ((($43)) + 4|0);
   $45 = HEAP32[$44>>2]|0;
   $46 = ($45|0)!=(0);
   if ($46) {
    $47 = HEAP32[$oldVal>>2]|0;
    $48 = $1;
    $49 = HEAP32[$48>>2]|0;
    $50 = (_qspGetAddText($47,$49,-1,-1)|0);
    HEAP32[$oldVal>>2] = $50;
   } else {
    label = 10;
   }
  } else {
   label = 10;
  }
  do {
   if ((label|0) == 10) {
    $51 = (_qspIsCanConvertToNum($oldVal)|0);
    $52 = ($51|0)!=(0);
    if ($52) {
     $53 = $1;
     $54 = (_qspIsCanConvertToNum($53)|0);
     $55 = ($54|0)!=(0);
     if ($55) {
      (_qspConvertVariantTo($oldVal,0)|0);
      $56 = $1;
      (_qspConvertVariantTo($56,0)|0);
      $57 = $1;
      $58 = HEAP32[$57>>2]|0;
      $59 = HEAP32[$oldVal>>2]|0;
      $60 = (($59) + ($58))|0;
      HEAP32[$oldVal>>2] = $60;
      $61 = $0;
      $62 = HEAP16[$61>>1]|0;
      $63 = $62&65535;
      $64 = HEAP16[446356>>1]|0;
      $65 = $64&65535;
      $66 = ($63|0)==($65|0);
      $67 = $66&1;
      (_qspConvertVariantTo($oldVal,$67)|0);
      break;
     }
    }
    $68 = ((($oldVal)) + 4|0);
    $69 = HEAP32[$68>>2]|0;
    $70 = ($69|0)!=(0);
    if ($70) {
     $71 = $1;
     (_qspConvertVariantTo($71,1)|0);
     $72 = HEAP32[$oldVal>>2]|0;
     $73 = $1;
     $74 = HEAP32[$73>>2]|0;
     $75 = (_qspGetAddText($72,$74,-1,-1)|0);
     HEAP32[$oldVal>>2] = $75;
     break;
    }
    _qspSetError(101);
    STACKTOP = sp;return;
   }
  } while(0);
  $76 = $var;
  $77 = HEAP32[$index>>2]|0;
  _qspSetVarValueByReference($76,$77,$oldVal);
  $78 = ((($oldVal)) + 4|0);
  $79 = HEAP32[$78>>2]|0;
  $80 = ($79|0)!=(0);
  if (!($80)) {
   STACKTOP = sp;return;
  }
  $81 = HEAP32[$oldVal>>2]|0;
  _free($81);
  STACKTOP = sp;return;
 }
 $82 = $2;
 $83 = (_qspIsInList(444368,$82)|0);
 $84 = ($83|0)!=(0);
 if (!($84)) {
  STACKTOP = sp;return;
 }
 $85 = $1;
 $86 = (_qspConvertVariantTo($85,0)|0);
 $87 = ($86|0)!=(0);
 if ($87) {
  _qspSetError(101);
  STACKTOP = sp;return;
 }
 $88 = $var;
 $89 = HEAP32[$index>>2]|0;
 $90 = $0;
 $91 = HEAP16[$90>>1]|0;
 $92 = $91&65535;
 $93 = HEAP16[446356>>1]|0;
 $94 = $93&65535;
 $95 = ($92|0)==($94|0);
 $96 = $95&1;
 _qspGetVarValueByReference($4,$88,$89,$96);
 ;HEAP32[$oldVal>>2]=HEAP32[$4>>2]|0;HEAP32[$oldVal+4>>2]=HEAP32[$4+4>>2]|0;
 $97 = (_qspConvertVariantTo($oldVal,0)|0);
 $98 = ($97|0)!=(0);
 if ($98) {
  _qspSetError(101);
  $99 = HEAP32[$oldVal>>2]|0;
  _free($99);
  STACKTOP = sp;return;
 }
 $100 = $2;
 $101 = $100&65535;
 $102 = HEAP16[444376>>1]|0;
 $103 = $102&65535;
 $104 = ($101|0)==($103|0);
 do {
  if ($104) {
   $105 = $1;
   $106 = HEAP32[$105>>2]|0;
   $107 = HEAP32[$oldVal>>2]|0;
   $108 = (($107) - ($106))|0;
   HEAP32[$oldVal>>2] = $108;
  } else {
   $109 = $2;
   $110 = $109&65535;
   $111 = HEAP16[444380>>1]|0;
   $112 = $111&65535;
   $113 = ($110|0)==($112|0);
   $114 = $1;
   $115 = HEAP32[$114>>2]|0;
   if (!($113)) {
    $121 = HEAP32[$oldVal>>2]|0;
    $122 = Math_imul($121, $115)|0;
    HEAP32[$oldVal>>2] = $122;
    break;
   }
   $116 = ($115|0)!=(0);
   if ($116) {
    $117 = $1;
    $118 = HEAP32[$117>>2]|0;
    $119 = HEAP32[$oldVal>>2]|0;
    $120 = (($119|0) / ($118|0))&-1;
    HEAP32[$oldVal>>2] = $120;
    break;
   }
   _qspSetError(100);
   STACKTOP = sp;return;
  }
 } while(0);
 $123 = $0;
 $124 = HEAP16[$123>>1]|0;
 $125 = $124&65535;
 $126 = HEAP16[446356>>1]|0;
 $127 = $126&65535;
 $128 = ($125|0)==($127|0);
 $129 = $128&1;
 (_qspConvertVariantTo($oldVal,$129)|0);
 $130 = $var;
 $131 = HEAP32[$index>>2]|0;
 _qspSetVarValueByReference($130,$131,$oldVal);
 $132 = ((($oldVal)) + 4|0);
 $133 = HEAP32[$132>>2]|0;
 $134 = ($133|0)!=(0);
 if (!($134)) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$oldVal>>2]|0;
 _free($135);
 STACKTOP = sp;return;
}
function _qspCopyVar($dest,$src,$start,$count) {
 $dest = $dest|0;
 $src = $src|0;
 $start = $start|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
 var $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0;
 var $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $maxCount = 0, $newInd = 0, $or$cond = 0, $str = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $dest;
 $1 = $src;
 $2 = $start;
 $3 = $count;
 $4 = $2;
 $5 = ($4|0)<(0);
 if ($5) {
  $2 = 0;
 }
 $6 = $1;
 $7 = ((($6)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = $2;
 $10 = (($8) - ($9))|0;
 $maxCount = $10;
 $11 = $3;
 $12 = ($11|0)<=(0);
 $13 = $maxCount;
 $14 = ($13|0)<=(0);
 $or$cond = $12 | $14;
 if ($or$cond) {
  $15 = $0;
  _qspInitVarData($15);
  STACKTOP = sp;return;
 }
 $16 = $3;
 $17 = $maxCount;
 $18 = ($16|0)<($17|0);
 if ($18) {
  $19 = $3;
  $maxCount = $19;
 }
 $20 = $maxCount;
 $21 = $0;
 $22 = ((($21)) + 8|0);
 HEAP32[$22>>2] = $20;
 $23 = $maxCount;
 $24 = $23<<3;
 $25 = (_malloc($24)|0);
 $26 = $0;
 $27 = ((($26)) + 4|0);
 HEAP32[$27>>2] = $25;
 $i = 0;
 while(1) {
  $28 = $i;
  $29 = $maxCount;
  $30 = ($28|0)<($29|0);
  if (!($30)) {
   break;
  }
  $31 = $i;
  $32 = $2;
  $33 = (($31) + ($32))|0;
  $34 = $1;
  $35 = ((($34)) + 4|0);
  $36 = HEAP32[$35>>2]|0;
  $37 = (($36) + ($33<<3)|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = $i;
  $40 = $0;
  $41 = ((($40)) + 4|0);
  $42 = HEAP32[$41>>2]|0;
  $43 = (($42) + ($39<<3)|0);
  HEAP32[$43>>2] = $38;
  $44 = $i;
  $45 = $2;
  $46 = (($44) + ($45))|0;
  $47 = $1;
  $48 = ((($47)) + 4|0);
  $49 = HEAP32[$48>>2]|0;
  $50 = (($49) + ($46<<3)|0);
  $51 = ((($50)) + 4|0);
  $52 = HEAP32[$51>>2]|0;
  $str = $52;
  $53 = $str;
  $54 = ($53|0)!=(0|0);
  if ($54) {
   $55 = $str;
   $56 = (_qspGetNewText($55,-1)|0);
   $63 = $56;
  } else {
   $63 = 0;
  }
  $57 = $i;
  $58 = $0;
  $59 = ((($58)) + 4|0);
  $60 = HEAP32[$59>>2]|0;
  $61 = (($60) + ($57<<3)|0);
  $62 = ((($61)) + 4|0);
  HEAP32[$62>>2] = $63;
  $64 = $i;
  $65 = (($64) + 1)|0;
  $i = $65;
 }
 $66 = $0;
 $67 = ((($66)) + 20|0);
 HEAP32[$67>>2] = 0;
 $68 = $0;
 $69 = ((($68)) + 12|0);
 HEAP32[$69>>2] = 0;
 $3 = 0;
 $i = 0;
 while(1) {
  $70 = $i;
  $71 = $1;
  $72 = ((($71)) + 16|0);
  $73 = HEAP32[$72>>2]|0;
  $74 = ($70|0)<($73|0);
  if (!($74)) {
   break;
  }
  $75 = $i;
  $76 = $1;
  $77 = ((($76)) + 12|0);
  $78 = HEAP32[$77>>2]|0;
  $79 = (($78) + ($75<<3)|0);
  $80 = HEAP32[$79>>2]|0;
  $81 = $2;
  $82 = (($80) - ($81))|0;
  $newInd = $82;
  $83 = $newInd;
  $84 = ($83|0)>=(0);
  if ($84) {
   $85 = $newInd;
   $86 = $maxCount;
   $87 = ($85|0)<($86|0);
   if ($87) {
    $88 = $3;
    $89 = $0;
    $90 = ((($89)) + 20|0);
    $91 = HEAP32[$90>>2]|0;
    $92 = ($88|0)==($91|0);
    if ($92) {
     $93 = $0;
     $94 = ((($93)) + 20|0);
     $95 = HEAP32[$94>>2]|0;
     $96 = (($95) + 16)|0;
     HEAP32[$94>>2] = $96;
     $97 = $0;
     $98 = ((($97)) + 12|0);
     $99 = HEAP32[$98>>2]|0;
     $100 = $0;
     $101 = ((($100)) + 20|0);
     $102 = HEAP32[$101>>2]|0;
     $103 = $102<<3;
     $104 = (_realloc($99,$103)|0);
     $105 = $0;
     $106 = ((($105)) + 12|0);
     HEAP32[$106>>2] = $104;
    }
    $107 = $newInd;
    $108 = $3;
    $109 = $0;
    $110 = ((($109)) + 12|0);
    $111 = HEAP32[$110>>2]|0;
    $112 = (($111) + ($108<<3)|0);
    HEAP32[$112>>2] = $107;
    $113 = $i;
    $114 = $1;
    $115 = ((($114)) + 12|0);
    $116 = HEAP32[$115>>2]|0;
    $117 = (($116) + ($113<<3)|0);
    $118 = ((($117)) + 4|0);
    $119 = HEAP32[$118>>2]|0;
    $120 = (_qspGetNewText($119,-1)|0);
    $121 = $3;
    $122 = $0;
    $123 = ((($122)) + 12|0);
    $124 = HEAP32[$123>>2]|0;
    $125 = (($124) + ($121<<3)|0);
    $126 = ((($125)) + 4|0);
    HEAP32[$126>>2] = $120;
    $127 = $3;
    $128 = (($127) + 1)|0;
    $3 = $128;
   }
  }
  $129 = $i;
  $130 = (($129) + 1)|0;
  $i = $130;
 }
 $131 = $3;
 $132 = $0;
 $133 = ((($132)) + 16|0);
 HEAP32[$133>>2] = $131;
 STACKTOP = sp;return;
}
function _qspRemoveArray($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $0;
 $2 = (_qspVarReferenceWithType($1,0,0)|0);
 $var = $2;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $4 = $var;
 _qspEmptyVar($4);
 STACKTOP = sp;return;
}
function _qspRemoveArrayItem($name,$index) {
 $name = $name|0;
 $index = $index|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $ind = 0, $isRemoving = 0, $or$cond = 0, $origIndex = 0, $var = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $index;
 $2 = $0;
 $3 = (_qspVarReferenceWithType($2,0,0)|0);
 $var = $3;
 $4 = ($3|0)==(0|0);
 $5 = $1;
 $6 = ($5|0)<(0);
 $or$cond = $4 | $6;
 if ($or$cond) {
  STACKTOP = sp;return;
 }
 $7 = $1;
 $8 = $var;
 $9 = ((($8)) + 8|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($7|0)>=($10|0);
 if ($11) {
  STACKTOP = sp;return;
 }
 $12 = $1;
 $origIndex = $12;
 $13 = $1;
 $14 = $var;
 $15 = ((($14)) + 4|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = (($16) + ($13<<3)|0);
 $18 = ((($17)) + 4|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($19|0)!=(0|0);
 if ($20) {
  $21 = $1;
  $22 = $var;
  $23 = ((($22)) + 4|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = (($24) + ($21<<3)|0);
  $26 = ((($25)) + 4|0);
  $27 = HEAP32[$26>>2]|0;
  _free($27);
 }
 $28 = $var;
 $29 = ((($28)) + 8|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = (($30) + -1)|0;
 HEAP32[$29>>2] = $31;
 while(1) {
  $32 = $1;
  $33 = $var;
  $34 = ((($33)) + 8|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = ($32|0)<($35|0);
  if (!($36)) {
   break;
  }
  $37 = $1;
  $38 = $var;
  $39 = ((($38)) + 4|0);
  $40 = HEAP32[$39>>2]|0;
  $41 = (($40) + ($37<<3)|0);
  $42 = $1;
  $43 = (($42) + 1)|0;
  $44 = $var;
  $45 = ((($44)) + 4|0);
  $46 = HEAP32[$45>>2]|0;
  $47 = (($46) + ($43<<3)|0);
  ;HEAP32[$41>>2]=HEAP32[$47>>2]|0;HEAP32[$41+4>>2]=HEAP32[$47+4>>2]|0;
  $48 = $1;
  $49 = (($48) + 1)|0;
  $1 = $49;
 }
 $isRemoving = 0;
 $1 = 0;
 while(1) {
  $50 = $1;
  $51 = $var;
  $52 = ((($51)) + 16|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ($50|0)<($53|0);
  if (!($54)) {
   label = 18;
   break;
  }
  $55 = $var;
  $56 = ((($55)) + 12|0);
  $57 = HEAP32[$56>>2]|0;
  $58 = $1;
  $59 = (($57) + ($58<<3)|0);
  $ind = $59;
  $60 = $ind;
  $61 = HEAP32[$60>>2]|0;
  $62 = $origIndex;
  $63 = ($61|0)==($62|0);
  if ($63) {
   $64 = $ind;
   $65 = ((($64)) + 4|0);
   $66 = HEAP32[$65>>2]|0;
   _free($66);
   $67 = $var;
   $68 = ((($67)) + 16|0);
   $69 = HEAP32[$68>>2]|0;
   $70 = (($69) + -1)|0;
   HEAP32[$68>>2] = $70;
   $71 = $1;
   $72 = $var;
   $73 = ((($72)) + 16|0);
   $74 = HEAP32[$73>>2]|0;
   $75 = ($71|0)==($74|0);
   if ($75) {
    label = 18;
    break;
   }
   $isRemoving = 1;
  }
  $76 = $isRemoving;
  $77 = ($76|0)!=(0);
  if ($77) {
   $78 = $ind;
   $79 = $1;
   $80 = (($79) + 1)|0;
   $81 = $var;
   $82 = ((($81)) + 12|0);
   $83 = HEAP32[$82>>2]|0;
   $84 = (($83) + ($80<<3)|0);
   ;HEAP32[$78>>2]=HEAP32[$84>>2]|0;HEAP32[$78+4>>2]=HEAP32[$84+4>>2]|0;
  }
  $85 = $ind;
  $86 = HEAP32[$85>>2]|0;
  $87 = $origIndex;
  $88 = ($86|0)>($87|0);
  if ($88) {
   $89 = $ind;
   $90 = HEAP32[$89>>2]|0;
   $91 = (($90) + -1)|0;
   HEAP32[$89>>2] = $91;
  }
  $92 = $1;
  $93 = (($92) + 1)|0;
  $1 = $93;
 }
 if ((label|0) == 18) {
  STACKTOP = sp;return;
 }
}
function _qspGetVarTextIndex($var,$str,$isCreate) {
 $var = $var|0;
 $str = $str|0;
 $isCreate = $isCreate|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $i = 0, $ind = 0, $n = 0, $uStr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $var;
 $2 = $str;
 $3 = $isCreate;
 $4 = $1;
 $5 = ((($4)) + 16|0);
 $6 = HEAP32[$5>>2]|0;
 $n = $6;
 $7 = $2;
 $8 = (_qspGetNewText($7,-1)|0);
 $uStr = $8;
 _qspUpperStr($8);
 $9 = $n;
 $10 = ($9|0)>(0);
 if ($10) {
  $11 = $uStr;
  $12 = $1;
  $13 = ((($12)) + 12|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = $n;
  $16 = (_bsearch($11,$14,$15,8,70)|0);
  $ind = $16;
  $17 = $ind;
  $18 = ($17|0)!=(0|0);
  if ($18) {
   $19 = $uStr;
   _free($19);
   $20 = $ind;
   $21 = HEAP32[$20>>2]|0;
   $0 = $21;
   $92 = $0;
   STACKTOP = sp;return ($92|0);
  }
 }
 $22 = $3;
 $23 = ($22|0)!=(0);
 if (!($23)) {
  $91 = $uStr;
  _free($91);
  $0 = -1;
  $92 = $0;
  STACKTOP = sp;return ($92|0);
 }
 $24 = $1;
 $25 = ((($24)) + 16|0);
 $26 = HEAP32[$25>>2]|0;
 $27 = (($26) + 1)|0;
 HEAP32[$25>>2] = $27;
 $28 = $1;
 $29 = ((($28)) + 20|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = $n;
 $32 = ($30|0)==($31|0);
 if ($32) {
  $33 = $1;
  $34 = ((($33)) + 20|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = (($35) + 8)|0;
  HEAP32[$34>>2] = $36;
  $37 = $1;
  $38 = ((($37)) + 12|0);
  $39 = HEAP32[$38>>2]|0;
  $40 = $1;
  $41 = ((($40)) + 20|0);
  $42 = HEAP32[$41>>2]|0;
  $43 = $42<<3;
  $44 = (_realloc($39,$43)|0);
  $45 = $1;
  $46 = ((($45)) + 12|0);
  HEAP32[$46>>2] = $44;
 }
 $47 = $n;
 $48 = (($47) - 1)|0;
 $i = $48;
 while(1) {
  $49 = $i;
  $50 = ($49|0)>=(0);
  if ($50) {
   $51 = $i;
   $52 = $1;
   $53 = ((($52)) + 12|0);
   $54 = HEAP32[$53>>2]|0;
   $55 = (($54) + ($51<<3)|0);
   $56 = ((($55)) + 4|0);
   $57 = HEAP32[$56>>2]|0;
   $58 = $uStr;
   $59 = (_qspStrsComp($57,$58)|0);
   $60 = ($59|0)>(0);
   $93 = $60;
  } else {
   $93 = 0;
  }
  $61 = $i;
  $62 = (($61) + 1)|0;
  if (!($93)) {
   break;
  }
  $63 = $1;
  $64 = ((($63)) + 12|0);
  $65 = HEAP32[$64>>2]|0;
  $66 = (($65) + ($62<<3)|0);
  $67 = $i;
  $68 = $1;
  $69 = ((($68)) + 12|0);
  $70 = HEAP32[$69>>2]|0;
  $71 = (($70) + ($67<<3)|0);
  ;HEAP32[$66>>2]=HEAP32[$71>>2]|0;HEAP32[$66+4>>2]=HEAP32[$71+4>>2]|0;
  $72 = $i;
  $73 = (($72) + -1)|0;
  $i = $73;
 }
 $i = $62;
 $74 = $1;
 $75 = ((($74)) + 8|0);
 $76 = HEAP32[$75>>2]|0;
 $n = $76;
 $77 = $uStr;
 $78 = $i;
 $79 = $1;
 $80 = ((($79)) + 12|0);
 $81 = HEAP32[$80>>2]|0;
 $82 = (($81) + ($78<<3)|0);
 $83 = ((($82)) + 4|0);
 HEAP32[$83>>2] = $77;
 $84 = $n;
 $85 = $i;
 $86 = $1;
 $87 = ((($86)) + 12|0);
 $88 = HEAP32[$87>>2]|0;
 $89 = (($88) + ($85<<3)|0);
 HEAP32[$89>>2] = $84;
 $90 = $n;
 $0 = $90;
 $92 = $0;
 STACKTOP = sp;return ($92|0);
}
function _qspIndStringCompare($name,$compareTo) {
 $name = $name|0;
 $compareTo = $compareTo|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $compareTo;
 $2 = $0;
 $3 = $1;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (_qspStrsComp($2,$5)|0);
 STACKTOP = sp;return ($6|0);
}
function _qspSaveCallState($state,$isDisableCodeExec,$isExitOnError) {
 $state = $state|0;
 $isDisableCodeExec = $isDisableCodeExec|0;
 $isExitOnError = $isExitOnError|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $state;
 $1 = $isDisableCodeExec;
 $2 = $isExitOnError;
 $3 = HEAP32[319852>>2]|0;
 $4 = $0;
 HEAP32[$4>>2] = $3;
 $5 = HEAP32[319856>>2]|0;
 $6 = $0;
 $7 = ((($6)) + 4|0);
 HEAP32[$7>>2] = $5;
 $8 = HEAP32[319860>>2]|0;
 $9 = $0;
 $10 = ((($9)) + 8|0);
 HEAP32[$10>>2] = $8;
 $11 = HEAP32[1660>>2]|0;
 $12 = $0;
 $13 = ((($12)) + 12|0);
 HEAP32[$13>>2] = $11;
 $14 = HEAP32[1664>>2]|0;
 $15 = $0;
 $16 = ((($15)) + 16|0);
 HEAP32[$16>>2] = $14;
 $17 = HEAP32[320520>>2]|0;
 $18 = $0;
 $19 = ((($18)) + 20|0);
 HEAP32[$19>>2] = $17;
 $20 = HEAP32[16>>2]|0;
 $21 = $0;
 $22 = ((($21)) + 24|0);
 HEAP32[$22>>2] = $20;
 HEAP32[319852>>2] = 1;
 $23 = $1;
 HEAP32[319856>>2] = $23;
 $24 = $2;
 HEAP32[319860>>2] = $24;
 STACKTOP = sp;return;
}
function _qspRestoreCallState($state) {
 $state = $state|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $state;
 $1 = HEAP32[319860>>2]|0;
 $2 = ($1|0)!=(0);
 if (!($2)) {
  _qspResetError();
 }
 $3 = $0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[319860>>2] = $5;
 $6 = $0;
 $7 = ((($6)) + 4|0);
 $8 = HEAP32[$7>>2]|0;
 HEAP32[319856>>2] = $8;
 $9 = $0;
 $10 = HEAP32[$9>>2]|0;
 HEAP32[319852>>2] = $10;
 $11 = $0;
 $12 = ((($11)) + 24|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)!=(0);
 if ($14) {
  HEAP32[16>>2] = 1;
 }
 $15 = $0;
 $16 = ((($15)) + 20|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = ($17|0)!=(0);
 if ($18) {
  HEAP32[320520>>2] = 1;
 }
 $19 = $0;
 $20 = ((($19)) + 16|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ($21|0)!=(0);
 if ($22) {
  HEAP32[1664>>2] = 1;
 }
 $23 = $0;
 $24 = ((($23)) + 12|0);
 $25 = HEAP32[$24>>2]|0;
 $26 = ($25|0)!=(0);
 if (!($26)) {
  STACKTOP = sp;return;
 }
 HEAP32[1660>>2] = 1;
 STACKTOP = sp;return;
}
function _qspCodeReCode($str,$isCode) {
 $str = $str|0;
 $isCode = $isCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $ch = 0, $len = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $isCode;
 $2 = $0;
 $3 = (_qspStrLen($2)|0);
 $len = $3;
 $4 = $len;
 $5 = (($4) + 1)|0;
 $6 = $5<<1;
 $7 = (_malloc($6)|0);
 $buf = $7;
 $8 = $len;
 $9 = $buf;
 $10 = (($9) + ($8<<1)|0);
 HEAP16[$10>>1] = 0;
 $11 = $1;
 $12 = ($11|0)!=(0);
 if ($12) {
  while(1) {
   $13 = $len;
   $14 = (($13) + -1)|0;
   $len = $14;
   $15 = ($14|0)>=(0);
   if (!($15)) {
    break;
   }
   $16 = $len;
   $17 = $0;
   $18 = (($17) + ($16<<1)|0);
   $19 = HEAP16[$18>>1]|0;
   $ch = $19;
   $20 = $ch;
   $21 = $20&65535;
   $22 = ($21|0)==(5);
   if ($22) {
    $ch = -5;
   } else {
    $23 = $ch;
    $24 = $23&65535;
    $25 = (($24) - 5)|0;
    $26 = $25&65535;
    $ch = $26;
   }
   $27 = $ch;
   $28 = $len;
   $29 = $buf;
   $30 = (($29) + ($28<<1)|0);
   HEAP16[$30>>1] = $27;
  }
  $49 = $buf;
  STACKTOP = sp;return ($49|0);
 } else {
  while(1) {
   $31 = $len;
   $32 = (($31) + -1)|0;
   $len = $32;
   $33 = ($32|0)>=(0);
   if (!($33)) {
    break;
   }
   $34 = $len;
   $35 = $0;
   $36 = (($35) + ($34<<1)|0);
   $37 = HEAP16[$36>>1]|0;
   $ch = $37;
   $38 = $ch;
   $39 = $38&65535;
   $40 = ($39|0)==(65531);
   if ($40) {
    $ch = 5;
   } else {
    $41 = $ch;
    $42 = $41&65535;
    $43 = (($42) + 5)|0;
    $44 = $43&65535;
    $ch = $44;
   }
   $45 = $ch;
   $46 = $len;
   $47 = $buf;
   $48 = (($47) + ($46<<1)|0);
   HEAP16[$48>>1] = $45;
  }
  $49 = $buf;
  STACKTOP = sp;return ($49|0);
 }
 return (0)|0;
}
function _qspGameToQSPString($s,$isUCS2,$isCoded) {
 $s = $s|0;
 $isUCS2 = $isUCS2|0;
 $isCoded = $isCoded|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ch = 0, $len = 0, $ptr = 0;
 var $ret = 0, $uCh = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $isUCS2;
 $2 = $isCoded;
 $3 = $1;
 $4 = ($3|0)!=(0);
 $5 = $0;
 if ($4) {
  $6 = (_qspUCS2StrLen($5)|0);
  $8 = $6;
 } else {
  $7 = (_strlen($5)|0);
  $8 = $7;
 }
 $len = $8;
 $9 = $len;
 $10 = (($9) + 1)|0;
 $11 = $10<<1;
 $12 = (_malloc($11)|0);
 $ret = $12;
 $13 = $len;
 $14 = $ret;
 $15 = (($14) + ($13<<1)|0);
 HEAP16[$15>>1] = 0;
 $16 = $1;
 $17 = ($16|0)!=(0);
 if (!($17)) {
  $82 = $2;
  $83 = ($82|0)!=(0);
  if (!($83)) {
   while(1) {
    $104 = $len;
    $105 = (($104) + -1)|0;
    $len = $105;
    $106 = ($105|0)>=(0);
    if (!($106)) {
     break;
    }
    $107 = $len;
    $108 = $0;
    $109 = (($108) + ($107)|0);
    $110 = HEAP8[$109>>0]|0;
    $111 = (_qspDirectConvertUC($110,319944)|0);
    $112 = $111&65535;
    $113 = $len;
    $114 = $ret;
    $115 = (($114) + ($113<<1)|0);
    HEAP16[$115>>1] = $112;
   }
   $116 = $ret;
   STACKTOP = sp;return ($116|0);
  }
  while(1) {
   $84 = $len;
   $85 = (($84) + -1)|0;
   $len = $85;
   $86 = ($85|0)>=(0);
   if (!($86)) {
    break;
   }
   $87 = $len;
   $88 = $0;
   $89 = (($88) + ($87)|0);
   $90 = HEAP8[$89>>0]|0;
   $ch = $90;
   $91 = $ch;
   $92 = $91 << 24 >> 24;
   $93 = ($92|0)==(-5);
   if ($93) {
    $ch = 5;
   } else {
    $94 = $ch;
    $95 = $94 << 24 >> 24;
    $96 = (($95) + 5)|0;
    $97 = $96&255;
    $ch = $97;
   }
   $98 = $ch;
   $99 = (_qspDirectConvertUC($98,319944)|0);
   $100 = $99&65535;
   $101 = $len;
   $102 = $ret;
   $103 = (($102) + ($101<<1)|0);
   HEAP16[$103>>1] = $100;
  }
  $116 = $ret;
  STACKTOP = sp;return ($116|0);
 }
 $18 = $0;
 $ptr = $18;
 $19 = $2;
 $20 = ($19|0)!=(0);
 if (!($20)) {
  while(1) {
   $55 = $len;
   $56 = (($55) + -1)|0;
   $len = $56;
   $57 = ($56|0)>=(0);
   if (!($57)) {
    break;
   }
   $58 = HEAP8[320456>>0]|0;
   $59 = $58 << 24 >> 24;
   $60 = ($59|0)==(1);
   $61 = $len;
   $62 = $ptr;
   $63 = (($62) + ($61<<1)|0);
   $64 = HEAP16[$63>>1]|0;
   $65 = $64&65535;
   if ($60) {
    $77 = $65;
   } else {
    $66 = $65 << 8;
    $67 = $len;
    $68 = $ptr;
    $69 = (($68) + ($67<<1)|0);
    $70 = HEAP16[$69>>1]|0;
    $71 = $70&65535;
    $72 = $71 >> 8;
    $73 = $66 | $72;
    $74 = $73&65535;
    $75 = $74&65535;
    $77 = $75;
   }
   $76 = $77&65535;
   $uCh = $76;
   $78 = $uCh;
   $79 = $len;
   $80 = $ret;
   $81 = (($80) + ($79<<1)|0);
   HEAP16[$81>>1] = $78;
  }
  $116 = $ret;
  STACKTOP = sp;return ($116|0);
 }
 while(1) {
  $21 = $len;
  $22 = (($21) + -1)|0;
  $len = $22;
  $23 = ($22|0)>=(0);
  if (!($23)) {
   break;
  }
  $24 = HEAP8[320456>>0]|0;
  $25 = $24 << 24 >> 24;
  $26 = ($25|0)==(1);
  $27 = $len;
  $28 = $ptr;
  $29 = (($28) + ($27<<1)|0);
  $30 = HEAP16[$29>>1]|0;
  $31 = $30&65535;
  if ($26) {
   $43 = $31;
  } else {
   $32 = $31 << 8;
   $33 = $len;
   $34 = $ptr;
   $35 = (($34) + ($33<<1)|0);
   $36 = HEAP16[$35>>1]|0;
   $37 = $36&65535;
   $38 = $37 >> 8;
   $39 = $32 | $38;
   $40 = $39&65535;
   $41 = $40&65535;
   $43 = $41;
  }
  $42 = $43&65535;
  $uCh = $42;
  $44 = $uCh;
  $45 = $44&65535;
  $46 = ($45|0)==(65531);
  if ($46) {
   $uCh = 5;
  } else {
   $47 = $uCh;
   $48 = $47&65535;
   $49 = (($48) + 5)|0;
   $50 = $49&65535;
   $uCh = $50;
  }
  $51 = $uCh;
  $52 = $len;
  $53 = $ret;
  $54 = (($53) + ($52<<1)|0);
  HEAP16[$54>>1] = $51;
 }
 $116 = $ret;
 STACKTOP = sp;return ($116|0);
}
function _qspSplitGameStr($str,$isUCS2,$delim,$res) {
 $str = $str|0;
 $isUCS2 = $isUCS2|0;
 $delim = $delim|0;
 $res = $res|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, $allocChars = 0, $bufSize = 0, $charSize = 0, $count = 0, $curPos = 0, $delimSize = 0, $delimStr = 0, $found = 0, $newStr = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $isUCS2;
 $2 = $delim;
 $3 = $res;
 $4 = $0;
 $curPos = $4;
 $count = 0;
 $bufSize = 8;
 $5 = $1;
 $6 = ($5|0)!=(0);
 $7 = $6 ? 2 : 1;
 $charSize = $7;
 $8 = $2;
 $9 = (_qspStrLen($8)|0);
 $10 = $charSize;
 $11 = Math_imul($9, $10)|0;
 $delimSize = $11;
 $12 = $2;
 $13 = $1;
 $14 = (_qspQSPToGameString($12,$13,0)|0);
 $delimStr = $14;
 $15 = $1;
 $16 = ($15|0)!=(0);
 $17 = $0;
 $18 = $delimStr;
 if ($16) {
  $19 = (_qspUCS2StrStr($17,$18)|0);
  $21 = $19;
 } else {
  $20 = (_strstr($17,$18)|0);
  $21 = $20;
 }
 $found = $21;
 $22 = $bufSize;
 $23 = $22<<2;
 $24 = (_malloc($23)|0);
 $ret = $24;
 while(1) {
  $25 = $found;
  $26 = ($25|0)!=(0|0);
  if (!($26)) {
   break;
  }
  $27 = $found;
  $28 = $curPos;
  $29 = $27;
  $30 = $28;
  $31 = (($29) - ($30))|0;
  $allocChars = $31;
  $32 = $allocChars;
  $33 = $charSize;
  $34 = (($32) + ($33))|0;
  $35 = (_malloc($34)|0);
  $newStr = $35;
  $36 = $newStr;
  $37 = $curPos;
  $38 = $allocChars;
  _memcpy(($36|0),($37|0),($38|0))|0;
  $39 = $1;
  $40 = ($39|0)!=(0);
  if ($40) {
   $41 = $newStr;
   $42 = $allocChars;
   $43 = (($41) + ($42)|0);
   HEAP16[$43>>1] = 0;
  } else {
   $44 = $allocChars;
   $45 = $newStr;
   $46 = (($45) + ($44)|0);
   HEAP8[$46>>0] = 0;
  }
  $47 = $count;
  $48 = (($47) + 1)|0;
  $count = $48;
  $49 = $bufSize;
  $50 = ($48|0)>($49|0);
  if ($50) {
   $51 = $bufSize;
   $52 = (($51) + 16)|0;
   $bufSize = $52;
   $53 = $ret;
   $54 = $bufSize;
   $55 = $54<<2;
   $56 = (_realloc($53,$55)|0);
   $ret = $56;
  }
  $57 = $newStr;
  $58 = $count;
  $59 = (($58) - 1)|0;
  $60 = $ret;
  $61 = (($60) + ($59<<2)|0);
  HEAP32[$61>>2] = $57;
  $62 = $found;
  $63 = $delimSize;
  $64 = (($62) + ($63)|0);
  $curPos = $64;
  $65 = $1;
  $66 = ($65|0)!=(0);
  $67 = $curPos;
  $68 = $delimStr;
  if ($66) {
   $69 = (_qspUCS2StrStr($67,$68)|0);
   $71 = $69;
  } else {
   $70 = (_strstr($67,$68)|0);
   $71 = $70;
  }
  $found = $71;
 }
 $72 = $delimStr;
 _free($72);
 $73 = $1;
 $74 = ($73|0)!=(0);
 $75 = $curPos;
 if ($74) {
  $76 = (_qspUCS2StrLen($75)|0);
  $77 = (($76) + 1)|0;
  $78 = $charSize;
  $79 = Math_imul($77, $78)|0;
  $82 = $79;
 } else {
  $80 = (_strlen($75)|0);
  $81 = (($80) + 1)|0;
  $82 = $81;
 }
 $allocChars = $82;
 $83 = $allocChars;
 $84 = (_malloc($83)|0);
 $newStr = $84;
 $85 = $newStr;
 $86 = $curPos;
 $87 = $allocChars;
 _memcpy(($85|0),($86|0),($87|0))|0;
 $88 = $count;
 $89 = (($88) + 1)|0;
 $count = $89;
 $90 = $bufSize;
 $91 = ($89|0)>($90|0);
 if (!($91)) {
  $96 = $newStr;
  $97 = $count;
  $98 = (($97) - 1)|0;
  $99 = $ret;
  $100 = (($99) + ($98<<2)|0);
  HEAP32[$100>>2] = $96;
  $101 = $ret;
  $102 = $3;
  HEAP32[$102>>2] = $101;
  $103 = $count;
  STACKTOP = sp;return ($103|0);
 }
 $92 = $ret;
 $93 = $count;
 $94 = $93<<2;
 $95 = (_realloc($92,$94)|0);
 $ret = $95;
 $96 = $newStr;
 $97 = $count;
 $98 = (($97) - 1)|0;
 $99 = $ret;
 $100 = (($99) + ($98<<2)|0);
 HEAP32[$100>>2] = $96;
 $101 = $ret;
 $102 = $3;
 HEAP32[$102>>2] = $101;
 $103 = $count;
 STACKTOP = sp;return ($103|0);
}
function _qspReCodeGetIntVal($val) {
 $val = $val|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $num = 0, $temp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $val;
 $1 = $0;
 $2 = (_qspCodeReCode($1,0)|0);
 $temp = $2;
 $3 = $temp;
 $4 = (_qspStrToNum($3,0)|0);
 $num = $4;
 $5 = $temp;
 _free($5);
 $6 = $num;
 STACKTOP = sp;return ($6|0);
}
function _qspCodeWriteIntVal($s,$len,$val,$isCode) {
 $s = $s|0;
 $len = $len|0;
 $val = $val|0;
 $isCode = $isCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0;
 var $temp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $buf = sp + 24|0;
 $0 = $s;
 $1 = $len;
 $2 = $val;
 $3 = $isCode;
 $4 = $2;
 (_qspNumToStr($buf,$4)|0);
 $5 = $3;
 $6 = ($5|0)!=(0);
 if ($6) {
  $7 = (_qspCodeReCode($buf,1)|0);
  $temp = $7;
  $8 = $0;
  $9 = $temp;
  $10 = $1;
  $11 = (_qspAddText($8,$9,$10,-1,0)|0);
  $1 = $11;
  $12 = $temp;
  _free($12);
 } else {
  $13 = $0;
  $14 = $1;
  $15 = (_qspAddText($13,$buf,$14,-1,0)|0);
  $1 = $15;
 }
 $16 = $0;
 $17 = $1;
 $18 = (_qspAddText($16,446380,$17,2,0)|0);
 STACKTOP = sp;return ($18|0);
}
function _qspCodeWriteVal($s,$len,$val,$isCode) {
 $s = $s|0;
 $len = $len|0;
 $val = $val|0;
 $isCode = $isCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $temp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $len;
 $2 = $val;
 $3 = $isCode;
 $4 = $2;
 $5 = ($4|0)!=(0|0);
 do {
  if ($5) {
   $6 = $3;
   $7 = ($6|0)!=(0);
   if ($7) {
    $8 = $2;
    $9 = (_qspCodeReCode($8,1)|0);
    $temp = $9;
    $10 = $0;
    $11 = $temp;
    $12 = $1;
    $13 = (_qspAddText($10,$11,$12,-1,0)|0);
    $1 = $13;
    $14 = $temp;
    _free($14);
    break;
   } else {
    $15 = $0;
    $16 = $2;
    $17 = $1;
    $18 = (_qspAddText($15,$16,$17,-1,0)|0);
    $1 = $18;
    break;
   }
  }
 } while(0);
 $19 = $0;
 $20 = $1;
 $21 = (_qspAddText($19,446380,$20,2,0)|0);
 STACKTOP = sp;return ($21|0);
}
function _qspUCS2StrLen($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ptr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $str;
 $1 = $0;
 $ptr = $1;
 while(1) {
  $2 = $ptr;
  $3 = HEAP16[$2>>1]|0;
  $4 = ($3<<16>>16)!=(0);
  $5 = $ptr;
  if (!($4)) {
   break;
  }
  $6 = ((($5)) + 2|0);
  $ptr = $6;
 }
 $7 = $0;
 $8 = $5;
 $9 = $7;
 $10 = (($8) - ($9))|0;
 $11 = (($10|0) / 2)&-1;
 STACKTOP = sp;return ($11|0);
}
function _qspDirectConvertUC($ch,$table) {
 $ch = $ch|0;
 $table = $table|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ch2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $ch;
 $1 = $table;
 $2 = $0;
 $ch2 = $2;
 $3 = $ch2;
 $4 = $3&255;
 $5 = ($4|0)>=(128);
 if ($5) {
  $6 = $ch2;
  $7 = $6&255;
  $8 = (($7) - 128)|0;
  $9 = $1;
  $10 = (($9) + ($8<<2)|0);
  $11 = HEAP32[$10>>2]|0;
  $14 = $11;
  STACKTOP = sp;return ($14|0);
 } else {
  $12 = $0;
  $13 = $12 << 24 >> 24;
  $14 = $13;
  STACKTOP = sp;return ($14|0);
 }
 return (0)|0;
}
function _qspQSPToGameString($s,$isUCS2,$isCode) {
 $s = $s|0;
 $isUCS2 = $isUCS2|0;
 $isCode = $isCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $12 = 0, $13 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ch = 0, $len = 0, $ptr = 0, $ret = 0, $uCh = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $s;
 $1 = $isUCS2;
 $2 = $isCode;
 $3 = $0;
 $4 = (_qspStrLen($3)|0);
 $len = $4;
 $5 = $len;
 $6 = (($5) + 1)|0;
 $7 = $1;
 $8 = ($7|0)!=(0);
 $9 = $8 ? 2 : 1;
 $10 = Math_imul($6, $9)|0;
 $11 = (_malloc($10)|0);
 $ret = $11;
 $12 = $1;
 $13 = ($12|0)!=(0);
 if (!($13)) {
  $75 = $len;
  $76 = $ret;
  $77 = (($76) + ($75)|0);
  HEAP8[$77>>0] = 0;
  $78 = $2;
  $79 = ($78|0)!=(0);
  if (!($79)) {
   while(1) {
    $100 = $len;
    $101 = (($100) + -1)|0;
    $len = $101;
    $102 = ($101|0)>=(0);
    if (!($102)) {
     break;
    }
    $103 = $len;
    $104 = $0;
    $105 = (($104) + ($103<<1)|0);
    $106 = HEAP16[$105>>1]|0;
    $107 = $106&65535;
    $108 = (_qspReverseConvertUC($107,319944)|0);
    $109 = $len;
    $110 = $ret;
    $111 = (($110) + ($109)|0);
    HEAP8[$111>>0] = $108;
   }
   $112 = $ret;
   STACKTOP = sp;return ($112|0);
  }
  while(1) {
   $80 = $len;
   $81 = (($80) + -1)|0;
   $len = $81;
   $82 = ($81|0)>=(0);
   if (!($82)) {
    break;
   }
   $83 = $len;
   $84 = $0;
   $85 = (($84) + ($83<<1)|0);
   $86 = HEAP16[$85>>1]|0;
   $87 = $86&65535;
   $88 = (_qspReverseConvertUC($87,319944)|0);
   $ch = $88;
   $89 = $ch;
   $90 = $89 << 24 >> 24;
   $91 = ($90|0)==(5);
   if ($91) {
    $ch = -5;
   } else {
    $92 = $ch;
    $93 = $92 << 24 >> 24;
    $94 = (($93) - 5)|0;
    $95 = $94&255;
    $ch = $95;
   }
   $96 = $ch;
   $97 = $len;
   $98 = $ret;
   $99 = (($98) + ($97)|0);
   HEAP8[$99>>0] = $96;
  }
  $112 = $ret;
  STACKTOP = sp;return ($112|0);
 }
 $14 = $ret;
 $ptr = $14;
 $15 = $len;
 $16 = $ptr;
 $17 = (($16) + ($15<<1)|0);
 HEAP16[$17>>1] = 0;
 $18 = $2;
 $19 = ($18|0)!=(0);
 if (!($19)) {
  while(1) {
   $51 = $len;
   $52 = (($51) + -1)|0;
   $len = $52;
   $53 = ($52|0)>=(0);
   if (!($53)) {
    break;
   }
   $54 = $len;
   $55 = $0;
   $56 = (($55) + ($54<<1)|0);
   $57 = HEAP16[$56>>1]|0;
   $uCh = $57;
   $58 = HEAP8[320456>>0]|0;
   $59 = $58 << 24 >> 24;
   $60 = ($59|0)==(1);
   $61 = $uCh;
   $62 = $61&65535;
   if ($60) {
    $71 = $62;
   } else {
    $63 = $62 << 8;
    $64 = $uCh;
    $65 = $64&65535;
    $66 = $65 >> 8;
    $67 = $63 | $66;
    $68 = $67&65535;
    $69 = $68&65535;
    $71 = $69;
   }
   $70 = $71&65535;
   $72 = $len;
   $73 = $ptr;
   $74 = (($73) + ($72<<1)|0);
   HEAP16[$74>>1] = $70;
  }
  $112 = $ret;
  STACKTOP = sp;return ($112|0);
 }
 while(1) {
  $20 = $len;
  $21 = (($20) + -1)|0;
  $len = $21;
  $22 = ($21|0)>=(0);
  if (!($22)) {
   break;
  }
  $23 = $len;
  $24 = $0;
  $25 = (($24) + ($23<<1)|0);
  $26 = HEAP16[$25>>1]|0;
  $uCh = $26;
  $27 = $uCh;
  $28 = $27&65535;
  $29 = ($28|0)==(5);
  if ($29) {
   $uCh = -5;
  } else {
   $30 = $uCh;
   $31 = $30&65535;
   $32 = (($31) - 5)|0;
   $33 = $32&65535;
   $uCh = $33;
  }
  $34 = HEAP8[320456>>0]|0;
  $35 = $34 << 24 >> 24;
  $36 = ($35|0)==(1);
  $37 = $uCh;
  $38 = $37&65535;
  if ($36) {
   $47 = $38;
  } else {
   $39 = $38 << 8;
   $40 = $uCh;
   $41 = $40&65535;
   $42 = $41 >> 8;
   $43 = $39 | $42;
   $44 = $43&65535;
   $45 = $44&65535;
   $47 = $45;
  }
  $46 = $47&65535;
  $48 = $len;
  $49 = $ptr;
  $50 = (($49) + ($48<<1)|0);
  HEAP16[$50>>1] = $46;
 }
 $112 = $ret;
 STACKTOP = sp;return ($112|0);
}
function _qspUCS2StrStr($str,$subStr) {
 $str = $str|0;
 $subStr = $subStr|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cp = 0, $s1 = 0, $s2 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str;
 $2 = $subStr;
 $3 = $1;
 $cp = $3;
 while(1) {
  $4 = $cp;
  $5 = HEAP16[$4>>1]|0;
  $6 = ($5<<16>>16)!=(0);
  if (!($6)) {
   label = 11;
   break;
  }
  $7 = $cp;
  $s1 = $7;
  $8 = $2;
  $s2 = $8;
  while(1) {
   $9 = $s1;
   $10 = HEAP16[$9>>1]|0;
   $11 = $10&65535;
   $12 = ($11|0)!=(0);
   if (!($12)) {
    break;
   }
   $13 = $s2;
   $14 = HEAP16[$13>>1]|0;
   $15 = $14&65535;
   $16 = ($15|0)!=(0);
   if (!($16)) {
    break;
   }
   $17 = $s1;
   $18 = HEAP16[$17>>1]|0;
   $19 = $18&65535;
   $20 = $s2;
   $21 = HEAP16[$20>>1]|0;
   $22 = $21&65535;
   $23 = (($19) - ($22))|0;
   $24 = ($23|0)!=(0);
   $25 = $24 ^ 1;
   if (!($25)) {
    break;
   }
   $26 = $s1;
   $27 = ((($26)) + 2|0);
   $s1 = $27;
   $28 = $s2;
   $29 = ((($28)) + 2|0);
   $s2 = $29;
  }
  $30 = $s2;
  $31 = HEAP16[$30>>1]|0;
  $32 = ($31<<16>>16)!=(0);
  $33 = $cp;
  if (!($32)) {
   label = 9;
   break;
  }
  $34 = ((($33)) + 2|0);
  $cp = $34;
 }
 if ((label|0) == 9) {
  $0 = $33;
  $35 = $0;
  STACKTOP = sp;return ($35|0);
 }
 else if ((label|0) == 11) {
  $0 = 0;
  $35 = $0;
  STACKTOP = sp;return ($35|0);
 }
 return (0)|0;
}
function _qspReverseConvertUC($ch,$table) {
 $ch = $ch|0;
 $table = $table|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $ch;
 $2 = $table;
 $3 = $1;
 $4 = ($3|0)<(128);
 do {
  if ($4) {
   $5 = $1;
   $6 = $5&255;
   $0 = $6;
  } else {
   $i = 127;
   while(1) {
    $7 = $i;
    $8 = ($7|0)>=(0);
    if (!($8)) {
     label = 8;
     break;
    }
    $9 = $i;
    $10 = $2;
    $11 = (($10) + ($9<<2)|0);
    $12 = HEAP32[$11>>2]|0;
    $13 = $1;
    $14 = ($12|0)==($13|0);
    $15 = $i;
    if ($14) {
     label = 6;
     break;
    }
    $18 = (($15) + -1)|0;
    $i = $18;
   }
   if ((label|0) == 6) {
    $16 = (($15) + 128)|0;
    $17 = $16&255;
    $0 = $17;
    break;
   }
   else if ((label|0) == 8) {
    $0 = 32;
    break;
   }
  }
 } while(0);
 $19 = $0;
 STACKTOP = sp;return ($19|0);
}
function _qspSetError($num) {
 $num = $num|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $num;
 $1 = HEAP32[320460>>2]|0;
 $2 = ($1|0)!=(0);
 if ($2) {
  STACKTOP = sp;return;
 }
 $3 = $0;
 HEAP32[320460>>2] = $3;
 $4 = HEAP32[320476>>2]|0;
 HEAP32[320464>>2] = $4;
 $5 = HEAP32[320484>>2]|0;
 HEAP32[320472>>2] = $5;
 $6 = HEAP32[320480>>2]|0;
 HEAP32[320468>>2] = $6;
 STACKTOP = sp;return;
}
function _qspResetError() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 HEAP32[320460>>2] = 0;
 HEAP32[320464>>2] = -1;
 HEAP32[320472>>2] = -1;
 HEAP32[320468>>2] = 0;
 return;
}
function _qspGetErrorDesc($errorNum) {
 $errorNum = $errorNum|0;
 var $0 = 0, $1 = 0, $2 = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $errorNum;
 $1 = $0;
 do {
  switch ($1|0) {
  case 100:  {
   $str = 444388;
   break;
  }
  case 101:  {
   $str = 444424;
   break;
  }
  case 102:  {
   $str = 444454;
   break;
  }
  case 103:  {
   $str = 444486;
   break;
  }
  case 104:  {
   $str = 444546;
   break;
  }
  case 105:  {
   $str = 444578;
   break;
  }
  case 106:  {
   $str = 444612;
   break;
  }
  case 107:  {
   $str = 444646;
   break;
  }
  case 108:  {
   $str = 444686;
   break;
  }
  case 109:  {
   $str = 444718;
   break;
  }
  case 110:  {
   $str = 444754;
   break;
  }
  case 111:  {
   $str = 444794;
   break;
  }
  case 112:  {
   $str = 444834;
   break;
  }
  case 113:  {
   $str = 444868;
   break;
  }
  case 114:  {
   $str = 444902;
   break;
  }
  case 115:  {
   $str = 444956;
   break;
  }
  case 116:  {
   $str = 444990;
   break;
  }
  case 117:  {
   $str = 445028;
   break;
  }
  case 118:  {
   $str = 445068;
   break;
  }
  case 119:  {
   $str = 445096;
   break;
  }
  case 120:  {
   $str = 445128;
   break;
  }
  case 121:  {
   $str = 445184;
   break;
  }
  case 122:  {
   $str = 445220;
   break;
  }
  case 123:  {
   $str = 445266;
   break;
  }
  case 124:  {
   $str = 445306;
   break;
  }
  case 125:  {
   $str = 445362;
   break;
  }
  case 126:  {
   $str = 445394;
   break;
  }
  default: {
   $str = 445426;
  }
  }
 } while(0);
 $2 = $str;
 STACKTOP = sp;return ($2|0);
}
function _qspCreateWorld($start,$locsCount) {
 $start = $start|0;
 $locsCount = $locsCount|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $j = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $start;
 $1 = $locsCount;
 $2 = $0;
 $i = $2;
 while(1) {
  $3 = $i;
  $4 = HEAP32[320496>>2]|0;
  $5 = ($3|0)<($4|0);
  if (!($5)) {
   break;
  }
  $6 = $i;
  $7 = HEAP32[320492>>2]|0;
  $8 = (($7) + ($6<<3)|0);
  $9 = ((($8)) + 4|0);
  $10 = HEAP32[$9>>2]|0;
  _free($10);
  $11 = $i;
  $12 = HEAP32[320488>>2]|0;
  $13 = (($12) + (($11*816)|0)|0);
  $14 = HEAP32[$13>>2]|0;
  _free($14);
  $15 = $i;
  $16 = HEAP32[320488>>2]|0;
  $17 = (($16) + (($15*816)|0)|0);
  $18 = ((($17)) + 4|0);
  $19 = HEAP32[$18>>2]|0;
  _free($19);
  $20 = $i;
  $21 = HEAP32[320488>>2]|0;
  $22 = (($21) + (($20*816)|0)|0);
  $23 = ((($22)) + 8|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = $i;
  $26 = HEAP32[320488>>2]|0;
  $27 = (($26) + (($25*816)|0)|0);
  $28 = ((($27)) + 12|0);
  $29 = HEAP32[$28>>2]|0;
  _qspFreePrepLines($24,$29);
  $j = 0;
  while(1) {
   $30 = $j;
   $31 = ($30|0)<(50);
   if (!($31)) {
    break;
   }
   $32 = $j;
   $33 = $i;
   $34 = HEAP32[320488>>2]|0;
   $35 = (($34) + (($33*816)|0)|0);
   $36 = ((($35)) + 16|0);
   $37 = (($36) + ($32<<4)|0);
   $38 = ((($37)) + 4|0);
   $39 = HEAP32[$38>>2]|0;
   $40 = ($39|0)!=(0|0);
   if ($40) {
    $41 = $j;
    $42 = $i;
    $43 = HEAP32[320488>>2]|0;
    $44 = (($43) + (($42*816)|0)|0);
    $45 = ((($44)) + 16|0);
    $46 = (($45) + ($41<<4)|0);
    $47 = HEAP32[$46>>2]|0;
    $48 = ($47|0)!=(0|0);
    if ($48) {
     $49 = $j;
     $50 = $i;
     $51 = HEAP32[320488>>2]|0;
     $52 = (($51) + (($50*816)|0)|0);
     $53 = ((($52)) + 16|0);
     $54 = (($53) + ($49<<4)|0);
     $55 = HEAP32[$54>>2]|0;
     _free($55);
    }
    $56 = $j;
    $57 = $i;
    $58 = HEAP32[320488>>2]|0;
    $59 = (($58) + (($57*816)|0)|0);
    $60 = ((($59)) + 16|0);
    $61 = (($60) + ($56<<4)|0);
    $62 = ((($61)) + 4|0);
    $63 = HEAP32[$62>>2]|0;
    _free($63);
    $64 = $j;
    $65 = $i;
    $66 = HEAP32[320488>>2]|0;
    $67 = (($66) + (($65*816)|0)|0);
    $68 = ((($67)) + 16|0);
    $69 = (($68) + ($64<<4)|0);
    $70 = ((($69)) + 8|0);
    $71 = HEAP32[$70>>2]|0;
    $72 = $j;
    $73 = $i;
    $74 = HEAP32[320488>>2]|0;
    $75 = (($74) + (($73*816)|0)|0);
    $76 = ((($75)) + 16|0);
    $77 = (($76) + ($72<<4)|0);
    $78 = ((($77)) + 12|0);
    $79 = HEAP32[$78>>2]|0;
    _qspFreePrepLines($71,$79);
   }
   $80 = $j;
   $81 = (($80) + 1)|0;
   $j = $81;
  }
  $82 = $i;
  $83 = (($82) + 1)|0;
  $i = $83;
 }
 $84 = HEAP32[320496>>2]|0;
 $85 = $1;
 $86 = ($84|0)!=($85|0);
 if ($86) {
  $87 = $1;
  HEAP32[320496>>2] = $87;
  $88 = HEAP32[320488>>2]|0;
  $89 = HEAP32[320496>>2]|0;
  $90 = ($89*816)|0;
  $91 = (_realloc($88,$90)|0);
  HEAP32[320488>>2] = $91;
  $92 = HEAP32[320492>>2]|0;
  $93 = HEAP32[320496>>2]|0;
  $94 = $93<<3;
  $95 = (_realloc($92,$94)|0);
  HEAP32[320492>>2] = $95;
 }
 $96 = $0;
 $i = $96;
 while(1) {
  $97 = $i;
  $98 = HEAP32[320496>>2]|0;
  $99 = ($97|0)<($98|0);
  if (!($99)) {
   break;
  }
  $100 = $i;
  $101 = HEAP32[320492>>2]|0;
  $102 = (($101) + ($100<<3)|0);
  $103 = ((($102)) + 4|0);
  HEAP32[$103>>2] = 0;
  $j = 0;
  while(1) {
   $104 = $j;
   $105 = ($104|0)<(50);
   if (!($105)) {
    break;
   }
   $106 = $j;
   $107 = $i;
   $108 = HEAP32[320488>>2]|0;
   $109 = (($108) + (($107*816)|0)|0);
   $110 = ((($109)) + 16|0);
   $111 = (($110) + ($106<<4)|0);
   $112 = ((($111)) + 4|0);
   HEAP32[$112>>2] = 0;
   $113 = $j;
   $114 = (($113) + 1)|0;
   $j = $114;
  }
  $115 = $i;
  $116 = (($115) + 1)|0;
  $i = $116;
 }
 STACKTOP = sp;return;
}
function _qspPrepareLocs() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = HEAP32[320496>>2]|0;
  $2 = ($0|0)<($1|0);
  if (!($2)) {
   break;
  }
  $3 = $i;
  $4 = $i;
  $5 = HEAP32[320492>>2]|0;
  $6 = (($5) + ($4<<3)|0);
  HEAP32[$6>>2] = $3;
  $7 = $i;
  $8 = HEAP32[320492>>2]|0;
  $9 = (($8) + ($7<<3)|0);
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = $i;
  $13 = HEAP32[320488>>2]|0;
  $14 = (($13) + (($12*816)|0)|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = (_qspGetAddText($11,$15,0,-1)|0);
  $17 = $i;
  $18 = HEAP32[320492>>2]|0;
  $19 = (($18) + ($17<<3)|0);
  $20 = ((($19)) + 4|0);
  HEAP32[$20>>2] = $16;
  _qspUpperStr($16);
  $21 = $i;
  $22 = (($21) + 1)|0;
  $i = $22;
 }
 $23 = HEAP32[320492>>2]|0;
 $24 = HEAP32[320496>>2]|0;
 _qsort($23,$24,8,71);
 STACKTOP = sp;return;
}
function _qspLocIndex($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $loc = 0, $uName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = HEAP32[320496>>2]|0;
 $3 = ($2|0)!=(0);
 do {
  if ($3) {
   $4 = $1;
   $5 = (_qspDelSpc($4)|0);
   $uName = $5;
   $6 = $uName;
   $7 = HEAP16[$6>>1]|0;
   $8 = ($7<<16>>16)!=(0);
   $9 = $uName;
   if (!($8)) {
    _free($9);
    $0 = -1;
    break;
   }
   _qspUpperStr($9);
   $10 = $uName;
   $11 = HEAP32[320492>>2]|0;
   $12 = HEAP32[320496>>2]|0;
   $13 = (_bsearch($10,$11,$12,8,72)|0);
   $loc = $13;
   $14 = $uName;
   _free($14);
   $15 = $loc;
   $16 = ($15|0)!=(0|0);
   if ($16) {
    $17 = $loc;
    $18 = HEAP32[$17>>2]|0;
    $0 = $18;
    break;
   } else {
    $0 = -1;
    break;
   }
  } else {
   $0 = -1;
  }
 } while(0);
 $19 = $0;
 STACKTOP = sp;return ($19|0);
}
function _qspExecLocByIndex($locInd,$isChangeDesc,$isNewLoc) {
 $locInd = $locInd|0;
 $isChangeDesc = $isChangeDesc|0;
 $isNewLoc = $isNewLoc|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $args = 0, $code = 0, $count = 0;
 var $i = 0, $loc = 0, $oldActIndex = 0, $oldLine = 0, $oldLoc = 0, $str = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $args = sp + 32|0;
 $code = sp + 24|0;
 $0 = $locInd;
 $1 = $isChangeDesc;
 $2 = $isNewLoc;
 $3 = HEAP32[320488>>2]|0;
 $4 = $0;
 $5 = (($3) + (($4*816)|0)|0);
 $loc = $5;
 $6 = HEAP32[320476>>2]|0;
 $oldLoc = $6;
 $7 = HEAP32[320484>>2]|0;
 $oldActIndex = $7;
 $8 = HEAP32[320480>>2]|0;
 $oldLine = $8;
 $9 = $0;
 HEAP32[320476>>2] = $9;
 HEAP32[320484>>2] = -1;
 HEAP32[320480>>2] = 0;
 $10 = $loc;
 $11 = ((($10)) + 4|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = (_qspFormatText($12,0)|0);
 $str = $13;
 $14 = ($13|0)!=(0|0);
 if (!($14)) {
  $15 = $oldLine;
  HEAP32[320480>>2] = $15;
  $16 = $oldActIndex;
  HEAP32[320484>>2] = $16;
  $17 = $oldLoc;
  HEAP32[320476>>2] = $17;
  STACKTOP = sp;return;
 }
 $18 = $1;
 $19 = ($18|0)!=(0);
 if ($19) {
  $20 = HEAP32[1628>>2]|0;
  $21 = ($20|0)!=(0|0);
  if ($21) {
   $22 = HEAP32[1628>>2]|0;
   _free($22);
  }
  $23 = $str;
  HEAP32[1628>>2] = $23;
  $24 = (_qspStrLen($23)|0);
  HEAP32[1632>>2] = $24;
  HEAP32[1660>>2] = 1;
 } else {
  $25 = $str;
  $26 = HEAP16[$25>>1]|0;
  $27 = ($26<<16>>16)!=(0);
  if ($27) {
   $28 = $str;
   $29 = HEAP32[1632>>2]|0;
   $30 = (_qspAddText(1628,$28,$29,-1,0)|0);
   HEAP32[1632>>2] = $30;
   HEAP32[1660>>2] = 1;
  }
  $31 = $str;
  _free($31);
 }
 $i = 0;
 while(1) {
  $32 = $i;
  $33 = ($32|0)<(50);
  if (!($33)) {
   label = 23;
   break;
  }
  $34 = $i;
  $35 = $loc;
  $36 = ((($35)) + 16|0);
  $37 = (($36) + ($34<<4)|0);
  $38 = ((($37)) + 4|0);
  $39 = HEAP32[$38>>2]|0;
  $str = $39;
  $40 = $str;
  $41 = ($40|0)!=(0|0);
  if (!($41)) {
   label = 23;
   break;
  }
  $42 = $str;
  $43 = HEAP16[$42>>1]|0;
  $44 = $43&65535;
  $45 = ($44|0)!=(0);
  if (!($45)) {
   label = 23;
   break;
  }
  $46 = $str;
  $47 = (_qspFormatText($46,0)|0);
  $str = $47;
  $48 = ($47|0)!=(0|0);
  if (!($48)) {
   label = 15;
   break;
  }
  $52 = $i;
  HEAP32[320484>>2] = $52;
  $53 = ((($args)) + 4|0);
  HEAP32[$53>>2] = 1;
  $54 = $str;
  HEAP32[$args>>2] = $54;
  $55 = $i;
  $56 = $loc;
  $57 = ((($56)) + 16|0);
  $58 = (($57) + ($55<<4)|0);
  $59 = HEAP32[$58>>2]|0;
  $str = $59;
  $60 = $str;
  $61 = ($60|0)!=(0|0);
  if ($61) {
   $62 = $str;
   $63 = HEAP16[$62>>1]|0;
   $64 = $63&65535;
   $65 = ($64|0)!=(0);
   if ($65) {
    $66 = ((($args)) + 8|0);
    $67 = ((($66)) + 4|0);
    HEAP32[$67>>2] = 1;
    $68 = $str;
    $69 = ((($args)) + 8|0);
    HEAP32[$69>>2] = $68;
    $count = 2;
   } else {
    label = 19;
   }
  } else {
   label = 19;
  }
  if ((label|0) == 19) {
   label = 0;
   $count = 1;
  }
  $70 = $count;
  $71 = $i;
  $72 = $loc;
  $73 = ((($72)) + 16|0);
  $74 = (($73) + ($71<<4)|0);
  $75 = ((($74)) + 8|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = $i;
  $78 = $loc;
  $79 = ((($78)) + 16|0);
  $80 = (($79) + ($77<<4)|0);
  $81 = ((($80)) + 12|0);
  $82 = HEAP32[$81>>2]|0;
  _qspAddAction($args,$70,$76,0,$82,1);
  $83 = HEAP32[$args>>2]|0;
  _free($83);
  $84 = HEAP32[320460>>2]|0;
  $85 = ($84|0)!=(0);
  if ($85) {
   label = 21;
   break;
  }
  $89 = $i;
  $90 = (($89) + 1)|0;
  $i = $90;
 }
 if ((label|0) == 15) {
  $49 = $oldLine;
  HEAP32[320480>>2] = $49;
  $50 = $oldActIndex;
  HEAP32[320484>>2] = $50;
  $51 = $oldLoc;
  HEAP32[320476>>2] = $51;
  STACKTOP = sp;return;
 }
 else if ((label|0) == 21) {
  $86 = $oldLine;
  HEAP32[320480>>2] = $86;
  $87 = $oldActIndex;
  HEAP32[320484>>2] = $87;
  $88 = $oldLoc;
  HEAP32[320476>>2] = $88;
  STACKTOP = sp;return;
 }
 else if ((label|0) == 23) {
  HEAP32[320484>>2] = -1;
  $91 = $0;
  $92 = HEAP32[320496>>2]|0;
  $93 = HEAP32[2952>>2]|0;
  $94 = (($92) - ($93))|0;
  $95 = ($91|0)<($94|0);
  $96 = $loc;
  if ($95) {
   $97 = ((($96)) + 8|0);
   $98 = HEAP32[$97>>2]|0;
   $99 = $loc;
   $100 = ((($99)) + 12|0);
   $101 = HEAP32[$100>>2]|0;
   $102 = $2;
   (_qspExecTopCodeWithLocals($98,$101,1,$102)|0);
  } else {
   $103 = ((($96)) + 12|0);
   $104 = HEAP32[$103>>2]|0;
   $count = $104;
   $105 = $loc;
   $106 = ((($105)) + 8|0);
   $107 = HEAP32[$106>>2]|0;
   $108 = $count;
   _qspCopyPrepLines($code,$107,0,$108);
   $109 = HEAP32[$code>>2]|0;
   $110 = $count;
   $111 = $2;
   (_qspExecTopCodeWithLocals($109,$110,1,$111)|0);
   $112 = HEAP32[$code>>2]|0;
   $113 = $count;
   _qspFreePrepLines($112,$113);
  }
  $114 = $oldLine;
  HEAP32[320480>>2] = $114;
  $115 = $oldActIndex;
  HEAP32[320484>>2] = $115;
  $116 = $oldLoc;
  HEAP32[320476>>2] = $116;
  STACKTOP = sp;return;
 }
}
function _qspExecLocByName($name,$isChangeDesc) {
 $name = $name|0;
 $isChangeDesc = $isChangeDesc|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $locInd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $isChangeDesc;
 $2 = $0;
 $3 = (_qspLocIndex($2)|0);
 $locInd = $3;
 $4 = $locInd;
 $5 = ($4|0)<(0);
 if ($5) {
  _qspSetError(111);
  STACKTOP = sp;return;
 } else {
  $6 = $locInd;
  $7 = $1;
  _qspExecLocByIndex($6,$7,0);
  STACKTOP = sp;return;
 }
}
function _qspExecLocByNameWithArgs($name,$args,$count) {
 $name = $name|0;
 $args = $args|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $local = 0, $oldRefreshCount = 0, $or$cond = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $local = sp + 8|0;
 $0 = $name;
 $1 = $args;
 $2 = $count;
 $3 = (_qspVarReference(446286,1)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = $var;
 _qspMoveVar($local,$5);
 $6 = $var;
 $7 = $1;
 $8 = $2;
 _qspSetArgs($6,$7,$8);
 $9 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $9;
 $10 = $0;
 _qspExecLocByName($10,0);
 $11 = HEAP32[320504>>2]|0;
 $12 = $oldRefreshCount;
 $13 = ($11|0)!=($12|0);
 $14 = HEAP32[320460>>2]|0;
 $15 = ($14|0)!=(0);
 $or$cond = $13 | $15;
 if ($or$cond) {
  _qspEmptyVar($local);
  STACKTOP = sp;return;
 }
 $16 = (_qspVarReference(446286,1)|0);
 $var = $16;
 $17 = ($16|0)!=(0|0);
 if ($17) {
  $18 = $var;
  _qspEmptyVar($18);
  $19 = $var;
  _qspMoveVar($19,$local);
  STACKTOP = sp;return;
 } else {
  _qspEmptyVar($local);
  STACKTOP = sp;return;
 }
}
function _qspExecLocByVarNameWithArgs($name,$args,$count) {
 $name = $name|0;
 $args = $args|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ind = 0, $locName = 0, $oldRefreshCount = 0, $or$cond = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $args;
 $2 = $count;
 $ind = 0;
 $3 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $3;
 while(1) {
  $4 = $0;
  $5 = (_qspVarReference($4,0)|0);
  $var = $5;
  $6 = ($5|0)!=(0|0);
  if (!($6)) {
   label = 8;
   break;
  }
  $7 = $ind;
  $8 = $var;
  $9 = ((($8)) + 8|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = ($7|0)>=($10|0);
  if ($11) {
   label = 8;
   break;
  }
  $12 = $ind;
  $13 = $var;
  $14 = ((($13)) + 4|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = (($15) + ($12<<3)|0);
  $17 = ((($16)) + 4|0);
  $18 = HEAP32[$17>>2]|0;
  $locName = $18;
  $19 = ($18|0)!=(0|0);
  if (!($19)) {
   label = 8;
   break;
  }
  $20 = $locName;
  $21 = (_qspIsAnyString($20)|0);
  $22 = ($21|0)!=(0);
  if (!($22)) {
   label = 8;
   break;
  }
  $23 = $locName;
  $24 = $1;
  $25 = $2;
  _qspExecLocByNameWithArgs($23,$24,$25);
  $26 = HEAP32[320504>>2]|0;
  $27 = $oldRefreshCount;
  $28 = ($26|0)!=($27|0);
  $29 = HEAP32[320460>>2]|0;
  $30 = ($29|0)!=(0);
  $or$cond = $28 | $30;
  if ($or$cond) {
   label = 8;
   break;
  }
  $31 = $ind;
  $32 = (($31) + 1)|0;
  $ind = $32;
 }
 if ((label|0) == 8) {
  STACKTOP = sp;return;
 }
}
function _qspRefreshCurLoc($isChangeDesc,$args,$count) {
 $isChangeDesc = $isChangeDesc|0;
 $args = $args|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $oldRefreshCount = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isChangeDesc;
 $1 = $args;
 $2 = $count;
 $3 = (_qspVarReference(446286,1)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = $var;
 _qspEmptyVar($5);
 $6 = $var;
 $7 = $1;
 $8 = $2;
 _qspSetArgs($6,$7,$8);
 _qspClearActions(0);
 $9 = HEAP32[320504>>2]|0;
 $10 = (($9) + 1)|0;
 HEAP32[320504>>2] = $10;
 $11 = $0;
 $12 = ($11|0)!=(0);
 if ($12) {
  $13 = HEAP32[320508>>2]|0;
  $14 = (($13) + 1)|0;
  HEAP32[320508>>2] = $14;
 }
 $15 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $15;
 $16 = HEAP32[320500>>2]|0;
 $17 = $0;
 _qspExecLocByIndex($16,$17,1);
 $18 = HEAP32[320460>>2]|0;
 $19 = ($18|0)!=(0);
 if ($19) {
  STACKTOP = sp;return;
 }
 $20 = HEAP32[320504>>2]|0;
 $21 = $oldRefreshCount;
 $22 = ($20|0)==($21|0);
 if (!($22)) {
  STACKTOP = sp;return;
 }
 $23 = $1;
 $24 = $2;
 _qspExecLocByVarNameWithArgs(445456,$23,$24);
 STACKTOP = sp;return;
}
function _qspLocsCompare($locName1,$locName2) {
 $locName1 = $locName1|0;
 $locName2 = $locName2|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $locName1;
 $1 = $locName2;
 $2 = $0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = $1;
 $6 = ((($5)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (_qspStrsComp($4,$7)|0);
 STACKTOP = sp;return ($8|0);
}
function _qspLocStringCompare($name,$compareTo) {
 $name = $name|0;
 $compareTo = $compareTo|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $name;
 $1 = $compareTo;
 $2 = $0;
 $3 = $1;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (_qspStrsComp($2,$5)|0);
 STACKTOP = sp;return ($6|0);
}
function _qspClearObjects($isFirst) {
 $isFirst = $isFirst|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $i = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $isFirst;
 $1 = $0;
 $2 = ($1|0)==(0);
 $3 = HEAP32[320512>>2]|0;
 $4 = ($3|0)!=(0);
 $or$cond = $2 & $4;
 if (!($or$cond)) {
  HEAP32[320512>>2] = 0;
  HEAP32[320516>>2] = -1;
  STACKTOP = sp;return;
 }
 $i = 0;
 while(1) {
  $5 = $i;
  $6 = HEAP32[320512>>2]|0;
  $7 = ($5|0)<($6|0);
  if (!($7)) {
   break;
  }
  $8 = $i;
  $9 = (320528 + ($8<<3)|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = ($10|0)!=(0|0);
  if ($11) {
   $12 = $i;
   $13 = (320528 + ($12<<3)|0);
   $14 = HEAP32[$13>>2]|0;
   _free($14);
  }
  $15 = $i;
  $16 = (320528 + ($15<<3)|0);
  $17 = ((($16)) + 4|0);
  $18 = HEAP32[$17>>2]|0;
  _free($18);
  $19 = $i;
  $20 = (($19) + 1)|0;
  $i = $20;
 }
 HEAP32[320520>>2] = 1;
 HEAP32[320512>>2] = 0;
 HEAP32[320516>>2] = -1;
 STACKTOP = sp;return;
}
function _qspClearObjectsWithNotify() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $objs = 0, $oldCount = 0, $oldRefreshCount = 0;
 var $or$cond = 0, $v = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $v = sp + 16|0;
 $0 = HEAP32[320512>>2]|0;
 $oldCount = $0;
 $1 = $oldCount;
 $2 = ($1|0)!=(0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = $oldCount;
 $4 = $3<<2;
 $5 = (_malloc($4)|0);
 $objs = $5;
 $i = 0;
 while(1) {
  $6 = $i;
  $7 = $oldCount;
  $8 = ($6|0)<($7|0);
  if (!($8)) {
   break;
  }
  $9 = $objs;
  $10 = $i;
  $11 = (($9) + ($10<<2)|0);
  $12 = $i;
  $13 = (320528 + ($12<<3)|0);
  $14 = ((($13)) + 4|0);
  $15 = HEAP32[$14>>2]|0;
  (_qspAddText($11,$15,0,-1,1)|0);
  $16 = $i;
  $17 = (($16) + 1)|0;
  $i = $17;
 }
 _qspClearObjects(0);
 $18 = ((($v)) + 4|0);
 HEAP32[$18>>2] = 1;
 $19 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $19;
 $i = 0;
 while(1) {
  $20 = $i;
  $21 = $oldCount;
  $22 = ($20|0)<($21|0);
  if (!($22)) {
   break;
  }
  $23 = $i;
  $24 = $objs;
  $25 = (($24) + ($23<<2)|0);
  $26 = HEAP32[$25>>2]|0;
  HEAP32[$v>>2] = $26;
  _qspExecLocByVarNameWithArgs(445474,$v,1);
  $27 = HEAP32[320504>>2]|0;
  $28 = $oldRefreshCount;
  $29 = ($27|0)!=($28|0);
  $30 = HEAP32[320460>>2]|0;
  $31 = ($30|0)!=(0);
  $or$cond = $29 | $31;
  if ($or$cond) {
   break;
  }
  $32 = $i;
  $33 = (($32) + 1)|0;
  $i = $33;
 }
 $34 = $objs;
 $35 = $oldCount;
 _qspFreeStrs($34,$35);
 STACKTOP = sp;return;
}
function _qspObjIndex($name) {
 $name = $name|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buf = 0, $bufSize = 0, $i = 0, $objNameLen = 0, $uName = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $name;
 $2 = HEAP32[320512>>2]|0;
 $3 = ($2|0)!=(0);
 if (!($3)) {
  $0 = -1;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 $4 = $1;
 $5 = (_qspGetNewText($4,-1)|0);
 $uName = $5;
 _qspUpperStr($5);
 $bufSize = 32;
 $6 = $bufSize;
 $7 = $6<<1;
 $8 = (_malloc($7)|0);
 $buf = $8;
 $i = 0;
 while(1) {
  $9 = $i;
  $10 = HEAP32[320512>>2]|0;
  $11 = ($9|0)<($10|0);
  if (!($11)) {
   label = 10;
   break;
  }
  $12 = $i;
  $13 = (320528 + ($12<<3)|0);
  $14 = ((($13)) + 4|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = (_qspStrLen($15)|0);
  $objNameLen = $16;
  $17 = $objNameLen;
  $18 = $bufSize;
  $19 = ($17|0)>=($18|0);
  if ($19) {
   $20 = $objNameLen;
   $21 = (($20) + 8)|0;
   $bufSize = $21;
   $22 = $buf;
   $23 = $bufSize;
   $24 = $23<<1;
   $25 = (_realloc($22,$24)|0);
   $buf = $25;
  }
  $26 = $buf;
  $27 = $i;
  $28 = (320528 + ($27<<3)|0);
  $29 = ((($28)) + 4|0);
  $30 = HEAP32[$29>>2]|0;
  (_qspStrCopy($26,$30)|0);
  $31 = $buf;
  _qspUpperStr($31);
  $32 = $buf;
  $33 = $uName;
  $34 = (_qspStrsComp($32,$33)|0);
  $35 = ($34|0)!=(0);
  if (!($35)) {
   label = 8;
   break;
  }
  $39 = $i;
  $40 = (($39) + 1)|0;
  $i = $40;
 }
 if ((label|0) == 8) {
  $36 = $uName;
  _free($36);
  $37 = $buf;
  _free($37);
  $38 = $i;
  $0 = $38;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 else if ((label|0) == 10) {
  $41 = $uName;
  _free($41);
  $42 = $buf;
  _free($42);
  $0 = -1;
  $43 = $0;
  STACKTOP = sp;return ($43|0);
 }
 return (0)|0;
}
function _qspStatementAddObject($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $i = 0, $imgPath = 0, $obj = 0, $objInd = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $args;
 $2 = $count;
 $3 = $jumpTo;
 $4 = $extArg;
 $5 = $2;
 $6 = ($5|0)==(3);
 do {
  if ($6) {
   $7 = $1;
   $8 = ((($7)) + 16|0);
   $9 = HEAP32[$8>>2]|0;
   $10 = (($9) - 1)|0;
   $objInd = $10;
   $11 = $objInd;
   $12 = ($11|0)<(0);
   if (!($12)) {
    $13 = $objInd;
    $14 = HEAP32[320512>>2]|0;
    $15 = ($13|0)>($14|0);
    if (!($15)) {
     break;
    }
   }
   $0 = 0;
   $59 = $0;
   STACKTOP = sp;return ($59|0);
  } else {
   $16 = HEAP32[320512>>2]|0;
   $objInd = $16;
  }
 } while(0);
 $17 = HEAP32[320512>>2]|0;
 $18 = ($17|0)==(1000);
 if ($18) {
  _qspSetError(121);
  $0 = 0;
  $59 = $0;
  STACKTOP = sp;return ($59|0);
 }
 $19 = HEAP32[320516>>2]|0;
 $20 = $objInd;
 $21 = ($19|0)>=($20|0);
 if ($21) {
  HEAP32[320516>>2] = -1;
 }
 $22 = $2;
 $23 = ($22|0)>=(2);
 if ($23) {
  $24 = $1;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = (_qspIsAnyString($26)|0);
  $28 = ($27|0)!=(0);
  if ($28) {
   $29 = $1;
   $30 = ((($29)) + 8|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = (_qspGetAbsFromRelPath($31)|0);
   $imgPath = $32;
  } else {
   label = 13;
  }
 } else {
  label = 13;
 }
 if ((label|0) == 13) {
  $imgPath = 0;
 }
 $33 = HEAP32[320512>>2]|0;
 $i = $33;
 while(1) {
  $34 = $i;
  $35 = $objInd;
  $36 = ($34|0)>($35|0);
  if (!($36)) {
   break;
  }
  $37 = $i;
  $38 = (320528 + ($37<<3)|0);
  $39 = $i;
  $40 = (($39) - 1)|0;
  $41 = (320528 + ($40<<3)|0);
  ;HEAP32[$38>>2]=HEAP32[$41>>2]|0;HEAP32[$38+4>>2]=HEAP32[$41+4>>2]|0;
  $42 = $i;
  $43 = (($42) + -1)|0;
  $i = $43;
 }
 $44 = HEAP32[320512>>2]|0;
 $45 = (($44) + 1)|0;
 HEAP32[320512>>2] = $45;
 $46 = $objInd;
 $47 = (320528 + ($46<<3)|0);
 $obj = $47;
 $48 = $imgPath;
 $49 = $obj;
 HEAP32[$49>>2] = $48;
 $50 = $1;
 $51 = HEAP32[$50>>2]|0;
 $52 = (_qspGetNewText($51,-1)|0);
 $53 = $obj;
 $54 = ((($53)) + 4|0);
 HEAP32[$54>>2] = $52;
 HEAP32[320520>>2] = 1;
 $55 = $2;
 $56 = ($55|0)==(3);
 if ($56) {
  $2 = 2;
 }
 $57 = $1;
 $58 = $2;
 _qspExecLocByVarNameWithArgs(445492,$57,$58);
 $0 = 0;
 $59 = $0;
 STACKTOP = sp;return ($59|0);
}
function _qspStatementDelObj($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 $4 = $3;
 L1: do {
  switch ($4|0) {
  case 0:  {
   $5 = $0;
   $6 = HEAP32[$5>>2]|0;
   $7 = (_qspObjIndex($6)|0);
   _qspRemoveObject($7);
   break;
  }
  case 1:  {
   $8 = $1;
   $9 = ($8|0)!=(0);
   if ($9) {
    $10 = $0;
    $11 = HEAP32[$10>>2]|0;
    $12 = (($11) - 1)|0;
    _qspRemoveObject($12);
    break L1;
   } else {
    _qspClearObjectsWithNotify();
    break L1;
   }
   break;
  }
  default: {
  }
  }
 } while(0);
 STACKTOP = sp;return 0;
}
function _qspStatementUnSelect($args,$count,$jumpTo,$extArg) {
 $args = $args|0;
 $count = $count|0;
 $jumpTo = $jumpTo|0;
 $extArg = $extArg|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $0 = $args;
 $1 = $count;
 $2 = $jumpTo;
 $3 = $extArg;
 HEAP32[320516>>2] = -1;
 STACKTOP = sp;return 0;
}
function _qspRemoveObject($index) {
 $index = $index|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $name = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $name = sp;
 $0 = $index;
 $1 = $0;
 $2 = ($1|0)<(0);
 if ($2) {
  STACKTOP = sp;return;
 }
 $3 = $0;
 $4 = HEAP32[320512>>2]|0;
 $5 = ($3|0)>=($4|0);
 if ($5) {
  STACKTOP = sp;return;
 }
 $6 = HEAP32[320516>>2]|0;
 $7 = $0;
 $8 = ($6|0)>=($7|0);
 if ($8) {
  HEAP32[320516>>2] = -1;
 }
 $9 = ((($name)) + 4|0);
 HEAP32[$9>>2] = 1;
 $10 = $0;
 $11 = (320528 + ($10<<3)|0);
 $12 = ((($11)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 HEAP32[$name>>2] = $13;
 $14 = $0;
 $15 = (320528 + ($14<<3)|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)!=(0|0);
 if ($17) {
  $18 = $0;
  $19 = (320528 + ($18<<3)|0);
  $20 = HEAP32[$19>>2]|0;
  _free($20);
 }
 $21 = HEAP32[320512>>2]|0;
 $22 = (($21) + -1)|0;
 HEAP32[320512>>2] = $22;
 while(1) {
  $23 = $0;
  $24 = HEAP32[320512>>2]|0;
  $25 = ($23|0)<($24|0);
  if (!($25)) {
   break;
  }
  $26 = $0;
  $27 = (320528 + ($26<<3)|0);
  $28 = $0;
  $29 = (($28) + 1)|0;
  $30 = (320528 + ($29<<3)|0);
  ;HEAP32[$27>>2]=HEAP32[$30>>2]|0;HEAP32[$27+4>>2]=HEAP32[$30+4>>2]|0;
  $31 = $0;
  $32 = (($31) + 1)|0;
  $0 = $32;
 }
 HEAP32[320520>>2] = 1;
 _qspExecLocByVarNameWithArgs(445474,$name,1);
 $33 = HEAP32[$name>>2]|0;
 _free($33);
 STACKTOP = sp;return;
}
function _qspInitStats() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer100 = 0, $vararg_buffer104 = 0;
 var $vararg_buffer109 = 0, $vararg_buffer111 = 0, $vararg_buffer114 = 0, $vararg_buffer117 = 0, $vararg_buffer12 = 0, $vararg_buffer120 = 0, $vararg_buffer122 = 0, $vararg_buffer125 = 0, $vararg_buffer128 = 0, $vararg_buffer131 = 0, $vararg_buffer134 = 0, $vararg_buffer137 = 0, $vararg_buffer140 = 0, $vararg_buffer144 = 0, $vararg_buffer146 = 0, $vararg_buffer149 = 0, $vararg_buffer152 = 0, $vararg_buffer155 = 0, $vararg_buffer158 = 0, $vararg_buffer16 = 0;
 var $vararg_buffer161 = 0, $vararg_buffer164 = 0, $vararg_buffer166 = 0, $vararg_buffer169 = 0, $vararg_buffer172 = 0, $vararg_buffer18 = 0, $vararg_buffer23 = 0, $vararg_buffer25 = 0, $vararg_buffer27 = 0, $vararg_buffer3 = 0, $vararg_buffer30 = 0, $vararg_buffer32 = 0, $vararg_buffer34 = 0, $vararg_buffer40 = 0, $vararg_buffer43 = 0, $vararg_buffer46 = 0, $vararg_buffer5 = 0, $vararg_buffer58 = 0, $vararg_buffer61 = 0, $vararg_buffer63 = 0;
 var $vararg_buffer65 = 0, $vararg_buffer7 = 0, $vararg_buffer77 = 0, $vararg_buffer89 = 0, $vararg_buffer9 = 0, $vararg_buffer92 = 0, $vararg_buffer95 = 0, $vararg_buffer97 = 0, $vararg_ptr103 = 0, $vararg_ptr107 = 0, $vararg_ptr108 = 0, $vararg_ptr143 = 0, $vararg_ptr15 = 0, $vararg_ptr175 = 0, $vararg_ptr176 = 0, $vararg_ptr177 = 0, $vararg_ptr178 = 0, $vararg_ptr179 = 0, $vararg_ptr180 = 0, $vararg_ptr181 = 0;
 var $vararg_ptr182 = 0, $vararg_ptr183 = 0, $vararg_ptr21 = 0, $vararg_ptr22 = 0, $vararg_ptr37 = 0, $vararg_ptr38 = 0, $vararg_ptr39 = 0, $vararg_ptr49 = 0, $vararg_ptr50 = 0, $vararg_ptr51 = 0, $vararg_ptr52 = 0, $vararg_ptr53 = 0, $vararg_ptr54 = 0, $vararg_ptr55 = 0, $vararg_ptr56 = 0, $vararg_ptr57 = 0, $vararg_ptr68 = 0, $vararg_ptr69 = 0, $vararg_ptr70 = 0, $vararg_ptr71 = 0;
 var $vararg_ptr72 = 0, $vararg_ptr73 = 0, $vararg_ptr74 = 0, $vararg_ptr75 = 0, $vararg_ptr76 = 0, $vararg_ptr80 = 0, $vararg_ptr81 = 0, $vararg_ptr82 = 0, $vararg_ptr83 = 0, $vararg_ptr84 = 0, $vararg_ptr85 = 0, $vararg_ptr86 = 0, $vararg_ptr87 = 0, $vararg_ptr88 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 576|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $vararg_buffer172 = sp + 528|0;
 $vararg_buffer169 = sp + 520|0;
 $vararg_buffer166 = sp + 512|0;
 $vararg_buffer164 = sp + 504|0;
 $vararg_buffer161 = sp + 496|0;
 $vararg_buffer158 = sp + 488|0;
 $vararg_buffer155 = sp + 480|0;
 $vararg_buffer152 = sp + 472|0;
 $vararg_buffer149 = sp + 464|0;
 $vararg_buffer146 = sp + 456|0;
 $vararg_buffer144 = sp + 448|0;
 $vararg_buffer140 = sp + 440|0;
 $vararg_buffer137 = sp + 432|0;
 $vararg_buffer134 = sp + 424|0;
 $vararg_buffer131 = sp + 416|0;
 $vararg_buffer128 = sp + 408|0;
 $vararg_buffer125 = sp + 400|0;
 $vararg_buffer122 = sp + 392|0;
 $vararg_buffer120 = sp + 384|0;
 $vararg_buffer117 = sp + 376|0;
 $vararg_buffer114 = sp + 368|0;
 $vararg_buffer111 = sp + 360|0;
 $vararg_buffer109 = sp + 352|0;
 $vararg_buffer104 = sp + 336|0;
 $vararg_buffer100 = sp + 328|0;
 $vararg_buffer97 = sp + 320|0;
 $vararg_buffer95 = sp + 312|0;
 $vararg_buffer92 = sp + 304|0;
 $vararg_buffer89 = sp + 296|0;
 $vararg_buffer77 = sp + 256|0;
 $vararg_buffer65 = sp + 216|0;
 $vararg_buffer63 = sp + 208|0;
 $vararg_buffer61 = sp + 200|0;
 $vararg_buffer58 = sp + 192|0;
 $vararg_buffer46 = sp + 152|0;
 $vararg_buffer43 = sp + 144|0;
 $vararg_buffer40 = sp + 136|0;
 $vararg_buffer34 = sp + 120|0;
 $vararg_buffer32 = sp + 112|0;
 $vararg_buffer30 = sp + 104|0;
 $vararg_buffer27 = sp + 96|0;
 $vararg_buffer25 = sp + 88|0;
 $vararg_buffer23 = sp + 80|0;
 $vararg_buffer18 = sp + 64|0;
 $vararg_buffer16 = sp + 56|0;
 $vararg_buffer12 = sp + 48|0;
 $vararg_buffer9 = sp + 40|0;
 $vararg_buffer7 = sp + 32|0;
 $vararg_buffer5 = sp + 24|0;
 $vararg_buffer3 = sp + 16|0;
 $vararg_buffer1 = sp + 8|0;
 $vararg_buffer = sp;
 $i = 0;
 while(1) {
  $0 = $i;
  $1 = ($0|0)<(3);
  if (!($1)) {
   break;
  }
  $2 = $i;
  $3 = (328532 + ($2<<2)|0);
  HEAP32[$3>>2] = 0;
  $4 = $i;
  $5 = (($4) + 1)|0;
  $i = $5;
 }
 HEAP32[328528>>2] = 0;
 _qspAddStatement(8,0,0,0,0,$vararg_buffer);
 HEAP32[$vararg_buffer1>>2] = 2;
 _qspAddStatement(7,0,0,1,1,$vararg_buffer1);
 _qspAddStatement(9,0,0,0,0,$vararg_buffer3);
 _qspAddStatement(5,0,0,0,0,$vararg_buffer5);
 _qspAddStatement(46,0,0,0,0,$vararg_buffer7);
 HEAP32[$vararg_buffer9>>2] = 2;
 _qspAddStatement(6,0,0,1,1,$vararg_buffer9);
 HEAP32[$vararg_buffer12>>2] = 1;
 $vararg_ptr15 = ((($vararg_buffer12)) + 4|0);
 HEAP32[$vararg_ptr15>>2] = 1;
 _qspAddStatement(3,0,0,1,2,$vararg_buffer12);
 _qspAddStatement(4,0,0,0,0,$vararg_buffer16);
 HEAP32[$vararg_buffer18>>2] = 1;
 $vararg_ptr21 = ((($vararg_buffer18)) + 4|0);
 HEAP32[$vararg_ptr21>>2] = 1;
 $vararg_ptr22 = ((($vararg_buffer18)) + 8|0);
 HEAP32[$vararg_ptr22>>2] = 2;
 _qspAddStatement(10,0,73,1,3,$vararg_buffer18);
 _qspAddStatement(11,3,74,0,0,$vararg_buffer23);
 _qspAddStatement(13,1,75,0,0,$vararg_buffer25);
 HEAP32[$vararg_buffer27>>2] = 1;
 _qspAddStatement(14,0,75,0,1,$vararg_buffer27);
 _qspAddStatement(15,4,74,0,0,$vararg_buffer30);
 _qspAddStatement(16,2,74,0,0,$vararg_buffer32);
 HEAP32[$vararg_buffer34>>2] = 1;
 $vararg_ptr37 = ((($vararg_buffer34)) + 4|0);
 HEAP32[$vararg_ptr37>>2] = 1;
 $vararg_ptr38 = ((($vararg_buffer34)) + 8|0);
 HEAP32[$vararg_ptr38>>2] = 2;
 $vararg_ptr39 = ((($vararg_buffer34)) + 12|0);
 HEAP32[$vararg_ptr39>>2] = 2;
 _qspAddStatement(17,0,76,2,4,$vararg_buffer34);
 HEAP32[$vararg_buffer40>>2] = 1;
 _qspAddStatement(18,0,77,1,1,$vararg_buffer40);
 HEAP32[$vararg_buffer43>>2] = 1;
 _qspAddStatement(19,0,78,1,1,$vararg_buffer43);
 HEAP32[$vararg_buffer46>>2] = 1;
 $vararg_ptr49 = ((($vararg_buffer46)) + 4|0);
 HEAP32[$vararg_ptr49>>2] = 0;
 $vararg_ptr50 = ((($vararg_buffer46)) + 8|0);
 HEAP32[$vararg_ptr50>>2] = 0;
 $vararg_ptr51 = ((($vararg_buffer46)) + 12|0);
 HEAP32[$vararg_ptr51>>2] = 0;
 $vararg_ptr52 = ((($vararg_buffer46)) + 16|0);
 HEAP32[$vararg_ptr52>>2] = 0;
 $vararg_ptr53 = ((($vararg_buffer46)) + 20|0);
 HEAP32[$vararg_ptr53>>2] = 0;
 $vararg_ptr54 = ((($vararg_buffer46)) + 24|0);
 HEAP32[$vararg_ptr54>>2] = 0;
 $vararg_ptr55 = ((($vararg_buffer46)) + 28|0);
 HEAP32[$vararg_ptr55>>2] = 0;
 $vararg_ptr56 = ((($vararg_buffer46)) + 32|0);
 HEAP32[$vararg_ptr56>>2] = 0;
 $vararg_ptr57 = ((($vararg_buffer46)) + 36|0);
 HEAP32[$vararg_ptr57>>2] = 0;
 _qspAddStatement(20,0,79,1,10,$vararg_buffer46);
 HEAP32[$vararg_buffer58>>2] = 1;
 _qspAddStatement(21,0,80,1,1,$vararg_buffer58);
 _qspAddStatement(22,0,81,0,0,$vararg_buffer61);
 _qspAddStatement(23,6,74,0,0,$vararg_buffer63);
 HEAP32[$vararg_buffer65>>2] = 1;
 $vararg_ptr68 = ((($vararg_buffer65)) + 4|0);
 HEAP32[$vararg_ptr68>>2] = 0;
 $vararg_ptr69 = ((($vararg_buffer65)) + 8|0);
 HEAP32[$vararg_ptr69>>2] = 0;
 $vararg_ptr70 = ((($vararg_buffer65)) + 12|0);
 HEAP32[$vararg_ptr70>>2] = 0;
 $vararg_ptr71 = ((($vararg_buffer65)) + 16|0);
 HEAP32[$vararg_ptr71>>2] = 0;
 $vararg_ptr72 = ((($vararg_buffer65)) + 20|0);
 HEAP32[$vararg_ptr72>>2] = 0;
 $vararg_ptr73 = ((($vararg_buffer65)) + 24|0);
 HEAP32[$vararg_ptr73>>2] = 0;
 $vararg_ptr74 = ((($vararg_buffer65)) + 28|0);
 HEAP32[$vararg_ptr74>>2] = 0;
 $vararg_ptr75 = ((($vararg_buffer65)) + 32|0);
 HEAP32[$vararg_ptr75>>2] = 0;
 $vararg_ptr76 = ((($vararg_buffer65)) + 36|0);
 HEAP32[$vararg_ptr76>>2] = 0;
 _qspAddStatement(24,0,82,1,10,$vararg_buffer65);
 HEAP32[$vararg_buffer77>>2] = 1;
 $vararg_ptr80 = ((($vararg_buffer77)) + 4|0);
 HEAP32[$vararg_ptr80>>2] = 0;
 $vararg_ptr81 = ((($vararg_buffer77)) + 8|0);
 HEAP32[$vararg_ptr81>>2] = 0;
 $vararg_ptr82 = ((($vararg_buffer77)) + 12|0);
 HEAP32[$vararg_ptr82>>2] = 0;
 $vararg_ptr83 = ((($vararg_buffer77)) + 16|0);
 HEAP32[$vararg_ptr83>>2] = 0;
 $vararg_ptr84 = ((($vararg_buffer77)) + 20|0);
 HEAP32[$vararg_ptr84>>2] = 0;
 $vararg_ptr85 = ((($vararg_buffer77)) + 24|0);
 HEAP32[$vararg_ptr85>>2] = 0;
 $vararg_ptr86 = ((($vararg_buffer77)) + 28|0);
 HEAP32[$vararg_ptr86>>2] = 0;
 $vararg_ptr87 = ((($vararg_buffer77)) + 32|0);
 HEAP32[$vararg_ptr87>>2] = 0;
 $vararg_ptr88 = ((($vararg_buffer77)) + 36|0);
 HEAP32[$vararg_ptr88>>2] = 0;
 _qspAddStatement(25,1,83,1,10,$vararg_buffer77);
 HEAP32[$vararg_buffer89>>2] = 1;
 _qspAddStatement(26,1,84,1,1,$vararg_buffer89);
 HEAP32[$vararg_buffer92>>2] = 1;
 _qspAddStatement(27,0,85,1,1,$vararg_buffer92);
 _qspAddStatement(28,5,74,0,0,$vararg_buffer95);
 HEAP32[$vararg_buffer97>>2] = 2;
 _qspAddStatement(29,1,78,0,1,$vararg_buffer97);
 HEAP32[$vararg_buffer100>>2] = 1;
 $vararg_ptr103 = ((($vararg_buffer100)) + 4|0);
 HEAP32[$vararg_ptr103>>2] = 2;
 _qspAddStatement(30,0,86,0,2,$vararg_buffer100);
 HEAP32[$vararg_buffer104>>2] = 1;
 $vararg_ptr107 = ((($vararg_buffer104)) + 4|0);
 HEAP32[$vararg_ptr107>>2] = 2;
 $vararg_ptr108 = ((($vararg_buffer104)) + 8|0);
 HEAP32[$vararg_ptr108>>2] = 2;
 _qspAddStatement(32,0,87,1,3,$vararg_buffer104);
 _qspAddStatement(31,1,74,0,0,$vararg_buffer109);
 HEAP32[$vararg_buffer111>>2] = 1;
 _qspAddStatement(33,5,88,0,1,$vararg_buffer111);
 HEAP32[$vararg_buffer114>>2] = 1;
 _qspAddStatement(34,3,88,0,1,$vararg_buffer114);
 HEAP32[$vararg_buffer117>>2] = 1;
 _qspAddStatement(35,1,88,1,1,$vararg_buffer117);
 _qspAddStatement(12,0,74,0,0,$vararg_buffer120);
 HEAP32[$vararg_buffer122>>2] = 1;
 _qspAddStatement(37,4,88,0,1,$vararg_buffer122);
 HEAP32[$vararg_buffer125>>2] = 1;
 _qspAddStatement(41,2,88,0,1,$vararg_buffer125);
 HEAP32[$vararg_buffer128>>2] = 1;
 _qspAddStatement(42,0,88,1,1,$vararg_buffer128);
 HEAP32[$vararg_buffer131>>2] = 1;
 _qspAddStatement(36,0,89,1,1,$vararg_buffer131);
 HEAP32[$vararg_buffer134>>2] = 1;
 _qspAddStatement(38,0,90,0,1,$vararg_buffer134);
 HEAP32[$vararg_buffer137>>2] = 1;
 _qspAddStatement(39,0,84,1,1,$vararg_buffer137);
 HEAP32[$vararg_buffer140>>2] = 1;
 $vararg_ptr143 = ((($vararg_buffer140)) + 4|0);
 HEAP32[$vararg_ptr143>>2] = 2;
 _qspAddStatement(40,0,91,1,2,$vararg_buffer140);
 _qspAddStatement(43,0,92,0,0,$vararg_buffer144);
 HEAP32[$vararg_buffer146>>2] = 1;
 _qspAddStatement(44,0,93,0,1,$vararg_buffer146);
 HEAP32[$vararg_buffer149>>2] = 2;
 _qspAddStatement(45,0,94,1,1,$vararg_buffer149);
 HEAP32[$vararg_buffer152>>2] = 2;
 _qspAddStatement(47,0,95,1,1,$vararg_buffer152);
 HEAP32[$vararg_buffer155>>2] = 2;
 _qspAddStatement(48,3,95,1,1,$vararg_buffer155);
 HEAP32[$vararg_buffer158>>2] = 2;
 _qspAddStatement(49,1,95,1,1,$vararg_buffer158);
 HEAP32[$vararg_buffer161>>2] = 2;
 _qspAddStatement(50,2,95,1,1,$vararg_buffer161);
 _qspAddStatement(51,0,96,0,0,$vararg_buffer164);
 HEAP32[$vararg_buffer166>>2] = 1;
 _qspAddStatement(52,0,97,0,1,$vararg_buffer166);
 HEAP32[$vararg_buffer169>>2] = 2;
 _qspAddStatement(53,0,98,1,1,$vararg_buffer169);
 HEAP32[$vararg_buffer172>>2] = 1;
 $vararg_ptr175 = ((($vararg_buffer172)) + 4|0);
 HEAP32[$vararg_ptr175>>2] = 0;
 $vararg_ptr176 = ((($vararg_buffer172)) + 8|0);
 HEAP32[$vararg_ptr176>>2] = 0;
 $vararg_ptr177 = ((($vararg_buffer172)) + 12|0);
 HEAP32[$vararg_ptr177>>2] = 0;
 $vararg_ptr178 = ((($vararg_buffer172)) + 16|0);
 HEAP32[$vararg_ptr178>>2] = 0;
 $vararg_ptr179 = ((($vararg_buffer172)) + 20|0);
 HEAP32[$vararg_ptr179>>2] = 0;
 $vararg_ptr180 = ((($vararg_buffer172)) + 24|0);
 HEAP32[$vararg_ptr180>>2] = 0;
 $vararg_ptr181 = ((($vararg_buffer172)) + 28|0);
 HEAP32[$vararg_ptr181>>2] = 0;
 $vararg_ptr182 = ((($vararg_buffer172)) + 32|0);
 HEAP32[$vararg_ptr182>>2] = 0;
 $vararg_ptr183 = ((($vararg_buffer172)) + 36|0);
 HEAP32[$vararg_ptr183>>2] = 0;
 _qspAddStatement(54,0,83,1,10,$vararg_buffer172);
 _qspAddStatName(8,445510,2);
 _qspAddStatName(7,445520,1);
 _qspAddStatName(9,445534,2);
 _qspAddStatName(5,445542,2);
 _qspAddStatName(46,445554,2);
 _qspAddStatName(46,445562,2);
 _qspAddStatName(6,445570,2);
 _qspAddStatName(3,445576,2);
 _qspAddStatName(4,445584,2);
 _qspAddStatName(10,445592,2);
 _qspAddStatName(10,445606,2);
 _qspAddStatName(11,445622,2);
 _qspAddStatName(13,445630,1);
 _qspAddStatName(14,445650,2);
 _qspAddStatName(15,445662,2);
 _qspAddStatName(16,445670,2);
 _qspAddStatName(16,445688,2);
 _qspAddStatName(17,445702,2);
 _qspAddStatName(18,445718,2);
 _qspAddStatName(18,445732,2);
 _qspAddStatName(19,445748,2);
 _qspAddStatName(19,445762,2);
 _qspAddStatName(20,445778,2);
 _qspAddStatName(21,445794,2);
 _qspAddStatName(22,445804,2);
 _qspAddStatName(23,445814,2);
 _qspAddStatName(24,445830,2);
 _qspAddStatName(24,445842,2);
 _qspAddStatName(25,445848,2);
 _qspAddStatName(25,445858,2);
 _qspAddStatName(26,445864,2);
 _qspAddStatName(27,445878,2);
 _qspAddStatName(28,445888,2);
 _qspAddStatName(29,445904,2);
 _qspAddStatName(30,445920,2);
 _qspAddStatName(32,445936,2);
 _qspAddStatName(31,445946,2);
 _qspAddStatName(31,445960,2);
 _qspAddStatName(33,445970,2);
 _qspAddStatName(34,445978,1);
 _qspAddStatName(35,445986,2);
 _qspAddStatName(12,445992,2);
 _qspAddStatName(12,446004,2);
 _qspAddStatName(37,446012,2);
 _qspAddStatName(41,446018,1);
 _qspAddStatName(42,446024,2);
 _qspAddStatName(36,446028,2);
 _qspAddStatName(38,446036,2);
 _qspAddStatName(39,446054,2);
 _qspAddStatName(40,446070,0);
 _qspAddStatName(43,446080,2);
 _qspAddStatName(44,446094,2);
 _qspAddStatName(45,446112,1);
 _qspAddStatName(47,446130,2);
 _qspAddStatName(48,446148,2);
 _qspAddStatName(49,446168,2);
 _qspAddStatName(50,446186,2);
 _qspAddStatName(51,446204,1);
 _qspAddStatName(51,446222,2);
 _qspAddStatName(52,446234,2);
 _qspAddStatName(53,446244,2);
 _qspAddStatName(54,446254,2);
 _qspAddStatName(54,446266,2);
 $i = 0;
 while(1) {
  $6 = $i;
  $7 = ($6|0)<(3);
  if (!($7)) {
   break;
  }
  $8 = $i;
  $9 = (328544 + (($8*1200)|0)|0);
  $10 = $i;
  $11 = (328532 + ($10<<2)|0);
  $12 = HEAP32[$11>>2]|0;
  _qsort($9,$12,12,99);
  $13 = $i;
  $14 = (($13) + 1)|0;
  $i = $14;
 }
 STACKTOP = sp;return;
}
function _qspGetStatArgs($s,$statCode,$args) {
 $s = $s|0;
 $statCode = $statCode|0;
 $args = $args|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $brack = 0, $count = 0, $oldRefreshCount = 0, $or$cond = 0, $or$cond3 = 0, $pos = 0, $type = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $4 = sp + 8|0;
 $5 = sp;
 $1 = $s;
 $2 = $statCode;
 $3 = $args;
 $count = 0;
 $brack = 0;
 $6 = $1;
 $7 = (_qspSkipSpaces($6)|0);
 $1 = $7;
 $8 = $1;
 $9 = HEAP16[$8>>1]|0;
 $10 = $9&65535;
 $11 = HEAP16[446274>>1]|0;
 $12 = $11&65535;
 $13 = ($10|0)==($12|0);
 do {
  if ($13) {
   $14 = $1;
   $15 = (_qspStrPos($14,446278,0)|0);
   $brack = $15;
   $16 = ($15|0)!=(0|0);
   if (!($16)) {
    _qspSetError(116);
    $0 = 0;
    $106 = $0;
    STACKTOP = sp;return ($106|0);
   }
   $17 = $brack;
   $18 = ((($17)) + 2|0);
   $19 = (_qspIsAnyString($18)|0);
   $20 = ($19|0)!=(0);
   if ($20) {
    $brack = 0;
    break;
   } else {
    $21 = $brack;
    HEAP16[$21>>1] = 0;
    $22 = $1;
    $23 = ((($22)) + 2|0);
    $24 = (_qspSkipSpaces($23)|0);
    $1 = $24;
    break;
   }
  }
 } while(0);
 $25 = $1;
 $26 = HEAP16[$25>>1]|0;
 $27 = ($26<<16>>16)!=(0);
 if ($27) {
  $28 = HEAP32[320504>>2]|0;
  $oldRefreshCount = $28;
  while(1) {
   $29 = $count;
   $30 = $2;
   $31 = (332144 + (($30*56)|0)|0);
   $32 = ((($31)) + 4|0);
   $33 = HEAP32[$32>>2]|0;
   $34 = ($29|0)==($33|0);
   if ($34) {
    label = 10;
    break;
   }
   $35 = $1;
   $36 = (_qspStrPos($35,446282,0)|0);
   $pos = $36;
   $37 = $pos;
   $38 = ($37|0)!=(0|0);
   if ($38) {
    $39 = $pos;
    HEAP16[$39>>1] = 0;
    $40 = $count;
    $41 = $3;
    $42 = (($41) + ($40<<3)|0);
    $43 = $1;
    _qspExprValue($4,$43);
    ;HEAP32[$42>>2]=HEAP32[$4>>2]|0;HEAP32[$42+4>>2]=HEAP32[$4+4>>2]|0;
    $44 = HEAP16[446282>>1]|0;
    $45 = $pos;
    HEAP16[$45>>1] = $44;
   } else {
    $46 = $count;
    $47 = $3;
    $48 = (($47) + ($46<<3)|0);
    $49 = $1;
    _qspExprValue($5,$49);
    ;HEAP32[$48>>2]=HEAP32[$5>>2]|0;HEAP32[$48+4>>2]=HEAP32[$5+4>>2]|0;
   }
   $50 = HEAP32[320504>>2]|0;
   $51 = $oldRefreshCount;
   $52 = ($50|0)!=($51|0);
   $53 = HEAP32[320460>>2]|0;
   $54 = ($53|0)!=(0);
   $or$cond = $52 | $54;
   if ($or$cond) {
    break;
   }
   $55 = $count;
   $56 = $2;
   $57 = (332144 + (($56*56)|0)|0);
   $58 = ((($57)) + 8|0);
   $59 = (($58) + ($55<<2)|0);
   $60 = HEAP32[$59>>2]|0;
   $type = $60;
   $61 = $type;
   $62 = ($61|0)!=(0);
   if ($62) {
    $63 = $3;
    $64 = $count;
    $65 = (($63) + ($64<<3)|0);
    $66 = $type;
    $67 = ($66|0)==(1);
    $68 = $67&1;
    $69 = (_qspConvertVariantTo($65,$68)|0);
    $70 = ($69|0)!=(0);
    if ($70) {
     label = 17;
     break;
    }
   }
   $73 = $count;
   $74 = (($73) + 1)|0;
   $count = $74;
   $75 = $pos;
   $76 = ($75|0)!=(0|0);
   if (!($76)) {
    break;
   }
   $77 = $pos;
   $78 = ((($77)) + 2|0);
   $79 = (_qspSkipSpaces($78)|0);
   $1 = $79;
   $80 = $1;
   $81 = HEAP16[$80>>1]|0;
   $82 = ($81<<16>>16)!=(0);
   if (!($82)) {
    label = 20;
    break;
   }
  }
  if ((label|0) == 10) {
   _qspSetError(120);
  }
  else if ((label|0) == 17) {
   _qspSetError(101);
   $71 = $count;
   $72 = (($71) + 1)|0;
   $count = $72;
  }
  else if ((label|0) == 20) {
   _qspSetError(118);
  }
  $83 = HEAP32[320504>>2]|0;
  $84 = $oldRefreshCount;
  $85 = ($83|0)!=($84|0);
  $86 = HEAP32[320460>>2]|0;
  $87 = ($86|0)!=(0);
  $or$cond3 = $85 | $87;
  if ($or$cond3) {
   $88 = $3;
   $89 = $count;
   _qspFreeVariants($88,$89);
   $90 = $brack;
   $91 = ($90|0)!=(0|0);
   if ($91) {
    $92 = HEAP16[446278>>1]|0;
    $93 = $brack;
    HEAP16[$93>>1] = $92;
   }
   $0 = 0;
   $106 = $0;
   STACKTOP = sp;return ($106|0);
  }
 }
 $94 = $brack;
 $95 = ($94|0)!=(0|0);
 if ($95) {
  $96 = HEAP16[446278>>1]|0;
  $97 = $brack;
  HEAP16[$97>>1] = $96;
 }
 $98 = $count;
 $99 = $2;
 $100 = (332144 + (($99*56)|0)|0);
 $101 = HEAP32[$100>>2]|0;
 $102 = ($98|0)<($101|0);
 if ($102) {
  _qspSetError(120);
  $103 = $3;
  $104 = $count;
  _qspFreeVariants($103,$104);
  $0 = 0;
  $106 = $0;
  STACKTOP = sp;return ($106|0);
 } else {
  $105 = $count;
  $0 = $105;
  $106 = $0;
  STACKTOP = sp;return ($106|0);
 }
 return (0)|0;
}
function _qspExecTopCodeWithLocals($s,$endLine,$codeOffset,$isNewLoc) {
 $s = $s|0;
 $endLine = $endLine|0;
 $codeOffset = $codeOffset|0;
 $isNewLoc = $isNewLoc|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $groupsCount = 0, $isExit = 0, $oldRefreshCount = 0;
 var $or$cond = 0, $savedGroups = 0, $savedVars = 0, $varsCount = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $savedVars = sp + 16|0;
 $1 = $s;
 $2 = $endLine;
 $3 = $codeOffset;
 $4 = $isNewLoc;
 $5 = $4;
 $6 = ($5|0)!=(0);
 if ($6) {
  _qspPrepareGlobalVars();
 } else {
  $7 = (_qspPrepareLocalVars($savedVars)|0);
  $varsCount = $7;
 }
 $8 = HEAP32[320460>>2]|0;
 $9 = ($8|0)!=(0);
 if ($9) {
  $0 = 0;
  $56 = $0;
  STACKTOP = sp;return ($56|0);
 }
 $10 = HEAP32[12644>>2]|0;
 $groupsCount = $10;
 $11 = HEAP32[12640>>2]|0;
 $savedGroups = $11;
 HEAP32[12644>>2] = 1;
 $12 = (_malloc(8)|0);
 HEAP32[12640>>2] = $12;
 $13 = HEAP32[12640>>2]|0;
 HEAP32[$13>>2] = 0;
 $14 = HEAP32[12640>>2]|0;
 $15 = ((($14)) + 4|0);
 HEAP32[$15>>2] = 0;
 $16 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $16;
 $17 = $1;
 $18 = $2;
 $19 = $3;
 $20 = (_qspExecCode($17,0,$18,$19,0)|0);
 $isExit = $20;
 $21 = $oldRefreshCount;
 $22 = HEAP32[320504>>2]|0;
 $23 = ($21|0)!=($22|0);
 $24 = HEAP32[320460>>2]|0;
 $25 = ($24|0)!=(0);
 $or$cond = $23 | $25;
 do {
  if ($or$cond) {
   $26 = HEAP32[12644>>2]|0;
   $27 = ($26|0)!=(0);
   if ($27) {
    $28 = HEAP32[12640>>2]|0;
    $29 = HEAP32[$28>>2]|0;
    $30 = HEAP32[12640>>2]|0;
    $31 = ((($30)) + 4|0);
    $32 = HEAP32[$31>>2]|0;
    _qspClearVarsList($29,$32);
   }
   $33 = $4;
   $34 = ($33|0)!=(0);
   if (!($34)) {
    $35 = HEAP32[$savedVars>>2]|0;
    $36 = $varsCount;
    _qspClearLocalVars($35,$36);
   }
  } else {
   $37 = HEAP32[12640>>2]|0;
   $38 = HEAP32[$37>>2]|0;
   $39 = HEAP32[12640>>2]|0;
   $40 = ((($39)) + 4|0);
   $41 = HEAP32[$40>>2]|0;
   _qspRestoreVarsList($38,$41);
   $42 = $4;
   $43 = ($42|0)!=(0);
   if (!($43)) {
    $44 = HEAP32[320460>>2]|0;
    $45 = ($44|0)!=(0);
    $46 = HEAP32[$savedVars>>2]|0;
    $47 = $varsCount;
    if ($45) {
     _qspClearLocalVars($46,$47);
     break;
    } else {
     $48 = $savedGroups;
     $49 = $groupsCount;
     _qspRestoreLocalVars($46,$47,$48,$49);
     break;
    }
   }
  }
 } while(0);
 $50 = HEAP32[12640>>2]|0;
 $51 = ($50|0)!=(0|0);
 if ($51) {
  $52 = HEAP32[12640>>2]|0;
  _free($52);
 }
 $53 = $savedGroups;
 HEAP32[12640>>2] = $53;
 $54 = $groupsCount;
 HEAP32[12644>>2] = $54;
 $55 = $isExit;
 $0 = $55;
 $56 = $0;
 STACKTOP = sp;return ($56|0);
}
function _qspExecStringAsCodeWithArgs($s,$args,$count) {
 $s = $s|0;
 $args = $args|0;
 $count = $count|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $local = 0, $oldRefreshCount = 0, $or$cond = 0, $strs = 0, $var = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $strs = sp + 32|0;
 $local = sp + 8|0;
 $0 = $s;
 $1 = $args;
 $2 = $count;
 $3 = (_qspVarReference(446286,1)|0);
 $var = $3;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = $var;
 _qspMoveVar($local,$5);
 $6 = $var;
 $7 = $1;
 $8 = $2;
 _qspSetArgs($6,$7,$8);
 $9 = $0;
 $10 = (_qspPreprocessData($9,$strs)|0);
 $2 = $10;
 $11 = HEAP32[320504>>2]|0;
 $oldRefreshCount = $11;
 $12 = HEAP32[$strs>>2]|0;
 $13 = $2;
 (_qspExecCodeBlockWithLocals($12,0,$13,0,0)|0);
 $14 = HEAP32[$strs>>2]|0;
 $15 = $2;
 _qspFreePrepLines($14,$15);
 $16 = HEAP32[320504>>2]|0;
 $17 = $oldRefreshCount;
 $18 = ($16|0)!=($17|0);
 $19 = HEAP32[320460>>2]|0;
 $20 = ($19|0)!=(0);
 $or$cond = $18 | $20;
 if ($or$cond) {
  _qspEmptyVar($local);
  STACKTOP = sp;return;
 }
 $21 = (_qspVarReference(446286,1)|0);
 $var = $21;
 $22 = ($21|0)!=(0|0);
 if ($22) {
  $23 = $var;
  _qspEmptyVar($23);
  $24 = $var;
  _qspMoveVar($24,$local);
  STACKTOP = sp;return;
 } else {
  _qspEmptyVar($local);
  STACKTOP = sp;return;
 }
}
function _qspGetLineLabel($str) {
 $str = $str|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $delimPos = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $1 = $str;
 $2 = $1;
 $3 = (_qspSkipSpaces($2)|0);
 $1 = $3;
 $4 = $1;
 $5 = HEAP16[$4>>1]|0;
 $6 = $5&65535;
 $7 = HEAP16[446296>>1]|0;
 $8 = $7&65535;
 $9 = ($6|0)==($8|0);
 if (!($9)) {
  $0 = 0;
  $26 = $0;
  STACKTOP = sp;return ($26|0);
 }
 $10 = $1;
 $11 = HEAP16[446300>>1]|0;
 $12 = (_qspStrChar($10,$11)|0);
 $delimPos = $12;
 $13 = $delimPos;
 $14 = ($13|0)!=(0|0);
 if ($14) {
  $15 = $delimPos;
  HEAP16[$15>>1] = 0;
  $16 = $1;
  $17 = ((($16)) + 2|0);
  $18 = (_qspDelSpc($17)|0);
  $1 = $18;
  $19 = HEAP16[446300>>1]|0;
  $20 = $delimPos;
  HEAP16[$20>>1] = $19;
 } else {
  $21 = $1;
  $22 = ((($21)) + 2|0);
  $23 = (_qspDelSpc($22)|0);
  $1 = $23;
 }
 $24 = $1;
 _qspUpperStr($24);
 $25 = $1;
 $0 = $25;
 $26 = $0;
 STACKTOP = sp;return ($26|0);
}
function _qspInitLineOfCode($line,$str,$lineNum) {
 $line = $line|0;
 $str = $str|0;
 $lineNum = $lineNum|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0;
 var $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0;
 var $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0;
 var $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0;
 var $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $buf = 0, $ch = 0, $count = 0, $delimPos = 0, $elsePos = 0, $isInLoop = 0, $isSearchElse = 0, $nextPos = 0, $or$cond = 0;
 var $or$cond3 = 0, $or$cond5 = 0, $or$cond7 = 0, $or$cond9 = 0, $paramPos = 0, $statCode = 0, $temp = 0, $uStr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abort();
 $paramPos = sp;
 $0 = $line;
 $1 = $str;
 $2 = $lineNum;
 $count = 0;
 $delimPos = 0;
 HEAP32[$paramPos>>2] = 0;
 $3 = $1;
 $4 = $0;
 HEAP32[$4>>2] = $3;
 $5 = $2;
 $6 = $0;
 $7 = ((($6)) + 4|0);
 HEAP32[$7>>2] = $5;
 $8 = $0;
 $9 = ((($8)) + 20|0);
 HEAP32[$9>>2] = 0;
 $10 = $0;
 $11 = ((($10)) + 16|0);
 HEAP32[$11>>2] = 0;
 $12 = $1;
 $13 = (_qspSkipSpaces($12)|0);
 $buf = $13;
 $14 = $buf;
 $15 = (_qspGetStatCode($14,$paramPos)|0);
 $statCode = $15;
 $16 = $buf;
 $17 = HEAP16[$16>>1]|0;
 $18 = $17&65535;
 $19 = ($18|0)!=(0);
 $20 = $statCode;
 $21 = ($20|0)!=(2);
 $or$cond = $19 & $21;
 if ($or$cond) {
  $isSearchElse = 1;
  $isInLoop = 1;
  $elsePos = 0;
  $22 = $1;
  $23 = (_qspGetNewText($22,-1)|0);
  $uStr = $23;
  _qspUpperStr($23);
  $24 = $statCode;
  switch ($24|0) {
  case 7: case 6: case 4: case 3:  {
   $25 = $buf;
   $26 = (_qspStrPos($25,446296,0)|0);
   $delimPos = $26;
   $27 = $delimPos;
   $28 = ($27|0)!=(0|0);
   if ($28) {
    $29 = $delimPos;
    $30 = ((($29)) + 2|0);
    $nextPos = $30;
    $31 = $nextPos;
    $32 = HEAP16[$31>>1]|0;
    $33 = ($32<<16>>16)!=(0);
    if (!($33)) {
     $isInLoop = 0;
    }
   }
   break;
  }
  case 8:  {
   $34 = HEAP32[$paramPos>>2]|0;
   $35 = (_qspSkipSpaces($34)|0);
   $nextPos = $35;
   $36 = $nextPos;
   $37 = HEAP16[$36>>1]|0;
   $38 = $37&65535;
   $39 = HEAP16[446296>>1]|0;
   $40 = $39&65535;
   $41 = ($38|0)==($40|0);
   if ($41) {
    $42 = $nextPos;
    $43 = ((($42)) + 2|0);
    $nextPos = $43;
   }
   $44 = $nextPos;
   $45 = HEAP16[$44>>1]|0;
   $46 = $45&65535;
   $47 = ($46|0)!=(0);
   $48 = $nextPos;
   $49 = $47 ? $48 : 0;
   $delimPos = $49;
   break;
  }
  default: {
   $50 = $buf;
   $51 = (_qspStrPos($50,446300,0)|0);
   $delimPos = $51;
   $52 = $delimPos;
   $53 = ($52|0)!=(0|0);
   if ($53) {
    $54 = $delimPos;
    $55 = ((($54)) + 2|0);
    $nextPos = $55;
   }
   $56 = $uStr;
   $57 = $buf;
   $58 = $1;
   $59 = $57;
   $60 = $58;
   $61 = (($59) - ($60))|0;
   $62 = (($61|0) / 2)&-1;
   $63 = (($56) + ($62<<1)|0);
   $64 = (_qspStrPos($63,445510,1)|0);
   $elsePos = $64;
   $65 = $elsePos;
   $66 = ($65|0)!=(0|0);
   if ($66) {
    $67 = $1;
    $68 = $elsePos;
    $69 = $uStr;
    $70 = $68;
    $71 = $69;
    $72 = (($70) - ($71))|0;
    $73 = (($72|0) / 2)&-1;
    $74 = (($67) + ($73<<1)|0);
    $elsePos = $74;
   } else {
    $isSearchElse = 0;
   }
   $75 = $elsePos;
   $76 = ($75|0)!=(0|0);
   do {
    if ($76) {
     $77 = $delimPos;
     $78 = ($77|0)!=(0|0);
     if ($78) {
      $79 = $elsePos;
      $80 = $delimPos;
      $81 = ($79>>>0)<($80>>>0);
      if (!($81)) {
       break;
      }
     }
     $82 = $elsePos;
     $delimPos = $82;
     $nextPos = $82;
     $elsePos = 0;
    }
   } while(0);
   $83 = $statCode;
   $84 = ($83|0)==(0);
   if ($84) {
    $85 = $buf;
    $86 = $delimPos;
    $87 = ($85|0)!=($86|0);
    if ($87) {
     $88 = $delimPos;
     $89 = ($88|0)!=(0|0);
     if ($89) {
      $90 = $delimPos;
      HEAP16[$90>>1] = 0;
      $91 = $buf;
      $92 = (_qspStrPos($91,446304,0)|0);
      $temp = $92;
      $93 = HEAP16[446300>>1]|0;
      $94 = $delimPos;
      HEAP16[$94>>1] = $93;
     } else {
      $95 = $buf;
      $96 = (_qspStrPos($95,446304,0)|0);
      $temp = $96;
     }
     $97 = $temp;
     $98 = ($97|0)!=(0|0);
     $99 = $98 ? 46 : 34;
     $statCode = $99;
    }
   }
  }
  }
  L31: while(1) {
   $100 = $delimPos;
   $101 = ($100|0)!=(0|0);
   $102 = $isInLoop;
   $103 = ($102|0)!=(0);
   $104 = $101 ? $103 : 0;
   if (!($104)) {
    break;
   }
   $105 = $0;
   $106 = ((($105)) + 20|0);
   $107 = HEAP32[$106>>2]|0;
   $108 = (($107) + 1)|0;
   HEAP32[$106>>2] = $108;
   $109 = $0;
   $110 = ((($109)) + 16|0);
   $111 = HEAP32[$110>>2]|0;
   $112 = $0;
   $113 = ((($112)) + 20|0);
   $114 = HEAP32[$113>>2]|0;
   $115 = ($114*12)|0;
   $116 = (_realloc($111,$115)|0);
   $117 = $0;
   $118 = ((($117)) + 16|0);
   HEAP32[$118>>2] = $116;
   $119 = $statCode;
   $120 = $count;
   $121 = $0;
   $122 = ((($121)) + 16|0);
   $123 = HEAP32[$122>>2]|0;
   $124 = (($123) + (($120*12)|0)|0);
   HEAP32[$124>>2] = $119;
   $125 = $delimPos;
   $126 = $1;
   $127 = $125;
   $128 = $126;
   $129 = (($127) - ($128))|0;
   $130 = (($129|0) / 2)&-1;
   $131 = $count;
   $132 = $0;
   $133 = ((($132)) + 16|0);
   $134 = HEAP32[$133>>2]|0;
   $135 = (($134) + (($131*12)|0)|0);
   $136 = ((($135)) + 4|0);
   HEAP32[$136>>2] = $130;
   $137 = HEAP32[$paramPos>>2]|0;
   $138 = ($137|0)!=(0|0);
   if ($138) {
    $139 = HEAP32[$paramPos>>2]|0;
    $140 = (_qspSkipSpaces($139)|0);
    $141 = $1;
    $142 = $140;
    $143 = $141;
    $144 = (($142) - ($143))|0;
    $145 = (($144|0) / 2)&-1;
    $146 = $count;
    $147 = $0;
    $148 = ((($147)) + 16|0);
    $149 = HEAP32[$148>>2]|0;
    $150 = (($149) + (($146*12)|0)|0);
    $151 = ((($150)) + 8|0);
    HEAP32[$151>>2] = $145;
   } else {
    $152 = $buf;
    $153 = $1;
    $154 = $152;
    $155 = $153;
    $156 = (($154) - ($155))|0;
    $157 = (($156|0) / 2)&-1;
    $158 = $count;
    $159 = $0;
    $160 = ((($159)) + 16|0);
    $161 = HEAP32[$160>>2]|0;
    $162 = (($161) + (($158*12)|0)|0);
    $163 = ((($162)) + 8|0);
    HEAP32[$163>>2] = $157;
   }
   $164 = $count;
   $165 = (($164) + 1)|0;
   $count = $165;
   $166 = $nextPos;
   $167 = (_qspSkipSpaces($166)|0);
   $buf = $167;
   HEAP32[$paramPos>>2] = 0;
   $168 = $buf;
   $169 = (_qspGetStatCode($168,$paramPos)|0);
   $statCode = $169;
   $170 = $buf;
   $171 = HEAP16[$170>>1]|0;
   $172 = $171&65535;
   $173 = ($172|0)!=(0);
   $174 = $statCode;
   $175 = ($174|0)!=(2);
   $or$cond3 = $173 & $175;
   if (!($or$cond3)) {
    $delimPos = 0;
    continue;
   }
   $176 = $statCode;
   switch ($176|0) {
   case 7: case 6: case 4: case 3:  {
    $177 = $buf;
    $178 = (_qspStrPos($177,446296,0)|0);
    $delimPos = $178;
    $179 = $delimPos;
    $180 = ($179|0)!=(0|0);
    if (!($180)) {
     continue L31;
    }
    $181 = $delimPos;
    $182 = ((($181)) + 2|0);
    $nextPos = $182;
    $183 = $nextPos;
    $184 = HEAP16[$183>>1]|0;
    $185 = ($184<<16>>16)!=(0);
    if ($185) {
     continue L31;
    }
    $isInLoop = 0;
    continue L31;
    break;
   }
   case 8:  {
    $186 = HEAP32[$paramPos>>2]|0;
    $187 = (_qspSkipSpaces($186)|0);
    $nextPos = $187;
    $188 = $nextPos;
    $189 = HEAP16[$188>>1]|0;
    $190 = $189&65535;
    $191 = HEAP16[446296>>1]|0;
    $192 = $191&65535;
    $193 = ($190|0)==($192|0);
    if ($193) {
     $194 = $nextPos;
     $195 = ((($194)) + 2|0);
     $nextPos = $195;
    }
    $196 = $nextPos;
    $197 = HEAP16[$196>>1]|0;
    $198 = $197&65535;
    $199 = ($198|0)!=(0);
    $200 = $nextPos;
    $201 = $199 ? $200 : 0;
    $delimPos = $201;
    continue L31;
    break;
   }
   default: {
    $202 = $buf;
    $203 = (_qspStrPos($202,446300,0)|0);
    $delimPos = $203;
    $204 = $delimPos;
    $205 = ($204|0)!=(0|0);
    if ($205) {
     $206 = $delimPos;
     $207 = ((($206)) + 2|0);
     $nextPos = $207;
    }
    $208 = $elsePos;
    $209 = ($208|0)!=(0|0);
    if ($209) {
     $210 = $buf;
     $211 = $elsePos;
     $212 = ($210>>>0)>=($211>>>0);
     if ($212) {
      $elsePos = 0;
     }
    }
    $213 = $elsePos;
    $214 = ($213|0)==(0|0);
    $215 = $isSearchElse;
    $216 = ($215|0)!=(0);
    $or$cond5 = $214 & $216;
    do {
     if ($or$cond5) {
      $217 = $uStr;
      $218 = $buf;
      $219 = $1;
      $220 = $218;
      $221 = $219;
      $222 = (($220) - ($221))|0;
      $223 = (($222|0) / 2)&-1;
      $224 = (($217) + ($223<<1)|0);
      $225 = (_qspStrPos($224,445510,1)|0);
      $elsePos = $225;
      $226 = $elsePos;
      $227 = ($226|0)!=(0|0);
      if ($227) {
       $228 = $1;
       $229 = $elsePos;
       $230 = $uStr;
       $231 = $229;
       $232 = $230;
       $233 = (($231) - ($232))|0;
       $234 = (($233|0) / 2)&-1;
       $235 = (($228) + ($234<<1)|0);
       $elsePos = $235;
       break;
      } else {
       $isSearchElse = 0;
       break;
      }
     }
    } while(0);
    $236 = $elsePos;
    $237 = ($236|0)!=(0|0);
    do {
     if ($237) {
      $238 = $delimPos;
      $239 = ($238|0)!=(0|0);
      if ($239) {
       $240 = $elsePos;
       $241 = $delimPos;
       $242 = ($240>>>0)<($241>>>0);
       if (!($242)) {
        break;
       }
      }
      $243 = $elsePos;
      $delimPos = $243;
      $nextPos = $243;
      $elsePos = 0;
     }
    } while(0);
    $244 = $statCode;
    $245 = ($244|0)==(0);
    if (!($245)) {
     continue L31;
    }
    $246 = $buf;
    $247 = $delimPos;
    $248 = ($246|0)!=($247|0);
    if (!($248)) {
     continue L31;
    }
    $249 = $delimPos;
    $250 = ($249|0)!=(0|0);
    if ($250) {
     $251 = $delimPos;
     $252 = HEAP16[$251>>1]|0;
     $ch = $252;
     $253 = $delimPos;
     HEAP16[$253>>1] = 0;
     $254 = $buf;
     $255 = (_qspStrPos($254,446304,0)|0);
     $temp = $255;
     $256 = $ch;
     $257 = $delimPos;
     HEAP16[$257>>1] = $256;
    } else {
     $258 = $buf;
     $259 = (_qspStrPos($258,446304,0)|0);
     $temp = $259;
    }
    $260 = $temp;
    $261 = ($260|0)!=(0|0);
    $262 = $261 ? 46 : 34;
    $statCode = $262;
    continue L31;
   }
   }
  }
  $263 = $uStr;
  _free($263);
 }
 $264 = $count;
 $265 = ($264|0)==(1);
 $266 = $delimPos;
 $267 = ($266|0)!=(0|0);
 $or$cond7 = $265 & $267;
 if ($or$cond7) {
  $268 = $0;
  $269 = ((($268)) + 16|0);
  $270 = HEAP32[$269>>2]|0;
  $271 = HEAP32[$270>>2]|0;
  $272 = ($271|0)==(8);
  $273 = $statCode;
  $274 = ($273|0)==(6);
  $or$cond9 = $272 & $274;
  if ($or$cond9) {
   $275 = $1;
   $276 = $0;
   $277 = ((($276)) + 16|0);
   $278 = HEAP32[$277>>2]|0;
   $279 = ((($278)) + 8|0);
   $280 = HEAP32[$279>>2]|0;
   $281 = (($275) + ($280<<1)|0);
   $282 = HEAP16[$281>>1]|0;
   $283 = $282&65535;
   $284 = HEAP16[446296>>1]|0;
   $285 = $284&65535;
   $286 = ($283|0)!=($285|0);
   if ($286) {
    $coun