/* Функции скина для игры */
var skinHandler;

function qspSkinOnInitApi() {
    skinHandler = new NewsashSkinHentai();
    skinHandler.redraw();
}

function qspSkinOnUpdateSkin() {
    skinHandler.redraw();
}

function qspSkinOnCenter() {
    skinHandler.redraw();
}

///**********NEWsash skin hentai************/

// Что может произойти:
// 1. Изменилось расположение окон -> redraw
// 2. Изменились параметры -> refreshParams (пусть оно вызывается автором), redraw
// 3. Изменились размеры окна -> ??? redraw

//********************TODO********************
// Поправить стили диалоговых окон
// Почистить лишние стили
// Придумать, как вызывать системное меню
// Проверить устойчивость при изменении параметров "на лету"

//var skinParams = {
//    //Поддерживаемые имена: Main, Objs, Acts, Vars, Input, View
//    //При использовании View нужно установить в игре ALWAYS_SHOW_VIEW = 1
//    layout: 'Main Objs | Acts Vars | Input',
//    layoutHorizontal : true,
//    sizes : {
//        lines : '70% 30% 30px',
//        inLines : '80% 20% | 70% 30% | 100%'
//    },
//    window: {
//        width : 800,
//        height : 600
//    },
//    // Тип шаблона: simple, resizable, scalable - работает пока только simple
//    type : 'simple'  
//    //victim : 'Main'   //Обойдёмся без жертв
//}


var NewsashSkinHentai = function () {

    var layout, layoutHorizontal, lineSizes, sizes,
        lineSizesTotal, sizesTotal, linesVisibility, visibility,
        type, windowHeight, windowWidth,
        handler, viewClassCenterBeen;
    var n = 0;
    refreshParams();
    refreshSizesTotal();
    switch (type) {
        case 'resizable': handler = skinSetResizable(); handler.onResize(redraw); break;
        case 'scalable': handler = skinSetScalable(); break;
        default: break;
    }
    //redraw();

    function getElement(name) {
        if (name == 'Main') { return $('#qsp-wrapper-main'); }
        if (name == 'Acts') { return $('#qsp-wrapper-acts'); }
        if (name == 'Objs') { return $('#qsp-wrapper-objs'); }
        if (name == 'Vars') { return $('#qsp-wrapper-vars'); }
        if (name == 'View') { return $('#qsp-dialog-view-image-container'); } //#qsp-dialog-view-image-container #qsp-dialog-view
        if (name == 'Input') { return $('#qsp-input-line'); }
        return null;
    }

    function refreshParams() {
        //layout
        var lines = skinParams.layout.split(' | ');
        layout = [];
        for (var i = 0; i < lines.length; i++) {
            layout[i] = [];
            layout[i] = lines[i].split(' ');
        }
        layoutHorizontal = skinParams.layoutHorizontal;

        //lineSizes
        var items = skinParams.sizes.lines.split(' ');
        lineSizes = [];
        for (var i = 0; i < layout.length; i++) {
            lineSizes[i] = {
                size: parseFloat(items[i]),
                type: 'px'
            }
            if (items[i].indexOf('%') + 1) {
                lineSizes[i].type = '%';
            }
        }

        //sizes
        var lines = skinParams.sizes.inLines.split(' | ');
        sizes = [];
        for (var i = 0; i < lines.length; i++) {
            sizes[i] = [];
            var items = lines[i].split(' ');
            for (var j = 0; j < items.length; j++) {
                sizes[i][j] = {
                    size: parseFloat(items[j]),
                    type: 'px'
                }
                if (items[j].indexOf('%') + 1) {
                    sizes[i][j].type = '%';
                }
            }
        }

        //View
        if (skinParams.layout.indexOf('View') + 1) {
            if ($('#qsp-dialog-view-image-container').hasClass('qsp-center')) {
                viewClassCenterBeen = true;
                $('#qsp-dialog-view-image-container').removeClass('qsp-center').addClass('skin-view-inlined');
            }
        } else if (viewClassCenterBeen) {
            $('#qsp-dialog-view-image-container').removeClass('skin-view-inlined').addClass('qsp-center');
        }

        //Type
        type = skinParams.type;

        //Borders
        $('.border-left, .border-right, .border-top, .border-bottom').remove();
        for (var i = 0; i < layout.length; i++) {
            for (var j = 0; j < layout[i].length; j++) {
                var $elem = getElement(layout[i][j]);
                if (type != 'resizable') {
                    $elem.append($('<div class="border-left"/>'));
                    $elem.append($('<div class="border-right"/>'));
                    $elem.append($('<div class="border-top"/>'));
                    $elem.append($('<div class="border-bottom"/>'));
                }
            }
        }

        windowHeight = skinParams.window.height;
        windowWidth = skinParams.window.width;
    } //refreshParams

    function sizeTotal(line, visibility) {
        var result = {
            px: 0,
            percent: 0
        }
        for (var i = 0; i < line.length; i++) {
            if (!visibility[i]) continue;
            switch (line[i].type) {
                case 'px': result.px += line[i].size; break;
                case '%': result.percent += line[i].size; break;
                default: break;
            }
        }
        return result;
    } //sizeTotal

    function refreshSizesTotal() {
        if (type != 'scalable') {
            windowHeight = $(window).height();
            windowWidth = $(window).width();
            $('#skin-scaler').css({ width: windowWidth, height: windowHeight });
        }
        linesVisibility = [];
        visibility = [];
        for (var i = 0; i < layout.length; i++) {
            visibility[i] = [];
            linesVisibility[i] = false;
            for (var j = 0; j < layout[i].length; j++) {
                visibility[i][j] = getElement(layout[i][j]).is(':visible');
                if (visibility[i][j]) { linesVisibility[i] = true; }
            }
        }
        lineSizesTotal = sizeTotal(lineSizes, linesVisibility);
        sizesTotal = [];
        for (var i = 0; i < layout.length; i++) {
            sizesTotal[i] = sizeTotal(sizes[i], visibility[i]);
        }
    } //refreshSizesTotal

    function redraw() {
        if (type == 'scalable') {
            handler.refresh();
        }

        refreshSizesTotal();

        if ((windowHeight < 50) || (windowWidth < 50)) { return; } //Защита от схлопывания

        var totalLinesSize = (layoutHorizontal) ? windowHeight : windowWidth;
        var totalLineSize = (layoutHorizontal) ? windowWidth : windowHeight;
        var sumLine = 0;
        //$('#qsp-inv').empty().append('Tesing');
        //        $('#qsp-inv').append('<br/>' + $(window).height() + ' ' + $(window).width());
        //        $('#qsp-inv').append('<br/>' + $(document).height() + ' ' + $(document).width());
        //        $('#qsp-inv').append('<br/>' + $(document.body).height() + ' ' + $(document.body).width());
        //        $('#qsp-inv').append('<br/>' + $(document.body).height() + ' ' + $(document.body).width());
        for (var i = 0; i < layout.length; i++) {
            if (!linesVisibility[i]) continue;
            var linesize = 0;
            switch (lineSizes[i].type) {
                case 'px': linesize = lineSizes[i].size; break;
                case '%': linesize = (totalLinesSize - lineSizesTotal.px) * (lineSizes[i].size / lineSizesTotal.percent);
                default: break;
            }
            //$('#qsp-main').append('<br/>' + linesize + ' ' + lineSizes[i].size + ' ' + lineSizesTotal.percent);
            var sumInLine = 0;
            for (var j = 0; j < layout[i].length; j++) {
                if (!visibility[i][j]) continue;
                var size = 0;
                switch (sizes[i][j].type) {
                    case 'px': size = sizes[i][j].size; break;
                    case '%': size = (totalLineSize - sizesTotal[i].px) * (sizes[i][j].size / sizesTotal[i].percent);
                    default: break;
                }
                getElement(layout[i][j]).css({
                    width: (layoutHorizontal) ? size - 1 + 'px' : linesize - 1 + 'px',
                    height: (layoutHorizontal) ? linesize - 1 + 'px' : size - 1 + 'px',
                    left: (layoutHorizontal) ? sumInLine + 'px' : sumLine + 'px',
                    top: (layoutHorizontal) ? sumLine + 'px' : sumInLine + 'px'
                });
                sumInLine += size;
            }
            sumLine += linesize;
        }

        if (type == 'resizable') {
            handler.refresh();
        }
    } //redraw

    function skinSetResizable() {

        var RESIZE = {
            BOTTOM: 1,
            RIGHT: 2,
            TOP: 4,
            LEFT: 8,
            ALL: 15,
            NONE: 0
        }

        var ResizableElement = function (options) {
            this.name = options.name;
            this.flags = options.flags;
            var resizers;
            var $elem = getElement(this.name);
            var name = this.name;
            var onResize;

            resizers = addResizers();
            resizersVisibility(this.flags);

            $(document).on("mouseup", OnMouseup);

            function addResizers() {
                function addResizer(text) {
                    var $resizer = $('<div class="' + text + '-resize"/>');
                    $resizer.appendTo($elem);
                    $resizer.on("mousedown", OnMousedown);
                    return $resizer;
                }

                return {
                    bottom: addResizer('bottom'),
                    right: addResizer('right'),
                    top: addResizer('top'),
                    left: addResizer('left'),
                    bottomLeft: addResizer('bottom-left'),
                    bottomRight: addResizer('bottom-right'),
                    topLeft: addResizer('top-left'),
                    topRight: addResizer('top-right')
                }
            } //addResizers

            function resizersVisibility(flags) {
                this.flags = flags;

                if (flags & RESIZE.BOTTOM) { resizers.bottom.show(); } else { resizers.bottom.hide(); }
                if (flags & RESIZE.RIGHT) { resizers.right.show(); } else { resizers.right.hide(); }
                if (flags & RESIZE.TOP) { resizers.top.show(); } else { resizers.top.hide(); }
                if (flags & RESIZE.LEFT) { resizers.left.show(); } else { resizers.left.hide(); }

                if ((flags & RESIZE.BOTTOM) && (flags & RESIZE.LEFT))
                { resizers.bottomLeft.show(); } else { resizers.bottomLeft.hide(); }
                if ((flags & RESIZE.BOTTOM) && (flags & RESIZE.RIGHT))
                { resizers.bottomRight.show(); } else { resizers.bottomRight.hide(); }
                if ((flags & RESIZE.TOP) && (flags & RESIZE.LEFT))
                { resizers.topLeft.show(); } else { resizers.topLeft.hide(); }
                if ((flags & RESIZE.TOP) && (flags & RESIZE.RIGHT))
                { resizers.topRight.show(); } else { resizers.topRight.hide(); }
            } //resizersVisibility

            function OnMousedown(e) {
                var targetMouseDown = $(e.target);
                $(document).on("mousemove", { targetMouseDown: targetMouseDown }, OnMousemove);
                return false;
            }

            function OnMousemove(e) {
                var $tDown = e.data.targetMouseDown;

                if ($tDown.hasClass("bottom-resize")) { resizeElem(e, RESIZE.BOTTOM); }
                else if ($tDown.hasClass("top-resize")) { resizeElem(e, RESIZE.TOP); }
                else if ($tDown.hasClass("right-resize")) { resizeElem(e, RESIZE.RIGHT); }
                else if ($tDown.hasClass("left-resize")) { resizeElem(e, RESIZE.LEFT); }
                else if ($tDown.hasClass("bottom-right-resize")) { resizeElem(e, RESIZE.BOTTOM); resizeElem(e, RESIZE.RIGHT); }
                else if ($tDown.hasClass("bottom-left-resize")) { resizeElem(e, RESIZE.BOTTOM); resizeElem(e, RESIZE.LEFT); }
                else if ($tDown.hasClass("top-right-resize")) { resizeElem(e, RESIZE.TOP); resizeElem(e, RESIZE.RIGHT); }
                else if ($tDown.hasClass("top-left-resize")) { resizeElem(e, RESIZE.TOP); resizeElem(e, RESIZE.LEFT); }

                if (typeof (onResize) == 'function') {
                    //$('#qsp-inv').empty().append('1 '+n);
                    onResize();
                }

            }

            function OnMouseup(e) {
                $(document).off("mousemove"); // С этой строчкой могут быть проблемы... А могут и не быть :)
            }

            function resizeElem(e, type) {
                refreshSizesTotal();
                var i, j;
                for (k = 0; k < layout.length; k++) {
                    for (l = 0; l < layout[k].length; l++) {
                        if (layout[k][l] == name) {
                            i = k; j = l;
                        }
                    }
                }

                var newHeight = 0,
                    newWidth = 0;
                switch (type) {
                    case RESIZE.BOTTOM: newHeight = e.pageY - $elem.offset().top; break;
                    case RESIZE.TOP: newHeight = $elem.position().top + $elem.height() - e.pageY; break;
                    case RESIZE.LEFT: newWidth = $elem.offset().left + $elem.width() - e.pageX; break;
                    case RESIZE.RIGHT: newWidth = e.pageX - $elem.offset().left; break;
                    default: break;
                }

                var totalLinesSize = (layoutHorizontal) ? windowHeight : windowWidth;
                var totalLineSize = (layoutHorizontal) ? windowWidth : windowHeight;

                switch (type) {
                    case RESIZE.BOTTOM:
                    case RESIZE.TOP:
                        if (layoutHorizontal) {
                            switch (lineSizes[i].type) {
                                case 'px': lineSizes[i].size = newHeight; break;
                                case '%': lineSizes[i].size = newHeight / (totalLinesSize - lineSizesTotal.px - newHeight) * (lineSizesTotal.percent - lineSizes[i].size);
                                default: break;
                            }
                        } else {
                            switch (sizes[i][j].type) {
                                case 'px': sizes[i][j].size = newHeight; break;
                                case '%': sizes[i][j].size = newHeight / (totalLineSize - sizesTotal[i].px - newHeight) * (sizesTotal[i].percent - sizes[i][j].size);
                                default: break;
                            }
                        }
                        break;
                    case RESIZE.LEFT:
                    case RESIZE.RIGHT:
                        if (layoutHorizontal) {
                            switch (sizes[i][j].type) {
                                case 'px': sizes[i][j].size = newWidth; break;
                                case '%': sizes[i][j].size = newWidth / (totalLineSize - sizesTotal[i].px - newWidth) * (sizesTotal[i].percent - sizes[i][j].size);
                                default: break;
                            }
                        } else {
                            switch (lineSizes[i].type) {
                                case 'px': lineSizes[i].size = newWidth; break;
                                case '%': lineSizes[i].size = newWidth / (totalLinesSize - lineSizesTotal.px - newWidth) * (lineSizesTotal.percent - lineSizes[i].size);
                                default: break;
                            }
                        }
                        break;
                    //меняем ширину          
                    default: break;
                }
            } //resizeElem

            this.changeResizers = resizersVisibility;

            this.onResize = function (func) {
                onResize = func;
            };
        } //ResizableElement
        var newResizer;
        var resizers = [];
        for (var i = 0; i < layout.length; i++) {
            resizers[i] = [];
            for (var j = 0; j < layout[i].length; j++) {
                resizers[i][j] = {
                    name: layout[i][j],
                    resizer: new ResizableElement({ name: layout[i][j], flags: 15 })
                }
            }
        }

        function resizer(name) {
            for (var i = 0; i < resizers.length; i++) {
                for (var j = 0; j < resizers[i].length; j++) {
                    if (resizers[i][j].name == name) {
                        return resizers[i][j].resizer;
                    }
                }
            }
            resizers[0][resizers[0].length] = {
                name: layout[i][j],
                resizer: new ResizableElement({ name: layout[i][j], flags: 15 })
            };
            return resizers[0][resizers[0].length - 1].resizer;
        }

        function refreshAllResizers() {
            var flags;
            for (var i = 0; i < resizers.length; i++) {
                for (var j = 0; j < resizers[i].length; j++) {
                    resizers[i][j].resizer.changeResizers(RESIZE.NONE);
                }
            }
            for (var i = 0; i < layout.length; i++) {
                for (var j = 0; j < layout[i].length; j++) {
                    flags = RESIZE.NONE;
                    if (!visibility[i][j]) continue;
                    for (var i2 = 0; i2 < layout.length; i2++) {
                        if ((i > i2) && (linesVisibility[i2])) {
                            flags |= RESIZE.TOP;
                        }
                        if ((i < i2) && (linesVisibility[i2])) {
                            flags |= RESIZE.BOTTOM;
                            break;
                        }
                    }
                    for (var j2 = 0; j2 < layout[i].length; j2++) {
                        if ((j > j2) && (visibility[i][j2])) {
                            flags |= RESIZE.LEFT;
                        }
                        if ((j < j2) && (visibility[i][j2])) {
                            flags |= RESIZE.RIGHT;
                            break;
                        }
                    }
                    resizer(layout[i][j]).changeResizers(flags);
                }
            }
        } //refreshAllResizers

        var onResize = function (func) {
            for (var i = 0; i < resizers.length; i++) {
                for (var j = 0; j < resizers[i].length; j++) {
                    resizers[i][j].resizer.onResize(func);
                }
            }
        }

        return {
            onResize: onResize,
            refresh: refreshAllResizers
        }
    } //skinSetResizable

    function skinSetScalable() {
        function skinScale() {
            var scaleW = $(window).width() / windowWidth;
            var scaleH = $(window).height() / windowHeight;
            var scale = Math.min( scaleW, scaleH );

            $('#skin-scaler').css({
                width: windowWidth,
                height: windowHeight
            });

            if (true) {

                $('#skin-scaler').css({
                    transform: "scale(" + scale + ")",
                    left: -windowWidth * (1 - scaleW) / 2 + 'px',
                    top: -windowHeight * (1 - scaleH)/2+'px'
                });

                $('body').css({
                    width: $(window).width(),
                    height: $(window).height()
                })
                //window.resizeTo( scale*skinObj.widthWindow , scale*skinObj.heightWindow );
            }
        }
        return {
            refresh: skinScale
        }
    } //skinSetScalable

    this.refreshParams = refreshParams;
    this.redraw = redraw;
} //NewsashSkinHentai